package com.huigou.bpm.management.application;

import com.huigou.bpm.management.domain.model.ProcInst;
import com.huigou.bpm.management.domain.query.ProcInstQueryRequest;
import org.springframework.data.domain.Page;

import java.util.Map;

/**
 * @author yonghuan
 */
public interface ProcInstApplication {

    Page<Map<String, Object>> sliceQuery(ProcInstQueryRequest queryRequest);

    ProcInst findById(String id);

    /**
     * 获取流程实例的mxgraph xml
     *
     * @param id 流程实例id
     * @return 流程实例的mxgraph xml
     */
    String findProcInstXml(String id);

    ProcInst findByBizKey(String bizKey);
}
