package com.huigou.bpm.engine.repository;

import com.huigou.bpm.engine.domain.model.BizTask;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author yonghuan
 */
public interface BizTaskRepository extends JpaRepository<BizTask, String> {

    /**
     * 根据流程实例id和业务节点code查询流程实例信息
     *
     * @param procInstId  流程实例id
     * @param serviceCode 业务节点code
     * @return 流程实例信息
     */
    BizTask findByProcInstIdAndServiceCode(String procInstId, String serviceCode);


    @Query("select count(*) from BizTask task where task.status <> 3 and task.limitDate is not null and task.limitDate<current_date and task.timeoutCheck=true")
    long countTimeoutCheckTask();


    @Query("from BizTask where status <> 3 and limitDate is not null and limitDate<current_date and timeoutCheck=true")
    List<BizTask> findTimeoutCheckTasks();

}
