package com.huigou.bpm.engine.processor.workflow;

import com.alibaba.fastjson.JSONObject;
import com.huigou.context.Operator;
import com.huigou.context.ThreadLocalUtil;
import com.huigou.uasp.bmp.operator.OperatorApplication;
import com.huigou.uasp.bpm.ProcessAction;
import com.huigou.uasp.bpm.ProcessStartModel;
import com.huigou.uasp.bpm.engine.application.WorkflowApplication;
import com.huigou.util.Constants;
import com.huigou.util.SDO;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 启动工作流
 *
 * @author yonghuan
 */
@Service
public class StartWorkflowProcessor implements Processor {

    private WorkflowApplication workflowApplication;
    private OperatorApplication operatorApplication;

    @Autowired
    public void setWorkflowApplication(WorkflowApplication workflowApplication) {
        this.workflowApplication = workflowApplication;
    }

    @Autowired
    public void setOperatorApplication(OperatorApplication operatorApplication) {
        this.operatorApplication = operatorApplication;
    }

    @Transactional
    @Override
    public void process(Exchange exchange) throws Exception {
        Message msg = exchange.getMessage();
        String textMsg = msg.getBody(String.class);
        JSONObject request = JSONObject.parseObject(textMsg);
        // 请求头
        JSONObject headers = request.getJSONObject("headers");
        // 认证信息
        String authentication = headers.getString("Authentication");
        String str = authentication.split("\\W")[1];
        String[] usernameAndPassword = new String(Base64.getDecoder().decode(str)).split(":");

        Operator operator = operatorApplication.createOperatorByLoginName(usernameAndPassword[0]);
        JSONObject bizData = request.getJSONObject("bizData");
        String processDefinitionKey = bizData.getString("processDefinitionKey");
        Assert.hasText(processDefinitionKey, "processDefinitionKey为空，无法启动工作流");
        String bizId = bizData.getString("bizId");
        Assert.hasText(bizId, "bizId为空，无法启动工作流");
        String bizCode = bizData.getString("bizCode");
        SDO localSdo = new SDO();
        // 将业务数据传递给工作流
        bizData.forEach(localSdo::putProperty);
        localSdo.putProperty("processAction", ProcessAction.SAVE);
        localSdo.putProperty("procUnitId", "");
        localSdo.putProperty("bizId", bizId);
        localSdo.putProperty("fillinDate", new Date());
        localSdo.putProperty("billCode", bizCode);
        localSdo.putProperty("personMemberName", operator.getPersonMemberName());
        ThreadLocalUtil.putVariable(Constants.SDO, localSdo);
        Map<String, Object> variables = new HashMap<>();
        // 模拟人工启动工作流
        variables.put("startModel", ProcessStartModel.MANUAL.id);
        variables.put("executorFullId", operator.getFullId());
        variables.put("executorFullName", operator.getFullName());
        ThreadLocalUtil.putOperator(operator);
        workflowApplication.startProcessInstanceByKey(processDefinitionKey, bizId, variables);
    }
}
