package com.huigou.bpm.engine.processor;

import com.huigou.bpm.engine.application.BusinessProcessApplication;
import com.huigou.bpm.engine.domain.InMessage;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.el.Expression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Map;

/**
 * @author yonghuan
 */
@Service
public class StartTaskProcessor extends AbstractBusinessProcessor implements ExecutionListener {

    private BusinessProcessApplication businessProcessApplication;
    /**
     * bpm流程定义key
     */
    private Expression procdefCode;
    private Expression bizKey;

    @Autowired
    public void setBusinessProcessApplication(BusinessProcessApplication businessProcessApplication) {
        this.businessProcessApplication = businessProcessApplication;
    }

    public void setProcdefCode(Expression procdefCode) {
        this.procdefCode = procdefCode;
    }

    public void setBizKey(Expression bizKey) {
        this.bizKey = bizKey;
    }

    @Override
    protected Map<String, Object> processInternal(InMessage msg) {
        businessProcessApplication.startTask(msg.getProcdefCode(), msg.getBizKey(), msg.getServiceCode(), msg.getBizData());
        return Collections.emptyMap();
    }

    @Transactional
    @Override
    public void notify(DelegateExecution delegateExecution) throws Exception {
        // 获取bpm流程定义key
        String processDefinitionKey = (String) procdefCode.getValue(delegateExecution);
        String bizId = (String) bizKey.getValue(delegateExecution);
        // TODO bizData获取规则待优化
        businessProcessApplication.startTask(processDefinitionKey, bizId, delegateExecution.getProcessDefinitionId().split(":")[0], Collections.emptyMap());
    }
}
