package com.huigou.bpm.engine.processor;

import com.huigou.bpm.engine.application.BusinessProcessApplication;
import com.huigou.bpm.engine.domain.InMessage;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.el.Expression;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 处理启动BPM流程请求。
 *
 * @author yonghuan
 */
@Service
public class StartProcessProcessor extends AbstractBusinessProcessor implements ExecutionListener {

    private BusinessProcessApplication businessProcessApplication;
    private RepositoryService repositoryService;

    /**
     * bpm流程定义key
     */
    private Expression procdefCode;
    private Expression bizKey;


    @Autowired
    public void setBusinessProcessApplication(BusinessProcessApplication businessProcessApplication) {
        this.businessProcessApplication = businessProcessApplication;
    }

    @Autowired
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setProcdefCode(Expression procdefCode) {
        this.procdefCode = procdefCode;
    }

    public void setBizKey(Expression bizKey) {
        this.bizKey = bizKey;
    }

    @Override
    protected Map<String, Object> processInternal(InMessage inMessage) {
        ProcessInstance pi = businessProcessApplication.startProcessByCode(inMessage.getProcdefCode(), inMessage.getBizKey(), inMessage.getName(), inMessage.getDescription(), inMessage.getBizData());
        Map<String, Object> result = new HashMap<>(1);
        result.put("procInstId", pi.getId());
        return result;
    }

    @Transactional
    @Override
    public void notify(DelegateExecution delegateExecution) throws Exception {
        // 获取bpm流程定义key
        String processDefinitionKey = (String) procdefCode.getValue(delegateExecution);
        String bizId = (String) bizKey.getValue(delegateExecution);
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey)
                .latestVersion()
                .singleResult();
        Assert.notNull(processDefinition, String.format("流程定义 %s 不存在", processDefinitionKey));
        // TODO bizData获取规则待优化
        businessProcessApplication.startProcessByCode(processDefinitionKey, bizId, processDefinition.getName(), processDefinition.getDescription(), Collections.emptyMap());
    }
}
