package com.huigou.bpm.engine.controller;

import com.huigou.bpm.engine.application.BusinessProcessApplication;
import com.huigou.bpm.engine.domain.InMessage;
import com.huigou.uasp.client.CommonController;
import org.activiti.engine.runtime.ProcessInstance;

/**
 * 业务流程控制器
 *
 * @author yonghuan
 */
public class BusinessProcessController extends CommonController {

    private final BusinessProcessApplication businessProcessApplication;

    public BusinessProcessController(BusinessProcessApplication businessProcessApplication) {
        this.businessProcessApplication = businessProcessApplication;
    }

    /**
     * 启动业务流程
     *
     * @return 业务流程实例id
     */
    public String startProcessByCode() {
        InMessage inMessage = getSDO().toObject(InMessage.class);
        ProcessInstance pi = businessProcessApplication.startProcessByCode(inMessage.getProcdefCode(), inMessage.getBizKey(), inMessage.getName(), inMessage.getDescription(), inMessage.getBizData());
        return pi.getId();
    }

    /**
     * 启动业务流程任务
     */
    public String startTask() {
        InMessage msg = getSDO().toObject(InMessage.class);
        businessProcessApplication.startTask(msg.getProcdefCode(), msg.getBizKey(), msg.getServiceCode(), msg.getBizData());
        return NONE;
    }

    /**
     * 完成业务流程任务
     */
    public String completeTask() {
        InMessage msg = getSDO().toObject(InMessage.class);
        businessProcessApplication.completeTask(msg.getProcdefCode(), msg.getBizKey(), msg.getServiceCode(), msg.getBizData());
        return NONE;
    }
}
