package com.huigou.bpm.engine.application.impl;

import com.huigou.bpm.engine.application.BizTaskApplication;
import com.huigou.bpm.engine.domain.model.BizTask;
import com.huigou.bpm.engine.repository.BizTaskRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author yonghuan
 */
@Service
public class BizTaskApplicationImpl implements BizTaskApplication {

    private BizTaskRepository bizTaskRepository;

    @Autowired
    public void setBizTaskRepository(BizTaskRepository bizTaskRepository) {
        this.bizTaskRepository = bizTaskRepository;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public BizTask add(BizTask bizTask) {
        return bizTaskRepository.save(bizTask);
    }

    @Override
    public BizTask findByServiceCode(String procInstId, String serviceCode) {
        BizTask bizTask = bizTaskRepository.findByProcInstIdAndServiceCode(procInstId, serviceCode);

        if (bizTask != null && bizTask.getStartDate() != null) {
            Long duration;
            if (bizTask.getStatus().intValue() == BizTask.Status.END.id) {
                duration = bizTask.getEndDate().getTime() - bizTask.getStartDate().getTime();
            } else {
                duration = System.currentTimeMillis() - bizTask.getStartDate().getTime();
            }
            bizTask.setDuration(duration);
        }
        return bizTask;
    }
}
