package com.huigou.bpm.engine.application;

import org.activiti.engine.runtime.ProcessInstance;

import java.util.Map;

/**
 * @author yonghuan
 * @since 1.1.3
 */
public interface BusinessProcessApplication {

    /**
     * 根据流程定义的code来启动流程。
     *
     * @param code        流程定义code
     * @param bizKey      业务key
     * @param name        流程实例的名称
     * @param description 流程实例的描述信息
     * @param bizData     业务参数
     * @return 流程实例
     */
    ProcessInstance startProcessByCode(String code, String bizKey, String name, String description, Map<String, Object> bizData);

    /**
     * 开始业务任务
     *
     * @param code        流程定义code
     * @param bizKey      业务key
     * @param serviceCode 业务服务code
     * @param bizData     业务参数
     */
    void startTask(String code, String bizKey, String serviceCode, Map<String, Object> bizData);

    /**
     * 完成业务任务
     *
     * @param code        流程定义code
     * @param bizKey      业务key
     * @param serviceCode 业务服务code
     * @param bizData     业务参数
     */
    void completeTask(String code, String bizKey, String serviceCode, Map<String, Object> bizData);

}
