
SET FOREIGN_KEY_CHECKS = 0;
DROP TABLE
IF
	EXISTS `tmp_sa_i18nproperties`;
CREATE TABLE tmp_sa_i18nproperties (
tmp_id VARCHAR ( 32 ) NOT NULL,
batch_number VARCHAR ( 64 ),
STATUS VARCHAR ( 64 ),
message VARCHAR ( 512 ),
CODE VARCHAR ( 128 ),
value1 VARCHAR ( 512 ),
value2 VARCHAR ( 512 ),
value3 VARCHAR ( 512 ),
value4 VARCHAR ( 512 ),
value5 VARCHAR ( 512 )
);-- ----------------------------
-- Table structure for act_ge_bytearray
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ge_bytearray`;
CREATE TABLE `act_ge_bytearray` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
`NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DEPLOYMENT_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BYTES_` LONGBLOB NULL,
`GENERATED_` SMALLINT ( 1 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE,
INDEX `ACT_IDX_BYTEAR_DEPL` ( `DEPLOYMENT_ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ge_property
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ge_property`;
CREATE TABLE `act_ge_property` (
`NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`VALUE_` VARCHAR ( 1200 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `NAME_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of act_ge_property
-- ----------------------------
INSERT INTO `act_ge_property`
VALUES
	( 'next.dbid', '969881', 27871 );
INSERT INTO `act_ge_property`
VALUES
	( 'schema.history', 'create(5.14)', 1 );
INSERT INTO `act_ge_property`
VALUES
	( 'schema.version', '5.21.0.0', 1 );-- ----------------------------
-- Table structure for act_hi_actinst
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_actinst`;
CREATE TABLE `act_hi_actinst` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ACT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CALL_PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ACT_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ACT_TYPE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ASSIGNEE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`START_TIME_` datetime NULL,
`END_TIME_` datetime NULL DEFAULT NULL,
`DURATION_` BIGINT ( 20 ) NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE,
INDEX `ACT_IDX_HI_ACT_INST_END` ( `END_TIME_` ) USING BTREE,
INDEX `ACT_IDX_HI_ACT_INST_EXEC` ( `EXECUTION_ID_`, `ACT_ID_` ) USING BTREE,
INDEX `ACT_IDX_HI_ACT_INST_PROCINST` ( `PROC_INST_ID_`, `ACT_ID_` ) USING BTREE,
INDEX `ACT_IDX_HI_ACT_INST_START` ( `START_TIME_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_comment
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_comment`;
CREATE TABLE `act_hi_comment` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`TYPE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TIME_` datetime NULL,
`USER_ID_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ACTION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`MESSAGE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_MSG_` LONGBLOB NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_identitylink
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_identitylink`;
CREATE TABLE `act_hi_identitylink` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`GROUP_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TYPE_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`USER_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_procinst
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_procinst`;
CREATE TABLE `act_hi_procinst` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`BUSINESS_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`START_TIME_` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
`END_TIME_` datetime NOT NULL,
`DURATION_` INT ( 11 ) NULL DEFAULT NULL,
`START_USER_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`START_ACT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`END_ACT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUPER_PROCESS_INSTANCE_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DELETE_REASON_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci,
`NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_procinst_extension
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_procinst_extension`;
CREATE TABLE `act_hi_procinst_extension` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`BUSINESS_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_ORG_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_ORG_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_FULL_NAME_` VARCHAR ( 2048 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION_` BIGINT ( 20 ) NULL DEFAULT NULL,
`DESCRIPTION_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS_NAME_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`START_TIME_` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP ,
`END_TIME_` datetime NOT NULL,
`DURATION_` INT ( 11 ) NULL DEFAULT NULL,
`START_USER_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`START_ACT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`END_ACT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUPER_PROCESS_INSTANCE_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DELETE_REASON_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci,
`NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_taskinst
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_taskinst`;
CREATE TABLE `act_hi_taskinst` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_DEF_KEY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PARENT_TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DESCRIPTION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`OWNER_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ASSIGNEE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`START_TIME_` datetime  NULL,
`CLAIM_TIME_` datetime  NULL DEFAULT NULL,
`END_TIME_` datetime  NULL DEFAULT NULL,
`DURATION_` BIGINT ( 20 ) NULL DEFAULT NULL,
`DELETE_REASON_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`PRIORITY_` INT ( 11 ) NULL DEFAULT NULL,
`DUE_DATE_` datetime  NULL DEFAULT NULL,
`FORM_KEY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CATEGORY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE,
INDEX `IDX_HI_TASKINST_ET` ( `END_TIME_` ) USING BTREE,
INDEX `IX_HI_TASKINST_PIID` ( `PROC_INST_ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_taskinst_extension
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_taskinst_extension`;
CREATE TABLE `act_hi_taskinst_extension` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CATALOG_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`KIND_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_URL_` VARCHAR ( 512 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_URL_` VARCHAR ( 512 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_OGN_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_OGN_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_FULL_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`EXECUTOR_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_OGN_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_OGN_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_FULL_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS_NAME_` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_NAMES_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`OWNER_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_OGN_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_OGN_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_FULL_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`PREVIOUS_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_UNIT_HANDLER_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BUSINESS_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BUSINESS_CODE_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NEED_TIMING_` INT ( 11 ) NULL DEFAULT NULL,
`OPINION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`RESULT_` INT ( 11 ) NULL DEFAULT NULL,
`SLEEPED_DATE_` date NULL DEFAULT NULL,
`SIGN_PUNISH_` INT ( 11 ) NULL DEFAULT NULL,
`SIGN_NEED_TIMING_` INT ( 11 ) NULL DEFAULT NULL,
`VERSION_` BIGINT ( 20 ) NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`COOPERATION_MODEL_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LIMIT_TIME_` INT ( 11 ) NULL DEFAULT NULL,
`APPLICANT_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROCESS_DEFINITION_KEY_` VARCHAR ( 510 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_PERSON_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_PERSON_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_DEF_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PARENT_TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DESCRIPTION_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`START_TIME_` datetime  NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
`CLAIM_TIME_` datetime  NOT NULL,
`END_TIME_` datetime  NOT NULL,
`DURATION_` INT ( 11 ) NULL DEFAULT NULL,
`DELETE_REASON_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PRIORITY_` INT ( 11 ) NULL DEFAULT NULL,
`DUE_DATE_` datetime  NULL,
`FORM_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CATEGORY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci,
`GENERATE_REASON_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUB_PROC_UNIT_NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_taskinst_relation
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_taskinst_relation`;
CREATE TABLE `act_hi_taskinst_relation` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
`BUSINESS_KEY` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
`PROC_INST_ID` VARCHAR ( 36 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程实例ID',
`TASK_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '任务ID',
`RELATED_TASK_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关联任务ID',
`VERSION` DECIMAL ( 65, 30 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE,
INDEX `IDX_TASKINST_RELATION_BIZ_ID` ( `BUSINESS_KEY` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '任务关联' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_hi_varinst
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_hi_varinst`;
CREATE TABLE `act_hi_varinst` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`VAR_TYPE_` VARCHAR ( 400 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
`BYTEARRAY_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DOUBLE_` DECIMAL ( 22, 10 ) NULL DEFAULT NULL,
`LONG_` INT ( 11 ) NULL DEFAULT NULL,
`TEXT_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TEXT2_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATE_TIME_` datetime  NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
`LAST_UPDATED_TIME_` datetime ( 6 ) NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_re_deployment
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_re_deployment`;
CREATE TABLE `act_re_deployment` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CATEGORY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DEPLOY_TIME_` datetime  NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_re_procdef
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_re_procdef`;
CREATE TABLE `act_re_procdef` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` DECIMAL ( 65, 30 ) NULL DEFAULT NULL,
`CATEGORY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`KEY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`VERSION_` BIGINT ( 20 ) NOT NULL,
`DEPLOYMENT_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`RESOURCE_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DGRM_RESOURCE_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DESCRIPTION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`HAS_START_FORM_KEY_` TINYINT ( 1 ) NULL DEFAULT NULL,
`SUSPENSION_STATE_` INT ( 11 ) NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HAS_GRAPHICAL_NOTATION_` TINYINT ( 1 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_re_procdef_tree_del
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_re_procdef_tree_del`;
CREATE TABLE `act_re_procdef_tree_del` (
`RE_PROCDEF_TREE_ID` BIGINT ( 20 ) NOT NULL COMMENT '主键',
`CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`PATH` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`PARENT_ID` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '父节点ID',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`KEY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程KEY',
`APPROVAL_RULE_PROC_DEF_KEY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批规则流程ID',
`NODE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '节点类型 folder 文件夹 proc 流程 procUnit 流程环节',
`NEED_TIMING` INT ( 11 ) NULL DEFAULT NULL COMMENT '需要计时',
`APP_MODEL_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT 'APP模型ID',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`SHOW_QUERY_HANDLERS` INT ( 11 ) NULL DEFAULT NULL COMMENT '显示询问处理人对话框 1 是 0 否',
PRIMARY KEY ( `RE_PROCDEF_TREE_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '流程定义树' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_event_subscr
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_event_subscr`;
CREATE TABLE `act_ru_event_subscr` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
`EVENT_TYPE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`EVENT_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ACTIVITY_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CONFIGURATION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CREATED_` datetime  NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_execution
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_execution`;
CREATE TABLE `act_ru_execution` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BUSINESS_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PARENT_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUPER_EXEC_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ACT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`IS_ACTIVE_` TINYINT ( 1 ) NULL DEFAULT NULL,
`IS_CONCURRENT_` TINYINT ( 1 ) NULL DEFAULT NULL,
`IS_SCOPE_` TINYINT ( 1 ) NULL DEFAULT NULL,
`IS_EVENT_SCOPE_` TINYINT ( 1 ) NULL DEFAULT NULL,
`SUSPENSION_STATE_` BIGINT ( 20 ) NULL DEFAULT NULL,
`CACHED_ENT_STATE_` BIGINT ( 20 ) NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci,
`NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOCK_TIME_` datetime  NOT NULL DEFAULT CURRENT_TIMESTAMP,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_identitylink
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_identitylink`;
CREATE TABLE `act_ru_identitylink` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
`GROUP_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TYPE_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`USER_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_job
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_job`;
CREATE TABLE `act_ru_job` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` DECIMAL ( 65, 30 ) NULL DEFAULT NULL,
`TYPE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`LOCK_EXP_TIME_` datetime  NULL DEFAULT NULL,
`LOCK_OWNER_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`EXCLUSIVE_` DECIMAL ( 1, 0 ) NULL DEFAULT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROCESS_INSTANCE_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`RETRIES_` DECIMAL ( 65, 30 ) NULL DEFAULT NULL,
`EXCEPTION_STACK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXCEPTION_MSG_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DUEDATE_` datetime  NULL DEFAULT NULL,
`REPEAT_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`HANDLER_TYPE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`HANDLER_CFG_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE,
INDEX `ACT_IDX_JOB_EXCEPTION` ( `EXCEPTION_STACK_ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_task
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_task`;
CREATE TABLE `act_ru_task` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
`REV_` DECIMAL ( 65, 30 ) NULL DEFAULT NULL COMMENT '版本号',
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '执行实例ID',
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程实例ID',
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
`NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '节点定义名称',
`PARENT_TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点实例ID',
`DESCRIPTION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '节点定义描述',
`TASK_DEF_KEY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '节点定义的KEY',
`OWNER_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '实际签收人',
`ASSIGNEE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '签收人或委托人',
`DELEGATION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '委托类型',
`PRIORITY_` DECIMAL ( 65, 30 ) NULL DEFAULT NULL COMMENT '优先级别',
`CREATE_TIME_` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`DUE_DATE_` datetime  NULL DEFAULT NULL COMMENT '过期时间',
`SUSPENSION_STATE_` DECIMAL ( 65, 30 ) NULL DEFAULT NULL COMMENT '是否挂起',
`CATEGORY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FORM_KEY_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID_` ) USING BTREE,
INDEX `ACT_IDX_TASK_CREATE` ( `CREATE_TIME_` ) USING BTREE,
INDEX `ACT_IDX_TASK_EXEC` ( `EXECUTION_ID_` ) USING BTREE,
INDEX `ACT_IDX_TASK_PROCDEF` ( `PROC_DEF_ID_` ) USING BTREE,
INDEX `ACT_IDX_TASK_PROCINST` ( `PROC_INST_ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_task_extension
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_task_extension`;
CREATE TABLE `act_ru_task_extension` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CATALOG_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`KIND_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_URL_` VARCHAR ( 512 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_URL_` VARCHAR ( 512 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_OGN_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_OGN_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_FULL_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`EXECUTOR_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_OGN_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_OGN_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_FULL_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS_NAME_` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_NAMES_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`OWNER_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_POS_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_POS_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_DEPT_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_DEPT_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_OGN_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_OGN_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_FULL_ID_` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OWNER_FULL_NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`PREVIOUS_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_UNIT_HANDLER_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BUSINESS_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BUSINESS_CODE_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NEED_TIMING_` INT ( 11 ) NULL DEFAULT NULL,
`OPINION_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`RESULT_` BIGINT ( 20 ) NULL DEFAULT NULL,
`SLEEPED_DATE_` date NULL DEFAULT NULL,
`VERSION_` BIGINT ( 20 ) NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`COOPERATION_MODEL_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LIMIT_TIME_` INT ( 11 ) NULL DEFAULT NULL,
`APPLICANT_PERSON_MEMBER_ID_` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPLICANT_PERSON_MEMBER_NAME_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROCESS_DEFINITION_KEY_` VARCHAR ( 510 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATOR_PERSON_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTOR_PERSON_ID_` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_DEF_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PARENT_TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DESCRIPTION_` VARCHAR ( 2000 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_DEF_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DELEGATION_` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PRIORITY_` INT ( 11 ) NULL DEFAULT NULL,
`START_TIME_` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
`DUE_DATE_` datetime NOT NULL,
`SUSPENSION_STATE_` INT ( 11 ) NULL DEFAULT NULL,
`CATEGORY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TENANT_ID_` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FORM_KEY_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`GENERATE_REASON_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUB_PROC_UNIT_NAME_` VARCHAR ( 1020 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for act_ru_variable
-- ----------------------------
DROP TABLE
IF
	EXISTS `act_ru_variable`;
CREATE TABLE `act_ru_variable` (
`ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`REV_` BIGINT ( 20 ) NULL DEFAULT NULL,
`TYPE_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`NAME_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`EXECUTION_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_INST_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BYTEARRAY_ID_` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DOUBLE_` DECIMAL ( 10, 10 ) NULL DEFAULT NULL,
`LONG_` DECIMAL ( 19, 0 ) NULL DEFAULT NULL,
`TEXT_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TEXT2_` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID_` ) USING BTREE,
INDEX `ACT_IDX_VARIABLE_TASK_ID` ( `TASK_ID_` ) USING BTREE,
INDEX `ACT_IDX_VAR_BYTEARRAY` ( `BYTEARRAY_ID_` ) USING BTREE,
INDEX `ACT_IDX_VAR_EXE` ( `EXECUTION_ID_` ) USING BTREE,
INDEX `ACT_IDX_VAR_PROCINST` ( `PROC_INST_ID_` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for hibernate_sequences
-- ----------------------------
DROP TABLE
IF
	EXISTS `hibernate_sequences`;
CREATE TABLE `hibernate_sequences` (
`SEQUENCE_NAME` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`NEXT_VAL` BIGINT ( 65 ) NULL DEFAULT NULL,
PRIMARY KEY ( `SEQUENCE_NAME` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_applicationsystem
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_applicationsystem`;
CREATE TABLE `sa_applicationsystem` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CLASS_PREFIX` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_applicationsystem
-- ----------------------------
INSERT INTO `sa_applicationsystem`
VALUES
	( 'A6A3D854550B43F7B549B25292938597', 'Platform', '平台', 'com.huigou.uasp', 1, 252264 );-- ----------------------------
-- Table structure for sa_approval_rejected_reason
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_approval_rejected_reason`;
CREATE TABLE `sa_approval_rejected_reason` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类ID',
`CONTENT` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'content',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'sequence',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT 'status',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
`REJECTED_REASON_KIND` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批驳回理由维护' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_approval_rejected_reason
-- ----------------------------
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '4C22EEC795A84E18A852FD7612A5A149', '50', '缺：项目负责人签字/会议负责人签字', NULL, 0, 267347, NULL );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5A23A0D678A44A70864EF1739078AD6D', '9E3AF30038A7481DAEABC4E7428E22AD', '缺：项目负责人/报销人签字', NULL, 0, 267356, NULL );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C8267FF113B8E24E050007F0100184C', '7045B38ED0AB47B991536307BE68EA0B', '缺：项目负责人签字/会议负责人签字', 1, 0, 279821, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C8268662FA0F979E050007F01001858', '7045B38ED0AB47B991536307BE68EA0B', '缺：会议预算/决算/相关材料', 2, 0, 279822, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C8268662FA1F979E050007F01001858', '7045B38ED0AB47B991536307BE68EA0B', '发票日期与会议日期不一致', 3, 0, 279823, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C8269408D78BB4FE050007F01001860', '7045B38ED0AB47B991536307BE68EA0B', '缺：会议议程、成果、出席人员名单', 4, 0, 279824, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C8269408D79BB4FE050007F01001860', '9E3AF30038A7481DAEABC4E7428E22AD', '缺项目负责人/报销人签字', 5, 0, 279825, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C826B51E2A5E2F7E050007F0100187B', '9E3AF30038A7481DAEABC4E7428E22AD', '缺：版面录取通知/培训通知/会议通知', 6, 0, 279828, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C826BC41B2E04AFE050007F0100188B', '9E3AF30038A7481DAEABC4E7428E22AD', '相关合同或协议不规范', 7, 0, 279829, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C826C4DBC797636E050007F0100188D', '9E3AF30038A7481DAEABC4E7428E22AD', '出租车发票连号', 8, 0, 279830, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C826CAA3EAF4A47E050007F0100188F', '9E3AF30038A7481DAEABC4E7428E22AD', '发票内容超项目报销预算范围', 9, 0, 279831, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( '5C826CAA3EB04A47E050007F0100188F', '9E3AF30038A7481DAEABC4E7428E22AD', '缺审批表:1、设备 2、家具 3、工程', 10, 0, 279832, 'techRb' );
INSERT INTO `sa_approval_rejected_reason`
VALUES
	( 'FC461F50785C4B1BA394A61530CE9C79', '50', '缺：会议预算/决算/相关材料', NULL, 0, 267348, NULL );-- ----------------------------
-- Table structure for sa_attachment
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_attachment`;
CREATE TABLE `sa_attachment` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`BIZ_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务类别ID',
`BIZ_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
`BIZ_SUB_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务子类别ID',
`PATH` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '路径',
`FILE_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '文件名称',
`FILE_SIZE` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件大小',
`FILE_KIND` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件类别',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建日期',
`CREATED_BY_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
`CLEAR_CACHE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '清楚缓存',
`UPLOAD_KIND` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上传类型',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_attachmentconfig
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_attachmentconfig`;
CREATE TABLE `sa_attachmentconfig` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ALLOW_DELETE` INT ( 11 ) NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_attachmentconfigdetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_attachmentconfigdetail`;
CREATE TABLE `sa_attachmentconfigdetail` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ATTACHMENTCONFIG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ALLOW_MULTIPLE` INT ( 11 ) NULL DEFAULT NULL,
`FILE_KIND` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`COL_SPAN` INT ( 11 ) NULL DEFAULT NULL,
`IS_REQUIRED` INT ( 11 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_bizclassification
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_bizclassification`;
CREATE TABLE `sa_bizclassification` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '全路径ID',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '全路径',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务分类配置' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_bizclassificationdetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_bizclassificationdetail`;
CREATE TABLE `sa_bizclassificationdetail` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`BIZ_CLASSIFICATION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务属性配置ID',
`BIZ_TYPE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务参数;业务数据',
`BIZ_PROPERTY_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务属性ID',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本',
`ENTITY_CLASS_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '对应实体资源类名',
`BIZ_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务名称',
`DIALOG_WIDTH` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '对话框宽度',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务分类配置明细' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_codebuildrule
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_codebuildrule`;
CREATE TABLE `sa_codebuildrule` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`RULE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CURRENT_VALUE` BIGINT ( 20 ) NULL DEFAULT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`LAST_MODIFIED_DATE` datetime  NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_commonhandler
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_commonhandler`;
CREATE TABLE `sa_commonhandler` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`BIZ_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
`KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'receiver 接收人 feedbacker 反馈人 feedbackViewer 反馈查看人',
`ORG_UNIT_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构ID',
`ORG_UNIT_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '组织单元名称',
`ORG_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织单元类别',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '序号',
`GROUP_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '分组ID',
`SUB_PROC_UNIT_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '环节描述',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '通用处理人设置' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_commontree
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_commontree`;
CREATE TABLE `sa_commontree` (
`KIND_ID` INT ( 11 ) NULL DEFAULT NULL,
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`SHORT_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '简码',
`NODE_KIND_ID` VARCHAR ( 6 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'floder文件夹 2 left',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ID',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID'
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '通用树' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_commontree
-- ----------------------------
INSERT INTO `sa_commontree`
VALUES
	( 1, '组织类型', NULL, 'FOLDER', '组织类型', NULL, 1, 104426, 1, '/1', '/组织类型', '1', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 1, 'CDHG', NULL, 'FOLDER', '系统默认', NULL, 2, 282373, 1, '/1/49530B56651A484196B80818734A49F6', '/组织类型/系统默认', '49530B56651A484196B80818734A49F6', '1' );
INSERT INTO `sa_commontree`
VALUES
	( 2, '01', NULL, 'FOLDER', '系统默认', NULL, 1, 3551256, 1, '/2/181', '/部门类型/系统默认', '181', '2' );
INSERT INTO `sa_commontree`
VALUES
	( 2, '部门类型', NULL, 'FOLDER', '部门类型', NULL, 1, 3551257, 1, '/2', '/部门类型', '2', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 3, '01', NULL, 'FOLDER', '系统默认', NULL, 1, 24482, 1, '/3/189', '/岗位类型/系统默认', '189', '3' );
INSERT INTO `sa_commontree`
VALUES
	( 3, '岗位类型', NULL, 'FOLDER', '岗位类型', NULL, 1, 79214, 1, '/3', '/岗位类型', '3', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 4, 'system', NULL, 'FOLDER', '系统角色', NULL, 2, 6138, 1, '/4/286', '/角色树/系统角色', '286', '4' );
INSERT INTO `sa_commontree`
VALUES
	( 4, 'JSS', NULL, 'FOLDER', '角色树', NULL, 1, 84172, 1, '/4', '/角色树', '4', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 5, 'flexfielddefinition', NULL, 'FOLDER', '扩展字段定义', NULL, 1, 98810, 1, '/5', '/扩展字段定义', '5', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 5, 'system', NULL, 'FOLDER', '系统', NULL, 1, 148148, 1, '/5/6603F93BCD3244BD8B6E5CBE0AC3AAE4', '/扩展字段定义/系统', '6603F93BCD3244BD8B6E5CBE0AC3AAE4', '5' );
INSERT INTO `sa_commontree`
VALUES
	( 6, 'flexfieldgroup', NULL, 'FOLDER', '扩展字段分组', NULL, 1, 98268, 1, '/6', '/扩展字段分组', '6', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 7, '系统参数', NULL, 'FOLDER', '系统参数', NULL, 2, 104442, 1, '/7', '/系统参数', '7', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 7, 'organConst', NULL, 'FOLDER', '机构常量', 'a', 1, 129721, 1, '/7/424955/424959', '/系统参数/组织权限常量/机构常量', '424959', '424955' );
INSERT INTO `sa_commontree`
VALUES
	( 7, 'OPMConst', NULL, 'FOLDER', '组织权限常量', NULL, 8, 129723, 1, '/7/424955', '/系统参数/组织权限常量', '424955', '7' );
INSERT INTO `sa_commontree`
VALUES
	( 7, '01', NULL, 'FOLDER', '系统参数', NULL, 6, 133392, 1, '/7/1320', '/系统参数/系统参数', '1320', '7' );
INSERT INTO `sa_commontree`
VALUES
	( 7, '界面参数', NULL, 'FOLDER', '界面参数', NULL, 1, 262749, 1, '/7/1320/7C9A74E0F19A4C5FB89746E80F788A6D', '/系统参数/系统参数/界面参数', '7C9A74E0F19A4C5FB89746E80F788A6D', '1320' );
INSERT INTO `sa_commontree`
VALUES
	( 7, '工作流', NULL, 'FOLDER', '工作流', NULL, 9, 338201, 1, '/7/AD048D2BF97D4AD5896892A4422D98F3', '/系统参数/工作流', 'AD048D2BF97D4AD5896892A4422D98F3', '7' );
INSERT INTO `sa_commontree`
VALUES
	( 7, 'posCost', NULL, 'FOLDER', '岗位常量', NULL, 4, NULL, 1, '/7/424955/424962', '/系统参数/组织权限常量/岗位常量', '424962', '424955' );
INSERT INTO `sa_commontree`
VALUES
	( 7, 'deptConst', NULL, 'FOLDER', '部门常量', NULL, 3, NULL, 1, '/7/424955/424961', '/系统参数/组织权限常量/部门常量', '424961', '424955' );
INSERT INTO `sa_commontree`
VALUES
	( 7, 'mangeType', NULL, 'FOLDER', '管理权限', NULL, 9, NULL, 1, '/7/424955/425521', '/系统参数/组织权限常量/管理权限', '425521', '424955' );
INSERT INTO `sa_commontree`
VALUES
	( 8, '01', NULL, 'FOLDER', '编码类别', NULL, 1, NULL, 1, '/8', '/编码类别', '8', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 9, '01', NULL, 'FOLDER', '系统管理', NULL, 1, 25171, 1, '/9/1395', '/数据字典/系统管理', '1395', '9' );
INSERT INTO `sa_commontree`
VALUES
	( 9, '01', NULL, 'FOLDER', '数据字典', NULL, 9, 104308, 1, '/9', '/数据字典', '9', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 10, 'root', NULL, 'FOLDER', '导入模板根节点', NULL, NULL, 103888, NULL, NULL, '/导入模板根节点', '20161202', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 15, 'remind', NULL, 'FOLDER', '消息提醒', NULL, 1, 105035, 1, '/15', '/消息提醒', '15', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 16, '01', NULL, 'FOLDER', '字段分类', NULL, 16, 1, 1, '/16', '/字段分类', '16', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 17, 'system', NULL, 'FOLDER', '系统', '系统', 3, 27951, 1, '/17/34DAC78038EE466F9595A73B001A8CF8', '/基础管理权限/系统', '34DAC78038EE466F9595A73B001A8CF8', '17' );
INSERT INTO `sa_commontree`
VALUES
	( 17, '01', NULL, 'FOLDER', '基础管理权限', NULL, 1, 27952, 1, '/17', '/基础管理权限', '17', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 18, '01', NULL, 'FOLDER', '业务管理权限', NULL, 1, 1, 1, '/18', '/业务管理权限', '18', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 18, 'pmBaseManage', NULL, 'FOLDER', '基础管理', NULL, 2, 1290163, 1, '/18/1272445/1290162', '/业务管理权限/物业/基础管理', '1290162', '1272445' );
INSERT INTO `sa_commontree`
VALUES
	( 18, '01', NULL, 'FOLDER', '系统', NULL, 1, NULL, 1, '/18/896255', '/业务管理权限/系统', '896255', '18' );
INSERT INTO `sa_commontree`
VALUES
	( 21, '01', NULL, 'FOLDER', '附件配置', NULL, 1, 1, 1, '/21', '/附件配置', '21', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 25, 'userGroup', NULL, 'FOLDER', '用户分组', NULL, 1, 115112, 1, '/2001', '/用户分组', '2001', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 50, 'approvalRejectedReason', NULL, 'FOLDER', '网上报销', NULL, 1, 50, 1, '/50', '/网上报销', '50', 'techRb' );
INSERT INTO `sa_commontree`
VALUES
	( 50, '主办及承办会议报销', NULL, 'FOLDER', '主办及承办会议报销', NULL, 1, 267344, 1, '/50/4C1CCFE31BD341C4B0BBA53F09C757C2/7045B38ED0AB47B991536307BE68EA0B', '/网上报销/主办及承办会议报销', '7045B38ED0AB47B991536307BE68EA0B', '50' );
INSERT INTO `sa_commontree`
VALUES
	( 60, '信息收集类别', NULL, 'FOLDER', '信息收集类别', NULL, 1, 319443, 1, '/5EF486A1B554196AE050007F01001ED3', '/信息收集类别', '5EF486A1B554196AE050007F01001ED3', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 55, 'i18nProperties', NULL, 'FOLDER', '国际化资源分类', NULL, 1, 55, 1, '/55', '/国际化资源分类', '55', '0' );
INSERT INTO `sa_commontree`
VALUES
	( 55, '系统参数', NULL, 'FOLDER', '系统参数', NULL, 1, 270772, 1, '/55/31D05A903AB9462CAD701B4F92D899C2', '/国际化资源分类/系统参数', '31D05A903AB9462CAD701B4F92D899C2', '55' );
INSERT INTO `sa_commontree`
VALUES
	( 55, '系统字典', NULL, 'FOLDER', '系统字典', NULL, 2, 270774, 1, '/55/7D63574CB124454F92AF30F6EE368240', '/国际化资源分类/系统字典', '7D63574CB124454F92AF30F6EE368240', '55' );
INSERT INTO `sa_commontree`
VALUES
	( 55, '功能菜单', NULL, 'FOLDER', '功能菜单', NULL, 4, 270776, 1, '/55/78D047EC4A044AFEA1A1DBC4792A2C91', '/国际化资源分类/功能菜单', '78D047EC4A044AFEA1A1DBC4792A2C91', '55' );
INSERT INTO `sa_commontree`
VALUES
	( 55, '审批环节名', NULL, 'FOLDER', '审批环节名', NULL, 5, 270778, 1, '/55/F90540F6C2224D2E9E4BEF6ACAB40A29', '/国际化资源分类/审批环节名', 'F90540F6C2224D2E9E4BEF6ACAB40A29', '55' );
INSERT INTO `sa_commontree`
VALUES
	( 55, '附件配置', NULL, 'FOLDER', '附件配置', NULL, 3, 270780, 1, '/55/9A8C89F070FB4B55BDDA40E3B66D2835', '/国际化资源分类/附件配置', '9A8C89F070FB4B55BDDA40E3B66D2835', '55' );
INSERT INTO `sa_commontree`
VALUES
	( 16, 'buttonJurisdiction', NULL, 'FOLDER', '按钮权限', '按钮权限buttonJurisdiction', 1, 851631, 1, '/16/671DFBC586B14E90E050007F01002A58', '/字段分类/按钮权限', '671DFBC586B14E90E050007F01002A58', '16' );-- ----------------------------
-- Table structure for sa_dictionary
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_dictionary`;
CREATE TABLE `sa_dictionary` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`KIND_ID` INT ( 11 ) NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_dictionary
-- ----------------------------
INSERT INTO `sa_dictionary`
VALUES
	( '0318D3F4E7F145469873708DED37391D', 'secretLevel', '密级级别', '1395', 0, 1, '密级级别', 86498, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '067825F78AF5493E82ABF74FB1BEDEA2', 'uiElementStatus', '界面元素状态', '1395', 0, 1, NULL, 86506, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '1', 'nation', '民族', '1395', 0, 1, NULL, NULL, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '10592', 'orgAdminKind', '机构类型', '1395', 0, 1, NULL, 24841, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '10601', 'dutyLevel', '层级', '1395', 0, 1, '层级', 86476, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '10859', 'managerFun', '管理人员函数', '1395', 0, 1, NULL, 257240, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '1266292', 'messageNodeType', '消息节点类型', '1266290', 0, 1, '消息节点类型', 86484, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '1317646', 'taskKind', '任务类别', '1395', 0, 1, NULL, 1317647, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '1405', 'sex', '性别', '1395', 0, 1, NULL, NULL, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '1A3ECD959A8A464B8CF14630578D59C7', 'roleStatus', '角色状态', '1395', 0, 1, NULL, 86496, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', 'businessKind', '业务类型', '11DC2E4FFF094A828B079EEE1F2CD731', 0, 1, NULL, 253330, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '3C89377D4E384DD6876B38FEF86B7041', 'processManageStatus', '流程状态', '1395', 0, 1, NULL, 86494, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '4188EF96566546A1951A1044B40348E6', 'commonTreeKind', '通用树类别', '1395', 0, 1, NULL, 3577479, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '424949', 'organKind', '公司类别', '1395', 0, - 1, '公司类别-需要删除', NULL, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '427180', 'orgProperty', '机构属性', '1395', 0, 1, NULL, 24812, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '434B00E325504AEC9B2E8D2DB00BA123', 'procAgentKind', '代理方式', '1395', 0, 1, NULL, 86492, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '4C43956329A947278BA13F43E76E7FE2', 'deptLevel', '部门级别', '1395', 0, 1, NULL, 1203021, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '62279D8505584A91BF523813FCFF8344', 'education', '学历', '1395', 0, 1, NULL, 308186, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '6272911', 'subjectType', '专业类别', '9', 0, 1, NULL, 6520834, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '634343', 'roleKindId', '角色类别', '1395', 0, 1, NULL, 70098, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '6365941', 'orgAreaKind', '组织机构区域类型', '1395', 0, 1, NULL, 55422476, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '6554A38109EA495786ECA295F53DEAAA', 'maritalStatus', '婚姻状况', '1395', 0, 1, NULL, 270577, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '6A4F9F6C7FCF4EAC8479AE6A79458541', 'orgFunctionNodeKind', '机构函数节点类别', '1395', 0, 1, NULL, 86488, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '726077', 'fieldAuthority', '字段权限', '1395', 0, 1, NULL, NULL, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '726372', 'fieldType', '字段分类', '1395', 0, 1, '数据测试数', 2110, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '739055A2A3D54C0AA5C06D848DA6334A', 'bizManagementNodeKind', '业务权限节点类别', '1395', 0, 1, NULL, 107988, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '768E1E81BCF14DC78FC843EDBA4CF800', 'agentStatus', '代理状态', '1395', 0, 1, NULL, 260141, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '780205', 'permissionKind', '权限类别', '1395', 0, 1, NULL, NULL, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', 'weekKindId', '星期', '1395', 0, 1, NULL, 5387, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '7D48D910A4B840E8908FC572ABCC7B71', 'treeNodeKind', '树节点类型', '1395', 0, 1, NULL, 294044, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '7F0F082C3A8643D9829BAE5A8AC19F48', 'scopeKind', '流程范围', '1395', 0, 1, NULL, 86497, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '81F17B971A114700B7FD3B6C9E51307A', 'subjection', '隶属公司', '11DC2E4FFF094A828B079EEE1F2CD731', 0, 1, NULL, 240990, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '898180', 'deptProperty', '部门属性', '1395', 0, 1, NULL, 32125199, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '8C850449D9314D70A446361BC291150E', 'bizManagementType', '业务权限类别', '1395', 0, 1, NULL, 253374, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '8C94DDC67C2840D8871BB630E008FFCB', 'processManageNodeKind', '流程类别', '1395', 0, 1, NULL, 86493, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '8E9E997A5FEB4287B30E6A6A65D83817', 'fieldTypeList', '字段类型', '1395', 0, 1, NULL, 86479, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '9059', 'posLevel', '行政级别', '1395', 0, 1, NULL, 32524, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '91C5EC53E16F4B8697E17C02699ED33E', 'showModel', '显示模式', '1395', 0, 1, NULL, 86499, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', 'editControlType', '控件类型', '1395', 0, 1, NULL, 135085, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '9765', 'yesorno', '是否', '1395', 0, 1, NULL, 14834, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', 'handleResult', '处理结果', '1395', 0, 1, NULL, 252241, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( '9D9822AA3DFF4B0FB84DEE0D501D1276', 'dictionaryKind', '字典类别', '1395', 0, 1, NULL, 98240, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'ACCCC370E59E4F74B19B677D03114FA0', 'dataSourceKind', '数据源类型', '1395', 0, 1, NULL, 86472, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'B4F33EA8EF2546F8A626ECAB8DA841A4', 'status', '状态', '1395', 0, 1, NULL, 86503, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'B6F5801335AD4525B87668DD2634C063', 'orgFunctionKind', '机构函数', '1395', 0, 1, NULL, 86487, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'CF4B535B1E914756B0FC688BEF6C94B9', 'orgKindStatus', '组织类型状态', '1395', 0, 1, NULL, 86489, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'D5A465C4B9B643FD8D7EC6B94E90AF21', 'dictionaryStatus', '字段状态', '1395', 0, 1, NULL, 86475, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'E9302BB1D5C74FC6999954EF535949AA', 'personSecurityGrade', '涉密等级', '1395', 0, 1, NULL, 270586, NULL );
INSERT INTO `sa_dictionary`
VALUES
	( 'F7D3A2AD863B48FC87F942D2A2C8125B', 'securityGrade', '密级', '1395', 0, 1, NULL, 103459, NULL );-- ----------------------------
-- Table structure for sa_dictionarydetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_dictionarydetail`;
CREATE TABLE `sa_dictionarydetail` (
`DICTIONARY_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci,
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VALUE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`TYPE_ID` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_dictionarydetail
-- ----------------------------
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '0073C130B0744F42B95C01CEEDF75940', '获取当前人员单位行政管理权限管理者', 'findCurrentPersonCenterAdminManager()', 1, NULL, NULL, 8, 347829 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', '0123B50A714C4D149B086A2DE651FC25', 'combox', '2', 1, NULL, NULL, 2, 135086 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', '02D7D5E92D01486587AEB992DDF96510', '系统完成', '5', 1, NULL, NULL, 0, 252240 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'D5A465C4B9B643FD8D7EC6B94E90AF21', '03368A5B74BB4BD3923AD8CAC8E8C6A4', '草稿', '-1', 1, NULL, NULL, 1, 81778 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '044D8A661AFC478B9A4604E5A4FCA47F', 'CodeBuildRule,folderId', '8', 1, NULL, NULL, 8, 98084 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'F7D3A2AD863B48FC87F942D2A2C8125B', '046505719CB043668837280D41CA6B0B', '秘密', 'SECRET', 1, NULL, NULL, NULL, 103453 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1A3ECD959A8A464B8CF14630578D59C7', '06C8528AFC9E4E0B998B7D383CBCDC78', '启用', '1', 1, NULL, NULL, 1, 81791 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'F7D3A2AD863B48FC87F942D2A2C8125B', '08EEFFD994184A74B95F1AA8DF87EA3B', '机密', 'CONFIDENTIALITY', 1, NULL, NULL, NULL, 103454 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726372', '09F5D59AEEFF4810A24109641817A6BB', '其他', '3', 1, NULL, NULL, 4, 775219 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '62279D8505584A91BF523813FCFF8344', '0B45D3440F204A6480321EFB0BAFCC8E', '学士', '学士', 1, '学士', NULL, 2, 270580 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8C850449D9314D70A446361BC291150E', '0DAA500B3030461698C82BB28FFD3316', '系统', '0', 1, NULL, NULL, 1, 81988 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '739055A2A3D54C0AA5C06D848DA6334A', '0DBC7C5F3DE3416E85110CB757B18CB8', '业务权限', '2', 1, NULL, NULL, 2, 81993 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '1', '汉族', '1', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '10', '朝鲜族', '10', 1, NULL, NULL, 10, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10601', '10602', '核心层', '1', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10601', '10603', '中高层', '2', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10601', '10604', '中层', '3', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10601', '10605', '基层骨干', '4', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10601', '10606', '基层', '5', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '11', '满族', '11', 1, NULL, NULL, 11, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '634343', '11758B55A22F48BEAB963CC62D93C655', '审计员', 'auditor', 1, NULL, NULL, 4, 70093 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '11EE96BCC0B8442FB3320A16D633E7F0', 'Formula,folderId', '30', 1, NULL, NULL, 30, 104396 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '12', '侗族', '12', 1, NULL, NULL, 12, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1266292', '1266295', '欢迎', 'welcome', 1, NULL, NULL, 2, 1266302 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1266292', '1266297', '文本', 'text', 1, NULL, NULL, 1, 1266303 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1266292', '1266299', '图文', 'pic', 1, NULL, NULL, 3, 1266304 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1266292', '1271373', '链接', 'link', 1, NULL, NULL, 4, 1271377 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '13', '瑶族', '13', 1, NULL, NULL, 13, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1317646', '1317648', '任务', 'task', 1, NULL, NULL, 1, 1317649 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1317646', '1317650', '通知', 'notice', 1, NULL, NULL, 2, 1317651 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1317646', '1317652', '抄送', 'makeACopyFor', 1, NULL, NULL, 3, 1317653 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1317646', '1317654', '催办', 'remind', 1, NULL, NULL, 4, 1317655 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'F7D3A2AD863B48FC87F942D2A2C8125B', '13D0F8C53B7B4B7093C5BBA3239CB0AF', '绝密', 'TOP_SECRET', 1, NULL, NULL, NULL, 103455 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '14', '白族', '14', 1, NULL, NULL, 14, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '15', '土家族', '15', 1, NULL, NULL, 15, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '16', '哈尼族', '16', 1, NULL, NULL, 16, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '17', '哈萨克族', '17', 1, NULL, NULL, 17, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1405', '1781', '男', '1', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1405', '1782', '女', '2', 1, NULL, NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '18', '傣族', '18', 1, NULL, NULL, 18, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'ACCCC370E59E4F74B19B677D03114FA0', '188530A3A41B48A68C11D5DF3FAAD688', '数据字典', '3', 1, NULL, NULL, 3, 81979 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '19', '黎族', '19', 1, NULL, NULL, 19, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'E9302BB1D5C74FC6999954EF535949AA', '1ABF160C4D294BD6B794DB737BCF7273', '一般', 'COMMON', 1, NULL, NULL, 2, 270588 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '1C8DA2FF3016477A844FFD94B9FED39D', 'FlexFieldDefinition,folderId', '5', 1, NULL, NULL, 5, 107919 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '1D7CDBCF30784F4FA1D21A437EA04313', 'ExcelImportTemplate,folderId', '10', 1, NULL, NULL, 10, 98086 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '2', '蒙古族', '2', 1, NULL, NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '20', '傈僳族', '20', 1, NULL, NULL, 20, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '21', '佤族', '21', 1, NULL, NULL, 21, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '22', '畲族', '22', 1, NULL, NULL, 22, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '23', '高山族', '23', 1, NULL, NULL, 23, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '24', '拉祜族', '24', 1, NULL, NULL, 24, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '25', '水族', '25', 1, NULL, NULL, 25, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'E9302BB1D5C74FC6999954EF535949AA', '25CCD0FFBCCD41D880FACD6D94320DDF', '重要', 'IMPORTANCE', 1, NULL, NULL, 3, 270589 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '26', '东乡族', '26', 1, NULL, NULL, 26, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7F0F082C3A8643D9829BAE5A8AC19F48', '262F3E4BA99941829E2FE9EACAB5DF50', '本组织', '1', 1, NULL, NULL, 1, 81961 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', '263F9E4B98584197A3C0D6543853AF82', '副部长', '2', - 1, NULL, NULL, 6, 31510 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '27', '纳西族', '27', 1, NULL, NULL, 27, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '28', '景颇族', '28', 1, NULL, NULL, 28, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '29', '柯尔克孜族', '29', 1, NULL, NULL, 29, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '2A2D8DA74EB84A4BBCA536CFAE689018', 'SysParameter,folderId', '7', 1, NULL, NULL, 7, 98083 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '2CAEF6BA26684D9D9A1BFE3C953691EE', '指定单位管理者', 'findTechOrgCodeManagers(@orgCoe,\'manageType\')', 1, NULL, NULL, 9, 347857 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '067825F78AF5493E82ABF74FB1BEDEA2', '2D8F270478E941CB9391D67959B12EC5', '启用', '1', 1, NULL, NULL, 1, 82010 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '3', '回族', '3', 1, NULL, NULL, 3, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '30', '土族', '30', 1, NULL, NULL, 30, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '31', '达斡尔族', '31', 1, NULL, NULL, 31, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '32', '仫佬族', '32', 1, NULL, NULL, 32, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '33', '羌族', '33', 1, NULL, NULL, 33, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '0318D3F4E7F145469873708DED37391D', '33B23A1BD3CC4AB68ECC83A0C8B729EA', '普通', '1', 1, NULL, NULL, 1, 73785 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '34', '布朗族', '34', 1, NULL, NULL, 34, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '35', '撒拉族', '35', 1, NULL, NULL, 35, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '36', '毛难族', '36', 1, NULL, NULL, 36, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'B6F5801335AD4525B87668DD2634C063', '3635BE863D204922A398D895C34F5F39', '系统', '0', 1, NULL, NULL, 1, 81996 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '37', '仡佬族', '37', 1, NULL, NULL, 37, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '38', '锡伯族', '38', 1, NULL, NULL, 38, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '39', '阿昌族', '39', 1, NULL, NULL, 39, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', '3D1F9711223248BA967EFB88F43CF0FE', 'textbox', '1', 1, NULL, NULL, 1, 81965 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8E9E997A5FEB4287B30E6A6A65D83817', '3E6D1A5D511242D78D2B88CE0F793BD8', 'date', '3', 1, NULL, NULL, NULL, 84017 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', '3E714F5C46EA402AB462B14C9CD6EEBC', '商业数据分析项目', '2', 1, NULL, NULL, 2, 253331 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '62279D8505584A91BF523813FCFF8344', '3EB0A0BC5F5D4DF7B85F725B2B09BBAB', '本科', '本科', 1, '本科', NULL, 3, 270581 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '634343', '3F937306B0D4416B80450B0A52AA7F0B', '管理员', 'administrator', 1, NULL, NULL, 5, 70094 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '4', '藏族', '4', 1, NULL, NULL, 4, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '40', '普米族', '40', 1, NULL, NULL, 40, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', '40CC9EB991034040A13C2C9FC308A90C', '分管领导', '4', - 1, NULL, NULL, 4, 31512 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '41', '塔吉克族', '41', 1, NULL, NULL, 41, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', '41619ECD376A4F74B9F04E979473B396', 'radio', '6', 1, NULL, NULL, 6, 81970 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '4188EF96566546A1951A1044B40348E6', 'Customer,folderId', '35', 1, NULL, NULL, 35, 104470 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '42', '怒族', '42', 1, NULL, NULL, 42, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '424949', '424952', '成长型公司', '3', 1, '0', NULL, 3, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '424949', '424953', '领跑型公司', '2', 1, '0', NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '424949', '427174', '总部', '1', 0, '1', NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10592', '427179', '分公司', 'two', 1, NULL, NULL, 5, 5460239 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '43', '乌孜别克族', '43', 1, NULL, NULL, 43, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '44', '俄罗斯族', '44', 1, NULL, NULL, 44, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '91C5EC53E16F4B8697E17C02699ED33E', '44D61A1F14D2447897F57A1098EAE8B7', '表格', '1', 1, NULL, NULL, 1, 81983 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '45', '鄂温克族', '45', 1, NULL, NULL, 45, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', '4584E1EF22634124926AB3415D5E1945', 'SAP软件销售项目', '4', 1, NULL, NULL, 4, 253333 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '46', '崩龙族', '46', 1, NULL, NULL, 46, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '47', '保安族', '47', 1, NULL, NULL, 47, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '81F17B971A114700B7FD3B6C9E51307A', '4716C7DC797A4CAB95A514087C214030', '母公司', 'parent_company', 1, NULL, NULL, 0, 240991 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10592', '4789114', '总部', 'one', 1, NULL, NULL, 7, 5336738 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '48', '裕固族', '48', 1, NULL, NULL, 48, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '48B1D56FA164408BB15A7600D303B860', 'Report,folderId', '62', 1, NULL, NULL, 21, 3577474 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '49', '京族', '49', 1, NULL, NULL, 49, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1A3ECD959A8A464B8CF14630578D59C7', '4CE302E2C3A84490896F67F4D19817C5', '禁用', '2', 1, NULL, NULL, 2, 81792 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', '4E98A9DE6DAE41DFAEE88713A8F5CF1A', '星期五', '5', 1, NULL, NULL, 5, 5380 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '5', '维吾尔族', '5', 1, NULL, NULL, 5, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '50', '塔塔尔族', '50', 1, NULL, NULL, 50, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '51', '独龙族', '51', 1, NULL, NULL, 51, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7D48D910A4B840E8908FC572ABCC7B71', '51B8C5DB44094A58B1458BF3232D5707', '叶节点', '2', 1, NULL, NULL, 0, 155942 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '52', '鄂伦春族', '52', 1, NULL, NULL, 52, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'ACCCC370E59E4F74B19B677D03114FA0', '52679A5F389A4554B08F6E265855BEB9', '无', '1', 1, NULL, NULL, 1, 81977 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '53', '赫哲族', '53', 1, NULL, NULL, 53, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', '536436F051AC4615AD15392BECDA92F3', '开发型项目', '7', 1, NULL, NULL, 7, 253336 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '54', '门巴族', '54', 1, NULL, NULL, 54, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '540AB4FAE9124726A994A4DC907B995F', '查找流程实例申请人', 'findApplicant()', 1, NULL, NULL, 4, 347808 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '55', '珞巴族', '55', 1, NULL, NULL, 55, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', '55B3A34973B24C488D3C47EC3E7D870C', '员工', '1', - 1, NULL, NULL, 7, 31509 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '56', '基诺族', '56', 1, NULL, NULL, 56, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '564E492D3F3644359A4D78EB2AFAFBD5', 'EnterpriseTemplateFolde,parentId', '32', 1, NULL, NULL, 32, 114647 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'CF4B535B1E914756B0FC688BEF6C94B9', '5834E85CA416405E89DBCC38EC49CC59', '禁用', '0', 1, NULL, NULL, 2, 81785 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '5A2E55303CBC4C8C9129A22484DF07C9', '获取指定单位管理者', 'findTechCenterManagers(@fullId,\'manageType\')', 1, NULL, NULL, 6, 347822 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'D5A465C4B9B643FD8D7EC6B94E90AF21', '5A8116A23BC549929780781A5342688B', '禁用', '0', 1, NULL, NULL, 2, 81780 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '5AB87B27F2DC48AAA94301A99B6FCCED', '获取当前人员的指定管理权限的管理者', 'findCurrentNearestManagers(\'manageType\')', 1, NULL, NULL, 7, 347828 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '5C0ACBBD9C0D44ECA4143644642D1EAF', 'UserGroup,folderId', '25', 1, NULL, NULL, 25, 98089 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '5C2937EDD15C44C99DE5D0D0520C5F4F', 'BaseManagementType,folderId', '17', 1, NULL, NULL, 17, 98087 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6554A38109EA495786ECA295F53DEAAA', '5D4924E292C944E188C800D1B9D7D74D', '离异', '离异', 1, '离异', NULL, 3, 270575 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'F7D3A2AD863B48FC87F942D2A2C8125B', '5D64359163EC49F0904B7F878663AC44', '非密', 'NON_SECRET', 1, NULL, NULL, NULL, 103458 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', '5DA0DDB5CD6944FFA9DC7CCD7C5FB0C6', '星期一', '1', 1, NULL, NULL, 1, 5376 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', '5DAA9CEA490341EA8031C18F480E995F', '副总经理', '8', - 1, NULL, NULL, 3, 31507 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8E9E997A5FEB4287B30E6A6A65D83817', '5DD3F0AA2D02465D8E690D5B689DC8AF', 'bool', '5', 1, NULL, NULL, NULL, 84019 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '0318D3F4E7F145469873708DED37391D', '5E2F6B5F95F54719A334EBADF3DC4A77', '一般', '2', 1, NULL, NULL, 2, 73786 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '6', '苗族', '6', 1, NULL, NULL, 6, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6272913', '建筑', '1', 1, NULL, NULL, 1, 6272920 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6272915', '景观', '2', 1, NULL, NULL, 1, 6272916 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6272917', '装饰', '3', 1, NULL, NULL, 1, 6272918 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6297795', '机电', '4', 1, NULL, NULL, 1, 6297796 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6297797', '结构', '5', 1, NULL, NULL, 1, 6297798 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6322570', '给排水', '41', 1, NULL, NULL, 1, 6322571 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6322572', '暖通', '42', 1, NULL, NULL, 1, 6322573 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6322574', '强电', '43', 1, NULL, NULL, 1, 6322575 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6322576', '弱电', '44', 1, NULL, NULL, 1, 6322577 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '641E49892E4F4784BED508CF1480B893', 'ApprovalRejectedReason,folderId', '50', 1, NULL, NULL, 50, 98089 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6272911', '6520835', '示范区', '99', 1, NULL, NULL, 1, 6520836 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', '664A5CF4B25645FA81E10B496AD7749C', '星期六', '6', 1, NULL, NULL, 6, 5381 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '91C5EC53E16F4B8697E17C02699ED33E', '67588F573ED74C0197592D0BAC83067C', 'DIV', '0', 1, NULL, NULL, 2, 81984 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '6854B61F41D9420FBFC5B6F5047CA3B4', '获取指定项目管理者', 'findPSProjectPerson(@projectId)', 0, NULL, NULL, 20, 348061 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4C43956329A947278BA13F43E76E7FE2', '689E3D19FA771B46E050007F01003C19', '总体', 'zt', 1, NULL, NULL, 3, 1203028 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4C43956329A947278BA13F43E76E7FE2', '689E3D19FA781B46E050007F01003C19', '分总体', 'fzt', 1, NULL, NULL, 4, 1203029 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4C43956329A947278BA13F43E76E7FE2', '689E3D19FA791B46E050007F01003C19', '系统', 'xt', 1, NULL, NULL, 5, 1203030 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '739055A2A3D54C0AA5C06D848DA6334A', '69DBB109C9324A90BE1BB19A66C86A66', '分类', '1', 1, NULL, NULL, 1, 81992 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '634343', '6D4F7485008747B4AD36C0DA3BF08791', '超级管理员', 'superAdministrator', 1, NULL, NULL, 2, 70091 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '7', '彝族', '7', 1, NULL, NULL, 7, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '7219766ABB3347208BA7CF12C7F66A0A', 'MessageRemind,folderId', '15', 1, NULL, NULL, 15, 107914 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726077', '726078', '读写', 'readwrite', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726077', '726079', '只读', 'readonly', 1, NULL, NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726077', '726080', '无权限', 'noaccess', 1, NULL, NULL, 3, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726372', '726373', '主集', '0', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726372', '726374', '子集', '1', 1, NULL, NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', '72925EBED1454703B2BFF2F058FE43D7', 'lookUp', '9', 1, NULL, NULL, 9, 81973 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '780205', '780206', '功能权限', 'fun', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '780205', '780207', '字段权限', 'field', 1, NULL, NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '780205', '780208', '按钮权限', 'button', - 1, NULL, NULL, 3, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', '782E0FCD60314B51A02C8DFF76E0516F', '打回', '4', 1, NULL, NULL, 0, 252239 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'B4F33EA8EF2546F8A626ECAB8DA841A4', '78382CFB415048249E1A7A58E275533E', '禁用', '0', 1, NULL, NULL, 2, 362823 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4C43956329A947278BA13F43E76E7FE2', '78F12454BD284A1FB76D07C390FD22ED', '一级部门', 'First', 1, NULL, NULL, 1, 1203026 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6554A38109EA495786ECA295F53DEAAA', '7ADB40B99524419B99DF3C53602D31DE', '未婚', '未婚', 1, '未婚', NULL, 1, 270573 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '7C5B724E0383402D92FA2E10CF9026FD', 'I18nproperties,folderId', '55', 1, NULL, NULL, 55, 98088 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'ACCCC370E59E4F74B19B677D03114FA0', '7CC1A5D31693401E83C96CEB8F970782', 'JSON', '4', 1, NULL, NULL, 4, 81980 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4C43956329A947278BA13F43E76E7FE2', '7E94A49B2BBA4FF891970AD642318464', '二级部门', 'Secondary', 1, NULL, NULL, 2, 1203027 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '8', '壮族', '8', 1, NULL, NULL, 8, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', '8054DAF161A8444FA8832BF21FA3BEA8', '其它项目', '8', 1, NULL, NULL, 8, 253337 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '726372', '809957', '按钮', '2', 1, NULL, NULL, 3, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', '81AD6DECE3ED43C8AD5F596C7E22C225', 'treebox', '10', 1, NULL, NULL, 10, 81974 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', '84F85DF2535F4EEBA284C946DB403D9E', '星期四', '4', 1, NULL, NULL, 4, 5379 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '067825F78AF5493E82ABF74FB1BEDEA2', '870161AAAFD44BEAA41CCE4CDCA90F73', '禁用', '0', 1, NULL, NULL, 2, 82011 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8C94DDC67C2840D8871BB630E008FFCB', '872D39B8D2E8480296508E571BA1A462', '文件夹', 'folder', 1, NULL, NULL, 1, 81951 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '896595', '获取指定组织单元的管理者', 'findManagers()', 1, NULL, NULL, 1, 347809 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'CF4B535B1E914756B0FC688BEF6C94B9', '89A8E20780DF4865AA7002FB3E37C8F4', '启用', '1', 1, NULL, NULL, 1, 81784 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7F0F082C3A8643D9829BAE5A8AC19F48', '8C340CB06787461A92E3D90079897497', '自定义组织', '2', 1, NULL, NULL, 2, 81962 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', '8CA6E5D06947436ABBDD4F70B69B01F0', 'SAP实施项目', '1', 1, NULL, NULL, 1, 253329 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '8DB2819CD55E44EAAEBDC82A61C61DD6', 'OrgType3,folderId', '3', 0, NULL, NULL, 3, 3577021 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', '8F59511A25BB4D38BC0D3970448E72B7', '系统集成项目', '3', 1, NULL, NULL, 3, 253332 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '1', '9', '布依族', '9', 1, NULL, NULL, 9, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '906353', '获取当前人员的行政权限管理者', 'findCurrentPersonMemberAdminManager()', 1, NULL, NULL, 3, 347817 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', '912965E172484C63AED5AF8F414AA20B', '已阅', '3', 1, NULL, NULL, 0, 252238 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '634343', '92BFE2324652439A85EEB46A39A10BB2', '普通角色', 'common', 1, NULL, NULL, 1, 70090 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'B4F33EA8EF2546F8A626ECAB8DA841A4', '9332FDB7116049BD8995EF5A1BF518C3', '启用', '1', 1, NULL, NULL, 1, 362824 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '93B59D1F4A2E44F09798E17BD9742090', 'OrgType,folderId', '1', 1, NULL, NULL, 1, 107915 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '3C89377D4E384DD6876B38FEF86B7041', '94C4EED23D2842CB8E933BD733B125E9', '禁用', '2', 1, NULL, NULL, 2, 81958 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9765', '9766', '是', '1', 1, NULL, NULL, 1, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9765', '9767', '否', '0', 1, NULL, NULL, 2, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8E9E997A5FEB4287B30E6A6A65D83817', '97BC44331AA34CE9822D9FAC65119F91', 'number', '2', 1, NULL, NULL, NULL, 84016 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', '9C35F090D8474008A549BA65F548C870', '获取指定组织单元最近的管理者', 'findNearestManagers(@personMemberId,\'admin\')', 1, NULL, NULL, 2, 347810 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '9CE8A02A2DEF42959R8B2376BA85162E', 'BmDataCollectionKind,folderId', '60', 1, NULL, NULL, NULL, NULL );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', '9E674A5E642B480A91ACE5222F4E1737', 'OrgType2,folderId', '2', 0, NULL, NULL, 2, 3577020 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '434B00E325504AEC9B2E8D2DB00BA123', '9F54B3DDAA234011AD2ED5068C6B45DA', '自定义流程', '2', 1, NULL, NULL, 2, 81876 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '62279D8505584A91BF523813FCFF8344', '9FD3CCA6EA544C16A818738F46783B36', '专科', '专科', 1, '专科', NULL, 4, 270582 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '634343', 'A787465417C146C8838103E3EA2F3726', '安全员', 'securityGuard', 1, NULL, NULL, 3, 70092 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', 'AA84822543E4463F95F577588F2B9FF3', '其它软件销售项目', '6', 1, NULL, NULL, 6, 253335 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'B6F5801335AD4525B87668DD2634C063', 'AC39BFAF98AC44CD8249E10F57D15E55', '自定义', '1', 1, NULL, NULL, 2, 81997 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', 'ACB0C9E59C784CD3AB2FA6723688615D', 'select', '8', 1, NULL, NULL, 8, 81972 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', 'ACCA56F52C2E495B924F77C9E1D5DFE1', 'Role,folderId', '4', 1, NULL, NULL, 4, 107918 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', 'AD0434A969E843D5B462E833F7464C75', 'Template,folderId', '31', 1, NULL, NULL, 31, 130342 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', 'AD2C20C232054DD5B8021B83775ABC81', '不通过', '2', 1, NULL, NULL, 0, 252237 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '427180', 'AD9B06BE8649446C8F37EED6ACD62EFA', '机构类型', 'orgAdminKind', - 1, NULL, NULL, NULL, 24811 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', 'ADBC27AC26D3481B8639A49D871D2D05', 'spinner', '3', 1, NULL, NULL, 3, 81967 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', 'AF6126F7D5C74D22977DD1D950635561', '星期日', '7', 1, NULL, NULL, 7, 5382 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', 'AFECEC9462A541B480A267EEE9D17A5A', '部长', '3', - 1, NULL, NULL, 5, 31511 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '62279D8505584A91BF523813FCFF8344', 'B225ED2551DC4093AE5A41CA80401F71', '博士', '博士', 1, '博士', NULL, 1, 270579 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '81F17B971A114700B7FD3B6C9E51307A', 'B308FFAAB0434EF28E59C6AE3518A54B', '子公司', 'sub_company', 1, NULL, NULL, 0, 240992 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'E9302BB1D5C74FC6999954EF535949AA', 'B3E189FB7FAB442D873B05AB1B66CCCF', '非密', 'NON_SECRET', 1, NULL, NULL, 1, 270587 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6A4F9F6C7FCF4EAC8479AE6A79458541', 'B46F1BBB156D4C59BE8D03C8F181A44A', '分类', '1', 1, NULL, NULL, 1, 82001 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '434B00E325504AEC9B2E8D2DB00BA123', 'B672237B11204656B8BB631E2D6EE4F2', '全部', '1', 1, NULL, NULL, 1, 81875 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8C94DDC67C2840D8871BB630E008FFCB', 'BBC3E957ED994B7691BAB8A3467D5EE2', '流程环节', 'procUnit', 1, NULL, NULL, 3, 81953 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8C94DDC67C2840D8871BB630E008FFCB', 'BEDA643D8AA94FFAADA7B94F131F112D', '流程', 'proc', 1, NULL, NULL, 2, 81952 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8E9E997A5FEB4287B30E6A6A65D83817', 'BFA34DD0FAEE43878861C3D560D95D4E', 'datetime', '4', 1, NULL, NULL, NULL, 84018 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '768E1E81BCF14DC78FC843EDBA4CF800', 'BFD7F2F0C54041CA94EF0F37F216C896', '启用', '1', 1, NULL, NULL, 1, 117126 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', 'C75C82B7E3444BA792691679C1BBAACF', 'date', '4', 1, NULL, NULL, 4, 81968 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9D9822AA3DFF4B0FB84DEE0D501D1276', 'C7E2E003FF15405E8A964E63AF99DB24', '用户', '1', 1, NULL, NULL, 2, 81772 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7D48D910A4B840E8908FC572ABCC7B71', 'C89BC2CD43284F7EA1A0F70AD47DF6CF', '文件夹', '1', 1, NULL, NULL, 0, 155941 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '10859', 'CA8F1057C95F4B54AE320E6DF7D06E68', '获取预算申报管理人', 'findBmManagers(@declareId,\'auditorType\')', 1, NULL, NULL, 21, 381648 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', 'CDEB6C8E3DC846998A28FE4D7FDEC357', '董事长', '7', - 1, NULL, NULL, 1, 31514 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', 'CFA3CF5DC5874E62B07541C286105C48', 'AttachmentConfiguration,folderId', '21', 1, NULL, NULL, 21, 98088 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9059', 'D164DA8CFCFC482E9FADC3CC99EE25F8', '总经理', '6', - 1, NULL, NULL, 2, 31513 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', 'D3C311CA829B43AE8D180BEFCDA40CC0', '通过', '1', 1, NULL, NULL, 0, 252236 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', 'D485AB0B6C7A4880BED8039CFC8E12C4', 'SysDictionary,folderId', '9', 1, NULL, NULL, 9, 98085 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '3C89377D4E384DD6876B38FEF86B7041', 'D4BB7C933CD04D47A3E42CE4DE05A87D', '启用', '1', 1, NULL, NULL, 1, 81957 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '9D9822AA3DFF4B0FB84DEE0D501D1276', 'D56FD68CBDA64A05A0E3BC162365FA99', '系统', '0', 1, NULL, NULL, 1, 81771 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '768E1E81BCF14DC78FC843EDBA4CF800', 'D5AD8F18345941EB9606B860A3887025', '禁用', '0', 1, NULL, NULL, 2, 117128 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '31CD452985D940D6BFF9FF9F97C4B465', 'D83BA9FB31674B109A5D1C8A1DD4409C', 'TA软件销售项目', '5', 1, NULL, NULL, 5, 253334 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'F7D3A2AD863B48FC87F942D2A2C8125B', 'DDCE85728D9C44CB9093D71F5D06B7A0', '内部', 'INTERIOR', 1, NULL, NULL, NULL, 103452 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', 'E07738AA181B444387B918D97AA2B3A1', 'datetime', '5', 1, NULL, NULL, 5, 81969 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', 'E1078977E48B480CB457797A1FE5CA60', '星期二', '2', 1, NULL, NULL, 2, 5377 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8E9E997A5FEB4287B30E6A6A65D83817', 'E135EA3E34B149D1B7B08F55CB7F854B', 'string', '1', 1, NULL, NULL, NULL, 84015 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'ACCCC370E59E4F74B19B677D03114FA0', 'E327B8C5EF554B248F43706380157240', '集合', '2', 1, NULL, NULL, 2, 81978 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '4188EF96566546A1951A1044B40348E6', 'E3A009A8BA7E4129A5FE6B097016980B', 'FlexFieldBizGroup,folderId', '6', 1, NULL, NULL, 6, 107920 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'D5A465C4B9B643FD8D7EC6B94E90AF21', 'E975D8BD284247019395AC8D32F1125D', '启用', '1', 1, NULL, NULL, 3, 81781 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6554A38109EA495786ECA295F53DEAAA', 'EAFBADDD3D27464790A709040F4FBDEA', '已婚', '已婚', 1, '已婚', NULL, 2, 270574 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '6A4F9F6C7FCF4EAC8479AE6A79458541', 'EC547FC1B27648E4A3875A07C87069D2', '职能', '2', 1, NULL, NULL, 2, 82002 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '7AD5E72E0DEB43AFAC397454A3D97799', 'EF7F0D94C69D46298400F5C224806445', '星期三', '3', 1, NULL, NULL, 3, 5378 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '97689C902E99423DBA3E1D3E026C5FEC', 'F2BBAD7E581843FCA1F628994AFFFCAC', '未填写', '0', 1, NULL, NULL, 0, 252235 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '93C4964B13314B538DF44FC8AD3D3F90', 'F647B80D63864C57B8F47A6455A8BC2C', 'checkbox', '7', 1, NULL, NULL, 7, 81971 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( '8C850449D9314D70A446361BC291150E', 'F755C2736A6F4337807C9C9B2E99599A', '自定义', '1', 1, NULL, NULL, 2, 81989 );
INSERT INTO `sa_dictionarydetail`
VALUES
	( 'E9302BB1D5C74FC6999954EF535949AA', 'FAAE09463918400DBE02D637873D9180', '核心', 'CORE', 1, NULL, NULL, 4, 270590 );-- ----------------------------
-- Table structure for sa_excelimportlog
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_excelimportlog`;
CREATE TABLE `sa_excelimportlog` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`TEMPLATE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BATCH_NUMBER` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FILE_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ERROR_CODE` INT ( 11 ) NULL DEFAULT NULL,
`ERROR_MESSAGE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ORGAN_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORGAN_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_DATE` datetime  NULL DEFAULT NULL,
`ERROR_COUNT` BIGINT ( 20 ) NULL DEFAULT NULL,
`SUCCESS_COUNT` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_excelimportlog
-- ----------------------------
-- ----------------------------
-- Table structure for sa_excelimporttemplate
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_excelimporttemplate`;
CREATE TABLE `sa_excelimporttemplate` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`TABLE_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`PROCEDURE_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_DATE` datetime  NULL DEFAULT NULL,
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_excelimporttemplate
-- ----------------------------
INSERT INTO `sa_excelimporttemplate`
VALUES
	( '6B4890DFB9BEB143E050007F01005CBD', '6B480BBA27C2FF74E050007F010057E3', 'i18nExcelImp', '国际化资源导入', 'TMP_SA_I18NPROPERTIES', 'i18nImportApplication', '2018-05-03 14:48:21', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 1, 3229291, NULL, NULL );-- ----------------------------
-- Table structure for sa_excelimporttemplatedetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_excelimporttemplatedetail`;
CREATE TABLE `sa_excelimporttemplatedetail` (
`TEMPLATE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`EXCEL_COLUMN_NUMBER` BIGINT ( 20 ) NULL DEFAULT NULL,
`EXCEL_COLUMN_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`COLUMN_NAME` VARCHAR ( 60 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`COLUMN_DESCRIPTION` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`LENGTH` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_excelimporttemplatedetail
-- ----------------------------
INSERT INTO `sa_excelimporttemplatedetail`
VALUES
	( '6B4890DFB9BEB143E050007F01005CBD', '6B4890DFB9BFB143E050007F01005CBD', 1, '编码', 'code', NULL, NULL, NULL, 1314672 );
INSERT INTO `sa_excelimporttemplatedetail`
VALUES
	( '6B4890DFB9BEB143E050007F01005CBD', '6B4890DFB9C0B143E050007F01005CBD', 2, '中文', 'value1', NULL, NULL, NULL, 1314673 );
INSERT INTO `sa_excelimporttemplatedetail`
VALUES
	( '6B4890DFB9BEB143E050007F01005CBD', '6B4890DFB9C1B143E050007F01005CBD', 3, '英文', 'value2', NULL, NULL, NULL, 1314674 );-- ----------------------------
-- Table structure for sa_flexfieldbizgroup
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_flexfieldbizgroup`;
CREATE TABLE `sa_flexfieldbizgroup` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VISIBLE` INT ( 11 ) NULL DEFAULT NULL,
`BIZ_CODE` VARCHAR ( 60 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`IS_DETAIL_TABLE` INT ( 11 ) NULL DEFAULT NULL,
`UI_STYLE` INT ( 11 ) NULL DEFAULT NULL,
`COLS` INT ( 11 ) NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`MODEL_FILE_PATH` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ENTITY_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SHOW_MODEL` INT ( 11 ) NULL DEFAULT NULL,
`TABLE_LAYOUT` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_flexfieldbizgroupfield
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_flexfieldbizgroupfield`;
CREATE TABLE `sa_flexfieldbizgroupfield` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FLEXFIELDBIZGROUP_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FLEXFIELDDEFINITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`NULLABLE` INT ( 11 ) NULL DEFAULT NULL,
`CONTROL_WIDTH` INT ( 11 ) NULL DEFAULT NULL,
`CONTROL_HEIGHT` INT ( 11 ) NULL DEFAULT NULL,
`READ_ONLY` INT ( 11 ) NULL DEFAULT NULL,
`VISIBLE` INT ( 11 ) NULL DEFAULT NULL,
`NEW_LINE` INT ( 11 ) NULL DEFAULT NULL,
`LABEL_WIDTH` INT ( 11 ) NULL DEFAULT NULL,
`COL_SPAN` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_flexfielddefinition
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_flexfielddefinition`;
CREATE TABLE `sa_flexfielddefinition` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FIELD_NAME` VARCHAR ( 60 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DESCRIPTION` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FIELD_TYPE` VARCHAR ( 40 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FIELD_LENGTH` INT ( 11 ) NULL DEFAULT NULL,
`FIELD_PRECISION` INT ( 11 ) NULL DEFAULT NULL,
`NULLABLE` INT ( 11 ) NULL DEFAULT NULL,
`DEFAULT_VALUE` VARCHAR ( 100 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`MIN_VALUE` DECIMAL ( 18, 2 ) NULL DEFAULT NULL,
`MAX_VALUE` DECIMAL ( 18, 2 ) NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CONTROL_TYPE` INT ( 11 ) NULL DEFAULT NULL,
`CONTROL_WIDTH` INT ( 11 ) NULL DEFAULT NULL,
`CONTROL_HEIGHT` INT ( 11 ) NULL DEFAULT NULL,
`DATA_SOURCE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DATA_SOURCE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`READ_ONLY` INT ( 11 ) NULL DEFAULT NULL,
`VISIBLE` INT ( 11 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`NEW_LINE` INT ( 11 ) NULL DEFAULT NULL,
`LABEL_WIDTH` INT ( 11 ) NULL DEFAULT NULL,
`COL_SPAN` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_flexfieldstorage
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_flexfieldstorage`;
CREATE TABLE `sa_flexfieldstorage` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`BIZ_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`BIZ_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DETAIL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FLEXFIELDDEFINITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FIELD_VALUE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FLEXFIELDGROUP_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOOK_UP_VALUE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FIELD_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_historicsession
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_historicsession`;
CREATE TABLE `sa_historicsession` (
`ID` VARCHAR ( 36 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ORGAN_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORGAN_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CLIENT_IP` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SERVER_IP` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGIN_DATE` datetime  NULL DEFAULT NULL,
`LOGOUT_DATE` datetime  NULL DEFAULT NULL,
`LOGOUT_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGOUT_PERSON_MEMEBER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGOUT_PERSON_MEMEBER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SESSION_ID` VARCHAR ( 36 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGIN_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ERROR_MESSAGE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_historicsession
-- ----------------------------
-- ----------------------------
-- Table structure for sa_i18nproperties
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_i18nproperties`;
CREATE TABLE `sa_i18nproperties` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'i18n 编码',
`VALUE1` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '语言值1(如中文显示数据)',
`VALUE2` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '语言值2(如英文显示数据)',
`VALUE3` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '语言值3',
`VALUE4` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '语言值4',
`VALUE5` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '语言值5',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类别',
`RESOURCE_KIND` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源类型  数据字典i18nResourceKind',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据库数据国际化支持' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_i18nproperties
-- ----------------------------
INSERT INTO `sa_i18nproperties`
VALUES
	( '00F1D6BAD89240AB9198AC2AA1915CA3', 'function.ApprovalHandlerKind.description', '审批处理人类别', 'Approval Handler Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '014F220D314E4987A6D89D5489110B26', 'dictionary.SynStatus.0', '失败', 'Failed', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '023A3EC04DED4ABD919B9EA400A30F71', 'function.ManagementQueryForManager.description', '查询管理者', 'Manager Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '024856F9A5004B35AEDB9A0194AE4239', 'dictionary.hxPaymentFlag.1', '审批完成', 'Approval Done', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0315AEC2AF4D41658AF56A8F565AE526', 'dictionary.businessKind.3', '系统集成项目', 'System Integration Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '036F3A99F73B4D0CB8708F8AE4330132', 'function.WorkflowConfiguration.description', '工作流配置', 'Workflow configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0495EFB9F9E2463C998B1DBFBD193107', 'function.SysParameter.description', '系统参数', 'System Parameter', NULL, NULL, NULL, NULL, 270806, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '05B67D7B70F843A1B28B346BFCB86088', 'dictionary.nation.37', '仡佬族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '05CA3C7681AE482AB8964CC15D0F5322', 'function.DataManage.name', '数据管理权限', 'Data Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '06196A85FA3D4B4699DC2DA23049803B', 'function.ApplicationSystem.name', '应用系统维护', 'Application System Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '061B5DA4F7984CC6B5E7F62DA22A5895', 'dictionary.processManageNodeKind.procUnit', '流程环节', 'Process Step', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '081CFEC1FAC4482789B511F9403D1377', 'dictionary.SubjectLimitType.-1', '/', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '09444138515D45C9AB25679A1551E14B', 'dictionary.PaymentMode.advance', '预付款', 'Prepayment', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '096E06AC4B264D6E9AE57C8F6AC726EB', 'dictionary.furnitureType.1', '教学用家具', 'Teaching Furniture', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '09AB6F010E7C4F33BCB116C72331EBFC', 'dictionary.nation.21', '佤族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0A7C3934C86D46DB909D47E7ED56E7C9', 'dictionary.OutSchoolType.0', '其他校区', 'Other Campuses', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0AF25B8FA7D140F091ABA58976337012', 'dictionary.i18nResourceKind.rbPersonKindApplication', '报销单出差人员类别', 'Category of Business Traveler for Reimbursement', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0B123661E0DD4CBB9F28DF00618B157E', 'dictionary.dutyLevel.1', '核心层', 'Core Level', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0BAB7FA92A3F4547B6425A3A0BB1D87A', 'dictionary.StorageType.low', '低值设备', 'Low-value Device', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0BC978CE80EA46CEB2AB68D7EFDE6A6D', 'dictionary.editControlType.10', 'treebox', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0BDDD5A2BC62472DABCC600F42037859', 'dictionary.MonetaryUnitType.SGD', '新加坡元', 'SGD', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0C454715094A41CEB03480B928A30DD2', 'dictionary.furnitureType.3', '办公用家具', 'Office Furniture', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0DD55019CC4E47B6AAF9ECC8F07DC95E', 'dictionary.weekKindId.4', '星期四', 'Thursday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0E4FB531CE2B4844924729DD38EA2A0D', 'dictionary.SecondNoticeReasonType.b', '原因二', 'Reason II', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0EAEBB684D124CFBA346F346E644E937', 'dictionary.commonTreeKind.32', 'EnterpriseTemplateFolde,parentId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0ED582F2051C4E80B7239ACABF06864C', 'dictionary.nation.29', '柯尔克孜族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0F55194B25AF4BBD92957870135710B2', 'function.SysLog.name', '系统日志', 'System Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0F73DFF1D3264012BB25734B12DB75A5', 'function.OrgFolder.name', '组织机构', 'Organization', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0FFC7948C686466FAB87C28ABBFD600C', 'dictionary.commonTreeKind.8', 'CodeBuildRule,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '0FFD92F6BFF14BEAB5B4E3D7F694DEF5', 'function.OrgType.description', '机构类型', 'Institution Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '10072EAB706C4DE38EBB2FA087344C6B', 'function.PosType.description', '岗位类型', 'Post Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '11222855F28C4D3C89F02A413B5CCACD', 'dictionary.nation.3', '回族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1132DC23FE164637B478FEDDB0839240', 'dictionary.MonetaryUnitType.JPY', '日元', 'JPY', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '12190752770F4720B98400D0909592F2', 'function.FlexField.name', '扩展字段', 'Extension Field', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1315D55C7460460C84C6C7B94DB8C98D', 'function.DatamanageDetail.description', '数据管理权限资源维护', 'Data Management authority resource', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1319F8F280094D049B2351A5B52CAAA8', 'dictionary.certificateKind.6', '香港特区护照/身份证明', 'Hong Kong SAR Passport/ID', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '13B2100C5D864516BB163101C0C9B022', 'function.OrgFolder.description', '组织机构', 'Organization', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '13C4A4A2C8BF4FEF86118FEE7FB73308', 'dictionary.dataSourceKind.2', '集合', 'Collection', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '14B785631AE240E4839EA9C99F765D70', 'dictionary.SignEvaluationType.purchasePerson', '用户评价', 'Comment of User', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '15A270BB2CF74E87A8C3575BEE996394', 'dictionary.nation.9', '布依族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '15B2AA4507F04D1CAF3595D657CA16BD', 'dictionary.commonTreeKind.4', 'Role,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '15BC47213AA7422EBA6A99EE2913368D', 'dictionary.commonTreeKind.2', 'OrgType,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '16DCA1C5772B484BA6483FD6DD76FB61', 'function.ProcUnitHandlerQuery.description', '流程处理人查询', 'Process Handler Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1717A1A8C2474DAD8673CCFC9F77A67D', 'function.ApprovalHandlerKind.name', '审批处理人类别', 'Approval Handler Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '172A73C17D0D4B94A7B480231FEF48A8', 'dictionary.SubjectTypeLevel.root', '根节点', 'Root Node', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '17C798B56A89480D8910E9BA68B47DA1', 'dictionary.serviceFunction.logistics', '后勤', 'Back Office', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '17E3158E48D44EFDBAB07A2BE3A06394', 'function.ManagementType.description', '业务权限管理类别', 'Category of Transaction Authority Mgmt', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '19061A7546814ED5BBFEA9AC83A4BDBC', 'dictionary.hxBiddingSource.2', '国外', 'Overseas', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '192A7DFC836547FDBF8F75C408FE41D1', 'dictionary.commonTreeKind.60', 'BmDataCollectionKind,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '193287894A79454D946BA2B42612F6E2', 'function.PurchaseApprovalManage.description', '业务单据管理', 'Transaction Document Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '19EA114B13874F4BADB4DC708B030931', 'dictionary.StorageType.donate', '捐赠设备', 'Donated Device', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1AB2329216874EE9A68273B27DA6D873', 'function.PersonLoginLimit.description', '登录限制', 'Login Limit', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1AD3F33461D74A38B644AE0343A2B05A', 'function.SecurityPolicy.name', '安全策略', 'Security Policy', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1B3E404E656D48A08D7442166AFC14D0', 'dictionary.BiddingResultType.fail', '失败', 'Failed', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1C108C05DEEF4E468DCD998A7A4994DE', 'dictionary.SubjectTypeLevel.base', '门类', 'Category', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1CF46D85145042FB93037AA99C0AA3DF', 'dictionary.taskKind.makeACopyFor', '抄送', 'Copy to', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1CFAA562224945C8A5DF45C00D3926F1', 'dictionary.roleKindId.superAdministrator', '超级管理员', 'Super Administrator', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1D4C4D6A411C416BA3623198C399672B', 'dictionary.editControlType.5', 'datetime', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1DBC945E0616448FA14E4CDFAEC5EF63', 'dictionary.FunctionPageName.pmLoseBill', '资产报失单页面', 'Asset Loss Report', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1F2DD7F0A344403890D8B44C9C37191D', 'dictionary.handleResult.4', '打回', 'Refused', NULL, NULL, NULL, NULL, 270795, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1F4D8793A0B74C1EB2C342205C163241', 'dictionary.handleResult.3', '已阅', 'Read', NULL, NULL, NULL, NULL, 270794, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1F4E753839744886BB5CF1CB0D1A05C9', 'dictionary.deptLevel.xt', '系统', 'System', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1F665A05FA2046F1A3583A2C1CF6F571', 'function.LoginLog.name', '登陆日志', 'Login Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '1F70ED457C8F472184D37E1C2E781236', 'function.OpDataKind.description', '权限资源类型定义', 'Permission resource type definition', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '206E4C209C4B427A949D11CF4474EA44', 'function.CodeBuildRule.name', '单据编号规则', 'Document Numbering Rule', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2161994DB00640C1B398E52F4C131A42', 'dictionary.MonetaryUnitType.BEF', '比利时法郎', 'BEF', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '219F264BF71847D5AAD8B969E80E6085', 'dictionary.nation.17', '哈萨克族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '21C2CF80DB9642B199A9AD4ED20F0D42', 'dictionary.nation.49', '京族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '21F54272E05443BEB5BC23659A1DFE95', 'dictionary.status.0', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2203296BB92742809BD40ABA42D07934', 'dictionary.dutyLevel.3', '中层', 'Middle Level', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2285549FCC014D178A754071BD5F94E5', 'dictionary.nation.23', '高山族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '229D4B1291794510BCFD2B56E0826109', 'function.DataManagement.name', '管理权限授权', 'Authorization from Data Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '22B98E0F56164459BC5B14C0F9F1EEC9', 'function.SysDictionary.description', '系统字典', 'System Dictionary', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '230D5F19827942C3B85ED8999D37D9E0', 'dictionary.businessKind.2', '商业数据分析项目', 'Commercial Data Analysis Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '238685830DD94C4795F7EE54E44CE169', 'dictionary.subjectType.43', '强电', 'HV', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '24643FC0F3314545A9DDBE20C62D9207', 'function.taskInfoCount.description', '流程任务统计', 'Process Task Statistics', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2520CEDC521D4A4DA480AC83D085F2EF', 'dictionary.commonTreeKind.55', 'I18nproperties,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '269FE1029E0E43F1A6E139B5BA54492B', 'function.ExcelImport.description', '导入数据', 'Import Data', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '275BABF9B767465E9F2E60EC71A3B6F5', 'function.BizManagementFolder.description', '业务管理权限', 'Service Administrative Privilege', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '27872AA1281945A390C7D9ACF58C9493', 'dictionary.commonTreeKind.21', 'AttachmentConfiguration,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '279BC8CBDD7241BF963357279676B8E5', 'dictionary.projectType.sporadicProject', '零星项目', 'Sporadic Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2848B10443C941A1AA230189884B2B99', 'dictionary.ConfigFileType.js', 'JS', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '286369A8C99A490FA7C41EC1E9257423', 'function.FlowTaskManagement.description', '流程任务维护', 'Process Task Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '28B286C6738E4360BB9AD9C828FCDE01', 'dictionary.nation.20', '傈僳族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2921BA5FDCFE4C618ED33A7642E2402E', 'dictionary.SecondNoticeReasonType.a', '原因一', 'Reason I', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '29D683E5D5C041B0A9CB7A2C5C97C3A7', 'parameter.system.copyright', '版权所有：XXXX 信息科技有限责任公司', 'All rights reserved. XXXX Information Technology Co., Ltd.', NULL, NULL, NULL, NULL, 270804, '31D05A903AB9462CAD701B4F92D899C2', NULL );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2A0D2553ED294CA8981F25C43CA068F1', 'function.SysConfiguration.description', '系统配置', 'System Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2A33E71B87F641C68E0AAAE0C85DB734', 'dictionary.MonetaryUnitType.DEM', '德国马克', 'DEM', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2AAFD82360EC43169C54B67ED2F45EC3', 'dictionary.UnitType.PC', '件', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2B8D9E9E7DD2470EBAFB9DEC971FB6A0', 'dictionary.orgKindStatus.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2BD39D3C5D0D409A9AC83EA627323F5C', 'dictionary.MonetaryUnitType.PHP', '菲律宾比索', 'PHP', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2BD7F544BF7C4B96B32963B81F87C872', 'dictionary.StorageType.build', '在建设备', 'In-process Device', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2CC30915791E4E2E8E2968F67A45F98B', 'function.BPMCBizFunction.name', '业务功能分组', 'Transaction Function Group', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2D964B36DA31449CACD4B6CC731C7171', 'dictionary.i18nResourceKind.psProjectKindApplication', '项目类型', 'Project Type', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2DE7426B05D94D76B54E7D1192A12AC8', 'dictionary.UnitType.FU', '幅', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2E00704F15F74CC991464B04A1429203', 'dictionary.treeNodeKind.1', '文件夹', 'Folder', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2EDC3DA50E384E89B1C55BCA5684967C', 'function.ManagementType.name', '业务权限管理类别', 'Category of Transaction Authority Mgmt', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2F1BD22A36644382A6DFF5A1255A421C', 'function.TaskQuery.name', '流程任务查询', 'Process Task Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2F3F7B2E30624373BAE2EFC9C99505EE', 'dictionary.nation.47', '保安族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2F7A63AC9FB24787804A4F7971E84BC9', 'dictionary.education.本科', '本科', 'Undergraduate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '2F83F09A28FA4E72A209CAB3A2A20C10', 'function.OrgTemplate.description', '机构模板', 'Institution Template', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '300387B7FBDD4AD496C7A00D405153F8', 'dictionary.agentStatus.0', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '31D849AD153C425D97380479AD0E839E', 'dictionary.UnitType.WEI', '位', 'Person', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3234CF38826845B5A11AF80084A0C88F', 'dictionary.showModel.1', '表格', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3281B2A8593540D98F06B9BDA73D14B7', 'dictionary.nation.25', '水族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '32DE7ECD49524745A89F8084A58FC665', 'dictionary.managerFun.findApplicant()', '查找流程实例申请人', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '33CB29566D3E4737B4EDF8672811696A', 'dictionary.MonetaryUnitType.THB', '泰国铢', 'THB', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '33D589B02E454413A72AF1775C04B4E1', 'function.DatamanageDetail.name', '管理权限资源维护', 'Management authority resource', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '342545110CD14ED883646862BE070BA1', 'dictionary.serviceFunction.scientific', '科研', 'Research', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '348AF650A9FF45A397E693B54113AA10', 'dictionary.fieldAuthority.noaccess', '无权限', 'No Authority', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '358282EF94814858801E4B291E6BDEA0', 'dictionary.i18nResourceKind.rbPurchasingKindApplication', '采购报销类型', 'Type of Purchase for Reimbursement', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '363A2ECF5F3B43DDA0DFE273DAF8AE11', 'function.ProcApprovaRuleConfig.description', '流程审批规则配置', 'Configure Process Approval Rules', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3685BC47FD3F4636813AAB96FCEAAA81', 'dictionary.MonetaryUnitType.HKD', '港元', 'HKD', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '386079EF95A54C519864F2099350C7F5', 'dictionary.OutSchoolType.1', '校外', 'Off-campus', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '388A346DAD5D4D1A8DABAE2063023AF0', 'dictionary.PaymentMode.bond', '保证金', 'Security Deposit', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '38DB2394FEE34EA287670390BE041170', 'dictionary.serviceFunction.teaching', '教学', 'Teaching', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '391AAB1946904A238B216612850812D7', 'dictionary.MonetaryUnitType.EUR', '欧元', 'EUR', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3A062C2D628440139133693E420AD7DA', 'dictionary.orgAdminKind.two', '分公司', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3A31E40B635946DD8C982F8849BB9185', 'function.ProcApprovalElementConfig.description', '流程审批要素配置', 'Configure Process Approval Element', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3A52D39D912F419A9A95103BD66C8DC3', 'function.BizDataConfiguration.description', '业务数据维护', 'Business Data Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3A551E20FFB14C13A37240AE735684DB', 'dictionary.nation.48', '裕固族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3B0556C614FE449F9B6829BE84814A40', 'dictionary.UnitType.ZU', '组', 'Set', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3B33127F9CA54CB3BB6A2C5FC39D5872', 'dictionary.securityGrade.SECRET', '秘密', 'Secret', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3B36C5469A2240B68CBE8F831339F59F', 'function.ErrorLoginLog.description', '无效人员登录日志', 'Invalid Logon Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3B6487144D4148998A92361D344938A5', 'function.DataImport.name', '数据导入', 'Data Import', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3C71069313E44F94B1747D87F3CF5FF3', 'dictionary.ConfigFileType.jsp', 'JSP', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3CBE86B7F3E044CFA7455416DD499125', 'dictionary.UnitType.CS', '箱', 'Case', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3CDC0780BCDB4C88BD81E30045377E0B', 'function.BizClassificationConfiguration.description', '业务分类配置', 'Business Classification Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3D217EE29F1D4DA1BA091869EE9ACC0E', 'dictionary.PaymentMode.storage', '结算款', 'Settlement Amount', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3D4DF61CBD254CB7B94CA087CD43281E', 'function.Coordination.description', '协同平台', 'Coordination Platform', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3DD8D8CFD03C49C6814C5651C99D1D13', 'dictionary.procAgentKind.1', '全部', 'All', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3E3453F287DA4FA9B8E1F28B1A206D04', 'dictionary.fieldType.1', '子集', 'Subset', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3E67016ACA53406B8F31F691D9B42B0C', 'dictionary.MonetaryUnitType.ITL', '意大利里拉', 'ITL', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3E8227F49B7F4BA1B9566CC3AB33FF9C', 'dictionary.nation.24', '拉祜族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3EDE395D041D437E9EA60653519B5051', 'dictionary.MonetaryUnitType.FIM', '芬兰马克', 'FIM', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3F22BA64870142FFA7A7150225BBF1C6', 'dictionary.commonTreeKind.50', 'ApprovalRejectedReason,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3F3829E3EBCC41A0B5F1D3090A2B3A92', 'function.FunctionPermission.description', '功能权限', 'Function Authority', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '3FBE4DD0DF72430EAC06214CFF2CF0F5', 'dictionary.rolePersonKind.other', '其他', 'Others', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4011A3C638F548758BA254F48A93405A', 'function.DataImport.description', '数据导入', 'Data Import', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '401FF5CCD01E4982A5583099D955DEB6', 'dictionary.hxBaseManageTypes.hxFinanceDirector', '财务主管', 'Finance Director', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '402F29D62A7440A2B05D07AABC1470E5', 'dictionary.FunctionType.b', '物质科学', 'Material Science', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4040AF41D7A541909B4E38CEEA6098C2', 'dictionary.UnitType.JIE', '节', 'Segment', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4142867CA5A34EB7BB22EF0AC494FC31', 'dictionary.taskKind.remind', '催办', 'Remind', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '41D871C934AC4764BF30E667284CBDE1', 'function.BizConfiguration.name', '业务配置', 'Service Configurations', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4315F0DCA2194D5AA1BB9A1F410A0634', 'dictionary.dutyLevel.2', '中高层', 'Middle to High Level', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '432BD00069734885B417E6A512FAE81C', 'function.FlexFieldGroup.name', '扩展字段分组', 'Extension Field Grouping', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4353B9CAF2354D7DB4C97CD8598ACCEF', 'dictionary.dictionaryStatus.-1', '草稿', 'Draft', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4388E5D6F97A4E6D96D5442FF64806CE', 'dictionary.MonetaryUnitType.INR', '印度卢比', 'INR', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '44163A62938B42588CF4085C3F223AD1', 'function.TMAuthorize.name', '三员授权', 'Three Authorization', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '451F3968FCD248CCA20447464462D908', 'function.ErrorLoginLog.name', '无效人员登录日志', 'Invalid Logon Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '46267EB7A3C64CAB992EE5D115BF4799', 'dictionary.MonetaryUnitType.CAD', '加拿大元', 'CAD', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '467537E0B7044DA5B97E6776F13E98A6', 'dictionary.scopeKind.1', '本组织', 'Default Organization', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '472A03CB3461457F8A4257FDC1DD719A', 'function.BaseManagementType.description', '基础管理权限类别', 'Basic Management Authority Category', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '476A9EC6AD124C72968A0A375748B3DE', 'dictionary.subjectType.44', '弱电', 'LV', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '477F4643F0DF4A76A68429BF5AAAAC7B', 'dictionary.taskKind.task', '任务', 'Task', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '482039A1281F4CF79D1E03DF61C398F5', 'dictionary.securityGrade.NON_SECRET', '非密', 'Not Classified', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '49A88A1000C74A70AD4F36F536478D30', 'function.DataManageType.description', '数据管理权限定义', 'Define Type of Data Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4A8BC71F827444688EB6D6C67C1FAF68', 'dictionary.certificateKind.7', '澳门特区护照/身份证明', 'Macao SAR Passport/ID', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4A99E479CAF24E5D96EBC098404CD89B', 'dictionary.nation.51', '独龙族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4B2D3F42616142BC8716C75124BCBF81', 'dictionary.handleResult.5', '系统完成', 'System Finishes', NULL, NULL, NULL, NULL, 270796, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4B9079742EFD4E21A7ADE35F8A2E087F', 'dictionary.processManageStatus.2', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4BB141EE5B794911A3AC83927653F38D', 'dictionary.supplierSelectMode.1', '招标', 'Tendering', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4C0C6B8CF6BB41A88CB3C4D809384AB9', 'dictionary.bizManagementNodeKind.1', '分类', 'Sort', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4C20072A59AB4E3AB72FFD25DEE91B77', 'dictionary.nation.30', '土族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4C9C91FE3B704A198AB3B641C0EC963A', 'dictionary.dictionaryKind.1', '用户', 'User', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4CA0EBF1F53E49669A3E50335BBAB434', 'dictionary.nation.19', '黎族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4CBF9FE0B9844F0A9DCB28CE99AD24FA', 'dictionary.LanguageType.ch', '中文', '中文', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4D71F4856B884E9182C0B796D67762F8', 'dictionary.nation.45', '鄂温克族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4D7B4543C66647A09331C1FB5FB8332E', 'function.OpDataKind.name', '权限资源类型定义', 'Permission resource type definition', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4D7CA7BCE22C408DB430891B456D63C3', 'function.ManagementQueryForSubordination.name', '查询下属', 'Subordinate Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4E0DF3F53D7D48EEB6DCF46B93033152', 'dictionary.roleKindId.securityGuard', '安全员', 'Security Officer', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4E45F4459C8245A393068071D7BF50EA', 'dictionary.commonTreeKind.31', 'Template,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '4EC5F2F8D4074C66B55B511CEA53D050', 'dictionary.handleResult.1', '通过', 'Approved', NULL, NULL, NULL, NULL, 885149, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5013C216F5C24F73A01DA885807554C6', 'dictionary.ConfigFileType.css', 'CSS', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '504165B274F542A88471D3EC4414D28B', 'dictionary.hxBaseManageTypes.hxTenderManage', '招标主管', 'Tendering Director', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '506ABC45683C4001A6F9B8D6F7AEE13D', 'dictionary.EvaluateResultType.fail', '被质疑', 'Questioned', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '50D015153D204FB58BD5D924D3044BE8', 'dictionary.ArgumentOperateStatus.3', '审批通过', 'Approved', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '50E77A505D60455993E6B01F0CD64A3F', 'dictionary.commonTreeKind.3', 'OrgType,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '514512D0969B4449AD95EBA78D08EBB5', 'dictionary.PaymentMode.openText', '开口文本付款', 'Open Text Payment', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '519175E981984503BB36CE4F90860228', 'dictionary.uiElementStatus.0', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '51EEFDA2CC5444AAA5823BDB2C509A37', 'dictionary.dictionaryStatus.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '529BFE148B404FA0884D9119667B82AA', 'dictionary.hxBaseManageTypes.hxFinancialSecretary', '财务秘书', 'Financial Secretary', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '52C9E357AA454FF6B50FCBEFB180B8CA', 'dictionary.certificateKind.8', '台湾居民来往大陆通行证', 'Mainland Travel Permit for Taiwan Residents', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '52D57485675B47D0B09C1B3DBBDF6829', 'function.BizConfiguration.description', '业务配置', 'Service Configurations', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5391E6A42041430C8B4EE4D93BA860ED', 'dictionary.RightCertificateType.notDealRight2', '暂未办理土地权利证的批文2', 'Land Title Deed Not Approved 2', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '544CEA0651474CB0AC2D9DD40A093EB4', 'dictionary.hxStandardKind.1', '标准', 'Standard', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '552CD6022F5842249870161F1D09B0C5', 'function.Func.name', '功能管理', 'Function Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '55699E8C87B645BE8419F9B00F917DB8', 'dictionary.deptLevel.zt', '总体', 'Population', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '55E283B5746A46A490413A51D315D2D6', 'dictionary.nation.46', '崩龙族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '56A0FF9B24064CFDB387D7DFF4B09BE8', 'dictionary.certificateKind.A', '护照', 'Passport', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '56FDB5892EF34BA597EDFC06F4E40838', 'dictionary.serviceFunction.environment', '环境', 'Environment', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '57D5005FBDC1491DA9CFEEB0C98A2CBB', 'dictionary.BiddingRound.2', '第二轮', 'Round 2', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '57F4B51DA60049C49C7A4437533B1F44', 'function.Coordination.name', '协同平台', 'Coordination Platform', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '58C11B65463646A9B7F3B1339ED291F1', 'dictionary.UnitType.TAO', '套', 'Set', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5927A013B2024138881022927E6B5320', 'dictionary.UnitType.PAA', '对', 'Pair', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5999FF7E318E4C18BBAA461A45B95110', 'dictionary.MonetaryUnitType.ATS', '奥地利先令', 'ATS', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5A3AAEA26EB74B358B85B415427B3857', 'function.BizDataConfiguration.name', '业务数据维护', 'Business Data Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5A8A7939318D4259B4BDA5BA51CE045E', 'dictionary.businessKind.6', '其它软件销售项目', 'Other Software Sales Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5AD7765F97FC4C0CA125DE1BF621F251', 'dictionary.taskKind.notice', '通知', 'Notice', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5AEF378D5A454832A3CDA89A5F9081BB', 'dictionary.i18nResourceKind.rbSettlementKindApplication', '结算类型', 'Settlement Type', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5B10D6B533074C9B83F97A629959FA12', 'function.LoginLog.description', '登陆日志', 'Login Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5B5658E0380743439805D900ADF711B6', 'dictionary.i18nResourceKind.dictionaryI18nInitApplication', '系统字典', 'System Dictionary', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5B7AAF04D7D14E98A33172BDEDF36419', 'function.TaskQuery.description', '流程任务查询', 'Process Task Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5BD7777EE462493F991B44CDD0DA5448', 'dictionary.nation.26', '东乡族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5D4401CCE6254D84882C838DC7E6D8CF', 'function.ExcelImport.name', '导入数据', 'Import Data', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5D57E803D967460D82243E917A288D53', 'function.FlexFieldDefine.name', '扩展字段定义', 'Extension Field Definition', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5DDCA26EF78C45CDA06F59C33BD092D8', 'function.DataManage.description', '数据管理权限', 'Data Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5E0FD5C9417B4941AC6EA30DB4BF3140', 'attachment.document.circulateFile', '传阅文件', 'Circulate document', NULL, NULL, NULL, NULL, 3212230, '9A8C89F070FB4B55BDDA40E3B66D2835', 'attachmentConfigI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5E1584E283E94B0CBAEFA86F5072C795', 'function.SysConfiguration.name', '系统配置', 'System Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5E87760FD2934BCA97928DFD1FB0C02F', 'dictionary.ApprovalStatus.-1', '终止', 'Terminated', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5F1DF5080DEE4D288A703861E150AA95', 'dictionary.StorageType.soft', '软件', 'Software', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '5FBFF18A15824176B52A30904D6912BD', 'function.OrgType.name', '机构类型', 'Institution Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6029E5E684344296BF567B984DD8902C', 'function.OrgPropertyDefinition.name', '组织机构属性定义', 'Organization Attribute Definition', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '602DCEFAE3FB4B9F924684F8B9D5C4C5', 'dictionary.MonetaryUnitType.SEK', '瑞典克朗', 'SEK', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6034BEF1846C4E74B9F2D7CD2ED93E44', 'dictionary.i18nResourceKind.psUseAssortmentApplication', '项目管理用途分类', 'Category of Project Management Purposes', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '60BF9202B2084E27B4385C6D76474D6F', 'dictionary.editControlType.4', 'date', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '614D21116D524C2793F98B4FA5FE1D1F', 'dictionary.education.学士', '学士', 'Bachelor', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6222AF189BCE48B08602D52980461D28', 'dictionary.nation.13', '瑶族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '624845834A764017B45913760DAFB356', 'function.Agent.name', '代理管理', 'Agent Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '62935965C7614FCEAD0C51757EA0279B', 'dictionary.treeNodeKind.2', '叶节点', 'Leaf Node', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '62CD54460D6642E29CAB044C8100D24B', 'function.RecycleBin.description', '回收站', 'Recycle Bin', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '634E4000815B404188E59D9C4BC54852', 'dictionary.supplierSelectMode.2', '非招标', 'Non-Tendering', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '64864B89A8A24A1E9862F9BE64C39964', 'dictionary.nation.4', '藏族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '649BF2861A5C4FBEB8016E20B5C30748', 'dictionary.education.博士', '博士', 'Doctor', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '64B4FFFF37C145B6BD249534257E217C', 'dictionary.FunctionConfigType.module', '模块路径', 'Module Path', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '660809AA52144F6FA8DB73F3C1007BCB', 'function.TECHBaseInfo.description', '基础管理', 'Basic Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '662F4AD87517456CA1B8BBA7678DFEA1', 'dictionary.SubjectTypeLevel.small', '小类', 'Small Class', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '668C1DD041D84930BE94A20A045B837F', 'function.Org.description', '组织管理', 'Organization Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '669B830103AC43D7AAB2E99EFBEDADA2', 'dictionary.sex.2', '女', 'Female', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '67955AAD16D14CAFA5A4E1B980754D1D', 'dictionary.SignEvaluationType.businessCharge', '采购主管评价', 'Comment of Purchase Director', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '68100C68B2114F57845256246B8AE7A1', 'function.OrgPropertyDefinition.description', '组织机构属性定义', 'Organization Attribute Definition', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6867251C7A534CA28DFCD5B34460DED9', 'dictionary.nation.8', '壮族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6A2B430650EB4509B2DB4A3E11CEC9ED', 'dictionary.UnitType.BAG', '袋', 'Bag', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6A905DA169C546919376BF65E83AF918', 'dictionary.serviceFunction.other', '其他', 'Others', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6AD7BDEE0A3640209CAA2C655F0D0A58', 'dictionary.dutyLevel.5', '基层', 'Grassroots', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6B00C64D4B864A3EB64B17F26BFFAFDA', 'function.ManagementQueryForSubordination.description', '查询下属', 'Subordinate Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6B1A7885B48846F7B4EF698C8D048AB6', 'dictionary.fieldTypeList.4', 'datetime', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6C6CD6225BDB4769915686161247B404', 'function.FlowTaskManagement.name', '流程任务维护', 'Process Task Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6CBA2FE002CB46B1A3DA169FB61E6511', 'dictionary.memorandumKind.4', '用章申请', 'Stamp Use Request', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6CF24841764442B197AD271624B67F3E', 'dictionary.dataSourceKind.4', 'JSON', 'JSON', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6D4A8603C8D84D9D8D63410FBEA65F7D', 'dictionary.yesorno.0', '否', 'No', NULL, NULL, NULL, NULL, 270789, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6D669F4375E54DD98FBC8C5E38498A8D', 'dictionary.SubjectCategory.C', '服务类', 'Service', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6E6219C684924311942D516C92670480', 'dictionary.nation.6', '苗族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6EDC609A1A2644E19DA16A25990833B6', 'function.ProcApprovalRuleConfigQuery.description', '流程审批规则配置查询', 'Process Approval Rules Configuration Inquiry', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6EF9AB9C51004FD89B7D026D8634BFEC', 'function.AttachmentConfiguration.name', '附件配置', 'Accessory Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '6F8CEC7A94D24E07BD37AED4FD488034', 'dictionary.MonetaryUnitType.USD', '美元', 'USD', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '700900A0932845A49C3F7E2BFA7CE3C8', 'dictionary.maritalStatus.未婚', '未婚', 'Single', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '702419C4C08F46CCB05D6143B1FCD3F3', 'dictionary.editControlType.6', 'radio', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '704D10A2CAC7411AB1961CF32CEBD59B', 'dictionary.hxBaseManageTypes.hxBaseManage', '业务数据查询权限', 'Transaction Data Query Authority', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '70C745B9BE6F42DEA333CF1D4D02555F', 'dictionary.nation.53', '赫哲族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '71000D74A5974725AA1ADEE2BD011557', 'dictionary.fieldTypeList.1', 'string', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '710C98F55CE041AD93F637D338527AAE', 'dictionary.MonetaryUnitType.RUB', '俄罗斯卢布', 'RUB', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '713DEE63DB0C46BA9B31C2B849D4CFC8', 'dictionary.dutyLevel.4', '基层骨干', 'Grassroots Backbone', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '715DDAC60E5545F2949F9772AF3365EA', 'dictionary.nation.43', '乌孜别克族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7199F0306424467C90E5CC5B8CFABDB0', 'dictionary.hxProcurementMmethod.2', '政府采购', 'Government Purchase', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '727DC95D24004B15B6E1C9D6EC055CA8', 'function.BPMCBusinessProcess.description', '业务流程图管理', 'Transaction Flow Chart Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '73007F1458434CDB8F34BBAE5B545286', 'dictionary.ApprovalStatus.1', '有效', 'Valid', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '733643E7669040B49E2F73ACC16780FB', 'function.AttachmentConfiguration.description', '附件配置', 'Accessory Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '73942DAADAA0446283439343614DF107', 'function.PosType.name', '岗位类型', 'Post Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '742009D48D5646F389CD8754BD459EC3', 'dictionary.i18nResourceKind.psChangeKindApplication', '项目变更类型', 'Project Change Type', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7474049BA6B8469B8206C601EF5A6FEC', 'function.UserGroupMge.name', '分组管理', 'Group Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '751C6E97C3394C19A2425120F4322BE4', 'dictionary.ProjectMaterialType.zbDoc', '招标资料', 'Tender Document', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '75CD06988D0C465291E386583F6E9E2E', 'dictionary.commonTreeKind.6', 'FlexFieldBizGroup,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '77D1C43F997A4E6D902DE93D6E90C797', 'dictionary.subjectType.1', '建筑', 'Architecture', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '78DB89C56B404C0AA50821800744EBA8', 'function.OperationLog.name', '操作日志', 'Action Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '79D0562263FC480980E367E9A3D65599', 'dictionary.personSecurityGrade.COMMON', '一般', 'General', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '79D0CCA782EB44E9AD233C16020AAAD8', 'dictionary.MonetaryUnitType.NLG', '荷兰盾', 'ANG', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '79FB491C65464D6DA3DDA3E67D5E8FAB', 'dictionary.i18nResourceKind.attachmentConfigI18nInitApplication', '系统附件配置', 'System Accessory Configuration', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7A28A1A74FE741859B50840B6E17E7AD', 'dictionary.processManageNodeKind.folder', '文件夹', 'Folder', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7AEEE2E22BB1461E81D8A97B6685106A', 'dictionary.i18nLanguage.zh_CN', '中文', '中文', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7BA0E83E5DC141AA91AA784A98FF204D', 'attachment.document.receiptMain', '收文正文', 'Text of receipt', NULL, NULL, NULL, NULL, 3212237, '9A8C89F070FB4B55BDDA40E3B66D2835', 'attachmentConfigI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7BB569FD75134250808E22E24828326D', 'dictionary.scopeKind.2', '自定义组织', 'User-defined Organization', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7BF008CCB7E847F383B1FA0EABFAA655', 'dictionary.nation.42', '怒族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7C277298220D4905AE14F7B4649FB100', 'dictionary.personSecurityGrade.IMPORTANCE', '重要', 'Important', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7C8212A5FB1B4733BE5406E8A2EAC85E', 'dictionary.ArgumentOperateStatus.5', '审批不通过', 'Rejected', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7C8723B056A54578AC5B01ABC0CC812D', 'dictionary.commonTreeKind.15', 'MessageRemind,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7CF0745013054AA8B0C84B3CE903B5AB', 'dictionary.MonetaryUnitType.AUD', '澳大利亚元', 'AUD', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7E2E601947144FC392DADE9576C07D03', 'dictionary.deptLevel.First', '一级部门', 'Primary Department', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7E50D04A3AD44ED682BE726D7E129CDF', 'dictionary.certificateKind.4', '文职干部证', 'Civilian Cadres Card', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7EBDBB6DDBC94BB8AA05D26CF13A101E', 'function.ProcApprovaRuleConfig.name', '流程审批规则配置', 'Configure Process Approval Rules', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7EDD390FE4EA42E9B988CF2A454EC5EA', 'dictionary.nation.22', '畲族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7EEA23B14C7045538ABE93047AB35AE1', 'dictionary.certificateKind.B', '户口薄', 'Household Register', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7F8D83BC3F2945DC919ED10F7FA9C9AE', 'dictionary.i18nResourceKind.psSpecialtyApplication', '验收专业', 'Acceptance Specialty', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '7F9B3AE4E0124A1E9C2AB276FD52048C', 'dictionary.deptLevel.fzt', '分总体', 'Sub-population', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8090C8D92AFD48B0A0958AADAC32C1C4', 'dictionary.messageNodeType.link', '链接', 'Link', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '80E7B7F416CD4D049A47C0B91D503618', 'function.DeptType.name', '部门类型', 'Department Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '810C467842504871959EB76B876EB81A', 'dictionary.businessKind.1', 'SAP实施项目', 'SAP Implementation Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8156AFC2B58A422C811F29E9D5D05C2D', 'dictionary.permissionKind.fun', '功能权限', 'Function Authority', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '81B542116197455E90FF44DD1BAEE0F5', 'dictionary.UnitType.KUA', '块', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '81B73086CED0410083CE5774E3F75847', 'dictionary.editControlType.1', 'textbox', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '81DEB532753543EC8DC57D7708092A60', 'dictionary.StorageType.buy', '新购设备', 'Newly Purchased Device', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '81E6D70B75B74E369608C939C8C4517C', 'dictionary.SubjectLimitType.1', '★', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8207B7BA2EC5494F908387C9EA6100E5', 'dictionary.businessKind.4', 'SAP软件销售项目', 'SAP Software Sales Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '830ADCB326DF4E66B2AC80D4DF080365', 'dictionary.ProjectMaterialType.ysDoc', '预算清单', 'Budget Listing', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '835D73ED97F740A991A5EA20C493EA0B', 'dictionary.ContractType.other', '其他类合同', 'Other Contracts', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8396BD8B8720403D9DA2277DC979D862', 'function.PurchaseApprovalManage.name', '业务单据管理', 'Transaction Document Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '83F2507D386C4E40B00C7A5B5ED7CB36', 'dictionary.procAgentKind.2', '自定义流程', 'User-defined Process', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8404CC15CFDB4F3AAA5DBFC6B40AEE92', 'dictionary.MonetaryUnitType.CNY', '人民币', 'RMB', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '846F964903CB4813808535B10F02C220', 'dictionary.nation.15', '土家族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '848F4BE26E86401284AC430FF2901ED1', 'function.ProcApprovalRuleConfigQuery.name', '流程审批规则配置查询', 'Process Approval Rules Configuration Inquiry', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '85C0EDF28EC24F1198FC13CC206D9C74', 'dictionary.commonTreeKind.35', 'Customer,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '85EAECC18A4D4C9EA481DB10C45946B0', 'dictionary.nation.39', '阿昌族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '85F22658F3644E1A8F0A10FD0277FD18', 'dictionary.certificateKind.9', '境外永久居住证', 'Overseas Permanent Residence Permit', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '863987967E3849D881E19F29CC89E5F9', 'function.FlexFieldDefine.description', '扩展字段定义', 'Extension Field Definition', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8742FEB6EAF74F2D9A94C13886270562', 'dictionary.ContractType.engineering', '工程类合同', 'Engineering Contract', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '874924E223A945C7B6F2DB380E5C6FEC', 'function.ManagementQueryForManager.name', '查询管理者', 'Manager Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8865A53FBDD548EAA974AE23F12EC4ED', 'dictionary.subjectType.5', '结构', 'Structure', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '88B596D4C0954FC696EF91733D328DB4', 'dictionary.SecondNoticeReasonType.c', '原因三', 'Reason III', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '88F7D606A51E4BD8B159CDAADCD135F3', 'dictionary.nation.28', '景颇族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '898A15460C9F4EE5B9392917A9A8FCF7', 'dictionary.weekKindId.3', '星期三', 'Wednesday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '89CF25179BA642AD94DF9AE353AFB92A', 'dictionary.RightCertificateType.usageRight', '国有土地使用证', 'State-owned Land Usufruct Certificate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8A57A9E97D094BB197FFB704B6333B8F', 'dictionary.processManageNodeKind.proc', '流程', 'Flow', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8B187CA07A914D18A4174A7DA2D0E579', 'dictionary.OutOrInnerSchool.2', '校外', 'Off-campus', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8B5D9C75EF524770B4EF6A9CC598BE00', 'dictionary.furnitureType.4', '公共空间家具', 'Furniture for Public Space', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8B9814907CCF48D8BE160D6AF68479F4', 'dictionary.rolePersonKind.student', '学生', 'Student', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8BD84413108546F681B46627C5F74F4A', 'dictionary.orgFunctionNodeKind.1', '分类', 'Sort', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8BE7E0C4597F48E9889A2E9999A57DE6', 'function.SysLog.description', '系统日志', 'System Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8C2FC1EF99404FC8B7A729CEA6B5D834', 'function.DeptType.description', '部门类型', 'Department Type', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8D87536722D54157B0316E122840D48F', 'dictionary.SubjectLimitType.2', '▲', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8D8A3747294A4FD8BD187E1ECFB0FC29', 'function.Permission.description', '权限管理', 'Authority Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8E90F79DB5E944588654FF56BE31B5ED', 'dictionary.nation.18', '傣族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8EB3DDB3E29043A788397650FB2BB770', 'dictionary.RightCertificateType.propertyRight', '房地产权证', 'Property Title Deed', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '8FBD33CB930D41BF8EAAA49D795CA95E', 'dictionary.i18nResourceKind.psFireUseAssortmentApplication', '项目管理消防改造目的', 'Project Management-Fire Fighting Renovation Objective', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '907434C98DD6412E8E0F54F426EB03D1', 'function.TECHBaseInfo.name', '基础管理', 'Basic Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '90F323BC0E184869AE599557DB5D39DF', 'dictionary.nation.55', '珞巴族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '923A14A55E344BB395AC350D627B662C', 'dictionary.personSecurityGrade.NON_SECRET', '非密', 'Not Classified', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9258BFFED1134ED5B2C8EC64BB7F64B8', 'dictionary.SubjectCategory.Z', '其他类', 'Others', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '936583493D6E4FD0BD3DCB276B11D1FD', 'dictionary.hxEquipmentType.1', '设备', 'Device', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '93D4FA91A25445C0B734E56DB345AC84', 'dictionary.hxPaymentFlag.0', '未审批', 'Approval not Done', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '94018417298C4B6394B54A33F1FAEDBB', 'dictionary.CurrencyUnitType.1', '元', 'CNY', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '94649B538AD44328AC65FBCE088EB88C', 'dictionary.permissionKind.field', '字段权限', 'Field Authority', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '94F4F816880342FCBC9CE3F8E2529735', 'dictionary.MonetaryUnitType.FRF', '法国法郎', 'FRF', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9689CCFE541945E7ACB02E72FCEC2324', 'dictionary.ContractType.office', '办公用品类合同', 'Office Supply Contract', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '96C9B46EE056403C88BF6D2E413D86C5', 'dictionary.messageNodeType.welcome', '欢迎', 'Welcome', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '976947AD515649A7BDEA8C087E93FF8E', 'dictionary.certificateKind.1', '居民身份证', 'ID Card', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9790DF045C9A40CF935156894B6DDA69', 'dictionary.managerFun.findCurrentPersonMemberAdminManager()', '获取当前人员的行政权限管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '97BD3B5440F34744A3DA959C6AF71130', 'dictionary.SubjectNodeKind.subject', '专业', 'Specialty', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '98573074BBC149C989B4A6DF4FBC0E57', 'dictionary.i18nResourceKind.functionI18nInitApplication', '系统功能', 'System Function', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9857A0D51E544D2C95D47284E95B0C3F', 'dictionary.fieldType.0', '主集', 'Dominant Set', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '987AE117E7F2478AB240165AB9E65034', 'function.TMAuthorize.description', '三员授权', 'Three Authorization', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '994864D82C7A4528AC5ED604F16279AE', 'dictionary.managerFun.findCurrentNearestManagers(\'manageType\')', '获取当前人员的指定管理权限的管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '994BDFC2AE41487CAB281343DCB59038', 'dictionary.orgKindStatus.0', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '99B7039D6AC64C76898287029CF6900F', 'dictionary.ConsumablesType.print', '复印纸或鼓粉盒', 'Paper or Cartridge', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9AD2832D519F465D95257613840D3087', 'function.ErrorLog.description', '错误日志', 'Error Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9B871FCEFD7B4C15A8DED4AC172A83C9', 'dictionary.commonTreeKind.9', 'SysDictionary,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9BA3F5A599F94A41B18EABAE0B7EDFD6', 'dictionary.SubjectLimitType.0', '无', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9C6893D86228485C9C3FAE748DD048B5', 'dictionary.secretLevel.1', '普通', 'Ordinary', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9C71005DF4AF49988123CEB1865C29A6', 'dictionary.subjectType.99', '示范区', 'Model Area', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9C7E94B35BB44319A88597758DF09099', 'dictionary.nation.7', '彝族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9CAF534E64804A09BFA1BF8CB39D0695', 'function.GNS.description', '功能树', 'Function Tree', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9CB3CB8A57C2477EBA89C2C105C9E72D', 'function.GNS.name', '功能树', 'Function Tree', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9DA34218570641E9A50E05DA20134B7A', 'dictionary.ContractType.device', '设备类合同', 'Equipment Contract', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9DEB8BB74AB44AA5B7FA4D76CB0F0619', 'function.Orgfun.description', '组织机构函数', 'Organization Function', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9E353D1FD67148F3B34762D6EEB40F09', 'dictionary.projectType.project', '工程项目', 'Engineering Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9E3DE1BE67B24716A031B6D39BBC13C9', 'dictionary.BiddingRound.3', '第三轮', 'Round 3', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9E684210CF8D4C62904B116F8969D6E4', 'dictionary.furnitureType.2', '实验室家具', 'Laboratory Furniture', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9E74F401678C462EA71815A909343A46', 'function.Agent.description', '代理管理', 'Agent Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9F0386E93EBA4480A64A3443C8BC4F1E', 'dictionary.dictionaryStatus.0', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9F22CC8779944ED7BB4A7915065F9470', 'dictionary.UnitType.BOT', '瓶', 'Bottle', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9FA9FEF902FF43A5BE2E6BA3E67E9C3E', 'dictionary.hxProcurementMmethod.1', '市场现购', 'Market Purchase', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9FB7E279FF5E4DC6941D56B99B6B63EF', 'function.ProcApprovalElementConfig.name', '流程审批要素配置', 'Configure Process Approval Element', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9FD6692ED001497E9D41B69C4C97F7B9', 'dictionary.RightCertificateType.additionalRight', '附加的产权证', 'Additional Title Deeds', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( '9FDD610911204609BBC33C5F099614C6', 'dictionary.FunctionType.a', '生命科学', 'Life Science', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A022A872F442465CB2A1AD1AC8F5FFA9', 'dictionary.roleStatus.2', '禁用', 'Disabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A0E561E54BD44248BD085DE04FF7D368', 'function.UserGroupMge.description', '分组管理', 'Group Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A0EDEF9CF4EE4F73A94546E159904A1F', 'dictionary.businessKind.8', '其它项目', 'Other Items', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A1197D6CD8FD4F28B2C9155273CD219C', 'function.SecurityPolicyList.description', '安全策略', 'Security Policy', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A1B6AE58752F4335A76391AADE691F7D', 'dictionary.memorandumKind.2', '出差申请', 'Business Travel Request', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A1F327243F984D5B82810DCA2D198547', 'dictionary.handleResult.0', '未填写', 'Not Completed', NULL, NULL, NULL, NULL, 270791, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A20A62D001D04091A9378D33A79B0B69', 'dictionary.UnitType.JIA', '架', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A25BA63CA74047698EFE895F27BD41C3', 'dictionary.nation.11', '满族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A3A4CE695AA74EAAAA67088C17CC2D68', 'dictionary.hxProcurementMmethod.4', '其他', 'Others', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A3FE448B086149B5A8C016DD329827BA', 'dictionary.weekKindId.2', '星期二', 'Tuesday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A4381C994A7D49E7A2141ED13367788B', 'dictionary.ArgumentOperateStatus.0', '未启动', 'Not Started', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A4EA4C655D914281BF116FDC27B98820', 'dictionary.orgFunctionKind.1', '自定义', 'User-defined', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A590D338583244159E124BF59FDA38EB', 'dictionary.nation.12', '侗族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A5EA1E6665DC4EA782AE537EF363B535', 'function.OPM.name', '组织权限', 'Organization Authority', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A6BBBDBA565B487CB63E468397BEA1E2', 'dictionary.RightCertificateType.ownershipRight', '房屋所有权证', 'Property Ownership Certificate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A6E1E8146D21461A97C24B20C0D659CD', 'dictionary.dictionaryKind.0', '系统', 'System', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A7551E7DA3824701B9A67EA306F3DBFC', 'dictionary.fieldTypeList.5', 'bool', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A768721CBAB3449D9A4C8A832685C80D', 'dictionary.BiddingRound.4', '第四轮', 'Round 4', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A785613B1DAF4A8CACD745E00D4DFB3D', 'dictionary.nation.41', '塔吉克族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A82CAECBD99A4943B563F07D9E3D929C', 'dictionary.fieldTypeList.2', 'number', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A8424AA13130403CB15C968F0D4119B9', 'function.ExcelImportTemplate.name', '导入模板设置', 'Import Template Setting', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A864FB07833D4B9788A7C44972B93070', 'dictionary.UnitType.PIC', '条', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A962EE35C499478CA1B8CD825DB06CD6', 'dictionary.FunctionPageName.pmAdjustReceiveBill', '设备调剂领用单页面', 'Device Regulation & Requisition', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A9990C7D3E0A416592318AC6D024A0F2', 'function.OperationLog.description', '操作日志', 'Action Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A9DD8FB208704D00A9F0E7BDCC030684', 'dictionary.nation.5', '维吾尔族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'A9ED940CBE8C47F1B6DCDCE14E7FBDAC', 'dictionary.SubjectCategory.B', '工程类', 'Engineering', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AA2010C85570460F9345B41E74BFA6BC', 'function.AllocateManager.name', '分配管理者', 'Assign Manager', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AADAA0A2B7204800A7B61AD913DC2298', 'dictionary.hxBiddingSource.1', '国内', 'Domestic', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AAEE03B1E42345D0A82549DACDC37C0A', 'dictionary.BiddingResultType.success', '成功', 'Hit', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AB9A391B888743BDAA81433F60F15D0D', 'function.AllocateSubordination.description', '分配下属', 'Assign Subordinate', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'ABD7C79B8DA24E4AA9529784ACC66566', 'dictionary.weekKindId.6', '星期六', 'Saturday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AD04ADDEE49B4F499F11A0585A22E211', 'dictionary.editControlType.7', 'checkbox', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AD32D50B2C5441DA9EF18748FD7F7229', 'dictionary.MonetaryUnitType.CHF', '瑞士法郎', 'CHF', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AD8BE0E1A762462D9C8BAD910F5A7D6B', 'dictionary.maritalStatus.已婚', '已婚', 'Married', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'AD9842A1AF4F49B7A1918B33B3A7CE5B', 'dictionary.hxStandardKind.0', '非标准', 'Non-standard', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B08F5BD294034881A0EDCF7833A25DC4', 'dictionary.subjectType.4', '机电', 'Electromechanics', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B1343D8BDD1E4C6B995427A21DCED756', 'dictionary.FunctionPageName.pmValidateBill', '设备核销单页面', 'Device Verification', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B136694CFBE44D63AD9C5117E80D01E2', 'function.SecurityPolicyList.name', '安全策略', 'Security Policy', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B13D87137FCF4283A0F434BF59334470', 'dictionary.level.undergraduate', '本科', 'Undergraduate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B187E3563AD44F52820295F1553DA8CD', 'dictionary.commonTreeKind.1', 'OrgType,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B198CB13D1594FFD8BFBF274A83B8475', 'dictionary.showModel.0', 'DIV', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B26B811C6EAF40A8A2DF246991E77CF4', 'function.ExcelImportTemplate.description', '导入模板设置', 'Import Template Setting', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B278BC8A27674ECAAD392341587C6CEC', 'dictionary.nation.35', '撒拉族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B2B804EFB8334AB98B4F8C311B74B9A5', 'dictionary.RightCertificateType.notDealRight', '暂未办理土地权利证的批文', 'Land Title Deed Not Approved', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B313D2BAE0044C0E86BFA39AAF188FB6', 'dictionary.managerFun.findNearestManagers(@personMemberId,\'admin\')', '获取指定组织单元最近的管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B35664DBF8E6441584372741596830E1', 'function.UIElement.name', '界面元素', 'Interface Elements', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B39A02B4F2C14DA7BB0B914A5F4FAE5C', 'dictionary.bizManagementType.0', '系统', 'System', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B3BEC19891B544449719284BBFB4CBB4', 'dictionary.commonTreeKind.30', 'Formula,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B3C285854B744235912CE2EDE27D4FC6', 'dictionary.nation.31', '达斡尔族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B3FB8BFB498C4C899FC047F68269BB5C', 'function.AllocateManager.description', '业务管理权限', 'Transaction Management Authority', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B4F34DF801364099A51807D547F966A9', 'dictionary.fieldTypeList.3', 'date', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B5530190539B46698E5496AD93988DC2', 'dictionary.deptLevel.Secondary', '二级部门', 'Secondary Department', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B571B912C0014950806545B90E762E75', 'dictionary.nation.40', '普米族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B5FC83850A734C01B1150018732D2E3A', 'function.ProcDefinition.description', '流程管理', 'Process Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B60E638F5FCD4711BF8849719ECB2D8D', 'dictionary.BiddingRound.5', '第五轮', 'Round 5', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B618D18F0CBF4E6E9927B7B5C4B5B154', 'dictionary.handleResult.2', '不通过', 'Rejected', NULL, NULL, NULL, NULL, 885151, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B6402F5FB5034AA7A33F2393CDD2A4FF', 'dictionary.SubjectNodeKind.root', '根节点', 'Root Node', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B67812B364FA48639B5243213F993BDA', 'dictionary.nation.1', '汉族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B6962916638C4F8EAF26B88479081010', 'function.PersonAccountManagement.description', '账号管理', 'Account Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B727B3AE6BC34E8EAE2B2F1E8B7E22D9', 'dictionary.UnitType.PI', '批', 'Batch', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B80C17C2D8104ED99DE3E2B45FCE77E4', 'function.Synbasedataversion.description', '系统数据同步', 'System Data Sync', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B8F0E9E10A674E5097E7593EB8E2F33F', 'dictionary.roleKindId.administrator', '管理员', 'Administrator', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B95B74B08CA54C80A3E826D4032669DD', 'dictionary.nation.34', '布朗族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B95D06E5864141619DFFB294EEC5F521', 'function.SecurityPolicy.description', '安全策略', 'Security Policy', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'B99311E840DF4FD49085AF195AC83EE8', 'dictionary.nation.44', '俄罗斯族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BA5D5E1A30AB4C8284D5C0B4A5D76D52', 'function.DataManageBusiness.description', '管理权限业务类型定义', 'Define Type of Business', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BC0E067AA00F4A32AB5A4806DED53036', 'function.FlexField.description', '扩展字段', 'Extension Field', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BC7DA89F765A4DD492DD79C99107C2FE', 'dictionary.hxBaseManageTypes.hxDirectorBase', '主任总师', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BCACD30DD4DE4A4C87A1F0C3916ACC10', 'dictionary.hxPaymentFlag.2', '财务已付款', 'Paid by Finance', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BD003C99B3DB44B899588D7B1E031D09', 'function.BizManagementFolder.name', '业务管理权限', 'Service Administrative Privilege', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BD14FDF449CC42ED8B4BD4C460117ABA', 'dictionary.nation.33', '羌族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BDA48AD7597A4B998ECBEA0CAFAD22D6', 'dictionary.status.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BDC47AF3F79648778E8115816B3BE7C0', 'dictionary.isOutSchool.0', '校内', 'On-campus', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BE70D72767354AC8A6AC0415ECC7F786', 'dictionary.subjectType.41', '给排水', 'Plumber', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BEE3ADFA31D54A5EA0049B78921F5E17', 'function.Machine.description', '机器维护', 'Machine Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BF174C202BEF4F35B89E619EF9B043A7', 'function.I18nProperties.description', '国际化资源维护', 'Internationalized Resource Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BF4C40392D58426C8AF307580B98E7D2', 'function.Authorization.name', '授权管理', 'Authorization Administration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BF7F2CFBA62148F5A35E3ED9FD62723B', 'dictionary.personSecurityGrade.CORE', '核心', 'Core', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BF84FB2A77D74C32A0C67DB952748FD0', 'dictionary.UnitType.BA', '把', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BFB2654730FA4275844829BCB2599340', 'dictionary.i18nResourceKind.rbSettlementAttrApplication', '结算方式显示属性', 'Display Property of Settlement Method', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'BFFFBDF0C9F446E5A6E9C61F22FE36E9', 'function.SysDictionary.name', '系统字典', 'System Dictionary', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C13BB95AE148499D9A9D68508CC1D7E7', 'dictionary.nation.50', '塔塔尔族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C14574C1BABD475AA5D7BDA44DF8CF1D', 'dictionary.subjectType.3', '装饰', 'Decoration', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C1636F63C68C48B892ED74BCC33AABC0', 'function.Machine.name', '机器维护', 'Machine Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C1908F53E0C848A4A3F939D853C678D7', 'function.BaseManagementType.name', '基础管理权限类别', 'Basic Management Authority Category', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C1933932619743608EECA4ED69983892', 'dictionary.editControlType.9', 'lookUp', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C1979E05E0FB41DFBE283DBD87E98CC2', 'function.Orgfun.name', '组织机构函数', 'Organization Function', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C1B38C9D4C09448EBD4CB0E468ED22F0', 'dictionary.education.专科', '专科', 'Junior College', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C1C3034E94A54131A5369F0D67B5756D', 'dictionary.dataSourceKind.1', '无', 'None', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C32A4CD10906460884AA3E133F01EF68', 'dictionary.hxProcurementMmethod.3', '合同', 'Contract', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C4007374298B487FAB35FDE67F4AC335', 'dictionary.FunctionPageName.pmRepairBill', '家具维修单页面', 'Furniture Repair', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C408A5B1F77D470DA2C0C431857730F7', 'dictionary.i18nResourceKind.kindApplication', '报销类型', 'Reimbursement Type', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C43FE7E14FC1464A80BB8297B89C9A3C', 'dictionary.fieldType.3', '其他', 'Others', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C45876CDE57D4C5FB3BE6F7654A5E561', 'dictionary.i18nResourceKind.rbInvoiceKindApplication', '报销单发票显示字段', 'Display Field for Reimbursement Form & Invoice', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C45D81FC63ED4CDD9A099E76A8912784', 'dictionary.agentStatus.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C53E84FB6D9348D88EE17D070B2C2547', 'dictionary.ProjectMaterialType.zzDoc', '公司资质', 'Company Qualification', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C5E3DF16705C4CAB9B5C030E4BDC7031', 'dictionary.managerFun.findTechCenterManagers(@fullId,\'manageType\')', '获取指定单位管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C619F61784E343EE862A4BE82F0CDA7F', 'dictionary.UnitType.ZHG', '张', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C6258F67C5BC4279B880532772925850', 'dictionary.nation.56', '基诺族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C7AC53CA3590450393B1DBBB4CCB3D16', 'function.SysParameter.name', '系统参数', 'System Parameter', NULL, NULL, NULL, NULL, 270808, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C8140BB5B77145B2802628E901C433C1', 'dictionary.MonetaryUnitType.KRW', '韩国圆', 'KRW', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C848B62E09964EB288E809DB41282A7D', 'dictionary.CurrencyUnitType.2', '万元', 'CNY 10,000', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C8731BDB5B064D639D92AD7E3C0DF904', 'dictionary.commonTreeKind.10', 'ExcelImportTemplate,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C8CC02ACAA014091B4AC2945552B5812', 'dictionary.UnitType.ZHI', '只', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C8F6693B978D4B9A925A1A8A744D5C84', 'dictionary.OutOrInnerSchool.1', '校内', 'On-campus', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'C8FCF557D5134D3F81CD70EA4C76353D', 'function.DataManageBusiness.name', '管理权限业务类型定义', 'Define Type of Business', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CA19C86BFB87472A9C6C0BF7A184AEC3', 'function.WorkflowTaskManagement.description', '流程任务管理', 'Process Task Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CA9F332CD8D34057B7B1AD391F4B8C06', 'dictionary.ArgumentOperateStatus.1', '执行中', 'Executing', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CBEA91401FDD4E1882B8B8028754B29E', 'dictionary.nation.52', '鄂伦春族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CC2426DFA84043CE954564E9E2DD6E13', 'dictionary.fieldAuthority.readonly', '只读', 'Read Only', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CC81173FDCE6416D91EA74F714826E39', 'function.ProcUnitHandlerQuery.name', '流程处理人查询', 'Process Handler Query', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CC9E8B4D2ACC4C328B25A947DD1E2509', 'function.FlexFieldGroup.description', '扩展字段分组', 'Extension Field Grouping', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CD350B9E30D648B8BAF7C06BAF7A8A8B', 'dictionary.yesorno.1', '是', 'Yes', NULL, NULL, NULL, NULL, 270790, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CD50AB5BF07E4FEDBF7B1E98BAADCEC2', 'dictionary.commonTreeKind.17', 'BaseManagementType,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CE278142DF9847BABE07631368B85C06', 'function.UIElement.description', '界面元素', 'Interface Elements', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CE8AFC88B64C4DD993DFA082B18C38C0', 'dictionary.editControlType.8', 'select', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CF2E9F7F3F754BC3B741D364E8390A26', 'dictionary.sex.1', '男', 'Male', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CF33999A4C2D498B85EC889C6B23795A', 'function.Org.name', '组织管理', 'Organization Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CF4ADB4FBDC24421827638E3F67A9B07', 'dictionary.level.graduate', '研究生', 'Post-graduate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'CF712E1F0D204DBE8E4F9369FAE79084', 'dictionary.SubjectCategory.A', '货物类', 'Goods', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D00DBED2DE9145ABB32C7FF7F154EBCD', 'dictionary.MonetaryUnitType.MMK', '缅甸元', 'MMK', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D0544203794B44C090617730FD4DFDC1', 'dictionary.commonTreeKind.25', 'UserGroup,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D09BF4E3CFD348AF95440EAF196DACC4', 'dictionary.commonTreeKind.7', 'SysParameter,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D10416F34725493B8CA9C57B83D76E81', 'function.AllocateSubordination.name', '分配下属', 'Assign Subordinate', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D1119C56D0E94687B5E0F3C75F8A235A', 'dictionary.LanguageType.en', '英文', 'English', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D128EC7250784D68BB9B77CD2CA7952C', 'dictionary.businessKind.7', '开发型项目', 'Developmental Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D145D1E73E2C4572966CDA4E19AF9764', 'dictionary.processManageStatus.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D17D525DDB024E60BA98BE7F15A78B0E', 'dictionary.certificateKind.2', '军官证', 'Military Officer Certificate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D1DFD7A11F9B4A2B871B5CD753E7B4D7', 'function.FunctionPermission.name', '功能权限', 'Function Authority', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D2BF578DD9334007B0F91A80688CFFD7', 'function.Func.description', '功能管理', 'Function Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D2F92768A023458E98037A7CC00F2D2B', 'dictionary.nation.16', '哈尼族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D3D5D913208F474CAB38DC1718068FD3', 'dictionary.certificateKind.Z', '其他', 'Others', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D40EA8DCFADD4CE2AF5B8FA132F5B21D', 'dictionary.subjectType.42', '暖通', 'HVAC', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D4AB936E118F419AA812DA45FD3DE083', 'dictionary.managerFun.findCurrentPersonCenterAdminManager()', '获取当前人员单位行政管理权限管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D52678CAF909454EAC2D5C10C5521C43', 'dictionary.bizManagementNodeKind.2', '业务权限', 'Transaction Authority', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D54FE83BE2BF4E2193148F6171B05C43', 'dictionary.UnitType.PAI', '排', 'Battery', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D5632454F992436D92B1729F5C52E19A', 'dictionary.BiddingRound.1', '第一轮', 'Round 1', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D567F5549A5E46DB860F3B032917D385', 'function.I18nProperties.name', '国际化资源维护', 'Internationalized Resource Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D5A8C542DD1349A69F6151E8D57F9370', 'dictionary.editControlType.2', 'combox', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D5E72A28661440B0BD2781382E57EFAE', 'dictionary.MonetaryUnitType.GBP', '英镑', 'GBP', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D5EDFD3005A24AB4B0F2D739350CD9AA', 'function.PersonLoginLimit.name', '登录限制', 'Login Limit', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D6449C6A677B4D67855E9B4D521F383D', 'function.ApprovalElement.description', '审批要素配置', 'Approval Element Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D69D7811277640A5ABB2160C981A8863', 'dictionary.hxBudgetFlag.extra', '预算外', 'Off-budget', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D7C14A3BA6AD413395AE3FDFAA316674', 'dictionary.nation.36', '毛难族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D80E1032B1BF4107913C955D5EEC7E69', 'function.DataManageType.name', '管理权限定义', 'Define Type of Data Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D8191AC0AFAE45BD8C80B05ACB0F55B5', 'dictionary.certificateKind.5', '部队离退休证', 'Military Retirement Certificate', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D85F28CC983044A1A010C7AF8584B4C2', 'dictionary.nation.2', '蒙古族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D866DF64E96C4245A692D3B1BC7DEDCB', 'dictionary.SubjectTypeLevel.subject', '科目', 'Account', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D8C3B5BEA8DB42E4ACE5C3247C2FEA21', 'function.WorkflowConfiguration.name', '工作流配置', 'Workflow configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D95527D169A842009F1B59BBC8B9CC39', 'dictionary.weekKindId.5', '星期五', 'Friday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'D97BDA7D589345F0ADD34195187900D3', 'function.ProcDefinition.name', '流程管理', 'Process Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DA2553075ED14C518A271352D62813B1', 'dictionary.weekKindId.7', '星期日', 'Sunday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DA565CCE92A04C2A9F7FDA478D8D61C5', 'dictionary.securityGrade.CONFIDENTIALITY', '机密', 'Classified', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DA7133C6A12C4869BCCEEECD258F20EA', 'dictionary.managerFun.findTechOrgCodeManagers(@orgCoe,\'manageType\')', '指定单位管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DB0BA46DC1444C3C93E7AD41A3A4A620', 'dictionary.rolePersonKind.def', '教师', 'Teacher', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DBC61DFF6D2F49CE87144DC63AD56AA2', 'dictionary.orgFunctionKind.0', '系统', 'System', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DC431BFD7ACE4DAFA6D36D5F3029E816', 'dictionary.commonTreeKind.5', 'FlexFieldDefinition,folderId', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DD25B4EBBE0C4C5886778A23927D334D', 'dictionary.MonetaryUnitType.NZD', '新西兰元', 'NZD', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DD6AB5C18EF047C99ED4DA78BB13B9DF', 'dictionary.hxBudgetFlag.within', '预算内', 'On-budget', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DDDE257974E04333BD33F2717B048082', 'dictionary.fieldType.2', '按钮', 'Buttons', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DE3991B383B348A684B0D7B3CFCAE9B4', 'dictionary.memorandumKind.1', '举办会议', 'Hold Conference', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DE4ADC62AEE642969A64B0BA2903D62C', 'function.RecycleBin.name', '回收站', 'Recycle Bin', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DE6B9A8F43214D2DA000F9EBF2E4FE57', 'function.BPMCBizFunction.description', '业务功能分组', 'Transaction Function Group', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DE98CC833641423981C246E7B64E1317', 'dictionary.roleStatus.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DED5E556140544B1950F419FE5DEED24', 'dictionary.SubjectTypeLevel.middle', '中类', 'Middle Class', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'DF815D736D594BE4BB42DE1C5D4F1B4A', 'dictionary.UnitType.ST', '个', 'Piece', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E00967D74B9941DA939149F17D073EB1', 'dictionary.nation.54', '门巴族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E0EC8C69049048BBAFE669F3B1CC1C8E', 'dictionary.maritalStatus.离异', '离异', 'Divorced', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E14DBE40D8654F6C89A95B760AD55522', 'dictionary.nation.38', '锡伯族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E2EBB605C15A4448A9C7E69877386204', 'dictionary.hxBaseManageTypes.hxQualityManage', '预算表数据查询权限', 'Budget Sheet Data Query Authority', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E300402AD4EA4813A33ADCEBE2FD9460', 'dictionary.FunctionConfigType.page', '页面组成', 'Page Composition', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E388DCE222014FAD894115FD5C2E5A7B', 'dictionary.fieldAuthority.readwrite', '读写', 'Read-Write', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E4003337B67B4726871BFA5352EB3D70', 'dictionary.subjection.parent_company', '母公司', 'Parent Company', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E46210482B194C90BD835B8B0895F8B9', 'function.ProcApprovalRuleConfig.name', '流程审批规则配置', 'Configure Process Approval Rules', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E549FEFE855548CD8D9C3E5D1F70B3AC', 'dictionary.nation.27', '纳西族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E56DF5435E054EF0855D8BE5E3717A31', 'function.WorkflowTaskManagement.name', '流程任务管理', 'Process Task Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E5F993A538C5493E9B2AC5565D7373DB', 'dictionary.certificateKind.3', '士兵证', 'Solder’s Card', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E6F2D43C6A1B44849884172EBEBB38A0', 'function.CodeBuildRule.description', '单据编号规则', 'Document Numbering Rule', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E7396ACBB0BD40A2A0E99949B94D13A1', 'function.BPMCBusinessProcess.name', '业务流程图管理', 'Transaction Flow Chart Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E88D896A099A44769BD95873DBB582F9', 'function.DataManagement.description', '数据管理权限授权', 'Authorization from Data Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E8DF98FAD9BA44D5876540AEAA8F401F', 'dictionary.MonetaryUnitType.NOK', '挪威克朗', 'NOK', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E8E46231F0E44F78B8D8C6195F6EF01F', 'dictionary.isOutSchool.1', '校外', 'Off-campus', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E975349677A44AC98203758F352DA216', 'dictionary.hxBiddingSource.3', '国内外', 'Home and Abroad', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E994CBD2FE214CABA063CDC963C97C3C', 'function.taskInfoCount.name', '流程任务统计', 'Process Task Statistics', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E9B32BA58A3844A19D6D89C13A766D2C', 'dictionary.SignStatus.1', '已签收', 'Signed', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'E9BA7568FFE04F2DB8F9A4CA4C4736AB', 'function.MessageRemind.name', '消息提醒配置', 'Message Alert Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EA7D5F9B977747C284834B014A9E11CF', 'dictionary.nation.32', '仫佬族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EB27531D06E04D2385A6B3562C6B1516', 'function.ProcApprovalRuleConfig.description', '流程审批规则配置', 'Configure Process Approval Rules', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EC085F23FCB34C78B2F1C3AFCCF737B8', 'dictionary.messageNodeType.text', '文本', 'Text', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EC60A2350D824F528582F99DF3A8EE12', 'dictionary.securityGrade.INTERIOR', '内部', 'Restricted', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EC70822C5D034D959A0ADBA459087697', 'dictionary.SynStatus.1', '成功', 'Hit', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'ED1159A977274F38AE27CE74FE6123FD', 'dictionary.secretLevel.2', '一般', 'General', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'ED2B0F4B139541BE8764B2A07A0DCC8F', 'dictionary.bizManagementType.1', '自定义', 'User-defined', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'ED32E94FC4CD45AC9424A5DE0F66078D', 'function.MessageRemind.description', '消息提醒配置', 'Message Alert Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EDEECBD35748457C9FD225F5286329FB', 'dictionary.MonetaryUnitType.DKK', '丹麦克朗', 'DKK', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EE3629754D714DF7A0A6FFE17FFD7527', 'function.OrgTemplate.name', '机构模板', 'Institution Template', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EF96335B05F24A769BDD1DE49F5E8371', 'dictionary.orgFunctionNodeKind.2', '职能', 'Function', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'EFABFB8ABA31419AAB6FAA3E33891B1C', 'dictionary.SubjectTypeLevel.big', '大类', 'Big Class', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F0009AFE26CE4C67B4C990BA2F9F68C7', 'dictionary.SubjectNodeKind.kind', '类型', 'Type', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F0BFCA9677924F51AF4C8C2348CEE215', 'dictionary.uiElementStatus.1', '启用', 'Enabled', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F0C999789C2B4A8A845D26B5BBD488EF', 'dictionary.ConsumablesType.other', '其他科研耗材', 'Other Research Consumables', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F0F6BDED753840B6AD0CBEF7E864FC74', 'dictionary.managerFun.findBmManagers(@declareId,\'auditorType\')', '获取预算申报管理人', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F1A4314BAA48413D860B6743FFA700BE', 'dictionary.hxBaseManageTypes.hxBudgetRecordManage', '预算记录管理', 'Budget Record Management', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F204A0EC134241C288C624663438863B', 'function.ErrorLog.name', '错误日志', 'Error Log', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F2B0EEAA8AB4447ABDCF75946AF73F15', 'dictionary.roleKindId.common', '普通角色', 'Ordinary Role', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F2BC7C4EC2444BDEA788462236FCD535', 'dictionary.ContractType.consumables', '耗材类合同', 'Consumable Contract', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F2C82D8CEC234873A93743AE7AF543AC', 'dictionary.editControlType.3', 'spinner', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F3091E29226C4E71B09867AF5E911637', 'function.PersonAccountManagement.name', '账号管理', 'Account Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F429855E186346D49EBE0DAB2D172D48', 'dictionary.subjection.sub_company', '子公司', 'Subsidiary', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F4728592ED024C039DFDEA537ADDEAFE', 'dictionary.securityGrade.TOP_SECRET', '绝密', 'Top Secret', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F50168B66F67472D827C6FEF03D9F69B', 'dictionary.hxBaseManageTypes.hxMpAssist', '市级重大专项协审', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F586DD8FCF904AF68C7A65BD31BE964C', 'dictionary.FunctionPageName.pmAdjustBill', '家具调剂单页面', 'Furniture Regulation', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F593D82226D741D192D33B09CC187911', 'dictionary.businessKind.5', 'TA软件销售项目', 'TA Software Sales Item', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F6208DEB0EE845378CA81087217FC7CA', 'dictionary.managerFun.findManagers()', '获取指定组织单元的管理者', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F6B47197B85846E49847962303C7AAB3', 'function.Synbasedataversion.name', '系统数据同步', 'System Data Sync', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F6C57EF728544518B60E80C1332DE159', 'dictionary.FunctionPageName.pmScrapBill', '资产报废单页面', 'Asset Retirement', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F717B22092CF41E7958264589F9F67C5', 'dictionary.EvaluateResultType.success', '招标完成', 'Tendering Completed', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F731294680474E1C8DBEA007B50B1817', 'dictionary.nation.10', '朝鲜族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F74E44357DC14976A27F9229C24F9D47', 'dictionary.orgAdminKind.one', '总部', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F78B81102D594B239ABE0F359AB9F440', 'dictionary.memorandumKind.MP', '市级重大专项采购申请', 'Major Special Purchase Applications', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F7A5E4E141DC44319E26F814E5B9A18C', 'dictionary.roleKindId.auditor', '审计员', 'Auditor', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F804029CD2F9422388AF22E43F64348A', 'dictionary.ProjectMaterialType.psDoc', '比价评审单', 'Project Comparison Review', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F87EEDAED6CF4CCC9000EFB445325FA3', 'function.ApprovalElement.name', '审批要素配置', 'Approval Element Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F92F51B8E2E54A089F7F9C625B1E7BE3', 'dictionary.hxBaseManageTypes.hxPreAudit', '预算预审核', 'Budget Pre-audit', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F9A6D24E616244469EACCE8E5CBFAEFF', 'function.ApplicationSystem.description', '应用系统维护', 'Application System Maintenance', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'F9F8A26243964932B2FE7DAB53A72EFF', 'dictionary.dataSourceKind.3', '数据字典', 'Data Dictionary', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FA2F971F820F46B1B6D8320AA28FC1E5', 'dictionary.UnitType.PAK', '包', 'Pack', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FAA341D2049C4E6F8AD69DE1153078A1', 'dictionary.weekKindId.1', '星期一', 'Monday', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FAB02785989346BFB3308F1E2F2592E8', 'dictionary.hxEquipmentType.2', '材料与元器件', 'Materials & Elements', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FAB37A69C21A4A198D1155751AE5F324', 'dictionary.messageNodeType.pic', '图文', 'Graphic', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FAE6C769D7764245A9F704EA4C18B50C', 'dictionary.nation.14', '白族', NULL, NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FB02AF271CC04CF49077CD6CCB668A0B', 'function.BizClassificationConfiguration.name', '业务分类配置', 'Business Classification Configuration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FB8A125600944C29AE206E0ECD54C63A', 'dictionary.SignStatus.0', '未签收', 'Not Signed', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FBEEB3909C05439B81B9ECC65B906682', 'dictionary.subjectType.2', '景观', 'Landscape', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FBF42AE99E8148BCA7F1631EBFB000BB', 'function.Role.name', '角色管理', 'Role Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FC3D5963ED01469CACC334CD589F7B86', 'dictionary.UnitType.TAI', '台', 'Set', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FC79E85B741C4A70AB1FCAAE759D483F', 'function.Authorization.description', '授权管理', 'Authorization Administration', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FC9A318816CB4D87BE1F7FB122815CF7', 'function.OPM.description', '组织权限', 'Organization Authority', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FCBE361B0C0C491F8EE2E172F15585F6', 'dictionary.memorandumKind.3', '出国申请', 'Traveling Abroad Request', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FD2EA4F261DA47988D76C1C51FE6A142', 'dictionary.ContractType.furniture', '家具类合同', 'Furniture Contract', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FDD1261B199B40218AA4C32E8BC9D11B', 'function.Role.description', '角色管理', 'Role Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FDDAF9853F964DC98299C1F86C32CDE7', 'dictionary.i18nLanguage.en_US', 'English', 'English', NULL, NULL, NULL, NULL, NULL, '7D63574CB124454F92AF30F6EE368240', 'dictionaryI18nInitApplication' );
INSERT INTO `sa_i18nproperties`
VALUES
	( 'FF2368B8BC96443EAB306F56359C1512', 'function.Permission.name', '权限管理', 'Authority Management', NULL, NULL, NULL, NULL, NULL, '78D047EC4A044AFEA1A1DBC4792A2C91', 'functionI18nInitApplication' );-- ----------------------------
-- Table structure for sa_machine
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_machine`;
CREATE TABLE `sa_machine` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`IP` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`MAC` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SECURITY_GRADE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_message_remind
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_message_remind`;
CREATE TABLE `sa_message_remind` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件夹ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`REMIND_TITLE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '提示文本',
`REMIND_URL` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '连接地址',
`EXECUTE_FUNC` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '函数',
`REPLACE_KIND` INT ( 11 ) NULL DEFAULT NULL COMMENT '替换类别  0 顺序替换 1名称替换 2存在则显示',
`OPEN_KIND` INT ( 11 ) NULL DEFAULT NULL COMMENT '页面打开方式 0 新窗口 1 弹出',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统消息提醒配置表' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_onlinesession
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_onlinesession`;
CREATE TABLE `sa_onlinesession` (
`ID` VARCHAR ( 36 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ORGAN_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORGAN_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CLIENT_IP` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SERVER_IP` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGIN_DATE` datetime  NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SESSION_ID` VARCHAR ( 36 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGIN_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_onlinesession
-- ----------------------------
-- ----------------------------
-- Table structure for sa_opagent
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opagent`;
CREATE TABLE `sa_opagent` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CLIENT_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '委托人ID',
`AGENT_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代理人ID',
`START_DATE` datetime  NULL DEFAULT NULL COMMENT '开始时间',
`END_DATE` datetime  NULL DEFAULT NULL COMMENT '结束时间',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`PROC_AGENT_KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '代理方式ID',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`CREATED_BY_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '创建人',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`CAN_TRAN_AGENT` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否允许把代理工作转交给其他人',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '代理' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opagentproc
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opagentproc`;
CREATE TABLE `sa_opagentproc` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`AGENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opauthorize
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opauthorize`;
CREATE TABLE `sa_opauthorize` (
`ORG_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构ID',
`ROLE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色ID'
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '授权' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opauthorize
-- ----------------------------
INSERT INTO `sa_opauthorize`
VALUES
	( '100427@5C7117E6CE704125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100427@5C7117E6CE704125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100429@5C7117E6CEBD4125E050007F010057D5', '5CFEB2FCAE11E8B4E050007F01001417' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100429@5C7117E6CEBD4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100442@5C7117E6CDA94125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100452@5C7117E6CE814125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100454@5C7117E6CDA94125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100482@5C7117E6CD964125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100511@5C7117E6CDDC4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100511@5C7117E6CDDC4125E050007F010057D5', '5EF44BB5146A472EE050007F01001C9C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100511@5C7117E6CDDC4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100511@5C7117E6CDDC4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100511@5C7117E6CDDC4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100519@5C7117E6CD964125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100519@5C7117E6CD964125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100519@5C7117E6CD964125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100552@5C7117E6CE904125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100554@5C7117E6CE5F4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100554@5C7117E6CE5F4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100554@5C7117E6CE5F4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100554@5C7117E6CE5F4125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100581@5C7117E6CE704125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100581@5C7117E6CE704125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100581@5C7117E6CE704125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100581@5C7117E6CE704125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100591@5C7117E6CD9C4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100591@5C7117E6CD9C4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100591@6764A03B8486F731E050007F01004EF8', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100606@5C7117E6CEA04125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100614@5C7117E6CD9C4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100614@5C7117E6CD9C4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100621@5C7117E6CDFF4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100621@5C7117E6CDFF4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100621@5C7117E6CDFF4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100622@5C7117E6CDE34125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100622@5C7117E6CDE34125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100622@5C7117E6CDE34125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100623@5C7117E6CE874125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100632@5C7117E6CE854125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100632@5C7117E6CE854125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100632@5C7117E6CE854125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100633@5C7117E6CE864125E050007F010057D5', '5EF44BB5146A472EE050007F01001C9C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100633@5C7117E6CE864125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100675@5C7117E6CF924125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100677@5C7117E6CDA94125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100677@5C7117E6CDA94125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100678@5C7117E6CD9C4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100678@6764A03B8486F731E050007F01004EF8', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100733@5C7117E6CDC14125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100745@5C7117E6CE294125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100747@5C7117E6CD874125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100747@5C7117E6CD874125E050007F010057D5', '5EF44BB5146A472EE050007F01001C9C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100747@5C7117E6CD874125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100762@5C7117E6CCFD4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100766@5C7117E6CD8C4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100766@5C7117E6CD8C4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100776@5C7117E6CE2C4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100776@5C7117E6CE2C4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100776@5C7117E6CE2C4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100787@5C7117E6CD714125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100804@6764A03B84A4F731E050007F01004EF8', '66A550FE24CA0518E050007F010064EE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100804@6764A03B84A4F731E050007F01004EF8', '69DFA8629BE3DA5FE050007F01003294' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100805@5C7117E6CD8C4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100805@5C7117E6CD8C4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100811@5C7117E6CE814125E050007F010057D5', '5E7A78DE624A12F7E050007F010041A6' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100811@5C7117E6CE814125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100811@5C7117E6CE814125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100811@5C7117E6CE814125E050007F010057D5', '6F97A29C9306707CE050007F01007680' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100813@5C7117E6CE304125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100813@5C7117E6CE304125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100813@5C7117E6CE304125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100813@5C7117E6CEE44125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100845@5C7117E6CD614125E050007F010057D5', '5CFEB2FCAE11E8B4E050007F01001417' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100856@5C7117E6CD654125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100860@5C7117E6CCFE4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100860@5C7117E6CCFE4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100886@5C7117E6CCFE4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100886@5C7117E6CCFE4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100886@5C7117E6CCFE4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100886@5C7117E6CCFE4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100886@5C7117E6CCFE4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100886@5C7117E6CDA94125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100892@6764A03B846EF731E050007F01004EF8', '71A57E4DE74D2E14E050007F010078CC' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100955@6764A03B8693F731E050007F01004EF8', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '120004@5C7117E6CEBD4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '120004@5C7117E6CEBD4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '120004@5C7117E6CEBD4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '120004@5C7117E6CEBD4125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '211005@5C7117E6CD974125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '211005@5C7117E6CD974125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '211092@5C7117E6CE8B4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '211092@5C7117E6CE8B4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213001@5C7117E6CD324125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213001@5C7117E6CD324125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213001@5C7117E6CD324125E050007F010057D5', '60A8D018BE34D83CE050007F01003659' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213001@5C7117E6CD324125E050007F010057D5', '66A550FE24CA0518E050007F010064EE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213001@6764A03B86A1F731E050007F01004EF8', '6358A43DB0933D5AE050007F01006F49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213076@5C7117E6CEA14125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '213076@5C7117E6CEA14125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '5D8659BEE52F920DE050007F01000FF1' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '5E7A78DE624A12F7E050007F010041A6' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '5EF44BB5146A472EE050007F01001C9C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '60A8D018BE34D83CE050007F01003659' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '72F96FA8CE4AB346E050007F01006D6B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5E171A90BDF15C51E050007F01006660@C18E23AAAA6940E09DF7C122332C51E0', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5E79B703E1834B98E050007F010039D8@C18E23AAAA6940E09DF7C122332C51E0', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6174DF9B9F3C928DE050007F01000456@7804BD48777048058B3222D1BD12ABF6', '6358A2BA0EF81581E050007F01006F43' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6174DF9B9F3C928DE050007F01000456@7804BD48777048058B3222D1BD12ABF6', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6174DF9B9F3C928DE050007F01000456@7804BD48777048058B3222D1BD12ABF6', '6358A94C2176B22AE050007F01006F7E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6174DF9B9F3C928DE050007F01000456@7804BD48777048058B3222D1BD12ABF6', '67197AC363568A61E050007F010079CE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6174DF9B9F3C928DE050007F01000456@C44EB50E375747A28050D941BDD617BB', '6358A2BA0EF81581E050007F01006F43' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6174DF9B9F3C928DE050007F01000456@C44EB50E375747A28050D941BDD617BB', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '67AAE83B2F7E6297E050007F01005183@E0B684B38FF445A585CD44C9CC973067', '6358A2BA0EF81581E050007F01006F43' );
INSERT INTO `sa_opauthorize`
VALUES
	( '67AAE83B2F7E6297E050007F01005183@E0B684B38FF445A585CD44C9CC973067', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '67AAE83B2F7E6297E050007F01005183@E0B684B38FF445A585CD44C9CC973067', '67197AC363568A61E050007F010079CE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '6358A2BA0EF81581E050007F01006F43' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '67197AC363568A61E050007F010079CE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '70A10ABC66EA4C9AE050007F01003C96@C121D5F7942B4004B9AB4F49C31038C4', '708D570E6CE8DFA4E050007F01006533' );
INSERT INTO `sa_opauthorize`
VALUES
	( '70A10D6FBB07DB31E050007F01003CB2@CFC7AF44D51F432E83B071F2B32C3ABB', '708D570E6CE8DFA4E050007F01006533' );
INSERT INTO `sa_opauthorize`
VALUES
	( '70A11035DE1B24DFE050007F01003CC8@CFC7AF44D51F432E83B071F2B32C3ABB', '708D570E6CE8DFA4E050007F01006533' );
INSERT INTO `sa_opauthorize`
VALUES
	( '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '298' );
INSERT INTO `sa_opauthorize`
VALUES
	( '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '8B7D5B15F3582D2FE050007F01006F8B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '8B7D6642E3384A67E050007F010070D5' );
INSERT INTO `sa_opauthorize`
VALUES
	( '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '8BAA5893FA853ADBE050007F01005C75' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'B6ABC4E9E5334573A137547641F72B60', '8BAA5893FA853ADBE050007F01005C75' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'B711778D87704312BF9970467A646B08', '8BAA5893FA853ADBE050007F01005C75' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '60A8D018BE34D83CE050007F01003659' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '62CBD828E2172463E050007F0100593E' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '6358A1582480032DE050007F01006F37' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '6358A2BA0EF81581E050007F01006F43' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '6358A86026989B3CE050007F01006F7C' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '67197AC363568A61E050007F010079CE' );
INSERT INTO `sa_opauthorize`
VALUES
	( 'shanghaitech', '6B4821E8A46D262BE050007F01005894' );
INSERT INTO `sa_opauthorize`
VALUES
	( '0107', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '0202D0001', '5B2759D2CF609A4FE050007F010051F3' );
INSERT INTO `sa_opauthorize`
VALUES
	( '0202P0002', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '0207', '66A550FE24CA0518E050007F010064EE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '0207', '6BAE497EB07ED00EE050007F010073FE' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100002@5C7117E6CDA74125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100003@5C7117E6CDA74125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100004@5C7117E6CEC94125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100006@5C7117E6CDA74125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100006@5C7117E6CDA74125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100102@5C7117E6CD964125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100102@5C7117E6CD964125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100103@5C7117E6CDDC4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100103@5C7117E6CDDC4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100104@5C7117E6CDFF4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100104@5C7117E6CDFF4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100109@5C7117E6CE9E4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100109@5C7117E6CE9E4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100109@5C7117E6CE9E4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '5B2759D2CF609A4FE050007F010051F3' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '5C80A745EA54F699E050007F01000509' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '5CFEB2FCAE11E8B4E050007F01001417' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '5EF44BB5146A472EE050007F01001C9C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '62CBD828E2172463E050007F0100593E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100110@5C7117E6CE9D4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100111@5C7117E6CE9F4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100111@5C7117E6CE9F4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100111@5C7117E6CE9F4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100112@5C7117E6CDE34125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100112@5C7117E6CDE34125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100112@5C7117E6CDE34125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100114@5C7117E6CDDA4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100114@5C7117E6CDDA4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100114@5C7117E6CDDA4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100114@5C7117E6CDDA4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100114@5C7117E6CDDA4125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100115@5C7117E6CDA94125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100117@5C7117E6CE9F4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100120@5C7117E6CEA04125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100120@5C7117E6CEA04125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100121@5C7117E6CEA04125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100121@5C7117E6CEA04125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100121@5C7117E6CEA04125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100121@5C7117E6CEA04125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100122@5C7117E6CDFF4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100122@5C7117E6CDFF4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100122@5C7117E6CDFF4125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100123@5C7117E6CED14125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100123@5C7117E6CED14125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100125@5C7117E6CE9E4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100125@5C7117E6CE9E4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100125@5C7117E6CE9E4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100126@5C7117E6CD924125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100126@5C7117E6CD924125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100126@5C7117E6CD924125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100126@5C7117E6CD924125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100127@5C7117E6CD924125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100127@5C7117E6CD924125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100127@5C7117E6CD924125E050007F010057D5', '7CF909AD3EA198DFE050007F01000195' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100130@5C7117E6CDFF4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100136@5C7117E6CD964125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100136@5C7117E6CD964125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100136@5C7117E6CD964125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100136@5C7117E6CD964125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100138@5C7117E6CEA04125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100138@5C7117E6CEA04125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100138@5C7117E6CEA04125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100140@5C7117E6CE814125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100140@5C7117E6CE814125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100140@5C7117E6CE814125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100140@5C7117E6CE814125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100146@5C7117E6CE854125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '6358A86026979B3CE050007F01006F7C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '6783B74F7C882BFEE050007F0100202E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100147@5C7117E6CD924125E050007F010057D5', '716B0E3F63675D97E050007F0100762C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100150@5C7117E6CD954125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100155@5C7117E6CD964125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100155@5C7117E6CD964125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100158@5C7117E6CEE44125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100159@5C7117E6CE9D4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100159@5C7117E6CE9D4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100159@5C7117E6CE9D4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '6783B74F7C882BFEE050007F0100202E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100162@5C7117E6CE814125E050007F010057D5', '7CF90F0459FAAF7CE050007F010001C4' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '60A8D018BE34D83CE050007F01003659' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '62CBD828E2172463E050007F0100593E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '6358A86026989B3CE050007F01006F7C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '6358AE2E6E26A762E050007F01006F9E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100163@5C7117E6CDDC4125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100166@5C7117E6CEE44125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100166@5C7117E6CEE44125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100167@5C7117E6CED04125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100167@5C7117E6CED04125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100169@5C7117E6CE9F4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100169@5C7117E6CE9F4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100169@5C7117E6CE9F4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100169@5C7117E6CE9F4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100173@5C7117E6CEEF4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '6358A94C2176B22AE050007F01006F7E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '6783B74F7C882BFEE050007F0100202E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100183@5C7117E6CE814125E050007F010057D5', '7CF90F0459FAAF7CE050007F010001C4' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100184@5C7117E6CE814125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100185@5C7117E6CEE44125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100187@6764A03B8481F731E050007F01004EF8', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100194@5C7117E6CE6A4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100194@5C7117E6CE6A4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100209@5C7117E6CDD74125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100213@5C7117E6CE9F4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100216@5C7117E6CD954125E050007F010057D5', '5CFEB2FCAE11E8B4E050007F01001417' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100216@5C7117E6CD954125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100216@5C7117E6CD954125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100216@5C7117E6CD954125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100217@5C7117E6CDFF4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100217@5C7117E6CDFF4125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100217@5C7117E6CDFF4125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100225@5C7117E6CD924125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100225@5C7117E6CD924125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100225@5C7117E6CD924125E050007F010057D5', '716B0E3F63675D97E050007F0100762C' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100240@5C7117E6CDFF4125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100240@5C7117E6CDFF4125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100248@5C7117E6CD924125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '5E7A78DE624A12F7E050007F010041A6' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '6358AE2E6E26A762E050007F01006F9E' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '6CD7383B10DDACBDE050007F0100563D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100253@5C7117E6CE814125E050007F010057D5', '6F97A29C9306707CE050007F01007680' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100259@5C7117E6CE6A4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100261@5C7117E6CD924125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100261@5C7117E6CD924125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100261@5C7117E6CD924125E050007F010057D5', '5FBAEFF9A5F23E43E050007F01005345' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100261@5C7117E6CD924125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100261@5C7117E6CD924125E050007F010057D5', '6D7922E91188A61BE050007F010018A8' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100268@5C7117E6CE9D4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100272@5C7117E6CD9C4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100287@5C7117E6CEA04125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100287@5C7117E6CEA04125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100287@5C7117E6CEA04125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100288@5C7117E6CF134125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100308@5C7117E6CE5F4125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100308@5C7117E6CE5F4125E050007F010057D5', '67353C1F96A27FFBE050007F01003B4B' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100308@5C7117E6CE5F4125E050007F010057D5', '67353E4644469CC7E050007F01003B49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100334@5C7117E6CD9C4125E050007F010057D5', '6358A43DB0933D5AE050007F01006F49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100334@6764A03B8486F731E050007F01004EF8', '6358A43DB0933D5AE050007F01006F49' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100335@5C7117E6CF274125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100416@5C7117E6CDFF4125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100416@5C7117E6CDFF4125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100417@5C7117E6CDA34125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100417@5C7117E6CDA34125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100417@5C7117E6CDA34125E050007F010057D5', '6358A6FC95F33EE2E050007F01006F63' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100417@5C7117E6CDA34125E050007F010057D5', '671B62358B6657F6E050007F01000F3D' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100417@5C7117E6CDA34125E050007F010057D5', '673536F16238B072E050007F01003AF2' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100417@5C7117E6CDA34125E050007F010057D5', '6B5C59E07CE14DD8E050007F01004196' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '5E7A78DE624A12F7E050007F010041A6' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '60D510356301982DE050007F01001D07' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '6A2A262E73BAFB17E050007F01005615' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '6F97A29C9306707CE050007F01007680' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100424@5C7117E6CE814125E050007F010057D5', '70D91ABBCE35ADB7E050007F010029E4' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100427@5C7117E6CE704125E050007F010057D5', '5E7A7B3AF5DECD42E050007F010041BF' );
INSERT INTO `sa_opauthorize`
VALUES
	( '100427@5C7117E6CE704125E050007F010057D5', '5E7A7C2DFA61EE12E050007F010041C7' );
INSERT INTO `sa_opauthorize`
VALUES
	( '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '298' );-- ----------------------------
-- Table structure for sa_opbasefunctiontype
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opbasefunctiontype`;
CREATE TABLE `sa_opbasefunctiontype` (
`ID` BIGINT ( 20 ) NOT NULL COMMENT 'BaseFunctionTypeID',
`FOLDER_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '文件夹ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '基础职能角色\r\n' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opbasemanagementtype
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opbasemanagementtype`;
CREATE TABLE `sa_opbasemanagementtype` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`BIZ_MANAGEMENT_TYPE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务权限ID',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目录ID',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '管理权限类别' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opbasemanagementtype
-- ----------------------------
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( '17519DBA3B684B9692534A12262D6783', 'admin', '行政管理权限', '84843FEE459A4663BDB4411F045AF783', 4, 463767, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( '291AEF9B6B4B4F0999FC23CCE76BA612', 'queryLog', '日志查询', '48B0938102354996BF3F076B63DB8234', 2, 28044, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( '2C5D75DBD8A3490F8FFA80E9825AFA09', 'procApprovalRule', '流程审批规则', '18D3CFB8D6C140E1939DCC7817E9EE66', 1, 256114, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( '46042F1D8A42481D8DD78FE1301FCBA5', 'tenant', '租户管理权限', '54D642DFA98A49B38F98852CB0C31CF1', 16, 170555, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( '7E1BA741902C4EAC83C28A951D276387', 'delegation', '分级授权', '2C7B69422F064D909E5AB142A3F24BAA', 3, 28045, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( 'D9C5759B78914010B099404D43DB460E', 'functionDelegation', '功能分级授权', 'A7954CBD424744859C832EBD6BDFDEEB', 6, 28079, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );
INSERT INTO `sa_opbasemanagementtype`
VALUES
	( 'DF3C8432E27C4E60AE031967663D1598', 'taskQuery', '任务查询', 'DCB940CC13CE43E08F077433A8771461', 5, 28054, '34DAC78038EE466F9595A73B001A8CF8', NULL, 1 );-- ----------------------------
-- Table structure for sa_opbizfunction
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opbizfunction`;
CREATE TABLE `sa_opbizfunction` (
`ID` BIGINT ( 20 ) NOT NULL COMMENT 'BizFunctionTypeId',
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织ID',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务职能角色\r\n' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opbizfunctionownbase
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opbizfunctionownbase`;
CREATE TABLE `sa_opbizfunctionownbase` (
`ID` BIGINT ( 20 ) NOT NULL COMMENT 'BizFunctionOwnBaseID',
`BIZ_FUNCTION_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT 'BizFunctionTypeId',
`BASE_FUNCTION_TYPE_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT 'BaseFunctionTypeID',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务职能角色对应基础职能' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opbizmanagement
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opbizmanagement`;
CREATE TABLE `sa_opbizmanagement` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`MANAGER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理者ID',
`MANAGE_TYPE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务权限类型ID',
`SUBORDINATION_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '下属ID',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`LAST_MODIFIED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LAST_MODIFIED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LAST_MODIFIED_DATE` datetime  NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '管理权限' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opbizmanagement
-- ----------------------------
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5B1A2F0CF951E730E050007F01003D9F', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', 'A7954CBD424744859C832EBD6BDFDEEB', 'E3B4E5C5C6454F81921CF58B7597CE2F', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-10-09 16:44:15', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-10-09 16:44:15', 268863 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5C80FF40800E5626E050007F010008BD', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2C7B69422F064D909E5AB142A3F24BAA', 'shanghaitech', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-10-27 12:49:16', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-10-27 12:49:16', 278985 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5C8101A06C93A5D5E050007F010008D1', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', 'A7954CBD424744859C832EBD6BDFDEEB', 'shanghaitech', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-10-27 12:49:44', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-10-27 12:49:44', 279010 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5D854BD50EE0C45EE050007F010003EE', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '18D3CFB8D6C140E1939DCC7817E9EE66', 'shanghaitech', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-11-09 11:22:07', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-11-09 11:22:07', 290156 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5D8671D5EB6C0189E050007F010010DE', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '18D3CFB8D6C140E1939DCC7817E9EE66', 'E3B4E5C5C6454F81921CF58B7597CE2F', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-11-09 12:44:20', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '2017-11-09 12:44:20', 290597 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5EA2C4DF933E7C65E050007F010003FB', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '2C7B69422F064D909E5AB142A3F24BAA', 'shanghaitech', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 15:57:12', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 15:57:12', 317008 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5EA38859E1A8C43EE050007F01000CE5', '100126@5C7117E6CD924125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0110', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 16:51:52', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 16:51:52', 317338 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5EA38992688DEC41E050007F01000CE7', '100138@5C7117E6CEA04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0106', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 16:52:13', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 16:52:13', 317353 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5EA3DA16C3202F17E050007F01000FF3', '100621@5C7117E6CDFF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0103', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 17:14:43', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 17:14:43', 317941 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5EA3E1C57039EF74E050007F01001030', '100111@5C7117E6CE9F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0109', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 17:16:52', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-11-23 17:16:52', 318000 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5F41E0B090D00650E050007F01000294', '5F167C7DB45D9A32E050007F01001BE8@C18E23AAAA6940E09DF7C122332C51E0', '84843FEE459A4663BDB4411F045AF783', '18FFF477AEEE4609B798015231B400C3', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-01 13:45:36', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-01 13:45:36', 327710 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5FA867E8949D9F39E050007F01000609', '100140@5C7117E6CE814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0108', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-06 16:04:55', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-06 16:04:55', 335109 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '5FB7B6F11F5E411DE050007F010030D6', '100159@5C7117E6CE9D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0107', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-07 10:21:44', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-07 10:21:44', 337689 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6057A4C2C94FC988E050007F010028BB', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '18D3CFB8D6C140E1939DCC7817E9EE66', 'shanghaitech', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-15 09:09:01', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-15 09:09:01', 363954 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '609808FD60E0B8E1E050007F01007BBA', '100194@5C7117E6CE6A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0112', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 13:58:22', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 13:58:22', 366696 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '60980A13B2E31316E050007F01007BC7', '100102@5C7117E6CD964125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0113', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 13:59:32', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 13:59:32', 366738 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '60982F3CB5228C2BE050007F01007D1E', '100167@5C7117E6CED04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:09:12', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:09:12', 367070 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '609843F11C8FF1D8E050007F01007DE0', '100006@5C7117E6CDA74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0206', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:15:16', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:15:16', 367246 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '60984818CFC95966E050007F01007E04', '100123@5C7117E6CED14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:16:01', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:16:01', 367274 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '60984C9AA0033EB6E050007F01007E1B', '211092@5C7117E6CE8B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:17:19', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2017-12-18 14:17:19', 367353 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '61EFCC2A0DB133D5E050007F01005EA3', '100308@5C7117E6CE5F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0205', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-01-04 16:06:01', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-01-04 16:06:01', 436074 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '61EFCD8A36AB2CE0E050007F01005EBB', '100856@5C7117E6CD654125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0208', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-01-04 16:06:40', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-01-04 16:06:40', 436106 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '61F00C0B08D5BB92E050007F01006124', '100166@5C7117E6CEE44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0105', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-01-04 16:23:53', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-01-04 16:23:53', 436247 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA41F7CF2E050007F010036EC', '200014@5C7117E6CD6F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0055', NULL, NULL, NULL, NULL, NULL, NULL, 459874 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4217CF2E050007F010036EC', '200015@5C7117E6CD704125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0054', NULL, NULL, NULL, NULL, NULL, NULL, 459876 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4237CF2E050007F010036EC', '100379@5C7117E6CE4E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0104', NULL, NULL, NULL, NULL, NULL, NULL, 459878 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4257CF2E050007F010036EC', '100387@5C7117E6CF674125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0112', NULL, NULL, NULL, NULL, NULL, NULL, 459880 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4277CF2E050007F010036EC', '100403@5C7117E6CE1E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0119', NULL, NULL, NULL, NULL, NULL, NULL, 459882 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4297CF2E050007F010036EC', '213007@5C7117E6CFA14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0007', NULL, NULL, NULL, NULL, NULL, NULL, 459884 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA42B7CF2E050007F010036EC', '213016@5C7117E6CD4C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0015', NULL, NULL, NULL, NULL, NULL, NULL, 459886 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA42D7CF2E050007F010036EC', '213026@5C7117E6CD444125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0024', NULL, NULL, NULL, NULL, NULL, NULL, 459888 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA42F7CF2E050007F010036EC', '213036@5C7117E6CE564125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0033', NULL, NULL, NULL, NULL, NULL, NULL, 459890 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4317CF2E050007F010036EC', '213047@5C7117E6CE0A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0043', NULL, NULL, NULL, NULL, NULL, NULL, 459892 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4337CF2E050007F010036EC', '213054@5C7117E6CDBF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0050', NULL, NULL, NULL, NULL, NULL, NULL, 459894 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4357CF2E050007F010036EC', '213065@5C7117E6CD3B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0060', NULL, NULL, NULL, NULL, NULL, NULL, 459896 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4377CF2E050007F010036EC', '213077@5C7117E6CD414125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0070', NULL, NULL, NULL, NULL, NULL, NULL, 459898 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4397CF2E050007F010036EC', '100343@5C7117E6CD364125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0078', NULL, NULL, NULL, NULL, NULL, NULL, 459900 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA43B7CF2E050007F010036EC', '100352@5C7117E6CDBD4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0087', NULL, NULL, NULL, NULL, NULL, NULL, 459902 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA43D7CF2E050007F010036EC', '100361@5C7117E6CD3F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0096', NULL, NULL, NULL, NULL, NULL, NULL, 459904 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA43F7CF2E050007F010036EC', '100291@5C7117E6CF154125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0008', NULL, NULL, NULL, NULL, NULL, NULL, 459906 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4417CF2E050007F010036EC', '100453@5C7117E6CE824125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0016', NULL, NULL, NULL, NULL, NULL, NULL, 459908 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4437CF2E050007F010036EC', '100716@5C7117E6CE364125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0025', NULL, NULL, NULL, NULL, NULL, NULL, 459910 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4457CF2E050007F010036EC', '100820@5C7117E6CE404125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0031', NULL, NULL, NULL, NULL, NULL, NULL, 459912 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4477CF2E050007F010036EC', '100176@5C7117E6CD944125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0004', NULL, NULL, NULL, NULL, NULL, NULL, 459914 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4497CF2E050007F010036EC', '100265@5C7117E6CEE34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0011', NULL, NULL, NULL, NULL, NULL, NULL, 459916 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA44B7CF2E050007F010036EC', '100419@5C7117E6CDA04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0018', NULL, NULL, NULL, NULL, NULL, NULL, 459918 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA44D7CF2E050007F010036EC', '100590@5C7117E6CD9B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0025', NULL, NULL, NULL, NULL, NULL, NULL, 459920 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA44F7CF2E050007F010036EC', '100737@5C7117E6CD824125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0032', NULL, NULL, NULL, NULL, NULL, NULL, 459922 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4517CF2E050007F010036EC', '100844@5C7117E6CE394125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0041', NULL, NULL, NULL, NULL, NULL, NULL, 459924 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4537CF2E050007F010036EC', '212001@5C7117E6CFA24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0001', NULL, NULL, NULL, NULL, NULL, NULL, 459926 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4557CF2E050007F010036EC', '212002@5C7117E6CF3F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0010', NULL, NULL, NULL, NULL, NULL, NULL, 459928 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4577CF2E050007F010036EC', '212015@5C7117E6CF2A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0020', NULL, NULL, NULL, NULL, NULL, NULL, 459930 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4597CF2E050007F010036EC', '212018@5C7117E6CF3D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0027', NULL, NULL, NULL, NULL, NULL, NULL, 459932 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA45B7CF2E050007F010036EC', '212036@5C7117E6CF494125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0037', NULL, NULL, NULL, NULL, NULL, NULL, 459934 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA45D7CF2E050007F010036EC', '212052@5C7117E6CFA44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0044', NULL, NULL, NULL, NULL, NULL, NULL, 459936 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4617CF2E050007F010036EC', '200007@5C7117E6CECE4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0004', NULL, NULL, NULL, NULL, NULL, NULL, 459940 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4637CF2E050007F010036EC', '100568@5C7117E6CE694125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0019', NULL, NULL, NULL, NULL, NULL, NULL, 459942 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4657CF2E050007F010036EC', '100630@5C7117E6CF114125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0026', NULL, NULL, NULL, NULL, NULL, NULL, 459944 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4677CF2E050007F010036EC', '100754@5C7117E6CE3B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0032', NULL, NULL, NULL, NULL, NULL, NULL, 459946 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4697CF2E050007F010036EC', '100891@5C7117E6CD784125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0043', NULL, NULL, NULL, NULL, NULL, NULL, 459948 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA46B7CF2E050007F010036EC', '211007@5C7117E6CD044125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0006', NULL, NULL, NULL, NULL, NULL, NULL, 459950 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA46D7CF2E050007F010036EC', '211017@5C7117E6CE234125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0015', NULL, NULL, NULL, NULL, NULL, NULL, 459952 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA46F7CF2E050007F010036EC', '211025@5C7117E6CF594125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0023', NULL, NULL, NULL, NULL, NULL, NULL, 459954 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4717CF2E050007F010036EC', '211033@5C7117E6CD274125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0031', NULL, NULL, NULL, NULL, NULL, NULL, 459956 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4737CF2E050007F010036EC', '211043@5C7117E6CF664125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0040', NULL, NULL, NULL, NULL, NULL, NULL, 459958 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4757CF2E050007F010036EC', '211052@5C7117E6CF6D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0049', NULL, NULL, NULL, NULL, NULL, NULL, 459960 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4777CF2E050007F010036EC', '211060@5C7117E6CE264125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0057', NULL, NULL, NULL, NULL, NULL, NULL, 459962 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4797CF2E050007F010036EC', '211071@5C7117E6CD0E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0067', NULL, NULL, NULL, NULL, NULL, NULL, 459964 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA47B7CF2E050007F010036EC', '211084@5C7117E6CE174125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0077', NULL, NULL, NULL, NULL, NULL, NULL, 459966 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA47D7CF2E050007F010036EC', '211093@5C7117E6CE1F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0085', NULL, NULL, NULL, NULL, NULL, NULL, 459968 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA47F7CF2E050007F010036EC', '100369@5C7117E6CF6F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0094', NULL, NULL, NULL, NULL, NULL, NULL, 459970 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4817CF2E050007F010036EC', '100336@5C7117E6CEDA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301F0004', NULL, NULL, NULL, NULL, NULL, NULL, 459972 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4837CF2E050007F010036EC', '100139@5C7117E6CED34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0001', NULL, NULL, NULL, NULL, NULL, NULL, 459974 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4857CF2E050007F010036EC', '100165@5C7117E6CEED4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0003', NULL, NULL, NULL, NULL, NULL, NULL, 459976 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4877CF2E050007F010036EC', '100175@5C7117E6CDA64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0005', NULL, NULL, NULL, NULL, NULL, NULL, 459978 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4897CF2E050007F010036EC', '100227@5C7117E6CEFE4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0007', NULL, NULL, NULL, NULL, NULL, NULL, 459980 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA48B7CF2E050007F010036EC', '100260@5C7117E6CEE04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0010', NULL, NULL, NULL, NULL, NULL, NULL, 459982 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA48D7CF2E050007F010036EC', '100269@5C7117E6CEE64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0012', NULL, NULL, NULL, NULL, NULL, NULL, 459984 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4917CF2E050007F010036EC', '100394@5C7117E6CF284125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0015', NULL, NULL, NULL, NULL, NULL, NULL, 459988 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4937CF2E050007F010036EC', '100438@5C7117E6CEC04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0019', NULL, NULL, NULL, NULL, NULL, NULL, 459990 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4957CF2E050007F010036EC', '100503@5C7117E6CDD54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0022', NULL, NULL, NULL, NULL, NULL, NULL, 459992 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4977CF2E050007F010036EC', '100575@5C7117E6CE6E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0024', NULL, NULL, NULL, NULL, NULL, NULL, 459994 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4997CF2E050007F010036EC', '100659@5C7117E6CF8A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0027', NULL, NULL, NULL, NULL, NULL, NULL, 459996 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA49B7CF2E050007F010036EC', '100724@5C7117E6CD804125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0028', NULL, NULL, NULL, NULL, NULL, NULL, 459998 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA49D7CF2E050007F010036EC', '100734@5C7117E6CCFF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0030', NULL, NULL, NULL, NULL, NULL, NULL, 460000 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA49F7CF2E050007F010036EC', '100735@5C7117E6CE3A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0031', NULL, NULL, NULL, NULL, NULL, NULL, 460002 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4A17CF2E050007F010036EC', '100755@5C7117E6CE2A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0035', NULL, NULL, NULL, NULL, NULL, NULL, 460004 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4A37CF2E050007F010036EC', '100827@5C7117E6CE464125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0038', NULL, NULL, NULL, NULL, NULL, NULL, 460006 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4A57CF2E050007F010036EC', '100832@5C7117E6CD504125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0039', NULL, NULL, NULL, NULL, NULL, NULL, 460008 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4A77CF2E050007F010036EC', '100857@5C7117E6CD644125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0043', NULL, NULL, NULL, NULL, NULL, NULL, 460010 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4A97CF2E050007F010036EC', '100890@5C7117E6CD774125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0044', NULL, NULL, NULL, NULL, NULL, NULL, 460012 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4AB7CF2E050007F010036EC', '212008@5C7117E6CF2C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0004', NULL, NULL, NULL, NULL, NULL, NULL, 460014 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4AD7CF2E050007F010036EC', '212007@5C7117E6CF314125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0005', NULL, NULL, NULL, NULL, NULL, NULL, 460016 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4AF7CF2E050007F010036EC', '212004@5C7117E6CF3B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0008', NULL, NULL, NULL, NULL, NULL, NULL, 460018 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4B17CF2E050007F010036EC', '212003@5C7117E6CF3E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0009', NULL, NULL, NULL, NULL, NULL, NULL, 460020 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4B37CF2E050007F010036EC', '212026@5C7117E6CFA64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0014', NULL, NULL, NULL, NULL, NULL, NULL, 460022 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4B57CF2E050007F010036EC', '212025@5C7117E6CFA94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0017', NULL, NULL, NULL, NULL, NULL, NULL, 460024 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4B77CF2E050007F010036EC', '212019@5C7117E6CFAB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0018', NULL, NULL, NULL, NULL, NULL, NULL, 460026 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4B97CF2E050007F010036EC', '212024@5C7117E6CF304125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0022', NULL, NULL, NULL, NULL, NULL, NULL, 460028 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4BB7CF2E050007F010036EC', '212028@5C7117E6CF344125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0023', NULL, NULL, NULL, NULL, NULL, NULL, 460030 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4BD7CF2E050007F010036EC', '212022@5C7117E6CF3A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0026', NULL, NULL, NULL, NULL, NULL, NULL, 460032 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4BF7CF2E050007F010036EC', '212021@5C7117E6CF474125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0029', NULL, NULL, NULL, NULL, NULL, NULL, 460034 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4C17CF2E050007F010036EC', '212031@5C7117E6CFAA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0031', NULL, NULL, NULL, NULL, NULL, NULL, 460036 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4C37CF2E050007F010036EC', '212038@5C7117E6CF3C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0033', NULL, NULL, NULL, NULL, NULL, NULL, 460038 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4C57CF2E050007F010036EC', '212040@5C7117E6CF424125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0035', NULL, NULL, NULL, NULL, NULL, NULL, 460040 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4C77CF2E050007F010036EC', '212046@5C7117E6CF2E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0038', NULL, NULL, NULL, NULL, NULL, NULL, 460042 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4C97CF2E050007F010036EC', '212047@5C7117E6CF354125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0041', NULL, NULL, NULL, NULL, NULL, NULL, 460044 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4CB7CF2E050007F010036EC', '212044@5C7117E6CF434125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0042', NULL, NULL, NULL, NULL, NULL, NULL, 460046 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4CD7CF2E050007F010036EC', '100525@5C7117E6CDE74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0046', NULL, NULL, NULL, NULL, NULL, NULL, 460048 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4CF7CF2E050007F010036EC', '100527@5C7117E6CDE94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0048', NULL, NULL, NULL, NULL, NULL, NULL, 460050 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4D17CF2E050007F010036EC', '100529@5C7117E6CDEB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0050', NULL, NULL, NULL, NULL, NULL, NULL, 460052 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4D37CF2E050007F010036EC', '100600@5C7117E6CEFF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0052', NULL, NULL, NULL, NULL, NULL, NULL, 460054 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4D57CF2E050007F010036EC', '100567@5C7117E6CE684125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0002', NULL, NULL, NULL, NULL, NULL, NULL, 460056 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4D77CF2E050007F010036EC', '100238@5C7117E6CEC64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0004', NULL, NULL, NULL, NULL, NULL, NULL, 460058 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4D97CF2E050007F010036EC', '100495@5C7117E6CDD04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0006', NULL, NULL, NULL, NULL, NULL, NULL, 460060 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4DB7CF2E050007F010036EC', '100674@5C7117E6CF914125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0010', NULL, NULL, NULL, NULL, NULL, NULL, 460062 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4DD7CF2E050007F010036EC', '100683@5C7117E6CDAF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0011', NULL, NULL, NULL, NULL, NULL, NULL, 460064 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4DF7CF2E050007F010036EC', '100688@5C7117E6CF9C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0013', NULL, NULL, NULL, NULL, NULL, NULL, 460066 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4E17CF2E050007F010036EC', '211092@5C7117E6CE8B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0002', NULL, NULL, NULL, NULL, NULL, NULL, 460068 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4E37CF2E050007F010036EC', '100189@5C7117E6CE8B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0003', NULL, NULL, NULL, NULL, NULL, NULL, 460070 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4E57CF2E050007F010036EC', '200009@5C7117E6CEA14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0006', NULL, NULL, NULL, NULL, NULL, NULL, 460072 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4E77CF2E050007F010036EC', '200005@5C7117E6CECC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0007', NULL, NULL, NULL, NULL, NULL, NULL, 460074 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4E97CF2E050007F010036EC', '100467@5C7117E6CDA44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0009', NULL, NULL, NULL, NULL, NULL, NULL, 460076 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4EB7CF2E050007F010036EC', '100508@5C7117E6CDD94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301P0001', NULL, NULL, NULL, NULL, NULL, NULL, 460078 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4ED7CF2E050007F010036EC', '100245@5C7117E6CDFE4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0001', NULL, NULL, NULL, NULL, NULL, NULL, 460080 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4EF7CF2E050007F010036EC', '100149@5C7117E6CDFC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0002', NULL, NULL, NULL, NULL, NULL, NULL, 460082 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4F17CF2E050007F010036EC', '100488@5C7117E6CDAC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0003', NULL, NULL, NULL, NULL, NULL, NULL, 460084 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4F37CF2E050007F010036EC', '100148@5C7117E6CDAC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0004', NULL, NULL, NULL, NULL, NULL, NULL, 460086 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4F57CF2E050007F010036EC', '100275@5C7117E6CEE84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0005', NULL, NULL, NULL, NULL, NULL, NULL, 460088 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4F77CF2E050007F010036EC', '100187@5C7117E6CD934125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0006', NULL, NULL, NULL, NULL, NULL, NULL, 460090 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4F97CF2E050007F010036EC', '100623@5C7117E6CE874125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302F0009', NULL, NULL, NULL, NULL, NULL, NULL, 460092 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4FB7CF2E050007F010036EC', '100123@5C7117E6CED14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0001', NULL, NULL, NULL, NULL, NULL, NULL, 460094 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4FD7CF2E050007F010036EC', '100144@5C7117E6CED64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0002', NULL, NULL, NULL, NULL, NULL, NULL, 460096 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA4FF7CF2E050007F010036EC', '100301@5C7117E6CF194125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0004', NULL, NULL, NULL, NULL, NULL, NULL, 460098 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5017CF2E050007F010036EC', '100315@5C7117E6CF204125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0005', NULL, NULL, NULL, NULL, NULL, NULL, 460100 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5037CF2E050007F010036EC', '100602@5C7117E6CF014125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0007', NULL, NULL, NULL, NULL, NULL, NULL, 460102 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5057CF2E050007F010036EC', '100638@5C7117E6CDB74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0008', NULL, NULL, NULL, NULL, NULL, NULL, 460104 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5077CF2E050007F010036EC', '200002@5C7117E6CECB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302D0001', NULL, NULL, NULL, NULL, NULL, NULL, 460106 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5097CF2E050007F010036EC', '100666@5C7117E6CF8C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302D0003', NULL, NULL, NULL, NULL, NULL, NULL, 460108 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA50B7CF2E050007F010036EC', '200010@5C7117E6CD8A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302D0004', NULL, NULL, NULL, NULL, NULL, NULL, 460110 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA50D7CF2E050007F010036EC', '213015@5C7117E6CCE74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0014', NULL, NULL, NULL, NULL, NULL, NULL, 460112 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA50F7CF2E050007F010036EC', '213019@5C7117E6CD2E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0018', NULL, NULL, NULL, NULL, NULL, NULL, 460114 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5117CF2E050007F010036EC', '213028@5C7117E6CDBB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0026', NULL, NULL, NULL, NULL, NULL, NULL, 460116 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5137CF2E050007F010036EC', '213033@5C7117E6CE084125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0030', NULL, NULL, NULL, NULL, NULL, NULL, 460118 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5157CF2E050007F010036EC', '213042@5C7117E6CD394125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0038', NULL, NULL, NULL, NULL, NULL, NULL, 460120 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5177CF2E050007F010036EC', '213046@5C7117E6CCE34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0042', NULL, NULL, NULL, NULL, NULL, NULL, 460122 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5197CF2E050007F010036EC', '213055@5C7117E6CDBE4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0051', NULL, NULL, NULL, NULL, NULL, NULL, 460124 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA51B7CF2E050007F010036EC', '213059@5C7117E6CCDE4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0055', NULL, NULL, NULL, NULL, NULL, NULL, 460126 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA51D7CF2E050007F010036EC', '213068@5C7117E6CE544125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0063', NULL, NULL, NULL, NULL, NULL, NULL, 460128 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA51F7CF2E050007F010036EC', '213073@5C7117E6CD454125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0067', NULL, NULL, NULL, NULL, NULL, NULL, 460130 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5217CF2E050007F010036EC', '213079@5C7117E6CE054125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0072', NULL, NULL, NULL, NULL, NULL, NULL, 460132 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5237CF2E050007F010036EC', '100345@5C7117E6CCEB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0080', NULL, NULL, NULL, NULL, NULL, NULL, 460134 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5257CF2E050007F010036EC', '100349@5C7117E6CD484125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0084', NULL, NULL, NULL, NULL, NULL, NULL, 460136 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5277CF2E050007F010036EC', '100358@5C7117E6CE584125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0093', NULL, NULL, NULL, NULL, NULL, NULL, 460138 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5297CF2E050007F010036EC', '100362@5C7117E6CCD84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0097', NULL, NULL, NULL, NULL, NULL, NULL, 460140 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA52B7CF2E050007F010036EC', '100290@5C7117E6CF144125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0007', NULL, NULL, NULL, NULL, NULL, NULL, 460142 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA52D7CF2E050007F010036EC', '100398@5C7117E6CE974125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0011', NULL, NULL, NULL, NULL, NULL, NULL, 460144 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA52F7CF2E050007F010036EC', '100520@5C7117E6CDE24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0019', NULL, NULL, NULL, NULL, NULL, NULL, 460146 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5317CF2E050007F010036EC', '100699@5C7117E6CE334125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0024', NULL, NULL, NULL, NULL, NULL, NULL, 460148 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5337CF2E050007F010036EC', '100819@5C7117E6CCF04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0032', NULL, NULL, NULL, NULL, NULL, NULL, 460150 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5357CF2E050007F010036EC', '100741@5C7117E6CD854125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0033', NULL, NULL, NULL, NULL, NULL, NULL, 460152 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5377CF2E050007F010036EC', '100796@5C7117E6CD8F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0037', NULL, NULL, NULL, NULL, NULL, NULL, 460154 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5397CF2E050007F010036EC', '212013@5C7117E6CFA34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0002', NULL, NULL, NULL, NULL, NULL, NULL, 460156 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA53B7CF2E050007F010036EC', '212006@5C7117E6CF394125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0007', NULL, NULL, NULL, NULL, NULL, NULL, 460158 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA53D7CF2E050007F010036EC', '212016@5C7117E6CFA74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0015', NULL, NULL, NULL, NULL, NULL, NULL, 460160 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA53F7CF2E050007F010036EC', '212030@5C7117E6CF294125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0019', NULL, NULL, NULL, NULL, NULL, NULL, 460162 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5417CF2E050007F010036EC', '212029@5C7117E6CF374125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0024', NULL, NULL, NULL, NULL, NULL, NULL, 460164 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5437CF2E050007F010036EC', '212034@5C7117E6CF2F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0032', NULL, NULL, NULL, NULL, NULL, NULL, 460166 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5457CF2E050007F010036EC', '212043@5C7117E6CF444125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0036', NULL, NULL, NULL, NULL, NULL, NULL, 460168 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5477CF2E050007F010036EC', '100524@5C7117E6CDE64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0045', NULL, NULL, NULL, NULL, NULL, NULL, 460170 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5497CF2E050007F010036EC', '100528@5C7117E6CDEA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0049', NULL, NULL, NULL, NULL, NULL, NULL, 460172 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA54B7CF2E050007F010036EC', '100282@5C7117E6CEE94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0005', NULL, NULL, NULL, NULL, NULL, NULL, 460174 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA54D7CF2E050007F010036EC', '100663@5C7117E6CF8B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0009', NULL, NULL, NULL, NULL, NULL, NULL, 460176 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA54F7CF2E050007F010036EC', '100723@5C7117E6CD7D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0014', NULL, NULL, NULL, NULL, NULL, NULL, 460178 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5517CF2E050007F010036EC', '200008@5C7117E6CECF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0008', NULL, NULL, NULL, NULL, NULL, NULL, 460180 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5537CF2E050007F010036EC', '100745@5C7117E6CE294125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0037', NULL, NULL, NULL, NULL, NULL, NULL, 460182 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5557CF2E050007F010036EC', '211006@5C7117E6CF704125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0005', NULL, NULL, NULL, NULL, NULL, NULL, 460184 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5577CF2E050007F010036EC', '211010@5C7117E6CD184125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0009', NULL, NULL, NULL, NULL, NULL, NULL, 460186 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5597CF2E050007F010036EC', '211014@5C7117E6CD034125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0013', NULL, NULL, NULL, NULL, NULL, NULL, 460188 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA55B7CF2E050007F010036EC', '211019@5C7117E6CE134125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0017', NULL, NULL, NULL, NULL, NULL, NULL, 460190 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA55D7CF2E050007F010036EC', '211023@5C7117E6CF764125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0021', NULL, NULL, NULL, NULL, NULL, NULL, 460192 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA55F7CF2E050007F010036EC', '211028@5C7117E6CD294125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0026', NULL, NULL, NULL, NULL, NULL, NULL, 460194 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5617CF2E050007F010036EC', '211032@5C7117E6CE0B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0030', NULL, NULL, NULL, NULL, NULL, NULL, 460196 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5637CF2E050007F010036EC', '211037@5C7117E6CF774125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0034', NULL, NULL, NULL, NULL, NULL, NULL, 460198 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5657CF2E050007F010036EC', '211041@5C7117E6CD194125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0038', NULL, NULL, NULL, NULL, NULL, NULL, 460200 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5677CF2E050007F010036EC', '211045@5C7117E6CF554125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0042', NULL, NULL, NULL, NULL, NULL, NULL, 460202 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5697CF2E050007F010036EC', '211050@5C7117E6CE0F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0047', NULL, NULL, NULL, NULL, NULL, NULL, 460204 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA56B7CF2E050007F010036EC', '211054@5C7117E6CF5D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0051', NULL, NULL, NULL, NULL, NULL, NULL, 460206 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA56D7CF2E050007F010036EC', '211058@5C7117E6CD094125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0055', NULL, NULL, NULL, NULL, NULL, NULL, 460208 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA56F7CF2E050007F010036EC', '211062@5C7117E6CE214125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0059', NULL, NULL, NULL, NULL, NULL, NULL, 460210 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5717CF2E050007F010036EC', '211066@5C7117E6CE184125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0063', NULL, NULL, NULL, NULL, NULL, NULL, 460212 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5737CF2E050007F010036EC', '211072@5C7117E6CE164125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0068', NULL, NULL, NULL, NULL, NULL, NULL, 460214 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5757CF2E050007F010036EC', '100786@5C7117E6CD624125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0028', NULL, NULL, NULL, NULL, NULL, NULL, 460216 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5777CF2E050007F010036EC', '100853@5C7117E6CCF54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0042', NULL, NULL, NULL, NULL, NULL, NULL, 460218 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5797CF2E050007F010036EC', '212012@5C7117E6CF464125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0011', NULL, NULL, NULL, NULL, NULL, NULL, 460220 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA57B7CF2E050007F010036EC', '212027@5C7117E6CF414125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0028', NULL, NULL, NULL, NULL, NULL, NULL, 460222 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA57D7CF2E050007F010036EC', '212048@5C7117E6CF334125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0040', NULL, NULL, NULL, NULL, NULL, NULL, 460224 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA57F7CF2E050007F010036EC', '100643@5C7117E6CEAD4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0053', NULL, NULL, NULL, NULL, NULL, NULL, 460226 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5817CF2E050007F010036EC', '200001@5C7117E6CE8B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0001', NULL, NULL, NULL, NULL, NULL, NULL, 460228 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5857CF2E050007F010036EC', '100264@5C7117E6CEE24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0006', NULL, NULL, NULL, NULL, NULL, NULL, 460232 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5877CF2E050007F010036EC', '100320@5C7117E6CF224125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0009', NULL, NULL, NULL, NULL, NULL, NULL, 460234 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5897CF2E050007F010036EC', '100396@5C7117E6CE964125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0011', NULL, NULL, NULL, NULL, NULL, NULL, 460236 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA58B7CF2E050007F010036EC', '100458@5C7117E6CEA24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0014', NULL, NULL, NULL, NULL, NULL, NULL, 460238 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA58D7CF2E050007F010036EC', '100586@5C7117E6CE734125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0020', NULL, NULL, NULL, NULL, NULL, NULL, 460240 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA58F7CF2E050007F010036EC', '100628@5C7117E6CF0F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0023', NULL, NULL, NULL, NULL, NULL, NULL, 460242 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5917CF2E050007F010036EC', '100675@5C7117E6CF924125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0027', NULL, NULL, NULL, NULL, NULL, NULL, 460244 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5937CF2E050007F010036EC', '100736@5C7117E6CD814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0030', NULL, NULL, NULL, NULL, NULL, NULL, 460246 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5957CF2E050007F010036EC', '100764@5C7117E6CE3C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0033', NULL, NULL, NULL, NULL, NULL, NULL, 460248 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5977CF2E050007F010036EC', '100762@5C7117E6CCFD4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0038', NULL, NULL, NULL, NULL, NULL, NULL, 460250 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5997CF2E050007F010036EC', '100888@5C7117E6CD4E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0042', NULL, NULL, NULL, NULL, NULL, NULL, 460252 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA59B7CF2E050007F010036EC', '211002@5C7117E6CD104125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0002', NULL, NULL, NULL, NULL, NULL, NULL, 460254 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA59D7CF2E050007F010036EC', '211004@5C7117E6CF684125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0004', NULL, NULL, NULL, NULL, NULL, NULL, 460256 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA59F7CF2E050007F010036EC', '211011@5C7117E6CD1C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0010', NULL, NULL, NULL, NULL, NULL, NULL, 460258 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5A17CF2E050007F010036EC', '211015@5C7117E6CF7A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0014', NULL, NULL, NULL, NULL, NULL, NULL, 460260 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5A37CF2E050007F010036EC', '211021@5C7117E6CE4F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0019', NULL, NULL, NULL, NULL, NULL, NULL, 460262 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5A57CF2E050007F010036EC', '211026@5C7117E6CD244125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0024', NULL, NULL, NULL, NULL, NULL, NULL, 460264 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5A77CF2E050007F010036EC', '211029@5C7117E6CF654125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0027', NULL, NULL, NULL, NULL, NULL, NULL, 460266 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5A97CF2E050007F010036EC', '211034@5C7117E6CF6E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0032', NULL, NULL, NULL, NULL, NULL, NULL, 460268 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5AB7CF2E050007F010036EC', '211039@5C7117E6CD164125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0036', NULL, NULL, NULL, NULL, NULL, NULL, 460270 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5AD7CF2E050007F010036EC', '211044@5C7117E6CF784125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0041', NULL, NULL, NULL, NULL, NULL, NULL, 460272 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5AF7CF2E050007F010036EC', '211048@5C7117E6CE144125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0045', NULL, NULL, NULL, NULL, NULL, NULL, 460274 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5B17CF2E050007F010036EC', '211053@5C7117E6CD084125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0050', NULL, NULL, NULL, NULL, NULL, NULL, 460276 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5B37CF2E050007F010036EC', '211057@5C7117E6CF734125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0054', NULL, NULL, NULL, NULL, NULL, NULL, 460278 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5B57CF2E050007F010036EC', '211061@5C7117E6CE224125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0058', NULL, NULL, NULL, NULL, NULL, NULL, 460280 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5B77CF2E050007F010036EC', '211065@5C7117E6CF634125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0062', NULL, NULL, NULL, NULL, NULL, NULL, 460282 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5B97CF2E050007F010036EC', '211070@5C7117E6CE0D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0066', NULL, NULL, NULL, NULL, NULL, NULL, 460284 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5BB7CF2E050007F010036EC', '211075@5C7117E6CF5A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0071', NULL, NULL, NULL, NULL, NULL, NULL, 460286 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5BD7CF2E050007F010036EC', '211080@5C7117E6CE504125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0074', NULL, NULL, NULL, NULL, NULL, NULL, 460288 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5BF7CF2E050007F010036EC', '211086@5C7117E6CE244125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0079', NULL, NULL, NULL, NULL, NULL, NULL, 460290 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5C17CF2E050007F010036EC', '211090@5C7117E6CF6A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0083', NULL, NULL, NULL, NULL, NULL, NULL, 460292 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5C37CF2E050007F010036EC', '100364@5C7117E6CF5C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0089', NULL, NULL, NULL, NULL, NULL, NULL, 460294 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5C57CF2E050007F010036EC', '100368@5C7117E6CF6C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0093', NULL, NULL, NULL, NULL, NULL, NULL, 460296 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5C77CF2E050007F010036EC', '100373@5C7117E6CD284125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0098', NULL, NULL, NULL, NULL, NULL, NULL, 460298 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5C97CF2E050007F010036EC', '100375@5C7117E6CE4A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0100', NULL, NULL, NULL, NULL, NULL, NULL, 460300 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5CB7CF2E050007F010036EC', '213058@5C7117E6CD334125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0054', NULL, NULL, NULL, NULL, NULL, NULL, 460302 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5CD7CF2E050007F010036EC', '212005@5C7117E6CF484125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0012', NULL, NULL, NULL, NULL, NULL, NULL, 460304 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5CF7CF2E050007F010036EC', '100675@5C7117E6CF924125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201F0002', NULL, NULL, NULL, NULL, NULL, NULL, 460306 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5D17CF2E050007F010036EC', '100423@5C7117E6CEBA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201F0001', NULL, NULL, NULL, NULL, NULL, NULL, 460308 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5D57CF2E050007F010036EC', '100164@5C7117E6CEEB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0004', NULL, NULL, NULL, NULL, NULL, NULL, 460312 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5D77CF2E050007F010036EC', '100229@5C7117E6CDFA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0005', NULL, NULL, NULL, NULL, NULL, NULL, 460314 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5D97CF2E050007F010036EC', '100267@5C7117E6CEE54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0007', NULL, NULL, NULL, NULL, NULL, NULL, 460316 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5DB7CF2E050007F010036EC', '100309@5C7117E6CF1B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0008', NULL, NULL, NULL, NULL, NULL, NULL, 460318 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5DD7CF2E050007F010036EC', '100335@5C7117E6CF274125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0010', NULL, NULL, NULL, NULL, NULL, NULL, 460320 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5DF7CF2E050007F010036EC', '100428@5C7117E6CEBC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0012', NULL, NULL, NULL, NULL, NULL, NULL, 460322 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5E17CF2E050007F010036EC', '100451@5C7117E6CE804125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0013', NULL, NULL, NULL, NULL, NULL, NULL, 460324 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5E37CF2E050007F010036EC', '100489@5C7117E6CDCC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0016', NULL, NULL, NULL, NULL, NULL, NULL, 460326 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5E57CF2E050007F010036EC', '100499@5C7117E6CDD34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0017', NULL, NULL, NULL, NULL, NULL, NULL, 460328 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5E77CF2E050007F010036EC', '100545@5C7117E6CDF94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0018', NULL, NULL, NULL, NULL, NULL, NULL, 460330 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5E97CF2E050007F010036EC', '100588@5C7117E6CE754125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0021', NULL, NULL, NULL, NULL, NULL, NULL, 460332 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5EB7CF2E050007F010036EC', '100604@5C7117E6CE924125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0022', NULL, NULL, NULL, NULL, NULL, NULL, 460334 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5EF7CF2E050007F010036EC', '100656@5C7117E6CF884125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0025', NULL, NULL, NULL, NULL, NULL, NULL, 460338 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5F17CF2E050007F010036EC', '100686@5C7117E6CDB24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0028', NULL, NULL, NULL, NULL, NULL, NULL, 460340 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5F37CF2E050007F010036EC', '100733@5C7117E6CDC14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0029', NULL, NULL, NULL, NULL, NULL, NULL, 460342 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5F57CF2E050007F010036EC', '100763@5C7117E6CCFC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0031', NULL, NULL, NULL, NULL, NULL, NULL, 460344 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5F77CF2E050007F010036EC', '100772@5C7117E6CCF34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0034', NULL, NULL, NULL, NULL, NULL, NULL, 460346 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5FB7CF2E050007F010036EC', '100829@5C7117E6CE474125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0039', NULL, NULL, NULL, NULL, NULL, NULL, 460350 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5FD7CF2E050007F010036EC', '100868@5C7117E6CCF64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0040', NULL, NULL, NULL, NULL, NULL, NULL, 460352 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA5FF7CF2E050007F010036EC', '211001@5C7117E6CD0F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0001', NULL, NULL, NULL, NULL, NULL, NULL, 460354 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6017CF2E050007F010036EC', '211003@5C7117E6CD0D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0003', NULL, NULL, NULL, NULL, NULL, NULL, 460356 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6037CF2E050007F010036EC', '211008@5C7117E6CF544125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0007', NULL, NULL, NULL, NULL, NULL, NULL, 460358 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6057CF2E050007F010036EC', '211009@5C7117E6CD214125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0008', NULL, NULL, NULL, NULL, NULL, NULL, 460360 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6077CF2E050007F010036EC', '211012@5C7117E6CF614125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0011', NULL, NULL, NULL, NULL, NULL, NULL, 460362 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6097CF2E050007F010036EC', '211013@5C7117E6CF564125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0012', NULL, NULL, NULL, NULL, NULL, NULL, 460364 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA60B7CF2E050007F010036EC', '211018@5C7117E6CD134125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0016', NULL, NULL, NULL, NULL, NULL, NULL, 460366 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA60D7CF2E050007F010036EC', '211020@5C7117E6CE124125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0018', NULL, NULL, NULL, NULL, NULL, NULL, 460368 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA60F7CF2E050007F010036EC', '211022@5C7117E6CD2B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0020', NULL, NULL, NULL, NULL, NULL, NULL, 460370 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6117CF2E050007F010036EC', '211024@5C7117E6CF754125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0022', NULL, NULL, NULL, NULL, NULL, NULL, 460372 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6137CF2E050007F010036EC', '211027@5C7117E6CD2A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0025', NULL, NULL, NULL, NULL, NULL, NULL, 460374 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6157CF2E050007F010036EC', '211030@5C7117E6CD1B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0028', NULL, NULL, NULL, NULL, NULL, NULL, 460376 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6177CF2E050007F010036EC', '211031@5C7117E6CF624125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0029', NULL, NULL, NULL, NULL, NULL, NULL, 460378 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6197CF2E050007F010036EC', '211036@5C7117E6CEC44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0033', NULL, NULL, NULL, NULL, NULL, NULL, 460380 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA61B7CF2E050007F010036EC', '211038@5C7117E6CD074125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0035', NULL, NULL, NULL, NULL, NULL, NULL, 460382 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA61D7CF2E050007F010036EC', '211076@5C7117E6CD1D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0109', NULL, NULL, NULL, NULL, NULL, NULL, 460384 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA61F7CF2E050007F010036EC', '211083@5C7117E6CD254125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0076', NULL, NULL, NULL, NULL, NULL, NULL, 460386 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6217CF2E050007F010036EC', '211087@5C7117E6CD144125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0080', NULL, NULL, NULL, NULL, NULL, NULL, 460388 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6237CF2E050007F010036EC', '211091@5C7117E6CF5F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0084', NULL, NULL, NULL, NULL, NULL, NULL, 460390 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6257CF2E050007F010036EC', '100188@5C7117E6CF714125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0088', NULL, NULL, NULL, NULL, NULL, NULL, 460392 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6277CF2E050007F010036EC', '100367@5C7117E6CF694125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0092', NULL, NULL, NULL, NULL, NULL, NULL, 460394 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6297CF2E050007F010036EC', '100372@5C7117E6CD234125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0097', NULL, NULL, NULL, NULL, NULL, NULL, 460396 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA62B7CF2E050007F010036EC', '100376@5C7117E6CF574125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0101', NULL, NULL, NULL, NULL, NULL, NULL, 460398 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA62D7CF2E050007F010036EC', '100778@5C7117E6CD024125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0035', NULL, NULL, NULL, NULL, NULL, NULL, 460400 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA62F7CF2E050007F010036EC', '100277@5C7117E6CE894125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301F0001', NULL, NULL, NULL, NULL, NULL, NULL, 460402 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6317CF2E050007F010036EC', '100005@5C7117E6CDA74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0001', NULL, NULL, NULL, NULL, NULL, NULL, 460404 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6337CF2E050007F010036EC', '100484@5C7117E6CDC84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201P0015', NULL, NULL, NULL, NULL, NULL, NULL, 460406 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6357CF2E050007F010036EC', '100386@5C7117E6CEC54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0111', NULL, NULL, NULL, NULL, NULL, NULL, 460408 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6377CF2E050007F010036EC', '100498@5C7117E6CDC44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201F0003', NULL, NULL, NULL, NULL, NULL, NULL, 460410 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6397CF2E050007F010036EC', '100610@5C7117E6CF054125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202F0001', NULL, NULL, NULL, NULL, NULL, NULL, 460412 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA63B7CF2E050007F010036EC', '100693@5C7117E6CF964125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202F0003', NULL, NULL, NULL, NULL, NULL, NULL, 460414 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA63D7CF2E050007F010036EC', '100814@5C7117E6CE314125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301F0005', NULL, NULL, NULL, NULL, NULL, NULL, 460416 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA63F7CF2E050007F010036EC', '100380@5C7117E6CF744125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0105', NULL, NULL, NULL, NULL, NULL, NULL, 460418 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6417CF2E050007F010036EC', '100385@5C7117E6CD264125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0110', NULL, NULL, NULL, NULL, NULL, NULL, 460420 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6437CF2E050007F010036EC', '100390@5C7117E6CD0B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0115', NULL, NULL, NULL, NULL, NULL, NULL, 460422 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6457CF2E050007F010036EC', '100402@5C7117E6CE4D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0118', NULL, NULL, NULL, NULL, NULL, NULL, 460424 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6477CF2E050007F010036EC', '100328@5C7117E6CF244125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0122', NULL, NULL, NULL, NULL, NULL, NULL, 460426 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA64B7CF2E050007F010036EC', '213004@5C7117E6CD384125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0004', NULL, NULL, NULL, NULL, NULL, NULL, 460430 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA64D7CF2E050007F010036EC', '213008@5C7117E6CF864125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0008', NULL, NULL, NULL, NULL, NULL, NULL, 460432 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA64F7CF2E050007F010036EC', '213012@5C7117E6CD374125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0011', NULL, NULL, NULL, NULL, NULL, NULL, 460434 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6517CF2E050007F010036EC', '213017@5C7117E6CD2F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0016', NULL, NULL, NULL, NULL, NULL, NULL, 460436 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6537CF2E050007F010036EC', '213021@5C7117E6CDBA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0020', NULL, NULL, NULL, NULL, NULL, NULL, 460438 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6557CF2E050007F010036EC', '213025@5C7117E6CE524125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0023', NULL, NULL, NULL, NULL, NULL, NULL, 460440 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6577CF2E050007F010036EC', '213031@5C7117E6CD4D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0028', NULL, NULL, NULL, NULL, NULL, NULL, 460442 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6597CF2E050007F010036EC', '213035@5C7117E6CCDB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0032', NULL, NULL, NULL, NULL, NULL, NULL, 460444 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA65B7CF2E050007F010036EC', '213041@5C7117E6CCE94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0037', NULL, NULL, NULL, NULL, NULL, NULL, 460446 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA65D7CF2E050007F010036EC', '213045@5C7117E6CF7D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0041', NULL, NULL, NULL, NULL, NULL, NULL, 460448 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA65F7CF2E050007F010036EC', '213049@5C7117E6CD3E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0045', NULL, NULL, NULL, NULL, NULL, NULL, 460450 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6617CF2E050007F010036EC', '213053@5C7117E6CCD64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0049', NULL, NULL, NULL, NULL, NULL, NULL, 460452 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6637CF2E050007F010036EC', '213060@5C7117E6CDBC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0056', NULL, NULL, NULL, NULL, NULL, NULL, 460454 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6657CF2E050007F010036EC', '213067@5C7117E6CE514125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0062', NULL, NULL, NULL, NULL, NULL, NULL, 460456 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6677CF2E050007F010036EC', '213070@5C7117E6CE5B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0065', NULL, NULL, NULL, NULL, NULL, NULL, 460458 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6697CF2E050007F010036EC', '213075@5C7117E6CDB94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0069', NULL, NULL, NULL, NULL, NULL, NULL, 460460 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA66B7CF2E050007F010036EC', '100339@5C7117E6CCE64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0074', NULL, NULL, NULL, NULL, NULL, NULL, 460462 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA66D7CF2E050007F010036EC', '100344@5C7117E6CD3D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0079', NULL, NULL, NULL, NULL, NULL, NULL, 460464 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA66F7CF2E050007F010036EC', '100348@5C7117E6CD474125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0083', NULL, NULL, NULL, NULL, NULL, NULL, 460466 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6717CF2E050007F010036EC', '100351@5C7117E6CDB84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0086', NULL, NULL, NULL, NULL, NULL, NULL, 460468 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6737CF2E050007F010036EC', '100356@5C7117E6CCDD4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0091', NULL, NULL, NULL, NULL, NULL, NULL, 460470 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6757CF2E050007F010036EC', '100360@5C7117E6CF9D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0095', NULL, NULL, NULL, NULL, NULL, NULL, 460472 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6777CF2E050007F010036EC', '100173@5C7117E6CEEF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0002', NULL, NULL, NULL, NULL, NULL, NULL, 460474 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6797CF2E050007F010036EC', '100219@5C7117E6CE8A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0005', NULL, NULL, NULL, NULL, NULL, NULL, 460476 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA67B7CF2E050007F010036EC', '100331@5C7117E6CF264125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0010', NULL, NULL, NULL, NULL, NULL, NULL, 460478 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA67D7CF2E050007F010036EC', '100437@5C7117E6CEBF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0014', NULL, NULL, NULL, NULL, NULL, NULL, 460480 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA67F7CF2E050007F010036EC', '100549@5C7117E6CE5D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0020', NULL, NULL, NULL, NULL, NULL, NULL, 460482 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6817CF2E050007F010036EC', '100625@5C7117E6CF0D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0022', NULL, NULL, NULL, NULL, NULL, NULL, 460484 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6837CF2E050007F010036EC', '100749@5C7117E6CD764125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0027', NULL, NULL, NULL, NULL, NULL, NULL, 460486 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6857CF2E050007F010036EC', '100824@5C7117E6CE344125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0033', NULL, NULL, NULL, NULL, NULL, NULL, 460488 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6877CF2E050007F010036EC', '100151@5C7117E6CED94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0002', NULL, NULL, NULL, NULL, NULL, NULL, 460490 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6897CF2E050007F010036EC', '100197@5C7117E6CEF34125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0006', NULL, NULL, NULL, NULL, NULL, NULL, 460492 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA68B7CF2E050007F010036EC', '100258@5C7117E6CEDF4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0009', NULL, NULL, NULL, NULL, NULL, NULL, 460494 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA68D7CF2E050007F010036EC', '100284@5C7117E6CEEA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0013', NULL, NULL, NULL, NULL, NULL, NULL, 460496 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA68F7CF2E050007F010036EC', '100406@5C7117E6CE9A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0016', NULL, NULL, NULL, NULL, NULL, NULL, 460498 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6917CF2E050007F010036EC', '100439@5C7117E6CEC14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0020', NULL, NULL, NULL, NULL, NULL, NULL, 460500 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6957CF2E050007F010036EC', '100607@5C7117E6CF944125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0026', NULL, NULL, NULL, NULL, NULL, NULL, 460504 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6977CF2E050007F010036EC', '100746@5C7117E6CE434125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0034', NULL, NULL, NULL, NULL, NULL, NULL, 460506 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6997CF2E050007F010036EC', '100782@5C7117E6CCF24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0036', NULL, NULL, NULL, NULL, NULL, NULL, 460508 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA69B7CF2E050007F010036EC', '100837@5C7117E6CE484125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203P0040', NULL, NULL, NULL, NULL, NULL, NULL, 460510 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA69D7CF2E050007F010036EC', '212010@5C7117E6CF2B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0003', NULL, NULL, NULL, NULL, NULL, NULL, 460512 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA69F7CF2E050007F010036EC', '212011@5C7117E6CF364125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0006', NULL, NULL, NULL, NULL, NULL, NULL, 460514 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6A17CF2E050007F010036EC', '212009@5C7117E6CF4A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0013', NULL, NULL, NULL, NULL, NULL, NULL, 460516 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6A37CF2E050007F010036EC', '212017@5C7117E6CFA84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0016', NULL, NULL, NULL, NULL, NULL, NULL, 460518 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6A57CF2E050007F010036EC', '212023@5C7117E6CF2D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0021', NULL, NULL, NULL, NULL, NULL, NULL, 460520 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6A77CF2E050007F010036EC', '212020@5C7117E6CF384125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0025', NULL, NULL, NULL, NULL, NULL, NULL, 460522 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6A97CF2E050007F010036EC', '212033@5C7117E6CFA54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0030', NULL, NULL, NULL, NULL, NULL, NULL, 460524 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6AB7CF2E050007F010036EC', '212039@5C7117E6CF404125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0034', NULL, NULL, NULL, NULL, NULL, NULL, 460526 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6AD7CF2E050007F010036EC', '213066@5C7117E6CCEA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0061', NULL, NULL, NULL, NULL, NULL, NULL, 460528 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6AF7CF2E050007F010036EC', '100384@5C7117E6CD1D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0072', NULL, NULL, NULL, NULL, NULL, NULL, 460530 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6B17CF2E050007F010036EC', '212049@5C7117E6CF324125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0039', NULL, NULL, NULL, NULL, NULL, NULL, 460532 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6B37CF2E050007F010036EC', '212045@5C7117E6CF4B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0043', NULL, NULL, NULL, NULL, NULL, NULL, 460534 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6B57CF2E050007F010036EC', '100526@5C7117E6CDE84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0047', NULL, NULL, NULL, NULL, NULL, NULL, 460536 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6B77CF2E050007F010036EC', '100157@5C7117E6CF454125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0203D0051', NULL, NULL, NULL, NULL, NULL, NULL, 460538 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6BB7CF2E050007F010036EC', '100587@5C7117E6CE744125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0008', NULL, NULL, NULL, NULL, NULL, NULL, 460542 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6BD7CF2E050007F010036EC', '100685@5C7117E6CDB14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0012', NULL, NULL, NULL, NULL, NULL, NULL, 460544 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6BF7CF2E050007F010036EC', '100831@5C7117E6CE424125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0204P0015', NULL, NULL, NULL, NULL, NULL, NULL, 460546 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6C17CF2E050007F010036EC', '200006@5C7117E6CECD4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0301D0005', NULL, NULL, NULL, NULL, NULL, NULL, 460548 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6C57CF2E050007F010036EC', '100595@5C7117E6CE784125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0006', NULL, NULL, NULL, NULL, NULL, NULL, 460552 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6C97CF2E050007F010036EC', '100174@5C7117E6CECA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302D0002', NULL, NULL, NULL, NULL, NULL, NULL, 460556 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6CB7CF2E050007F010036EC', '213024@5C7117E6CD404125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0022', NULL, NULL, NULL, NULL, NULL, NULL, 460558 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6CD7CF2E050007F010036EC', '213038@5C7117E6CCE44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0034', NULL, NULL, NULL, NULL, NULL, NULL, 460560 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6CF7CF2E050007F010036EC', '213051@5C7117E6CD4A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0047', NULL, NULL, NULL, NULL, NULL, NULL, 460562 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6D17CF2E050007F010036EC', '213064@5C7117E6CCD54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0059', NULL, NULL, NULL, NULL, NULL, NULL, 460564 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6D37CF2E050007F010036EC', '100341@5C7117E6CE574125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0076', NULL, NULL, NULL, NULL, NULL, NULL, 460566 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6D57CF2E050007F010036EC', '100353@5C7117E6CFA04125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0088', NULL, NULL, NULL, NULL, NULL, NULL, 460568 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6D77CF2E050007F010036EC', '100201@5C7117E6CEF54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0003', NULL, NULL, NULL, NULL, NULL, NULL, 460570 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6D97CF2E050007F010036EC', '100450@5C7117E6CDA54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0015', NULL, NULL, NULL, NULL, NULL, NULL, 460572 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6DB7CF2E050007F010036EC', '211040@5C7117E6CE1D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0037', NULL, NULL, NULL, NULL, NULL, NULL, 460574 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6DD7CF2E050007F010036EC', '211042@5C7117E6CE104125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0039', NULL, NULL, NULL, NULL, NULL, NULL, 460576 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6DF7CF2E050007F010036EC', '211046@5C7117E6CF5B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0043', NULL, NULL, NULL, NULL, NULL, NULL, 460578 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6E17CF2E050007F010036EC', '211047@5C7117E6CF6B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0044', NULL, NULL, NULL, NULL, NULL, NULL, 460580 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6E37CF2E050007F010036EC', '211049@5C7117E6CE0C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0046', NULL, NULL, NULL, NULL, NULL, NULL, 460582 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6E57CF2E050007F010036EC', '211051@5C7117E6CE114125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0048', NULL, NULL, NULL, NULL, NULL, NULL, 460584 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6E77CF2E050007F010036EC', '211055@5C7117E6CF644125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0052', NULL, NULL, NULL, NULL, NULL, NULL, 460586 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6E97CF2E050007F010036EC', '211056@5C7117E6CE1A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0053', NULL, NULL, NULL, NULL, NULL, NULL, 460588 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6EB7CF2E050007F010036EC', '211059@5C7117E6CF724125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0056', NULL, NULL, NULL, NULL, NULL, NULL, 460590 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6ED7CF2E050007F010036EC', '211063@5C7117E6CE194125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0060', NULL, NULL, NULL, NULL, NULL, NULL, 460592 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6EF7CF2E050007F010036EC', '211064@5C7117E6CF794125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0061', NULL, NULL, NULL, NULL, NULL, NULL, 460594 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6F17CF2E050007F010036EC', '211067@5C7117E6CF584125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0064', NULL, NULL, NULL, NULL, NULL, NULL, 460596 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6F37CF2E050007F010036EC', '211068@5C7117E6CF534125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0065', NULL, NULL, NULL, NULL, NULL, NULL, 460598 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6F57CF2E050007F010036EC', '211073@5C7117E6CD064125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0069', NULL, NULL, NULL, NULL, NULL, NULL, 460600 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6F77CF2E050007F010036EC', '211074@5C7117E6CE204125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0070', NULL, NULL, NULL, NULL, NULL, NULL, 460602 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6F97CF2E050007F010036EC', '211077@5C7117E6CD124125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0073', NULL, NULL, NULL, NULL, NULL, NULL, 460604 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6FB7CF2E050007F010036EC', '211081@5C7117E6CD2C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0075', NULL, NULL, NULL, NULL, NULL, NULL, 460606 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6FD7CF2E050007F010036EC', '211085@5C7117E6CD114125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0078', NULL, NULL, NULL, NULL, NULL, NULL, 460608 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA6FF7CF2E050007F010036EC', '211088@5C7117E6CF524125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0081', NULL, NULL, NULL, NULL, NULL, NULL, 460610 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7017CF2E050007F010036EC', '211089@5C7117E6CD1E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0082', NULL, NULL, NULL, NULL, NULL, NULL, 460612 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7037CF2E050007F010036EC', '212014@5C7117E6CF604125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0086', NULL, NULL, NULL, NULL, NULL, NULL, 460614 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7057CF2E050007F010036EC', '211005@5C7117E6CD974125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0087', NULL, NULL, NULL, NULL, NULL, NULL, 460616 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7077CF2E050007F010036EC', '100365@5C7117E6CF5E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0090', NULL, NULL, NULL, NULL, NULL, NULL, 460618 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7097CF2E050007F010036EC', '100366@5C7117E6CE154125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0091', NULL, NULL, NULL, NULL, NULL, NULL, 460620 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA70B7CF2E050007F010036EC', '100370@5C7117E6CD054125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0095', NULL, NULL, NULL, NULL, NULL, NULL, 460622 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA70D7CF2E050007F010036EC', '100371@5C7117E6CD1F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0096', NULL, NULL, NULL, NULL, NULL, NULL, 460624 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA70F7CF2E050007F010036EC', '100374@5C7117E6CD174125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0099', NULL, NULL, NULL, NULL, NULL, NULL, 460626 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7117CF2E050007F010036EC', '100377@5C7117E6CE0E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0102', NULL, NULL, NULL, NULL, NULL, NULL, 460628 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7137CF2E050007F010036EC', '100381@5C7117E6CD0C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0106', NULL, NULL, NULL, NULL, NULL, NULL, 460630 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7157CF2E050007F010036EC', '100382@5C7117E6CD154125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0107', NULL, NULL, NULL, NULL, NULL, NULL, 460632 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7177CF2E050007F010036EC', '100383@5C7117E6CD1A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0108', NULL, NULL, NULL, NULL, NULL, NULL, 460634 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7197CF2E050007F010036EC', '100388@5C7117E6CD0A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0113', NULL, NULL, NULL, NULL, NULL, NULL, 460636 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA71B7CF2E050007F010036EC', '100389@5C7117E6CE4B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0114', NULL, NULL, NULL, NULL, NULL, NULL, 460638 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA71D7CF2E050007F010036EC', '100391@5C7117E6CE4C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0116', NULL, NULL, NULL, NULL, NULL, NULL, 460640 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA71F7CF2E050007F010036EC', '100401@5C7117E6CD224125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0117', NULL, NULL, NULL, NULL, NULL, NULL, 460642 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7217CF2E050007F010036EC', '110004@5C7117E6CD974125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0120', NULL, NULL, NULL, NULL, NULL, NULL, 460644 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7237CF2E050007F010036EC', '100296@5C7117E6CF174125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0121', NULL, NULL, NULL, NULL, NULL, NULL, 460646 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7257CF2E050007F010036EC', '100423@5C7117E6CEBA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0201D0123', NULL, NULL, NULL, NULL, NULL, NULL, 460648 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7277CF2E050007F010036EC', '100631@5C7117E6CF124125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202F0002', NULL, NULL, NULL, NULL, NULL, NULL, 460650 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7297CF2E050007F010036EC', '213002@5C7117E6CF814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0002', NULL, NULL, NULL, NULL, NULL, NULL, 460652 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA72B7CF2E050007F010036EC', '213003@5C7117E6CF824125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0003', NULL, NULL, NULL, NULL, NULL, NULL, 460654 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA72D7CF2E050007F010036EC', '213005@5C7117E6CCD94125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0005', NULL, NULL, NULL, NULL, NULL, NULL, 460656 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA72F7CF2E050007F010036EC', '213006@5C7117E6CCDA4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0006', NULL, NULL, NULL, NULL, NULL, NULL, 460658 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7317CF2E050007F010036EC', '213009@5C7117E6CF7F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0009', NULL, NULL, NULL, NULL, NULL, NULL, 460660 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7337CF2E050007F010036EC', '213010@5C7117E6CF7E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0010', NULL, NULL, NULL, NULL, NULL, NULL, 460662 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7357CF2E050007F010036EC', '213013@5C7117E6CF9F4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0012', NULL, NULL, NULL, NULL, NULL, NULL, 460664 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7377CF2E050007F010036EC', '213014@5C7117E6CF9E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0013', NULL, NULL, NULL, NULL, NULL, NULL, 460666 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7397CF2E050007F010036EC', '213018@5C7117E6CF7C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0017', NULL, NULL, NULL, NULL, NULL, NULL, 460668 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA73B7CF2E050007F010036EC', '213020@5C7117E6CE064125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0019', NULL, NULL, NULL, NULL, NULL, NULL, 460670 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA73D7CF2E050007F010036EC', '213023@5C7117E6CE044125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0021', NULL, NULL, NULL, NULL, NULL, NULL, 460672 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA73F7CF2E050007F010036EC', '213027@5C7117E6CF834125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0025', NULL, NULL, NULL, NULL, NULL, NULL, 460674 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7417CF2E050007F010036EC', '213029@5C7117E6CD424125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0027', NULL, NULL, NULL, NULL, NULL, NULL, 460676 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7437CF2E050007F010036EC', '213032@5C7117E6CD4B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0029', NULL, NULL, NULL, NULL, NULL, NULL, 460678 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7457CF2E050007F010036EC', '213034@5C7117E6CD354125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0031', NULL, NULL, NULL, NULL, NULL, NULL, 460680 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7477CF2E050007F010036EC', '213039@5C7117E6CD2D4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0035', NULL, NULL, NULL, NULL, NULL, NULL, 460682 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7497CF2E050007F010036EC', '213040@5C7117E6CD434125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0036', NULL, NULL, NULL, NULL, NULL, NULL, 460684 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA74B7CF2E050007F010036EC', '213043@5C7117E6CE554125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0039', NULL, NULL, NULL, NULL, NULL, NULL, 460686 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA74D7CF2E050007F010036EC', '213044@5C7117E6CE094125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0040', NULL, NULL, NULL, NULL, NULL, NULL, 460688 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA74F7CF2E050007F010036EC', '213048@5C7117E6CD304125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0044', NULL, NULL, NULL, NULL, NULL, NULL, 460690 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7517CF2E050007F010036EC', '213050@5C7117E6CCE84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0046', NULL, NULL, NULL, NULL, NULL, NULL, 460692 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7537CF2E050007F010036EC', '213052@5C7117E6CCE54125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0048', NULL, NULL, NULL, NULL, NULL, NULL, 460694 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7557CF2E050007F010036EC', '213056@5C7117E6CF7B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0052', NULL, NULL, NULL, NULL, NULL, NULL, 460696 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7577CF2E050007F010036EC', '213057@5C7117E6CF804125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0053', NULL, NULL, NULL, NULL, NULL, NULL, 460698 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7597CF2E050007F010036EC', '213061@5C7117E6CCD74125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0057', NULL, NULL, NULL, NULL, NULL, NULL, 460700 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA75B7CF2E050007F010036EC', '213063@5C7117E6CCE24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0058', NULL, NULL, NULL, NULL, NULL, NULL, 460702 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA75D7CF2E050007F010036EC', '213069@5C7117E6CF844125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0064', NULL, NULL, NULL, NULL, NULL, NULL, 460704 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA75F7CF2E050007F010036EC', '213072@5C7117E6CE034125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0066', NULL, NULL, NULL, NULL, NULL, NULL, 460706 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7617CF2E050007F010036EC', '213074@5C7117E6CD3C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0068', NULL, NULL, NULL, NULL, NULL, NULL, 460708 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7637CF2E050007F010036EC', '213078@5C7117E6CD344125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0071', NULL, NULL, NULL, NULL, NULL, NULL, 460710 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7657CF2E050007F010036EC', '100215@5C7117E6CD464125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0073', NULL, NULL, NULL, NULL, NULL, NULL, 460712 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7677CF2E050007F010036EC', '100340@5C7117E6CD3A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0075', NULL, NULL, NULL, NULL, NULL, NULL, 460714 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7697CF2E050007F010036EC', '100342@5C7117E6CD494125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0077', NULL, NULL, NULL, NULL, NULL, NULL, 460716 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA76B7CF2E050007F010036EC', '100346@5C7117E6CE534125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0081', NULL, NULL, NULL, NULL, NULL, NULL, 460718 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA76D7CF2E050007F010036EC', '100347@5C7117E6CE074125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0082', NULL, NULL, NULL, NULL, NULL, NULL, 460720 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA76F7CF2E050007F010036EC', '100350@5C7117E6CF854125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0085', NULL, NULL, NULL, NULL, NULL, NULL, 460722 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7717CF2E050007F010036EC', '100354@5C7117E6CD314125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0089', NULL, NULL, NULL, NULL, NULL, NULL, 460724 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7737CF2E050007F010036EC', '100355@5C7117E6CE494125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0090', NULL, NULL, NULL, NULL, NULL, NULL, 460726 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7757CF2E050007F010036EC', '100357@5C7117E6CE5A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0092', NULL, NULL, NULL, NULL, NULL, NULL, 460728 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7777CF2E050007F010036EC', '100359@5C7117E6CE594125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0094', NULL, NULL, NULL, NULL, NULL, NULL, 460730 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7797CF2E050007F010036EC', '100363@5C7117E6CCDC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202D0098', NULL, NULL, NULL, NULL, NULL, NULL, 460732 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA77B7CF2E050007F010036EC', '110009@5C7117E6CE884125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0001', NULL, NULL, NULL, NULL, NULL, NULL, 460734 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA77D7CF2E050007F010036EC', '100210@5C7117E6CEF84125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0004', NULL, NULL, NULL, NULL, NULL, NULL, 460736 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA77F7CF2E050007F010036EC', '100251@5C7117E6CEDB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0006', NULL, NULL, NULL, NULL, NULL, NULL, 460738 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7817CF2E050007F010036EC', '100306@5C7117E6CF1A4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0009', NULL, NULL, NULL, NULL, NULL, NULL, 460740 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7837CF2E050007F010036EC', '100415@5C7117E6CEB64125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0012', NULL, NULL, NULL, NULL, NULL, NULL, 460742 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7857CF2E050007F010036EC', '100434@5C7117E6CEBE4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0013', NULL, NULL, NULL, NULL, NULL, NULL, 460744 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7877CF2E050007F010036EC', '100487@5C7117E6CDCB4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0017', NULL, NULL, NULL, NULL, NULL, NULL, 460746 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7897CF2E050007F010036EC', '100518@5C7117E6CDE14125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0018', NULL, NULL, NULL, NULL, NULL, NULL, 460748 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA78B7CF2E050007F010036EC', '100563@5C7117E6CE664125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0021', NULL, NULL, NULL, NULL, NULL, NULL, 460750 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA78D7CF2E050007F010036EC', '100651@5C7117E6CEB24125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0023', NULL, NULL, NULL, NULL, NULL, NULL, 460752 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA78F7CF2E050007F010036EC', '100681@5C7117E6CDAD4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0026', NULL, NULL, NULL, NULL, NULL, NULL, 460754 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7917CF2E050007F010036EC', '100791@5C7117E6CD8E4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0029', NULL, NULL, NULL, NULL, NULL, NULL, 460756 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7937CF2E050007F010036EC', '100793@5C7117E6CD7B4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0030', NULL, NULL, NULL, NULL, NULL, NULL, 460758 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7957CF2E050007F010036EC', '100848@5C7117E6CD604125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0034', NULL, NULL, NULL, NULL, NULL, NULL, 460760 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7977CF2E050007F010036EC', '100858@5C7117E6CD694125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0035', NULL, NULL, NULL, NULL, NULL, NULL, 460762 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '62766CEEA7997CF2E050007F010036EC', '100882@5C7117E6CD6C4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0202P0036', NULL, NULL, NULL, NULL, NULL, NULL, 460764 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '66E2BBD4B4E323C9E050007F010021B3', '100140@5C7117E6CE814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '9C23A34E91064D5689F0E2B26F8CCC50', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-08 15:37:14', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-08 15:37:14', 751176 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6811BA7CF6949AEFE050007F0100160B', '213001@6764A03B86A1F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0202D0001', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-23 17:06:41', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-23 17:06:41', 1131635 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '68474EC055AF8C68E050007F010078F0', '100142@6764A03B8543F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0201P0002', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-26 09:02:05', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-26 09:02:05', 1135980 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '68740C7470E39B2BE050007F01006C1D', '100183@5C7117E6CE814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', 'E1D8CAA6CE9E4BB386FE4958C332C91E', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-28 14:24:48', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-28 14:24:48', 1156836 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6876EE0056400FD8E050007F01000AB3', '100184@5C7117E6CE814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', 'AC0F9895383D4F10908393C6146438CA', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-28 17:51:02', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-28 17:51:02', 1161338 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6876EEA446BEA1CFE050007F01000AAF', '100162@5C7117E6CE814125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '07D1395BF0804BF68D6EDA0C0E3CE752', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-28 17:51:13', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-03-28 17:51:13', 1161353 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '68DBB1CCC03D7617E050007F01007A1D', '100166@5C7117E6CEE44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0101', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-02 18:04:08', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-02 18:04:08', 1234865 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '69047D83E29C3F73E050007F01004452', '100843@6764A03B85F3F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0204', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-04 18:44:27', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-04 18:44:27', 1248884 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '690486D2AB7E453FE050007F0100449F', '100494@6764A03B85EDF731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0204P0001', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-04 18:47:03', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-04 18:47:03', 1248980 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '697B7DAC95455194E050007F0100139D', '100625@6764A03B86D9F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0202', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-10 16:42:56', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-10 16:42:56', 1254534 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6A83C0BC6B9E9E76E050007F010067F2', '100804@6764A03B84A4F731E050007F01004EF8', '2C7B69422F064D909E5AB142A3F24BAA', '0207', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-23 19:59:46', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-04-23 19:59:46', 1290167 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6BADCF0A41C76219E050007F01006F7B', '6BA8F56B46C8BE88E050007F01003AF9@FA68152C69754443AAA8B955AE81F6AA', '84843FEE459A4663BDB4411F045AF783', '800A55B2583E41A58B10E3CD793CA012', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '2018-05-08 15:35:40', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '2018-05-08 15:35:40', 1324099 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6BADD041F2B423D2E050007F01006F88', '6BA8FF03B4B3C30EE050007F01003B51@F8C7D039C78A425F94B4FC7C5EDC6BC1', '84843FEE459A4663BDB4411F045AF783', '9CC185A2B3E44328998AFA41CEA19260', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '2018-05-08 15:36:01', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '2018-05-08 15:36:01', 1324114 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6BAEDEA1E8971B46E050007F01007973', '100145@6764A03B8545F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0201P0003', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-08 16:51:37', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-08 16:51:37', 1325177 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6BD0EEEDA16F3C90E050007F01007DD5', '211005@6764A03B855BF731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0201', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-10 09:30:53', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-10 09:30:53', 1425225 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6BD0F08FC75265C9E050007F01007DF1', '100629@6764A03B8643F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0201P0024', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-10 09:30:30', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-10 09:30:30', 1425188 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6C1024D91F95DF7EE050007F0100588C', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', 'DCB940CC13CE43E08F077433A8771461', 'shanghaitech', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-13 12:54:51', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-13 12:54:51', 1593002 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6C5DC81A04EF56DFE050007F0100532F', '100559@6764A03B8517F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0203P0023', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-17 09:32:27', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-17 09:32:27', 1663158 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6D41203A89AB9883E050007F010016FE', '6D40DCD9CE283B0AE050007F0100145D@6E45B4608DD64FD49A4020619E0D7C00', '84843FEE459A4663BDB4411F045AF783', '9F5C25B40604464AB5E80FFA830EFDC7', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-28 16:46:33', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-28 16:46:33', 1703353 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6D41229957DA05A0E050007F0100171A', '6D40DE25C78FA12AE050007F01001475@6E45B4608DD64FD49A4020619E0D7C00', '84843FEE459A4663BDB4411F045AF783', 'D3287025E1424945BEDAB79540801B0E', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-28 16:47:13', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-28 16:47:13', 1703399 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6D412420F408E7CAE050007F01001720', '6D40DE25C78FA12AE050007F01001475@6E45B4608DD64FD49A4020619E0D7C00', '84843FEE459A4663BDB4411F045AF783', 'E8A35770AA6D477EA140E102662F6E86', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-28 16:47:39', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-05-28 16:47:39', 1703428 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6DDFE183EA8BE16BE050007F01003BCD', '100950@5C7117E6CE704125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0104', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-06-05 14:10:49', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-06-05 14:10:49', 1725955 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '6DE23132200158EAE050007F010052CD', '100511@5C7117E6CDDC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0111', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-06-05 09:56:16', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2018-06-05 16:56:16', 1728616 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '7D714D0C9458438BB67B6E260FF24AD9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', 'A7954CBD424744859C832EBD6BDFDEEB', '2FF43C8EED31448CAFDBC345C0EF0296', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-08-18 21:38:43', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-08-18 21:38:43', 3547630 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '85830904DF84793CE050007F010031CB', '100792@6764A03B8473F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0201P0036', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-02 09:27:20', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-02 09:27:20', 3386502 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '8614985D12F36B95E050007F01001DD9', '100288@6764A03B864DF731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0203P0014', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-09 15:07:00', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-09 15:07:00', 3398560 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '8614A04D5C0F4A37E050007F01001E27', '100178@6764A03B8480F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0204P0003', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-09 15:09:13', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-09 15:09:13', 3399526 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '8614CA03A04F6F98E050007F01001FC7', '100221@5C7117E6CEFC4125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '0302P0003', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-09 15:20:53', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-09 15:20:53', 3399633 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '862955F098F1FDC6E050007F01000695', '100684@6764A03B8658F731E050007F01004EF8', '84843FEE459A4663BDB4411F045AF783', '0302P0009', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-10 15:51:41', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-10 15:51:41', 3402112 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '86CD9BA9E1764726E050007F010043A8', '100158@5C7117E6CEE44125E050007F010057D5', '84843FEE459A4663BDB4411F045AF783', '100158@5C7117E6CEE44125E050007F010057D5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-18 19:50:50', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-04-18 19:50:50', 3407606 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '8BD68AE0067F44DB88996786F3ED695C', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '18D3CFB8D6C140E1939DCC7817E9EE66', '2FF43C8EED31448CAFDBC345C0EF0296', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-08-18 21:56:54', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-08-18 21:56:54', 3547987 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '90FD1AF04D3B7371E050007F010058C9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', 'A7954CBD424744859C832EBD6BDFDEEB', '7609EDB28F974C5F948CAA24D5ADAB85', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-08-26 10:45:47', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-08-26 10:45:47', 3553890 );
INSERT INTO `sa_opbizmanagement`
VALUES
	( '9257631DE87A0D41E050007F01003F91', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '84843FEE459A4663BDB4411F045AF783', '7609EDB28F974C5F948CAA24D5ADAB85', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-09-12 10:48:58', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-09-12 10:48:58', 3568403 );-- ----------------------------
-- Table structure for sa_opbizmanagementtype
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opbizmanagementtype`;
CREATE TABLE `sa_opbizmanagementtype` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`MANAGE_ORG_KIND_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理组织类别',
`MANAGE_ORG_KIND_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '管理组织类别名称',
`KIND_ID` VARCHAR ( 6 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'sys 系统 def 自定义',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`NODE_KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '节点类别ID',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务权限类别' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opbizmanagementtype
-- ----------------------------
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'1',
	'01',
	'业务管理权限',
	NULL,
	NULL,
	'1',
	25221,
	1,
	'0',
	'/1',
	1,
	NULL,
	'/业务管理权限',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'18D3CFB8D6C140E1939DCC7817E9EE66',
	'procApprovalRule',
	'流程审批规则',
	NULL,
	NULL,
	'0',
	258347,
	1,
	'896255',
	'/1/896255/18D3CFB8D6C140E1939DCC7817E9EE66',
	2,
	NULL,
	'/业务管理权限/系统/流程审批规则',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'2C7B69422F064D909E5AB142A3F24BAA',
	'delegation',
	'分级授权',
	NULL,
	NULL,
	'0',
	28010,
	3,
	'896255',
	'/1/896255/2C7B69422F064D909E5AB142A3F24BAA',
	2,
	NULL,
	'/业务管理权限/系统/分级授权',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'48B0938102354996BF3F076B63DB8234',
	'queryLog',
	'日志查询',
	NULL,
	NULL,
	'0',
	27988,
	2,
	'896255',
	'/1/896255/48B0938102354996BF3F076B63DB8234',
	2,
	NULL,
	'/业务管理权限/系统/日志查询',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'54D642DFA98A49B38F98852CB0C31CF1',
	'tenant',
	'租户管理权限',
	NULL,
	NULL,
	'0',
	170554,
	14,
	'896255',
	'/1/896255/54D642DFA98A49B38F98852CB0C31CF1',
	2,
	NULL,
	'/业务管理权限/系统/租户管理权限',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'84843FEE459A4663BDB4411F045AF783',
	'admin',
	'行政管理权限',
	NULL,
	NULL,
	'0',
	463691,
	4,
	'896255',
	'/1/896255/84843FEE459A4663BDB4411F045AF783',
	2,
	NULL,
	'/业务管理权限/系统/行政管理权限',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'896255',
	'system',
	'系统',
	NULL,
	NULL,
	'1',
	258477,
	1,
	'1',
	'/1/896255',
	1,
	NULL,
	'/业务管理权限/系统',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'A7954CBD424744859C832EBD6BDFDEEB',
	'functionDelegation',
	'功能分级授权',
	NULL,
	NULL,
	'0',
	28077,
	6,
	'896255',
	'/1/896255/A7954CBD424744859C832EBD6BDFDEEB',
	2,
	NULL,
	'/业务管理权限/系统/功能分级授权',
	1
	);
INSERT INTO `sa_opbizmanagementtype`
VALUES
	(
	'DCB940CC13CE43E08F077433A8771461',
	'taskQuery',
	'任务查询',
	NULL,
	NULL,
	'0',
	28038,
	5,
	'896255',
	'/1/896255/DCB940CC13CE43E08F077433A8771461',
	2,
	NULL,
	'/业务管理权限/系统/任务查询',
	1
	);-- ----------------------------
-- Table structure for sa_opdatakind
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatakind`;
CREATE TABLE `sa_opdatakind` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`DATA_KIND` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
`DATA_SOURCE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '数据源',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'SEQUENCE',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT 'status',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'VERSION',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限维度定义' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opdatakind
-- ----------------------------
INSERT INTO `sa_opdatakind`
VALUES
	( '84BAD3628483C84EE050007F0100736D', 'org', 'org', 'org', NULL, NULL, 1, 1, 3295394 );-- ----------------------------
-- Table structure for sa_opdatamanagebusiness
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagebusiness`;
CREATE TABLE `sa_opdatamanagebusiness` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`CODE` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
`NODE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '节点类型(分类，类型)',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'full_id',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'full_name',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'SEQUENCE',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT 'status',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'REMARK',
`DATA_MANAGE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据管理权限ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限业务类型' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opdatamanagebusiness_field
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagebusiness_field`;
CREATE TABLE `sa_opdatamanagebusiness_field` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`DATAMANAGEBUSINESS_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据管理权限业务类型ID',
`IS_ORG_CONDITION` INT ( 11 ) NULL DEFAULT NULL COMMENT '特殊组织条件',
`DATA_KIND_NAME` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源维度名称',
`DATA_KIND_CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源维度编码',
`TABLE_COLUMN` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'column',
`COLUMN_DATA_TYPE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'type',
`COLUMN_SYMBOL` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'symbol',
`TABLE_ALIAS` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'alias',
`FORMULA` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'Formula',
`DATA_KIND` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
`MANAGE_TYPE` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据管理权限编码',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'SEQUENCE',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限业务过滤字段定义' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opdatamanagedetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagedetail`;
CREATE TABLE `sa_opdatamanagedetail` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`DATA_MANAGE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据管理权限类别',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'SEQUENCE',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限取值定义' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opdatamanagedetail
-- ----------------------------
INSERT INTO `sa_opdatamanagedetail`
VALUES
	( '84E7F21C34A61116E050007F0100684A', '84E7ECF31C637BCBE050007F01006825', 'bm1', NULL, NULL, 3306052 );
INSERT INTO `sa_opdatamanagedetail`
VALUES
	( '88382ABEB9816617E050007F01002C34', '84E7ECF31C637BCBE050007F01006825', '12312', NULL, NULL, 3433010 );-- ----------------------------
-- Table structure for sa_opdatamanagedetailresource
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagedetailresource`;
CREATE TABLE `sa_opdatamanagedetailresource` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`DATA_MANAGEDETAL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据取值定义ID',
`DATA_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源维度ID',
`DATA_KIND` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源类型',
`RESOURCE_KEY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源KEY',
`RESOURCE_VALUE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源值',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'full_id',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'full_name',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
`ORG_DATA_KIND` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织权限类型',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限包含维度资源' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opdatamanagedetailresource
-- ----------------------------
INSERT INTO `sa_opdatamanagedetailresource`
VALUES
	( '84E7F2FB89F48D1CE050007F01006851', '84E7F21C34A61116E050007F0100684A', '84BAD3628483C84EE050007F0100736D', 'org', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt', '/外部机构/测试使用部门', 3305971, 'choose' );
INSERT INTO `sa_opdatamanagedetailresource`
VALUES
	( '8837E1C8CFD85E07E050007F0100292C', '84E7F21C34A61116E050007F0100684A', '84BAD3628483C84EE050007F0100736D', 'org', '111', '222', NULL, NULL, 3432953, 'manageType' );-- ----------------------------
-- Table structure for sa_opdatamanagement
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagement`;
CREATE TABLE `sa_opdatamanagement` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`DATA_MANAGE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据管理权限类别',
`DATA_MANAGEDETAL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据取值定义ID',
`MANAGER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理者ID',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限授权' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opdatamanagetype
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagetype`;
CREATE TABLE `sa_opdatamanagetype` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`CODE` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
`NODE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '节点类型(分类，数据权限)',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'full_id',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'full_name',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'SEQUENCE',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'REMARK',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT 'status',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限类型' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opdatamanagetype
-- ----------------------------
INSERT INTO `sa_opdatamanagetype`
VALUES
	( '84BAD23089A01A32E050007F01007365', '11', '111', '0', '2', '/84BAD23089A01A32E050007F01007365', '/111', 1, 3295385, NULL, 1 );
INSERT INTO `sa_opdatamanagetype`
VALUES
	( '84E79FD03C906E59E050007F01006522', 'sd', 'sd', '0', '2', '/84E79FD03C906E59E050007F01006522', '/sd', 2, 3305722, NULL, 1 );
INSERT INTO `sa_opdatamanagetype`
VALUES
	( '84E7EBC4B9ED0D5CE050007F0100681F', 'cs', '测试分类', '0', '1', '/84E7EBC4B9ED0D5CE050007F0100681F', '/测试分类', 3, 3305876, NULL, 1 );
INSERT INTO `sa_opdatamanagetype`
VALUES
	( '84E7ECF31C637BCBE050007F01006825', 'bm', 'bm', '84E7EBC4B9ED0D5CE050007F0100681F', '2', '/84E7EBC4B9ED0D5CE050007F0100681F/84E7ECF31C637BCBE050007F01006825', '/测试分类/bm', 0, 3305898, NULL, 1 );
INSERT INTO `sa_opdatamanagetype`
VALUES
	( 'EE5554968AE8425585A0E55538B767CD', 'report', '报告管理', '0', '2', '/EE5554968AE8425585A0E55538B767CD', '/报告管理', 4, 3569791, NULL, 1 );-- ----------------------------
-- Table structure for sa_opdatamanagetypekind
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opdatamanagetypekind`;
CREATE TABLE `sa_opdatamanagetypekind` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`DATA_MANAGE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据管理权限类别',
`DATA_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源维度ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据管理权限包含维度明细' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opdatamanagetypekind
-- ----------------------------
INSERT INTO `sa_opdatamanagetypekind`
VALUES
	( '84BAD23089A11A32E050007F01007365', '84BAD23089A01A32E050007F01007365', '84BAD3628483C84EE050007F0100736D', 3295406 );
INSERT INTO `sa_opdatamanagetypekind`
VALUES
	( '84E7A08C4B3862A1E050007F01006526', '84E79FD03C906E59E050007F01006522', '84BAD3628483C84EE050007F0100736D', 3305727 );
INSERT INTO `sa_opdatamanagetypekind`
VALUES
	( '84E7ECF31C647BCBE050007F01006825', '84E7ECF31C637BCBE050007F01006825', '84BAD3628483C84EE050007F0100736D', 3305893 );-- ----------------------------
-- Table structure for sa_operationlog
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_operationlog`;
CREATE TABLE `sa_operationlog` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`APP_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APP_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APP_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ORGAN_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORGAN_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ROLE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ROLE_KIND_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_MEMBER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`BEGIN_DATE` datetime  NULL DEFAULT NULL,
`END_DATE` datetime  NULL DEFAULT NULL,
`IP` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`MAC` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CLASS_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`METHOD_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`LOG_TYPE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OPERATE_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS_ID` INT ( 11 ) NULL DEFAULT NULL,
`STATUS_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_SECURITY_LEVEL_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`RESOURCE_SECURITY_LEVEL_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`MACHINE_SECURITY_LEVEL_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_SECURITY_LEVEL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`RESOURCE_SECURITY_LEVEL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`MACHINE_SECURITY_LEVEL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '操作日志' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_operationlogdetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_operationlogdetail`;
CREATE TABLE `sa_operationlogdetail` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`OPERATIONLOG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PARAMS` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`ERROR_MESSAGE` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`DESCRIPTION` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`BEFORE_IMAGE` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`AFTER_IMAGE` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '日志明细' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opfunction
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opfunction`;
CREATE TABLE `sa_opfunction` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '功能ID',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '全名称',
`NODE_KIND_ID` VARCHAR ( 6 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'node 节点 left 叶子 ',
`KEY_CODE` INT ( 11 ) NULL DEFAULT NULL COMMENT '快捷键码',
`URL` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '路径',
`ICON` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '图标',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`DEPTH` INT ( 11 ) NULL DEFAULT NULL COMMENT '深度',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`OPERATION_MAP_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '管理业务导图ID',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '功能' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opfunction
-- ----------------------------
INSERT INTO `sa_opfunction`
VALUES
	(
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	'ApplicationSystem',
	'应用系统维护',
	'/功能树/协同平台/安全策略/应用系统维护',
	'fun',
	NULL,
	'applicationSystem/forwardApplicationSystem.do',
	'fa-tv',
	NULL,
	NULL,
	1,
	5,
	811537,
	'应用系统维护',
	NULL,
	'/1/443/AD2EA0A0990243A3A7DB0B3FD2BCB0BE/0E92578B0AFB487E9EC3B0D77622E6C6'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1',
	'0',
	'GNS',
	'功能树',
	'/功能树',
	'folder',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	1,
	1,
	179219,
	'功能树',
	NULL,
	'/1'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1108',
	'6763',
	'ApprovalHandlerKind',
	'审批处理人类别',
	'/功能树/协同平台/工作流配置/流程审批规则配置/审批处理人类别',
	'fun',
	NULL,
	'approvalRule/forwardApprovalHandlerKind.do',
	'fa-list-ol',
	NULL,
	NULL,
	1,
	2,
	812208,
	'审批处理人类别',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/6763/1108'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1289',
	'1656',
	'SysParameter',
	'系统参数',
	'/功能树/协同平台/系统配置/系统参数',
	'fun',
	NULL,
	'parameter/forward.do',
	'fa-th-large',
	'管理系统使用的全部参数',
	NULL,
	1,
	1,
	3575828,
	'系统参数',
	NULL,
	'/1/443/1656/1289'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'130B44388AF142A2A2FEB8227ABB8CAD',
	'1656',
	'ApprovalRejectedReason',
	'审批驳回理由',
	'/功能树/协同平台/系统配置/审批驳回理由',
	'fun',
	NULL,
	'approvalRejectedReason/forwardListApprovalRejectedReason.do',
	'fa-question-circle',
	NULL,
	NULL,
	0,
	6,
	812593,
	'审批驳回理由',
	NULL,
	'/1/443/1656/130B44388AF142A2A2FEB8227ABB8CAD'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1326',
	'1656',
	'CodeBuildRule',
	'单据编号规则',
	'/功能树/协同平台/系统配置/单据编号规则',
	'fun',
	NULL,
	'codeBuildRule/forward.do',
	'fa-server',
	NULL,
	NULL,
	1,
	2,
	812592,
	'单据编号规则',
	NULL,
	'/1/443/1656/1326'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1366',
	'1656',
	'SysDictionary',
	'系统字典',
	'/功能树/协同平台/系统配置/系统字典',
	'fun',
	NULL,
	'dictionary/forward.do',
	'fa-book',
	NULL,
	NULL,
	1,
	3,
	812597,
	'系统字典',
	NULL,
	'/1/443/1656/1366'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1531',
	'443',
	'SysLog',
	'系统日志',
	'/功能树/协同平台/系统日志',
	'folder',
	NULL,
	NULL,
	'fa-file-word-o',
	NULL,
	NULL,
	1,
	7,
	812527,
	'系统日志',
	NULL,
	'/1/443/1531'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'158EE9A480EA4E49865DCDE28AD32A83',
	'443',
	'WorkflowTaskManagement',
	'流程任务管理',
	'/功能树/协同平台/流程任务管理',
	'folder',
	NULL,
	NULL,
	'fa-folder',
	NULL,
	NULL,
	1,
	4,
	812529,
	'流程任务管理',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1591B93C8792402CA206A64A71F419C3',
	'443',
	'WorkflowConfiguration',
	'工作流配置',
	'/功能树/协同平台/工作流配置',
	'folder',
	NULL,
	NULL,
	'fa-folder',
	NULL,
	NULL,
	1,
	3,
	812525,
	'工作流配置',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'160597161',
	'30D672692E9E48E295796F3ADD96AC65',
	'AllocateSubordination',
	'分配下属',
	'/功能树/协同平台/组织权限/业务管理权限/分配下属',
	'fun',
	NULL,
	'management/forwardBizManagement.do?typeId=subordination',
	'fa-suitcase',
	NULL,
	NULL,
	1,
	4,
	812605,
	'分配下属',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65/160597161'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1656',
	'443',
	'SysConfiguration',
	'系统配置',
	'/功能树/协同平台/系统配置',
	'folder',
	NULL,
	NULL,
	'fa-windows',
	NULL,
	NULL,
	1,
	1,
	812278,
	'系统配置',
	NULL,
	'/1/443/1656'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'1A063E96064444AAB643D390EC87C800',
	'158EE9A480EA4E49865DCDE28AD32A83',
	'TaskQuery',
	'流程任务查询',
	'/功能树/协同平台/流程任务管理/流程任务查询',
	'fun',
	NULL,
	'workflow/forwardTaskQuery.do',
	'fa-user-circle-o',
	NULL,
	NULL,
	1,
	4,
	812608,
	'流程任务查询',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83/1A063E96064444AAB643D390EC87C800'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'222052FA15FC4CBD969804CEB4851EB9',
	'158EE9A480EA4E49865DCDE28AD32A83',
	'ProcUnitHandlerQuery',
	'流程处理人查询',
	'/功能树/协同平台/流程任务管理/流程处理人查询',
	'fun',
	NULL,
	'workflow/forwardProcunitHandlerQuery.do',
	'fa-user-secret',
	NULL,
	NULL,
	1,
	5,
	812701,
	'流程处理人查询',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83/222052FA15FC4CBD969804CEB4851EB9'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'29030502',
	'1656',
	'MessageKind',
	'消息发送类别',
	'/功能树/协同平台/系统配置/消息发送类别',
	'fun',
	NULL,
	'parameter/forwardListMessageKind.do',
	'fa-commenting',
	NULL,
	NULL,
	0,
	5,
	812598,
	'消息发送类别',
	NULL,
	'/1/443/1656/29030502'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'300',
	'1531',
	'OperationLog',
	'操作日志',
	'/功能树/协同平台/系统日志/操作日志',
	'fun',
	NULL,
	'log/forwardOperationLog.do',
	'fa-file',
	NULL,
	NULL,
	1,
	4,
	813758,
	'操作日志',
	NULL,
	'/1/443/1531/300'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'30D672692E9E48E295796F3ADD96AC65',
	'446',
	'BizManagementFolder',
	'业务管理权限',
	'/功能树/协同平台/组织权限/业务管理权限',
	'folder',
	NULL,
	NULL,
	'fa-folder',
	NULL,
	NULL,
	1,
	3,
	811967,
	'业务管理权限',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'32B4DC6736734C5985D5C7E4A13033BF',
	'446',
	'FunctionPermission',
	'功能权限',
	'/功能树/协同平台/组织权限/功能权限',
	'folder',
	NULL,
	NULL,
	'fa-folder',
	NULL,
	NULL,
	1,
	2,
	811917,
	'功能权限',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'32D3CC5E12774181A9CAB5B306B222F8',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'OrgPropertyDefinition',
	'组织属性定义',
	'/功能树/协同平台/组织权限/组织机构/组织属性定义',
	'fun',
	NULL,
	'org/forwardOrgPropertyDefinition.do',
	'fa-volume-down',
	NULL,
	NULL,
	1,
	7,
	812061,
	'组织属性定义',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/32D3CC5E12774181A9CAB5B306B222F8'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'33E0C6BCE56A41D893014279D8CF726D',
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	'Machine',
	'机器维护',
	'/功能树/协同平台/安全策略/机器维护',
	'fun',
	NULL,
	'machine/forwardMachine.do',
	'fa-laptop',
	NULL,
	NULL,
	1,
	1,
	811540,
	'机器维护',
	NULL,
	'/1/443/AD2EA0A0990243A3A7DB0B3FD2BCB0BE/33E0C6BCE56A41D893014279D8CF726D'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'3AECEB1B898D4F348606363D5E444AE7',
	'446',
	'DataManage',
	'数据管理权限',
	'/功能树/协同平台/组织权限/数据管理权限',
	'folder',
	NULL,
	NULL,
	'fa-bank',
	NULL,
	NULL,
	1,
	4,
	812941,
	'数据管理权限',
	NULL,
	'/1/443/446/3AECEB1B898D4F348606363D5E444AE7'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'400',
	'1531',
	'ErrorLog',
	'错误日志',
	'/功能树/协同平台/系统日志/错误日志',
	'fun',
	NULL,
	'log/forwardErrorLog.do',
	'fa-columns',
	NULL,
	NULL,
	1,
	3,
	3188691,
	'错误日志',
	NULL,
	'/1/443/1531/400'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'411F3C501F2F48DB99F339993D9DDCB7',
	'1656',
	'Orgfun',
	'组织机构函数定义',
	'/功能树/协同平台/系统配置/组织机构函数定义',
	'fun',
	NULL,
	'orgfun/forwardListOrgfun.do',
	'fa-gear',
	NULL,
	NULL,
	1,
	8,
	812594,
	'组织机构函数定义',
	NULL,
	'/1/443/1656/411F3C501F2F48DB99F339993D9DDCB7'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4178',
	'5E954471A9C0443EB259460FF3BA686C',
	'DataImport',
	'数据导入',
	'/功能树/协同平台/业务配置/数据导入',
	'folder',
	NULL,
	NULL,
	'fa-mail-reply-all',
	NULL,
	NULL,
	1,
	2,
	3133496,
	'数据导入',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C/4178'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4179',
	'4178',
	'ExcelImportTemplate',
	'导入模板设置',
	'/功能树/协同平台/业务配置/数据导入/导入模板设置',
	'fun',
	NULL,
	'excelImport/forwardList.do',
	'fa-mail-reply',
	NULL,
	NULL,
	1,
	1,
	815292,
	'导入模板设置',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C/4178/4179'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'443',
	'1',
	'Coordination',
	'协同平台',
	'/功能树/协同平台',
	'folder',
	NULL,
	NULL,
	'fa-dashboard',
	'123',
	NULL,
	1,
	1,
	257756,
	'协同平台',
	NULL,
	'/1/443'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'446',
	'443',
	'OPM',
	'组织权限',
	'/功能树/协同平台/组织权限',
	'folder',
	NULL,
	NULL,
	'fa-share-alt',
	NULL,
	NULL,
	1,
	2,
	812063,
	'组织权限',
	NULL,
	'/1/443/446'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'448',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'OrgType',
	'机构类型',
	'/功能树/协同平台/组织权限/组织机构/机构类型',
	'fun',
	NULL,
	'orgType.do?orgKindId=ogn',
	'fa-align-justify',
	NULL,
	NULL,
	1,
	1,
	811499,
	'机构类型',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/448'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'449',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'DeptType',
	'部门类型',
	'/功能树/协同平台/组织权限/组织机构/部门类型',
	'fun',
	NULL,
	'orgType.do?orgKindId=dpt',
	'fa-align-left',
	NULL,
	NULL,
	1,
	2,
	811502,
	'部门类型',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/449'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'450',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'PosType',
	'岗位类型',
	'/功能树/协同平台/组织权限/组织机构/岗位类型',
	'fun',
	NULL,
	'orgType.do?orgKindId=pos',
	'fa-align-right',
	NULL,
	NULL,
	1,
	3,
	811500,
	'岗位类型',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/450'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'451',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'OrgTemplate',
	'机构模板',
	'/功能树/协同平台/组织权限/组织机构/机构模板',
	'fun',
	NULL,
	'orgTemplate.do',
	'fa-chain',
	NULL,
	NULL,
	1,
	4,
	812029,
	'机构模板',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/451'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'452',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'Org',
	'组织管理',
	'/功能树/协同平台/组织权限/组织机构/组织管理',
	'fun',
	NULL,
	'org/forwardOrg.do',
	'fa-male',
	NULL,
	NULL,
	1,
	5,
	812030,
	'组织管理',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/452'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'453',
	'32B4DC6736734C5985D5C7E4A13033BF',
	'Func',
	'功能管理',
	'/功能树/协同平台/组织权限/功能权限/功能管理',
	'fun',
	NULL,
	'sysFunction/forwardFunction.do',
	'fa-gear',
	NULL,
	NULL,
	1,
	2,
	812588,
	'功能管理',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF/453'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'454',
	'32B4DC6736734C5985D5C7E4A13033BF',
	'Role',
	'角色管理',
	'/功能树/协同平台/组织权限/功能权限/角色管理',
	'fun',
	NULL,
	'access/forwardRole.do?tenantKindId=global',
	'fa-users',
	NULL,
	NULL,
	1,
	3,
	812589,
	'角色管理',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF/454'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'455',
	'32B4DC6736734C5985D5C7E4A13033BF',
	'Authorization',
	'授权管理',
	'/功能树/协同平台/组织权限/功能权限/授权管理',
	'fun',
	NULL,
	'access/forwardAuthorize.do',
	'fa-cogs',
	NULL,
	NULL,
	1,
	4,
	812591,
	'授权管理',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF/455'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'456',
	'30D672692E9E48E295796F3ADD96AC65',
	'ManagementType',
	'业务权限管理类别',
	'/功能树/协同平台/组织权限/业务管理权限/业务权限管理类别',
	'fun',
	NULL,
	'management/forwardBizManagementType.do',
	'fa-outdent',
	NULL,
	NULL,
	1,
	2,
	812604,
	'业务权限管理类别',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65/456'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'457',
	'158EE9A480EA4E49865DCDE28AD32A83',
	'Agent',
	'代理管理',
	'/功能树/协同平台/流程任务管理/代理管理',
	'fun',
	NULL,
	'agent/forwardAgent.do',
	'fa-group',
	NULL,
	NULL,
	1,
	1,
	812299,
	'代理管理',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83/457'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4802432',
	'158EE9A480EA4E49865DCDE28AD32A83',
	'FlowTaskManagement',
	'流程任务维护',
	'/功能树/协同平台/流程任务管理/流程任务维护',
	'fun',
	NULL,
	'processInstanceOperation/forwardFlowTaskHandlerManage.do',
	'fa-wrench',
	NULL,
	NULL,
	1,
	2,
	812688,
	'流程任务维护',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83/4802432'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4803288',
	'30D672692E9E48E295796F3ADD96AC65',
	'ManagementQueryForManager',
	'查询管理者',
	'/功能树/协同平台/组织权限/业务管理权限/查询管理者',
	'fun',
	NULL,
	'management/forwardBizManagementQuery.do?typeId=manager',
	'fa-suitcase',
	NULL,
	NULL,
	1,
	5,
	812603,
	'查询管理者',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65/4803288'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4803290',
	'30D672692E9E48E295796F3ADD96AC65',
	'ManagementQueryForSubordination',
	'查询下属',
	'/功能树/协同平台/组织权限/业务管理权限/查询下属',
	'fun',
	NULL,
	'management/forwardBizManagementQuery.do?typeId=subordination',
	'fa-address-card-o',
	NULL,
	NULL,
	1,
	6,
	812606,
	'查询下属',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65/4803290'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4803541',
	'6763',
	'ProcApprovalRuleConfigQuery',
	'流程审批规则配置查询',
	'/功能树/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询',
	'fun',
	NULL,
	'approvalRule/forwardApprovalRule.do?isReadOnly=true',
	'fa-search-plus',
	NULL,
	NULL,
	1,
	6,
	812207,
	'流程审批规则配置查询',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/6763/4803541'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'4803613',
	'1656',
	'AttachmentConfiguration',
	'附件配置',
	'/功能树/协同平台/系统配置/附件配置',
	'fun',
	NULL,
	'attachment/forward.do',
	'fa-file-text',
	NULL,
	NULL,
	1,
	4,
	812600,
	'附件配置',
	NULL,
	'/1/443/1656/4803613'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'500',
	'1531',
	'LoginLog',
	'登陆日志',
	'/功能树/协同平台/系统日志/登陆日志',
	'fun',
	NULL,
	'log/forwardLoginLog.do',
	'fa-wpforms',
	NULL,
	NULL,
	1,
	1,
	813718,
	'登陆日志',
	NULL,
	'/1/443/1531/500'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'513179',
	'1591B93C8792402CA206A64A71F419C3',
	'ProcDefinition',
	'流程管理',
	'/功能树/协同平台/工作流配置/流程管理',
	'fun',
	NULL,
	'procDefinition/forwardList.do',
	'fa-hard-of-hearing',
	NULL,
	NULL,
	1,
	1,
	812205,
	'流程管理',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/513179'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'5431972',
	'446',
	'DelegationBizManagement',
	'分级授权管理',
	'/功能树/协同平台/组织权限/分级授权管理',
	'fun',
	NULL,
	'management/forwardDelegationBizManagement.do',
	'fa-wrench',
	NULL,
	NULL,
	0,
	5,
	812607,
	'分级授权管理',
	NULL,
	'/1/443/446/5431972'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'5E954471A9C0443EB259460FF3BA686C',
	'443',
	'BizConfiguration',
	'业务配置',
	'/功能树/协同平台/业务配置',
	'folder',
	NULL,
	NULL,
	'fa-window-restore',
	NULL,
	NULL,
	1,
	5,
	812526,
	'业务配置',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'631EDDA58C5A46CBAB665608091488B7',
	'3AECEB1B898D4F348606363D5E444AE7',
	'OpDataKind',
	'权限资源类型定义',
	'/功能树/协同平台/组织权限/数据管理权限/权限资源类型定义',
	'fun',
	NULL,
	'opDataKind/forwardListOpdatakind.do',
	'fa-bars',
	NULL,
	NULL,
	1,
	1,
	811512,
	'权限资源类型定义',
	NULL,
	'/1/443/446/3AECEB1B898D4F348606363D5E444AE7/631EDDA58C5A46CBAB665608091488B7'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'661',
	'30D672692E9E48E295796F3ADD96AC65',
	'BaseManagementType',
	'基础管理权限类别',
	'/功能树/协同平台/组织权限/业务管理权限/基础管理权限类别',
	'fun',
	NULL,
	'management/forwardBaseManagementType.do',
	'fa-list-alt',
	NULL,
	NULL,
	1,
	1,
	812601,
	'基础管理权限类别',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65/661'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6686',
	'4178',
	'ExcelImport',
	'导入数据',
	'/功能树/协同平台/业务配置/数据导入/导入数据',
	'fun',
	NULL,
	'excelImport/forwardExcelImportLog.do',
	'fa-mail-reply-all',
	NULL,
	NULL,
	1,
	2,
	815293,
	'导入数据',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C/4178/6686'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6762',
	'443',
	'ConfigurationTools',
	'配置工具',
	'/功能树/协同平台/配置工具',
	'folder',
	NULL,
	NULL,
	'fa-cogs',
	NULL,
	NULL,
	0,
	8,
	815323,
	'配置工具',
	NULL,
	'/1/443/6762'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6763',
	'1591B93C8792402CA206A64A71F419C3',
	'ProcApprovaRuleConfig',
	'流程审批规则配置',
	'/功能树/协同平台/工作流配置/流程审批规则配置',
	'folder',
	NULL,
	NULL,
	'fa-tag',
	NULL,
	NULL,
	1,
	2,
	812204,
	'流程审批规则配置',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/6763'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6764',
	'6763',
	'ApprovalElement',
	'审批要素配置',
	'/功能树/协同平台/工作流配置/流程审批规则配置/审批要素配置',
	'fun',
	NULL,
	'approvalRule/forwardApprovalElement.do',
	'fa-list-ul',
	NULL,
	NULL,
	1,
	1,
	812201,
	'审批要素配置',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/6763/6764'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6765',
	'6763',
	'ProcApprovalElementConfig',
	'流程审批要素配置',
	'/功能树/协同平台/工作流配置/流程审批规则配置/流程审批要素配置',
	'fun',
	NULL,
	'approvalRule/forwardProcApprovalElement.do',
	'fa-th-list',
	NULL,
	NULL,
	1,
	3,
	812209,
	'流程审批要素配置',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/6763/6765'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6766',
	'6763',
	'ProcApprovalRuleConfig',
	'流程审批规则配置',
	'/功能树/协同平台/工作流配置/流程审批规则配置/流程审批规则配置',
	'fun',
	NULL,
	'approvalRule/forwardApprovalRule.do',
	'fa-list',
	NULL,
	NULL,
	1,
	4,
	812202,
	'流程审批规则配置',
	NULL,
	'/1/443/1591B93C8792402CA206A64A71F419C3/6763/6766'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'686',
	'30D672692E9E48E295796F3ADD96AC65',
	'AllocateManager',
	'分配管理者',
	'/功能树/协同平台/组织权限/业务管理权限/分配管理者',
	'fun',
	NULL,
	'management/forwardBizManagement.do?typeId=manager',
	'fa-asterisk',
	NULL,
	NULL,
	1,
	3,
	812602,
	'业务管理权限',
	NULL,
	'/1/443/446/30D672692E9E48E295796F3ADD96AC65/686'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'6C101A020198D474E050007F0100582A',
	'158EE9A480EA4E49865DCDE28AD32A83',
	'taskInfoCount',
	'流程任务统计',
	'/功能树/协同平台/流程任务管理/流程任务统计',
	'fun',
	NULL,
	'bmCommonOperate/forwardTaskCount.do',
	'fa-industry',
	NULL,
	NULL,
	1,
	12,
	1592505,
	'流程任务统计',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83/6C101A020198D474E050007F0100582A'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'76E7443571D08D7DE050007F010079F9',
	'3AECEB1B898D4F348606363D5E444AE7',
	'DataManageBusiness',
	'管理权限业务类型定义',
	'/功能树/协同平台/组织权限/数据管理权限/管理权限业务类型定义',
	'fun',
	NULL,
	'dataManageBusiness/forwardListOpdatamanagebusiness.do',
	'fa-briefcase',
	NULL,
	NULL,
	1,
	4,
	3132746,
	'管理权限业务类型定义',
	NULL,
	'/1/443/446/3AECEB1B898D4F348606363D5E444AE7/76E7443571D08D7DE050007F010079F9'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'7B7DAE68C0F94888AC219388D53AC87C',
	'158EE9A480EA4E49865DCDE28AD32A83',
	'WorkflowMonitor',
	'流程监控',
	'/功能树/协同平台/流程任务管理/流程监控',
	'folder',
	NULL,
	NULL,
	'fa-low-vision',
	NULL,
	NULL,
	0,
	3,
	3133454,
	'流程监控',
	NULL,
	'/1/443/158EE9A480EA4E49865DCDE28AD32A83/7B7DAE68C0F94888AC219388D53AC87C'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'7D166A5A3A164BB19BEA396812EE7110',
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	'PersonAccountManagement',
	'账号管理',
	'/功能树/协同平台/安全策略/账号管理',
	'fun',
	NULL,
	'personAccountManagement/forwardPersonAccountManagement.do',
	'fa-user-o',
	NULL,
	NULL,
	1,
	4,
	811538,
	'账号管理',
	NULL,
	'/1/443/AD2EA0A0990243A3A7DB0B3FD2BCB0BE/7D166A5A3A164BB19BEA396812EE7110'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'803',
	'5E954471A9C0443EB259460FF3BA686C',
	'FlexField',
	'扩展字段',
	'/功能树/协同平台/业务配置/扩展字段',
	'folder',
	NULL,
	NULL,
	'fa-random',
	NULL,
	NULL,
	1,
	1,
	812611,
	'扩展字段',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C/803'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'804',
	'803',
	'FlexFieldDefine',
	'扩展字段定义',
	'/功能树/协同平台/业务配置/扩展字段/扩展字段定义',
	'fun',
	NULL,
	'flexField/executeFlexFieldDefine.do',
	'fa-paper-plane',
	NULL,
	NULL,
	1,
	1,
	812327,
	'扩展字段定义',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C/803/804'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	'1656',
	'I18nProperties',
	'国际化资源维护',
	'/功能树/协同平台/系统配置/国际化资源维护',
	'fun',
	NULL,
	'i18nProperties/forward.do',
	'fa-language',
	NULL,
	NULL,
	1,
	7,
	812595,
	'国际化资源维护',
	NULL,
	'/1/443/1656/856477CAA7F64B0FB79DCBF24ED47CBE'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'862',
	'803',
	'FlexFieldGroup',
	'扩展字段分组',
	'/功能树/协同平台/业务配置/扩展字段/扩展字段分组',
	'fun',
	NULL,
	'flexField/executeFlexFieldGroup.do',
	'fa-paper-plane-o',
	NULL,
	NULL,
	1,
	2,
	812328,
	'扩展字段分组',
	NULL,
	'/1/443/5E954471A9C0443EB259460FF3BA686C/803/862'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'86D6DB958BA84ED19DF33EDAC6364F42',
	'32B4DC6736734C5985D5C7E4A13033BF',
	'Permission',
	'权限管理',
	'/功能树/协同平台/组织权限/功能权限/权限管理',
	'fun',
	NULL,
	'access/forwardPermission.do',
	'fa-hand-lizard-o',
	NULL,
	NULL,
	1,
	1,
	812586,
	'权限管理',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF/86D6DB958BA84ED19DF33EDAC6364F42'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'888561D799F446FEA981C1825CCAC31E',
	'3AECEB1B898D4F348606363D5E444AE7',
	'DataManageType',
	'管理权限定义',
	'/功能树/协同平台/组织权限/数据管理权限/管理权限定义',
	'fun',
	NULL,
	'dataManageType/forwardListOpdatamanagetype.do',
	'fa-building-o',
	NULL,
	NULL,
	1,
	2,
	811507,
	'数据管理权限定义',
	NULL,
	'/1/443/446/3AECEB1B898D4F348606363D5E444AE7/888561D799F446FEA981C1825CCAC31E'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'97B71AB933674A47B99746511A4411F3',
	'443',
	'hawtio',
	'性能检测',
	'/功能树/协同平台/性能检测',
	'fun',
	NULL,
	'_blank:http://192.168.3.51:8080/hawtio',
	'fa',
	NULL,
	NULL,
	1,
	10,
	3579338,
	NULL,
	NULL,
	'/1/443/97B71AB933674A47B99746511A4411F3'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'UserGroupMge',
	'分组管理',
	'/功能树/协同平台/组织权限/组织机构/分组管理',
	'fun',
	NULL,
	'userGroup/forwardUserGroup.do',
	'fa-users',
	'分组管理',
	NULL,
	1,
	9,
	812059,
	'分组管理',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/9CBD5AB8EEB44EC6B0FB00FE002E5B3E'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'A587A3666005459DB4B2768B1386F2D9',
	'3AECEB1B898D4F348606363D5E444AE7',
	'DatamanageDetail',
	'管理权限资源维护',
	'/功能树/协同平台/组织权限/数据管理权限/管理权限资源维护',
	'fun',
	NULL,
	'dataManagement/forwardListOpdatamanagedetail.do',
	'fa-tachometer',
	NULL,
	NULL,
	1,
	3,
	811513,
	'数据管理权限资源维护',
	NULL,
	'/1/443/446/3AECEB1B898D4F348606363D5E444AE7/A587A3666005459DB4B2768B1386F2D9'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'A7A4C0AE008944AEB6A6E01037C24B23',
	'1531',
	'ErrorLoginLog',
	'无效人员登录日志',
	'/功能树/协同平台/系统日志/无效人员登录日志',
	'fun',
	NULL,
	'log/forwardErrorLoginLog.do',
	'fa-clipboard',
	NULL,
	NULL,
	1,
	2,
	811473,
	'无效人员登录日志',
	NULL,
	'/1/443/1531/A7A4C0AE008944AEB6A6E01037C24B23'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'A891BB9165904C48B3D6B73134CEB7E7',
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	'PersonLoginLimit',
	'登录限制',
	'/功能树/协同平台/安全策略/登录限制',
	'fun',
	NULL,
	'personLoginLimit/forwardPersonLoginLimit.do',
	'fa-exclamation-circle',
	NULL,
	NULL,
	1,
	3,
	811536,
	'登录限制',
	NULL,
	'/1/443/AD2EA0A0990243A3A7DB0B3FD2BCB0BE/A891BB9165904C48B3D6B73134CEB7E7'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	'443',
	'SecurityPolicy',
	'安全策略',
	'/功能树/协同平台/安全策略',
	'folder',
	NULL,
	NULL,
	'fa-fire-extinguisher',
	'安全策略',
	NULL,
	1,
	6,
	812528,
	'安全策略',
	NULL,
	'/1/443/AD2EA0A0990243A3A7DB0B3FD2BCB0BE'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'CFEE19FBBDCC4242834562C277F3DB6B',
	'32B4DC6736734C5985D5C7E4A13033BF',
	'TMAuthorize',
	'三员授权',
	'/功能树/协同平台/组织权限/功能权限/三员授权',
	'fun',
	NULL,
	'tmAuthorize/forwardTMAuthorize.do',
	'fa-hand-spock-o',
	NULL,
	NULL,
	1,
	5,
	812587,
	'三员授权',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF/CFEE19FBBDCC4242834562C277F3DB6B'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	'32B4DC6736734C5985D5C7E4A13033BF',
	'UIElement',
	'界面元素',
	'/功能树/协同平台/组织权限/功能权限/界面元素',
	'fun',
	NULL,
	'uiElement/forwardUIElement.do',
	'fa-clipboard',
	NULL,
	NULL,
	1,
	6,
	812590,
	'界面元素',
	NULL,
	'/1/443/446/32B4DC6736734C5985D5C7E4A13033BF/D219D03F5BDD4FB2893A86B0EF2A3FD9'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'D6A3E6208CCF4D8491DBC717955429F4',
	'446',
	'OrgFolder',
	'组织机构',
	'/功能树/协同平台/组织权限/组织机构',
	'folder',
	NULL,
	NULL,
	'fa-folder',
	NULL,
	NULL,
	1,
	1,
	811510,
	'组织机构',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'E420A7A8C2514663A1EFB96213A4BBA9',
	'3AECEB1B898D4F348606363D5E444AE7',
	'DataManagement',
	'管理权限授权',
	'/功能树/协同平台/组织权限/数据管理权限/管理权限授权',
	'fun',
	NULL,
	'dataManagement/forwardListOpdatamanagement.do',
	'fa-user-secret',
	NULL,
	NULL,
	1,
	5,
	3132745,
	'数据管理权限授权',
	NULL,
	'/1/443/446/3AECEB1B898D4F348606363D5E444AE7/E420A7A8C2514663A1EFB96213A4BBA9'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'F0362545AC424641BD3EB11BDBBDFB61',
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	'SecurityPolicyList',
	'安全策略',
	'/功能树/协同平台/安全策略/安全策略',
	'fun',
	NULL,
	'securityPolicy/forwardSecurityPolicy.do',
	'fa-heart',
	NULL,
	NULL,
	1,
	2,
	811539,
	'安全策略',
	NULL,
	'/1/443/AD2EA0A0990243A3A7DB0B3FD2BCB0BE/F0362545AC424641BD3EB11BDBBDFB61'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	'1656',
	'MessageRemind',
	'消息提醒配置',
	'/功能树/协同平台/系统配置/消息提醒配置',
	'fun',
	NULL,
	'messageRemind/forwardList.do',
	'fa-telegram',
	NULL,
	NULL,
	1,
	9,
	812599,
	'消息提醒配置',
	NULL,
	'/1/443/1656/F3D38CC6FB5049F99C7F6E832E3EC57A'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'FAD26F9F461D47FD84596AFC782C34A2',
	'443',
	'reportAdmin',
	'报告管理',
	'/功能树/协同平台/报告管理',
	'fun',
	NULL,
	'/report/showReports.do',
	'xx',
	NULL,
	NULL,
	1,
	9,
	3571467,
	NULL,
	NULL,
	'/1/443/FAD26F9F461D47FD84596AFC782C34A2'
	);
INSERT INTO `sa_opfunction`
VALUES
	(
	'FF0D8FE902D447D1A31110E86CDD8385',
	'D6A3E6208CCF4D8491DBC717955429F4',
	'RecycleBin',
	'回收站',
	'/功能树/协同平台/组织权限/组织机构/回收站',
	'fun',
	NULL,
	'org/forwardRecycleBin.do',
	'fa-trash-o',
	NULL,
	NULL,
	1,
	8,
	812060,
	'回收站',
	NULL,
	'/1/443/446/D6A3E6208CCF4D8491DBC717955429F4/FF0D8FE902D447D1A31110E86CDD8385'
	);-- ----------------------------
-- Table structure for sa_opfunction_field_group
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opfunction_field_group`;
CREATE TABLE `sa_opfunction_field_group` (
`FUNCTION_FIELD_GROUP_ID` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'function_field_group_id',
`FUNCTION_ID` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '功能ID',
`NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码'
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '功能字段权限设置表' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opfunction_permissionfield
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opfunction_permissionfield`;
CREATE TABLE `sa_opfunction_permissionfield` (
`PERMISSION_FIELD_ID` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'Permission_field_id',
`FUNCTION_FIELD_GROUP_ID` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'function_field_group_id',
`FIELD_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段名称',
`FIELD_CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段编码',
`FIELD_TYPE` TINYINT ( 1 ) NULL DEFAULT NULL COMMENT '字段类型',
`FIELD_AUTHORITY` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限'
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '功能字段权限对应表' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_opoperation
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opoperation`;
CREATE TABLE `sa_opoperation` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`IS_COMMON` INT ( 11 ) NULL DEFAULT NULL,
`RESOURCE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opoperation
-- ----------------------------
INSERT INTO `sa_opoperation`
VALUES
	( '1', 'readwrite', '读写', 1, 1, 1, 1, 'UI_ELEMENT' );
INSERT INTO `sa_opoperation`
VALUES
	( '1850F8E461AC4D44A67544E92D77E1B6', 'move', '移动', 1, 5, 5, 0, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( '1C7978FCC1CD4E4880E2A91B09DCAF7D', 'update', '修改', 1, 3, 3, 1, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( '2', 'readonly', '只读', 1, 2, 1, 1, 'UI_ELEMENT' );
INSERT INTO `sa_opoperation`
VALUES
	( '3', 'noaccess', '无权限', 1, 3, 2, 1, 'UI_ELEMENT' );
INSERT INTO `sa_opoperation`
VALUES
	( 'A0DAC625FBCF48F49AB9039BC746F196', 'query', '查询', 1, 6, 6, 1, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( 'C69E9314B8944B459B9C408A11C829D6', '*', '所有操作', 1, 1, 1, 1, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( 'D7F50C72845A45BE93E5378AC1636609', 'syn', '同步', 1, 7, 7, 0, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( 'E23D0E0EA7584311B048EED187DC1DA3', 'create', '新增', 1, 2, 2, 1, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( 'E3FB88A05FE749B08BF6D4D134084E5D', 'delete', '删除', 1, 4, 4, 1, 'FUN' );
INSERT INTO `sa_opoperation`
VALUES
	( 'EEA83C782F054979BA616BBF00043732', 'restore', '恢复', 1, 8, 8, 0, 'FUN' );-- ----------------------------
-- Table structure for sa_oporg
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oporg`;
CREATE TABLE `sa_oporg` (
`ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织ID',
`TYPE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织类型ID',
`CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`LONG_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '长名称',
`PARENT_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`FULL_CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '编码全路径',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '全名称',
`ORG_KIND_ID` VARCHAR ( 5 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ogn 机构 dpt 部门 pos 岗位 psm 人员成员',
`DEPTH` INT ( 11 ) NULL DEFAULT NULL COMMENT '深度',
`PERSON_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员ID',
`NODE_KIND_ID` VARCHAR ( 6 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'node 节点 leaf 叶子 ',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`ORG_CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '公司编码',
`DEPT_CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '部门编码',
`POSITION_CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '岗位编码',
`PERSON_MEMBER_CODE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '人员成员编码',
`IS_CENTER` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否中心',
`CENTER_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '中心编码',
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司名称',
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门名称',
`POSITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '岗位ID',
`PERSON_MEMBER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员成员ID',
`CENTER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '中心ID',
`ORG_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司名称',
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门名称',
`POSITION_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '岗位名称',
`PERSON_MEMBER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员成员名称',
`CENTER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '中心名称',
`FULL_SEQUENCE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '排序号全路径',
`FULL_ORG_KIND_ID` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`IS_VIRTUAL` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否虚拟组织',
`DEPT_LEVEL` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门级别',
`TENANT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '租户ID',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oporg
-- ----------------------------
INSERT INTO `sa_oporg`
VALUES
	(
	'0CBF734CE4184AF382831398B108941B',
	NULL,
	'etl',
	'ETL供应商',
	NULL,
	'18FFF477AEEE4609B798015231B400C3',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/0CBF734CE4184AF382831398B108941B.pos',
	'/INIT_ORG/INIT_DPT/etl',
	'/外部机构/测试使用部门/ETL供应商',
	'pos',
	NULL,
	NULL,
	NULL,
	NULL,
	1,
	2,
	3562604,
	'INIT_ORG',
	'INIT_DPT',
	'etl',
	NULL,
	NULL,
	NULL,
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'0CBF734CE4184AF382831398B108941B',
	NULL,
	NULL,
	'外部机构',
	'测试使用部门',
	'ETL供应商',
	NULL,
	NULL,
	'/010/001/002',
	'/ogn/dpt/pos',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'18FFF477AEEE4609B798015231B400C3',
	'2',
	'INIT_DPT',
	'测试使用部门',
	'测试使用部门',
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt',
	'/INIT_ORG/INIT_DPT',
	'/外部机构/测试使用部门',
	'dpt',
	NULL,
	NULL,
	NULL,
	NULL,
	1,
	1,
	294009,
	'INIT_ORG',
	'INIT_DPT',
	NULL,
	NULL,
	1,
	'INIT_DPT',
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	NULL,
	NULL,
	'18FFF477AEEE4609B798015231B400C3',
	'外部机构',
	'测试使用部门',
	NULL,
	NULL,
	'测试使用部门',
	'/010/001',
	'/ogn/dpt',
	0,
	'First',
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'tester',
	'业务系统管理者',
	'测试人员',
	'C18E23AAAA6940E09DF7C122332C51E0',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm',
	'/INIT_ORG/INIT_DPT/INIT_POS/tester',
	'/外部机构/测试使用部门/初始化岗位/业务系统管理者',
	'psm',
	NULL,
	'5B1A2386CCD9ECF9E050007F01003D30',
	NULL,
	NULL,
	1,
	3,
	311358,
	'INIT_ORG',
	'INIT_DPT',
	'INIT_POS',
	NULL,
	NULL,
	'INIT_DPT',
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'18FFF477AEEE4609B798015231B400C3',
	'外部机构',
	'测试使用部门',
	'初始化岗位',
	NULL,
	'测试使用部门',
	'/010/001/001/003',
	'/ogn/dpt/pos/psm',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'5E17123168A376FFE050007F01006612@C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'bmld',
	'部门领导',
	'部门领导',
	'C18E23AAAA6940E09DF7C122332C51E0',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5E17123168A376FFE050007F01006612@C18E23AAAA6940E09DF7C122332C51E0.psm',
	'/INIT_ORG/INIT_DPT/INIT_POS/bmld',
	'/外部机构/测试使用部门/初始化岗位/部门领导',
	'psm',
	NULL,
	'5E17123168A376FFE050007F01006612',
	NULL,
	NULL,
	1,
	8,
	311369,
	'INIT_ORG',
	'INIT_DPT',
	'INIT_POS',
	NULL,
	NULL,
	'INIT_DPT',
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'18FFF477AEEE4609B798015231B400C3',
	'外部机构',
	'测试使用部门',
	'初始化岗位',
	NULL,
	'测试使用部门',
	'/010/001/001/008',
	'/ogn/dpt/pos/psm',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'administrator',
	'系统管理员',
	'管理员',
	'C18E23AAAA6940E09DF7C122332C51E0',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm',
	'/INIT_ORG/INIT_DPT/INIT_POS/administrator',
	'/外部机构/测试使用部门/初始化岗位/系统管理员',
	'psm',
	NULL,
	'5EEB2DC861694A65933CB4CE9A8D870A',
	NULL,
	NULL,
	1,
	2,
	311359,
	'INIT_ORG',
	'INIT_DPT',
	'INIT_POS',
	NULL,
	NULL,
	'INIT_DPT',
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'18FFF477AEEE4609B798015231B400C3',
	'外部机构',
	'测试使用部门',
	'初始化岗位',
	NULL,
	'测试使用部门',
	'/010/001/001/002',
	'/ogn/dpt/pos/psm',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B',
	NULL,
	'user',
	'user',
	'user',
	'0CBF734CE4184AF382831398B108941B',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/0CBF734CE4184AF382831398B108941B.pos/607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B.psm',
	'/INIT_ORG/INIT_DPT/etl/user',
	'/外部机构/测试使用部门/ETL供应商/user',
	'psm',
	NULL,
	'607BD4AFE1F64458ACD6E5A31C102E80',
	NULL,
	NULL,
	1,
	1,
	3562616,
	'INIT_ORG',
	'INIT_DPT',
	'etl',
	NULL,
	NULL,
	NULL,
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'0CBF734CE4184AF382831398B108941B',
	NULL,
	NULL,
	'外部机构',
	'测试使用部门',
	'ETL供应商',
	NULL,
	NULL,
	'/010/001/002/001',
	'/ogn/dpt/pos/psm',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'92208DB644D0346BE050007F010012C2@C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'juyanfeng',
	'鞠岩峰',
	'鞠岩峰',
	'C18E23AAAA6940E09DF7C122332C51E0',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/92208DB644D0346BE050007F010012C2@C18E23AAAA6940E09DF7C122332C51E0.psm',
	'/INIT_ORG/INIT_DPT/INIT_POS/juyanfeng',
	'/外部机构/测试使用部门/初始化岗位/鞠岩峰',
	'psm',
	NULL,
	'92208DB644D0346BE050007F010012C2',
	NULL,
	NULL,
	1,
	9,
	3580821,
	'INIT_ORG',
	'INIT_DPT',
	'INIT_POS',
	NULL,
	NULL,
	NULL,
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	NULL,
	'外部机构',
	'测试使用部门',
	'初始化岗位',
	NULL,
	NULL,
	'/010/001/001/009',
	'/ogn/dpt/pos/psm',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'C18E23AAAA6940E09DF7C122332C51E0',
	'3',
	'INIT_POS',
	'初始化岗位',
	'初始化岗位',
	'18FFF477AEEE4609B798015231B400C3',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos',
	'/INIT_ORG/INIT_DPT/INIT_POS',
	'/外部机构/测试使用部门/初始化岗位',
	'pos',
	NULL,
	NULL,
	NULL,
	NULL,
	1,
	1,
	311357,
	'INIT_ORG',
	'INIT_DPT',
	'INIT_POS',
	NULL,
	NULL,
	'INIT_DPT',
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'18FFF477AEEE4609B798015231B400C3',
	'C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	'18FFF477AEEE4609B798015231B400C3',
	'外部机构',
	'测试使用部门',
	'初始化岗位',
	NULL,
	'测试使用部门',
	'/010/001/001',
	'/ogn/dpt/pos',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);
INSERT INTO `sa_oporg`
VALUES
	(
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'1',
	'INIT_ORG',
	'外部机构',
	'外部机构',
	'orgRoot',
	'/E3B4E5C5C6454F81921CF58B7597CE2F.ogn',
	'/INIT_ORG',
	'/外部机构',
	'ogn',
	NULL,
	NULL,
	NULL,
	NULL,
	1,
	10,
	291609,
	'INIT_ORG',
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	NULL,
	NULL,
	NULL,
	NULL,
	'外部机构',
	NULL,
	NULL,
	NULL,
	NULL,
	'/010',
	'/ogn',
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2'
	);-- ----------------------------
-- Table structure for sa_oporgproperty
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oporgproperty`;
CREATE TABLE `sa_oporgproperty` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`ORG_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构ID',
`PROPERTY_DEFINITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '属性定义ID',
`PROPERTY_VALUE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '属性值',
`PROPERTY_DISPLAY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织机构属性' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oporgproperty
-- ----------------------------
INSERT INTO `sa_oporgproperty`
VALUES
	( '84BAEE46A93B589FE050007F01007457', '0101', '84BAEE0ADB245002E050007F0100746D', '1700', '1700', 3295536 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8611504022AE0886E050007F010078BD', '0203P0005', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3395007 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832B0252C3790AFE050007F01007097', '0207A', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430423 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832BA915119B0D2E050007F010070DF', '8ABC494C64FC484186C2BFA6FA62A124', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430503 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832BA91511AB0D2E050007F010070DF', 'D3287025E1424945BEDAB79540801B0E', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430547 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832BAB759383412E050007F010070F1', 'BD0ED2E17D62494F91EB28C27BD44318', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430508 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832BAB759393412E050007F010070F1', '9F5C25B40604464AB5E80FFA830EFDC7', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430540 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832BADE6261F6E6E050007F010070FF', '19E8FC0152E54CF3B0B869AD5D181D95', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430513 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8832C715E1EF69EDE050007F01007154', '81A2D9C0B89F47C683CF6B730D21122F', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3430617 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '883317371A7009DFE050007F01007403', '800A55B2583E41A58B10E3CD793CA012', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3431259 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '894C7A57A2674E78E050007F0100667B', '0207L', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3449635 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '894E63DE358D1C14E050007F010079DB', '7F973D0234724BA4A2A2044ABB60780F', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3450796 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '894E6E1ED54E3C3AE050007F01007A5F', '26D35EB88BE94116B95D70F151D1B560', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3450815 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '894E7A2714B8337EE050007F01007AD4', 'A14EC67576644A1380D2EDFA86FB6595', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3450860 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '89551789C0822283E050007F0100466A', '0201A', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3451628 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '89EFDD7AA4B17B84E050007F01000E2E', '0109', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3467090 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8BA6044A04D11D1BE050007F01002AFD', '0102', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3489378 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8BA60BDBF6720063E050007F01002BE9', 'FB70C8F0A15B4925A7C61ECD898448E8', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3489433 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8E0108B5594F1ACEE050007F01004487', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3513002 );
INSERT INTO `sa_oporgproperty`
VALUES
	( '8E550473AEFF6F1AE050007F01004145', '0302P0001', '84BAEE0ADB245002E050007F0100746D', NULL, NULL, 3518081 );-- ----------------------------
-- Table structure for sa_oporgpropertydefinition
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oporgpropertydefinition`;
CREATE TABLE `sa_oporgpropertydefinition` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ORG_KIND_ID` VARCHAR ( 6 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DESCRIPTION` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DATA_SOURCE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_oporgroleauthorize
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oporgroleauthorize`;
CREATE TABLE `sa_oporgroleauthorize` (
`ID` BIGINT ( 20 ) NOT NULL COMMENT 'ID',
`ORG_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织ID',
`ROLE_KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '角色类别ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_oporgtemplate
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oporgtemplate`;
CREATE TABLE `sa_oporgtemplate` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`TYPE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织类型ID',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织机构模板' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oporgtemplate
-- ----------------------------
INSERT INTO `sa_oporgtemplate`
VALUES
	( '76312014953484A6E050007F01002408', '1', '1', 1, 3126764, NULL );
INSERT INTO `sa_oporgtemplate`
VALUES
	( '763120F0847154FCE050007F01002412', '2', '76312014953484A6E050007F01002408', 1, 3126787, NULL );
INSERT INTO `sa_oporgtemplate`
VALUES
	( '763121741354194EE050007F0100241C', '3', '763120F0847154FCE050007F01002412', 1, 3126802, NULL );-- ----------------------------
-- Table structure for sa_oporgtype
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oporgtype`;
CREATE TABLE `sa_oporgtype` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件夹ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`ORG_KIND_ID` VARCHAR ( 5 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ogn 机构 dpt 部门 pos 岗位',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织机构类型' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oporgtype
-- ----------------------------
INSERT INTO `sa_oporgtype`
VALUES
	( '1', '49530B56651A484196B80818734A49F6', 'INIT_ORG', '初始化机构', 'ogn', 1, 2, 282335 );
INSERT INTO `sa_oporgtype`
VALUES
	( '2', '181', 'INIT_DPT', '初始化部门', 'dpt', 1, 1, 145815 );
INSERT INTO `sa_oporgtype`
VALUES
	( '3', '189', 'INIT_POS', '初始化岗位', 'pos', 1, 2, 82186 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6174D47EC0A62BAAE050007F01000400', '181', 'EXT_DPT', '外部部门', 'dpt', 1, 2, 420638 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6860D2195040F252E050007F0100164D', '189', 'grop1', '王景妤组', 'pos', 1, 3, 1161014 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6873FCD782537552E050007F01006B96', '181', 'dept1', '王景妤部', 'dpt', 1, 3, 1160993 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6876DB8EA8B3F23BE050007F01000A2A', '181', 'dept2', '吴晓燕部', 'dpt', 1, 4, 1161000 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6876DC8180894E75E050007F01000A3A', '181', 'dept3', '邹龙君部', 'dpt', 1, 5, 1161007 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6876DFFA1F6A2DDFE050007F01000A58', '189', 'grop2', '吴晓燕组', 'pos', 1, 4, 1161025 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6876E0B8C3625476E050007F01000A5E', '189', 'grop3', '邹龙君组', 'pos', 1, 5, 1161032 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B62AD970EDB96E050007F01006CFC', '181', '0207B', '加速器总体', 'dpt', 1, 6, 1169620 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6806EE00D716E050007F01006D2D', '181', '0207B01', '注入器', 'dpt', 1, 7, 1169646 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B691D6B3BBA34E050007F01006CF4', '181', '0207B01001', '电子枪', 'dpt', 1, 8, 1169653 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6A1C4E3D2596E050007F01006D43', '181', '0207B01002', '固态功率源', 'dpt', 1, 9, 1169660 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6AC70D861EBBE050007F01006D49', '181', '0207B01003', '光阴极', 'dpt', 1, 10, 1169667 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6B8456DE0B76E050007F01006D4E', '181', '0207B01004', '激光', 'dpt', 1, 11, 1169674 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6B8456DF0B76E050007F01006D4E', '181', '0207B01005', '射频', 'dpt', 1, 12, 3405944 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6B8456E00B76E050007F01006D4E', '181', '0207B01007', '低温模组', 'dpt', 1, 14, 1169707 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6CD71D691D82E050007F01006D5A', '181', '0207B01006', '脉冲功率源', 'dpt', 1, 13, 1169700 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6CD71D6A1D82E050007F01006D5A', '181', '0207B01009', '激光加热波荡器', 'dpt', 1, 16, 1169721 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6E3790759E0CE050007F01006D5F', '181', '0207B01008', '低电平', 'dpt', 1, 15, 1169714 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6E3790769E0CE050007F01006D5F', '181', '0207B01011', '真空', 'dpt', 1, 18, 1169735 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B6F9D26293C7BE050007F01006D65', '181', '0207B01010', '快引出', 'dpt', 1, 17, 1169728 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B70B6A049CD78E050007F01006D71', '181', '0207B01012', '机械', 'dpt', 1, 19, 1169742 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B70B6A04ACD78E050007F01006D71', '181', '0207B01013', '高功率耦合器测试平台', 'dpt', 1, 20, 1169749 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B72003965FB59E050007F01006D77', '181', 'SPCL_DPT', '射频测量平台', 'dpt', 1, 21, 1168871 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8AABBD005AC2E050007F01006E46', '181', '0207B02', '加速器', 'dpt', 1, 22, 1169892 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8C54DFA23EB8E050007F01006E52', '181', '0207B02001', '1.3G超导加速腔模组', 'dpt', 1, 23, 1169958 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8D68F4BFAA32E050007F01006E60', '181', '0207B02002', '3.9G超导加速腔模组', 'dpt', 1, 24, 1169967 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8E6D10B55C60E050007F01006E64', '181', '0207B02003', '1.3G固态放大器和低电平系统', 'dpt', 1, 25, 1169976 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8F32D45EB7E3E050007F01006E6B', '181', '0207B02004', '3.9G固态放大器和低电平系统', 'dpt', 1, 26, 1169985 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8F32D45FB7E3E050007F01006E6B', '181', '0207B02006', '能散补偿系统', 'dpt', 1, 28, 1170005 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B8FDC163A2CD0E050007F01006E71', '181', '0207B02005', '束团压缩系统', 'dpt', 1, 27, 1169994 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B911AB19C58B2E050007F01006E7D', '181', '0207B02007', 'S波段偏转腔诊断', 'dpt', 1, 29, 1170016 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B911AB19D58B2E050007F01006E7D', '181', '0207B02008', 'X波段偏转腔诊断', 'dpt', 1, 30, 1170025 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B9CC592A00F1EE050007F01006ECE', '181', '0207B03', '低温', 'dpt', 1, 31, 1170524 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B9D6DA60EC19BE050007F01006ED7', '181', '0207B03001', '低温制冷机', 'dpt', 1, 32, 1170533 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B9D6DA60FC19BE050007F01006ED7', '181', '0207B03002', '常温管线', 'dpt', 1, 33, 1170596 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688B9EC98D06DD4EE050007F01006EEB', '181', '0207B03003', '常温阀门', 'dpt', 1, 34, 1170611 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BF67BB9824B30E050007F010071BD', '181', '0207B03004', '缓冲中压罐体', 'dpt', 1, 35, 1170624 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BF796A184481EE050007F010071C3', '181', '0207B03005', '液氮系统', 'dpt', 1, 36, 1170631 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BF94F4BF721E9E050007F010071CF', '181', '0207B03006', '回收纯化系统', 'dpt', 1, 37, 1170646 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BF9E60525DE0DE050007F010071D5', '181', '0207B03007', '低温管线', 'dpt', 1, 37, 1170649 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BF9E60526DE0DE050007F010071D5', '181', '0207B03008', '低温阀门', 'dpt', 1, 37, 1170652 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BFB9C9864AF84E050007F010071DA', '181', '0207B03009', '阀箱', 'dpt', 1, 37, 1170655 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BFB9C9865AF84E050007F010071DA', '181', '0207B03010', '真空泵组', 'dpt', 1, 37, 1170658 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BFB9C9866AF84E050007F010071DA', '181', '0207B03011', '控制系统', 'dpt', 1, 37, 1170661 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BFCF3382F1CF3E050007F010071EE', '181', '0207B03012', '温度探头', 'dpt', 1, 37, 1170664 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BFCF338301CF3E050007F010071EE', '181', '0207B03013', '水冷系统', 'dpt', 1, 37, 1170667 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688BFCF338311CF3E050007F010071EE', '181', '0207B03014', '安全系统', 'dpt', 1, 37, 1170670 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0A3625668568E050007F0100724C', '181', '0207B04', '波荡器', 'dpt', 1, 38, 1170915 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0C974DD5D667E050007F0100727F', '181', '0207B04001', '波荡器线FEL-I', 'dpt', 1, 39, 1170941 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0CFCA9AF2AAAE050007F01007287', '181', '0207B04002', '波荡器线FEL-II', 'dpt', 1, 39, 1170944 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0CFCA9B02AAAE050007F01007287', '181', '0207B04003', '波荡器线FEL-III', 'dpt', 1, 39, 1170947 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0CFCA9B12AAAE050007F01007287', '181', '0207B04004', '束流分配', 'dpt', 1, 39, 1170950 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0CFCA9B22AAAE050007F01007287', '181', '0207B05001', '设备控制', 'dpt', 1, 41, 1171081 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C0E2681565F5AE050007F01007291', '181', '0207B04005', '物理、激光与同步', 'dpt', 1, 39, 1170953 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C1462C9842C02E050007F010072B0', '181', '0207B05', '测控', 'dpt', 1, 40, 1171053 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C16E7BE8D052BE050007F010072C2', '181', '0207B05002', '快联锁系统', 'dpt', 1, 41, 1171084 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C16E7BE8E052BE050007F010072C2', '181', '0207B05003', '上层控制、流数据采集', 'dpt', 1, 41, 1171087 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C16E7BE8F052BE050007F010072C2', '181', '0207B05004', '横向位置测量系统', 'dpt', 1, 41, 1171090 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C180D345B8F94E050007F010072C8', '181', '0207B05005', '束团纵向参数测量系统', 'dpt', 1, 41, 1171093 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C180D345C8F94E050007F010072C8', '181', '0207B05006', '截面及流强测量系统', 'dpt', 1, 41, 1171096 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C180D345D8F94E050007F010072C8', '181', '0207B05007', '辐射安全系统', 'dpt', 1, 41, 1171099 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C1C92579B0760E050007F01007306', '181', '0207B05008', '常规磁铁', 'dpt', 1, 42, 1171128 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C1CF981D0A1D4E050007F0100730C', '181', '0207B05009', '常规电源系统', 'dpt', 1, 42, 1171131 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C1CF981D1A1D4E050007F0100730C', '181', '0207B05010', '准直系统', 'dpt', 1, 42, 1171134 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C1CF981D2A1D4E050007F0100730C', '181', '0207B05011', '工艺系统', 'dpt', 1, 42, 1171137 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C27DEC3AEC625E050007F01007345', '181', '0207B06', '配套公用设施', 'dpt', 1, 43, 1171341 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C340BAAF4A010E050007F010073BB', '181', '0207C', '束线站总体', 'dpt', 1, 44, 1171917 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C37F5FC5D62F3E050007F010073B9', '181', '0207C01', '光束线', 'dpt', 1, 45, 1171969 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C3A620358CCBFE050007F010073DF', '181', '0207C01001', 'FEL-I光束线', 'dpt', 1, 46, 1172014 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C3ACFC413FC50E050007F010073F3', '181', '0207C01002', 'FEL-II光束线', 'dpt', 1, 46, 1172017 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C3ACFC414FC50E050007F010073F3', '181', '0207C01003', 'FEL-III光束线', 'dpt', 1, 46, 1172020 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C460FC241D747E050007F01007438', '181', '0207C02', '实验站', 'dpt', 1, 47, 1172210 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C47C8DD3B2AA6E050007F01007400', '181', '0207C02001', '相干衍射实验站', 'dpt', 1, 47, 1172235 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C47C8DD3C2AA6E050007F01007400', '181', '0207C02002', '原子分子反应成像实验站', 'dpt', 1, 47, 1172238 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C488BCF4C8663E050007F0100744A', '181', '0207C02003', '单分子单颗粒相干衍射实验站', 'dpt', 1, 47, 1172313 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C488BCF4D8663E050007F0100744A', '181', '0207C02004', '物质电子结构实验站', 'dpt', 1, 47, 1172244 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C488BCF4E8663E050007F0100744A', '181', '0207C02005', '软X光高分辨共振散射实验站', 'dpt', 1, 47, 1172247 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C49A4F06D3F08E050007F01007450', '181', '0207C02006', '串行晶体学实验站', 'dpt', 1, 47, 1172250 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C49A4F06E3F08E050007F01007450', '181', '0207C02007', '硬X射线超快谱学实验站', 'dpt', 1, 47, 1172253 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C49A4F06F3F08E050007F01007450', '181', '0207C02008', '硬X射线高分辨共振散射实验站', 'dpt', 1, 47, 1172256 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C551378B6509DE050007F0100747B', '181', '0207C03', '束线与实验站辅助系统', 'dpt', 1, 48, 1172432 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C551378B7509DE050007F0100747B', '181', '0207C03001', '探测器', 'dpt', 1, 49, 1172482 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C5873B94CD01DE050007F010074BF', '181', '0207C03002', '数据采集与处理', 'dpt', 1, 49, 1172490 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C5873B94DD01DE050007F010074BF', '181', '0207C03003', '泵浦激光', 'dpt', 1, 49, 1172500 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C5D16189E8001E050007F010074CF', '181', '0207D', '极端光物理', 'dpt', 1, 50, 1172606 );
INSERT INTO `sa_oporgtype`
VALUES
	( '688C601EF986B1CFE050007F010074F5', '181', '0207D01', '极端光物理实验站', 'dpt', 1, 51, 1172666 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6A2BA201960C017FE050007F01006616', '181', '0207E', '总师办', 'dpt', 1, 52, 1279786 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6A2BA2BACC5B643CE050007F0100661C', '181', '0207F', '工程办', 'dpt', 1, 52, 1279789 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6A2BA39CB7EE5D03E050007F01006620', '181', '0207G', '项目领导', 'dpt', 1, 52, 1279792 );
INSERT INTO `sa_oporgtype`
VALUES
	( '6BA8EB6F6BA55AF5E050007F01003AA1', '189', 'ScientificResearchPersonnel', '科研人员', 'pos', 1, 6, 1321678 );-- ----------------------------
-- Table structure for sa_oppermission
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oppermission`;
CREATE TABLE `sa_oppermission` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
`RESOURCE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源类型ID',
`RESOURCE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源ID',
`OPERATION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作ID',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`NODE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oppermission
-- ----------------------------
INSERT INTO `sa_oppermission`
VALUES
	(
	'0BD90B4C11BA4ACA8E2AEC4406C8DA35',
	'5CA97EEC61324A5D8155933335CC9B4C',
	'reportAdmin:delete',
	'报告管理删除',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C/0BD90B4C11BA4ACA8E2AEC4406C8DA35',
	'/系统功能/协同平台/报告管理/报告管理删除',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3571028,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'1',
	'0',
	'Gns',
	'系统功能',
	'/1',
	'/系统功能',
	'fun',
	'1',
	NULL,
	1,
	1,
	105161,
	'folder',
	'qqqq'
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'28E3126A28F24BE1B340D56D4F4877D4',
	'5FF00C38293B4E2BBA94DD48122C691C',
	'hawtio:delete',
	'性能检测删除',
	'/1/6000FDBFF674421E883D035966C60431/5FF00C38293B4E2BBA94DD48122C691C/28E3126A28F24BE1B340D56D4F4877D4',
	'/系统功能/协同平台/性能检测/性能检测删除',
	'fun',
	'97B71AB933674A47B99746511A4411F3',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3579350,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'332E9D6F5789409784B2D83459B5F88A',
	'76C3EFD9DC76BDD2E050007F010069C5',
	'Org:syn',
	'组织管理同步',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5/332E9D6F5789409784B2D83459B5F88A',
	'/系统功能/协同平台/组织权限/组织机构/组织管理/组织管理同步',
	'fun',
	'452',
	'D7F50C72845A45BE93E5378AC1636609',
	1,
	7,
	3568108,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'4827D71C9FA94C4896649BBE73EB0B3D',
	'5FF00C38293B4E2BBA94DD48122C691C',
	'hawtio:query',
	'性能检测查询',
	'/1/6000FDBFF674421E883D035966C60431/5FF00C38293B4E2BBA94DD48122C691C/4827D71C9FA94C4896649BBE73EB0B3D',
	'/系统功能/协同平台/性能检测/性能检测查询',
	'fun',
	'97B71AB933674A47B99746511A4411F3',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3579351,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'571FCB0B2D1040698749A3A749C1B9DA',
	'5CA97EEC61324A5D8155933335CC9B4C',
	'shareReportUI',
	'无分享报告的权限',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C/571FCB0B2D1040698749A3A749C1B9DA',
	'/系统功能/协同平台/报告管理/无分享报告的权限',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	NULL,
	1,
	7,
	3571926,
	'uiElement',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'5CA97EEC61324A5D8155933335CC9B4C',
	'6000FDBFF674421E883D035966C60431',
	'reportAdmin',
	'报告管理',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C',
	'/系统功能/协同平台/报告管理',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	NULL,
	1,
	9,
	3571024,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'5FF00C38293B4E2BBA94DD48122C691C',
	'6000FDBFF674421E883D035966C60431',
	'hawtio',
	'性能检测',
	'/1/6000FDBFF674421E883D035966C60431/5FF00C38293B4E2BBA94DD48122C691C',
	'/系统功能/协同平台/性能检测',
	'fun',
	'97B71AB933674A47B99746511A4411F3',
	NULL,
	1,
	10,
	3579346,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'6000FDBFF674421E883D035966C60431',
	'1',
	'Coordination',
	'协同平台',
	'/1/6000FDBFF674421E883D035966C60431',
	'/系统功能/协同平台',
	'fun',
	'443',
	NULL,
	1,
	1,
	258040,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'6FEE4B7967FD4FC0B737699BB5186DFE',
	'5CA97EEC61324A5D8155933335CC9B4C',
	'reportAdmin:update',
	'报告管理修改',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C/6FEE4B7967FD4FC0B737699BB5186DFE',
	'/系统功能/协同平台/报告管理/报告管理修改',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3571027,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB57BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'SysLog',
	'系统日志',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志',
	'fun',
	'1531',
	NULL,
	1,
	7,
	3406253,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB58BDD2E050007F010069C5',
	'76C3EFD9DB57BDD2E050007F010069C5',
	'OperationLog',
	'操作日志',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB58BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/操作日志',
	'fun',
	'300',
	NULL,
	1,
	4,
	3129647,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB59BDD2E050007F010069C5',
	'76C3EFD9DB58BDD2E050007F010069C5',
	'OperationLog:*',
	'操作日志所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB58BDD2E050007F010069C5/76C3EFD9DB59BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/操作日志/操作日志所有操作',
	'fun',
	'300',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129648,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB5ABDD2E050007F010069C5',
	'76C3EFD9DB58BDD2E050007F010069C5',
	'OperationLog:create',
	'操作日志新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB58BDD2E050007F010069C5/76C3EFD9DB5ABDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/操作日志/操作日志新增',
	'fun',
	'300',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129649,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB5BBDD2E050007F010069C5',
	'76C3EFD9DB58BDD2E050007F010069C5',
	'OperationLog:update',
	'操作日志修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB58BDD2E050007F010069C5/76C3EFD9DB5BBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/操作日志/操作日志修改',
	'fun',
	'300',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129650,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB5CBDD2E050007F010069C5',
	'76C3EFD9DB58BDD2E050007F010069C5',
	'OperationLog:delete',
	'操作日志删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB58BDD2E050007F010069C5/76C3EFD9DB5CBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/操作日志/操作日志删除',
	'fun',
	'300',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129651,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB5DBDD2E050007F010069C5',
	'76C3EFD9DB58BDD2E050007F010069C5',
	'OperationLog:query',
	'操作日志查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB58BDD2E050007F010069C5/76C3EFD9DB5DBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/操作日志/操作日志查询',
	'fun',
	'300',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129652,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB5EBDD2E050007F010069C5',
	'76C3EFD9DB57BDD2E050007F010069C5',
	'ErrorLog',
	'错误日志',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB5EBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/错误日志',
	'fun',
	'400',
	NULL,
	1,
	3,
	3188713,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB5FBDD2E050007F010069C5',
	'76C3EFD9DB5EBDD2E050007F010069C5',
	'ErrorLog:*',
	'错误日志所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB5EBDD2E050007F010069C5/76C3EFD9DB5FBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/错误日志/错误日志所有操作',
	'fun',
	'400',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3188724,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB60BDD2E050007F010069C5',
	'76C3EFD9DB5EBDD2E050007F010069C5',
	'ErrorLog:create',
	'错误日志新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB5EBDD2E050007F010069C5/76C3EFD9DB60BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/错误日志/错误日志新增',
	'fun',
	'400',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3188733,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB61BDD2E050007F010069C5',
	'76C3EFD9DB5EBDD2E050007F010069C5',
	'ErrorLog:update',
	'错误日志修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB5EBDD2E050007F010069C5/76C3EFD9DB61BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/错误日志/错误日志修改',
	'fun',
	'400',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3188742,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB62BDD2E050007F010069C5',
	'76C3EFD9DB5EBDD2E050007F010069C5',
	'ErrorLog:delete',
	'错误日志删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB5EBDD2E050007F010069C5/76C3EFD9DB62BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/错误日志/错误日志删除',
	'fun',
	'400',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3188751,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB63BDD2E050007F010069C5',
	'76C3EFD9DB5EBDD2E050007F010069C5',
	'ErrorLog:query',
	'错误日志查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB5EBDD2E050007F010069C5/76C3EFD9DB63BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/错误日志/错误日志查询',
	'fun',
	'400',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3188760,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB64BDD2E050007F010069C5',
	'76C3EFD9DB57BDD2E050007F010069C5',
	'LoginLog',
	'登陆日志',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB64BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/登陆日志',
	'fun',
	'500',
	NULL,
	1,
	1,
	3129673,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB65BDD2E050007F010069C5',
	'76C3EFD9DB64BDD2E050007F010069C5',
	'LoginLog:*',
	'登陆日志所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB64BDD2E050007F010069C5/76C3EFD9DB65BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/登陆日志/登陆日志所有操作',
	'fun',
	'500',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129674,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB66BDD2E050007F010069C5',
	'76C3EFD9DB64BDD2E050007F010069C5',
	'LoginLog:create',
	'登陆日志新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB64BDD2E050007F010069C5/76C3EFD9DB66BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/登陆日志/登陆日志新增',
	'fun',
	'500',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129675,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB67BDD2E050007F010069C5',
	'76C3EFD9DB64BDD2E050007F010069C5',
	'LoginLog:update',
	'登陆日志修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB64BDD2E050007F010069C5/76C3EFD9DB67BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/登陆日志/登陆日志修改',
	'fun',
	'500',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129676,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB68BDD2E050007F010069C5',
	'76C3EFD9DB64BDD2E050007F010069C5',
	'LoginLog:delete',
	'登陆日志删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB64BDD2E050007F010069C5/76C3EFD9DB68BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/登陆日志/登陆日志删除',
	'fun',
	'500',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129677,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB69BDD2E050007F010069C5',
	'76C3EFD9DB64BDD2E050007F010069C5',
	'LoginLog:query',
	'登陆日志查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB64BDD2E050007F010069C5/76C3EFD9DB69BDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/登陆日志/登陆日志查询',
	'fun',
	'500',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129678,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB6ABDD2E050007F010069C5',
	'76C3EFD9DB57BDD2E050007F010069C5',
	'ErrorLoginLog',
	'无效人员登录日志',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB6ABDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/无效人员登录日志',
	'fun',
	'A7A4C0AE008944AEB6A6E01037C24B23',
	NULL,
	1,
	2,
	3129686,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB6BBDD2E050007F010069C5',
	'76C3EFD9DB6ABDD2E050007F010069C5',
	'ErrorLoginLog:*',
	'无效人员登录日志所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB6ABDD2E050007F010069C5/76C3EFD9DB6BBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/无效人员登录日志/无效人员登录日志所有操作',
	'fun',
	'A7A4C0AE008944AEB6A6E01037C24B23',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129687,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB6CBDD2E050007F010069C5',
	'76C3EFD9DB6ABDD2E050007F010069C5',
	'ErrorLoginLog:create',
	'无效人员登录日志新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB6ABDD2E050007F010069C5/76C3EFD9DB6CBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/无效人员登录日志/无效人员登录日志新增',
	'fun',
	'A7A4C0AE008944AEB6A6E01037C24B23',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129688,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB6DBDD2E050007F010069C5',
	'76C3EFD9DB6ABDD2E050007F010069C5',
	'ErrorLoginLog:update',
	'无效人员登录日志修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB6ABDD2E050007F010069C5/76C3EFD9DB6DBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/无效人员登录日志/无效人员登录日志修改',
	'fun',
	'A7A4C0AE008944AEB6A6E01037C24B23',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129689,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB6EBDD2E050007F010069C5',
	'76C3EFD9DB6ABDD2E050007F010069C5',
	'ErrorLoginLog:delete',
	'无效人员登录日志删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB6ABDD2E050007F010069C5/76C3EFD9DB6EBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/无效人员登录日志/无效人员登录日志删除',
	'fun',
	'A7A4C0AE008944AEB6A6E01037C24B23',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129690,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB6FBDD2E050007F010069C5',
	'76C3EFD9DB6ABDD2E050007F010069C5',
	'ErrorLoginLog:query',
	'无效人员登录日志查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB57BDD2E050007F010069C5/76C3EFD9DB6ABDD2E050007F010069C5/76C3EFD9DB6FBDD2E050007F010069C5',
	'/系统功能/协同平台/系统日志/无效人员登录日志/无效人员登录日志查询',
	'fun',
	'A7A4C0AE008944AEB6A6E01037C24B23',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129691,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB70BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'WorkflowTaskManagement',
	'流程任务管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理',
	'fun',
	'158EE9A480EA4E49865DCDE28AD32A83',
	NULL,
	1,
	4,
	3129693,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB71BDD2E050007F010069C5',
	'76C3EFD9DB70BDD2E050007F010069C5',
	'TaskQuery',
	'流程任务查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB71BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务查询',
	'fun',
	'1A063E96064444AAB643D390EC87C800',
	NULL,
	1,
	4,
	3129701,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB72BDD2E050007F010069C5',
	'76C3EFD9DB71BDD2E050007F010069C5',
	'TaskQuery:*',
	'流程任务查询所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB71BDD2E050007F010069C5/76C3EFD9DB72BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务查询/流程任务查询所有操作',
	'fun',
	'1A063E96064444AAB643D390EC87C800',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129702,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB73BDD2E050007F010069C5',
	'76C3EFD9DB71BDD2E050007F010069C5',
	'TaskQuery:create',
	'流程任务查询新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB71BDD2E050007F010069C5/76C3EFD9DB73BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务查询/流程任务查询新增',
	'fun',
	'1A063E96064444AAB643D390EC87C800',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129703,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB74BDD2E050007F010069C5',
	'76C3EFD9DB71BDD2E050007F010069C5',
	'TaskQuery:update',
	'流程任务查询修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB71BDD2E050007F010069C5/76C3EFD9DB74BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务查询/流程任务查询修改',
	'fun',
	'1A063E96064444AAB643D390EC87C800',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129704,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB75BDD2E050007F010069C5',
	'76C3EFD9DB71BDD2E050007F010069C5',
	'TaskQuery:delete',
	'流程任务查询删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB71BDD2E050007F010069C5/76C3EFD9DB75BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务查询/流程任务查询删除',
	'fun',
	'1A063E96064444AAB643D390EC87C800',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129705,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB76BDD2E050007F010069C5',
	'76C3EFD9DB71BDD2E050007F010069C5',
	'TaskQuery:query',
	'流程任务查询查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB71BDD2E050007F010069C5/76C3EFD9DB76BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务查询/流程任务查询查询',
	'fun',
	'1A063E96064444AAB643D390EC87C800',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129706,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB77BDD2E050007F010069C5',
	'76C3EFD9DB70BDD2E050007F010069C5',
	'ProcUnitHandlerQuery',
	'流程处理人查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB77BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程处理人查询',
	'fun',
	'222052FA15FC4CBD969804CEB4851EB9',
	NULL,
	1,
	5,
	3129714,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB78BDD2E050007F010069C5',
	'76C3EFD9DB77BDD2E050007F010069C5',
	'ProcUnitHandlerQuery:*',
	'流程处理人查询所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB77BDD2E050007F010069C5/76C3EFD9DB78BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程处理人查询/流程处理人查询所有操作',
	'fun',
	'222052FA15FC4CBD969804CEB4851EB9',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129715,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB79BDD2E050007F010069C5',
	'76C3EFD9DB77BDD2E050007F010069C5',
	'ProcUnitHandlerQuery:create',
	'流程处理人查询新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB77BDD2E050007F010069C5/76C3EFD9DB79BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程处理人查询/流程处理人查询新增',
	'fun',
	'222052FA15FC4CBD969804CEB4851EB9',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129716,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB7ABDD2E050007F010069C5',
	'76C3EFD9DB77BDD2E050007F010069C5',
	'ProcUnitHandlerQuery:update',
	'流程处理人查询修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB77BDD2E050007F010069C5/76C3EFD9DB7ABDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程处理人查询/流程处理人查询修改',
	'fun',
	'222052FA15FC4CBD969804CEB4851EB9',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129717,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB7BBDD2E050007F010069C5',
	'76C3EFD9DB77BDD2E050007F010069C5',
	'ProcUnitHandlerQuery:delete',
	'流程处理人查询删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB77BDD2E050007F010069C5/76C3EFD9DB7BBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程处理人查询/流程处理人查询删除',
	'fun',
	'222052FA15FC4CBD969804CEB4851EB9',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129718,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB7CBDD2E050007F010069C5',
	'76C3EFD9DB77BDD2E050007F010069C5',
	'ProcUnitHandlerQuery:query',
	'流程处理人查询查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB77BDD2E050007F010069C5/76C3EFD9DB7CBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程处理人查询/流程处理人查询查询',
	'fun',
	'222052FA15FC4CBD969804CEB4851EB9',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129719,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB7DBDD2E050007F010069C5',
	'76C3EFD9DB70BDD2E050007F010069C5',
	'Agent',
	'代理管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB7DBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/代理管理',
	'fun',
	'457',
	NULL,
	1,
	1,
	3129727,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB7EBDD2E050007F010069C5',
	'76C3EFD9DB7DBDD2E050007F010069C5',
	'Agent:*',
	'代理管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB7DBDD2E050007F010069C5/76C3EFD9DB7EBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/代理管理/代理管理所有操作',
	'fun',
	'457',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129728,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB7FBDD2E050007F010069C5',
	'76C3EFD9DB7DBDD2E050007F010069C5',
	'Agent:create',
	'代理管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB7DBDD2E050007F010069C5/76C3EFD9DB7FBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/代理管理/代理管理新增',
	'fun',
	'457',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129729,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB80BDD2E050007F010069C5',
	'76C3EFD9DB7DBDD2E050007F010069C5',
	'Agent:update',
	'代理管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB7DBDD2E050007F010069C5/76C3EFD9DB80BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/代理管理/代理管理修改',
	'fun',
	'457',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129730,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB81BDD2E050007F010069C5',
	'76C3EFD9DB7DBDD2E050007F010069C5',
	'Agent:delete',
	'代理管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB7DBDD2E050007F010069C5/76C3EFD9DB81BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/代理管理/代理管理删除',
	'fun',
	'457',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129731,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB82BDD2E050007F010069C5',
	'76C3EFD9DB7DBDD2E050007F010069C5',
	'Agent:query',
	'代理管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB7DBDD2E050007F010069C5/76C3EFD9DB82BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/代理管理/代理管理查询',
	'fun',
	'457',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129732,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB83BDD2E050007F010069C5',
	'76C3EFD9DB70BDD2E050007F010069C5',
	'FlowTaskManagement',
	'流程任务维护',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB83BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务维护',
	'fun',
	'4802432',
	NULL,
	1,
	2,
	3129740,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB84BDD2E050007F010069C5',
	'76C3EFD9DB83BDD2E050007F010069C5',
	'FlowTaskManagement:*',
	'流程任务维护所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB83BDD2E050007F010069C5/76C3EFD9DB84BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务维护/流程任务维护所有操作',
	'fun',
	'4802432',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129741,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB85BDD2E050007F010069C5',
	'76C3EFD9DB83BDD2E050007F010069C5',
	'FlowTaskManagement:create',
	'流程任务维护新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB83BDD2E050007F010069C5/76C3EFD9DB85BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务维护/流程任务维护新增',
	'fun',
	'4802432',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129742,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB86BDD2E050007F010069C5',
	'76C3EFD9DB83BDD2E050007F010069C5',
	'FlowTaskManagement:update',
	'流程任务维护修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB83BDD2E050007F010069C5/76C3EFD9DB86BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务维护/流程任务维护修改',
	'fun',
	'4802432',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129743,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB87BDD2E050007F010069C5',
	'76C3EFD9DB83BDD2E050007F010069C5',
	'FlowTaskManagement:delete',
	'流程任务维护删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB83BDD2E050007F010069C5/76C3EFD9DB87BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务维护/流程任务维护删除',
	'fun',
	'4802432',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129744,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB88BDD2E050007F010069C5',
	'76C3EFD9DB83BDD2E050007F010069C5',
	'FlowTaskManagement:query',
	'流程任务维护查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB83BDD2E050007F010069C5/76C3EFD9DB88BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务维护/流程任务维护查询',
	'fun',
	'4802432',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129745,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB89BDD2E050007F010069C5',
	'76C3EFD9DB70BDD2E050007F010069C5',
	'taskInfoCount',
	'流程任务统计',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB89BDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务统计',
	'fun',
	'6C101A020198D474E050007F0100582A',
	NULL,
	1,
	12,
	3129753,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB8ABDD2E050007F010069C5',
	'76C3EFD9DB89BDD2E050007F010069C5',
	'taskInfoCount:*',
	'流程任务统计所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB89BDD2E050007F010069C5/76C3EFD9DB8ABDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务统计/流程任务统计所有操作',
	'fun',
	'6C101A020198D474E050007F0100582A',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129754,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB8BBDD2E050007F010069C5',
	'76C3EFD9DB89BDD2E050007F010069C5',
	'taskInfoCount:create',
	'流程任务统计新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB89BDD2E050007F010069C5/76C3EFD9DB8BBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务统计/流程任务统计新增',
	'fun',
	'6C101A020198D474E050007F0100582A',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129755,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB8CBDD2E050007F010069C5',
	'76C3EFD9DB89BDD2E050007F010069C5',
	'taskInfoCount:update',
	'流程任务统计修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB89BDD2E050007F010069C5/76C3EFD9DB8CBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务统计/流程任务统计修改',
	'fun',
	'6C101A020198D474E050007F0100582A',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129756,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB8DBDD2E050007F010069C5',
	'76C3EFD9DB89BDD2E050007F010069C5',
	'taskInfoCount:delete',
	'流程任务统计删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB89BDD2E050007F010069C5/76C3EFD9DB8DBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务统计/流程任务统计删除',
	'fun',
	'6C101A020198D474E050007F0100582A',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129757,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB8EBDD2E050007F010069C5',
	'76C3EFD9DB89BDD2E050007F010069C5',
	'taskInfoCount:query',
	'流程任务统计查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB89BDD2E050007F010069C5/76C3EFD9DB8EBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程任务统计/流程任务统计查询',
	'fun',
	'6C101A020198D474E050007F0100582A',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129758,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB8FBDD2E050007F010069C5',
	'76C3EFD9DB70BDD2E050007F010069C5',
	'WorkflowMonitor',
	'流程监控',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB70BDD2E050007F010069C5/76C3EFD9DB8FBDD2E050007F010069C5',
	'/系统功能/协同平台/流程任务管理/流程监控',
	'fun',
	'7B7DAE68C0F94888AC219388D53AC87C',
	NULL,
	0,
	3,
	3129760,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB90BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'WorkflowConfiguration',
	'工作流配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置',
	'fun',
	'1591B93C8792402CA206A64A71F419C3',
	NULL,
	1,
	3,
	3129762,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB91BDD2E050007F010069C5',
	'76C3EFD9DB90BDD2E050007F010069C5',
	'ProcDefinition',
	'流程管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB91BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程管理',
	'fun',
	'513179',
	NULL,
	1,
	1,
	3129770,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB92BDD2E050007F010069C5',
	'76C3EFD9DB91BDD2E050007F010069C5',
	'ProcDefinition:*',
	'流程管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB91BDD2E050007F010069C5/76C3EFD9DB92BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程管理/流程管理所有操作',
	'fun',
	'513179',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129771,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB93BDD2E050007F010069C5',
	'76C3EFD9DB91BDD2E050007F010069C5',
	'ProcDefinition:create',
	'流程管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB91BDD2E050007F010069C5/76C3EFD9DB93BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程管理/流程管理新增',
	'fun',
	'513179',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129772,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB94BDD2E050007F010069C5',
	'76C3EFD9DB91BDD2E050007F010069C5',
	'ProcDefinition:update',
	'流程管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB91BDD2E050007F010069C5/76C3EFD9DB94BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程管理/流程管理修改',
	'fun',
	'513179',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129773,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB95BDD2E050007F010069C5',
	'76C3EFD9DB91BDD2E050007F010069C5',
	'ProcDefinition:delete',
	'流程管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB91BDD2E050007F010069C5/76C3EFD9DB95BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程管理/流程管理删除',
	'fun',
	'513179',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129774,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB96BDD2E050007F010069C5',
	'76C3EFD9DB91BDD2E050007F010069C5',
	'ProcDefinition:query',
	'流程管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB91BDD2E050007F010069C5/76C3EFD9DB96BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程管理/流程管理查询',
	'fun',
	'513179',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129775,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB97BDD2E050007F010069C5',
	'76C3EFD9DB90BDD2E050007F010069C5',
	'ProcApprovaRuleConfig',
	'流程审批规则配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置',
	'fun',
	'6763',
	NULL,
	1,
	2,
	3129777,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB98BDD2E050007F010069C5',
	'76C3EFD9DB97BDD2E050007F010069C5',
	'ApprovalHandlerKind',
	'审批处理人类别',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB98BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批处理人类别',
	'fun',
	'1108',
	NULL,
	1,
	2,
	3129785,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB99BDD2E050007F010069C5',
	'76C3EFD9DB98BDD2E050007F010069C5',
	'ApprovalHandlerKind:*',
	'审批处理人类别所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB98BDD2E050007F010069C5/76C3EFD9DB99BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批处理人类别/审批处理人类别所有操作',
	'fun',
	'1108',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129786,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB9ABDD2E050007F010069C5',
	'76C3EFD9DB98BDD2E050007F010069C5',
	'ApprovalHandlerKind:create',
	'审批处理人类别新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB98BDD2E050007F010069C5/76C3EFD9DB9ABDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批处理人类别/审批处理人类别新增',
	'fun',
	'1108',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129787,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB9BBDD2E050007F010069C5',
	'76C3EFD9DB98BDD2E050007F010069C5',
	'ApprovalHandlerKind:update',
	'审批处理人类别修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB98BDD2E050007F010069C5/76C3EFD9DB9BBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批处理人类别/审批处理人类别修改',
	'fun',
	'1108',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129788,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB9CBDD2E050007F010069C5',
	'76C3EFD9DB98BDD2E050007F010069C5',
	'ApprovalHandlerKind:delete',
	'审批处理人类别删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB98BDD2E050007F010069C5/76C3EFD9DB9CBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批处理人类别/审批处理人类别删除',
	'fun',
	'1108',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129789,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB9DBDD2E050007F010069C5',
	'76C3EFD9DB98BDD2E050007F010069C5',
	'ApprovalHandlerKind:query',
	'审批处理人类别查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB98BDD2E050007F010069C5/76C3EFD9DB9DBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批处理人类别/审批处理人类别查询',
	'fun',
	'1108',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129790,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB9EBDD2E050007F010069C5',
	'76C3EFD9DB97BDD2E050007F010069C5',
	'ProcApprovalRuleConfigQuery',
	'流程审批规则配置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB9EBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询',
	'fun',
	'4803541',
	NULL,
	1,
	6,
	3129798,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DB9FBDD2E050007F010069C5',
	'76C3EFD9DB9EBDD2E050007F010069C5',
	'ProcApprovalRuleConfigQuery:*',
	'流程审批规则配置查询所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB9EBDD2E050007F010069C5/76C3EFD9DB9FBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询/流程审批规则配置查询所有操作',
	'fun',
	'4803541',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129799,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA0BDD2E050007F010069C5',
	'76C3EFD9DB9EBDD2E050007F010069C5',
	'ProcApprovalRuleConfigQuery:create',
	'流程审批规则配置查询新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB9EBDD2E050007F010069C5/76C3EFD9DBA0BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询/流程审批规则配置查询新增',
	'fun',
	'4803541',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129800,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA1BDD2E050007F010069C5',
	'76C3EFD9DB9EBDD2E050007F010069C5',
	'ProcApprovalRuleConfigQuery:update',
	'流程审批规则配置查询修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB9EBDD2E050007F010069C5/76C3EFD9DBA1BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询/流程审批规则配置查询修改',
	'fun',
	'4803541',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129801,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA2BDD2E050007F010069C5',
	'76C3EFD9DB9EBDD2E050007F010069C5',
	'ProcApprovalRuleConfigQuery:delete',
	'流程审批规则配置查询删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB9EBDD2E050007F010069C5/76C3EFD9DBA2BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询/流程审批规则配置查询删除',
	'fun',
	'4803541',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129802,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA3BDD2E050007F010069C5',
	'76C3EFD9DB9EBDD2E050007F010069C5',
	'ProcApprovalRuleConfigQuery:query',
	'流程审批规则配置查询查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DB9EBDD2E050007F010069C5/76C3EFD9DBA3BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置查询/流程审批规则配置查询查询',
	'fun',
	'4803541',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129803,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA4BDD2E050007F010069C5',
	'76C3EFD9DB97BDD2E050007F010069C5',
	'ApprovalElement',
	'审批要素配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBA4BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批要素配置',
	'fun',
	'6764',
	NULL,
	1,
	1,
	3129811,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA5BDD2E050007F010069C5',
	'76C3EFD9DBA4BDD2E050007F010069C5',
	'ApprovalElement:*',
	'审批要素配置所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBA4BDD2E050007F010069C5/76C3EFD9DBA5BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批要素配置/审批要素配置所有操作',
	'fun',
	'6764',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129812,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA6BDD2E050007F010069C5',
	'76C3EFD9DBA4BDD2E050007F010069C5',
	'ApprovalElement:create',
	'审批要素配置新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBA4BDD2E050007F010069C5/76C3EFD9DBA6BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批要素配置/审批要素配置新增',
	'fun',
	'6764',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129813,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA7BDD2E050007F010069C5',
	'76C3EFD9DBA4BDD2E050007F010069C5',
	'ApprovalElement:update',
	'审批要素配置修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBA4BDD2E050007F010069C5/76C3EFD9DBA7BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批要素配置/审批要素配置修改',
	'fun',
	'6764',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129814,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA8BDD2E050007F010069C5',
	'76C3EFD9DBA4BDD2E050007F010069C5',
	'ApprovalElement:delete',
	'审批要素配置删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBA4BDD2E050007F010069C5/76C3EFD9DBA8BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批要素配置/审批要素配置删除',
	'fun',
	'6764',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129815,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBA9BDD2E050007F010069C5',
	'76C3EFD9DBA4BDD2E050007F010069C5',
	'ApprovalElement:query',
	'审批要素配置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBA4BDD2E050007F010069C5/76C3EFD9DBA9BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/审批要素配置/审批要素配置查询',
	'fun',
	'6764',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129816,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBAABDD2E050007F010069C5',
	'76C3EFD9DB97BDD2E050007F010069C5',
	'ProcApprovalElementConfig',
	'流程审批要素配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBAABDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批要素配置',
	'fun',
	'6765',
	NULL,
	1,
	3,
	3129824,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBABBDD2E050007F010069C5',
	'76C3EFD9DBAABDD2E050007F010069C5',
	'ProcApprovalElementConfig:*',
	'流程审批要素配置所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBAABDD2E050007F010069C5/76C3EFD9DBABBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批要素配置/流程审批要素配置所有操作',
	'fun',
	'6765',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129825,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBACBDD2E050007F010069C5',
	'76C3EFD9DBAABDD2E050007F010069C5',
	'ProcApprovalElementConfig:create',
	'流程审批要素配置新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBAABDD2E050007F010069C5/76C3EFD9DBACBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批要素配置/流程审批要素配置新增',
	'fun',
	'6765',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129826,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBADBDD2E050007F010069C5',
	'76C3EFD9DBAABDD2E050007F010069C5',
	'ProcApprovalElementConfig:update',
	'流程审批要素配置修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBAABDD2E050007F010069C5/76C3EFD9DBADBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批要素配置/流程审批要素配置修改',
	'fun',
	'6765',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129827,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBAEBDD2E050007F010069C5',
	'76C3EFD9DBAABDD2E050007F010069C5',
	'ProcApprovalElementConfig:delete',
	'流程审批要素配置删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBAABDD2E050007F010069C5/76C3EFD9DBAEBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批要素配置/流程审批要素配置删除',
	'fun',
	'6765',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129828,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBAFBDD2E050007F010069C5',
	'76C3EFD9DBAABDD2E050007F010069C5',
	'ProcApprovalElementConfig:query',
	'流程审批要素配置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBAABDD2E050007F010069C5/76C3EFD9DBAFBDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批要素配置/流程审批要素配置查询',
	'fun',
	'6765',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129829,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB0BDD2E050007F010069C5',
	'76C3EFD9DB97BDD2E050007F010069C5',
	'ProcApprovalRuleConfig',
	'流程审批规则配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBB0BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置',
	'fun',
	'6766',
	NULL,
	1,
	4,
	3129837,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB1BDD2E050007F010069C5',
	'76C3EFD9DBB0BDD2E050007F010069C5',
	'ProcApprovalRuleConfig:*',
	'流程审批规则配置所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBB0BDD2E050007F010069C5/76C3EFD9DBB1BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置/流程审批规则配置所有操作',
	'fun',
	'6766',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129838,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB2BDD2E050007F010069C5',
	'76C3EFD9DBB0BDD2E050007F010069C5',
	'ProcApprovalRuleConfig:create',
	'流程审批规则配置新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBB0BDD2E050007F010069C5/76C3EFD9DBB2BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置/流程审批规则配置新增',
	'fun',
	'6766',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129839,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB3BDD2E050007F010069C5',
	'76C3EFD9DBB0BDD2E050007F010069C5',
	'ProcApprovalRuleConfig:update',
	'流程审批规则配置修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBB0BDD2E050007F010069C5/76C3EFD9DBB3BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置/流程审批规则配置修改',
	'fun',
	'6766',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129840,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB4BDD2E050007F010069C5',
	'76C3EFD9DBB0BDD2E050007F010069C5',
	'ProcApprovalRuleConfig:delete',
	'流程审批规则配置删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBB0BDD2E050007F010069C5/76C3EFD9DBB4BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置/流程审批规则配置删除',
	'fun',
	'6766',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129841,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB5BDD2E050007F010069C5',
	'76C3EFD9DBB0BDD2E050007F010069C5',
	'ProcApprovalRuleConfig:query',
	'流程审批规则配置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DB90BDD2E050007F010069C5/76C3EFD9DB97BDD2E050007F010069C5/76C3EFD9DBB0BDD2E050007F010069C5/76C3EFD9DBB5BDD2E050007F010069C5',
	'/系统功能/协同平台/工作流配置/流程审批规则配置/流程审批规则配置/流程审批规则配置查询',
	'fun',
	'6766',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129842,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'SysConfiguration',
	'系统配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置',
	'fun',
	'1656',
	NULL,
	1,
	1,
	3129844,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'SysParameter',
	'系统参数',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统参数',
	'fun',
	'1289',
	NULL,
	1,
	1,
	3129852,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB8BDD2E050007F010069C5',
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'SysParameter:*',
	'系统参数所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5/76C3EFD9DBB8BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统参数/系统参数所有操作',
	'fun',
	'1289',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3406344,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBB9BDD2E050007F010069C5',
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'SysParameter:create',
	'系统参数新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5/76C3EFD9DBB9BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统参数/系统参数新增',
	'fun',
	'1289',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129854,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBBABDD2E050007F010069C5',
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'SysParameter:update',
	'系统参数修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5/76C3EFD9DBBABDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统参数/系统参数修改',
	'fun',
	'1289',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129855,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBBBBDD2E050007F010069C5',
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'SysParameter:delete',
	'系统参数删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5/76C3EFD9DBBBBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统参数/系统参数删除',
	'fun',
	'1289',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129856,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBBCBDD2E050007F010069C5',
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'SysParameter:query',
	'系统参数查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5/76C3EFD9DBBCBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统参数/系统参数查询',
	'fun',
	'1289',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129857,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBBDBDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'ApprovalRejectedReason',
	'审批驳回理由',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBBDBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/审批驳回理由',
	'fun',
	'130B44388AF142A2A2FEB8227ABB8CAD',
	NULL,
	0,
	6,
	3129865,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBBEBDD2E050007F010069C5',
	'76C3EFD9DBBDBDD2E050007F010069C5',
	'ApprovalRejectedReason:*',
	'审批驳回理由所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBBDBDD2E050007F010069C5/76C3EFD9DBBEBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/审批驳回理由/审批驳回理由所有操作',
	'fun',
	'130B44388AF142A2A2FEB8227ABB8CAD',
	'C69E9314B8944B459B9C408A11C829D6',
	0,
	1,
	3129866,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBBFBDD2E050007F010069C5',
	'76C3EFD9DBBDBDD2E050007F010069C5',
	'ApprovalRejectedReason:create',
	'审批驳回理由新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBBDBDD2E050007F010069C5/76C3EFD9DBBFBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/审批驳回理由/审批驳回理由新增',
	'fun',
	'130B44388AF142A2A2FEB8227ABB8CAD',
	'E23D0E0EA7584311B048EED187DC1DA3',
	0,
	2,
	3129867,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC0BDD2E050007F010069C5',
	'76C3EFD9DBBDBDD2E050007F010069C5',
	'ApprovalRejectedReason:update',
	'审批驳回理由修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBBDBDD2E050007F010069C5/76C3EFD9DBC0BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/审批驳回理由/审批驳回理由修改',
	'fun',
	'130B44388AF142A2A2FEB8227ABB8CAD',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	0,
	3,
	3129868,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC1BDD2E050007F010069C5',
	'76C3EFD9DBBDBDD2E050007F010069C5',
	'ApprovalRejectedReason:delete',
	'审批驳回理由删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBBDBDD2E050007F010069C5/76C3EFD9DBC1BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/审批驳回理由/审批驳回理由删除',
	'fun',
	'130B44388AF142A2A2FEB8227ABB8CAD',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	0,
	4,
	3129869,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC2BDD2E050007F010069C5',
	'76C3EFD9DBBDBDD2E050007F010069C5',
	'ApprovalRejectedReason:query',
	'审批驳回理由查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBBDBDD2E050007F010069C5/76C3EFD9DBC2BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/审批驳回理由/审批驳回理由查询',
	'fun',
	'130B44388AF142A2A2FEB8227ABB8CAD',
	'A0DAC625FBCF48F49AB9039BC746F196',
	0,
	6,
	3129870,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC3BDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'CodeBuildRule',
	'单据编号规则',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC3BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/单据编号规则',
	'fun',
	'1326',
	NULL,
	1,
	2,
	3129878,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC4BDD2E050007F010069C5',
	'76C3EFD9DBC3BDD2E050007F010069C5',
	'CodeBuildRule:*',
	'单据编号规则所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC3BDD2E050007F010069C5/76C3EFD9DBC4BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/单据编号规则/单据编号规则所有操作',
	'fun',
	'1326',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129879,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC5BDD2E050007F010069C5',
	'76C3EFD9DBC3BDD2E050007F010069C5',
	'CodeBuildRule:create',
	'单据编号规则新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC3BDD2E050007F010069C5/76C3EFD9DBC5BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/单据编号规则/单据编号规则新增',
	'fun',
	'1326',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129880,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC6BDD2E050007F010069C5',
	'76C3EFD9DBC3BDD2E050007F010069C5',
	'CodeBuildRule:update',
	'单据编号规则修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC3BDD2E050007F010069C5/76C3EFD9DBC6BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/单据编号规则/单据编号规则修改',
	'fun',
	'1326',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129881,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC7BDD2E050007F010069C5',
	'76C3EFD9DBC3BDD2E050007F010069C5',
	'CodeBuildRule:delete',
	'单据编号规则删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC3BDD2E050007F010069C5/76C3EFD9DBC7BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/单据编号规则/单据编号规则删除',
	'fun',
	'1326',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129882,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC8BDD2E050007F010069C5',
	'76C3EFD9DBC3BDD2E050007F010069C5',
	'CodeBuildRule:query',
	'单据编号规则查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC3BDD2E050007F010069C5/76C3EFD9DBC8BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/单据编号规则/单据编号规则查询',
	'fun',
	'1326',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129883,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBC9BDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'SysDictionary',
	'系统字典',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC9BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统字典',
	'fun',
	'1366',
	NULL,
	1,
	3,
	3129891,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBCABDD2E050007F010069C5',
	'76C3EFD9DBC9BDD2E050007F010069C5',
	'SysDictionary:*',
	'系统字典所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC9BDD2E050007F010069C5/76C3EFD9DBCABDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统字典/系统字典所有操作',
	'fun',
	'1366',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129892,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBCBBDD2E050007F010069C5',
	'76C3EFD9DBC9BDD2E050007F010069C5',
	'SysDictionary:create',
	'系统字典新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC9BDD2E050007F010069C5/76C3EFD9DBCBBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统字典/系统字典新增',
	'fun',
	'1366',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129893,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBCCBDD2E050007F010069C5',
	'76C3EFD9DBC9BDD2E050007F010069C5',
	'SysDictionary:update',
	'系统字典修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC9BDD2E050007F010069C5/76C3EFD9DBCCBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统字典/系统字典修改',
	'fun',
	'1366',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129894,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBCDBDD2E050007F010069C5',
	'76C3EFD9DBC9BDD2E050007F010069C5',
	'SysDictionary:delete',
	'系统字典删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC9BDD2E050007F010069C5/76C3EFD9DBCDBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统字典/系统字典删除',
	'fun',
	'1366',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129895,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBCEBDD2E050007F010069C5',
	'76C3EFD9DBC9BDD2E050007F010069C5',
	'SysDictionary:query',
	'系统字典查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBC9BDD2E050007F010069C5/76C3EFD9DBCEBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/系统字典/系统字典查询',
	'fun',
	'1366',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129896,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBCFBDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'MessageKind',
	'消息发送类别',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBCFBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息发送类别',
	'fun',
	'29030502',
	NULL,
	0,
	5,
	3129904,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD0BDD2E050007F010069C5',
	'76C3EFD9DBCFBDD2E050007F010069C5',
	'MessageKind:*',
	'消息发送类别所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBCFBDD2E050007F010069C5/76C3EFD9DBD0BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息发送类别/消息发送类别所有操作',
	'fun',
	'29030502',
	'C69E9314B8944B459B9C408A11C829D6',
	0,
	1,
	3129905,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD1BDD2E050007F010069C5',
	'76C3EFD9DBCFBDD2E050007F010069C5',
	'MessageKind:create',
	'消息发送类别新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBCFBDD2E050007F010069C5/76C3EFD9DBD1BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息发送类别/消息发送类别新增',
	'fun',
	'29030502',
	'E23D0E0EA7584311B048EED187DC1DA3',
	0,
	2,
	3129906,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD2BDD2E050007F010069C5',
	'76C3EFD9DBCFBDD2E050007F010069C5',
	'MessageKind:update',
	'消息发送类别修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBCFBDD2E050007F010069C5/76C3EFD9DBD2BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息发送类别/消息发送类别修改',
	'fun',
	'29030502',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	0,
	3,
	3129907,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD3BDD2E050007F010069C5',
	'76C3EFD9DBCFBDD2E050007F010069C5',
	'MessageKind:delete',
	'消息发送类别删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBCFBDD2E050007F010069C5/76C3EFD9DBD3BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息发送类别/消息发送类别删除',
	'fun',
	'29030502',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	0,
	4,
	3129908,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD4BDD2E050007F010069C5',
	'76C3EFD9DBCFBDD2E050007F010069C5',
	'MessageKind:query',
	'消息发送类别查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBCFBDD2E050007F010069C5/76C3EFD9DBD4BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息发送类别/消息发送类别查询',
	'fun',
	'29030502',
	'A0DAC625FBCF48F49AB9039BC746F196',
	0,
	6,
	3129909,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD5BDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'Orgfun',
	'组织机构函数定义',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBD5BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/组织机构函数定义',
	'fun',
	'411F3C501F2F48DB99F339993D9DDCB7',
	NULL,
	1,
	8,
	3129917,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD6BDD2E050007F010069C5',
	'76C3EFD9DBD5BDD2E050007F010069C5',
	'Orgfun:*',
	'组织机构函数定义所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBD5BDD2E050007F010069C5/76C3EFD9DBD6BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/组织机构函数定义/组织机构函数定义所有操作',
	'fun',
	'411F3C501F2F48DB99F339993D9DDCB7',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129918,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD7BDD2E050007F010069C5',
	'76C3EFD9DBD5BDD2E050007F010069C5',
	'Orgfun:create',
	'组织机构函数定义新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBD5BDD2E050007F010069C5/76C3EFD9DBD7BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/组织机构函数定义/组织机构函数定义新增',
	'fun',
	'411F3C501F2F48DB99F339993D9DDCB7',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129919,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD8BDD2E050007F010069C5',
	'76C3EFD9DBD5BDD2E050007F010069C5',
	'Orgfun:update',
	'组织机构函数定义修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBD5BDD2E050007F010069C5/76C3EFD9DBD8BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/组织机构函数定义/组织机构函数定义修改',
	'fun',
	'411F3C501F2F48DB99F339993D9DDCB7',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129920,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBD9BDD2E050007F010069C5',
	'76C3EFD9DBD5BDD2E050007F010069C5',
	'Orgfun:delete',
	'组织机构函数定义删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBD5BDD2E050007F010069C5/76C3EFD9DBD9BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/组织机构函数定义/组织机构函数定义删除',
	'fun',
	'411F3C501F2F48DB99F339993D9DDCB7',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129921,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBDABDD2E050007F010069C5',
	'76C3EFD9DBD5BDD2E050007F010069C5',
	'Orgfun:query',
	'组织机构函数定义查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBD5BDD2E050007F010069C5/76C3EFD9DBDABDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/组织机构函数定义/组织机构函数定义查询',
	'fun',
	'411F3C501F2F48DB99F339993D9DDCB7',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129922,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBDBBDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'AttachmentConfiguration',
	'附件配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBDBBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/附件配置',
	'fun',
	'4803613',
	NULL,
	1,
	4,
	3129930,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBDCBDD2E050007F010069C5',
	'76C3EFD9DBDBBDD2E050007F010069C5',
	'AttachmentConfiguration:*',
	'附件配置所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBDBBDD2E050007F010069C5/76C3EFD9DBDCBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/附件配置/附件配置所有操作',
	'fun',
	'4803613',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129931,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBDDBDD2E050007F010069C5',
	'76C3EFD9DBDBBDD2E050007F010069C5',
	'AttachmentConfiguration:create',
	'附件配置新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBDBBDD2E050007F010069C5/76C3EFD9DBDDBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/附件配置/附件配置新增',
	'fun',
	'4803613',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129932,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBDEBDD2E050007F010069C5',
	'76C3EFD9DBDBBDD2E050007F010069C5',
	'AttachmentConfiguration:update',
	'附件配置修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBDBBDD2E050007F010069C5/76C3EFD9DBDEBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/附件配置/附件配置修改',
	'fun',
	'4803613',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129933,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBDFBDD2E050007F010069C5',
	'76C3EFD9DBDBBDD2E050007F010069C5',
	'AttachmentConfiguration:delete',
	'附件配置删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBDBBDD2E050007F010069C5/76C3EFD9DBDFBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/附件配置/附件配置删除',
	'fun',
	'4803613',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129934,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE0BDD2E050007F010069C5',
	'76C3EFD9DBDBBDD2E050007F010069C5',
	'AttachmentConfiguration:query',
	'附件配置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBDBBDD2E050007F010069C5/76C3EFD9DBE0BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/附件配置/附件配置查询',
	'fun',
	'4803613',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129935,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE1BDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'I18nProperties',
	'国际化资源维护',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE1BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/国际化资源维护',
	'fun',
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	NULL,
	1,
	7,
	3129943,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE2BDD2E050007F010069C5',
	'76C3EFD9DBE1BDD2E050007F010069C5',
	'I18nProperties:*',
	'国际化资源维护所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE1BDD2E050007F010069C5/76C3EFD9DBE2BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/国际化资源维护/国际化资源维护所有操作',
	'fun',
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129944,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE3BDD2E050007F010069C5',
	'76C3EFD9DBE1BDD2E050007F010069C5',
	'I18nProperties:create',
	'国际化资源维护新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE1BDD2E050007F010069C5/76C3EFD9DBE3BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/国际化资源维护/国际化资源维护新增',
	'fun',
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129945,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE4BDD2E050007F010069C5',
	'76C3EFD9DBE1BDD2E050007F010069C5',
	'I18nProperties:update',
	'国际化资源维护修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE1BDD2E050007F010069C5/76C3EFD9DBE4BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/国际化资源维护/国际化资源维护修改',
	'fun',
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129946,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE5BDD2E050007F010069C5',
	'76C3EFD9DBE1BDD2E050007F010069C5',
	'I18nProperties:delete',
	'国际化资源维护删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE1BDD2E050007F010069C5/76C3EFD9DBE5BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/国际化资源维护/国际化资源维护删除',
	'fun',
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129947,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE6BDD2E050007F010069C5',
	'76C3EFD9DBE1BDD2E050007F010069C5',
	'I18nProperties:query',
	'国际化资源维护查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE1BDD2E050007F010069C5/76C3EFD9DBE6BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/国际化资源维护/国际化资源维护查询',
	'fun',
	'856477CAA7F64B0FB79DCBF24ED47CBE',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129948,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE7BDD2E050007F010069C5',
	'76C3EFD9DBB6BDD2E050007F010069C5',
	'MessageRemind',
	'消息提醒配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE7BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息提醒配置',
	'fun',
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	NULL,
	1,
	9,
	3129956,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE8BDD2E050007F010069C5',
	'76C3EFD9DBE7BDD2E050007F010069C5',
	'MessageRemind:*',
	'消息提醒配置所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE7BDD2E050007F010069C5/76C3EFD9DBE8BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息提醒配置/消息提醒配置所有操作',
	'fun',
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129957,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBE9BDD2E050007F010069C5',
	'76C3EFD9DBE7BDD2E050007F010069C5',
	'MessageRemind:create',
	'消息提醒配置新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE7BDD2E050007F010069C5/76C3EFD9DBE9BDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息提醒配置/消息提醒配置新增',
	'fun',
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129958,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBEABDD2E050007F010069C5',
	'76C3EFD9DBE7BDD2E050007F010069C5',
	'MessageRemind:update',
	'消息提醒配置修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE7BDD2E050007F010069C5/76C3EFD9DBEABDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息提醒配置/消息提醒配置修改',
	'fun',
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129959,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBEBBDD2E050007F010069C5',
	'76C3EFD9DBE7BDD2E050007F010069C5',
	'MessageRemind:delete',
	'消息提醒配置删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE7BDD2E050007F010069C5/76C3EFD9DBEBBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息提醒配置/消息提醒配置删除',
	'fun',
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129960,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBECBDD2E050007F010069C5',
	'76C3EFD9DBE7BDD2E050007F010069C5',
	'MessageRemind:query',
	'消息提醒配置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBE7BDD2E050007F010069C5/76C3EFD9DBECBDD2E050007F010069C5',
	'/系统功能/协同平台/系统配置/消息提醒配置/消息提醒配置查询',
	'fun',
	'F3D38CC6FB5049F99C7F6E832E3EC57A',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129961,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBEDBDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'OPM',
	'组织权限',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限',
	'fun',
	'446',
	NULL,
	1,
	2,
	3129963,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'76C3EFD9DBEDBDD2E050007F010069C5',
	'BizManagementFolder',
	'业务管理权限',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限',
	'fun',
	'30D672692E9E48E295796F3ADD96AC65',
	NULL,
	1,
	3,
	3129965,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBEFBDD2E050007F010069C5',
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'AllocateSubordination',
	'分配下属',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBEFBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配下属',
	'fun',
	'160597161',
	NULL,
	1,
	4,
	3129973,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF0BDD2E050007F010069C5',
	'76C3EFD9DBEFBDD2E050007F010069C5',
	'AllocateSubordination:*',
	'分配下属所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBEFBDD2E050007F010069C5/76C3EFD9DBF0BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配下属/分配下属所有操作',
	'fun',
	'160597161',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129974,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF1BDD2E050007F010069C5',
	'76C3EFD9DBEFBDD2E050007F010069C5',
	'AllocateSubordination:create',
	'分配下属新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBEFBDD2E050007F010069C5/76C3EFD9DBF1BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配下属/分配下属新增',
	'fun',
	'160597161',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129975,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF2BDD2E050007F010069C5',
	'76C3EFD9DBEFBDD2E050007F010069C5',
	'AllocateSubordination:update',
	'分配下属修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBEFBDD2E050007F010069C5/76C3EFD9DBF2BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配下属/分配下属修改',
	'fun',
	'160597161',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129976,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF3BDD2E050007F010069C5',
	'76C3EFD9DBEFBDD2E050007F010069C5',
	'AllocateSubordination:delete',
	'分配下属删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBEFBDD2E050007F010069C5/76C3EFD9DBF3BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配下属/分配下属删除',
	'fun',
	'160597161',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129977,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF4BDD2E050007F010069C5',
	'76C3EFD9DBEFBDD2E050007F010069C5',
	'AllocateSubordination:query',
	'分配下属查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBEFBDD2E050007F010069C5/76C3EFD9DBF4BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配下属/分配下属查询',
	'fun',
	'160597161',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129978,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF5BDD2E050007F010069C5',
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'ManagementType',
	'业务权限管理类别',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBF5BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/业务权限管理类别',
	'fun',
	'456',
	NULL,
	1,
	2,
	3129986,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF6BDD2E050007F010069C5',
	'76C3EFD9DBF5BDD2E050007F010069C5',
	'ManagementType:*',
	'业务权限管理类别所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBF5BDD2E050007F010069C5/76C3EFD9DBF6BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/业务权限管理类别/业务权限管理类别所有操作',
	'fun',
	'456',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3129987,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF7BDD2E050007F010069C5',
	'76C3EFD9DBF5BDD2E050007F010069C5',
	'ManagementType:create',
	'业务权限管理类别新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBF5BDD2E050007F010069C5/76C3EFD9DBF7BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/业务权限管理类别/业务权限管理类别新增',
	'fun',
	'456',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3129988,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF8BDD2E050007F010069C5',
	'76C3EFD9DBF5BDD2E050007F010069C5',
	'ManagementType:update',
	'业务权限管理类别修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBF5BDD2E050007F010069C5/76C3EFD9DBF8BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/业务权限管理类别/业务权限管理类别修改',
	'fun',
	'456',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3129989,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBF9BDD2E050007F010069C5',
	'76C3EFD9DBF5BDD2E050007F010069C5',
	'ManagementType:delete',
	'业务权限管理类别删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBF5BDD2E050007F010069C5/76C3EFD9DBF9BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/业务权限管理类别/业务权限管理类别删除',
	'fun',
	'456',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3129990,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBFABDD2E050007F010069C5',
	'76C3EFD9DBF5BDD2E050007F010069C5',
	'ManagementType:query',
	'业务权限管理类别查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBF5BDD2E050007F010069C5/76C3EFD9DBFABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/业务权限管理类别/业务权限管理类别查询',
	'fun',
	'456',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3129991,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBFBBDD2E050007F010069C5',
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'ManagementQueryForManager',
	'查询管理者',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBFBBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询管理者',
	'fun',
	'4803288',
	NULL,
	1,
	5,
	3129999,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBFCBDD2E050007F010069C5',
	'76C3EFD9DBFBBDD2E050007F010069C5',
	'ManagementQueryForManager:*',
	'查询管理者所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBFBBDD2E050007F010069C5/76C3EFD9DBFCBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询管理者/查询管理者所有操作',
	'fun',
	'4803288',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130000,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBFDBDD2E050007F010069C5',
	'76C3EFD9DBFBBDD2E050007F010069C5',
	'ManagementQueryForManager:create',
	'查询管理者新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBFBBDD2E050007F010069C5/76C3EFD9DBFDBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询管理者/查询管理者新增',
	'fun',
	'4803288',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130001,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBFEBDD2E050007F010069C5',
	'76C3EFD9DBFBBDD2E050007F010069C5',
	'ManagementQueryForManager:update',
	'查询管理者修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBFBBDD2E050007F010069C5/76C3EFD9DBFEBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询管理者/查询管理者修改',
	'fun',
	'4803288',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130002,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DBFFBDD2E050007F010069C5',
	'76C3EFD9DBFBBDD2E050007F010069C5',
	'ManagementQueryForManager:delete',
	'查询管理者删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBFBBDD2E050007F010069C5/76C3EFD9DBFFBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询管理者/查询管理者删除',
	'fun',
	'4803288',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130003,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC00BDD2E050007F010069C5',
	'76C3EFD9DBFBBDD2E050007F010069C5',
	'ManagementQueryForManager:query',
	'查询管理者查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DBFBBDD2E050007F010069C5/76C3EFD9DC00BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询管理者/查询管理者查询',
	'fun',
	'4803288',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130004,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC01BDD2E050007F010069C5',
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'ManagementQueryForSubordination',
	'查询下属',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC01BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询下属',
	'fun',
	'4803290',
	NULL,
	1,
	6,
	3130012,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC02BDD2E050007F010069C5',
	'76C3EFD9DC01BDD2E050007F010069C5',
	'ManagementQueryForSubordination:*',
	'查询下属所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC01BDD2E050007F010069C5/76C3EFD9DC02BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询下属/查询下属所有操作',
	'fun',
	'4803290',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130013,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC03BDD2E050007F010069C5',
	'76C3EFD9DC01BDD2E050007F010069C5',
	'ManagementQueryForSubordination:create',
	'查询下属新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC01BDD2E050007F010069C5/76C3EFD9DC03BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询下属/查询下属新增',
	'fun',
	'4803290',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130014,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC04BDD2E050007F010069C5',
	'76C3EFD9DC01BDD2E050007F010069C5',
	'ManagementQueryForSubordination:update',
	'查询下属修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC01BDD2E050007F010069C5/76C3EFD9DC04BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询下属/查询下属修改',
	'fun',
	'4803290',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130015,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC05BDD2E050007F010069C5',
	'76C3EFD9DC01BDD2E050007F010069C5',
	'ManagementQueryForSubordination:delete',
	'查询下属删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC01BDD2E050007F010069C5/76C3EFD9DC05BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询下属/查询下属删除',
	'fun',
	'4803290',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130016,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC06BDD2E050007F010069C5',
	'76C3EFD9DC01BDD2E050007F010069C5',
	'ManagementQueryForSubordination:query',
	'查询下属查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC01BDD2E050007F010069C5/76C3EFD9DC06BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/查询下属/查询下属查询',
	'fun',
	'4803290',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130017,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC07BDD2E050007F010069C5',
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'BaseManagementType',
	'基础管理权限类别',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC07BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/基础管理权限类别',
	'fun',
	'661',
	NULL,
	1,
	1,
	3130025,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC08BDD2E050007F010069C5',
	'76C3EFD9DC07BDD2E050007F010069C5',
	'BaseManagementType:*',
	'基础管理权限类别所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC07BDD2E050007F010069C5/76C3EFD9DC08BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/基础管理权限类别/基础管理权限类别所有操作',
	'fun',
	'661',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130026,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC09BDD2E050007F010069C5',
	'76C3EFD9DC07BDD2E050007F010069C5',
	'BaseManagementType:create',
	'基础管理权限类别新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC07BDD2E050007F010069C5/76C3EFD9DC09BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/基础管理权限类别/基础管理权限类别新增',
	'fun',
	'661',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130027,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC0ABDD2E050007F010069C5',
	'76C3EFD9DC07BDD2E050007F010069C5',
	'BaseManagementType:update',
	'基础管理权限类别修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC07BDD2E050007F010069C5/76C3EFD9DC0ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/基础管理权限类别/基础管理权限类别修改',
	'fun',
	'661',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130028,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC0BBDD2E050007F010069C5',
	'76C3EFD9DC07BDD2E050007F010069C5',
	'BaseManagementType:delete',
	'基础管理权限类别删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC07BDD2E050007F010069C5/76C3EFD9DC0BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/基础管理权限类别/基础管理权限类别删除',
	'fun',
	'661',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130029,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC0CBDD2E050007F010069C5',
	'76C3EFD9DC07BDD2E050007F010069C5',
	'BaseManagementType:query',
	'基础管理权限类别查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC07BDD2E050007F010069C5/76C3EFD9DC0CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/基础管理权限类别/基础管理权限类别查询',
	'fun',
	'661',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130030,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC0DBDD2E050007F010069C5',
	'76C3EFD9DBEEBDD2E050007F010069C5',
	'AllocateManager',
	'分配管理者',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC0DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配管理者',
	'fun',
	'686',
	NULL,
	1,
	3,
	3130038,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC0EBDD2E050007F010069C5',
	'76C3EFD9DC0DBDD2E050007F010069C5',
	'AllocateManager:*',
	'分配管理者所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC0DBDD2E050007F010069C5/76C3EFD9DC0EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配管理者/分配管理者所有操作',
	'fun',
	'686',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130039,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC0FBDD2E050007F010069C5',
	'76C3EFD9DC0DBDD2E050007F010069C5',
	'AllocateManager:create',
	'分配管理者新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC0DBDD2E050007F010069C5/76C3EFD9DC0FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配管理者/分配管理者新增',
	'fun',
	'686',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130040,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC10BDD2E050007F010069C5',
	'76C3EFD9DC0DBDD2E050007F010069C5',
	'AllocateManager:update',
	'分配管理者修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC0DBDD2E050007F010069C5/76C3EFD9DC10BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配管理者/分配管理者修改',
	'fun',
	'686',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130041,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC11BDD2E050007F010069C5',
	'76C3EFD9DC0DBDD2E050007F010069C5',
	'AllocateManager:delete',
	'分配管理者删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC0DBDD2E050007F010069C5/76C3EFD9DC11BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配管理者/分配管理者删除',
	'fun',
	'686',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130042,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC12BDD2E050007F010069C5',
	'76C3EFD9DC0DBDD2E050007F010069C5',
	'AllocateManager:query',
	'分配管理者查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DBEEBDD2E050007F010069C5/76C3EFD9DC0DBDD2E050007F010069C5/76C3EFD9DC12BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/业务管理权限/分配管理者/分配管理者查询',
	'fun',
	'686',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130043,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC13BDD2E050007F010069C5',
	'76C3EFD9DBEDBDD2E050007F010069C5',
	'FunctionPermission',
	'功能权限',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限',
	'fun',
	'32B4DC6736734C5985D5C7E4A13033BF',
	NULL,
	1,
	2,
	3130045,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC14BDD2E050007F010069C5',
	'76C3EFD9DC13BDD2E050007F010069C5',
	'Func',
	'功能管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC14BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/功能管理',
	'fun',
	'453',
	NULL,
	1,
	2,
	3130053,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC15BDD2E050007F010069C5',
	'76C3EFD9DC14BDD2E050007F010069C5',
	'Func:*',
	'功能管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC14BDD2E050007F010069C5/76C3EFD9DC15BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/功能管理/功能管理所有操作',
	'fun',
	'453',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130054,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC16BDD2E050007F010069C5',
	'76C3EFD9DC14BDD2E050007F010069C5',
	'Func:create',
	'功能管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC14BDD2E050007F010069C5/76C3EFD9DC16BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/功能管理/功能管理新增',
	'fun',
	'453',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130055,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC17BDD2E050007F010069C5',
	'76C3EFD9DC14BDD2E050007F010069C5',
	'Func:update',
	'功能管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC14BDD2E050007F010069C5/76C3EFD9DC17BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/功能管理/功能管理修改',
	'fun',
	'453',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130056,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC18BDD2E050007F010069C5',
	'76C3EFD9DC14BDD2E050007F010069C5',
	'Func:delete',
	'功能管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC14BDD2E050007F010069C5/76C3EFD9DC18BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/功能管理/功能管理删除',
	'fun',
	'453',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130057,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC19BDD2E050007F010069C5',
	'76C3EFD9DC14BDD2E050007F010069C5',
	'Func:query',
	'功能管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC14BDD2E050007F010069C5/76C3EFD9DC19BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/功能管理/功能管理查询',
	'fun',
	'453',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130058,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC1ABDD2E050007F010069C5',
	'76C3EFD9DC13BDD2E050007F010069C5',
	'Role',
	'角色管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC1ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/角色管理',
	'fun',
	'454',
	NULL,
	1,
	3,
	3130066,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC1BBDD2E050007F010069C5',
	'76C3EFD9DC1ABDD2E050007F010069C5',
	'Role:*',
	'角色管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC1ABDD2E050007F010069C5/76C3EFD9DC1BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/角色管理/角色管理所有操作',
	'fun',
	'454',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130067,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC1CBDD2E050007F010069C5',
	'76C3EFD9DC1ABDD2E050007F010069C5',
	'Role:create',
	'角色管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC1ABDD2E050007F010069C5/76C3EFD9DC1CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/角色管理/角色管理新增',
	'fun',
	'454',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130068,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC1DBDD2E050007F010069C5',
	'76C3EFD9DC1ABDD2E050007F010069C5',
	'Role:update',
	'角色管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC1ABDD2E050007F010069C5/76C3EFD9DC1DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/角色管理/角色管理修改',
	'fun',
	'454',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130069,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC1EBDD2E050007F010069C5',
	'76C3EFD9DC1ABDD2E050007F010069C5',
	'Role:delete',
	'角色管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC1ABDD2E050007F010069C5/76C3EFD9DC1EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/角色管理/角色管理删除',
	'fun',
	'454',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130070,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC1FBDD2E050007F010069C5',
	'76C3EFD9DC1ABDD2E050007F010069C5',
	'Role:query',
	'角色管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC1ABDD2E050007F010069C5/76C3EFD9DC1FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/角色管理/角色管理查询',
	'fun',
	'454',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130071,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC20BDD2E050007F010069C5',
	'76C3EFD9DC13BDD2E050007F010069C5',
	'Authorization',
	'授权管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC20BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/授权管理',
	'fun',
	'455',
	NULL,
	1,
	4,
	3130079,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC21BDD2E050007F010069C5',
	'76C3EFD9DC20BDD2E050007F010069C5',
	'Authorization:*',
	'授权管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC20BDD2E050007F010069C5/76C3EFD9DC21BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/授权管理/授权管理所有操作',
	'fun',
	'455',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130080,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC22BDD2E050007F010069C5',
	'76C3EFD9DC20BDD2E050007F010069C5',
	'Authorization:create',
	'授权管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC20BDD2E050007F010069C5/76C3EFD9DC22BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/授权管理/授权管理新增',
	'fun',
	'455',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130081,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC23BDD2E050007F010069C5',
	'76C3EFD9DC20BDD2E050007F010069C5',
	'Authorization:update',
	'授权管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC20BDD2E050007F010069C5/76C3EFD9DC23BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/授权管理/授权管理修改',
	'fun',
	'455',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130082,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC24BDD2E050007F010069C5',
	'76C3EFD9DC20BDD2E050007F010069C5',
	'Authorization:delete',
	'授权管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC20BDD2E050007F010069C5/76C3EFD9DC24BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/授权管理/授权管理删除',
	'fun',
	'455',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130083,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC25BDD2E050007F010069C5',
	'76C3EFD9DC20BDD2E050007F010069C5',
	'Authorization:query',
	'授权管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC20BDD2E050007F010069C5/76C3EFD9DC25BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/授权管理/授权管理查询',
	'fun',
	'455',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130084,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC26BDD2E050007F010069C5',
	'76C3EFD9DC13BDD2E050007F010069C5',
	'Permission',
	'权限管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC26BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/权限管理',
	'fun',
	'86D6DB958BA84ED19DF33EDAC6364F42',
	NULL,
	1,
	1,
	3130092,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC27BDD2E050007F010069C5',
	'76C3EFD9DC26BDD2E050007F010069C5',
	'Permission:*',
	'权限管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC26BDD2E050007F010069C5/76C3EFD9DC27BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/权限管理/权限管理所有操作',
	'fun',
	'86D6DB958BA84ED19DF33EDAC6364F42',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130093,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC28BDD2E050007F010069C5',
	'76C3EFD9DC26BDD2E050007F010069C5',
	'Permission:create',
	'权限管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC26BDD2E050007F010069C5/76C3EFD9DC28BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/权限管理/权限管理新增',
	'fun',
	'86D6DB958BA84ED19DF33EDAC6364F42',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130094,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC29BDD2E050007F010069C5',
	'76C3EFD9DC26BDD2E050007F010069C5',
	'Permission:update',
	'权限管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC26BDD2E050007F010069C5/76C3EFD9DC29BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/权限管理/权限管理修改',
	'fun',
	'86D6DB958BA84ED19DF33EDAC6364F42',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130095,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC2ABDD2E050007F010069C5',
	'76C3EFD9DC26BDD2E050007F010069C5',
	'Permission:delete',
	'权限管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC26BDD2E050007F010069C5/76C3EFD9DC2ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/权限管理/权限管理删除',
	'fun',
	'86D6DB958BA84ED19DF33EDAC6364F42',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130096,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC2BBDD2E050007F010069C5',
	'76C3EFD9DC26BDD2E050007F010069C5',
	'Permission:query',
	'权限管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC26BDD2E050007F010069C5/76C3EFD9DC2BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/权限管理/权限管理查询',
	'fun',
	'86D6DB958BA84ED19DF33EDAC6364F42',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130097,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC2CBDD2E050007F010069C5',
	'76C3EFD9DC13BDD2E050007F010069C5',
	'TMAuthorize',
	'三员授权',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC2CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/三员授权',
	'fun',
	'CFEE19FBBDCC4242834562C277F3DB6B',
	NULL,
	1,
	5,
	3130105,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC2DBDD2E050007F010069C5',
	'76C3EFD9DC2CBDD2E050007F010069C5',
	'TMAuthorize:*',
	'三员授权所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC2CBDD2E050007F010069C5/76C3EFD9DC2DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/三员授权/三员授权所有操作',
	'fun',
	'CFEE19FBBDCC4242834562C277F3DB6B',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130106,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC2EBDD2E050007F010069C5',
	'76C3EFD9DC2CBDD2E050007F010069C5',
	'TMAuthorize:create',
	'三员授权新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC2CBDD2E050007F010069C5/76C3EFD9DC2EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/三员授权/三员授权新增',
	'fun',
	'CFEE19FBBDCC4242834562C277F3DB6B',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130107,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC2FBDD2E050007F010069C5',
	'76C3EFD9DC2CBDD2E050007F010069C5',
	'TMAuthorize:update',
	'三员授权修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC2CBDD2E050007F010069C5/76C3EFD9DC2FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/三员授权/三员授权修改',
	'fun',
	'CFEE19FBBDCC4242834562C277F3DB6B',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130108,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC30BDD2E050007F010069C5',
	'76C3EFD9DC2CBDD2E050007F010069C5',
	'TMAuthorize:delete',
	'三员授权删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC2CBDD2E050007F010069C5/76C3EFD9DC30BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/三员授权/三员授权删除',
	'fun',
	'CFEE19FBBDCC4242834562C277F3DB6B',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130109,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC31BDD2E050007F010069C5',
	'76C3EFD9DC2CBDD2E050007F010069C5',
	'TMAuthorize:query',
	'三员授权查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC2CBDD2E050007F010069C5/76C3EFD9DC31BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/三员授权/三员授权查询',
	'fun',
	'CFEE19FBBDCC4242834562C277F3DB6B',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130110,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC32BDD2E050007F010069C5',
	'76C3EFD9DC13BDD2E050007F010069C5',
	'UIElement',
	'界面元素',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC32BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/界面元素',
	'fun',
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	NULL,
	1,
	6,
	3130118,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC33BDD2E050007F010069C5',
	'76C3EFD9DC32BDD2E050007F010069C5',
	'UIElement:*',
	'界面元素所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC32BDD2E050007F010069C5/76C3EFD9DC33BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/界面元素/界面元素所有操作',
	'fun',
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130119,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC34BDD2E050007F010069C5',
	'76C3EFD9DC32BDD2E050007F010069C5',
	'UIElement:create',
	'界面元素新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC32BDD2E050007F010069C5/76C3EFD9DC34BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/界面元素/界面元素新增',
	'fun',
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130120,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC35BDD2E050007F010069C5',
	'76C3EFD9DC32BDD2E050007F010069C5',
	'UIElement:update',
	'界面元素修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC32BDD2E050007F010069C5/76C3EFD9DC35BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/界面元素/界面元素修改',
	'fun',
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130121,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC36BDD2E050007F010069C5',
	'76C3EFD9DC32BDD2E050007F010069C5',
	'UIElement:delete',
	'界面元素删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC32BDD2E050007F010069C5/76C3EFD9DC36BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/界面元素/界面元素删除',
	'fun',
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130122,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC37BDD2E050007F010069C5',
	'76C3EFD9DC32BDD2E050007F010069C5',
	'UIElement:query',
	'界面元素查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC13BDD2E050007F010069C5/76C3EFD9DC32BDD2E050007F010069C5/76C3EFD9DC37BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/功能权限/界面元素/界面元素查询',
	'fun',
	'D219D03F5BDD4FB2893A86B0EF2A3FD9',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130123,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC38BDD2E050007F010069C5',
	'76C3EFD9DBEDBDD2E050007F010069C5',
	'DataManage',
	'数据管理权限',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限',
	'fun',
	'3AECEB1B898D4F348606363D5E444AE7',
	NULL,
	1,
	4,
	3130125,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC39BDD2E050007F010069C5',
	'76C3EFD9DC38BDD2E050007F010069C5',
	'OpDataKind',
	'权限资源类型定义',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC39BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/权限资源类型定义',
	'fun',
	'631EDDA58C5A46CBAB665608091488B7',
	NULL,
	1,
	1,
	3130133,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC3ABDD2E050007F010069C5',
	'76C3EFD9DC39BDD2E050007F010069C5',
	'OpDataKind:*',
	'权限资源类型定义所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC39BDD2E050007F010069C5/76C3EFD9DC3ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/权限资源类型定义/权限资源类型定义所有操作',
	'fun',
	'631EDDA58C5A46CBAB665608091488B7',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130134,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC3BBDD2E050007F010069C5',
	'76C3EFD9DC39BDD2E050007F010069C5',
	'OpDataKind:create',
	'权限资源类型定义新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC39BDD2E050007F010069C5/76C3EFD9DC3BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/权限资源类型定义/权限资源类型定义新增',
	'fun',
	'631EDDA58C5A46CBAB665608091488B7',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130135,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC3CBDD2E050007F010069C5',
	'76C3EFD9DC39BDD2E050007F010069C5',
	'OpDataKind:update',
	'权限资源类型定义修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC39BDD2E050007F010069C5/76C3EFD9DC3CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/权限资源类型定义/权限资源类型定义修改',
	'fun',
	'631EDDA58C5A46CBAB665608091488B7',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130136,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC3DBDD2E050007F010069C5',
	'76C3EFD9DC39BDD2E050007F010069C5',
	'OpDataKind:delete',
	'权限资源类型定义删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC39BDD2E050007F010069C5/76C3EFD9DC3DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/权限资源类型定义/权限资源类型定义删除',
	'fun',
	'631EDDA58C5A46CBAB665608091488B7',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130137,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC3EBDD2E050007F010069C5',
	'76C3EFD9DC39BDD2E050007F010069C5',
	'OpDataKind:query',
	'权限资源类型定义查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC39BDD2E050007F010069C5/76C3EFD9DC3EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/权限资源类型定义/权限资源类型定义查询',
	'fun',
	'631EDDA58C5A46CBAB665608091488B7',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130138,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC3FBDD2E050007F010069C5',
	'76C3EFD9DC38BDD2E050007F010069C5',
	'DataManageType',
	'管理权限定义',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC3FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限定义',
	'fun',
	'888561D799F446FEA981C1825CCAC31E',
	NULL,
	1,
	2,
	3130146,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC40BDD2E050007F010069C5',
	'76C3EFD9DC3FBDD2E050007F010069C5',
	'DataManageType:*',
	'管理权限定义所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC3FBDD2E050007F010069C5/76C3EFD9DC40BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限定义/管理权限定义所有操作',
	'fun',
	'888561D799F446FEA981C1825CCAC31E',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130147,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC41BDD2E050007F010069C5',
	'76C3EFD9DC3FBDD2E050007F010069C5',
	'DataManageType:create',
	'管理权限定义新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC3FBDD2E050007F010069C5/76C3EFD9DC41BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限定义/管理权限定义新增',
	'fun',
	'888561D799F446FEA981C1825CCAC31E',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130148,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC42BDD2E050007F010069C5',
	'76C3EFD9DC3FBDD2E050007F010069C5',
	'DataManageType:update',
	'管理权限定义修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC3FBDD2E050007F010069C5/76C3EFD9DC42BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限定义/管理权限定义修改',
	'fun',
	'888561D799F446FEA981C1825CCAC31E',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130149,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC43BDD2E050007F010069C5',
	'76C3EFD9DC3FBDD2E050007F010069C5',
	'DataManageType:delete',
	'管理权限定义删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC3FBDD2E050007F010069C5/76C3EFD9DC43BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限定义/管理权限定义删除',
	'fun',
	'888561D799F446FEA981C1825CCAC31E',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130150,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC44BDD2E050007F010069C5',
	'76C3EFD9DC3FBDD2E050007F010069C5',
	'DataManageType:query',
	'管理权限定义查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC3FBDD2E050007F010069C5/76C3EFD9DC44BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限定义/管理权限定义查询',
	'fun',
	'888561D799F446FEA981C1825CCAC31E',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130151,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC45BDD2E050007F010069C5',
	'76C3EFD9DC38BDD2E050007F010069C5',
	'DatamanageDetail',
	'管理权限资源维护',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC45BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限资源维护',
	'fun',
	'A587A3666005459DB4B2768B1386F2D9',
	NULL,
	1,
	3,
	3130159,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC46BDD2E050007F010069C5',
	'76C3EFD9DC45BDD2E050007F010069C5',
	'DatamanageDetail:*',
	'管理权限资源维护所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC45BDD2E050007F010069C5/76C3EFD9DC46BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限资源维护/管理权限资源维护所有操作',
	'fun',
	'A587A3666005459DB4B2768B1386F2D9',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130160,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC47BDD2E050007F010069C5',
	'76C3EFD9DC45BDD2E050007F010069C5',
	'DatamanageDetail:create',
	'管理权限资源维护新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC45BDD2E050007F010069C5/76C3EFD9DC47BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限资源维护/管理权限资源维护新增',
	'fun',
	'A587A3666005459DB4B2768B1386F2D9',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130161,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC48BDD2E050007F010069C5',
	'76C3EFD9DC45BDD2E050007F010069C5',
	'DatamanageDetail:update',
	'管理权限资源维护修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC45BDD2E050007F010069C5/76C3EFD9DC48BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限资源维护/管理权限资源维护修改',
	'fun',
	'A587A3666005459DB4B2768B1386F2D9',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130162,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC49BDD2E050007F010069C5',
	'76C3EFD9DC45BDD2E050007F010069C5',
	'DatamanageDetail:delete',
	'管理权限资源维护删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC45BDD2E050007F010069C5/76C3EFD9DC49BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限资源维护/管理权限资源维护删除',
	'fun',
	'A587A3666005459DB4B2768B1386F2D9',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130163,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC4ABDD2E050007F010069C5',
	'76C3EFD9DC45BDD2E050007F010069C5',
	'DatamanageDetail:query',
	'管理权限资源维护查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC45BDD2E050007F010069C5/76C3EFD9DC4ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限资源维护/管理权限资源维护查询',
	'fun',
	'A587A3666005459DB4B2768B1386F2D9',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130164,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC4BBDD2E050007F010069C5',
	'76C3EFD9DC38BDD2E050007F010069C5',
	'DataManagement',
	'管理权限授权',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC4BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限授权',
	'fun',
	'E420A7A8C2514663A1EFB96213A4BBA9',
	NULL,
	1,
	4,
	3130172,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC4CBDD2E050007F010069C5',
	'76C3EFD9DC4BBDD2E050007F010069C5',
	'DataManagement:*',
	'管理权限授权所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC4BBDD2E050007F010069C5/76C3EFD9DC4CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限授权/管理权限授权所有操作',
	'fun',
	'E420A7A8C2514663A1EFB96213A4BBA9',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130173,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC4DBDD2E050007F010069C5',
	'76C3EFD9DC4BBDD2E050007F010069C5',
	'DataManagement:create',
	'管理权限授权新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC4BBDD2E050007F010069C5/76C3EFD9DC4DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限授权/管理权限授权新增',
	'fun',
	'E420A7A8C2514663A1EFB96213A4BBA9',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130174,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC4EBDD2E050007F010069C5',
	'76C3EFD9DC4BBDD2E050007F010069C5',
	'DataManagement:update',
	'管理权限授权修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC4BBDD2E050007F010069C5/76C3EFD9DC4EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限授权/管理权限授权修改',
	'fun',
	'E420A7A8C2514663A1EFB96213A4BBA9',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130175,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC4FBDD2E050007F010069C5',
	'76C3EFD9DC4BBDD2E050007F010069C5',
	'DataManagement:delete',
	'管理权限授权删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC4BBDD2E050007F010069C5/76C3EFD9DC4FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限授权/管理权限授权删除',
	'fun',
	'E420A7A8C2514663A1EFB96213A4BBA9',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130176,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC50BDD2E050007F010069C5',
	'76C3EFD9DC4BBDD2E050007F010069C5',
	'DataManagement:query',
	'管理权限授权查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76C3EFD9DC4BBDD2E050007F010069C5/76C3EFD9DC50BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限授权/管理权限授权查询',
	'fun',
	'E420A7A8C2514663A1EFB96213A4BBA9',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130177,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC51BDD2E050007F010069C5',
	'76C3EFD9DBEDBDD2E050007F010069C5',
	'DelegationBizManagement',
	'分级授权管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC51BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/分级授权管理',
	'fun',
	'5431972',
	NULL,
	0,
	5,
	3130185,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC52BDD2E050007F010069C5',
	'76C3EFD9DC51BDD2E050007F010069C5',
	'DelegationBizManagement:*',
	'分级授权管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC51BDD2E050007F010069C5/76C3EFD9DC52BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/分级授权管理/分级授权管理所有操作',
	'fun',
	'5431972',
	'C69E9314B8944B459B9C408A11C829D6',
	0,
	1,
	3130186,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC53BDD2E050007F010069C5',
	'76C3EFD9DC51BDD2E050007F010069C5',
	'DelegationBizManagement:create',
	'分级授权管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC51BDD2E050007F010069C5/76C3EFD9DC53BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/分级授权管理/分级授权管理新增',
	'fun',
	'5431972',
	'E23D0E0EA7584311B048EED187DC1DA3',
	0,
	2,
	3130187,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC54BDD2E050007F010069C5',
	'76C3EFD9DC51BDD2E050007F010069C5',
	'DelegationBizManagement:update',
	'分级授权管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC51BDD2E050007F010069C5/76C3EFD9DC54BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/分级授权管理/分级授权管理修改',
	'fun',
	'5431972',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	0,
	3,
	3130188,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC55BDD2E050007F010069C5',
	'76C3EFD9DC51BDD2E050007F010069C5',
	'DelegationBizManagement:delete',
	'分级授权管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC51BDD2E050007F010069C5/76C3EFD9DC55BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/分级授权管理/分级授权管理删除',
	'fun',
	'5431972',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	0,
	4,
	3130189,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC56BDD2E050007F010069C5',
	'76C3EFD9DC51BDD2E050007F010069C5',
	'DelegationBizManagement:query',
	'分级授权管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC51BDD2E050007F010069C5/76C3EFD9DC56BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/分级授权管理/分级授权管理查询',
	'fun',
	'5431972',
	'A0DAC625FBCF48F49AB9039BC746F196',
	0,
	6,
	3130190,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC57BDD2E050007F010069C5',
	'76C3EFD9DBEDBDD2E050007F010069C5',
	'OrgFolder',
	'组织机构',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构',
	'fun',
	'D6A3E6208CCF4D8491DBC717955429F4',
	NULL,
	1,
	1,
	3130192,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC58BDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'OrgPropertyDefinition',
	'组织属性定义',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC58BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织属性定义',
	'fun',
	'32D3CC5E12774181A9CAB5B306B222F8',
	NULL,
	1,
	7,
	3130200,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC59BDD2E050007F010069C5',
	'76C3EFD9DC58BDD2E050007F010069C5',
	'OrgPropertyDefinition:*',
	'组织属性定义所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC58BDD2E050007F010069C5/76C3EFD9DC59BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织属性定义/组织属性定义所有操作',
	'fun',
	'32D3CC5E12774181A9CAB5B306B222F8',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130201,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC5ABDD2E050007F010069C5',
	'76C3EFD9DC58BDD2E050007F010069C5',
	'OrgPropertyDefinition:create',
	'组织属性定义新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC58BDD2E050007F010069C5/76C3EFD9DC5ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织属性定义/组织属性定义新增',
	'fun',
	'32D3CC5E12774181A9CAB5B306B222F8',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130202,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC5BBDD2E050007F010069C5',
	'76C3EFD9DC58BDD2E050007F010069C5',
	'OrgPropertyDefinition:update',
	'组织属性定义修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC58BDD2E050007F010069C5/76C3EFD9DC5BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织属性定义/组织属性定义修改',
	'fun',
	'32D3CC5E12774181A9CAB5B306B222F8',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130203,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC5CBDD2E050007F010069C5',
	'76C3EFD9DC58BDD2E050007F010069C5',
	'OrgPropertyDefinition:delete',
	'组织属性定义删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC58BDD2E050007F010069C5/76C3EFD9DC5CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织属性定义/组织属性定义删除',
	'fun',
	'32D3CC5E12774181A9CAB5B306B222F8',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130204,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC5DBDD2E050007F010069C5',
	'76C3EFD9DC58BDD2E050007F010069C5',
	'OrgPropertyDefinition:query',
	'组织属性定义查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC58BDD2E050007F010069C5/76C3EFD9DC5DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织属性定义/组织属性定义查询',
	'fun',
	'32D3CC5E12774181A9CAB5B306B222F8',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130205,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC5EBDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'OrgType',
	'机构类型',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC5EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构类型',
	'fun',
	'448',
	NULL,
	1,
	1,
	3130213,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC5FBDD2E050007F010069C5',
	'76C3EFD9DC5EBDD2E050007F010069C5',
	'OrgType:*',
	'机构类型所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC5EBDD2E050007F010069C5/76C3EFD9DC5FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构类型/机构类型所有操作',
	'fun',
	'448',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130214,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC60BDD2E050007F010069C5',
	'76C3EFD9DC5EBDD2E050007F010069C5',
	'OrgType:create',
	'机构类型新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC5EBDD2E050007F010069C5/76C3EFD9DC60BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构类型/机构类型新增',
	'fun',
	'448',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130215,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC61BDD2E050007F010069C5',
	'76C3EFD9DC5EBDD2E050007F010069C5',
	'OrgType:update',
	'机构类型修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC5EBDD2E050007F010069C5/76C3EFD9DC61BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构类型/机构类型修改',
	'fun',
	'448',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130216,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC62BDD2E050007F010069C5',
	'76C3EFD9DC5EBDD2E050007F010069C5',
	'OrgType:delete',
	'机构类型删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC5EBDD2E050007F010069C5/76C3EFD9DC62BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构类型/机构类型删除',
	'fun',
	'448',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130217,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC63BDD2E050007F010069C5',
	'76C3EFD9DC5EBDD2E050007F010069C5',
	'OrgType:query',
	'机构类型查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC5EBDD2E050007F010069C5/76C3EFD9DC63BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构类型/机构类型查询',
	'fun',
	'448',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130218,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC64BDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'DeptType',
	'部门类型',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC64BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/部门类型',
	'fun',
	'449',
	NULL,
	1,
	2,
	3130226,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC65BDD2E050007F010069C5',
	'76C3EFD9DC64BDD2E050007F010069C5',
	'DeptType:*',
	'部门类型所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC64BDD2E050007F010069C5/76C3EFD9DC65BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/部门类型/部门类型所有操作',
	'fun',
	'449',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130227,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC66BDD2E050007F010069C5',
	'76C3EFD9DC64BDD2E050007F010069C5',
	'DeptType:create',
	'部门类型新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC64BDD2E050007F010069C5/76C3EFD9DC66BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/部门类型/部门类型新增',
	'fun',
	'449',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130228,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC67BDD2E050007F010069C5',
	'76C3EFD9DC64BDD2E050007F010069C5',
	'DeptType:update',
	'部门类型修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC64BDD2E050007F010069C5/76C3EFD9DC67BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/部门类型/部门类型修改',
	'fun',
	'449',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130229,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC68BDD2E050007F010069C5',
	'76C3EFD9DC64BDD2E050007F010069C5',
	'DeptType:delete',
	'部门类型删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC64BDD2E050007F010069C5/76C3EFD9DC68BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/部门类型/部门类型删除',
	'fun',
	'449',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130230,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC69BDD2E050007F010069C5',
	'76C3EFD9DC64BDD2E050007F010069C5',
	'DeptType:query',
	'部门类型查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC64BDD2E050007F010069C5/76C3EFD9DC69BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/部门类型/部门类型查询',
	'fun',
	'449',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130231,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC6ABDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'PosType',
	'岗位类型',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC6ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/岗位类型',
	'fun',
	'450',
	NULL,
	1,
	3,
	3130239,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC6BBDD2E050007F010069C5',
	'76C3EFD9DC6ABDD2E050007F010069C5',
	'PosType:*',
	'岗位类型所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC6ABDD2E050007F010069C5/76C3EFD9DC6BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/岗位类型/岗位类型所有操作',
	'fun',
	'450',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130240,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC6CBDD2E050007F010069C5',
	'76C3EFD9DC6ABDD2E050007F010069C5',
	'PosType:create',
	'岗位类型新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC6ABDD2E050007F010069C5/76C3EFD9DC6CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/岗位类型/岗位类型新增',
	'fun',
	'450',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130241,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC6DBDD2E050007F010069C5',
	'76C3EFD9DC6ABDD2E050007F010069C5',
	'PosType:update',
	'岗位类型修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC6ABDD2E050007F010069C5/76C3EFD9DC6DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/岗位类型/岗位类型修改',
	'fun',
	'450',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130242,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC6EBDD2E050007F010069C5',
	'76C3EFD9DC6ABDD2E050007F010069C5',
	'PosType:delete',
	'岗位类型删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC6ABDD2E050007F010069C5/76C3EFD9DC6EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/岗位类型/岗位类型删除',
	'fun',
	'450',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130243,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC6FBDD2E050007F010069C5',
	'76C3EFD9DC6ABDD2E050007F010069C5',
	'PosType:query',
	'岗位类型查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC6ABDD2E050007F010069C5/76C3EFD9DC6FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/岗位类型/岗位类型查询',
	'fun',
	'450',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130244,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC70BDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'OrgTemplate',
	'机构模板',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC70BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构模板',
	'fun',
	'451',
	NULL,
	1,
	4,
	3130252,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC71BDD2E050007F010069C5',
	'76C3EFD9DC70BDD2E050007F010069C5',
	'OrgTemplate:*',
	'机构模板所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC70BDD2E050007F010069C5/76C3EFD9DC71BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构模板/机构模板所有操作',
	'fun',
	'451',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130253,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC72BDD2E050007F010069C5',
	'76C3EFD9DC70BDD2E050007F010069C5',
	'OrgTemplate:create',
	'机构模板新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC70BDD2E050007F010069C5/76C3EFD9DC72BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构模板/机构模板新增',
	'fun',
	'451',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130254,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC73BDD2E050007F010069C5',
	'76C3EFD9DC70BDD2E050007F010069C5',
	'OrgTemplate:update',
	'机构模板修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC70BDD2E050007F010069C5/76C3EFD9DC73BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构模板/机构模板修改',
	'fun',
	'451',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130255,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC74BDD2E050007F010069C5',
	'76C3EFD9DC70BDD2E050007F010069C5',
	'OrgTemplate:delete',
	'机构模板删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC70BDD2E050007F010069C5/76C3EFD9DC74BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构模板/机构模板删除',
	'fun',
	'451',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130256,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC75BDD2E050007F010069C5',
	'76C3EFD9DC70BDD2E050007F010069C5',
	'OrgTemplate:query',
	'机构模板查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC70BDD2E050007F010069C5/76C3EFD9DC75BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/机构模板/机构模板查询',
	'fun',
	'451',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130257,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC76BDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'Org',
	'组织管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织管理',
	'fun',
	'452',
	NULL,
	1,
	5,
	3130265,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC77BDD2E050007F010069C5',
	'76C3EFD9DC76BDD2E050007F010069C5',
	'Org:*',
	'组织管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5/76C3EFD9DC77BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织管理/组织管理所有操作',
	'fun',
	'452',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130266,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC78BDD2E050007F010069C5',
	'76C3EFD9DC76BDD2E050007F010069C5',
	'Org:create',
	'组织管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5/76C3EFD9DC78BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织管理/组织管理新增',
	'fun',
	'452',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130267,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC79BDD2E050007F010069C5',
	'76C3EFD9DC76BDD2E050007F010069C5',
	'Org:update',
	'组织管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5/76C3EFD9DC79BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织管理/组织管理修改',
	'fun',
	'452',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130268,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC7ABDD2E050007F010069C5',
	'76C3EFD9DC76BDD2E050007F010069C5',
	'Org:delete',
	'组织管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5/76C3EFD9DC7ABDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织管理/组织管理删除',
	'fun',
	'452',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130269,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC7BBDD2E050007F010069C5',
	'76C3EFD9DC76BDD2E050007F010069C5',
	'Org:query',
	'组织管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC76BDD2E050007F010069C5/76C3EFD9DC7BBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/组织管理/组织管理查询',
	'fun',
	'452',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130270,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC7CBDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'UserGroupMge',
	'分组管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC7CBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/分组管理',
	'fun',
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	NULL,
	1,
	9,
	3130278,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC7DBDD2E050007F010069C5',
	'76C3EFD9DC7CBDD2E050007F010069C5',
	'UserGroupMge:*',
	'分组管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC7CBDD2E050007F010069C5/76C3EFD9DC7DBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/分组管理/分组管理所有操作',
	'fun',
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130279,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC7EBDD2E050007F010069C5',
	'76C3EFD9DC7CBDD2E050007F010069C5',
	'UserGroupMge:create',
	'分组管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC7CBDD2E050007F010069C5/76C3EFD9DC7EBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/分组管理/分组管理新增',
	'fun',
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130280,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC7FBDD2E050007F010069C5',
	'76C3EFD9DC7CBDD2E050007F010069C5',
	'UserGroupMge:update',
	'分组管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC7CBDD2E050007F010069C5/76C3EFD9DC7FBDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/分组管理/分组管理修改',
	'fun',
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130281,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC80BDD2E050007F010069C5',
	'76C3EFD9DC7CBDD2E050007F010069C5',
	'UserGroupMge:delete',
	'分组管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC7CBDD2E050007F010069C5/76C3EFD9DC80BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/分组管理/分组管理删除',
	'fun',
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130282,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC81BDD2E050007F010069C5',
	'76C3EFD9DC7CBDD2E050007F010069C5',
	'UserGroupMge:query',
	'分组管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC7CBDD2E050007F010069C5/76C3EFD9DC81BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/分组管理/分组管理查询',
	'fun',
	'9CBD5AB8EEB44EC6B0FB00FE002E5B3E',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130283,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC82BDD2E050007F010069C5',
	'76C3EFD9DC57BDD2E050007F010069C5',
	'RecycleBin',
	'回收站',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC82BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/回收站',
	'fun',
	'FF0D8FE902D447D1A31110E86CDD8385',
	NULL,
	1,
	8,
	3130291,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC83BDD2E050007F010069C5',
	'76C3EFD9DC82BDD2E050007F010069C5',
	'RecycleBin:*',
	'回收站所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC82BDD2E050007F010069C5/76C3EFD9DC83BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/回收站/回收站所有操作',
	'fun',
	'FF0D8FE902D447D1A31110E86CDD8385',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130292,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC84BDD2E050007F010069C5',
	'76C3EFD9DC82BDD2E050007F010069C5',
	'RecycleBin:create',
	'回收站新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC82BDD2E050007F010069C5/76C3EFD9DC84BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/回收站/回收站新增',
	'fun',
	'FF0D8FE902D447D1A31110E86CDD8385',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130293,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC85BDD2E050007F010069C5',
	'76C3EFD9DC82BDD2E050007F010069C5',
	'RecycleBin:update',
	'回收站修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC82BDD2E050007F010069C5/76C3EFD9DC85BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/回收站/回收站修改',
	'fun',
	'FF0D8FE902D447D1A31110E86CDD8385',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130294,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC86BDD2E050007F010069C5',
	'76C3EFD9DC82BDD2E050007F010069C5',
	'RecycleBin:delete',
	'回收站删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC82BDD2E050007F010069C5/76C3EFD9DC86BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/回收站/回收站删除',
	'fun',
	'FF0D8FE902D447D1A31110E86CDD8385',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130295,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC87BDD2E050007F010069C5',
	'76C3EFD9DC82BDD2E050007F010069C5',
	'RecycleBin:query',
	'回收站查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC57BDD2E050007F010069C5/76C3EFD9DC82BDD2E050007F010069C5/76C3EFD9DC87BDD2E050007F010069C5',
	'/系统功能/协同平台/组织权限/组织机构/回收站/回收站查询',
	'fun',
	'FF0D8FE902D447D1A31110E86CDD8385',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130296,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC88BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'BizConfiguration',
	'业务配置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置',
	'fun',
	'5E954471A9C0443EB259460FF3BA686C',
	NULL,
	1,
	5,
	3130298,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC96BDD2E050007F010069C5',
	'76C3EFD9DC88BDD2E050007F010069C5',
	'DataImport',
	'数据导入',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入',
	'fun',
	'4178',
	NULL,
	1,
	1,
	3130328,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC97BDD2E050007F010069C5',
	'76C3EFD9DC96BDD2E050007F010069C5',
	'ExcelImportTemplate',
	'导入模板设置',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC97BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入模板设置',
	'fun',
	'4179',
	NULL,
	1,
	1,
	3130336,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC98BDD2E050007F010069C5',
	'76C3EFD9DC97BDD2E050007F010069C5',
	'ExcelImportTemplate:*',
	'导入模板设置所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC97BDD2E050007F010069C5/76C3EFD9DC98BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入模板设置/导入模板设置所有操作',
	'fun',
	'4179',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130337,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC99BDD2E050007F010069C5',
	'76C3EFD9DC97BDD2E050007F010069C5',
	'ExcelImportTemplate:create',
	'导入模板设置新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC97BDD2E050007F010069C5/76C3EFD9DC99BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入模板设置/导入模板设置新增',
	'fun',
	'4179',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130338,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC9ABDD2E050007F010069C5',
	'76C3EFD9DC97BDD2E050007F010069C5',
	'ExcelImportTemplate:update',
	'导入模板设置修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC97BDD2E050007F010069C5/76C3EFD9DC9ABDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入模板设置/导入模板设置修改',
	'fun',
	'4179',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130339,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC9BBDD2E050007F010069C5',
	'76C3EFD9DC97BDD2E050007F010069C5',
	'ExcelImportTemplate:delete',
	'导入模板设置删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC97BDD2E050007F010069C5/76C3EFD9DC9BBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入模板设置/导入模板设置删除',
	'fun',
	'4179',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130340,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC9CBDD2E050007F010069C5',
	'76C3EFD9DC97BDD2E050007F010069C5',
	'ExcelImportTemplate:query',
	'导入模板设置查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC97BDD2E050007F010069C5/76C3EFD9DC9CBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入模板设置/导入模板设置查询',
	'fun',
	'4179',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130341,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC9DBDD2E050007F010069C5',
	'76C3EFD9DC96BDD2E050007F010069C5',
	'ExcelImport',
	'导入数据',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC9DBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入数据',
	'fun',
	'6686',
	NULL,
	1,
	2,
	3130349,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC9EBDD2E050007F010069C5',
	'76C3EFD9DC9DBDD2E050007F010069C5',
	'ExcelImport:*',
	'导入数据所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC9DBDD2E050007F010069C5/76C3EFD9DC9EBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入数据/导入数据所有操作',
	'fun',
	'6686',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130350,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DC9FBDD2E050007F010069C5',
	'76C3EFD9DC9DBDD2E050007F010069C5',
	'ExcelImport:create',
	'导入数据新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC9DBDD2E050007F010069C5/76C3EFD9DC9FBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入数据/导入数据新增',
	'fun',
	'6686',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130351,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA0BDD2E050007F010069C5',
	'76C3EFD9DC9DBDD2E050007F010069C5',
	'ExcelImport:update',
	'导入数据修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC9DBDD2E050007F010069C5/76C3EFD9DCA0BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入数据/导入数据修改',
	'fun',
	'6686',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130352,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA1BDD2E050007F010069C5',
	'76C3EFD9DC9DBDD2E050007F010069C5',
	'ExcelImport:delete',
	'导入数据删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC9DBDD2E050007F010069C5/76C3EFD9DCA1BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入数据/导入数据删除',
	'fun',
	'6686',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130353,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA2BDD2E050007F010069C5',
	'76C3EFD9DC9DBDD2E050007F010069C5',
	'ExcelImport:query',
	'导入数据查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DC96BDD2E050007F010069C5/76C3EFD9DC9DBDD2E050007F010069C5/76C3EFD9DCA2BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/数据导入/导入数据/导入数据查询',
	'fun',
	'6686',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130354,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA3BDD2E050007F010069C5',
	'76C3EFD9DC88BDD2E050007F010069C5',
	'FlexField',
	'扩展字段',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段',
	'fun',
	'803',
	NULL,
	1,
	1,
	3130356,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA4BDD2E050007F010069C5',
	'76C3EFD9DCA3BDD2E050007F010069C5',
	'FlexFieldDefine',
	'扩展字段定义',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCA4BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段定义',
	'fun',
	'804',
	NULL,
	1,
	1,
	3130364,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA5BDD2E050007F010069C5',
	'76C3EFD9DCA4BDD2E050007F010069C5',
	'FlexFieldDefine:*',
	'扩展字段定义所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCA4BDD2E050007F010069C5/76C3EFD9DCA5BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段定义/扩展字段定义所有操作',
	'fun',
	'804',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130365,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA6BDD2E050007F010069C5',
	'76C3EFD9DCA4BDD2E050007F010069C5',
	'FlexFieldDefine:create',
	'扩展字段定义新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCA4BDD2E050007F010069C5/76C3EFD9DCA6BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段定义/扩展字段定义新增',
	'fun',
	'804',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130366,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA7BDD2E050007F010069C5',
	'76C3EFD9DCA4BDD2E050007F010069C5',
	'FlexFieldDefine:update',
	'扩展字段定义修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCA4BDD2E050007F010069C5/76C3EFD9DCA7BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段定义/扩展字段定义修改',
	'fun',
	'804',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130367,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA8BDD2E050007F010069C5',
	'76C3EFD9DCA4BDD2E050007F010069C5',
	'FlexFieldDefine:delete',
	'扩展字段定义删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCA4BDD2E050007F010069C5/76C3EFD9DCA8BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段定义/扩展字段定义删除',
	'fun',
	'804',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130368,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCA9BDD2E050007F010069C5',
	'76C3EFD9DCA4BDD2E050007F010069C5',
	'FlexFieldDefine:query',
	'扩展字段定义查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCA4BDD2E050007F010069C5/76C3EFD9DCA9BDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段定义/扩展字段定义查询',
	'fun',
	'804',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130369,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCAABDD2E050007F010069C5',
	'76C3EFD9DCA3BDD2E050007F010069C5',
	'FlexFieldGroup',
	'扩展字段分组',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCAABDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段分组',
	'fun',
	'862',
	NULL,
	1,
	2,
	3130377,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCABBDD2E050007F010069C5',
	'76C3EFD9DCAABDD2E050007F010069C5',
	'FlexFieldGroup:*',
	'扩展字段分组所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCAABDD2E050007F010069C5/76C3EFD9DCABBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段分组/扩展字段分组所有操作',
	'fun',
	'862',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130378,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCACBDD2E050007F010069C5',
	'76C3EFD9DCAABDD2E050007F010069C5',
	'FlexFieldGroup:create',
	'扩展字段分组新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCAABDD2E050007F010069C5/76C3EFD9DCACBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段分组/扩展字段分组新增',
	'fun',
	'862',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130379,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCADBDD2E050007F010069C5',
	'76C3EFD9DCAABDD2E050007F010069C5',
	'FlexFieldGroup:update',
	'扩展字段分组修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCAABDD2E050007F010069C5/76C3EFD9DCADBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段分组/扩展字段分组修改',
	'fun',
	'862',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130380,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCAEBDD2E050007F010069C5',
	'76C3EFD9DCAABDD2E050007F010069C5',
	'FlexFieldGroup:delete',
	'扩展字段分组删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCAABDD2E050007F010069C5/76C3EFD9DCAEBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段分组/扩展字段分组删除',
	'fun',
	'862',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130381,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCAFBDD2E050007F010069C5',
	'76C3EFD9DCAABDD2E050007F010069C5',
	'FlexFieldGroup:query',
	'扩展字段分组查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DC88BDD2E050007F010069C5/76C3EFD9DCA3BDD2E050007F010069C5/76C3EFD9DCAABDD2E050007F010069C5/76C3EFD9DCAFBDD2E050007F010069C5',
	'/系统功能/协同平台/业务配置/扩展字段/扩展字段分组/扩展字段分组查询',
	'fun',
	'862',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130382,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB0BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'ConfigurationTools',
	'配置工具',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB0BDD2E050007F010069C5',
	'/系统功能/协同平台/配置工具',
	'fun',
	'6762',
	NULL,
	0,
	8,
	3130384,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB1BDD2E050007F010069C5',
	'6000FDBFF674421E883D035966C60431',
	'SecurityPolicy',
	'安全策略',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略',
	'fun',
	'AD2EA0A0990243A3A7DB0B3FD2BCB0BE',
	NULL,
	1,
	6,
	3130386,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB2BDD2E050007F010069C5',
	'76C3EFD9DCB1BDD2E050007F010069C5',
	'ApplicationSystem',
	'应用系统维护',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB2BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/应用系统维护',
	'fun',
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	NULL,
	1,
	5,
	3130394,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB3BDD2E050007F010069C5',
	'76C3EFD9DCB2BDD2E050007F010069C5',
	'ApplicationSystem:*',
	'应用系统维护所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB2BDD2E050007F010069C5/76C3EFD9DCB3BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/应用系统维护/应用系统维护所有操作',
	'fun',
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130395,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB4BDD2E050007F010069C5',
	'76C3EFD9DCB2BDD2E050007F010069C5',
	'ApplicationSystem:create',
	'应用系统维护新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB2BDD2E050007F010069C5/76C3EFD9DCB4BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/应用系统维护/应用系统维护新增',
	'fun',
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130396,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB5BDD2E050007F010069C5',
	'76C3EFD9DCB2BDD2E050007F010069C5',
	'ApplicationSystem:update',
	'应用系统维护修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB2BDD2E050007F010069C5/76C3EFD9DCB5BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/应用系统维护/应用系统维护修改',
	'fun',
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130397,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB6BDD2E050007F010069C5',
	'76C3EFD9DCB2BDD2E050007F010069C5',
	'ApplicationSystem:delete',
	'应用系统维护删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB2BDD2E050007F010069C5/76C3EFD9DCB6BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/应用系统维护/应用系统维护删除',
	'fun',
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130398,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB7BDD2E050007F010069C5',
	'76C3EFD9DCB2BDD2E050007F010069C5',
	'ApplicationSystem:query',
	'应用系统维护查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB2BDD2E050007F010069C5/76C3EFD9DCB7BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/应用系统维护/应用系统维护查询',
	'fun',
	'0E92578B0AFB487E9EC3B0D77622E6C6',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130399,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB8BDD2E050007F010069C5',
	'76C3EFD9DCB1BDD2E050007F010069C5',
	'Machine',
	'机器维护',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB8BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/机器维护',
	'fun',
	'33E0C6BCE56A41D893014279D8CF726D',
	NULL,
	1,
	1,
	3130407,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCB9BDD2E050007F010069C5',
	'76C3EFD9DCB8BDD2E050007F010069C5',
	'Machine:*',
	'机器维护所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB8BDD2E050007F010069C5/76C3EFD9DCB9BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/机器维护/机器维护所有操作',
	'fun',
	'33E0C6BCE56A41D893014279D8CF726D',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130408,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCBABDD2E050007F010069C5',
	'76C3EFD9DCB8BDD2E050007F010069C5',
	'Machine:create',
	'机器维护新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB8BDD2E050007F010069C5/76C3EFD9DCBABDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/机器维护/机器维护新增',
	'fun',
	'33E0C6BCE56A41D893014279D8CF726D',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130409,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCBBBDD2E050007F010069C5',
	'76C3EFD9DCB8BDD2E050007F010069C5',
	'Machine:update',
	'机器维护修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB8BDD2E050007F010069C5/76C3EFD9DCBBBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/机器维护/机器维护修改',
	'fun',
	'33E0C6BCE56A41D893014279D8CF726D',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130410,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCBCBDD2E050007F010069C5',
	'76C3EFD9DCB8BDD2E050007F010069C5',
	'Machine:delete',
	'机器维护删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB8BDD2E050007F010069C5/76C3EFD9DCBCBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/机器维护/机器维护删除',
	'fun',
	'33E0C6BCE56A41D893014279D8CF726D',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130411,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCBDBDD2E050007F010069C5',
	'76C3EFD9DCB8BDD2E050007F010069C5',
	'Machine:query',
	'机器维护查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCB8BDD2E050007F010069C5/76C3EFD9DCBDBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/机器维护/机器维护查询',
	'fun',
	'33E0C6BCE56A41D893014279D8CF726D',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130412,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCBEBDD2E050007F010069C5',
	'76C3EFD9DCB1BDD2E050007F010069C5',
	'PersonAccountManagement',
	'账号管理',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCBEBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/账号管理',
	'fun',
	'7D166A5A3A164BB19BEA396812EE7110',
	NULL,
	1,
	4,
	3130420,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCBFBDD2E050007F010069C5',
	'76C3EFD9DCBEBDD2E050007F010069C5',
	'PersonAccountManagement:*',
	'账号管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCBEBDD2E050007F010069C5/76C3EFD9DCBFBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/账号管理/账号管理所有操作',
	'fun',
	'7D166A5A3A164BB19BEA396812EE7110',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130421,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC0BDD2E050007F010069C5',
	'76C3EFD9DCBEBDD2E050007F010069C5',
	'PersonAccountManagement:create',
	'账号管理新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCBEBDD2E050007F010069C5/76C3EFD9DCC0BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/账号管理/账号管理新增',
	'fun',
	'7D166A5A3A164BB19BEA396812EE7110',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130422,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC1BDD2E050007F010069C5',
	'76C3EFD9DCBEBDD2E050007F010069C5',
	'PersonAccountManagement:update',
	'账号管理修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCBEBDD2E050007F010069C5/76C3EFD9DCC1BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/账号管理/账号管理修改',
	'fun',
	'7D166A5A3A164BB19BEA396812EE7110',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130423,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC2BDD2E050007F010069C5',
	'76C3EFD9DCBEBDD2E050007F010069C5',
	'PersonAccountManagement:delete',
	'账号管理删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCBEBDD2E050007F010069C5/76C3EFD9DCC2BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/账号管理/账号管理删除',
	'fun',
	'7D166A5A3A164BB19BEA396812EE7110',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130424,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC3BDD2E050007F010069C5',
	'76C3EFD9DCBEBDD2E050007F010069C5',
	'PersonAccountManagement:query',
	'账号管理查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCBEBDD2E050007F010069C5/76C3EFD9DCC3BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/账号管理/账号管理查询',
	'fun',
	'7D166A5A3A164BB19BEA396812EE7110',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130425,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC4BDD2E050007F010069C5',
	'76C3EFD9DCB1BDD2E050007F010069C5',
	'PersonLoginLimit',
	'登录限制',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCC4BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/登录限制',
	'fun',
	'A891BB9165904C48B3D6B73134CEB7E7',
	NULL,
	1,
	3,
	3130433,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC5BDD2E050007F010069C5',
	'76C3EFD9DCC4BDD2E050007F010069C5',
	'PersonLoginLimit:*',
	'登录限制所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCC4BDD2E050007F010069C5/76C3EFD9DCC5BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/登录限制/登录限制所有操作',
	'fun',
	'A891BB9165904C48B3D6B73134CEB7E7',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130434,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC6BDD2E050007F010069C5',
	'76C3EFD9DCC4BDD2E050007F010069C5',
	'PersonLoginLimit:create',
	'登录限制新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCC4BDD2E050007F010069C5/76C3EFD9DCC6BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/登录限制/登录限制新增',
	'fun',
	'A891BB9165904C48B3D6B73134CEB7E7',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130435,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC7BDD2E050007F010069C5',
	'76C3EFD9DCC4BDD2E050007F010069C5',
	'PersonLoginLimit:update',
	'登录限制修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCC4BDD2E050007F010069C5/76C3EFD9DCC7BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/登录限制/登录限制修改',
	'fun',
	'A891BB9165904C48B3D6B73134CEB7E7',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130436,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC8BDD2E050007F010069C5',
	'76C3EFD9DCC4BDD2E050007F010069C5',
	'PersonLoginLimit:delete',
	'登录限制删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCC4BDD2E050007F010069C5/76C3EFD9DCC8BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/登录限制/登录限制删除',
	'fun',
	'A891BB9165904C48B3D6B73134CEB7E7',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130437,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCC9BDD2E050007F010069C5',
	'76C3EFD9DCC4BDD2E050007F010069C5',
	'PersonLoginLimit:query',
	'登录限制查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCC4BDD2E050007F010069C5/76C3EFD9DCC9BDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/登录限制/登录限制查询',
	'fun',
	'A891BB9165904C48B3D6B73134CEB7E7',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130438,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCCABDD2E050007F010069C5',
	'76C3EFD9DCB1BDD2E050007F010069C5',
	'SecurityPolicyList',
	'安全策略',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCCABDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/安全策略',
	'fun',
	'F0362545AC424641BD3EB11BDBBDFB61',
	NULL,
	1,
	2,
	3130446,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCCBBDD2E050007F010069C5',
	'76C3EFD9DCCABDD2E050007F010069C5',
	'SecurityPolicyList:*',
	'安全策略所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCCABDD2E050007F010069C5/76C3EFD9DCCBBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/安全策略/安全策略所有操作',
	'fun',
	'F0362545AC424641BD3EB11BDBBDFB61',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3130447,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCCCBDD2E050007F010069C5',
	'76C3EFD9DCCABDD2E050007F010069C5',
	'SecurityPolicyList:create',
	'安全策略新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCCABDD2E050007F010069C5/76C3EFD9DCCCBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/安全策略/安全策略新增',
	'fun',
	'F0362545AC424641BD3EB11BDBBDFB61',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3130448,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCCDBDD2E050007F010069C5',
	'76C3EFD9DCCABDD2E050007F010069C5',
	'SecurityPolicyList:update',
	'安全策略修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCCABDD2E050007F010069C5/76C3EFD9DCCDBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/安全策略/安全策略修改',
	'fun',
	'F0362545AC424641BD3EB11BDBBDFB61',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3130449,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCCEBDD2E050007F010069C5',
	'76C3EFD9DCCABDD2E050007F010069C5',
	'SecurityPolicyList:delete',
	'安全策略删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCCABDD2E050007F010069C5/76C3EFD9DCCEBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/安全策略/安全策略删除',
	'fun',
	'F0362545AC424641BD3EB11BDBBDFB61',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3130450,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76C3EFD9DCCFBDD2E050007F010069C5',
	'76C3EFD9DCCABDD2E050007F010069C5',
	'SecurityPolicyList:query',
	'安全策略查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DCB1BDD2E050007F010069C5/76C3EFD9DCCABDD2E050007F010069C5/76C3EFD9DCCFBDD2E050007F010069C5',
	'/系统功能/协同平台/安全策略/安全策略/安全策略查询',
	'fun',
	'F0362545AC424641BD3EB11BDBBDFB61',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3130451,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76E7443571D18D7DE050007F010079F9',
	'76C3EFD9DC38BDD2E050007F010069C5',
	'DataManageBusiness',
	'管理权限业务类型定义',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76E7443571D18D7DE050007F010079F9',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限业务类型定义',
	'fun',
	'76E7443571D08D7DE050007F010079F9',
	NULL,
	1,
	5,
	3132716,
	'fun',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76E7443571D28D7DE050007F010079F9',
	'76E7443571D18D7DE050007F010079F9',
	'DataManageBusiness:*',
	'管理权限业务类型定义所有操作',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76E7443571D18D7DE050007F010079F9/76E7443571D28D7DE050007F010079F9',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限业务类型定义/管理权限业务类型定义所有操作',
	'fun',
	'76E7443571D08D7DE050007F010079F9',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3132717,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76E7443571D38D7DE050007F010079F9',
	'76E7443571D18D7DE050007F010079F9',
	'DataManageBusiness:create',
	'管理权限业务类型定义新增',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76E7443571D18D7DE050007F010079F9/76E7443571D38D7DE050007F010079F9',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限业务类型定义/管理权限业务类型定义新增',
	'fun',
	'76E7443571D08D7DE050007F010079F9',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3132718,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76E7443571D48D7DE050007F010079F9',
	'76E7443571D18D7DE050007F010079F9',
	'DataManageBusiness:update',
	'管理权限业务类型定义修改',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76E7443571D18D7DE050007F010079F9/76E7443571D48D7DE050007F010079F9',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限业务类型定义/管理权限业务类型定义修改',
	'fun',
	'76E7443571D08D7DE050007F010079F9',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3132719,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76E7443571D58D7DE050007F010079F9',
	'76E7443571D18D7DE050007F010079F9',
	'DataManageBusiness:delete',
	'管理权限业务类型定义删除',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76E7443571D18D7DE050007F010079F9/76E7443571D58D7DE050007F010079F9',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限业务类型定义/管理权限业务类型定义删除',
	'fun',
	'76E7443571D08D7DE050007F010079F9',
	'E3FB88A05FE749B08BF6D4D134084E5D',
	1,
	4,
	3132720,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'76E7443571D68D7DE050007F010079F9',
	'76E7443571D18D7DE050007F010079F9',
	'DataManageBusiness:query',
	'管理权限业务类型定义查询',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBEDBDD2E050007F010069C5/76C3EFD9DC38BDD2E050007F010069C5/76E7443571D18D7DE050007F010079F9/76E7443571D68D7DE050007F010079F9',
	'/系统功能/协同平台/组织权限/数据管理权限/管理权限业务类型定义/管理权限业务类型定义查询',
	'fun',
	'76E7443571D08D7DE050007F010079F9',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3132721,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'84BABAF3BC1D660BE050007F0100727E',
	'76C3EFD9DBB7BDD2E050007F010069C5',
	'1',
	'1',
	'/1/6000FDBFF674421E883D035966C60431/76C3EFD9DBB6BDD2E050007F010069C5/76C3EFD9DBB7BDD2E050007F010069C5/84BABAF3BC1D660BE050007F0100727E',
	'/系统功能/协同平台/系统配置/系统参数/1',
	'fun',
	'1289',
	NULL,
	1,
	7,
	3294504,
	'uiElement',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'90899797598D260BE050007F010039B5',
	'0',
	'remind:root',
	'消息提醒',
	'/90899797598D260BE050007F010039B5',
	'/消息提醒',
	'remind',
	NULL,
	NULL,
	1,
	1,
	3549502,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'90899797598E260BE050007F010039B5',
	'0',
	'businessclass:root',
	'业务分类',
	'/90899797598E260BE050007F010039B5',
	'/业务分类',
	'businessclass',
	NULL,
	NULL,
	1,
	1,
	3549504,
	'folder',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'970CB1E5FDC3432AB724A7A9D4989505',
	'5CA97EEC61324A5D8155933335CC9B4C',
	'reportAdmin:create',
	'报告管理新增',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C/970CB1E5FDC3432AB724A7A9D4989505',
	'/系统功能/协同平台/报告管理/报告管理新增',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3571026,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'AB870998B03D42FCA871417D77AA08BE',
	'5FF00C38293B4E2BBA94DD48122C691C',
	'hawtio:update',
	'性能检测修改',
	'/1/6000FDBFF674421E883D035966C60431/5FF00C38293B4E2BBA94DD48122C691C/AB870998B03D42FCA871417D77AA08BE',
	'/系统功能/协同平台/性能检测/性能检测修改',
	'fun',
	'97B71AB933674A47B99746511A4411F3',
	'1C7978FCC1CD4E4880E2A91B09DCAF7D',
	1,
	3,
	3579349,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'CB5D1729DBF44C7B8E480414758EDB98',
	'5CA97EEC61324A5D8155933335CC9B4C',
	'reportAdmin:*',
	'报告管理所有操作',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C/CB5D1729DBF44C7B8E480414758EDB98',
	'/系统功能/协同平台/报告管理/报告管理所有操作',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3571025,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'D6765FF67B0D41D0B9CEC62D1A7D775B',
	'5CA97EEC61324A5D8155933335CC9B4C',
	'reportAdmin:query',
	'报告管理查询',
	'/1/6000FDBFF674421E883D035966C60431/5CA97EEC61324A5D8155933335CC9B4C/D6765FF67B0D41D0B9CEC62D1A7D775B',
	'/系统功能/协同平台/报告管理/报告管理查询',
	'fun',
	'FAD26F9F461D47FD84596AFC782C34A2',
	'A0DAC625FBCF48F49AB9039BC746F196',
	1,
	6,
	3571029,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'EEC0CFAD9A5F4DB78FF17AFCD52364EB',
	'5FF00C38293B4E2BBA94DD48122C691C',
	'hawtio:create',
	'性能检测新增',
	'/1/6000FDBFF674421E883D035966C60431/5FF00C38293B4E2BBA94DD48122C691C/EEC0CFAD9A5F4DB78FF17AFCD52364EB',
	'/系统功能/协同平台/性能检测/性能检测新增',
	'fun',
	'97B71AB933674A47B99746511A4411F3',
	'E23D0E0EA7584311B048EED187DC1DA3',
	1,
	2,
	3579348,
	'permission',
NULL
	);
INSERT INTO `sa_oppermission`
VALUES
	(
	'FA3FE33A38B240F7AC1FDBB3AF3424C7',
	'5FF00C38293B4E2BBA94DD48122C691C',
	'hawtio:*',
	'性能检测所有操作',
	'/1/6000FDBFF674421E883D035966C60431/5FF00C38293B4E2BBA94DD48122C691C/FA3FE33A38B240F7AC1FDBB3AF3424C7',
	'/系统功能/协同平台/性能检测/性能检测所有操作',
	'fun',
	'97B71AB933674A47B99746511A4411F3',
	'C69E9314B8944B459B9C408A11C829D6',
	1,
	1,
	3579347,
	'permission',
NULL
	);-- ----------------------------
-- Table structure for sa_opperson
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opperson`;
CREATE TABLE `sa_opperson` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`LOGIN_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '登录名',
`PASSWORD` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '密码',
`PASSWORD_TIME_LIMIT` INT ( 11 ) NULL DEFAULT NULL COMMENT '密码时限',
`PASSWORD_MODIFY_TIME` datetime  NULL DEFAULT NULL COMMENT '密码修改时间',
`MAIN_ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`SEX` VARCHAR ( 12 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '性别',
`BIRTHDAY` datetime  NULL DEFAULT NULL COMMENT '出生日期',
`JOIN_DATE` datetime  NULL DEFAULT NULL COMMENT '参加工作日期',
`HOME_PLACE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '出生地',
`DEGREE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '学历',
`GRADUATE_SCHOOL` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '毕业院校',
`SPECIALITY` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '专业',
`SCHOOL_LENGTH` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '学年制',
`TITLE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职称',
`MARRIAGE` VARCHAR ( 12 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '婚姻状况',
`CERTIFICATE_NO` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '证件号码',
`CERTIFICATE_KIND_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '证件类型',
`FAMILY_ADDRESS` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '家庭住址',
`ZIP` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '邮编',
`MSN` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'Msn',
`QQ` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'QQ',
`EMAIL` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电子邮件',
`MOBILE_PHONE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '移动电话',
`FAMILY_PHONE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '家庭电话',
`OFFICE_PHONE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '办公电话',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`PHOTO_FILE_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '照片',
`COUNTRY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '国家',
`PROVINCE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '省',
`CITY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '市',
`ENGLISH_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '英文名称',
`PAY_PASSWORD` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '薪资密码',
`IS_OPERATOR` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否操作员',
`IS_HIDDEN` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否隐藏',
`WEIXIN` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信',
`NUM` INT ( 11 ) NULL DEFAULT NULL,
`SECURITY_GRADE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '密级',
`PERSON_SECURITY_GRADE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员涉密登记',
`CA_STATUS` INT ( 11 ) NULL DEFAULT NULL,
`CA_NO` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TENANT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '租户ID',
`PERSON_KIND` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员类别',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '人员' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opperson
-- ----------------------------
INSERT INTO `sa_opperson`
VALUES
	(
	'5B1A2386CCD9ECF9E050007F01003D30',
	'tester',
	'业务系统管理者',
	'tester',
	'E10ADC3949BA59ABBE56E057F20F883E',
	NULL,
	NULL,
	'C18E23AAAA6940E09DF7C122332C51E0',
	2,
	1,
	NULL,
	'0',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'5134011985120110034',
	'2',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'13112345678',
	NULL,
	NULL,
	310905,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2',
NULL
	);
INSERT INTO `sa_opperson`
VALUES
	(
	'5E17123168A376FFE050007F01006612',
	'bmld',
	'部门领导',
	'bmld',
	'E10ADC3949BA59ABBE56E057F20F883E',
	NULL,
	NULL,
	'C18E23AAAA6940E09DF7C122332C51E0',
	NULL,
	1,
	NULL,
	'0',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'510521199403062501',
	'1',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	302994,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2',
NULL
	);
INSERT INTO `sa_opperson`
VALUES
	(
	'5EEB2DC861694A65933CB4CE9A8D870A',
	'administrator',
	'系统管理员',
	'admin',
	'21232F297A57A5A743894A0E4A801FC3',
	NULL,
	NULL,
	'C18E23AAAA6940E09DF7C122332C51E0',
	2,
	1,
	NULL,
	'0',
	'2017-07-06 00:00:00',
	'2017-07-11 00:00:00',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'5113053265447892',
	NULL,
	NULL,
	NULL,
	NULL,
	'11111',
	NULL,
	NULL,
	NULL,
	NULL,
	3578120,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	1,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2',
NULL
	);
INSERT INTO `sa_opperson`
VALUES
	(
	'607BD4AFE1F64458ACD6E5A31C102E80',
	'user',
	'user',
	'user',
	'E10ADC3949BA59ABBE56E057F20F883E',
	NULL,
	NULL,
	'0CBF734CE4184AF382831398B108941B',
	NULL,
	1,
	NULL,
	'0',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	3562633,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'4E6571AA8ACB4F9C878D82DFCD2D91C2',
NULL
	);-- ----------------------------
-- Table structure for sa_opremind
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opremind`;
CREATE TABLE `sa_opremind` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ROLE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`REMIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色提醒授权' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_oprole
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oprole`;
CREATE TABLE `sa_oprole` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`ROLE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'fn 功能 data 数据',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`TENANT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '租户ID',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
`NODE_KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '节点类型',
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ROLE_PERSON_KIND` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员类别',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oprole
-- ----------------------------
INSERT INTO `sa_oprole`
VALUES
	(
	'1',
	'common',
	'JSS',
	'角色树',
	NULL,
	1,
	1,
	84172,
	'global',
	'0',
	'/1',
	'/角色树',
	1,
	'0',
NULL
	);
INSERT INTO `sa_oprole`
VALUES
	(
	'286',
	'common',
	'system',
	'系统角色',
	NULL,
	1,
	1,
	6138,
	'global',
	'1',
	'/1/286',
	'/角色树/系统角色',
	1,
	'4',
NULL
	);
INSERT INTO `sa_oprole`
VALUES
	(
	'298',
	'common',
	'001',
	'系统管理员',
	'001',
	1,
	3,
	18351,
	'global',
	'286',
	'/1/286/298',
	'/角色树/系统角色/系统管理员',
	2,
	'286',
NULL
	);
INSERT INTO `sa_oprole`
VALUES
	(
	'72F96FA8CE4AB346E050007F01006D6B',
	'common',
	'002',
	'系统维护',
	NULL,
	1,
	4,
	1918069,
	'global',
	'286',
	'/1/286/72F96FA8CE4AB346E050007F01006D6B',
	'/角色树/系统角色/系统维护',
	2,
	NULL,
NULL
	);-- ----------------------------
-- Table structure for sa_oprolepermission
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_oprolepermission`;
CREATE TABLE `sa_oprolepermission` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ROLE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERMISSION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_oprolepermission
-- ----------------------------
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DD8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130910 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DD9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130911 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DDAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '6000FDBFF674421E883D035966C60431', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130912 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DDBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130913 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DDCC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBCABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130914 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DDDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBDCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130915 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DDEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130916 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DDFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBBEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130917 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130918 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130919 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130920 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC57BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130921 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC5EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130922 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC5FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130923 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC65BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130924 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC6BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130925 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC71BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130926 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DE9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC77BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130927 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DEAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC59BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130928 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DEBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC83BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130929 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DECC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC7DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130930 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DEDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC26BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130931 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DEEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC27BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130932 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DEFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC15BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130933 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC1BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130934 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC21BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130935 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC2DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130936 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC33BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130937 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC07BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130938 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC08BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130939 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130940 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC0EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130941 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130942 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DF9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBFCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130943 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DFAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC02BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130944 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DFBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC39BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130945 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DFCC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC3ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130946 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DFDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC40BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130947 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DFEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC46BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130948 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561DFFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC4CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130949 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E00C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC52BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130950 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E01C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB91BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130951 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E02C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB92BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130952 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E03C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130953 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E04C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130954 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E05C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB99BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130955 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E06C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBABBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130956 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E07C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130957 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E08C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB9FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130958 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E09C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB7DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130959 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E0AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB7EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130960 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E0BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB84BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130961 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E0CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB72BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130962 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E0DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB78BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130963 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E0EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB8ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130964 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E0FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC96BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130965 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E10C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC97BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130966 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E11C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC98BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130967 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E12C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC9EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130968 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E13C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130969 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E14C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130970 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E15C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130971 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E16C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCABBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130972 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E1AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130976 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E1BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130977 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E1CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCCBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130978 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E1DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130979 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E1EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCBFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130980 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E1FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130981 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E20C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB64BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130982 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E21C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB65BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130983 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E22C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB6BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130984 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E23C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB5FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130985 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E24C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB59BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130986 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E25C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130987 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E26C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130988 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E27C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC4DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130989 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E28C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC7EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130990 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E29C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC53BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130991 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E2AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC13BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130992 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E2BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBEDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130993 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E2CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB93BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130994 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E2DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB97BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130995 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E2EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130996 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E2FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC28BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130997 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E30C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130998 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E31C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB98BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3130999 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E32C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC14BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131000 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E33C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB9ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131001 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E34C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131002 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E35C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBACBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131003 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E36C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC16BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131004 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E37C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131005 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E38C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131006 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E39C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131007 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E3AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC1CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131008 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E3BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC60BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131009 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E3CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB7FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131010 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E3DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB83BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131011 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E3EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC22BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131012 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E3FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB85BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131013 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E40C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC64BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131014 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E41C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB73BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131015 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E42C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC2EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131016 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E43C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB79BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131017 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E44C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBBFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131018 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E45C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB8BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131019 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E46C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC34BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131020 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E47C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC66BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131021 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E48C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBCBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131022 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E49C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC99BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131023 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E4AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC9DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131024 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E4BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC09BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131025 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E4CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC9FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131026 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E4DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131027 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E4EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC6CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131028 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E4FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131029 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E50C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131030 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E51C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCAABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131031 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E52C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131032 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E53C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCACBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131033 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E55C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC0FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131035 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E56C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC72BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131036 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E59C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131039 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E5BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131041 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E5CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBFDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131042 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E5DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCBABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131043 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E5EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCCABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131044 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E5FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC78BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131045 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E60C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCCCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131046 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E61C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC03BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131047 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E62C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131048 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E63C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131049 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E64C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131050 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E65C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC5ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131051 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E66C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131052 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E67C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC3BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131053 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E68C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC3FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131054 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E69C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB66BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131055 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E6AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB6ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131056 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E6BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBDDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131057 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E6CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB6CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131058 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E6DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC41BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131059 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E6EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB60BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131060 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E6FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC84BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131061 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E70C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB5ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131062 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E71C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC47BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131063 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E72C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB8FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131064 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E73C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131065 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E74C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131066 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E75C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB74BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131067 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E76C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC1DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131068 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E77C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC3CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131069 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E78C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB7ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131070 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E79C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC79BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131071 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E7AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBCCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131072 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E7BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB8CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131073 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E7CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC23BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131074 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E7DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC42BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131075 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E7EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC45BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131076 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E7FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC61BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131077 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E80C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC9ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131078 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E81C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC5BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131079 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E82C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC48BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131080 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E83C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC2FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131081 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E84C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131082 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E85C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131083 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E86C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC4EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131084 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E87C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131085 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E88C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC35BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131086 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E89C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131087 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E8AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC54BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131088 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E8BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB90BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131089 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E8CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBEEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131090 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E8DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCADBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131091 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E8EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC85BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131092 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E8FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131093 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E90C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB94BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131094 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E91C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC67BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131095 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E93C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC0ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131097 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E94C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC7FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131098 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E95C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC6ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131099 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E97C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131101 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E98C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBBABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131102 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E99C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131103 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E9AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCBBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131104 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E9BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC0DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131105 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E9CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB9BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131106 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E9DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBAABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131107 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E9EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCCDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131108 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561E9FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131109 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBEABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131110 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC6DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131111 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131112 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBADBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131113 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC10BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131114 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131115 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC29BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131116 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131117 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131118 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EA9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131119 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EAAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131120 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EABC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131121 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EACC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB67BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131122 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EADC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBDEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131123 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EAEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC73BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131124 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EAFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBFEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131125 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB6DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131126 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB5EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131127 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB80BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131128 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC17BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131129 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB61BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131130 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC1ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131131 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC04BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131132 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB5BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131133 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB86BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131134 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EB9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC6EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131135 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EBAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC24BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131136 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EBBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC70BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131137 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EBCC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131138 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EBDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131139 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EBEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBFFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131140 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EBFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBDBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131141 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC80BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131142 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC30BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131143 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131144 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB9CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131145 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC05BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131146 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC38BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131147 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131148 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCAEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131149 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC62BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131150 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EC9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBAEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131151 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ECAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131152 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ECBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC74BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131153 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ECCC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC36BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131154 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ECEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC3DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131156 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ECFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131157 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131158 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBBBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131159 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC2ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131161 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131162 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB70BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131163 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131164 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCBCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131165 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC43BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131166 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561ED9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC7ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131167 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EDAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC0BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131168 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EDBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB81BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131169 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EDCC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCCEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131170 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EDDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBEBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131171 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EDEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC68BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131172 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EDFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC49BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131173 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC4BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131174 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131175 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCBEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131176 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB87BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131177 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC18BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131178 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB71BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131179 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131180 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131181 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131182 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EE9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC4FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131183 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EEAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131184 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EEBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB75BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131185 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EECC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC5CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131186 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EEDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131187 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EEEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBCDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131188 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EEFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB68BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131189 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF0C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB7BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131190 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF1C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC55BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131191 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF2C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC1EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131192 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF3C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC11BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131193 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF4C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB6EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131194 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF5C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB8DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131195 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF6C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBEFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131196 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF7C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC20BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131197 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF8C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBDFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131198 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EF9C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB62BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131199 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EFAC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB58BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131200 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EFBC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB95BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131201 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EFCC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC86BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131202 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EFDC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC9BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131203 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EFEC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB5CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131204 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561EFFC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131205 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F00C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC2CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131206 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F01C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC88BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131207 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F02C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC51BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131208 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F03C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC76BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131209 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F04C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBCFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131210 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F05C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB77BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131211 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F06C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131212 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F07C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBFBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131213 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F08C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC87BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131214 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F09C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC75BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131215 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F0BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131217 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F0CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB88BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131218 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F0DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC06BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131219 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F0EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB96BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131220 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F0FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC69BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131221 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F11C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131223 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F12C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC0CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131224 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F13C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC1FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131225 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F14C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBBCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131226 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F15C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB76BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131227 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F16C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC81BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131228 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F17C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCBDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131229 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F18C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBBDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131230 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F19C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131231 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F1AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC3EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131232 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F1BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBDABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131233 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F1CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB7CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131234 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F1DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCCFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131235 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F1EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBFABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131236 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F1FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC7BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131237 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F20C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC25BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131238 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F21C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB9DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131239 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F22C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB8EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131240 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F23C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131241 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F24C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131242 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F25C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC44BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131243 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F26C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBCEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131244 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F27C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC6FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131245 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F28C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC12BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131246 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F29C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCC3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131247 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F2AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBAFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131248 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F2BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC2BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131249 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F2CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC9CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131250 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F2DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC63BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131251 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F2EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC4ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131252 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F2FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCB7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131253 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F30C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC31BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131254 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F31C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC32BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131255 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F32C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBB5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131256 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F33C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131257 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F34C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB9EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131258 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F35C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB69BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131259 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F36C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC5DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131260 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F37C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBF4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131261 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F38C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBC8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131262 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F39C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC50BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131263 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F3AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBA3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131264 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F3BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB6FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131265 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F3CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCA9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131266 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F3DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131267 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F3EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBECBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131268 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F3FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC37BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131269 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F40C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC19BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131270 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F41C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB63BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131271 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F42C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC00BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131272 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F43C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DCAFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131273 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F44C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC56BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131274 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F45C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB82BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131275 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F46C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC01BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131276 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F47C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB5DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131277 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F48C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131278 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F49C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC58BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131279 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F4AC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB57BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131280 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F4BC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131281 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F4CC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC82BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131282 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F4DC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBD5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131283 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F4EC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DBE7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131284 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F4FC143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DC7CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131285 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F50C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '76C3EFD9DB89BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131286 );
INSERT INTO `sa_oprolepermission`
VALUES
	( '76C3FD561F51C143E050007F01006A31', '72F96FA8CE4AB346E050007F01006D6B', '6000FDBFF674421E883D035966C60431', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2018-09-26 17:39:05', '系统管理员', 3131287 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbea461130f111ea826a00fff30e9800', '298', '76C3EFD9DB64BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbeb27c030f111ea826a00fff30e9800', '298', '76C3EFD9DBDCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbebf35030f111ea826a00fff30e9800', '298', '76C3EFD9DC08BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbecb7d730f111ea826a00fff30e9800', '298', '76C3EFD9DC07BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbed7b5630f111ea826a00fff30e9800', '298', '76C3EFD9DBB1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbee4e5230f111ea826a00fff30e9800', '298', '76C3EFD9DC2DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbef1d2d30f111ea826a00fff30e9800', '298', '76C3EFD9DC6BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbefebc430f111ea826a00fff30e9800', '298', '76C3EFD9DCBFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf0cf9430f111ea826a00fff30e9800', '298', '76C3EFD9DC52BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf19c0230f111ea826a00fff30e9800', '298', '76C3EFD9DBE8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf2720430f111ea826a00fff30e9800', '298', '76C3EFD9DB9FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf3824730f111ea826a00fff30e9800', '298', '76C3EFD9DC59BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf4578230f111ea826a00fff30e9800', '298', '76C3EFD9DB84BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf5336d30f111ea826a00fff30e9800', '298', '76C3EFD9DCB8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf62b6d30f111ea826a00fff30e9800', '298', '76C3EFD9DBBEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf6ff7530f111ea826a00fff30e9800', '298', '76C3EFD9DBA4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf7f05e30f111ea826a00fff30e9800', '298', '76C3EFD9DB78BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf8e5df30f111ea826a00fff30e9800', '298', '76C3EFD9DCB9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbf9b54b30f111ea826a00fff30e9800', '298', '76C3EFD9DB65BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbfa922730f111ea826a00fff30e9800', '298', '76C3EFD9DCA5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbfb610c30f111ea826a00fff30e9800', '298', '76C3EFD9DB7DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbfc2e6f30f111ea826a00fff30e9800', '298', '76C3EFD9DC40BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbfd0e6630f111ea826a00fff30e9800', '298', '76C3EFD9DBB7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbfdd00330f111ea826a00fff30e9800', '298', '76C3EFD9DC02BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbfe991230f111ea826a00fff30e9800', '298', '76C3EFD9DC4CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dbff6af830f111ea826a00fff30e9800', '298', '76C3EFD9DC0EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc00377c30f111ea826a00fff30e9800', '298', '76C3EFD9DC97BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc00fe8530f111ea826a00fff30e9800', '298', '76C3EFD9DCCBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc01c5a530f111ea826a00fff30e9800', '298', '76C3EFD9DB99BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc02969530f111ea826a00fff30e9800', '298', '76C3EFD9DBE2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc035ef030f111ea826a00fff30e9800', '298', '76C3EFD9DBABBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0424ef30f111ea826a00fff30e9800', '298', '76C3EFD9DC39BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc05034730f111ea826a00fff30e9800', '298', '76C3EFD9DC15BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc05e92630f111ea826a00fff30e9800', '298', '76C3EFD9DBB6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc06ce7e30f111ea826a00fff30e9800', '298', '76C3EFD9DB91BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc07bc4130f111ea826a00fff30e9800', '298', '76C3EFD9DBA5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc08ee1a30f111ea826a00fff30e9800', '298', '76C3EFD9DC96BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc09f98f30f111ea826a00fff30e9800', '298', '76C3EFD9DC71BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0ad0e030f111ea826a00fff30e9800', '298', '76C3EFD9DBFCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0ba7c630f111ea826a00fff30e9800', '298', '76E7443571D28D7DE050007F010079F9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0c7f3c30f111ea826a00fff30e9800', '298', '76C3EFD9DCA3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0d4e8c30f111ea826a00fff30e9800', '298', '76C3EFD9DB6BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0e238a30f111ea826a00fff30e9800', '298', '76C3EFD9DC46BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc0fc8df30f111ea826a00fff30e9800', '298', '76C3EFD9DC5EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc10901b30f111ea826a00fff30e9800', '298', '76C3EFD9DB5FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1191ca30f111ea826a00fff30e9800', '298', '76C3EFD9DC57BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc12688930f111ea826a00fff30e9800', '298', '76C3EFD9DB92BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc133a6c30f111ea826a00fff30e9800', '298', '76C3EFD9DB8ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc142e2c30f111ea826a00fff30e9800', '298', '76C3EFD9DC1BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc14fbe630f111ea826a00fff30e9800', '298', '76C3EFD9DCC5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc15d60830f111ea826a00fff30e9800', '298', '76C3EFD9DC33BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc16b3d830f111ea826a00fff30e9800', '298', '76C3EFD9DBF0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc17888b30f111ea826a00fff30e9800', '298', '76C3EFD9DC65BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1870ba30f111ea826a00fff30e9800', '298', '76C3EFD9DBB8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc196e2530f111ea826a00fff30e9800', '298', '76C3EFD9DBF6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1a36dd30f111ea826a00fff30e9800', '298', '76C3EFD9DBC4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1af31230f111ea826a00fff30e9800', '298', '76C3EFD9DB59BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1bb4ed30f111ea826a00fff30e9800', '298', '76C3EFD9DC26BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1c5b4230f111ea826a00fff30e9800', '298', '76C3EFD9DBD0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1cfbea30f111ea826a00fff30e9800', '298', '76C3EFD9DB7EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1db4af30f111ea826a00fff30e9800', '298', '76C3EFD9DBD6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1e762d30f111ea826a00fff30e9800', '298', '76C3EFD9DC7DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1f2ee430f111ea826a00fff30e9800', '298', '76C3EFD9DC77BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc1ff02330f111ea826a00fff30e9800', '298', '76C3EFD9DB72BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc20c8c730f111ea826a00fff30e9800', '298', '76C3EFD9DC27BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc21779230f111ea826a00fff30e9800', '298', '76C3EFD9DC3ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2221f930f111ea826a00fff30e9800', '298', '76C3EFD9DCB3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc22bc9330f111ea826a00fff30e9800', '298', '76C3EFD9DC21BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc23521b30f111ea826a00fff30e9800', '298', '76C3EFD9DC9EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc23f22030f111ea826a00fff30e9800', '298', '76C3EFD9DBCABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc24b74630f111ea826a00fff30e9800', '298', '76C3EFD9DCABBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc25905830f111ea826a00fff30e9800', '298', '76C3EFD9DC98BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2676fa30f111ea826a00fff30e9800', '298', '76C3EFD9DC5FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc276d1230f111ea826a00fff30e9800', '298', '76C3EFD9DCA4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc28a02a30f111ea826a00fff30e9800', '298', '76C3EFD9DC83BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc29938230f111ea826a00fff30e9800', '298', '76C3EFD9DB79BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2ad0ad30f111ea826a00fff30e9800', '298', '76C3EFD9DC60BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2c013030f111ea826a00fff30e9800', '298', '76C3EFD9DC72BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2cde3e30f111ea826a00fff30e9800', '298', '76C3EFD9DBC5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2d904930f111ea826a00fff30e9800', '298', '76C3EFD9DB66BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc2e2f4c30f111ea826a00fff30e9800', '298', '76C3EFD9DB6CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc383e4530f111ea826a00fff30e9800', '298', '76C3EFD9DC4DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc38eb9e30f111ea826a00fff30e9800', '298', '76C3EFD9DBD1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc399cb530f111ea826a00fff30e9800', '298', '76C3EFD9DC9FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3a267d30f111ea826a00fff30e9800', '298', '76C3EFD9DC09BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3ab36830f111ea826a00fff30e9800', '298', '76C3EFD9DC64BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3b5fff30f111ea826a00fff30e9800', '298', '76C3EFD9DBDDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3c18e730f111ea826a00fff30e9800', '298', '76C3EFD9DCAABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3ce2af30f111ea826a00fff30e9800', '298', '76C3EFD9DBFDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3d95e130f111ea826a00fff30e9800', '298', '76C3EFD9DC5ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3e506a30f111ea826a00fff30e9800', '298', '76C3EFD9DCACBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3f2c7830f111ea826a00fff30e9800', '298', '76C3EFD9DBB9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc3ffdb330f111ea826a00fff30e9800', '298', '76C3EFD9DB7FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc40f5a630f111ea826a00fff30e9800', '298', '76C3EFD9DBA0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc44a42930f111ea826a00fff30e9800', '298', '76C3EFD9DCC6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4562aa30f111ea826a00fff30e9800', '298', '76C3EFD9DB6ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc460f3d30f111ea826a00fff30e9800', '298', '76C3EFD9DCA6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc46ccf830f111ea826a00fff30e9800', '298', '76C3EFD9DC22BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc47813730f111ea826a00fff30e9800', '298', '76C3EFD9DB85BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc482dd530f111ea826a00fff30e9800', '298', '76C3EFD9DBA6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc48e21830f111ea826a00fff30e9800', '298', '76C3EFD9DCB4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc49a8c830f111ea826a00fff30e9800', '298', '76C3EFD9DC47BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4a5ee530f111ea826a00fff30e9800', '298', '76C3EFD9DB9ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4b0cf130f111ea826a00fff30e9800', '298', '76C3EFD9DC3BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4bcad730f111ea826a00fff30e9800', '298', '76C3EFD9DC78BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4c7e7e30f111ea826a00fff30e9800', '298', '76C3EFD9DBB2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4d31c830f111ea826a00fff30e9800', '298', '76C3EFD9DC3FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4de87a30f111ea826a00fff30e9800', '298', '76C3EFD9DBF5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4eadfe30f111ea826a00fff30e9800', '298', '76C3EFD9DC7EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc4f64b530f111ea826a00fff30e9800', '298', '76C3EFD9DC34BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc501f0d30f111ea826a00fff30e9800', '298', '76C3EFD9DCC0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc50e8b830f111ea826a00fff30e9800', '298', '76C3EFD9DBE9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc51ab5730f111ea826a00fff30e9800', '298', '76C3EFD9DB8BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc526d3f30f111ea826a00fff30e9800', '298', '76E7443571D38D7DE050007F010079F9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc533c1530f111ea826a00fff30e9800', '298', '76C3EFD9DC13BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5403c530f111ea826a00fff30e9800', '298', '76C3EFD9DC9DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc54c56830f111ea826a00fff30e9800', '298', '76C3EFD9DB5ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc557efa30f111ea826a00fff30e9800', '298', '76C3EFD9DBD7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5648b330f111ea826a00fff30e9800', '298', '76C3EFD9DB60BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc57168730f111ea826a00fff30e9800', '298', '76C3EFD9DBEDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc57c95c30f111ea826a00fff30e9800', '298', '76C3EFD9DCCCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc58900b30f111ea826a00fff30e9800', '298', '76C3EFD9DC1CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc594f1e30f111ea826a00fff30e9800', '298', '76C3EFD9DC66BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5a079a30f111ea826a00fff30e9800', '298', '76C3EFD9DC03BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5abe5330f111ea826a00fff30e9800', '298', '76C3EFD9DC84BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5b861330f111ea826a00fff30e9800', '298', '76C3EFD9DBBFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5c595030f111ea826a00fff30e9800', '298', '76C3EFD9DC41BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5d256530f111ea826a00fff30e9800', '298', '76C3EFD9DB97BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5dfc7430f111ea826a00fff30e9800', '298', '76C3EFD9DBACBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5ec1c630f111ea826a00fff30e9800', '298', '76C3EFD9DBCBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc5f7d0130f111ea826a00fff30e9800', '298', '76C3EFD9DC14BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc604f2230f111ea826a00fff30e9800', '298', '76C3EFD9DB93BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc611bfd30f111ea826a00fff30e9800', '298', '76C3EFD9DBF7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc61dcc530f111ea826a00fff30e9800', '298', '76C3EFD9DC2EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc62c42730f111ea826a00fff30e9800', '298', '76C3EFD9DB98BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc638d0b30f111ea826a00fff30e9800', '298', '76C3EFD9DC6CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6448f130f111ea826a00fff30e9800', '298', '76C3EFD9DBC3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc650d8530f111ea826a00fff30e9800', '298', '76C3EFD9DC99BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc65ebfe30f111ea826a00fff30e9800', '298', '76C3EFD9DC53BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc66b40c30f111ea826a00fff30e9800', '298', '76C3EFD9DCBABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc67b06f30f111ea826a00fff30e9800', '298', '76C3EFD9DB73BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc69e0f430f111ea826a00fff30e9800', '298', '76C3EFD9DC28BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6abbb530f111ea826a00fff30e9800', '298', '76C3EFD9DCCABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6b740330f111ea826a00fff30e9800', '298', '76C3EFD9DBE3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6c2d8a30f111ea826a00fff30e9800', '298', '76C3EFD9DB83BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6ceefd30f111ea826a00fff30e9800', '298', '76C3EFD9DBF1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6da68d30f111ea826a00fff30e9800', '298', '76C3EFD9DC0FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6e5b9a30f111ea826a00fff30e9800', '298', '76C3EFD9DC16BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6f14a830f111ea826a00fff30e9800', '298', '76C3EFD9DC67BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc6fe02a30f111ea826a00fff30e9800', '298', '76C3EFD9DBADBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7094f930f111ea826a00fff30e9800', '298', '76C3EFD9DC54BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7153f730f111ea826a00fff30e9800', '298', '76C3EFD9DB74BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc721a4e30f111ea826a00fff30e9800', '298', '76C3EFD9DC61BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc72da0030f111ea826a00fff30e9800', '298', '76C3EFD9DCA7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc73f50f30f111ea826a00fff30e9800', '298', '76C3EFD9DCCDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc74bc3d30f111ea826a00fff30e9800', '298', '76C3EFD9DCBBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc75754930f111ea826a00fff30e9800', '298', '76C3EFD9DC85BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc76398630f111ea826a00fff30e9800', '298', '76C3EFD9DC9ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc77114a30f111ea826a00fff30e9800', '298', '76C3EFD9DC29BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc77df6730f111ea826a00fff30e9800', '298', '76C3EFD9DC2FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc789ed030f111ea826a00fff30e9800', '298', '76C3EFD9DC04BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc79675e30f111ea826a00fff30e9800', '298', '76C3EFD9DBD8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7a325630f111ea826a00fff30e9800', '298', '76C3EFD9DBE4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7b169730f111ea826a00fff30e9800', '298', '76C3EFD9DC0DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7beca530f111ea826a00fff30e9800', '298', '76C3EFD9DBB3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7cc7bd30f111ea826a00fff30e9800', '298', '76C3EFD9DBAABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc7d9c2330f111ea826a00fff30e9800', '298', '76C3EFD9DB5EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8240f230f111ea826a00fff30e9800', '298', '76C3EFD9DC73BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8308e930f111ea826a00fff30e9800', '298', '76C3EFD9DBCCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc83f9e730f111ea826a00fff30e9800', '298', '76C3EFD9DC35BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc84f1fb30f111ea826a00fff30e9800', '298', '76C3EFD9DBA7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc85b85330f111ea826a00fff30e9800', '298', '76C3EFD9DBEABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8686ac30f111ea826a00fff30e9800', '298', '76C3EFD9DCC4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc87615830f111ea826a00fff30e9800', '298', '76C3EFD9DB86BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8816b230f111ea826a00fff30e9800', '298', '76E7443571D48D7DE050007F010079F9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc88ec0730f111ea826a00fff30e9800', '298', '76C3EFD9DB94BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8989b830f111ea826a00fff30e9800', '298', '76C3EFD9DC45BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8a1c0730f111ea826a00fff30e9800', '298', '76C3EFD9DC0ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8ac06930f111ea826a00fff30e9800', '298', '76C3EFD9DC42BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8b638830f111ea826a00fff30e9800', '298', '76C3EFD9DC79BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8d40a330f111ea826a00fff30e9800', '298', '76C3EFD9DCC1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8e009830f111ea826a00fff30e9800', '298', '76C3EFD9DCA0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8eb5d830f111ea826a00fff30e9800', '298', '76C3EFD9DB80BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc8f6cbd30f111ea826a00fff30e9800', '298', '76C3EFD9DC4EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc907c2530f111ea826a00fff30e9800', '298', '76C3EFD9DBD2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc91448c30f111ea826a00fff30e9800', '298', '76C3EFD9DC48BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc920af330f111ea826a00fff30e9800', '298', '76C3EFD9DC6DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc92d87430f111ea826a00fff30e9800', '298', '76C3EFD9DBBABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc93b8c430f111ea826a00fff30e9800', '298', '76C3EFD9DBF8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc94e12430f111ea826a00fff30e9800', '298', '76C3EFD9DB9BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc95e4cf30f111ea826a00fff30e9800', '298', '76C3EFD9DBDEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc96c8f030f111ea826a00fff30e9800', '298', '76C3EFD9DC10BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc97868530f111ea826a00fff30e9800', '298', '76C3EFD9DBC0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc9beaf530f111ea826a00fff30e9800', '298', '76C3EFD9DC23BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc9e6aaf30f111ea826a00fff30e9800', '298', '76C3EFD9DB6DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dc9f53f230f111ea826a00fff30e9800', '298', '76C3EFD9DB7ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca0007b30f111ea826a00fff30e9800', '298', '76C3EFD9DC1DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca0d43c30f111ea826a00fff30e9800', '298', '76C3EFD9DC7FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca1525e30f111ea826a00fff30e9800', '298', '76C3EFD9DB67BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca1d06330f111ea826a00fff30e9800', '298', '76C3EFD9DB8FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca25e6130f111ea826a00fff30e9800', '298', '76C3EFD9DC5BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca2e4aa30f111ea826a00fff30e9800', '298', '76C3EFD9DBFEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca3687330f111ea826a00fff30e9800', '298', '76C3EFD9DBEEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca3dcda30f111ea826a00fff30e9800', '298', '76C3EFD9DB61BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca45a0d30f111ea826a00fff30e9800', '298', '76C3EFD9DBC9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dca4e13330f111ea826a00fff30e9800', '298', '76C3EFD9DCADBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcaa2a7430f111ea826a00fff30e9800', '298', '76C3EFD9DBC6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcaaa13130f111ea826a00fff30e9800', '298', '76C3EFD9DC17BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcab0c9830f111ea826a00fff30e9800', '298', '76C3EFD9DB5BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcab83c530f111ea826a00fff30e9800', '298', '76C3EFD9DC6ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcac342830f111ea826a00fff30e9800', '298', '76C3EFD9DBA1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcace92930f111ea826a00fff30e9800', '298', '76C3EFD9DCC7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcad997c30f111ea826a00fff30e9800', '298', '76C3EFD9DCB5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcae4dad30f111ea826a00fff30e9800', '298', '76C3EFD9DB8CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcaf1f9930f111ea826a00fff30e9800', '298', '76C3EFD9DC1ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcafd37130f111ea826a00fff30e9800', '298', '76C3EFD9DB90BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb086f130f111ea826a00fff30e9800', '298', '76C3EFD9DBF2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb13a5130f111ea826a00fff30e9800', '298', '76C3EFD9DC3CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb2207330f111ea826a00fff30e9800', '298', '76C3EFD9DBA2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb4c13930f111ea826a00fff30e9800', '298', '76C3EFD9DBCDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb57d7130f111ea826a00fff30e9800', '298', '76C3EFD9DBF3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb6355a30f111ea826a00fff30e9800', '298', '76C3EFD9DB71BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb6fb3b30f111ea826a00fff30e9800', '298', '76C3EFD9DC6EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb7aedf30f111ea826a00fff30e9800', '298', '76C3EFD9DC4BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb860d130f111ea826a00fff30e9800', '298', '76C3EFD9DC55BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb92d2b30f111ea826a00fff30e9800', '298', '76C3EFD9DC80BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcb9e9a930f111ea826a00fff30e9800', '298', '76C3EFD9DC9BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcba9a0430f111ea826a00fff30e9800', '298', '76C3EFD9DC62BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcbb595730f111ea826a00fff30e9800', '298', '76C3EFD9DC0BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcbc1f2930f111ea826a00fff30e9800', '298', '76C3EFD9DCBCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcbced9530f111ea826a00fff30e9800', '298', '76C3EFD9DC68BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcbda36430f111ea826a00fff30e9800', '298', '76C3EFD9DC7ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc13bde30f111ea826a00fff30e9800', '298', '76C3EFD9DB81BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc1dc9730f111ea826a00fff30e9800', '298', '76C3EFD9DBAEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc27bdc30f111ea826a00fff30e9800', '298', '76C3EFD9DBBBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc31d5d30f111ea826a00fff30e9800', '298', '76C3EFD9DC1EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc3b2f930f111ea826a00fff30e9800', '298', '76C3EFD9DBB4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc48b3230f111ea826a00fff30e9800', '298', '76C3EFD9DB87BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc5427d30f111ea826a00fff30e9800', '298', '76C3EFD9DC4FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc5df7530f111ea826a00fff30e9800', '298', '76C3EFD9DB5CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc6706530f111ea826a00fff30e9800', '298', '76C3EFD9DBC1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc7059430f111ea826a00fff30e9800', '298', '76C3EFD9DB58BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc7b22230f111ea826a00fff30e9800', '298', '76C3EFD9DBD3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc8678830f111ea826a00fff30e9800', '298', '76C3EFD9DCC2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcc91d9b30f111ea826a00fff30e9800', '298', '76C3EFD9DB9CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcca5eef30f111ea826a00fff30e9800', '298', '76C3EFD9DC18BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dccb4e6930f111ea826a00fff30e9800', '298', '76C3EFD9DBA8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dccc023330f111ea826a00fff30e9800', '298', '76C3EFD9DC5CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcccb22730f111ea826a00fff30e9800', '298', '76C3EFD9DC38BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dccd777c30f111ea826a00fff30e9800', '298', '76C3EFD9DCBEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcce2d7630f111ea826a00fff30e9800', '298', '76C3EFD9DBF9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dccee0f130f111ea826a00fff30e9800', '298', '76C3EFD9DC36BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dccf8b6830f111ea826a00fff30e9800', '298', '76C3EFD9DC24BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd0515e30f111ea826a00fff30e9800', '298', '76E7443571D58D7DE050007F010079F9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd0fca730f111ea826a00fff30e9800', '298', '76C3EFD9DCB6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd1a96f30f111ea826a00fff30e9800', '298', '76C3EFD9DB62BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd2601530f111ea826a00fff30e9800', '298', '76C3EFD9DBD9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd31b5d30f111ea826a00fff30e9800', '298', '76C3EFD9DB7BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd49d1030f111ea826a00fff30e9800', '298', '76C3EFD9DC74BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd5669c30f111ea826a00fff30e9800', '298', '76C3EFD9DBDBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd60cae30f111ea826a00fff30e9800', '298', '76C3EFD9DCCEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd6b43730f111ea826a00fff30e9800', '298', '76C3EFD9DC86BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd7745a30f111ea826a00fff30e9800', '298', '76C3EFD9DC70BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd8347630f111ea826a00fff30e9800', '298', '76C3EFD9DC20BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd8e12030f111ea826a00fff30e9800', '298', '76C3EFD9DC2ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcd991b630f111ea826a00fff30e9800', '298', '76C3EFD9DCA1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcda5e6c30f111ea826a00fff30e9800', '298', '76C3EFD9DBDFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcdb159830f111ea826a00fff30e9800', '298', '76C3EFD9DC30BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcdbc6a530f111ea826a00fff30e9800', '298', '76C3EFD9DB8DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcdc859a30f111ea826a00fff30e9800', '298', '76C3EFD9DC11BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcdd493530f111ea826a00fff30e9800', '298', '76C3EFD9DB68BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcde8eb330f111ea826a00fff30e9800', '298', '76C3EFD9DBC7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcdf4c9430f111ea826a00fff30e9800', '298', '76C3EFD9DBFFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcdff92830f111ea826a00fff30e9800', '298', '76C3EFD9DC49BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dce09e9630f111ea826a00fff30e9800', '298', '76C3EFD9DB70BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dce14b8b30f111ea826a00fff30e9800', '298', '76C3EFD9DBEFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dce8c75030f111ea826a00fff30e9800', '298', '76C3EFD9DBE5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dce9c0f530f111ea826a00fff30e9800', '298', '76C3EFD9DBEBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcea885e30f111ea826a00fff30e9800', '298', '76C3EFD9DCAEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dceb444130f111ea826a00fff30e9800', '298', '76C3EFD9DC3DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcec14d930f111ea826a00fff30e9800', '298', '76C3EFD9DB95BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcecce5630f111ea826a00fff30e9800', '298', '76C3EFD9DB75BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dced840430f111ea826a00fff30e9800', '298', '76C3EFD9DCA8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcee3c5030f111ea826a00fff30e9800', '298', '76C3EFD9DC05BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcef13fc30f111ea826a00fff30e9800', '298', '76C3EFD9DB6EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcefc85930f111ea826a00fff30e9800', '298', '76C3EFD9DCC8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf076e930f111ea826a00fff30e9800', '298', '76C3EFD9DBB0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf13ac530f111ea826a00fff30e9800', '298', '76C3EFD9DC43BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf1e96130f111ea826a00fff30e9800', '298', '76C3EFD9DC88BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf29f0a30f111ea826a00fff30e9800', '298', '76E7443571D18D7DE050007F010079F9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf347f530f111ea826a00fff30e9800', '298', '76C3EFD9DB77BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf3fc5630f111ea826a00fff30e9800', '298', '76C3EFD9DBFBBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf4a67730f111ea826a00fff30e9800', '298', '76C3EFD9DC51BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf54ee030f111ea826a00fff30e9800', '298', '76C3EFD9DC2CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf5f8ae30f111ea826a00fff30e9800', '298', '76C3EFD9DBCFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf6acdd30f111ea826a00fff30e9800', '298', '76C3EFD9DCB2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf7572c30f111ea826a00fff30e9800', '298', '76C3EFD9DC76BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf807e430f111ea826a00fff30e9800', '298', '76C3EFD9DC1FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf8c9de30f111ea826a00fff30e9800', '298', '76C3EFD9DC31BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcf975e930f111ea826a00fff30e9800', '298', '76C3EFD9DCB1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfa203630f111ea826a00fff30e9800', '298', '76C3EFD9DBFABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfac53b30f111ea826a00fff30e9800', '298', '76C3EFD9DB7CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfb81fe30f111ea826a00fff30e9800', '298', '76C3EFD9DC01BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfc350830f111ea826a00fff30e9800', '298', '76C3EFD9DBA9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfcdbba30f111ea826a00fff30e9800', '298', '76C3EFD9DC2BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfdb31030f111ea826a00fff30e9800', '298', '76C3EFD9DCBDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcfe6b2230f111ea826a00fff30e9800', '298', '76C3EFD9DC3EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcff2fdb30f111ea826a00fff30e9800', '298', '76C3EFD9DCA2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dcffd43b30f111ea826a00fff30e9800', '298', '76C3EFD9DC06BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd00976730f111ea826a00fff30e9800', '298', '76C3EFD9DC63BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd014a0a30f111ea826a00fff30e9800', '298', '76C3EFD9DC5DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd01f7dd30f111ea826a00fff30e9800', '298', '76C3EFD9DC87BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd02a5c830f111ea826a00fff30e9800', '298', '76C3EFD9DC25BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd03564130f111ea826a00fff30e9800', '298', '76C3EFD9DC69BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd03fc1530f111ea826a00fff30e9800', '298', '76C3EFD9DC50BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd049bf130f111ea826a00fff30e9800', '298', '76C3EFD9DBC8BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd05497830f111ea826a00fff30e9800', '298', '76C3EFD9DBD4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd06113f30f111ea826a00fff30e9800', '298', '76C3EFD9DB88BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd06c15230f111ea826a00fff30e9800', '298', '76C3EFD9DC00BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd077d5d30f111ea826a00fff30e9800', '298', '76C3EFD9DC6FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd08fe0c30f111ea826a00fff30e9800', '298', '76E7443571D68D7DE050007F010079F9', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd099c9730f111ea826a00fff30e9800', '298', '76C3EFD9DBBCBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0a365c30f111ea826a00fff30e9800', '298', '76C3EFD9DC56BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0ae32530f111ea826a00fff30e9800', '298', '76C3EFD9DBC2BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0b804d30f111ea826a00fff30e9800', '298', '76C3EFD9DCAFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0c1f3830f111ea826a00fff30e9800', '298', '76C3EFD9DCCFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0cbf9b30f111ea826a00fff30e9800', '298', '76C3EFD9DB8EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0d755730f111ea826a00fff30e9800', '298', '76C3EFD9DBCEBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0e15b330f111ea826a00fff30e9800', '298', '76C3EFD9DCC3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0eb50130f111ea826a00fff30e9800', '298', '76C3EFD9DBA3BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd0f6cbc30f111ea826a00fff30e9800', '298', '76C3EFD9DC81BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd10237f30f111ea826a00fff30e9800', '298', '76C3EFD9DB6FBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd10dc9a30f111ea826a00fff30e9800', '298', '76C3EFD9DCC9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd127d2130f111ea826a00fff30e9800', '298', '76C3EFD9DB69BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd13285f30f111ea826a00fff30e9800', '298', '76C3EFD9DC0CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd13fafa30f111ea826a00fff30e9800', '298', '76C3EFD9DC19BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd14fb4a30f111ea826a00fff30e9800', '298', '76C3EFD9DB63BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd15b0e630f111ea826a00fff30e9800', '298', '76C3EFD9DC12BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd16584e30f111ea826a00fff30e9800', '298', '76C3EFD9DBE0BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd17019330f111ea826a00fff30e9800', '298', '76C3EFD9DBAFBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd17b48d30f111ea826a00fff30e9800', '298', '76C3EFD9DCA9BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd18531f30f111ea826a00fff30e9800', '298', '76C3EFD9DC7BBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd18f83a30f111ea826a00fff30e9800', '298', '76C3EFD9DB82BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd19a85630f111ea826a00fff30e9800', '298', '76C3EFD9DBDABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd1a60f630f111ea826a00fff30e9800', '298', '76C3EFD9DC4ABDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd1b069b30f111ea826a00fff30e9800', '298', '76C3EFD9DBECBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd1dd0ed30f111ea826a00fff30e9800', '298', '76C3EFD9DC44BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd1e87ff30f111ea826a00fff30e9800', '298', '76C3EFD9DB5DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd20ac0b30f111ea826a00fff30e9800', '298', '76C3EFD9DBE6BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd2174bb30f111ea826a00fff30e9800', '298', '76C3EFD9DBB5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd22343730f111ea826a00fff30e9800', '298', '76C3EFD9DB9EBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd22e24930f111ea826a00fff30e9800', '298', '76C3EFD9DB76BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd2397c330f111ea826a00fff30e9800', '298', '76C3EFD9DBBDBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd246a9a30f111ea826a00fff30e9800', '298', '76C3EFD9DBF4BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd25182130f111ea826a00fff30e9800', '298', '76C3EFD9DC32BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd25cb4a30f111ea826a00fff30e9800', '298', '76C3EFD9DC37BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd26915c30f111ea826a00fff30e9800', '298', '76C3EFD9DC9CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd27460630f111ea826a00fff30e9800', '298', '76C3EFD9DB9DBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd27fdcc30f111ea826a00fff30e9800', '298', '76C3EFD9DC75BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd31856e30f111ea826a00fff30e9800', '298', '76C3EFD9DCB7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd3231bd30f111ea826a00fff30e9800', '298', '76C3EFD9DB96BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd33036130f111ea826a00fff30e9800', '298', '76C3EFD9DBE1BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd33bfe630f111ea826a00fff30e9800', '298', '76C3EFD9DB57BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd347ac030f111ea826a00fff30e9800', '298', '332E9D6F5789409784B2D83459B5F88A', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd3530ef30f111ea826a00fff30e9800', '298', '76C3EFD9DC58BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd35f15530f111ea826a00fff30e9800', '298', '76C3EFD9DC82BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd39019e30f111ea826a00fff30e9800', '298', '76C3EFD9DBD5BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd3970b730f111ea826a00fff30e9800', '298', '76C3EFD9DBE7BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd40484030f111ea826a00fff30e9800', '298', '76C3EFD9DC7CBDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd40b0fc30f111ea826a00fff30e9800', '298', '76C3EFD9DB89BDD2E050007F010069C5', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );
INSERT INTO `sa_oprolepermission`
VALUES
	( 'dd410d3430f111ea826a00fff30e9800', '298', '6000FDBFF674421E883D035966C60431', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '2020-01-07 10:02:57', '系统管理员', 0 );-- ----------------------------
-- Table structure for sa_optenant
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_optenant`;
CREATE TABLE `sa_optenant` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`INDUSTRY_ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CONTACTS` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`CONTACT_NUMBER` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ROOT_FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`IS_INDUSTRY` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_optenant
-- ----------------------------
INSERT INTO `sa_optenant`
VALUES
	( '4E6571AA8ACB4F9C878D82DFCD2D91C2', 'huigou', '公司名称', 'B447C4AE48254EF0A003454525C23EFC', NULL, '公司名称', '超级管理员', '15112345678', 1, 'orgRoot', '/', 184661, 0 );-- ----------------------------
-- Table structure for sa_opuielement
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opuielement`;
CREATE TABLE `sa_opuielement` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件夹ID',
`KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`DEFAULT_OPERATION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '默认操作',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '序列号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '界面元素' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opuielement
-- ----------------------------
INSERT INTO `sa_opuielement`
VALUES
	( '671E0E987B5F98AFE050007F01002AFC', '671DFBC586B14E90E050007F01002A58', '2', 'maingrid.addHandler', '添加', 'noaccess', 1, 1, 851748 );
INSERT INTO `sa_opuielement`
VALUES
	( '671E11B253493DBAE050007F01002B0E', '671DFBC586B14E90E050007F01002A58', '2', 'maingrid.updateHandler', '修改', 'noaccess', 1, 2, 851768 );
INSERT INTO `sa_opuielement`
VALUES
	( '671E13CCB74C6077E050007F01002B22', '671DFBC586B14E90E050007F01002A58', '2', 'maingrid.deleteHandler', '删除', 'noaccess', 1, 3, 851788 );
INSERT INTO `sa_opuielement`
VALUES
	( '671E13CCB74E6077E050007F01002B22', '671DFBC586B14E90E050007F01002A58', '2', 'maingrid.enableHandler', '启用', 'noaccess', 1, 4, 851859 );
INSERT INTO `sa_opuielement`
VALUES
	( '671E17E9EAD8883FE050007F01002B48', '671DFBC586B14E90E050007F01002A58', '2', 'maingrid.disableHandler', '禁用', 'noaccess', 1, 5, 851887 );
INSERT INTO `sa_opuielement`
VALUES
	( '671E1BD3F4BC95D9E050007F01002B6E', '671DFBC586B14E90E050007F01002A58', '2', 'maingrid.saveSortIDHandler', '保存排序号', 'noaccess', 1, 6, 851917 );-- ----------------------------
-- Table structure for sa_opuielementpermission
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_opuielementpermission`;
CREATE TABLE `sa_opuielementpermission` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PERMISSION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限ID',
`RESOURCE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类别',
`OPERATION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '界面元素权限' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_opuielementpermission
-- ----------------------------
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671AF5D2EC3D7CA9E050007F01000B5A', '671AF2ED47924578E050007F01000B3C', NULL, 'maingrid.addHandler', '新增', '2', 'noaccess', 836468, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671B2DCBAB36B514E050007F01000D16', '671B2C4775F57049E050007F01000D03', NULL, 'maingrid.addHandler', '添加', '2', 'readwrite', 1676052, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671E28371E5F7BA6E050007F01002C15', '671B2C4775F57049E050007F01000D03', '671E11B253493DBAE050007F01002B0E', 'maingrid.updateHandler', '修改', '2', 'readwrite', 1676053, 2 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671E28371E607BA6E050007F01002C15', '671B2C4775F57049E050007F01000D03', '671E13CCB74C6077E050007F01002B22', 'maingrid.deleteHandler', '删除', '2', 'readwrite', 1676054, 3 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671E28371E617BA6E050007F01002C15', '671B2C4775F57049E050007F01000D03', '671E13CCB74E6077E050007F01002B22', 'maingrid.enableHandler', '启用', '2', 'readwrite', 1676055, 4 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671E28371E627BA6E050007F01002C15', '671B2C4775F57049E050007F01000D03', '671E17E9EAD8883FE050007F01002B48', 'maingrid.disableHandler', '禁用', '2', 'readwrite', 1676056, 5 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '671E28371E637BA6E050007F01002C15', '671B2C4775F57049E050007F01000D03', '671E1BD3F4BC95D9E050007F01002B6E', 'maingrid.saveSortIDHandler', '保存排序号', '2', 'readwrite', 1676057, 6 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '67339BF6A7227905E050007F01002AF8', '67337D34CC8EAB31E050007F010029A4', NULL, 'DeviceKind', '设备类', '0', 'readwrite', 862973, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6733A00FD91A93FAE050007F01002B15', '67339460DC98D79BE050007F01002ABF', NULL, 'FurnitureKind', '家具类', '0', 'readwrite', 862991, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6733A256EBFB955CE050007F01002AF0', '67339460DC99D79BE050007F01002ABF', NULL, 'BookKind', '图书类', '0', 'readwrite', 863002, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6733A256EBFC955CE050007F01002AF0', '67339460DC99D79BE050007F01002ABF', NULL, 'DatabaseKind', '数据库类', '0', 'readwrite', 863003, 2 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6734E626F3E03DFFE050007F0100376C', '6734C40691529A1DE050007F01003617', NULL, 'DeviceKind', '设备类', '3', 'readwrite', 868168, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6734E626F3E13DFFE050007F0100376C', '6734C504F56CDA3BE050007F01003629', NULL, 'FurnitureKind', '家具类', '3', 'readwrite', 868189, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6734E8D9427FA4B9E050007F01003781', '6734C5A50BA318AEE050007F0100362F', NULL, 'BookKind', '图书类', '3', 'readwrite', 868200, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6734E9C580B2F80CE050007F01003785', '6734C5A50BA318AEE050007F0100362F', NULL, 'DatabaseKind', '数据库类', '3', 'readwrite', 868205, 2 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '676B53DF666528F0E050007F01001913', '676B4C0D5B3814ECE050007F010018EB', NULL, 'maingrid.constructionHandler', '项目报建', '2', 'noaccess', 930024, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '67832C344AE4DC75E050007F01001A8E', '67831D161969A83CE050007F010019D2', NULL, 'maingrid.updateHandler', '修改', '2', 'readwrite', 972292, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '67844E5A0C8AEC90E050007F0100265B', '67844C3206473AE3E050007F01002649', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 972930, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6A2A318A2E7E4B26E050007F01005677', '6A2A24BF2598E237E050007F01005601', NULL, 'maingrid.constructionHandler', '项目报建', '2', 'readwrite', 1279230, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6B5C6CA79329D86FE050007F01004246', '6B5C68DB8C8022BDE050007F01004222', NULL, 'maingrid.updateHandler', '修改', '2', 'readwrite', 1317320, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6B5C6E86264B63A0E050007F0100425D', '6B5C6E86264A63A0E050007F0100425D', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 1317341, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC7D9153285E67E050007F010061C0', '6BAC718FBE8DC91DE050007F01006165', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'noaccess', 1322757, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC7F0B5706E2D2E050007F010061C6', '6BAC718FBE8EC91DE050007F01006165', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'noaccess', 1322776, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC7F0B5707E2D2E050007F010061C6', '6BAC718FBE8FC91DE050007F01006165', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'noaccess', 1322793, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC828F17B86705E050007F010061F8', '6BAC7ADD2155CD48E050007F010061AC', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'noaccess', 1322810, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC994C9DF00D4DE050007F010062F4', '6BAC994C9DEF0D4DE050007F010062F4', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'readwrite', 1323084, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC9C6497E0D5FFE050007F010062FE', '6BAC994C9DF10D4DE050007F010062F4', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'readwrite', 1323117, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BAC9C6497E1D5FFE050007F010062FE', '6BAC994C9DF20D4DE050007F010062F4', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'readwrite', 1323154, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6BACA168E1081C55E050007F0100631E', '6BACA0B63DF29451E050007F01006324', '6BAC6B5A2A9A1F11E050007F0100613B', 'maingrid.printHandler', '打印', '2', 'readwrite', 1323187, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C7582E34BC3DBB8E050007F010061C8', '6C7582E34BC2DBB8E050007F010061C8', NULL, 'maingrid.updateHandler', '修改', '2', 'readwrite', 1666746, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75863D9A5408A7E050007F010061DE', '6C7583F8C33404A3E050007F010061D4', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 1666755, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75B63CB5117473E050007F010063FF', '6C75882C3DAA2224E050007F0100620E', NULL, 'maingrid.updateHandler', '修改', '2', 'readwrite', 1667122, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75BB19C43AA574E050007F0100643C', '6C758965E39DBB61E050007F01006214', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 1667131, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75BCD73A06B90AE050007F01006446', '6C75A96DF00BEFFCE050007F0100635C', NULL, 'maingrid.updateHandler', '修改', '2', 'readwrite', 1667142, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75BCD73A07B90AE050007F01006446', '6C75A96DF00CEFFCE050007F0100635C', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 1667151, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75C0498CD96953E050007F01006460', '6C75ACEFEDE2EC79E050007F01006396', NULL, 'maingrid.updateHandler', '修改', '2', 'readwrite', 1667172, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75C1066B65AD45E050007F0100646A', '6C75AEE6790AED3EE050007F010063D5', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 1667181, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75D67AB6C17138E050007F0100651F', '6C75CB8AFC419307E050007F010064CD', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'readwrite', 1667358, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75D8364923626CE050007F01006533', '6C75CDA9144E9ACEE050007F010064EB', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'noaccess', 1667378, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75DA1B2A719ABFE050007F0100654B', '6C75CB02AEFE988AE050007F010064C1', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'readwrite', 1667389, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C75DB1D083E12ABE050007F0100654D', '6C75D3F44477DD70E050007F0100651B', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'noaccess', 1667398, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C76189D28F01D0DE050007F01006789', '6C760EB56CFBC529E050007F0100671E', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'readwrite', 1667947, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C76199BC6ADC67AE050007F0100678F', '6C76102072FF1550E050007F01006732', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'noaccess', 1667956, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C761AD2D7A62237E050007F0100679B', '6C761227CFC6A5F8E050007F01006741', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'readwrite', 1667971, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C761AD2D7A72237E050007F0100679B', '6C76135509B47565E050007F0100673C', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'noaccess', 1667986, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C761D9A8FEDB333E050007F0100679F', '6C76156440A12D12E050007F01006773', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'readwrite', 1667997, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6C761EE4A244D09DE050007F010067A3', '6C76167147D48EEEE050007F01006781', NULL, 'maingrid.savePmAddressHandler', '批量设置地点', '2', 'noaccess', 1668006, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CB20EA9C9D2A6ADE050007F01002026', '6CB1F2343FE6BEACE050007F01001ECF', NULL, 'maingrid.saveExcelImpAssetFinancial', '导入财政资产编号', '2', 'readwrite', 1672011, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CB210855B765100E050007F0100203E', '6CB1F466632A6C4FE050007F01001EF1', NULL, 'maingrid.saveExcelImpAssetFinancial', '导入财政资产编号', '2', 'noaccess', 1672020, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CB2129F5C57277CE050007F01002044', '6CB1F74F56FBA7EDE050007F01001F0D', NULL, 'maingrid.saveExcelImpAssetFinancial', '导入财政资产编号', '2', 'readwrite', 1672031, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CB213CA6C690417E050007F01002052', '6CB1F8F9F121028EE050007F01001F20', NULL, 'maingrid.saveExcelImpAssetFinancial', '导入财政资产编号', '2', 'noaccess', 1672053, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CB216F651B856E7E050007F0100206B', '6CB1FBC14566586BE050007F01001F36', NULL, 'maingrid.saveExcelImpAssetFinancial', '导入财政资产编号', '2', 'readwrite', 1672068, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CB21837E7BB6F93E050007F01002073', '6CB20549DF9A501DE050007F01001FAA', NULL, 'maingrid.saveExcelImpAssetFinancial', '导入财政资产编号', '2', 'noaccess', 1672077, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CD73614D3745FEDE050007F0100562B', '6CD72E5C52A1A55FE050007F010055E1', NULL, 'maingrid.addHandler', '添加', '2', 'noaccess', 1681071, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CD73614D3755FEDE050007F0100562B', '6CD72E5C52A1A55FE050007F010055E1', NULL, 'maingrid.updateHandler', '修改', '2', 'noaccess', 1681072, 2 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CD73614D3765FEDE050007F0100562B', '6CD72E5C52A1A55FE050007F010055E1', NULL, 'maingrid.deleteHandler', '删除', '2', 'noaccess', 1681073, 3 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CD73614D3775FEDE050007F0100562B', '6CD72E5C52A1A55FE050007F010055E1', NULL, 'maingrid.enableHandler', '启用', '2', 'noaccess', 1681074, 4 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CD73614D3785FEDE050007F0100562B', '6CD72E5C52A1A55FE050007F010055E1', NULL, 'maingrid.disableHandler', '禁用', '2', 'noaccess', 1681075, 5 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6CD73614D3795FEDE050007F0100562B', '6CD72E5C52A1A55FE050007F010055E1', NULL, 'maingrid.saveSortIDHandler', '保存排序号', '2', 'noaccess', 1681076, 6 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6F0B6940323093C8E050007F01000EF4', '6F0B60D1FB10CEE5E050007F01000E97', NULL, 'maingrid.fundingItemsHandler', '维护经费项目', '2', 'readwrite', 1775283, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '6F0B6940323193C8E050007F01000EF4', '6F0B624C15776B72E050007F01000E99', NULL, 'maingrid.fundingItemsHandler', '维护经费项目', '2', 'noaccess', 1775298, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '70130196D0B736FBE050007F01003716', '7012FC03BCCE34FBE050007F010036E3', NULL, 'maingrid.synResponsiblePersonHandler', '同步责任人', '2', 'readwrite', 1838286, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '7013033B52ACF3B4E050007F01003714', '7012FDCCE5E1D10CE050007F010036EF', NULL, 'maingrid.synResponsiblePersonHandler', '同步责任人', '2', 'noaccess', 1838299, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '70D925C3ED996DF4E050007F01002A3F', '70D916986D52F608E050007F010029BE', NULL, 'maingrid.abandonHandler', '项目放弃无权限', '2', 'noaccess', 1884492, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '70D92A4BE0CE2415E050007F01002A67', '70D918E8356C46C7E050007F010029D8', NULL, 'maingrid.abandonHandler', '项目放弃有权限', '2', 'readwrite', 1884527, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '84BAB04FF62EAC40E050007F0100723C', '84BAAE7EAE816E7AE050007F01007216', NULL, 'code', 'code', '0', 'noaccess', 3294372, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '84BAB5B528DBB26DE050007F0100725E', '84BAB04FF62FAC40E050007F0100723C', NULL, 'code', 'code', '0', 'noaccess', 3294449, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '84BAB5B528DCB26DE050007F0100725E', '84BAB04FF62FAC40E050007F0100723C', '671E0E987B5F98AFE050007F01002AFC', 'maingrid.addHandler', '添加', '2', 'noaccess', 3294456, 3 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '84BABAF3BC1E660BE050007F0100727E', '84BABAF3BC1D660BE050007F0100727E', '671E0E987B5F98AFE050007F01002AFC', 'maingrid.addHandler', '添加', '2', 'noaccess', 3294517, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '84BABAF3BC1F660BE050007F0100727E', '84BABAF3BC1D660BE050007F0100727E', NULL, 'code', 'code', '0', 'noaccess', 3294518, 2 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( '8DC4F0284AFE0A19E050007F010026D4', '8DC42CFFE5B57EC7E050007F010001B2', NULL, 'settlementMoney', '可编辑项目结算金额', '1', 'readwrite', 3508347, 1 );
INSERT INTO `sa_opuielementpermission`
VALUES
	( 'E015DE1332B1466DAF92A1BA695608B8', '571FCB0B2D1040698749A3A749C1B9DA', NULL, 'adminReportGrid.shareHandler', '分享', '2', 'noaccess', 3573219, 1 );-- ----------------------------
-- Table structure for sa_orgfun
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_orgfun`;
CREATE TABLE `sa_orgfun` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'code',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'name',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'parent_id',
`IS_LAST` INT ( 11 ) NULL DEFAULT NULL COMMENT 'is_last',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT 'remark',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'sequence',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT 'status',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT 'version',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统可用组织机构函数' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_orgfun
-- ----------------------------
INSERT INTO `sa_orgfun`
VALUES
	( '0073C130B0744F42B95C01CEEDF75940', 'findCurrentPersonCenterAdminManager()', '获取当前人员单位行政管理权限管理者', '46F22C02A83B4CE6B3F2748C84CC751B', 1, NULL, 10, 1, 744021 );
INSERT INTO `sa_orgfun`
VALUES
	( '46F22C02A83B4CE6B3F2748C84CC751B', 'system', '系统函数', '0', 0, NULL, 1, 1, 743912 );
INSERT INTO `sa_orgfun`
VALUES
	( '540AB4FAE9124726A994A4DC907B995F', 'findApplicant()', '查找流程实例申请人', '46F22C02A83B4CE6B3F2748C84CC751B', 1, NULL, 2, 1, 744018 );
INSERT INTO `sa_orgfun`
VALUES
	( '5AB87B27F2DC48AAA94301A99B6FCCED', 'findCurrentNearestManagers(\'manageType\')', '获取当前人员的指定管理权限的管理者', '46F22C02A83B4CE6B3F2748C84CC751B', 1, NULL, 9, 1, 744020 );
INSERT INTO `sa_orgfun`
VALUES
	( '896595', 'findManagers()', '获取指定组织单元的管理者', '46F22C02A83B4CE6B3F2748C84CC751B', 1, NULL, 3, 1, 744016 );
INSERT INTO `sa_orgfun`
VALUES
	( '906353', 'findCurrentPersonMemberAdminManager()', '获取当前人员的行政权限管理者', '46F22C02A83B4CE6B3F2748C84CC751B', 1, NULL, 1, 1, 744014 );
INSERT INTO `sa_orgfun`
VALUES
	( '9C35F090D8474008A549BA65F548C870', 'findNearestManagers(@personMemberId,\'admin\')', '获取指定组织单元最近的管理者', '46F22C02A83B4CE6B3F2748C84CC751B', 1, NULL, 5, 1, 744017 );-- ----------------------------
-- Table structure for sa_parameter
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_parameter`;
CREATE TABLE `sa_parameter` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数名称',
`VALUE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '参数值',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父编码',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统参数' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_parameter
-- ----------------------------
INSERT INTO `sa_parameter`
VALUES
	( '01BC395F84844991A42E26F888D98E21', 'uploadPath', '上传文件保存路径', '/opt/attachment/upload/', NULL, 3570434, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '1BD0158AEB1A4766A61939AD4622F147', 'SYSTEM.LOGO.PATH', '系统logo路径', 'images\\logo-mini.png', NULL, 3565069, '7C9A74E0F19A4C5FB89746E80F788A6D', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '1D76E4AA103245C39CD4BEEE8EA6D82A', 'tenant.entity.rootId', '租户根组织ID', 'E3B4E5C5C6454F81921CF58B7597CE2F', NULL, 184805, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '26193721', 'Token.ExpireTime', 'Token过期时间', '5400', '单位  秒', 258472, '1320', 1, 1 );
INSERT INTO `sa_parameter`
VALUES
	( '26E67F1FBB834B33A93FDF3FCEA0B36E', 'wf.approval.advance.showMergeHandler', '流程提交显示合并处理人', 'true', NULL, 1845237, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '3361499DDAC548F4BA6E71881DAD3774', 'organName', '组织名称', '统一应用支撑平台', NULL, 3547884, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '397913F8305C49CC93DA410F101BB956', 'tenant.enable', '使用租户', 'false', NULL, 289289, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '4591BE2F23A6478E95ACD9820B329730', 'limit', '流程预警提醒时间(小时)', '48', NULL, 86664, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '46D6DB7FFA4F49908F386B7C6070F2D2', 'wf.bizBill.creator.showPositionName', '业务单据创建人显示岗位名称', 'false', NULL, 268010, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '4D17369B375C4AD5B7A68914293EBE60', 'boardChairmanPosCode', '董事长岗位', 'DSZ', NULL, 77911, '424962', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '5639D5758A2C4D6A830DA5BF62D4AF50', 'operator.fullDisplayName.showOrganName', '操作员显示机构名称', 'false', NULL, 270342, '424959', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '5C70C316D8A9892BE050007F01005443', 'wf.chart.showAllRules', '流程图是否显示全部规则', 'false', NULL, 487595, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '606381657188469895699A3326DB29BE', 'maintain.app.id', 'maintain大仪系统对接APP_ID', 'topsun', NULL, 583147, '7', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '62EA78D1B71A43EC8A468814F823C693', 'maintain.app.code', 'maintain大仪系统对接APP_CODE', 'b216f2bd-e7df-480d-89d8-6ffc88dc8fc6', NULL, 583154, '7', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '65C2B021CF504EE39401C38E125FA907', 'tenant.admin.roleId', '租户管理员角色ID', '66A94EEA560B403D9AF4013984F37CD8', NULL, 184666, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '674A64E468EA11C1E050007F01001F52', 'exportExcelCount', 'Excel导出数据上限', '40000', 'Excel导出数据上限', 1108851, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '6A7BF83F995C474CB81CA35AC90570DB', 'operator.fullDisplayName.showPositionName', '操作员显示岗位名称', 'false', NULL, 270347, '424962', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '702B01014F3CAA1DE050007F010035C5', 'canMergeSubProcUnitId', '流程审批允许合并子环节ID', 'printPage,magdpt,dpt', '环节打印,预算申报部门审核', 1860344, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '73C99D0FB8C144A8B20573AFFA50B6DE', 'uploadTempPath', '文件上传临时路径', '/opt/attachment/uploadTemp/', NULL, 3570427, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '7600FE569F0B4FE982312775AFC50CBB', 'selectOrg.scope', '选择组织范围', 'TENANT', 'ALL\\TENANT', 169983, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '8DA7E3317C9448E3B021F6C60DB17677', 'wf.bizBill.creator.showOrganName', '业务单据创建人显示公司名称', 'false', NULL, 266444, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '8E54299F3CAA83DEE050007F01002187', 'techAgentRootOrgId', '代理商根orgId', '8E29A8EEFC134CC7BF7B20F273CDA5C4', NULL, 3517835, '7', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '8EF1B038D555200EE050007F01000EEB', 'templateId', '外贸合同上传附件模板Id', '8E79D94230ACC299E050007F0100335C', NULL, 3522570, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '91FA811C875448CF9F1E1B73DE1263DC', 'ApproveNotPassedHandleKind', '审批不通过流程处理类型', 'back', 'back:回退申请人 abort:终止流程 continue:继续流程', 264815, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '91FA811C875448CF9F1E1B73DE1263FB', 'wf.approval.showAfterHandlers', '显示当前组后面的处理人', 'true', NULL, 264815, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '922057AACF0710B3E050007F01000B23', 'import.employee.autoClearData', '人员导入，自动删除数据', 'false', NULL, 3574525, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '924E9B58B4294C8EB2913D20047144D9', 'SYSTEM.NAME', '系统显示名称', '统一应用支撑平台', '', 0, '7C9A74E0F19A4C5FB89746E80F788A6D', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '932D7D32951C45E5BACCD553559F9488', 'sap.account.book', 'sap默认账套', 'all', 'ST00', 1256389, '7', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( '9407EC0DBA81487D8E3650B1E8F935B2', 'adminPersonId', '系统管理员PersonID', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员PersonID', 663313, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'B9AA73B4C4CD47ED83D6F1CB1E322766', 'wf.approval.supportManuscript', '流程审批支持手写', 'false', NULL, 265564, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'BD37A81ED3434CC58A392722721671C2', 'defaultSkin', '默认皮肤', 'skin-1', NULL, 3562303, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'C2B0A5958BDA48FA94C7FE37C553EA81', 'queryHandlerShowField', '预览处理人显示办理人字段类型', 'fullName', NULL, 100985, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'C8DF53421EDC4A249B9A4842E1D710CA', 'uploadFileSize', '允许上传文件大小(M)', '50', NULL, 59039, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'C9D53E08576446A2A426864D52406B0E', 'HQOrganId', '集团组织ID', '7609EDB28F974C5F948CAA24D5ADAB85', NULL, 3563415, '424959', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'CABFD27A3592415790F02B2D6B01784C', 'companyLeaderDeptCode', '公司领导部门编码公司领导部门编码公司领导部门编码公司领导部门编码', 'JTLD', NULL, 255292, '424961', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'E18E5233A6B64B8D93C7F0560184577E', 'uploadFileType', '允许上传文件类型', 'png,jpg,pdf,doc,xls,docx,xlsx,zip,rar,txt,ppt,pptx', NULL, 1893729, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'E395387DCCEC46D892A882DEDD781FD2', 'wf.approval.agree.defaultOpinion', '审批同意默认处理意见', '同意！', 'null', 3281665, 'AD048D2BF97D4AD5896892A4422D98F3', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'EB671DD7A72A4A0AB3B8D9EFAB268C55', 'fine.sync.jobXml', '帆软组织架构同步任务定义文件', 'E:/FineSync/sync.kjb', NULL, 3568521, '7', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'EC838F1F23E04AEB9A91B7AC969EA539', 'maintain.app.url', 'maintain大仪系统APP_URL', 'http://10.15.44.71/eq-maintain/rest/maintain', NULL, 672552, '7', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'F7C11EA981A7491481942BC2543EBB1F', 'webBasePath', '根路径', 'http://10.15.65.62:8080/bpm', '根路径', 270689, '1320', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'F82A4025D49D4BE48DA8AE26731E2D8A', 'adminMR', '行政管理权限', 'admin', '默认行政管理权限', 610299, '425521', 0, NULL );
INSERT INTO `sa_parameter`
VALUES
	( 'FB1E07D2A88249E5A0A30430E9729A6D', 'SYSTEM.COPYRIGHT', '系统版权信息', '版权所有:腾燊嘉诚', '', 0, '7C9A74E0F19A4C5FB89746E80F788A6D', 0, NULL );-- ----------------------------
-- Table structure for sa_pdscreen
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_pdscreen`;
CREATE TABLE `sa_pdscreen` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`PERSON_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户桌面分屏设置' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_pdscreen
-- ----------------------------
INSERT INTO `sa_pdscreen`
VALUES
	( '5B1AC4C45430A71EE050007F01004403', '5B1A2386CCD9ECF9E050007F01003D30', 269203 );
INSERT INTO `sa_pdscreen`
VALUES
	( '5E271E71AF457C0EE050007F01001A34', '5EEB2DC861694A65933CB4CE9A8D870A', 305909 );
INSERT INTO `sa_pdscreen`
VALUES
	( '628A6475E4C0F27AE050007F01000F0C', '213001', 469110 );
INSERT INTO `sa_pdscreen`
VALUES
	( '6356064A1D14972FE050007F010053D4', '5C80F5E9C2D04981E050007F0100085D', 528295 );
INSERT INTO `sa_pdscreen`
VALUES
	( '6381AB8DEF9F4F4EE050007F01002ADA', '213001', 549016 );
INSERT INTO `sa_pdscreen`
VALUES
	( '66B5F6EC1D671F90E050007F01001D46', '100163', 704544 );
INSERT INTO `sa_pdscreen`
VALUES
	( '67072E852B48B6EBE050007F01003161', '100288', 824775 );
INSERT INTO `sa_pdscreen`
VALUES
	( '73D564D6A748010EE050007F01004C19', '100110', 1953271 );
INSERT INTO `sa_pdscreen`
VALUES
	( '73E90DBF88B51256E050007F01005178', '100123', 2018685 );
INSERT INTO `sa_pdscreen`
VALUES
	( '7403EC4CA440C72AE050007F01003AE4', '100424', 2600053 );
INSERT INTO `sa_pdscreen`
VALUES
	( '7411D80EA057B9FDE050007F01007E3B', '100614', 2702538 );
INSERT INTO `sa_pdscreen`
VALUES
	( '741642AD091496C9E050007F01005A17', '100455', 2909681 );
INSERT INTO `sa_pdscreen`
VALUES
	( '7D809D8F724F81B0E050007F0100051C', '100163', 3234177 );
INSERT INTO `sa_pdscreen`
VALUES
	( '92C04790ACC472F1E050007F01007BF6', '92208DB645E8346BE050007F010012C2', 3573161 );-- ----------------------------
-- Table structure for sa_pdscreenfunction
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_pdscreenfunction`;
CREATE TABLE `sa_pdscreenfunction` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
`SCREEN_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分屏ID',
`FUNCTION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能ID',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户分屏应用记录表' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of sa_pdscreenfunction
-- ----------------------------
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '3BE0643FA6FD4C85AC52DCCF3FF45261', '5E271E71AF457C0EE050007F01001A34', '686', 1, 3565000 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CA67005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', 'E755352BD5634BE086FE1AD80191E9D1', 0, 422632 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CA77005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', '680C55BF42E64ACD9AE1BCDF94CA498E', 1, 422633 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CA87005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', '9A605D637B9E40C0853F468938FAA348', 2, 422634 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CA97005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', 'DD855C08BE73408DABB100EDBA4603CD', 3, 422635 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CAA7005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', '7E110076931346AE9C920C1BF19409E9', 4, 422636 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CAB7005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', 'ADEE5537F79D4ED78DCE2822FADC948B', 5, 422637 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CAC7005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', '5C01D90EFDDA496A910B1697D5CF1D72', 6, 422638 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '61C24EC56CAD7005E050007F01006CED', '5B1AC4C45430A71EE050007F01004403', '45D1CA23421C4E03AF18DBA084B87B4F', 7, 422639 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '6356064A1D15972FE050007F010053D4', '6356064A1D14972FE050007F010053D4', '07F55957A5FA45CC94B2295A3B8E91A0', 0, 528296 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '6381AB8DEFA04F4EE050007F01002ADA', '6381AB8DEF9F4F4EE050007F01002ADA', 'C4576D25DEB0409F968FF776F68B83E2', 0, 549017 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '67072E852B4AB6EBE050007F01003161', '67072E852B48B6EBE050007F01003161', '680C55BF42E64ACD9AE1BCDF94CA498E', 0, 824783 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '67072E852B4BB6EBE050007F01003161', '67072E852B48B6EBE050007F01003161', '7E110076931346AE9C920C1BF19409E9', 1, 824784 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '73E906C4FC435787E050007F01005109', '73D564D6A748010EE050007F01004C19', '918FDEAB5DAB453DABEA556C0FEC0764', 0, 2018645 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '73E906C4FC445787E050007F01005109', '73D564D6A748010EE050007F01004C19', '227C2C1C3DFA4550AA9970BFA96A86E9', 1, 2018646 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '73E906C4FC455787E050007F01005109', '73D564D6A748010EE050007F01004C19', '67D46B81644D40AFB75EC8EA62C898D2', 2, 2018647 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '73E906C4FC465787E050007F01005109', '73D564D6A748010EE050007F01004C19', '3B9AE820315D4F48B1D5738FEE9A247A', 3, 2018648 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7403EC4CA441C72AE050007F01003AE4', '7403EC4CA440C72AE050007F01003AE4', '69F2682451667C8DE050007F01005458', 0, 2600054 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7411D210AC324D7EE050007F01007DED', '73E90DBF88B51256E050007F01005178', '7E110076931346AE9C920C1BF19409E9', 0, 2702498 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7411D210AC334D7EE050007F01007DED', '73E90DBF88B51256E050007F01005178', 'FEC5BB770DA1498388A23ECF49552075', 1, 2702499 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7411D210AC344D7EE050007F01007DED', '73E90DBF88B51256E050007F01005178', '9A605D637B9E40C0853F468938FAA348', 2, 2702500 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7411D210AC354D7EE050007F01007DED', '73E90DBF88B51256E050007F01005178', '5C809C33F5DCA5CCE050007F0100049A', 3, 2702501 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7411D210AC364D7EE050007F01007DED', '73E90DBF88B51256E050007F01005178', '3B9AE820315D4F48B1D5738FEE9A247A', 4, 2702502 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7411D210AC374D7EE050007F01007DED', '73E90DBF88B51256E050007F01005178', '00EBC04467D04D3C92AF0284EEF2A17D', 5, 2702503 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7413667A9A275D12E050007F010049B3', '7411D80EA057B9FDE050007F01007E3B', '00EBC04467D04D3C92AF0284EEF2A17D', 0, 2828608 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '7413667A9A285D12E050007F010049B3', '7411D80EA057B9FDE050007F01007E3B', '6BB747FF179B4903B7907F3F43D21E0D', 1, 2828609 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '74166E20A1F886ACE050007F01005CB2', '741642AD091496C9E050007F01005A17', 'FEC5BB770DA1498388A23ECF49552075', 0, 2909865 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '74166E20A1F986ACE050007F01005CB2', '741642AD091496C9E050007F01005A17', '918FDEAB5DAB453DABEA556C0FEC0764', 1, 2909866 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '74166E20A1FA86ACE050007F01005CB2', '741642AD091496C9E050007F01005A17', '9A605D637B9E40C0853F468938FAA348', 2, 2909867 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '74166E20A1FB86ACE050007F01005CB2', '741642AD091496C9E050007F01005A17', '5C809C33F5DCA5CCE050007F0100049A', 3, 2909868 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '74ECA53049434A87AEC0A8EBF1710940', '5E271E71AF457C0EE050007F01001A34', '6766', 2, 3565001 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '8976DAC8B878F520E050007F01004080', '7D809D8F724F81B0E050007F0100051C', '24B85DE7C5464FC991A55E7D21A88259', 0, 3455391 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '8976DAC8B879F520E050007F01004080', '7D809D8F724F81B0E050007F0100051C', '2B50D139F1D649DBB378D9BA3C1FEB0D', 1, 3455392 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '8976DAC8B87AF520E050007F01004080', '7D809D8F724F81B0E050007F0100051C', '3D28E29BA614486E8258FB903DC9B8B7', 2, 3455393 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '8976DAC8B87BF520E050007F01004080', '7D809D8F724F81B0E050007F0100051C', '5F01C05DF1EA14D5E050007F010034B6', 3, 3455394 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '8976DAC8B87CF520E050007F01004080', '7D809D8F724F81B0E050007F0100051C', 'B3573A32B43549818A0102DAFF373EA9', 4, 3455395 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( '9C1E99D4B855416BB029D51653CC12B2', '5E271E71AF457C0EE050007F01001A34', '1289', 0, 3564999 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( 'A550C48445F54D8E952C965244C02ADC', '5E271E71AF457C0EE050007F01001A34', '452', 3, 3565002 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( 'CB8C4AA224F44732861C15F2BA0F1730', '5E271E71AF457C0EE050007F01001A34', '4803541', 4, 3565003 );
INSERT INTO `sa_pdscreenfunction`
VALUES
	( 'E0672ABD71594595B84EBC6F24466F7A', '5E271E71AF457C0EE050007F01001A34', '92F7A2EE270523CEE050007F010066C5', 5, 3565004 );-- ----------------------------
-- Table structure for sa_personaccountmanagement
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_personaccountmanagement`;
CREATE TABLE `sa_personaccountmanagement` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`LOGIN_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`LOCKED_DATE` datetime  NULL DEFAULT NULL,
`LAST_LOGIN_DATE` datetime  NULL DEFAULT NULL,
`LAST_MODIFIED_PASSWORD_DATE` datetime  NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_personcalendar
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_personcalendar`;
CREATE TABLE `sa_personcalendar` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`SUBJECT` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '标题',
`START_TIME` datetime  NULL DEFAULT NULL COMMENT '开始时间',
`END_TIME` datetime  NULL DEFAULT NULL COMMENT '结束时间',
`IS_ALLDAYEVENT` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否全天',
`PERSON_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户ID',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_BY_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_DATE` datetime  NULL DEFAULT NULL,
`LAST_MODIFIED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LAST_MODIFIED_BY_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LAST_MODIFIED_DATE` datetime  NULL DEFAULT NULL,
`BUSINESS_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务单据ID',
`LINK_BILL_URL` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '业务单据链接',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '日程安排' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_personloginlimit
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_personloginlimit`;
CREATE TABLE `sa_personloginlimit` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`MACHINE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PERSON_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LOGIN_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_personqueryscheme
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_personqueryscheme`;
CREATE TABLE `sa_personqueryscheme` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`PERSON_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员ID',
`KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类别',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`PARAM` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '参数',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户查询方案' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_securitypolicy
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_securitypolicy`;
CREATE TABLE `sa_securitypolicy` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`ENABLE_INTERNET_LOGIN` INT ( 11 ) NULL DEFAULT NULL,
`INTRANET_SEGMENT` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PASSWORD_VALIDITY_INTERVAL` INT ( 11 ) NULL DEFAULT NULL,
`PASSWORD_EXPIRE_GIVE_DAYS` INT ( 11 ) NULL DEFAULT NULL,
`PASSWORD_MINIMUM_LENGTH` INT ( 11 ) NULL DEFAULT NULL,
`LOCK_USER_PASSWORD_ERROR_TIME` INT ( 11 ) NULL DEFAULT NULL,
`ENABLE_COMPLEXITY` INT ( 11 ) NULL DEFAULT NULL,
`AUTO_UNLOCK_TIME` INT ( 11 ) NULL DEFAULT NULL,
`SECURITY_GRADE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NUMBER_COUNT` INT ( 11 ) NULL DEFAULT NULL,
`UPPERCASE_COUNT` INT ( 11 ) NULL DEFAULT NULL,
`LOWERCASE_COUNT` INT ( 11 ) NULL DEFAULT NULL,
`SPECIAL_CHARACTER_COUNT` INT ( 11 ) NULL DEFAULT NULL,
`INIT_PASSWORD` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_tmauthorize
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_tmauthorize`;
CREATE TABLE `sa_tmauthorize` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`SUBORDINATION_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUBORDINATION_FULL_ID` VARCHAR ( 255 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SYSTEM_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ROLE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`MANAGER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`CREATED_DATE` datetime  NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_usergroup
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_usergroup`;
CREATE TABLE `sa_usergroup` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组名称',
`FOLDER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`KIND_ID` VARCHAR ( 8 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组类别(系统,个人)',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态',
`FUNCTION_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '函数名',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'CREATEd_BY_ID',
`CREATED_BY_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'CREATEd_BY_name',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT 'created_date',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户分组' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for sa_usergroupdetail
-- ----------------------------
DROP TABLE
IF
	EXISTS `sa_usergroupdetail`;
CREATE TABLE `sa_usergroupdetail` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`GROUP_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORG_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_approvalelement
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalelement`;
CREATE TABLE `wf_approvalelement` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '1系统 2业务',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`DATA_SOURCE_CONFIG` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE,
UNIQUE INDEX `PK_WF_APPROVALELEMENT` ( `ID` ) USING BTREE,
INDEX `IX_APPROVALELEMENT_CODE` ( `CODE` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批要素' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_approvalelement
-- ----------------------------
INSERT INTO `wf_approvalelement`
VALUES
	( '5329563', 'deptKind', '部门类别', 1, 8, 258409, '{ type: \'dictionary\',data:{name: \'deptKind\'},textField:\'fvalue\',valueField:\'fvalueId\'}', 1 );
INSERT INTO `wf_approvalelement`
VALUES
	( '6945', 'orgId', '机构', 1, 2, 258406, '{ type: \'tree\',data:{name: \'org\',checkbox:true},textField:\'fvalue\',valueField:\'fvalueId\'}', 1 );
INSERT INTO `wf_approvalelement`
VALUES
	( '6946', 'deptId', '部门', 1, 4, 258407, '{ type: \'tree\',data:{name: \'org\',checkbox:true},textField:\'fvalue\',valueField:\'fvalueId\'}', 1 );
INSERT INTO `wf_approvalelement`
VALUES
	( '6948', 'deptFunctionKind', '部门职能类别', 1, 3, 145816, NULL, 1 );
INSERT INTO `wf_approvalelement`
VALUES
	( '6953', 'posKind', '岗位类别', 1, 5, 145817, NULL, 1 );
INSERT INTO `wf_approvalelement`
VALUES
	( '6954', 'posId', '岗位', 1, 6, 258408, '{ type: \'tree\',data:{name: \'org\',checkbox:true},textField:\'fvalue\',valueField:\'fvalueId\'}', 1 );-- ----------------------------
-- Table structure for wf_approvalhandlerkind
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalhandlerkind`;
CREATE TABLE `wf_approvalhandlerkind` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`DATA_SOURCE_ID` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '数据源',
`DATA_SOURCE_CONFIG` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '数据源配置',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批人类别' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_approvalhandlerkind
-- ----------------------------
INSERT INTO `wf_approvalhandlerkind`
VALUES
	( '431B20C1FEF3404CB6536411FAB61756', 'ManualSelection', '手工选择', 3, NULL, 5, 6901, 1 );
INSERT INTO `wf_approvalhandlerkind`
VALUES
	( '9E0FE43B087E45938E6F1D9890C4E18A', 'Psm', '人员', 1, '{ type: \'tree\',data:{name: \'org\',filter:\'psm\',minWidth:250},textField:\'handlerName\',valueField:\'handlerId\'}', 2, 322100, 1 );
INSERT INTO `wf_approvalhandlerkind`
VALUES
	( 'BD13E6CEE74B48C4A1153C73995E3BBA', 'Pos', '岗位', 1, '{ type: \'tree\',data:{name: \'org\',minWidth:250,excludePos:0},textField:\'handlerName\',valueField:\'handlerId\'}', 1, 322104, 1 );
INSERT INTO `wf_approvalhandlerkind`
VALUES
	( 'D98DCDFCD1C3463185D37017AD180447', 'ScopeSelection', '范围选择', 2, '{ type: \'tree\',data:{name: \'saOrgFun\',searchName:\'saOrgFun\',searchType:\'sys\',hasSearch :true},back:{code:\'handlerId\',name:\'handlerName\'}}', 6, 908572, 1 );
INSERT INTO `wf_approvalhandlerkind`
VALUES
	( 'E6C74BC4BFB84D3BB9F4B3D228FA261E', 'ManagerFun', '管理员人员函数', 2, '{ type: \'tree\',data:{name: \'saOrgFun\',searchName:\'saOrgFun\',searchType:\'sys\',hasSearch :true},back:{code:\'handlerId\',name:\'handlerName\'}}', 3, 908571, 1 );-- ----------------------------
-- Table structure for wf_approvalrule
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrule`;
CREATE TABLE `wf_approvalrule` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规则ID',
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID',
`PROC_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程ID',
`PROC_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '流程名称',
`PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '环节ID',
`PROC_UNIT_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '环节名称',
`NODE_KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '节点类别 1 分类 2 规则 ',
`NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
`PRIORITY` INT ( 11 ) NULL DEFAULT NULL COMMENT '优先级',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '状态 1 启用 0 禁用',
`REMARK` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`CREATED_BY_NAME` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人姓名',
`CREATED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
`LAST_MODIFIED_DATE` datetime  NULL DEFAULT NULL COMMENT '最后修改时间',
`LAST_MODIFIED_BY_NAME` VARCHAR ( 100 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '最后修改人姓名',
`LAST_MODIFIED_BY_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '最后修改人ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织ID（公司ID：organ_id，以后可扩展为组织ID）',
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`SCOPE_KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '适用范围',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE,
UNIQUE INDEX `PK_WF_APPROVALRULE` ( `ID` ) USING BTREE,
INDEX `IX_APPROVALRULE_PARENT_ID` ( `PARENT_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批规则' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_approvalrule
-- ----------------------------
INSERT INTO `wf_approvalrule`
VALUES
	(
	'CADB7D9A56C8450F8ECF12E666A2F955',
	'1',
	'leave',
	'请假流程',
	'Approve',
	'审批请假条',
	2,
	'请假天数<=3天',
	1,
	1,
	NULL,
	'2019-11-05 17:05:27',
	'系统管理员',
	'5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0',
	'2019-11-05 17:05:44',
	'系统管理员',
	'5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0',
	3575156,
	'E3B4E5C5C6454F81921CF58B7597CE2F',
	'/CADB7D9A56C8450F8ECF12E666A2F955',
	'/请假天数<=3天',
	1,
	'请假天数<=3天',
	1
	);-- ----------------------------
-- Table structure for wf_approvalruleelement
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalruleelement`;
CREATE TABLE `wf_approvalruleelement` (
`APPROVAL_RULE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ApprovalRule',
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`ELEMENT_CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批要素编码',
`FOPERATOR` VARCHAR ( 20 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作符',
`FVALUE_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '值ID',
`FVALUE` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '值',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`ELEMENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批要素ID',
PRIMARY KEY ( `ID` ) USING BTREE,
INDEX `IX_APPROVALRULEELEMENT_MID` ( `APPROVAL_RULE_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批规则要素' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_approvalruleelement
-- ----------------------------
INSERT INTO `wf_approvalruleelement`
VALUES
	( 'CADB7D9A56C8450F8ECF12E666A2F955', 'B80CDD65B0EA475A831D6DFAAE5BA977', 'days', 'LE', '3', NULL, 1, 3575201, NULL );-- ----------------------------
-- Table structure for wf_approvalrulehandler
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrulehandler`;
CREATE TABLE `wf_approvalrulehandler` (
`APPROVAL_RULE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ApprovalRuleID',
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`HANDLER_KIND_CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理权限、部门、岗位、人员成员、函数',
`HANDLER_ID` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批人ID',
`HANDLER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批人',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT ' chief 主审 assistant 协审 cc抄送',
`ALLOW_ADD` INT ( 11 ) NULL DEFAULT NULL COMMENT '允许加签',
`ALLOW_SUBTRACT` INT ( 11 ) NULL DEFAULT NULL COMMENT '允许被减签',
`ALLOW_TRANSFER` INT ( 11 ) NULL DEFAULT NULL COMMENT '允许转交',
`ALLOW_ABORT` INT ( 11 ) NULL DEFAULT NULL COMMENT '允许终止',
`NEED_TIMING` INT ( 11 ) NULL DEFAULT NULL COMMENT '需要计时',
`HELP_SECTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '审批要点',
`CHIEF_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '主审环节ID',
`GROUP_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '分组ID',
`BIZ_HANDLER_PARAM` VARCHAR ( 60 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务处理人参数',
`HANDLER_KIND_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '环节ID',
`MUST_PASS` INT ( 11 ) NULL DEFAULT NULL COMMENT '是否必经节点',
`APPROVAL_HANDLER_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LIMIT_TIME` INT ( 11 ) NULL DEFAULT NULL COMMENT '限制时间',
`SEND_MESSAGE` INT ( 11 ) NULL DEFAULT NULL COMMENT '发送消息',
PRIMARY KEY ( `ID` ) USING BTREE,
UNIQUE INDEX `PK_WF_APPROVALRULEHANDLER` ( `ID` ) USING BTREE,
INDEX `IX_ARH_PARENT_ID1` ( `APPROVAL_RULE_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批规则审批人' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_approvalrulehandler
-- ----------------------------
INSERT INTO `wf_approvalrulehandler`
VALUES
	(
	'CADB7D9A56C8450F8ECF12E666A2F955',
	'1903AD3CAB2F4521A85B3E2CA5B01397',
	'部门领导审批',
	'Psm',
	'5E17123168A376FFE050007F01006612@C18E23AAAA6940E09DF7C122332C51E0',
	'部门领导',
	2,
	NULL,
	NULL,
	1,
	NULL,
	1,
	0,
	1,
	NULL,
	NULL,
	2,
	NULL,
	'leader',
	1,
	NULL,
	NULL,
	1
	);
INSERT INTO `wf_approvalrulehandler`
VALUES
	(
	'CADB7D9A56C8450F8ECF12E666A2F955',
	'769BAEA56587435B96EAE2D79BEF0684',
	'管理员审批',
	'Psm',
	'5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0',
	'系统管理员',
	1,
	3575206,
	NULL,
	1,
	NULL,
	1,
	0,
	1,
	NULL,
	NULL,
	1,
	NULL,
	NULL,
	1,
	NULL,
	0,
	1
	);-- ----------------------------
-- Table structure for wf_approvalrulehandler_auth
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrulehandler_auth`;
CREATE TABLE `wf_approvalrulehandler_auth` (
`HANDLER_AUTH_ID` INT ( 11 ) NOT NULL COMMENT '审批人字段权限主键',
`APPROVAL_RULE_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '审批规则ID',
`HANDLER_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '审批人ID',
`FIELD_CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段编码',
`FIELD_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段名称',
`FIELD_TYPE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段类型',
`FIELD_AUTHORITY` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段权限',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `HANDLER_AUTH_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批人字段权限表' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_approvalrulehandlerassist
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrulehandlerassist`;
CREATE TABLE `wf_approvalrulehandlerassist` (
`APPROVAL_RULE_HANDLER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`HANDLER_ID` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLER_KIND_CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_approvalrulehandlergroup
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrulehandlergroup`;
CREATE TABLE `wf_approvalrulehandlergroup` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`APPROVAL_RULE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_EXECUTE_MODE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`GROUP_ID` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_approvalrulehandleruiperm
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrulehandleruiperm`;
CREATE TABLE `wf_approvalrulehandleruiperm` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '审批人字段权限主键',
`APPROVAL_RULE_HANDLER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批人ID',
`CODE` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段名称',
`KIND_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段类型',
`OPERATION_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段权限',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批人字段权限表' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_approvalrulescope
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_approvalrulescope`;
CREATE TABLE `wf_approvalrulescope` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`APPROVAL_RULE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批规则ID',
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批规则适用范围' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_approvalrulescope
-- ----------------------------
-- ----------------------------
-- Table structure for wf_basesegmentationtype
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_basesegmentationtype`;
CREATE TABLE `wf_basesegmentationtype` (
`BASE_SEGMENTATION_TYPE_ID` BIGINT ( 20 ) NOT NULL COMMENT 'BaseSegmentationTypeID',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`FOLDER_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '文件夹ID',
PRIMARY KEY ( `BASE_SEGMENTATION_TYPE_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '基础分段类' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_bizsegmentation
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_bizsegmentation`;
CREATE TABLE `wf_bizsegmentation` (
`BIZ_SEGMENTATION_ID` BIGINT ( 20 ) NOT NULL COMMENT 'BizSegmentationID',
`ORG_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'Org_ID',
`CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
`NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`KIND_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 私有段 2 公开段 3 私有公开段',
PRIMARY KEY ( `BIZ_SEGMENTATION_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织业务段' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_bizsegmentationauthorize
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_bizsegmentationauthorize`;
CREATE TABLE `wf_bizsegmentationauthorize` (
`BIZ_SEGMENTATION_AUTHORIZE_ID` BIGINT ( 20 ) NOT NULL COMMENT 'SegmentationAuthorizeID',
`BIZ_SEGMENTATION_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT 'BizSegmentationTypeID',
`BASE_SEGMENTATION_TYPE_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT 'BaseSegmentationTypeID',
`ORG_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织Id',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `BIZ_SEGMENTATION_AUTHORIZE_ID` ) USING BTREE,
INDEX `BASESEGMENTATIONTYPE_AUTHORIZE` ( `BASE_SEGMENTATION_TYPE_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织分段授权' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_hi_procunithandler
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_hi_procunithandler`;
CREATE TABLE `wf_hi_procunithandler` (
`ID` BIGINT ( 20 ) NOT NULL,
`BIZ_ID` BIGINT ( 20 ) NULL DEFAULT NULL,
`PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_UNIT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLE_KIND_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLE_KIND_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`HANDLER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORG_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLE_TIME` datetime  NULL DEFAULT NULL,
`RESULT` INT ( 11 ) NULL DEFAULT NULL,
`OPINION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '数据版本',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`COOPERATION_MODEL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_EXECUTE_MODE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`GROUP_ID` INT ( 11 ) NULL DEFAULT NULL,
`CHIEF_ID` INT ( 11 ) NULL DEFAULT NULL,
`APPROVAL_RULE_HANDLER_ID` INT ( 11 ) NULL DEFAULT NULL,
`APPROVAL_RULE_ID` INT ( 11 ) NULL DEFAULT NULL,
`ASSISTANT_SEQUENCE` DECIMAL ( 65, 30 ) NULL DEFAULT NULL,
`BIZ_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`OPERATE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作类型 add delete ',
`OPERATOR_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERS` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本',
`OPERATOR_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理人',
PRIMARY KEY ( `ID` ) USING BTREE,
INDEX `IDX_HI_PROCUNITHANDLER_BIZCODE` ( `BIZ_CODE` ) USING BTREE,
INDEX `IDX_HI_PROCUNITHANDLER_BIZID` ( `BIZ_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_hi_procunithandlerinst
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_hi_procunithandlerinst`;
CREATE TABLE `wf_hi_procunithandlerinst` (
`ID` BIGINT ( 20 ) NOT NULL,
`BIZ_ID` DECIMAL ( 65, 30 ) NULL DEFAULT NULL,
`PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERS` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE,
INDEX `IDX_HI_PROCUNITHANDLERINST_BP` ( `PROC_UNIT_ID`, `BIZ_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_procapprovalelement
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_procapprovalelement`;
CREATE TABLE `wf_procapprovalelement` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '流程审批要素ID',
`PROC_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程ID',
`PROC_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '流程名称',
`PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '环节ID',
`PROC_UNIT_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '环节名称',
`ELEMENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批要素ID',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
`PROC_KEY` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '流程Key',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '流程审批要素' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_procapprovalelement
-- ----------------------------
INSERT INTO `wf_procapprovalelement`
VALUES
	( '9172C074EB0049DCA732DF86DA158554', '53482F79BD5143218F40F89E5312A5FB', NULL, NULL, NULL, 'CF322D7E172D4E228D5B2D6D1C485BCE', 1, NULL, 3575196 );-- ----------------------------
-- Table structure for wf_procdef
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_procdef`;
CREATE TABLE `wf_procdef` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`CODE` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NAME` VARCHAR ( 512 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PARENT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`DESCRIPTION` VARCHAR ( 1200 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`APPROVAL_BRIDGE_PROC_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NODE_KIND_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`NEED_TIMING` INT ( 11 ) NULL DEFAULT NULL,
`FULL_NAME` VARCHAR ( 2048 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`FULL_ID` VARCHAR ( 1024 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SHOW_QUERY_HANDLERS` INT ( 11 ) NULL DEFAULT NULL,
`PROC_ID` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_NAME` VARCHAR ( 256 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`LIMIT_TIME` INT ( 11 ) NULL DEFAULT NULL,
`ASSISTANT_MUST_APPROVE` INT ( 11 ) NULL DEFAULT NULL,
`MERGE_HANDLER_KIND` INT ( 11 ) NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_procdef
-- ----------------------------
INSERT INTO `wf_procdef`
VALUES
	(
	'1',
	'1',
	'流程树',
	'0',
	1,
	NULL,
	1,
	1,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	1,
NULL
	);-- ----------------------------
-- Table structure for wf_procunithandler
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_procunithandler`;
CREATE TABLE `wf_procunithandler` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`BIZ_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
`PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '环节ID',
`PROC_UNIT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '环节名称',
`SUB_PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '子环节ID',
`SUB_PROC_UNIT_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '子环节名称',
`HANDLER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人ID',
`HANDLER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人姓名',
`POSITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '岗位ID',
`POSITION_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '岗位',
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门ID',
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门',
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构ID',
`ORG_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构',
`HANDLED_DATE` datetime  NULL DEFAULT NULL COMMENT '处理时间',
`RESULT` INT ( 11 ) NULL DEFAULT NULL COMMENT '处理结果',
`OPINION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理意见',
`STATUS` INT ( 11 ) NULL DEFAULT NULL COMMENT '1 启用 0 禁用',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '主审序号',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`COOPERATION_MODEL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '协作模式 chief 主审 assistant 协审',
`TASK_EXECUTE_MODE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '任务执行模式 preempt 抢占模式 sequential 顺序执行 simultaneous 并行执行',
`GROUP_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '分组ID',
`CHIEF_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主审人ID',
`APPROVAL_RULE_HANDLER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批规则处理人ID',
`APPROVAL_RULE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批规则ID',
`ASSISTANT_SEQUENCE` INT ( 11 ) NULL DEFAULT NULL COMMENT '协审序号',
`BIZ_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务编码',
`PRINCIPAL_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '委托人ID',
`PRINCIPAL_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '委托人ID',
`EXECUTION_TIMES` INT ( 11 ) NULL DEFAULT NULL COMMENT '执行次数',
`SEND_MESSAGE` INT ( 11 ) NULL DEFAULT NULL COMMENT '发送消息',
PRIMARY KEY ( `ID` ) USING BTREE,
INDEX `IDX_PROCUNITHANDLER_BIZCODE` ( `BIZ_CODE` ) USING BTREE,
INDEX `IDX_PROCUNITHANDLER_BIZID` ( `BIZ_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '环节处理人' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_procunithandler
-- ----------------------------
-- ----------------------------
-- Table structure for wf_procunithandler_cache
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_procunithandler_cache`;
CREATE TABLE `wf_procunithandler_cache` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL,
`BIZ_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PROC_UNIT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUB_PROC_UNIT_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`SUB_PROC_UNIT_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`HANDLER_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLER_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`POSITION_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`DEPT_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORG_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ORG_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`HANDLED_DATE` datetime  NULL DEFAULT NULL,
`RESULT` INT ( 11 ) NULL DEFAULT NULL,
`OPINION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`STATUS` INT ( 11 ) NULL DEFAULT NULL,
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL,
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL,
`FULL_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`FULL_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL,
`COOPERATION_MODEL_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`TASK_EXECUTE_MODE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`GROUP_ID` INT ( 11 ) NULL DEFAULT NULL,
`CHIEF_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPROVAL_RULE_HANDLER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`APPROVAL_RULE_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`ASSISTANT_SEQUENCE` INT ( 11 ) NULL DEFAULT NULL,
`BIZ_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PRINCIPAL_ID` VARCHAR ( 65 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
`PRINCIPAL_NAME` VARCHAR ( 128 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_procunithandlermanuscript
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_procunithandlermanuscript`;
CREATE TABLE `wf_procunithandlermanuscript` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`BIZ_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
`PROC_UNIT_HANDLER_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '环节处理人ID',
`HEIGHT` INT ( 11 ) NULL DEFAULT NULL COMMENT '高度',
`OPINION_30` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理意见',
`OPINION_64` LONGTEXT CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理意见',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_segmentationhandler
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_segmentationhandler`;
CREATE TABLE `wf_segmentationhandler` (
`SEGMENTATION_HANDLER_ID` BIGINT ( 20 ) NOT NULL COMMENT 'SegmentationHandlerID',
`SEGMENTATION_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT 'SegmentationID',
`DESCRIPTION` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
`HANDLER_KIND_CODE` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理权限、部门、岗位、人员成员、函数',
`HANDLER_ID` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理人ID',
`HANDLER_NAME` text CHARACTER
SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理人名称',
`GROUP_ID` INT ( 11 ) NULL DEFAULT NULL COMMENT '分组ID',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
`SEQUENCE` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '排序号',
PRIMARY KEY ( `SEGMENTATION_HANDLER_ID` ) USING BTREE,
INDEX `BIZSEGMENTATION_HANDLER_FK` ( `SEGMENTATION_ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织业务段处理人' ROW_FORMAT = Dynamic;-- ----------------------------
-- Table structure for wf_taskcollection
-- ----------------------------
DROP TABLE
IF
	EXISTS `wf_taskcollection`;
CREATE TABLE `wf_taskcollection` (
`ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
`TASK_ID` VARCHAR ( 64 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '任务ID',
`PERSON_ID` VARCHAR ( 32 ) CHARACTER
SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '人员ID',
`CREATED_DATE` datetime  NULL DEFAULT NULL COMMENT '创建时间',
`VERSION` BIGINT ( 20 ) NULL DEFAULT NULL COMMENT '版本号',
PRIMARY KEY ( `ID` ) USING BTREE
) ENGINE = INNODB CHARACTER
SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户收藏任务' ROW_FORMAT = Dynamic;-- ----------------------------
-- Records of wf_taskcollection
-- ----------------------------
-- View structure for v_act_hi_procinst
-- ----------------------------
DROP VIEW
IF
	EXISTS `v_act_hi_procinst`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_act_hi_procinst` AS SELECT
`pe`.`ID_` AS `PROC_INST_ID_`,
`pe`.`BUSINESS_KEY_` AS `BUSINESS_KEY_`,
`pe`.`PROC_DEF_ID_` AS `PROC_DEF_ID_`,
`pe`.`KEY_` AS `PROCESS_DEFINITION_KEY_`,
`pdf`.`FULL_ID` AS `PROC_FULL_ID`,
`pdf`.`FULL_NAME` AS `PROC_FULL_NAME`,
`pdf`.`NAME` AS `PROC_NAME`,
substr( `pdf`.`FULL_NAME`, 2, locate( '/', substr( `pdf`.`FULL_NAME`, 1 ) ) ) AS `PROC_SYS_NAME`,
`pe`.`START_TIME_` AS `START_TIME_`,
`pe`.`END_TIME_` AS `END_TIME_`,
`pe`.`APPLICANT_PERSON_MEMBER_ID_` AS `APPLICANT_PERSON_MEMBER_ID_`,
`pe`.`APPLICANT_PERSON_MEMBER_NAME_` AS `APPLICANT_PERSON_MEMBER_NAME_`,
`pe`.`APPLICANT_DEPT_NAME_` AS `APPLICANT_DEPT_NAME_`,
`pe`.`APPLICANT_ORG_NAME_` AS `APPLICANT_ORG_NAME_`,
`pe`.`STATUS_ID_` AS `PROC_STATUS_ID_`
FROM
	(
	`wf_procdef` `pdf`
	LEFT JOIN ( `act_hi_procinst_extension` `pe` JOIN `act_re_procdef` `pd` ON ( ( `pe`.`PROC_DEF_ID_` = `pd`.`ID_` ) ) ) ON ( ( `pd`.`KEY_` = `pdf`.`PROC_ID` ) )
	)
WHERE
	( `pdf`.`NODE_KIND_ID` = 'proc' );-- ----------------------------
-- View structure for v_sa_oporg_exclude_pos
-- ----------------------------
DROP VIEW
IF
	EXISTS `v_sa_oporg_exclude_pos`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_sa_oporg_exclude_pos` AS SELECT
`sa_oporg`.`ID` AS `ID`,
`sa_oporg`.`TYPE_ID` AS `TYPE_ID`,
`sa_oporg`.`CODE` AS `CODE`,
`sa_oporg`.`NAME` AS `NAME`,
`sa_oporg`.`LONG_NAME` AS `LONG_NAME`,
( CASE `sa_oporg`.`ORG_KIND_ID` WHEN 'psm' THEN `sa_oporg`.`DEPT_ID` ELSE `sa_oporg`.`PARENT_ID` END ) AS `PARENT_ID`,
`sa_oporg`.`FULL_ID` AS `FULL_ID`,
`sa_oporg`.`FULL_CODE` AS `FULL_CODE`,
`sa_oporg`.`FULL_NAME` AS `FULL_NAME`,
`sa_oporg`.`ORG_KIND_ID` AS `ORG_KIND_ID`,
`sa_oporg`.`DEPTH` AS `DEPTH`,
`sa_oporg`.`PERSON_ID` AS `PERSON_ID`,
`sa_oporg`.`NODE_KIND_ID` AS `NODE_KIND_ID`,
`sa_oporg`.`DESCRIPTION` AS `DESCRIPTION`,
`sa_oporg`.`STATUS` AS `STATUS`,
`sa_oporg`.`SEQUENCE` AS `SEQUENCE`,
`sa_oporg`.`VERSION` AS `VERSION`,
`sa_oporg`.`ORG_CODE` AS `ORG_CODE`,
`sa_oporg`.`DEPT_CODE` AS `DEPT_CODE`,
`sa_oporg`.`POSITION_CODE` AS `POSITION_CODE`,
`sa_oporg`.`PERSON_MEMBER_CODE` AS `PERSON_MEMBER_CODE`,
`sa_oporg`.`IS_CENTER` AS `IS_CENTER`,
`sa_oporg`.`CENTER_CODE` AS `CENTER_CODE`,
`sa_oporg`.`ORG_ID` AS `ORG_ID`,
`sa_oporg`.`DEPT_ID` AS `DEPT_ID`,
`sa_oporg`.`POSITION_ID` AS `POSITION_ID`,
`sa_oporg`.`PERSON_MEMBER_ID` AS `PERSON_MEMBER_ID`,
`sa_oporg`.`CENTER_ID` AS `CENTER_ID`,
`sa_oporg`.`ORG_NAME` AS `ORG_NAME`,
`sa_oporg`.`DEPT_NAME` AS `DEPT_NAME`,
`sa_oporg`.`POSITION_NAME` AS `POSITION_NAME`,
`sa_oporg`.`PERSON_MEMBER_NAME` AS `PERSON_MEMBER_NAME`,
`sa_oporg`.`CENTER_NAME` AS `CENTER_NAME`,
`sa_oporg`.`FULL_SEQUENCE` AS `FULL_SEQUENCE`,
`sa_oporg`.`FULL_ORG_KIND_ID` AS `FULL_ORG_KIND_ID`,
`sa_oporg`.`IS_VIRTUAL` AS `IS_VIRTUAL`
FROM
	`sa_oporg`
WHERE
	( `sa_oporg`.`ORG_KIND_ID` <> 'pos' );-- ----------------------------
-- Function structure for next_sequence
-- ----------------------------
DROP FUNCTION
IF
	EXISTS `next_sequence`;
CREATE FUNCTION `next_sequence`( seq_name VARCHAR ( 128 ) ) RETURNS bigint(20)
    DETERMINISTIC
BEGIN
DECLARE
	val BIGINT;
SELECT
	next_val INTO val
FROM
	hibernate_sequences
WHERE
	sequence_name = seq_name;
IF val is null THEN
	SIGNAL SQLSTATE 'HY000' SET MESSAGE_TEXT = '序列不存在或者序列未设置初始值';
END IF;

UPDATE hibernate_sequences
SET next_val = next_val + 1
WHERE
	sequence_name = seq_name;
RETURN val;

END


ALTER TABLE WF_ApprovalRuleHandlerGroup ADD COLUMN LIMIT_HANDLER INT NULL COMMENT '分组最少审批人数';
ALTER TABLE wf_procunithandler ADD COLUMN LIMIT_HANDLER INT NULL COMMENT '分组最少审批人数';
ALTER TABLE wf_procunithandler_cache ADD COLUMN LIMIT_HANDLER INT NULL COMMENT '分组最少审批人数';

SET FOREIGN_KEY_CHECKS = 1;