/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.sysfunc;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.rfc.api.GatewayRegInfo;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.data.RFCSI;
import com.sap.conn.rfc.data.RfcIntParameter;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Calendar;
import java.util.Date;

public final class RfcSystemInfo
implements IRfcFunction {
    private static final String[] documentation = new String[]{"Returns some information about the system environment.", "", "EXPORTING", "  RFCSI_EXPORT    LIKE RFCSI"};

    public String getName() {
        return "RFC_SYSTEM_INFO";
    }

    public void execute(RfcIoOpenCntl act_cntl) throws RfcException {
        act_cntl.RfcGetData(null, null, null, null, null);
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        GatewayRegInfo gwRegInfo = RfcApi.runtime.getGatewayRegInfo(act_cntl);
        IRfcParameter[] exp = gwRegInfo == null ? new IRfcParameter[1] : new IRfcParameter[3];
        exp[0] = rfcsi;
        DefaultStructure rfcsiStructure = rfcsi.getStructure();
        rfcsiStructure.setValue(0, "011");
        rfcsiStructure.setValue(1, AbSysInfo.charset);
        if (AbSysInfo.intformat == 1) {
            rfcsiStructure.setValue(2, "LIT");
        } else {
            rfcsiStructure.setValue(2, "BIG");
        }
        rfcsiStructure.setValue(3, "IE3");
        if (Environment.inJTS()) {
            rfcsiStructure.setValue(4, AbSysInfo.callerID);
        } else {
            rfcsiStructure.setValue(4, AbSysInfo.programName);
        }
        rfcsiStructure.setValue(5, AbSysInfo.host);
        rfcsiStructure.setValue(6, AbSysInfo.systemID);
        rfcsiStructure.setValue(10, "721");
        String value = JCo.getMiddlewareProperty("jco.middleware.native_layer_version");
        if (value != null) {
            int idx = value.indexOf(46);
            if (idx > 0 && idx < 4) {
                value = value.substring(0, idx);
            }
        } else {
            value = "721";
        }
        rfcsiStructure.setValue(16, value);
        rfcsiStructure.setValue(17, AbSysInfo.host);
        rfcsiStructure.setValue(15, AbSysInfo.ipAddress);
        if (AbSysInfo.ipv6Address != null) {
            rfcsiStructure.setValue(19, AbSysInfo.ipv6Address);
        }
        if ((value = System.getProperty("os.name")) != null) {
            if (value.length() > 10 && value.startsWith("Windows ")) {
                if (value.charAt(9) == '.') {
                    value = value.substring(0, 9);
                } else if (value.charAt(10) != '.') {
                    if ((value = value.substring(8)).startsWith("Server ")) {
                        value = value.substring(7);
                    }
                    StringBuilder sb = new StringBuilder(value.length() + 4);
                    sb.append("Win ").append(value);
                    if (sb.length() > 10 && sb.charAt(8) == ' ' && sb.charAt(9) == 'R' && sb.charAt(10) <= '9') {
                        sb.deleteCharAt(8);
                    }
                    value = sb.toString();
                }
            }
            rfcsiStructure.setValue(12, value);
        }
        Calendar calendar = Calendar.getInstance();
        rfcsiStructure.setValue(13, calendar.get(15) / 1000);
        rfcsiStructure.setValue(14, calendar.getTimeZone().inDaylightTime(new Date()) ? (char)'X' : ' ');
        if (gwRegInfo != null) {
            RfcIntParameter CURRENT_RESOURCES = new RfcIntParameter("CURRENT_RESOURCES");
            exp[1] = CURRENT_RESOURCES;
            CURRENT_RESOURCES.setInt(gwRegInfo.getWaiting());
            RfcIntParameter MAXIMAL_RESOURCES = new RfcIntParameter("MAXIMAL_RESOURCES");
            exp[2] = MAXIMAL_RESOURCES;
            MAXIMAL_RESOURCES.setInt(gwRegInfo.getTotal());
        }
        act_cntl.RfcSendData(exp, null, null);
        act_cntl.flushServerConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultStructure clientExecute(RfcIoOpenCntl act_cntl) throws RfcException {
        boolean isStateless;
        IRfcParameter[] exp = new IRfcParameter[1];
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        exp[0] = rfcsi;
        boolean isClient = act_cntl.rfc_role == 'C';
        boolean bl = isStateless = !act_cntl.isStateful();
        if (isClient && isStateless) {
            act_cntl.setStateful(true);
        }
        try {
            act_cntl.RfcCallReceive("RFC_SYSTEM_INFO", null, exp, null, null);
            Object var7_6 = null;
            if (isClient && isStateless) {
                act_cntl.setStateful(false);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (isClient && isStateless) {
                act_cntl.setStateful(false);
            }
            throw throwable;
        }
        return rfcsi.getStructure();
    }

    public String[] getDocumentation() {
        return documentation;
    }
}

