/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectList<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2667675730898011170L;
    protected Object[] m_list = null;
    protected int m_size = 0;
    protected int m_capacityIncrement = 0;
    protected transient int m_idxLastAccess = 0;

    public ObjectList() {
        this(10, 0);
    }

    public ObjectList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ObjectList(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity < 0 [" + initialCapacity + "<0]");
        }
        if (capacityIncrement < 0) {
            throw new IllegalArgumentException("capacityIncrement < 0 [" + capacityIncrement + "<0]");
        }
        this.m_list = new Object[initialCapacity];
        this.m_capacityIncrement = capacityIncrement;
    }

    public ObjectList(E[] objectArray) {
        this(objectArray, 0);
    }

    public ObjectList(E[] objectArray, int capacityIncrement) {
        if (objectArray == null) {
            throw new IllegalArgumentException("objectArray == null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("objectArray[" + i + "] == null");
        }
        if (capacityIncrement < 0) {
            throw new IllegalArgumentException("capacityIncrement < 0 [" + capacityIncrement + "<0]");
        }
        this.m_list = (Object[])objectArray.clone();
        this.m_size = objectArray.length;
        this.m_capacityIncrement = capacityIncrement;
    }

    public final boolean add(E object) {
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        if (this.m_size == this.m_list.length) {
            Object[] oldList = this.m_list;
            this.m_list = this.m_capacityIncrement <= 0 ? (this.m_size > 0 ? new Object[this.m_size * 2] : new Object[1]) : new Object[this.m_size + this.m_capacityIncrement];
            System.arraycopy(oldList, 0, this.m_list, 0, this.m_size);
        }
        this.m_idxLastAccess = this.m_size;
        this.m_list[this.m_size++] = object;
        return true;
    }

    public final void add(int index, E object) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index > this.m_size) {
            throw new IndexOutOfBoundsException("index > size() [" + index + ">" + this.m_size + "]");
        }
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        Object[] oldList = this.m_list;
        if (this.m_size == this.m_list.length) {
            this.m_list = this.m_capacityIncrement <= 0 ? (this.m_size > 0 ? new Object[this.m_size * 2] : new Object[1]) : new Object[this.m_size + this.m_capacityIncrement];
            System.arraycopy(oldList, 0, this.m_list, 0, index);
        }
        System.arraycopy(oldList, index, this.m_list, index + 1, this.m_size - index);
        this.m_idxLastAccess = index;
        this.m_list[index] = object;
        ++this.m_size;
    }

    public final int addAfter(E afterObject, E newObject) {
        if (newObject == null) {
            throw new IllegalArgumentException("newObject == null");
        }
        int addedIndex = this.indexOf(afterObject, this.m_idxLastAccess, true, true);
        if (addedIndex >= 0) {
            this.add(++addedIndex, newObject);
        }
        return addedIndex;
    }

    public final boolean addAll(E[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("objectArray == null");
        }
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("objectArray.length == 0");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("objectArray[" + i + "] == null");
        }
        if (this.m_size + objectArray.length > this.m_list.length) {
            Object[] oldList = this.m_list;
            int newCapacity = 0;
            if (this.m_capacityIncrement <= 0) {
                int minCapacity = this.m_size + objectArray.length;
                for (newCapacity = this.m_list.length > 0 ? this.m_list.length * 2 : 1; newCapacity < minCapacity; newCapacity *= 2) {
                }
            } else {
                int lack = this.m_size + objectArray.length - this.m_list.length;
                int factor = lack / this.m_capacityIncrement + (lack % this.m_capacityIncrement > 0 ? 1 : 0);
                newCapacity = this.m_list.length + factor * this.m_capacityIncrement;
            }
            this.m_list = new Object[newCapacity];
            System.arraycopy(oldList, 0, this.m_list, 0, this.m_size);
        }
        System.arraycopy(objectArray, 0, this.m_list, this.m_size, objectArray.length);
        this.m_size += objectArray.length;
        this.m_idxLastAccess = this.m_size - 1;
        return true;
    }

    public final int addBefore(E beforeObject, E newObject) {
        if (newObject == null) {
            throw new IllegalArgumentException("newObject == null");
        }
        int addedIndex = this.indexOf(beforeObject, this.m_idxLastAccess, false, true);
        if (addedIndex >= 0) {
            this.add(addedIndex, newObject);
        }
        return addedIndex;
    }

    public final int capacity() {
        return this.m_list.length;
    }

    public final void clear() {
        for (int i = 0; i < this.m_size; ++i) {
            this.m_list[i] = null;
        }
        this.m_size = 0;
        this.m_idxLastAccess = 0;
    }

    public final ObjectList<E> clone() {
        try {
            ObjectList objectList = (ObjectList)super.clone();
            objectList.m_list = (Object[])this.m_list.clone();
            return objectList;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public final boolean contains(E object) {
        return this.indexOf(object, 0, true, false) > -1;
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.m_list.length) {
            return;
        }
        Object[] oldList = this.m_list;
        this.m_list = new Object[minCapacity];
        System.arraycopy(oldList, 0, this.m_list, 0, this.m_size);
    }

    public final E first() {
        if (this.m_size == 0) {
            return null;
        }
        this.m_idxLastAccess = 0;
        return (E)this.m_list[0];
    }

    public final E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.m_size) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.m_size + "]");
        }
        this.m_idxLastAccess = index;
        return (E)this.m_list[index];
    }

    public final E getNext(E object) {
        Object nextObject = null;
        int index = this.indexOf(object, this.m_idxLastAccess, true, true);
        if (index >= 0 && index + 1 < this.m_size) {
            nextObject = this.m_list[index + 1];
            this.m_idxLastAccess = index + 1;
        }
        return (E)nextObject;
    }

    public final E getPrevious(E object) {
        Object previousObject = null;
        int index = this.indexOf(object, this.m_idxLastAccess, false, true);
        if (index > 0) {
            previousObject = this.m_list[index - 1];
            this.m_idxLastAccess = index - 1;
        }
        return (E)previousObject;
    }

    public final int indexOf(E object) {
        return this.indexOf(object, 0, true, false);
    }

    public final int indexOf(E object, int startIndex) {
        return this.indexOf(object, startIndex, true, false);
    }

    public final int indexOf(E object, int startIndex, boolean searchForward) {
        return this.indexOf(object, startIndex, searchForward, false);
    }

    public final int indexOf(E object, int startIndex, boolean searchForward, boolean wrapAround) {
        block11: {
            int i;
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("startIndex < 0 [" + startIndex + "<0]");
            }
            if (startIndex > 0 && startIndex >= this.m_size) {
                throw new IndexOutOfBoundsException("startIndex >= size() [" + startIndex + ">=" + this.m_size + "]");
            }
            if (object == null) break block11;
            if (searchForward) {
                for (i = startIndex; i < this.m_size; ++i) {
                    if (!object.equals(this.m_list[i])) continue;
                    return i;
                }
            } else {
                for (i = startIndex; i >= 0; --i) {
                    if (!object.equals(this.m_list[i])) continue;
                    return i;
                }
            }
            if (wrapAround) {
                if (searchForward) {
                    for (i = 0; i < startIndex; ++i) {
                        if (!object.equals(this.m_list[i])) continue;
                        return i;
                    }
                } else {
                    for (i = this.m_size - 1; i > startIndex; --i) {
                        if (!object.equals(this.m_list[i])) continue;
                        return i;
                    }
                }
            }
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public final E last() {
        if (this.m_size == 0) {
            return null;
        }
        this.m_idxLastAccess = this.m_size - 1;
        return (E)this.m_list[this.m_idxLastAccess];
    }

    public final int lastIndexOf(E object) {
        if (this.m_size == 0) {
            return -1;
        }
        return this.indexOf(object, this.m_size - 1, false, false);
    }

    public final E peek() {
        return this.last();
    }

    public final E pop() {
        if (this.m_size == 0) {
            return null;
        }
        Object object = this.m_list[--this.m_size];
        this.m_list[this.m_size] = null;
        this.m_idxLastAccess = this.m_size > 0 ? this.m_size - 1 : 0;
        return (E)object;
    }

    public final E push(E object) {
        this.add(object);
        return object;
    }

    public final E remove(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.m_size) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.m_size + "]");
        }
        Object removedObject = this.m_list[index];
        int numToMove = this.m_size - index - 1;
        if (numToMove > 0) {
            System.arraycopy(this.m_list, index + 1, this.m_list, index, numToMove);
        }
        this.m_list[--this.m_size] = null;
        this.m_idxLastAccess = index < this.m_size ? index : (this.m_size > 0 ? this.m_size - 1 : 0);
        return (E)removedObject;
    }

    public final boolean remove(E object) {
        int index = this.indexOf(object, this.m_idxLastAccess, true, true);
        if (index >= 0) {
            this.remove(index);
        }
        return index >= 0;
    }

    public final boolean removeAll(E[] objects) {
        boolean removed = false;
        if (objects != null) {
            int index = 0;
            for (int i = 0; i < objects.length; ++i) {
                index = this.indexOf(objects[i], this.m_idxLastAccess, true, true);
                if (index < 0) continue;
                this.remove(index);
                removed = true;
            }
        }
        return removed;
    }

    public final E set(int index, E object) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.m_size) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.m_size + "]");
        }
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        Object replacedObject = this.m_list[index];
        this.m_list[index] = object;
        this.m_idxLastAccess = index;
        return (E)replacedObject;
    }

    public final int size() {
        return this.m_size;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.m_size];
        System.arraycopy(this.m_list, 0, array, 0, this.m_size);
        return array;
    }

    public final void trimToSize() {
        if (this.m_size == this.m_list.length) {
            return;
        }
        Object[] oldList = this.m_list;
        this.m_list = new Object[this.m_size];
        System.arraycopy(oldList, 0, this.m_list, 0, this.m_size);
    }
}

