/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCCCErrInfo;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.tc.logging.Location;

public class ConvertSimpleBase
extends ConvertBase {
    public static final boolean CNV_ERR_IGNORE = true;
    public static final boolean CNV_ERR_ABORT = false;
    public static final boolean INIT_ERR_IGNORE = false;
    public static final boolean INIT_ERR_ABORT = true;
    public static final int SAP_O_K = 0;
    public static final int RSCPEINTERN = 1;
    public static final int RSCPEIO = 8;
    public static final int RSCPEINVAL = 16;
    public static final int RSCPETOOLONG = 32;
    public static final int RSCPECALL = 64;
    public static final int RSCPENOOBJ = 128;
    public static final int RSCPEBUSY = 256;
    public static final int RSCPEUNIQ = 512;
    public static final int RSCPENOCONV = 2048;
    public static final int RSCPEBADO = 4096;
    public static final int RSCPEODATA = 8192;
    public static final int RSCPEROLLBACK = 16384;
    public static final int REPL_CHAR = 35;
    private static final Location m_oLoc = Location.getLocation("com.sap.i18n.cp.ConvertSimpleBase");
    public static final int RSCP_NO_SHORT_CNV = 0;
    public static final int RSCP_SB2UC = 1;
    public static final int RSCP_DB2UC = 2;
    public static final int RSCP_UC2SB = 3;
    public static final int RSCP_UC2DB = 4;
    protected boolean m_bCnvObjInit;
    protected byte[] m_aCnvObj;
    protected char[] m_sInCp;
    protected char[] m_sOutCp;
    protected boolean m_bIgnoreErr;

    public ConvertSimpleBase(char[] sInCp, char[] sOutCp, boolean bIgnoreErr, boolean bFailOnErr) {
        this.m_sInCp = sInCp;
        this.m_sOutCp = sOutCp;
        this.m_bIgnoreErr = bIgnoreErr;
        ConvertSimpleBase.CheckConverterJNIAvailable();
        int[] aRet = new int[]{0, 0};
        this.m_aCnvObj = ConverterJNI.ConvertInit(sInCp, sOutCp, bIgnoreErr, aRet);
        if (aRet[0] != 0) {
            this.m_bCnvObjInit = false;
            this.m_oCnvLastErr = new ConvertCCCErrInfo("Init converter object", sInCp, sOutCp, aRet[0]);
            if (bFailOnErr) {
                ConvertSimpleBase.throwConverterRuntimeException(m_oLoc, this.m_oCnvLastErr.GetText());
            }
            m_oLog.errorT(m_oLoc, "ConvertInit failed", "ConvertInit failed. RscpInfo: {0}", new Object[]{this.m_oCnvLastErr.GetText()});
        } else {
            this.m_bCnvObjInit = true;
        }
    }

    public boolean InitOk() {
        return this.m_bCnvObjInit;
    }

    public String getCnvDisplayText() {
        String sInCp = ConvertSimpleBase.getCpDisplayText(this.m_sInCp);
        String sOutCp = ConvertSimpleBase.getCpDisplayText(this.m_sOutCp);
        String sShortcut = this.isShortcut() ? " (Shortcut)" : "";
        return sInCp + "->" + sOutCp + sShortcut;
    }

    public static String getCpDisplayText(char[] acCp) {
        String sCp = new String(acCp);
        if (sCp.equals("0000")) {
            return "Unicode";
        }
        if (sCp.equals("1101")) {
            return "ASCII";
        }
        return "code page " + sCp;
    }

    protected static void checkFatalReturn(Location oLoc, ConvertCCCErrInfo oErrInfo, boolean bIgnoreErr) {
        switch (oErrInfo.m_nRet) {
            case 0: {
                return;
            }
            case 16: 
            case 32: 
            case 512: 
            case 2048: {
                if (bIgnoreErr) {
                    ConvertBase.throwConverterRuntimeException(oLoc, oErrInfo.GetText());
                }
                return;
            }
        }
        ConvertBase.throwConverterRuntimeException(oLoc, oErrInfo.GetText());
    }

    protected boolean isShortcut() {
        return false;
    }

    static boolean isIgnorableReturn(int nRet) {
        switch (nRet) {
            case 0: 
            case 512: 
            case 2048: {
                return true;
            }
        }
        return false;
    }

    int GetShortcutType() {
        if (!this.m_bCnvObjInit) {
            return 0;
        }
        return ConverterJNI.GetShortcutType(this.m_aCnvObj);
    }

    protected void checkShortcutLoaded(int nRet) {
        if (nRet != 0) {
            this.m_oCnvLastErr = new ConvertCCCErrInfo("Load shortcut", this.m_sInCp, this.m_sOutCp, nRet);
            m_oLoc.infoT("Load shortcut failed", "Load shortcut failed. RscpInfo: {0}", new Object[]{this.m_oCnvLastErr.GetText()});
        }
    }
}

