/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.data;

import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.engine.Compress;
import com.sap.conn.rfc.engine.RfcUtilities;

public abstract class ItStream {
    public static final int ITS_OK = 0;
    public static final int ITS_EOF = -1;
    public static final int ITS_ERROR = -2;
    public static final int ITSMODE_WRITE = 2;
    public static final int ITSMODE_FORMAT = 1;
    public static final int ITSMODE_READ = 4;
    public static final int ITS_CLOSED = 0;
    public static final int ITS_WRITE = 2;
    public static final int ITS_WRITE_FORMAT = 3;
    public static final int ITS_READ = 4;
    public static final int ITS_READ_FORMAT = 5;
    public static final int ITS_READ_WRITE = 6;
    public static final int ITS_MAGIC_0 = 123;
    public static final int ITS_MAGIC_1_NOCONV = 0;
    public static final int ITS_MAGIC_1_LZ = 1;
    public static final int ITS_MAGIC_1_LZH = 2;
    public static final int ITS_MAGIC_3 = 234;
    public static final int CS_NORMAL_COMPRESS = 0;
    public static final int CS_INIT_COMPRESS = 1;
    public static final int CS_INIT_DECOMPRESS = 1;
    public static final int CS_LZH = 2;
    public static final int CS_HEAD_SIZE = 8;
    public static final int CS_END_INBUFFER = 3;
    public static final int CS_END_OUTBUFFER = 2;
    public static final int CS_END_OF_STREAM = 1;
    public static final int CS_OK = 0;
    public static final int COMPRESS_SIZE_OUT = 2048;
    public static final int COMPRESS_SIZE_IN = 4096;
    public static final int DECOMPRESS_SIZE_IN = 2048;
    public static final int DECOMPRESS_SIZE_OUT = 4096;

    public static int compress(IRfcTable lzTable, IRfcTable inputTable) {
        byte[] outbuffer = new byte[2080];
        byte[] buffer = new byte[4128];
        TableInputStream tableInputStream = new TableInputStream(inputTable);
        LZTableOutputStream lzOutputStream = new LZTableOutputStream(lzTable);
        int csHandle = 0;
        int orglen = inputTable.getNumRows() * inputTable.getRowLength();
        int option = 1;
        int bytes_read = 0;
        int bytes_compressed = 0;
        int lenout = 2048;
        int sumout = 0;
        int csrc = 0;
        int pout = 0;
        int p = 0;
        int len = 0;
        csHandle = Compress.CsRGetHandle();
        csrc = Compress.CsRInitCompress(csHandle, outbuffer, orglen, 2);
        if (csrc != 0) {
            Compress.CsRCloseHandle(csHandle);
            return -2;
        }
        lzOutputStream.write(outbuffer, 0, 8);
        csrc = 0;
        option = 0;
        while (true) {
            if (csrc == 2) {
                len -= bytes_read;
                p += bytes_read;
                if (sumout != 0) {
                    lzOutputStream.write(outbuffer, 0, sumout);
                }
                sumout = 0;
                lenout = 2048;
                pout = 0;
            } else {
                len = tableInputStream.read(buffer, 0, 4096);
                p = 0;
                pout += bytes_compressed;
                lenout -= bytes_compressed;
            }
            int[] comp_res = new int[3];
            Compress.CsRCompress(csHandle, orglen, buffer, p, Math.max(len, 0), outbuffer, pout, lenout, option, comp_res);
            bytes_read = comp_res[0];
            bytes_compressed = comp_res[1];
            csrc = comp_res[2];
            if (csrc < 0) {
                Compress.CsRCloseHandle(csHandle);
                return 1000 + -csrc;
            }
            sumout += bytes_compressed;
            if (csrc == 1) {
                if (sumout <= 0) break;
                lzOutputStream.write(outbuffer, 0, sumout);
                break;
            }
            option = 0;
        }
        lzOutputStream.flush(2);
        Compress.CsRCloseHandle(csHandle);
        return 0;
    }

    public static int decompress(IRfcTable outputTable, IRfcTable lzTable, int remote_leng) {
        int csrc = 0;
        int total = 0;
        int readBytes = 0;
        int option = 0;
        int p = 0;
        int bytes_read = 0;
        int bytes_dec = 0;
        int len = 0;
        int[] rc_read = new int[3];
        byte[] bufferd = new byte[2080];
        byte[] outbufferd = new byte[4128];
        LZTableInputStream lzInputStream = null;
        try {
            lzInputStream = new LZTableInputStream(lzTable);
        }
        catch (StreamException se) {
            return -2;
        }
        TableOutputStream tableOutputStream = new TableOutputStream(outputTable, remote_leng);
        LZHeader header = lzInputStream.getLZHeader();
        total = header.size;
        total -= 8;
        switch (header.magic[1]) {
            case 0: {
                int to_read = 0;
                while (total > 0) {
                    to_read = Math.min(total, 4096);
                    readBytes = lzInputStream.read(outbufferd, 0, to_read);
                    tableOutputStream.write(outbufferd, 0, readBytes);
                    total -= readBytes;
                }
                return 0;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return -2;
            }
        }
        option = 1;
        bytes_read = 0;
        bytes_dec = 0;
        csrc = 0;
        p = 0;
        len = 0;
        readBytes = lzInputStream.read(bufferd, 0, 8);
        int csHandle = Compress.CsRGetHandle();
        csrc = Compress.CsRInitDecompress(csHandle, bufferd);
        if (csrc != 0) {
            Compress.CsRCloseHandle(csHandle);
            return -2;
        }
        option = 0;
        csrc = 0;
        while (true) {
            if (csrc == 2) {
                p += bytes_read;
                len -= bytes_read;
            } else {
                len = readBytes = lzInputStream.read(bufferd, 0, 2048);
                p = 0;
            }
            Compress.CsRDecompress(csHandle, bufferd, p, len, outbufferd, 4096, option, rc_read);
            bytes_read = rc_read[0];
            bytes_dec = rc_read[1];
            csrc = rc_read[2];
            if (csrc < 0) {
                Compress.CsRCloseHandle(csHandle);
                return 1000 + -csrc;
            }
            if (bytes_dec > 0) {
                tableOutputStream.write(outbufferd, 0, bytes_dec);
            }
            if (csrc == 1) break;
            option = 0;
        }
        tableOutputStream.flush();
        Compress.CsRCloseHandle(csHandle);
        return 0;
    }

    private static class LZHeader {
        byte[] magic = new byte[4];
        int size;

        public LZHeader(int size, byte mode) {
            this.magic[0] = 123;
            this.magic[1] = mode;
            this.magic[3] = -22;
            this.size = size;
        }

        public LZHeader(int size) {
            this(size, 0);
        }

        public LZHeader(byte[] from) {
            this.setBytes(from);
        }

        public boolean verify() {
            return this.magic[0] == 123 && this.magic[3] == -22;
        }

        public byte[] getBytes() {
            byte[] res = new byte[8];
            byte[] buf = RfcUtilities.STCM15(this.size);
            res[0] = this.magic[0];
            res[1] = this.magic[1];
            res[2] = this.magic[2];
            res[3] = this.magic[3];
            res[4] = buf[0];
            res[5] = buf[1];
            res[6] = buf[2];
            res[7] = buf[3];
            return res;
        }

        public void setBytes(byte[] buffer) {
            this.magic[0] = buffer[0];
            this.magic[1] = buffer[1];
            this.magic[2] = buffer[2];
            this.magic[3] = buffer[3];
            this.size = RfcUtilities.ICM15(buffer, 4);
        }
    }

    private static class LZTableInputStream
    extends TableInputStream {
        LZHeader header;

        LZTableInputStream(IRfcTable inputTable) throws StreamException {
            super(inputTable);
            byte[] headerBytes = new byte[8];
            int count = this.read(headerBytes, 0, 8);
            if (count == -1 || count < 8) {
                throw new StreamException("Could not read LZHeader from LZTable");
            }
            this.header = new LZHeader(headerBytes);
            if (!this.header.verify()) {
                throw new StreamException("LZHeader from LZTable is incorrect");
            }
        }

        LZHeader getLZHeader() {
            return this.header;
        }
    }

    private static class TableInputStream {
        IRfcTable inputTable;
        byte[] buffer;
        int pos;
        int rowLength;
        int numRows;
        int nextRow;

        TableInputStream(IRfcTable inputTable) {
            this.inputTable = inputTable;
            this.rowLength = inputTable.getRowLength();
            this.numRows = inputTable.getNumRows();
            this.pos = this.rowLength;
            this.nextRow = 0;
        }

        public int read(byte[] value, int offset, int len) {
            int ret = -1;
            int initialOffset = offset;
            if (value != null) {
                int capacity = this.rowLength - this.pos;
                if (len > capacity) {
                    if (capacity > 0) {
                        System.arraycopy(this.buffer, this.pos, value, offset, capacity);
                        offset += capacity;
                        len -= capacity;
                        this.pos = this.rowLength;
                    }
                    if (this.nextRow < this.numRows) {
                        this.buffer = this.inputTable.getBytes(this.nextRow);
                        ++this.nextRow;
                        while (len > this.rowLength) {
                            System.arraycopy(this.buffer, 0, value, offset, this.rowLength);
                            offset += this.rowLength;
                            len -= this.rowLength;
                            if (this.nextRow < this.numRows) {
                                this.buffer = this.inputTable.getBytes(this.nextRow);
                                ++this.nextRow;
                                continue;
                            }
                            ret = offset - initialOffset;
                            break;
                        }
                        if (ret < 0 && len > 0) {
                            System.arraycopy(this.buffer, 0, value, offset, len);
                            ret = offset + len - initialOffset;
                            this.pos = len;
                        }
                    } else {
                        ret = capacity;
                    }
                } else {
                    System.arraycopy(this.buffer, this.pos, value, offset, len);
                    ret = len;
                    this.pos += len;
                }
            }
            return ret;
        }
    }

    private static class LZTableOutputStream
    extends TableOutputStream {
        LZTableOutputStream(IRfcTable outputTable) {
            super(outputTable, outputTable.getRowLength());
            outputTable.clear();
            this.write(new LZHeader(0).getBytes(), 0, 8);
        }

        public void flush(int mode) {
            LZHeader header = new LZHeader(this.outputTable.getNumRows() * this.rowLength + this.pos, (byte)mode);
            if (header.size <= this.rowLength) {
                System.arraycopy(header.getBytes(), 0, this.buffer, 0, 8);
            } else {
                byte[] row1 = this.outputTable.getBytes(0);
                System.arraycopy(header.getBytes(), 0, row1, 0, 8);
                this.outputTable.setBytes(0, row1);
            }
            super.flush();
        }

        public void flush() {
            this.flush(2);
        }
    }

    private static class TableOutputStream {
        IRfcTable outputTable;
        byte[] buffer;
        int pos;
        int rowLength;

        TableOutputStream(IRfcTable outputTable, int remoteLength) {
            this.outputTable = outputTable;
            this.rowLength = remoteLength;
            this.buffer = new byte[remoteLength];
            this.pos = 0;
        }

        public void flush() {
            if (this.pos > 0) {
                for (int i = this.pos; i < this.buffer.length; ++i) {
                    this.buffer[i] = 0;
                }
                this.outputTable.appendRow(this.buffer);
            }
        }

        public void write(byte[] value, int offset, int len) {
            int capacity = this.rowLength - this.pos;
            if (value == null) {
                return;
            }
            if (len > capacity) {
                if (capacity > 0) {
                    System.arraycopy(value, offset, this.buffer, this.pos, capacity);
                    offset += capacity;
                    len -= capacity;
                }
                this.outputTable.appendRow(this.buffer);
                this.pos = 0;
                while (len > this.rowLength) {
                    System.arraycopy(value, offset, this.buffer, 0, this.rowLength);
                    offset += this.rowLength;
                    len -= this.rowLength;
                    this.outputTable.appendRow(this.buffer);
                }
                if (len > 0) {
                    System.arraycopy(value, offset, this.buffer, 0, len);
                    this.pos = len;
                }
            } else {
                System.arraycopy(value, offset, this.buffer, this.pos, len);
                this.pos += len;
            }
        }
    }

    public static class StreamException
    extends Exception {
        private static final long serialVersionUID = -9055117759455846248L;

        public StreamException(String s) {
            super(s);
        }
    }
}

