/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.XMLWriterBase;
import java.io.CharConversionException;

public class AbapFunction
implements JCoFunction {
    static final long serialVersionUID = 3000120080918L;
    private String name;
    private DefaultParameterList importParameters;
    private DefaultParameterList exportParameters;
    private DefaultParameterList changingParameters;
    private DefaultParameterList tableParameters;
    private AbapException[] exceptionList;
    private boolean supportingASXML;
    private JCoFunctionTemplate template;
    private AbapClassException.Mode abapClassExceptionMode = AbapClassException.Mode.OFF;

    protected AbapFunction(String name) {
        this(name, null, null, null, null);
    }

    protected AbapFunction(String funcName, DefaultParameterList input, DefaultParameterList output, DefaultParameterList changing, DefaultParameterList tables) {
        this.name = funcName;
        this.importParameters = input;
        this.exportParameters = output;
        this.changingParameters = changing;
        this.tableParameters = tables;
        this.exceptionList = null;
        this.supportingASXML = false;
        this.template = null;
    }

    protected AbapFunction(JCoFunctionTemplate templ) {
        this.name = templ.getName();
        JCoListMetaData importMeta = templ.getImportParameterList();
        JCoListMetaData exportMeta = templ.getExportParameterList();
        JCoListMetaData changingMeta = templ.getChangingParameterList();
        JCoListMetaData tablesMeta = templ.getTableParameterList();
        this.importParameters = importMeta == null ? null : new DefaultParameterList(importMeta);
        this.exportParameters = exportMeta == null ? null : new DefaultParameterList(exportMeta);
        this.changingParameters = changingMeta == null ? null : new DefaultParameterList(changingMeta);
        this.tableParameters = tablesMeta == null ? null : new DefaultParameterList(tablesMeta);
        this.exceptionList = templ.getExceptionList();
        this.supportingASXML = templ.supportsASXML();
        this.template = templ;
    }

    public JCoFunction clone() {
        try {
            AbapFunction obj = (AbapFunction)super.clone();
            if (this.importParameters != null) {
                obj.importParameters = (DefaultParameterList)this.importParameters.clone();
            }
            if (this.exportParameters != null) {
                obj.exportParameters = (DefaultParameterList)this.exportParameters.clone();
            }
            if (this.changingParameters != null) {
                obj.changingParameters = (DefaultParameterList)this.changingParameters.clone();
            }
            if (this.tableParameters != null) {
                obj.tableParameters = (DefaultParameterList)this.tableParameters.clone();
            }
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DefaultParameterList getImportParameterList() {
        return this.importParameters;
    }

    public DefaultParameterList getExportParameterList() {
        return this.exportParameters;
    }

    public DefaultParameterList getChangingParameterList() {
        return this.changingParameters;
    }

    public DefaultParameterList getTableParameterList() {
        return this.tableParameters;
    }

    public AbapException[] getExceptionList() {
        return this.exceptionList;
    }

    public AbapException getException(String key) {
        if (this.exceptionList == null) {
            return null;
        }
        for (int i = 0; i < this.exceptionList.length; ++i) {
            if (!this.exceptionList[i].getKey().equalsIgnoreCase(key)) continue;
            AbapException ex = this.exceptionList[i];
            return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
        }
        return null;
    }

    public void setAbapClassExceptionMode(AbapClassException.Mode mode) {
        if (!Environment.inJTS()) {
            this.abapClassExceptionMode = mode;
        }
    }

    public boolean isAbapClassExceptionEnabled() {
        return this.abapClassExceptionMode != AbapClassException.Mode.OFF;
    }

    public AbapClassException.Mode getAbapClassExceptionMode() {
        return this.abapClassExceptionMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getName());
        sb.append(JCoRuntime.CRLF).append("Input:").append(JCoRuntime.CRLF);
        sb.append(this.importParameters);
        if (this.importParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append(JCoRuntime.CRLF).append("Changing:").append(JCoRuntime.CRLF);
        sb.append(this.changingParameters);
        if (this.changingParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append(JCoRuntime.CRLF).append("Output:").append(JCoRuntime.CRLF);
        sb.append(this.exportParameters);
        if (this.exportParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append(JCoRuntime.CRLF).append("Tables:").append(JCoRuntime.CRLF);
        sb.append(this.tableParameters);
        if (this.tableParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        if (this.exceptionList != null) {
            sb.append(JCoRuntime.CRLF).append("Exceptions:").append(JCoRuntime.CRLF);
            for (int i = 0; i < this.exceptionList.length; ++i) {
                sb.append(this.exceptionList[i].getKey()).append(JCoRuntime.CRLF);
            }
        }
        return sb.toString();
    }

    public String toXML() {
        XMLWriterBase xmlWriterBase = new XMLWriterBase();
        StringBuilder b = new StringBuilder();
        String convertedName = null;
        try {
            convertedName = xmlWriterBase.escape(this.name);
        }
        catch (CharConversionException cce) {
            convertedName = this.name;
        }
        b.append('<').append(convertedName).append('>');
        if (this.importParameters != null) {
            b.append(this.importParameters.toXML());
        }
        if (this.changingParameters != null) {
            b.append(this.changingParameters.toXML());
        }
        if (this.exportParameters != null) {
            b.append(this.exportParameters.toXML());
        }
        if (this.tableParameters != null) {
            b.append(this.tableParameters.toXML());
        }
        b.append("</").append(convertedName).append('>');
        return b.toString();
    }

    public void execute(JCoDestination destination) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination is null and not allowed.");
        }
        ((InternalDestination)destination).execute(this);
    }

    public void execute(JCoDestination destination, String tid) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination is null and not allowed.");
        }
        ((InternalDestination)destination).execute(this, tid, null);
    }

    public void execute(JCoDestination destination, String tid, String queueName) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination is null and not allowed.");
        }
        ((InternalDestination)destination).execute(this, tid, queueName);
    }

    boolean supportsASXML() {
        return this.supportingASXML;
    }

    public JCoFunctionTemplate getFunctionTemplate() {
        return this.template;
    }
}

