package com.huigou.uasp.bmp.fn.impl;

import com.huigou.context.OrgUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.List;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration("classpath:applicationContext.xml")
public class OrgFunTests {

    @Autowired
    private OrgFun orgFun;

    @Test
    public void findSubordinations() {
        String orgFullId = "/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm";
       // "/7609EDB28F974C5F948CAA24D5ADAB85.ogn"
        List<OrgUnit> units = orgFun.findSubordinations(orgFullId, "admin",null,true, false);
        System.out.println(units);
    }

    @Test
    public void findSubordinationsForNearestManager() {
        String orgFullId = "/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm";
        List<OrgUnit> units = orgFun.findSubordinationsForNearestManager(orgFullId, "admin",null,false);
        System.out.println(units);
    }

    @Test
    public void findManagers() {
        String orgFullId = "/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm";
        List<OrgUnit> units = orgFun.findManagers(orgFullId, "admin",true, null);
        System.out.println(units);
    }

    @Test
    public void  findNearestManagers() {
        String orgFullId = "/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm";
        List<OrgUnit> units = orgFun.findNearestManagers(orgFullId, "admin");
        System.out.println(units);
    }

    @Test
    public void hasManageType() {
        String orgFullId = "/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm";
        System.out.println("hasManageType: " + orgFun.hasManageType(orgFullId, "admin"));
    }

}
