package com.huigou.uasp.bmp.opm.controller;

import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.opm.application.LinkApplication;
import com.huigou.uasp.bmp.opm.domain.model.resource.Link;
import com.huigou.uasp.client.CommonController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author yonghuan
 */
@ControllerMapping("link")
@Controller
public class LinkController extends CommonController {

    @Autowired
    private RequestMappingHandlerMapping handlerMapping;

    @Autowired
    private LinkApplication linkApplication;

    public String syncLinks() {
        List<Link> links = new ArrayList<>(500);
        Map<RequestMappingInfo, HandlerMethod> map = handlerMapping.getHandlerMethods();
        Iterator<Map.Entry<RequestMappingInfo, HandlerMethod>> iter = map.entrySet().iterator();
        Map.Entry<RequestMappingInfo, HandlerMethod> entry;
        while (iter.hasNext()) {
            entry = iter.next();
            String url = entry.getKey().getPatternsCondition().getPatterns().iterator().next();
            links.add(new Link(url));
        }
        linkApplication.syncLinks(links);
        return success();
    }

}
