package com.huigou.uasp.bmp.opm.application.impl;

import com.huigou.uasp.bmp.opm.application.LinkApplication;
import com.huigou.uasp.bmp.opm.domain.model.resource.Link;
import com.huigou.uasp.bmp.opm.repository.org.LinkRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author yonghuan
 */
@Service
public class LinkApplicationImpl implements LinkApplication {

    private LinkRepository linkRepository;

    @Autowired
    public void setLinkRepository(LinkRepository linkRepository) {
        this.linkRepository = linkRepository;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void syncLinks(List<Link> links) {
        linkRepository.deleteAll();
        linkRepository.save(links);
    }
}
