package com.huigou.uasp.bmp.opm.proxy;

import com.huigou.uasp.bmp.opm.application.RoleBizManagementApplication;
import com.huigou.uasp.bmp.opm.domain.query.RoleBizManagementQueryRequest;
import com.huigou.uasp.bmp.opm.impl.RoleBizManagementApplicationImpl;
import com.huigou.uasp.bmp.opm.mapper.managment.RoleBizManagementMapper;
import com.huigou.uasp.bmp.opm.repository.managment.BizManagementTypeRepository;
import com.huigou.uasp.bmp.opm.repository.managment.RoleBizManagementRepository;
import com.huigou.uasp.bmp.opm.repository.org.OrgRepository;
import com.huigou.uasp.bmp.opm.repository.org.RoleRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author yonghuan
 */
@Service
public class RoleBizManagementApplicationProxy implements RoleBizManagementApplication, InitializingBean {

    private RoleBizManagementApplication target;

    private RoleBizManagementRepository roleBizManagementRepository;
    private BizManagementTypeRepository bizManagementTypeRepository;
    private RoleRepository roleRepository;
    private OrgRepository orgRepository;
    private RoleBizManagementMapper roleBizManagementMapper;

    @Autowired
    public void setRoleBizManagementRepository(RoleBizManagementRepository roleBizManagementRepository) {
        this.roleBizManagementRepository = roleBizManagementRepository;
    }

    @Autowired
    public void setBizManagementTypeRepository(BizManagementTypeRepository bizManagementTypeRepository) {
        this.bizManagementTypeRepository = bizManagementTypeRepository;
    }

    @Autowired
    public void setRoleRepository(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    @Autowired
    public void setOrgRepository(OrgRepository orgRepository) {
        this.orgRepository = orgRepository;
    }
    @Autowired
    public void setRoleBizManagementMapper(RoleBizManagementMapper roleBizManagementMapper) {
        this.roleBizManagementMapper = roleBizManagementMapper;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RoleBizManagementApplicationImpl target = new RoleBizManagementApplicationImpl();
        target.setRoleBizManagementRepository(roleBizManagementRepository);
        target.setBizManagementTypeRepository(bizManagementTypeRepository);
        target.setOrgRepository(orgRepository);
        target.setRoleRepository(roleRepository);
        target.setRoleBizManagementMapper(roleBizManagementMapper);
        this.target = target;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void allocateSubordinations(String managerId, String manageTypeId, List<String> subordinationIds) {
        target.allocateSubordinations(managerId, manageTypeId, subordinationIds);
    }

    @Override
    public Map<String, Object> slicedQuerySubordination(RoleBizManagementQueryRequest queryRequest) {
        return target.slicedQuerySubordination(queryRequest);
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void deleteByIds(List<String> id) {
        target.deleteByIds(id);
    }
}
