package com.huigou.uasp.bmp.opm.proxy;

import com.huigou.uasp.bmp.opm.application.IconApplication;
import com.huigou.uasp.bmp.opm.domain.model.resource.Icon;
import com.huigou.uasp.bmp.opm.impl.IconApplicationImpl;
import com.huigou.uasp.bmp.opm.repository.org.IconRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author yonghuan
 */
@Service
public class IconApplicationProxy implements IconApplication, InitializingBean {

    private IconRepository iconRepository;
    private IconApplication iconApplication;

    @Autowired
    public void setIconRepository(IconRepository iconRepository) {
        this.iconRepository = iconRepository;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        IconApplicationImpl impl = new IconApplicationImpl();
        impl.setIconRepository(iconRepository);
        this.iconApplication = impl;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void syncIcons(List<Icon> icons) {
        iconApplication.syncIcons(icons);
    }
}
