package com.topsunit.query.binding;

import java.lang.reflect.Method;

/**
 * 调用策略。
 *
 * @author yonghuan
 * @since 1.1.3
 */
public interface InvokeStrategy {

    /**
     * 判断是否支持。
     *
     * @param invokeContext 执行上下文
     * @param method        被调用的方法
     * @param args          参数
     * @return 如果支持就返回true, 否则返回false。
     */
    boolean supports(InvokeContext invokeContext, Method method, Object[] args);

    /**
     * 执行。
     *
     * @param invokeContext 执行上下文
     * @param method        被调用的方法
     * @param args          参数
     * @return 执行结果
     */
    Object invoke(InvokeContext invokeContext, Method method, Object[] args);

}
