package com.huigou.uasp.bmp.opm.impl;

import com.huigou.uasp.bmp.opm.application.RoleBizManagementApplication;
import com.huigou.uasp.bmp.opm.domain.model.access.Role;
import com.huigou.uasp.bmp.opm.domain.model.management.BizManagementType;
import com.huigou.uasp.bmp.opm.domain.model.management.RoleBizManagement;
import com.huigou.uasp.bmp.opm.domain.model.org.Org;
import com.huigou.uasp.bmp.opm.domain.query.RoleBizManagementQueryRequest;
import com.huigou.uasp.bmp.opm.mapper.managment.RoleBizManagementMapper;
import com.huigou.uasp.bmp.opm.repository.managment.BizManagementTypeRepository;
import com.huigou.uasp.bmp.opm.repository.managment.RoleBizManagementRepository;
import com.huigou.uasp.bmp.opm.repository.org.OrgRepository;
import com.huigou.uasp.bmp.opm.repository.org.RoleRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yonghuan
 */
@Service
public class RoleBizManagementApplicationImpl implements RoleBizManagementApplication {

    private RoleBizManagementRepository roleBizManagementRepository;
    private BizManagementTypeRepository bizManagementTypeRepository;
    private RoleRepository roleRepository;
    private OrgRepository orgRepository;
    private RoleBizManagementMapper roleBizManagementMapper;


    @Autowired
    public void setRoleBizManagementRepository(RoleBizManagementRepository roleBizManagementRepository) {
        this.roleBizManagementRepository = roleBizManagementRepository;
    }

    @Autowired
    public void setBizManagementTypeRepository(BizManagementTypeRepository bizManagementTypeRepository) {
        this.bizManagementTypeRepository = bizManagementTypeRepository;
    }

    @Autowired
    public void setRoleRepository(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    @Autowired
    public void setOrgRepository(OrgRepository orgRepository) {
        this.orgRepository = orgRepository;
    }

    @Autowired
    public void setRoleBizManagementMapper(RoleBizManagementMapper roleBizManagementMapper) {
        this.roleBizManagementMapper = roleBizManagementMapper;
    }

    @Override
    public void allocateSubordinations(String managerId, String manageTypeId, List<String> subordinationIds) {
        List<RoleBizManagement> managements = subordinationIds.stream().distinct()
                .map(subordinationId -> buildRoleBizManagement(manageTypeId, managerId, subordinationId))
                .collect(Collectors.toList());
        roleBizManagementRepository.save(managements);
    }

    private RoleBizManagement buildRoleBizManagement(String manageTypeId, String managerId, String subordinationId) {
        RoleBizManagement rbm = new RoleBizManagement();
        BizManagementType managementType = bizManagementTypeRepository.getOne(manageTypeId);
        rbm.setBizManagementType(managementType);
        Role role = roleRepository.findOne(managerId);
        rbm.setManager(role);
        Org subordination = orgRepository.findOne(subordinationId);
        rbm.setSubordination(subordination);
        return rbm;
    }

    @Override
    public Map<String, Object> slicedQuerySubordination(RoleBizManagementQueryRequest queryRequest) {
        return roleBizManagementMapper.slicedQuerySubordination(queryRequest);
    }

    @Override
    public void deleteByIds(List<String> id) {
        id.forEach(roleBizManagementRepository::delete);
    }
}
