package com.huigou.uasp.bmp.opm.impl;

import com.huigou.uasp.bmp.opm.application.IconApplication;
import com.huigou.uasp.bmp.opm.domain.model.resource.Icon;
import com.huigou.uasp.bmp.opm.repository.org.IconRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author yonghuan
 */
@Service
public class IconApplicationImpl implements IconApplication {

    private IconRepository iconRepository;

    @Autowired
    public void setIconRepository(IconRepository iconRepository) {
        this.iconRepository = iconRepository;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void syncIcons(List<Icon> icons) {
        iconRepository.deleteAll();
        iconRepository.save(icons);
    }
}
