package com.huigou.uasp.bmp.opm.repository.org;

import com.huigou.uasp.bmp.opm.domain.model.access.Role;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


public interface RoleRepository extends JpaRepository<Role, String> {

    Long countByParentId(String parentId);

    @Modifying
    @Query("update Role set status = -1 where kindId = 'superAdministrator'")
    int hideSuperAdministrator();

    List<Role> findByKindId(String kindId);

    @Query("select count(p) from Role r join r.permissions p where r.id = ?1")
    int countPermissionsByRoleId(String roleId);

    /**
     * 查询组织拥有的有效角色信息。
     *
     * @param orgId 组织id
     * @return 组织拥有的有效角色信息
     */
    @Query("from Role r where r.status=1 and exists (select 1 from Authorize a where a.id.orgId=:orgId and a.id.roleId=r.id)")
    List<Role> findByOrgId(@Param("orgId") String orgId);
}
