--
-- PostgreSQL database dump
--

-- Dumped from database version 10.11
-- Dumped by pg_dump version 10.11

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';


--
-- Name: instr(character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.instr(string character varying, string_to_search character varying, beg_index integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
    pos integer;
    temp_str varchar;
    beg integer;
    length integer;
    ss_length integer;
BEGIN
    pos:=0;
    IF beg_index > 0 THEN
        temp_str := substring(string FROM beg_index);
        pos := position(string_to_search IN temp_str);
        IF pos = 0 THEN
            RETURN 0;
        ELSE
            RETURN pos + beg_index - 1; 
        END IF;
    ELSE
        ss_length := char_length(string_to_search);
        length := char_length(string);
        beg := length + beg_index - ss_length+2;
        WHILE beg > 0 LOOP
            temp_str := substring(string FROM beg FOR ss_length);
            pos := position(string_to_search IN temp_str);
            IF pos > 0 THEN
                RETURN beg;
            END IF;
            beg := beg - 1;
        END LOOP;
        RETURN 0;
    END IF;
END;
$$;


ALTER FUNCTION public.instr(string character varying, string_to_search character varying, beg_index integer) OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

  create table tmp_sa_i18nproperties
   (	tmp_id varchar(32 ) not null,
	batch_number varchar(64 ),
	status integer,
	message varchar(512 ),
	code varchar(128 ),
	value1 varchar(512 ),
	value2 varchar(512 ),
	value3 varchar(512 ),
	value4 varchar(512 ),
	value5 varchar(512 )
   )

--
-- Name: act_ge_bytearray; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ge_bytearray (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    name_ character varying(1020),
    deployment_id_ character varying(64),
    bytes_ bytea,
    generated_ numeric(1,0)
);


ALTER TABLE public.act_ge_bytearray OWNER TO postgres;

--
-- Name: act_ge_property; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ge_property (
    name_ character varying(256) NOT NULL,
    value_ character varying(1200),
    rev_ numeric
);


ALTER TABLE public.act_ge_property OWNER TO postgres;

--
-- Name: act_hi_actinst; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_actinst (
    id_ character varying(64) NOT NULL,
    proc_def_id_ character varying(64) NOT NULL,
    proc_inst_id_ character varying(64) NOT NULL,
    execution_id_ character varying(64) NOT NULL,
    act_id_ character varying(255) NOT NULL,
    task_id_ character varying(64),
    call_proc_inst_id_ character varying(64),
    act_name_ character varying(1020),
    act_type_ character varying(1020) NOT NULL,
    assignee_ character varying(1024),
    start_time_ timestamp(6) without time zone NOT NULL,
    end_time_ timestamp(6) without time zone,
    duration_ numeric(19,0),
    tenant_id_ character varying(255)
);


ALTER TABLE public.act_hi_actinst OWNER TO postgres;

--
-- Name: act_hi_comment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_comment (
    id_ character varying(64) NOT NULL,
    type_ character varying(1020),
    time_ timestamp(6) without time zone NOT NULL,
    user_id_ character varying(1024),
    task_id_ character varying(64),
    proc_inst_id_ character varying(64),
    action_ character varying(1020),
    message_ character varying(2000),
    full_msg_ bytea
);


ALTER TABLE public.act_hi_comment OWNER TO postgres;

--
-- Name: act_hi_identitylink; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_identitylink (
    id_ character varying(64) NOT NULL,
    group_id_ character varying(255),
    type_ character varying(1020),
    user_id_ character varying(1024),
    task_id_ character varying(64),
    proc_inst_id_ character varying(64)
);


ALTER TABLE public.act_hi_identitylink OWNER TO postgres;

--
-- Name: act_hi_procinst; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_procinst (
    id_ character varying(64) NOT NULL,
    proc_inst_id_ character varying(64) NOT NULL,
    business_key_ character varying(1020),
    proc_def_id_ character varying(64) NOT NULL,
    start_time_ timestamp(6) without time zone NOT NULL,
    end_time_ timestamp(6) without time zone,
    duration_ numeric(19,0),
    start_user_id_ character varying(255),
    start_act_id_ character varying(255),
    end_act_id_ character varying(255),
    super_process_instance_id_ character varying(64),
    delete_reason_ character varying(2000),
    tenant_id_ character varying(255),
    name_ character varying(1020)
);


ALTER TABLE public.act_hi_procinst OWNER TO postgres;

--
-- Name: act_hi_procinst_extension; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_procinst_extension (
    id_ character varying(64) NOT NULL,
    business_key_ character varying(1020),
    applicant_person_member_id_ character varying(65),
    applicant_person_member_name_ character varying(256),
    applicant_pos_id_ character varying(65),
    applicant_pos_name_ character varying(256),
    applicant_dept_id_ character varying(65),
    applicant_dept_name_ character varying(256),
    applicant_org_id_ character varying(65),
    applicant_org_name_ character varying(256),
    applicant_full_id_ character varying(1024),
    applicant_full_name_ character varying(2048),
    version_ numeric,
    description_ character varying(1024),
    status_id_ character varying(32),
    status_name_ character varying(64),
    proc_def_id_ character varying(64),
    start_time_ timestamp(6) without time zone,
    end_time_ timestamp(6) without time zone,
    duration_ numeric(19,0),
    start_user_id_ character varying(255),
    start_act_id_ character varying(255),
    end_act_id_ character varying(255),
    super_process_instance_id_ character varying(64),
    delete_reason_ character varying(2000),
    tenant_id_ character varying(255),
    name_ character varying(1020),
    key_ character varying(1020),
    proc_inst_id_ character varying(64)
);


ALTER TABLE public.act_hi_procinst_extension OWNER TO postgres;

--
-- Name: act_hi_taskinst; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_taskinst (
    id_ character varying(64) NOT NULL,
    proc_def_id_ character varying(64),
    task_def_key_ character varying(1020),
    proc_inst_id_ character varying(64),
    execution_id_ character varying(64),
    parent_task_id_ character varying(64),
    name_ character varying(1020),
    description_ character varying(2000),
    owner_ character varying(1024),
    assignee_ character varying(1024),
    start_time_ timestamp(6) without time zone NOT NULL,
    claim_time_ timestamp(6) without time zone,
    end_time_ timestamp(6) without time zone,
    duration_ numeric(19,0),
    delete_reason_ character varying(2000),
    priority_ numeric,
    due_date_ timestamp(6) without time zone,
    form_key_ character varying(1020),
    category_ character varying(1020),
    tenant_id_ character varying(255)
);


ALTER TABLE public.act_hi_taskinst OWNER TO postgres;

--
-- Name: act_hi_taskinst_extension; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_taskinst_extension (
    id_ character varying(64) NOT NULL,
    catalog_id_ character varying(32),
    kind_id_ character varying(32),
    creator_url_ character varying(512),
    executor_url_ character varying(512),
    creator_person_member_id_ character varying(65),
    creator_person_member_name_ character varying(256),
    creator_pos_id_ character varying(65),
    creator_pos_name_ character varying(256),
    creator_dept_id_ character varying(65),
    creator_dept_name_ character varying(256),
    creator_ogn_id_ character varying(65),
    creator_ogn_name_ character varying(256),
    creator_full_id_ character varying(1024),
    creator_full_name_ character varying(2048),
    executor_person_member_id_ character varying(65),
    executor_person_member_name_ character varying(256),
    executor_pos_id_ character varying(65),
    executor_pos_name_ character varying(256),
    executor_dept_id_ character varying(65),
    executor_dept_name_ character varying(256),
    executor_ogn_id_ character varying(65),
    executor_ogn_name_ character varying(256),
    executor_full_id_ character varying(1024),
    executor_full_name_ character varying(2048),
    status_id_ character varying(32),
    status_name_ character varying(128),
    executor_names_ character varying(2048),
    owner_person_member_id_ character varying(65),
    owner_person_member_name_ character varying(256),
    owner_pos_id_ character varying(65),
    owner_pos_name_ character varying(256),
    owner_dept_id_ character varying(65),
    owner_dept_name_ character varying(256),
    owner_ogn_id_ character varying(65),
    owner_ogn_name_ character varying(256),
    owner_full_id_ character varying(1024),
    owner_full_name_ character varying(2048),
    previous_id_ character varying(64),
    proc_unit_handler_id_ character varying(32),
    business_key_ character varying(1020),
    business_code_ character varying(256),
    need_timing_ numeric,
    opinion_ character varying(2048),
    result_ numeric,
    sleeped_date_ timestamp(6) without time zone,
    sign_punish_ numeric,
    sign_need_timing_ numeric,
    version_ numeric,
    proc_inst_id_ character varying(64),
    cooperation_model_id_ character varying(32),
    limit_time_ numeric,
    applicant_person_member_id_ character varying(65),
    applicant_person_member_name_ character varying(256),
    process_definition_key_ character varying(510),
    creator_person_id_ character varying(32),
    executor_person_id_ character varying(32),
    proc_def_id_ character varying(64),
    task_def_key_ character varying(1020),
    execution_id_ character varying(64),
    parent_task_id_ character varying(64),
    name_ character varying(1020),
    description_ character varying(2000),
    start_time_ timestamp(6) without time zone,
    claim_time_ timestamp(6) without time zone,
    end_time_ timestamp(6) without time zone,
    duration_ numeric(19,0),
    delete_reason_ character varying(2000),
    priority_ numeric,
    due_date_ timestamp(6) without time zone,
    form_key_ character varying(1020),
    category_ character varying(1020),
    tenant_id_ character varying(255),
    generate_reason_ character varying(1020),
    sub_proc_unit_name_ character varying(1020)
);


ALTER TABLE public.act_hi_taskinst_extension OWNER TO postgres;

--
-- Name: COLUMN act_hi_taskinst_extension.catalog_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.catalog_id_ IS '任务的大类标识 process为流程任务，task为协同任务';


--
-- Name: COLUMN act_hi_taskinst_extension.kind_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.kind_id_ IS '任务的类型细分标识，processInstance为流程实例，task为任务，executor为执行者';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_url_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_url_ IS '创建此任务的activity的URL';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_url_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_url_ IS '处理此任务的activity的URL';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_person_member_id_ IS '创建人ID';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_person_member_name_ IS '创建人';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_pos_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_pos_id_ IS '创建人岗位ID';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_pos_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_pos_name_ IS '创建人岗位';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_dept_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_dept_id_ IS '创建人部门ID';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_dept_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_dept_name_ IS '创建人部门';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_ogn_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_ogn_id_ IS '创建人机构ID';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_ogn_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_ogn_name_ IS '创建人机构';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_full_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_full_id_ IS '创建人ID全路径';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_full_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_full_name_ IS '创建人名称全路径';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_person_member_id_ IS '执行人ID';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_person_member_name_ IS '执行人';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_pos_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_pos_id_ IS '执行人岗位ID';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_pos_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_pos_name_ IS '执行人岗位';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_dept_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_dept_id_ IS '执行人部门ID';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_dept_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_dept_name_ IS '执行人部门';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_ogn_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_ogn_id_ IS '执行人机构ID';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_ogn_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_ogn_name_ IS '执行人机构';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_full_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_full_id_ IS '执行人ID全路径';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_full_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_full_name_ IS '执行人名称全路径';


--
-- Name: COLUMN act_hi_taskinst_extension.status_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.status_id_ IS '任务状态ID ，取值范围是ready(尚未处理)，executing(正在处理)，sleeping(暂缓处理)，canceled(已取消)，aborted(已终止)，completed(已完成)，returned(已回退)，trainsmited(已转发)，paused(已暂停)';


--
-- Name: COLUMN act_hi_taskinst_extension.status_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.status_name_ IS '任务状态';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_names_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_names_ IS '执行人名称';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_person_member_id_ IS '责任人ID';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_person_member_name_ IS '责任人';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_pos_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_pos_id_ IS '责任人岗位ID';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_pos_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_pos_name_ IS '责任人岗位';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_dept_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_dept_id_ IS '责任人部门ID';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_dept_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_dept_name_ IS '责任人部门';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_ogn_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_ogn_id_ IS '责任人机构ID';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_ogn_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_ogn_name_ IS '责任人机构';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_full_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_full_id_ IS '责任人ID全路径';


--
-- Name: COLUMN act_hi_taskinst_extension.owner_full_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.owner_full_name_ IS '责任人名称全路径';


--
-- Name: COLUMN act_hi_taskinst_extension.previous_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.previous_id_ IS '前任务ID';


--
-- Name: COLUMN act_hi_taskinst_extension.proc_unit_handler_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.proc_unit_handler_id_ IS '环节处理人ID';


--
-- Name: COLUMN act_hi_taskinst_extension.business_key_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.business_key_ IS '业务组件ID';


--
-- Name: COLUMN act_hi_taskinst_extension.business_code_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.business_code_ IS '业务组件编码';


--
-- Name: COLUMN act_hi_taskinst_extension.need_timing_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.need_timing_ IS '需要计时';


--
-- Name: COLUMN act_hi_taskinst_extension.opinion_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.opinion_ IS '处理意见';


--
-- Name: COLUMN act_hi_taskinst_extension.result_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.result_ IS '处理结果';


--
-- Name: COLUMN act_hi_taskinst_extension.sleeped_date_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.sleeped_date_ IS '暂缓时间';


--
-- Name: COLUMN act_hi_taskinst_extension.sign_punish_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.sign_punish_ IS '人为标记是否处罚';


--
-- Name: COLUMN act_hi_taskinst_extension.sign_need_timing_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.sign_need_timing_ IS '人为标记是否计时';


--
-- Name: COLUMN act_hi_taskinst_extension.proc_inst_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.proc_inst_id_ IS '流程实例ID';


--
-- Name: COLUMN act_hi_taskinst_extension.cooperation_model_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.cooperation_model_id_ IS '协助模式';


--
-- Name: COLUMN act_hi_taskinst_extension.limit_time_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.limit_time_ IS '限制时间';


--
-- Name: COLUMN act_hi_taskinst_extension.applicant_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.applicant_person_member_id_ IS '申请人员成员ID';


--
-- Name: COLUMN act_hi_taskinst_extension.applicant_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.applicant_person_member_name_ IS '申请人员成员';


--
-- Name: COLUMN act_hi_taskinst_extension.process_definition_key_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.process_definition_key_ IS '流程定义ID';


--
-- Name: COLUMN act_hi_taskinst_extension.creator_person_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.creator_person_id_ IS '创建人';


--
-- Name: COLUMN act_hi_taskinst_extension.executor_person_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.executor_person_id_ IS '执行人';


--
-- Name: COLUMN act_hi_taskinst_extension.generate_reason_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_extension.generate_reason_ IS '产生原因';


--
-- Name: act_hi_taskinst_relation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_taskinst_relation (
    id character varying(32) NOT NULL,
    created_date timestamp(6) without time zone,
    created_by_id character varying(65),
    created_by_name character varying(64),
    business_key character varying(64),
    proc_inst_id character varying(36),
    task_id character varying(64),
    related_task_id character varying(64),
    version numeric
);


ALTER TABLE public.act_hi_taskinst_relation OWNER TO postgres;

--
-- Name: TABLE act_hi_taskinst_relation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.act_hi_taskinst_relation IS '任务关联';


--
-- Name: COLUMN act_hi_taskinst_relation.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.id IS 'ID';


--
-- Name: COLUMN act_hi_taskinst_relation.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.created_date IS '创建时间';


--
-- Name: COLUMN act_hi_taskinst_relation.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.created_by_id IS '创建人ID';


--
-- Name: COLUMN act_hi_taskinst_relation.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.created_by_name IS '创建人';


--
-- Name: COLUMN act_hi_taskinst_relation.business_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.business_key IS '业务ID';


--
-- Name: COLUMN act_hi_taskinst_relation.proc_inst_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.proc_inst_id IS '流程实例ID';


--
-- Name: COLUMN act_hi_taskinst_relation.task_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.task_id IS '任务ID';


--
-- Name: COLUMN act_hi_taskinst_relation.related_task_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_hi_taskinst_relation.related_task_id IS '关联任务ID';


--
-- Name: act_hi_varinst; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_hi_varinst (
    id_ character varying(64) NOT NULL,
    proc_inst_id_ character varying(64),
    execution_id_ character varying(64),
    task_id_ character varying(64),
    name_ character varying(1020) NOT NULL,
    var_type_ character varying(400),
    rev_ numeric,
    bytearray_id_ character varying(64),
    double_ numeric(10,10),
    long_ numeric(19,0),
    text_ character varying(2000),
    text2_ character varying(2000),
    create_time_ timestamp(6) without time zone,
    last_updated_time_ timestamp(6) without time zone
);


ALTER TABLE public.act_hi_varinst OWNER TO postgres;

--
-- Name: act_re_deployment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_re_deployment (
    id_ character varying(64) NOT NULL,
    name_ character varying(1020),
    category_ character varying(1020),
    deploy_time_ timestamp(6) without time zone,
    tenant_id_ character varying(255)
);


ALTER TABLE public.act_re_deployment OWNER TO postgres;

--
-- Name: act_re_procdef; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_re_procdef (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    category_ character varying(1020),
    name_ character varying(1020),
    key_ character varying(1020) NOT NULL,
    version_ numeric NOT NULL,
    deployment_id_ character varying(64),
    resource_name_ character varying(2000),
    dgrm_resource_name_ character varying(4000),
    description_ character varying(2000),
    has_start_form_key_ numeric(1,0),
    suspension_state_ numeric,
    tenant_id_ character varying(255),
    has_graphical_notation_ numeric(1,0)
);


ALTER TABLE public.act_re_procdef OWNER TO postgres;

--
-- Name: act_re_procdef_tree_del; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_re_procdef_tree_del (
    re_procdef_tree_id numeric NOT NULL,
    code character varying(256),
    name character varying(512),
    path character varying(2048),
    parent_id numeric,
    status numeric,
    description character varying(1200),
    sequence numeric,
    version numeric,
    key character varying(128),
    approval_rule_proc_def_key character varying(128),
    node_kind_id character varying(32),
    need_timing numeric,
    app_model_id numeric,
    full_name character varying(2048),
    full_id character varying(1024),
    show_query_handlers numeric
);


ALTER TABLE public.act_re_procdef_tree_del OWNER TO postgres;

--
-- Name: TABLE act_re_procdef_tree_del; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.act_re_procdef_tree_del IS '流程定义树';


--
-- Name: COLUMN act_re_procdef_tree_del.re_procdef_tree_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.re_procdef_tree_id IS '主键';


--
-- Name: COLUMN act_re_procdef_tree_del.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.code IS '编码';


--
-- Name: COLUMN act_re_procdef_tree_del.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.name IS '名称';


--
-- Name: COLUMN act_re_procdef_tree_del.path; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.path IS 'ID全路径';


--
-- Name: COLUMN act_re_procdef_tree_del.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.parent_id IS '父节点ID';


--
-- Name: COLUMN act_re_procdef_tree_del.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.status IS '状态';


--
-- Name: COLUMN act_re_procdef_tree_del.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.description IS '描述';


--
-- Name: COLUMN act_re_procdef_tree_del.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.sequence IS '排序号';


--
-- Name: COLUMN act_re_procdef_tree_del.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.version IS '版本号';


--
-- Name: COLUMN act_re_procdef_tree_del.key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.key IS '流程KEY';


--
-- Name: COLUMN act_re_procdef_tree_del.approval_rule_proc_def_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.approval_rule_proc_def_key IS '审批规则流程ID';


--
-- Name: COLUMN act_re_procdef_tree_del.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.node_kind_id IS '节点类型 folder 文件夹 proc 流程 procUnit 流程环节';


--
-- Name: COLUMN act_re_procdef_tree_del.need_timing; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.need_timing IS '需要计时';


--
-- Name: COLUMN act_re_procdef_tree_del.app_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.app_model_id IS 'APP模型ID';


--
-- Name: COLUMN act_re_procdef_tree_del.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.full_name IS '名称全路径';


--
-- Name: COLUMN act_re_procdef_tree_del.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.full_id IS 'ID全路径';


--
-- Name: COLUMN act_re_procdef_tree_del.show_query_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_re_procdef_tree_del.show_query_handlers IS '显示询问处理人对话框 1 是 0 否';


--
-- Name: act_ru_event_subscr; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_event_subscr (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    event_type_ character varying(1020) NOT NULL,
    event_name_ character varying(1020),
    execution_id_ character varying(64),
    proc_inst_id_ character varying(64),
    activity_id_ character varying(64),
    configuration_ character varying(1020),
    created_ timestamp(6) without time zone NOT NULL,
    tenant_id_ character varying(255),
    proc_def_id_ character varying(64)
);


ALTER TABLE public.act_ru_event_subscr OWNER TO postgres;

--
-- Name: act_ru_execution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_execution (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    proc_inst_id_ character varying(64),
    business_key_ character varying(1020),
    parent_id_ character varying(64),
    proc_def_id_ character varying(64),
    super_exec_ character varying(256),
    act_id_ character varying(255),
    is_active_ numeric(1,0),
    is_concurrent_ numeric(1,0),
    is_scope_ numeric(1,0),
    is_event_scope_ numeric(1,0),
    suspension_state_ numeric,
    cached_ent_state_ numeric,
    tenant_id_ character varying(255),
    name_ character varying(1020),
    lock_time_ timestamp(6) without time zone
);


ALTER TABLE public.act_ru_execution OWNER TO postgres;

--
-- Name: act_ru_identitylink; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_identitylink (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    group_id_ character varying(255),
    type_ character varying(1020),
    user_id_ character varying(1024),
    task_id_ character varying(64),
    proc_inst_id_ character varying(64),
    proc_def_id_ character varying(64)
);


ALTER TABLE public.act_ru_identitylink OWNER TO postgres;

--
-- Name: act_ru_job; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_job (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    type_ character varying(1020) NOT NULL,
    lock_exp_time_ timestamp(6) without time zone,
    lock_owner_ character varying(1020),
    exclusive_ numeric(1,0),
    execution_id_ character varying(64),
    process_instance_id_ character varying(64),
    proc_def_id_ character varying(64),
    retries_ numeric,
    exception_stack_id_ character varying(64),
    exception_msg_ character varying(2000),
    duedate_ timestamp(6) without time zone,
    repeat_ character varying(1020),
    handler_type_ character varying(1020),
    handler_cfg_ character varying(2000),
    tenant_id_ character varying(255)
);


ALTER TABLE public.act_ru_job OWNER TO postgres;

--
-- Name: act_ru_task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_task (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    execution_id_ character varying(64),
    proc_inst_id_ character varying(64),
    proc_def_id_ character varying(64),
    name_ character varying(1020),
    parent_task_id_ character varying(64),
    description_ character varying(2000),
    task_def_key_ character varying(1020),
    owner_ character varying(1024),
    assignee_ character varying(1024),
    delegation_ character varying(256),
    priority_ numeric,
    create_time_ timestamp(6) without time zone,
    due_date_ timestamp(6) without time zone,
    suspension_state_ numeric,
    category_ character varying(1020),
    tenant_id_ character varying(255),
    form_key_ character varying(1020)
);


ALTER TABLE public.act_ru_task OWNER TO postgres;

--
-- Name: COLUMN act_ru_task.id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.id_ IS '主键';


--
-- Name: COLUMN act_ru_task.rev_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.rev_ IS '版本号';


--
-- Name: COLUMN act_ru_task.execution_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.execution_id_ IS '执行实例ID';


--
-- Name: COLUMN act_ru_task.proc_inst_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.proc_inst_id_ IS '流程实例ID';


--
-- Name: COLUMN act_ru_task.proc_def_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.proc_def_id_ IS '流程定义ID';


--
-- Name: COLUMN act_ru_task.name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.name_ IS '节点定义名称';


--
-- Name: COLUMN act_ru_task.parent_task_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.parent_task_id_ IS '父节点实例ID';


--
-- Name: COLUMN act_ru_task.description_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.description_ IS '节点定义描述';


--
-- Name: COLUMN act_ru_task.task_def_key_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.task_def_key_ IS '节点定义的KEY';


--
-- Name: COLUMN act_ru_task.owner_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.owner_ IS '实际签收人';


--
-- Name: COLUMN act_ru_task.assignee_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.assignee_ IS '签收人或委托人';


--
-- Name: COLUMN act_ru_task.delegation_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.delegation_ IS '委托类型';


--
-- Name: COLUMN act_ru_task.priority_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.priority_ IS '优先级别';


--
-- Name: COLUMN act_ru_task.create_time_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.create_time_ IS '创建时间';


--
-- Name: COLUMN act_ru_task.due_date_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.due_date_ IS '过期时间';


--
-- Name: COLUMN act_ru_task.suspension_state_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task.suspension_state_ IS '是否挂起';


--
-- Name: act_ru_task_extension; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_task_extension (
    id_ character varying(64) NOT NULL,
    catalog_id_ character varying(32),
    kind_id_ character varying(32),
    creator_url_ character varying(512),
    executor_url_ character varying(512),
    creator_person_member_id_ character varying(65),
    creator_person_member_name_ character varying(256),
    creator_pos_id_ character varying(65),
    creator_pos_name_ character varying(256),
    creator_dept_id_ character varying(65),
    creator_dept_name_ character varying(256),
    creator_ogn_id_ character varying(65),
    creator_ogn_name_ character varying(256),
    creator_full_id_ character varying(1024),
    creator_full_name_ character varying(2048),
    executor_person_member_id_ character varying(65),
    executor_person_member_name_ character varying(256),
    executor_pos_id_ character varying(65),
    executor_pos_name_ character varying(256),
    executor_dept_id_ character varying(65),
    executor_dept_name_ character varying(256),
    executor_ogn_id_ character varying(65),
    executor_ogn_name_ character varying(256),
    executor_full_id_ character varying(1024),
    executor_full_name_ character varying(2048),
    status_id_ character varying(32),
    status_name_ character varying(128),
    executor_names_ character varying(2048),
    owner_person_member_id_ character varying(65),
    owner_person_member_name_ character varying(256),
    owner_pos_id_ character varying(65),
    owner_pos_name_ character varying(256),
    owner_dept_id_ character varying(65),
    owner_dept_name_ character varying(256),
    owner_ogn_id_ character varying(65),
    owner_ogn_name_ character varying(256),
    owner_full_id_ character varying(1024),
    owner_full_name_ character varying(2048),
    previous_id_ character varying(64),
    proc_unit_handler_id_ character varying(32),
    business_key_ character varying(1020),
    business_code_ character varying(256),
    need_timing_ numeric,
    opinion_ character varying(2048),
    result_ numeric,
    sleeped_date_ timestamp(6) without time zone,
    version_ numeric,
    proc_inst_id_ character varying(64),
    cooperation_model_id_ character varying(32),
    limit_time_ numeric,
    applicant_person_member_id_ character varying(65),
    applicant_person_member_name_ character varying(256),
    process_definition_key_ character varying(510),
    creator_person_id_ character varying(32),
    executor_person_id_ character varying(32),
    execution_id_ character varying(64),
    proc_def_id_ character varying(64),
    name_ character varying(1020),
    parent_task_id_ character varying(64),
    description_ character varying(2000),
    task_def_key_ character varying(1020),
    delegation_ character varying(256),
    priority_ numeric,
    start_time_ timestamp(6) without time zone,
    due_date_ timestamp(6) without time zone,
    suspension_state_ numeric,
    category_ character varying(1020),
    tenant_id_ character varying(255),
    form_key_ character varying(1020),
    generate_reason_ character varying(1020),
    sub_proc_unit_name_ character varying(1020)
);


ALTER TABLE public.act_ru_task_extension OWNER TO postgres;

--
-- Name: COLUMN act_ru_task_extension.catalog_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.catalog_id_ IS '任务的大类标识 process为流程任务，task为协同任务';


--
-- Name: COLUMN act_ru_task_extension.kind_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.kind_id_ IS '任务的类型细分标识，task为任务，notice 任务抄送';


--
-- Name: COLUMN act_ru_task_extension.creator_url_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_url_ IS '创建此任务的activity的URL';


--
-- Name: COLUMN act_ru_task_extension.executor_url_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_url_ IS '处理此任务的activity的URL';


--
-- Name: COLUMN act_ru_task_extension.creator_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_person_member_id_ IS '创建人ID';


--
-- Name: COLUMN act_ru_task_extension.creator_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_person_member_name_ IS '创建人';


--
-- Name: COLUMN act_ru_task_extension.creator_pos_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_pos_id_ IS '创建人岗位ID';


--
-- Name: COLUMN act_ru_task_extension.creator_pos_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_pos_name_ IS '创建人岗位';


--
-- Name: COLUMN act_ru_task_extension.creator_dept_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_dept_id_ IS '创建人部门ID';


--
-- Name: COLUMN act_ru_task_extension.creator_dept_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_dept_name_ IS '创建人部门';


--
-- Name: COLUMN act_ru_task_extension.creator_ogn_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_ogn_id_ IS '创建人机构ID';


--
-- Name: COLUMN act_ru_task_extension.creator_ogn_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_ogn_name_ IS '创建人机构';


--
-- Name: COLUMN act_ru_task_extension.creator_full_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_full_id_ IS '创建人ID全路径';


--
-- Name: COLUMN act_ru_task_extension.creator_full_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_full_name_ IS '创建人名称全路径';


--
-- Name: COLUMN act_ru_task_extension.executor_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_person_member_id_ IS '执行人ID';


--
-- Name: COLUMN act_ru_task_extension.executor_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_person_member_name_ IS '执行人';


--
-- Name: COLUMN act_ru_task_extension.executor_pos_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_pos_id_ IS '执行人岗位ID';


--
-- Name: COLUMN act_ru_task_extension.executor_pos_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_pos_name_ IS '执行人岗位';


--
-- Name: COLUMN act_ru_task_extension.executor_dept_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_dept_id_ IS '执行人部门ID';


--
-- Name: COLUMN act_ru_task_extension.executor_dept_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_dept_name_ IS '执行人部门';


--
-- Name: COLUMN act_ru_task_extension.executor_ogn_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_ogn_id_ IS '执行人机构ID';


--
-- Name: COLUMN act_ru_task_extension.executor_ogn_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_ogn_name_ IS '执行人机构';


--
-- Name: COLUMN act_ru_task_extension.executor_full_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_full_id_ IS '执行人ID全路径';


--
-- Name: COLUMN act_ru_task_extension.executor_full_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_full_name_ IS '执行人名称全路径';


--
-- Name: COLUMN act_ru_task_extension.status_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.status_id_ IS '任务状态ID ，取值范围是ready(尚未处理)，executing(正在处理)，sleeping(暂缓处理)，canceled(已取消)，aborted(已终止)，completed(已完成)，returned(已回退)，trainsmited(已转发)，paused(已暂停)';


--
-- Name: COLUMN act_ru_task_extension.status_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.status_name_ IS '任务状态';


--
-- Name: COLUMN act_ru_task_extension.executor_names_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_names_ IS '执行人名称';


--
-- Name: COLUMN act_ru_task_extension.owner_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_person_member_id_ IS '责任人ID';


--
-- Name: COLUMN act_ru_task_extension.owner_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_person_member_name_ IS '责任人';


--
-- Name: COLUMN act_ru_task_extension.owner_pos_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_pos_id_ IS '责任人岗位ID';


--
-- Name: COLUMN act_ru_task_extension.owner_pos_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_pos_name_ IS '责任人岗位';


--
-- Name: COLUMN act_ru_task_extension.owner_dept_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_dept_id_ IS '责任人部门ID';


--
-- Name: COLUMN act_ru_task_extension.owner_dept_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_dept_name_ IS '责任人部门';


--
-- Name: COLUMN act_ru_task_extension.owner_ogn_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_ogn_id_ IS '责任人机构ID';


--
-- Name: COLUMN act_ru_task_extension.owner_ogn_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_ogn_name_ IS '责任人机构';


--
-- Name: COLUMN act_ru_task_extension.owner_full_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_full_id_ IS '责任人ID全路径';


--
-- Name: COLUMN act_ru_task_extension.owner_full_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.owner_full_name_ IS '责任人名称全路径';


--
-- Name: COLUMN act_ru_task_extension.previous_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.previous_id_ IS '前任务ID';


--
-- Name: COLUMN act_ru_task_extension.proc_unit_handler_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.proc_unit_handler_id_ IS '环节处理人ID';


--
-- Name: COLUMN act_ru_task_extension.business_key_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.business_key_ IS '业务组件ID';


--
-- Name: COLUMN act_ru_task_extension.business_code_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.business_code_ IS '业务组件编码';


--
-- Name: COLUMN act_ru_task_extension.need_timing_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.need_timing_ IS '需要计时';


--
-- Name: COLUMN act_ru_task_extension.opinion_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.opinion_ IS '处理意见';


--
-- Name: COLUMN act_ru_task_extension.result_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.result_ IS '处理结果';


--
-- Name: COLUMN act_ru_task_extension.sleeped_date_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.sleeped_date_ IS '暂缓时间';


--
-- Name: COLUMN act_ru_task_extension.proc_inst_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.proc_inst_id_ IS '流程实例ID';


--
-- Name: COLUMN act_ru_task_extension.cooperation_model_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.cooperation_model_id_ IS '协助模式';


--
-- Name: COLUMN act_ru_task_extension.limit_time_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.limit_time_ IS '限制时间';


--
-- Name: COLUMN act_ru_task_extension.applicant_person_member_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.applicant_person_member_id_ IS '申请人员成员ID';


--
-- Name: COLUMN act_ru_task_extension.applicant_person_member_name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.applicant_person_member_name_ IS '申请人员成员';


--
-- Name: COLUMN act_ru_task_extension.process_definition_key_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.process_definition_key_ IS '流程定义ID';


--
-- Name: COLUMN act_ru_task_extension.creator_person_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.creator_person_id_ IS '创建人';


--
-- Name: COLUMN act_ru_task_extension.executor_person_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.executor_person_id_ IS '执行人';


--
-- Name: COLUMN act_ru_task_extension.execution_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.execution_id_ IS '执行实例ID';


--
-- Name: COLUMN act_ru_task_extension.proc_def_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.proc_def_id_ IS '流程定义ID';


--
-- Name: COLUMN act_ru_task_extension.name_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.name_ IS '节点定义名称';


--
-- Name: COLUMN act_ru_task_extension.parent_task_id_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.parent_task_id_ IS '父节点实例ID';


--
-- Name: COLUMN act_ru_task_extension.description_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.description_ IS '节点定义描述';


--
-- Name: COLUMN act_ru_task_extension.task_def_key_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.task_def_key_ IS '节点定义的KEY';


--
-- Name: COLUMN act_ru_task_extension.delegation_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.delegation_ IS '委托类型';


--
-- Name: COLUMN act_ru_task_extension.priority_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.priority_ IS '优先级别';


--
-- Name: COLUMN act_ru_task_extension.start_time_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.start_time_ IS '创建时间';


--
-- Name: COLUMN act_ru_task_extension.due_date_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.due_date_ IS '过期时间';


--
-- Name: COLUMN act_ru_task_extension.suspension_state_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.suspension_state_ IS '是否挂起';


--
-- Name: COLUMN act_ru_task_extension.generate_reason_; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.act_ru_task_extension.generate_reason_ IS '产生原因';


--
-- Name: act_ru_variable; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.act_ru_variable (
    id_ character varying(64) NOT NULL,
    rev_ numeric,
    type_ character varying(1020) NOT NULL,
    name_ character varying(1020) NOT NULL,
    execution_id_ character varying(64),
    proc_inst_id_ character varying(64),
    task_id_ character varying(64),
    bytearray_id_ character varying(64),
    double_ numeric(10,10),
    long_ numeric(19,0),
    text_ character varying(2000),
    text2_ character varying(2000)
);


ALTER TABLE public.act_ru_variable OWNER TO postgres;

--
-- Name: avic_imp_employee; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_imp_employee (
    level1 character varying(255),
    level2 character varying(255),
    level3 character varying(255),
    level4 character varying(255),
    level5 character varying(255),
    level6 character varying(255),
    level7 character varying(255),
    emp_no character varying(32),
    real_name character varying(255),
    "position" character varying(64),
    batch_number character varying(255),
    message character varying(2048),
    status numeric(38,0),
    tmp_id character varying(32) NOT NULL,
    last_name character varying(32),
    first_name character varying(32),
    telephone1 character varying(64),
    telephone2 character varying(64),
    mobile_phone1 character varying(64),
    mobile_phone2 character varying(64),
    email1 character varying(255),
    email2 character varying(255),
    position_type character varying(32),
    description character varying(1024)
);


ALTER TABLE public.avic_imp_employee OWNER TO postgres;

--
-- Name: TABLE avic_imp_employee; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_imp_employee IS '员工导入临时表';


--
-- Name: COLUMN avic_imp_employee.level1; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level1 IS '一级部门名称';


--
-- Name: COLUMN avic_imp_employee.level2; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level2 IS '二级部门名称';


--
-- Name: COLUMN avic_imp_employee.level3; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level3 IS '三级部门名称';


--
-- Name: COLUMN avic_imp_employee.level4; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level4 IS '四级部门名称';


--
-- Name: COLUMN avic_imp_employee.level5; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level5 IS '五级部门名称';


--
-- Name: COLUMN avic_imp_employee.level6; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level6 IS '6级部门名称';


--
-- Name: COLUMN avic_imp_employee.level7; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.level7 IS '7级部门名称';


--
-- Name: COLUMN avic_imp_employee.emp_no; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.emp_no IS '工号';


--
-- Name: COLUMN avic_imp_employee.real_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.real_name IS '姓名';


--
-- Name: COLUMN avic_imp_employee."position"; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee."position" IS '职务';


--
-- Name: COLUMN avic_imp_employee.batch_number; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.batch_number IS '导入批次号';


--
-- Name: COLUMN avic_imp_employee.message; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.message IS '导入状态消息';


--
-- Name: COLUMN avic_imp_employee.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.status IS '导入状态';


--
-- Name: COLUMN avic_imp_employee.tmp_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.tmp_id IS '临时数据id';


--
-- Name: COLUMN avic_imp_employee.last_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.last_name IS '姓';


--
-- Name: COLUMN avic_imp_employee.first_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.first_name IS '名';


--
-- Name: COLUMN avic_imp_employee.telephone1; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.telephone1 IS '电话号码1';


--
-- Name: COLUMN avic_imp_employee.telephone2; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.telephone2 IS '电话号码2';


--
-- Name: COLUMN avic_imp_employee.mobile_phone1; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.mobile_phone1 IS '移动号码1';


--
-- Name: COLUMN avic_imp_employee.mobile_phone2; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.mobile_phone2 IS '移动号码2';


--
-- Name: COLUMN avic_imp_employee.email1; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.email1 IS '邮箱1';


--
-- Name: COLUMN avic_imp_employee.email2; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.email2 IS '邮箱2';


--
-- Name: COLUMN avic_imp_employee.position_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.position_type IS '职位类型';


--
-- Name: COLUMN avic_imp_employee.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_imp_employee.description IS '描述';


--
-- Name: avic_oauth2_client; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_oauth2_client (
    id character varying(32) NOT NULL,
    version numeric(38,0),
    name character varying(255) NOT NULL,
    secret_key character varying(32) NOT NULL
);


ALTER TABLE public.avic_oauth2_client OWNER TO postgres;

--
-- Name: COLUMN avic_oauth2_client.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_oauth2_client.id IS '客户端id';


--
-- Name: COLUMN avic_oauth2_client.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_oauth2_client.name IS '客户端名称';


--
-- Name: COLUMN avic_oauth2_client.secret_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_oauth2_client.secret_key IS '客户端key';


--
-- Name: avic_object_authorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_object_authorize (
    id character varying(32) NOT NULL,
    biz_code character varying(128) NOT NULL,
    biz_id character varying(32) NOT NULL,
    authorizer_id character varying(65) NOT NULL,
    authorize_time timestamp(6) without time zone NOT NULL,
    authorizer_name character varying(64) NOT NULL,
    org_id character varying(65) NOT NULL,
    org_name character varying(128) NOT NULL,
    org_full_id character varying(1024) NOT NULL,
    authorize_type numeric,
    version numeric
);


ALTER TABLE public.avic_object_authorize OWNER TO postgres;

--
-- Name: TABLE avic_object_authorize; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_object_authorize IS '对象授权';


--
-- Name: COLUMN avic_object_authorize.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.id IS '主键';


--
-- Name: COLUMN avic_object_authorize.biz_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.biz_code IS '业务编码';


--
-- Name: COLUMN avic_object_authorize.biz_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.biz_id IS '业务id';


--
-- Name: COLUMN avic_object_authorize.authorizer_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.authorizer_id IS '授权人id';


--
-- Name: COLUMN avic_object_authorize.authorize_time; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.authorize_time IS '授权时间';


--
-- Name: COLUMN avic_object_authorize.authorizer_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.authorizer_name IS '授权人名称';


--
-- Name: COLUMN avic_object_authorize.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.org_id IS '使用者orgId';


--
-- Name: COLUMN avic_object_authorize.org_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.org_name IS '使用者名称';


--
-- Name: COLUMN avic_object_authorize.org_full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.org_full_id IS '使用者全id';


--
-- Name: COLUMN avic_object_authorize.authorize_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.authorize_type IS '授权类型';


--
-- Name: COLUMN avic_object_authorize.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_object_authorize.version IS '实体版本号';


--
-- Name: avic_report; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_report (
    id character varying(32) NOT NULL,
    version numeric,
    status numeric NOT NULL,
    name character varying(512) NOT NULL,
    created_by_id character varying(65) NOT NULL,
    created_by_name character varying(64) NOT NULL,
    created_date timestamp(6) without time zone NOT NULL,
    last_modified_by_id character varying(65) NOT NULL,
    last_modified_by_name character varying(64) NOT NULL,
    last_modified_date timestamp(6) without time zone NOT NULL,
    kind_id numeric NOT NULL,
    template_id character varying(32),
    template_name character varying(512),
    share_count numeric NOT NULL,
    created_by_full_id character varying(1024) NOT NULL,
    biz_id character varying(32),
    folder_id character varying(32)
);


ALTER TABLE public.avic_report OWNER TO postgres;

--
-- Name: TABLE avic_report; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_report IS '生成的报告';


--
-- Name: COLUMN avic_report.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.id IS '主键';


--
-- Name: COLUMN avic_report.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.version IS '实体版本';


--
-- Name: COLUMN avic_report.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.status IS '-1  逻辑删除，0 未发布， 1 已发布';


--
-- Name: COLUMN avic_report.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.name IS '报告名称';


--
-- Name: COLUMN avic_report.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.created_by_id IS '创建者id';


--
-- Name: COLUMN avic_report.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.created_by_name IS '创建者名称';


--
-- Name: COLUMN avic_report.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.created_date IS '创建时间';


--
-- Name: COLUMN avic_report.last_modified_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.last_modified_by_id IS '修改者id';


--
-- Name: COLUMN avic_report.last_modified_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.last_modified_by_name IS '修改者名称';


--
-- Name: COLUMN avic_report.last_modified_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.last_modified_date IS '修改时间';


--
-- Name: COLUMN avic_report.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.kind_id IS '1 - 在线，2 - 本地上传';


--
-- Name: COLUMN avic_report.template_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.template_id IS '模板id';


--
-- Name: COLUMN avic_report.template_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.template_name IS '模板名称';


--
-- Name: COLUMN avic_report.share_count; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.share_count IS '有效分享次数';


--
-- Name: COLUMN avic_report.created_by_full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.created_by_full_id IS '创建者全id';


--
-- Name: COLUMN avic_report.biz_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.biz_id IS '业务编码';


--
-- Name: COLUMN avic_report.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report.folder_id IS '文件夹id';


--
-- Name: avic_report_form; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_report_form (
    id character varying(64),
    template_path character varying(1024),
    parent_id character varying(64),
    full_id character varying(1024),
    full_name character varying(1024),
    name character varying(512),
    code character varying(512),
    status numeric,
    version numeric,
    sequence numeric(38,0),
    node_kind_id numeric(2,0),
    file_id character varying(64),
    remark character varying(255),
    kind_id numeric(2,0),
    url character varying(1024)
);


ALTER TABLE public.avic_report_form OWNER TO postgres;

--
-- Name: TABLE avic_report_form; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_report_form IS '报表';


--
-- Name: COLUMN avic_report_form.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.id IS '主键';


--
-- Name: COLUMN avic_report_form.template_path; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.template_path IS '模板路径';


--
-- Name: COLUMN avic_report_form.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.parent_id IS '父id';


--
-- Name: COLUMN avic_report_form.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.full_id IS 'ID全路径';


--
-- Name: COLUMN avic_report_form.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.full_name IS '全id';


--
-- Name: COLUMN avic_report_form.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.name IS '全名称';


--
-- Name: COLUMN avic_report_form.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.code IS '编码';


--
-- Name: COLUMN avic_report_form.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.status IS '状态';


--
-- Name: COLUMN avic_report_form.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.version IS '实体版本号';


--
-- Name: COLUMN avic_report_form.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.sequence IS '排序号';


--
-- Name: COLUMN avic_report_form.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.node_kind_id IS '节点类型';


--
-- Name: COLUMN avic_report_form.file_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.file_id IS '文件id';


--
-- Name: COLUMN avic_report_form.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.remark IS '备注';


--
-- Name: COLUMN avic_report_form.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.kind_id IS '模板类型';


--
-- Name: COLUMN avic_report_form.url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form.url IS '访问路径';


--
-- Name: avic_report_form_parameter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_report_form_parameter (
    id character varying(32) NOT NULL,
    version numeric(38,0),
    code character varying(20) NOT NULL,
    name character varying(20) NOT NULL,
    status numeric(2,0),
    default_value character varying(128),
    remark character varying(20),
    report_form_id character varying(32) NOT NULL,
    control_type numeric(2,0),
    data_source_kind numeric(2,0),
    data_source character varying(2048)
);


ALTER TABLE public.avic_report_form_parameter OWNER TO postgres;

--
-- Name: TABLE avic_report_form_parameter; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_report_form_parameter IS '报表参数';


--
-- Name: COLUMN avic_report_form_parameter.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.status IS '状态';


--
-- Name: COLUMN avic_report_form_parameter.default_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.default_value IS '默认值';


--
-- Name: COLUMN avic_report_form_parameter.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.remark IS '备注';


--
-- Name: COLUMN avic_report_form_parameter.report_form_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.report_form_id IS '报表id';


--
-- Name: COLUMN avic_report_form_parameter.control_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.control_type IS '控件类型';


--
-- Name: COLUMN avic_report_form_parameter.data_source_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.data_source_kind IS '数据源类型';


--
-- Name: COLUMN avic_report_form_parameter.data_source; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_form_parameter.data_source IS '数据源';


--
-- Name: avic_report_from_authorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_report_from_authorize (
    id character varying(64),
    org_id character varying(65),
    org_name character varying(64),
    org_full_id character varying(1024),
    form_id character varying(64),
    version numeric(38,0)
);


ALTER TABLE public.avic_report_from_authorize OWNER TO postgres;

--
-- Name: TABLE avic_report_from_authorize; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_report_from_authorize IS '报表授权';


--
-- Name: avic_report_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_report_template (
    id character varying(64),
    type numeric,
    file_type numeric,
    node_kind numeric,
    parent_id character varying(64),
    full_id character varying(1024),
    full_name character varying(1024),
    name character varying(512),
    code character varying(512),
    status numeric,
    version numeric,
    folder_id character varying(64),
    sequence numeric,
    file_id character varying(64),
    pub_template_id character varying(64)
);


ALTER TABLE public.avic_report_template OWNER TO postgres;

--
-- Name: TABLE avic_report_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_report_template IS '在线报告模板';


--
-- Name: COLUMN avic_report_template.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.id IS '主键';


--
-- Name: COLUMN avic_report_template.type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.type IS '模板类型（字典），0-公共模板，1-个人模板';


--
-- Name: COLUMN avic_report_template.file_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.file_type IS '模板文件类型';


--
-- Name: COLUMN avic_report_template.node_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.node_kind IS '节点类型';


--
-- Name: COLUMN avic_report_template.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.parent_id IS '父id';


--
-- Name: COLUMN avic_report_template.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.full_id IS 'ID全路径';


--
-- Name: COLUMN avic_report_template.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.full_name IS '全名称';


--
-- Name: COLUMN avic_report_template.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.name IS '名称';


--
-- Name: COLUMN avic_report_template.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.code IS '编码';


--
-- Name: COLUMN avic_report_template.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.status IS '状态';


--
-- Name: COLUMN avic_report_template.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.version IS '实体版本号';


--
-- Name: COLUMN avic_report_template.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.folder_id IS '文件夹id';


--
-- Name: COLUMN avic_report_template.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.sequence IS '排序号';


--
-- Name: COLUMN avic_report_template.file_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.file_id IS '模板文件id';


--
-- Name: COLUMN avic_report_template.pub_template_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template.pub_template_id IS '关联公共模板id';


--
-- Name: avic_report_template_authorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.avic_report_template_authorize (
    id character varying(64),
    template_id character varying(64),
    authorize_type numeric,
    org_id character varying(65),
    org_name character varying(64),
    org_full_id character varying(1024),
    version numeric(38,0)
);


ALTER TABLE public.avic_report_template_authorize OWNER TO postgres;

--
-- Name: TABLE avic_report_template_authorize; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.avic_report_template_authorize IS '报告模板授权';


--
-- Name: COLUMN avic_report_template_authorize.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.id IS '主键';


--
-- Name: COLUMN avic_report_template_authorize.template_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.template_id IS '模板id';


--
-- Name: COLUMN avic_report_template_authorize.authorize_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.authorize_type IS '0 - 公共模板授权
1 - 个人
2 - 分享
';


--
-- Name: COLUMN avic_report_template_authorize.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.org_id IS '使用者id';


--
-- Name: COLUMN avic_report_template_authorize.org_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.org_name IS '使用者名称';


--
-- Name: COLUMN avic_report_template_authorize.org_full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.org_full_id IS '使用者全路径';


--
-- Name: COLUMN avic_report_template_authorize.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.avic_report_template_authorize.version IS '实体版本号';


--
-- Name: demo_leave; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.demo_leave (
    id character varying(32) NOT NULL,
    fillin_date timestamp(6) without time zone,
    bill_code character varying(32),
    status numeric(32,0),
    full_id character varying(1024),
    organ_id character varying(32),
    organ_name character varying(32),
    dept_id character varying(32),
    dept_name character varying(32),
    position_id character varying(32),
    position_name character varying(20),
    person_member_id character varying(65),
    person_member_name character varying(20),
    version numeric(32,0),
    days numeric(32,0)
);


ALTER TABLE public.demo_leave OWNER TO postgres;

--
-- Name: district; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.district (
    id numeric(10,0) NOT NULL,
    parent_id numeric(10,0),
    name character varying(255) NOT NULL
);


ALTER TABLE public.district OWNER TO postgres;

--
-- Name: pm_exercise_list; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pm_exercise_list (
    id character varying(32) NOT NULL,
    exercise_name character varying(100),
    exercise_type numeric,
    exercise_stock numeric(8,0),
    exercise_price numeric(10,2),
    version numeric(19,0),
    created_by_id character varying(255),
    created_by_name character varying(255),
    created_date timestamp(6) without time zone,
    last_modified_by_id character varying(255),
    last_modified_by_name character varying(255),
    last_modified_date timestamp(6) without time zone,
    code character varying(255),
    name character varying(255),
    status numeric(10,0),
    folder_id character varying(255)
);


ALTER TABLE public.pm_exercise_list OWNER TO postgres;

--
-- Name: COLUMN pm_exercise_list.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.pm_exercise_list.id IS '商品id';


--
-- Name: COLUMN pm_exercise_list.exercise_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.pm_exercise_list.exercise_name IS '商品名称';


--
-- Name: COLUMN pm_exercise_list.exercise_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.pm_exercise_list.exercise_type IS '商品类型';


--
-- Name: COLUMN pm_exercise_list.exercise_stock; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.pm_exercise_list.exercise_stock IS '库存';


--
-- Name: COLUMN pm_exercise_list.exercise_price; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.pm_exercise_list.exercise_price IS '价格';


--
-- Name: pm_exercisedetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pm_exercisedetail (
    id character varying(32) NOT NULL,
    eid character varying(100),
    cpu character varying(100),
    ram character varying(100),
    rom character varying(100),
    rear_camera character varying(100),
    front_camera character varying(100),
    screen_size character varying(100),
    name character varying(100),
    version numeric(19,0),
    sequence numeric
);


ALTER TABLE public.pm_exercisedetail OWNER TO postgres;

--
-- Name: pm_product_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pm_product_config (
    id character varying(32) NOT NULL,
    pid character varying(32),
    cpu character varying(100),
    ram character varying(100),
    rom character varying(100),
    sequence numeric,
    describe character varying(1000)
);


ALTER TABLE public.pm_product_config OWNER TO postgres;

--
-- Name: pm_tree_product; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pm_tree_product (
    id character varying(32) NOT NULL,
    sid character varying(255),
    p_name character varying(100),
    p_type character varying(100),
    p_price numeric(10,2),
    p_stock numeric(8,0),
    version numeric(19,0),
    created_by_id character varying(255),
    created_by_name character varying(255),
    created_date timestamp(6) without time zone,
    last_modified_by_id character varying(255),
    last_modified_by_name character varying(255),
    last_modified_date timestamp(6) without time zone,
    full_id character varying(1000)
);


ALTER TABLE public.pm_tree_product OWNER TO postgres;

--
-- Name: pm_tree_shape; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pm_tree_shape (
    id character varying(255) NOT NULL,
    code character varying(255),
    name character varying(255),
    status numeric(10,0),
    full_id character varying(1024),
    full_name character varying(1024),
    parent_id character varying(255),
    sequence numeric(10,0),
    version numeric(19,0),
    created_by_id character varying(255),
    created_by_name character varying(255),
    created_date timestamp(6) without time zone,
    last_modified_by_id character varying(255),
    last_modified_by_name character varying(255),
    last_modified_date timestamp(6) without time zone
);


ALTER TABLE public.pm_tree_shape OWNER TO postgres;

--
-- Name: sa_applicationsystem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_applicationsystem (
    id character varying(32),
    code character varying(128),
    name character varying(256),
    class_prefix character varying(512),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_applicationsystem OWNER TO postgres;

--
-- Name: sa_approval_rejected_reason; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_approval_rejected_reason (
    id character varying(32),
    folder_id character varying(32),
    content character varying(512),
    sequence numeric,
    status numeric,
    version numeric,
    rejected_reason_kind character varying(64)
);


ALTER TABLE public.sa_approval_rejected_reason OWNER TO postgres;

--
-- Name: TABLE sa_approval_rejected_reason; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_approval_rejected_reason IS '审批驳回理由维护';


--
-- Name: COLUMN sa_approval_rejected_reason.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.id IS 'id';


--
-- Name: COLUMN sa_approval_rejected_reason.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.folder_id IS '分类ID';


--
-- Name: COLUMN sa_approval_rejected_reason.content; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.content IS 'content';


--
-- Name: COLUMN sa_approval_rejected_reason.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.sequence IS 'sequence';


--
-- Name: COLUMN sa_approval_rejected_reason.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.status IS 'status';


--
-- Name: COLUMN sa_approval_rejected_reason.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.version IS 'version';


--
-- Name: COLUMN sa_approval_rejected_reason.rejected_reason_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_approval_rejected_reason.rejected_reason_kind IS '类型';


--
-- Name: sa_attachment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_attachment (
    id character varying(32),
    biz_kind_id character varying(32),
    biz_id character varying(32),
    biz_sub_kind_id character varying(32),
    path character varying(1024),
    file_name character varying(512),
    file_size character varying(32),
    file_kind character varying(32),
    created_by_id character varying(65),
    created_date timestamp(6) without time zone,
    created_by_name character varying(128),
    clear_cache numeric,
    upload_kind character varying(32),
    remark character varying(512),
    status numeric,
    version numeric,
    sequence numeric
);


ALTER TABLE public.sa_attachment OWNER TO postgres;

--
-- Name: COLUMN sa_attachment.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.id IS 'ID';


--
-- Name: COLUMN sa_attachment.biz_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.biz_kind_id IS '业务类别ID';


--
-- Name: COLUMN sa_attachment.biz_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.biz_id IS '业务ID';


--
-- Name: COLUMN sa_attachment.biz_sub_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.biz_sub_kind_id IS '业务子类别ID';


--
-- Name: COLUMN sa_attachment.path; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.path IS '路径';


--
-- Name: COLUMN sa_attachment.file_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.file_name IS '文件名称';


--
-- Name: COLUMN sa_attachment.file_size; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.file_size IS '文件大小';


--
-- Name: COLUMN sa_attachment.file_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.file_kind IS '文件类别';


--
-- Name: COLUMN sa_attachment.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.created_by_id IS '创建人ID';


--
-- Name: COLUMN sa_attachment.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.created_date IS '创建日期';


--
-- Name: COLUMN sa_attachment.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.created_by_name IS '创建人';


--
-- Name: COLUMN sa_attachment.clear_cache; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.clear_cache IS '清楚缓存';


--
-- Name: COLUMN sa_attachment.upload_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.upload_kind IS '上传类型';


--
-- Name: COLUMN sa_attachment.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.remark IS '备注';


--
-- Name: COLUMN sa_attachment.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.status IS '状态';


--
-- Name: COLUMN sa_attachment.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.version IS '版本';


--
-- Name: COLUMN sa_attachment.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_attachment.sequence IS '排序号';


--
-- Name: sa_attachmentconfig; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_attachmentconfig (
    id character varying(32),
    folder_id character varying(32),
    code character varying(64),
    name character varying(128),
    allow_delete numeric,
    remark character varying(512),
    version numeric,
    status numeric,
    sequence numeric
);


ALTER TABLE public.sa_attachmentconfig OWNER TO postgres;

--
-- Name: sa_attachmentconfigdetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_attachmentconfigdetail (
    id character varying(32),
    attachmentconfig_id character varying(32),
    code character varying(64),
    name character varying(128),
    allow_multiple numeric,
    file_kind character varying(256),
    sequence numeric,
    col_span numeric,
    is_required numeric,
    version numeric
);


ALTER TABLE public.sa_attachmentconfigdetail OWNER TO postgres;

--
-- Name: sa_bizclassification; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_bizclassification (
    id character varying(32),
    code character varying(64),
    name character varying(128),
    parent_id character varying(32),
    full_id character varying(1024),
    full_name character varying(2048),
    description character varying(2048),
    sequence numeric,
    version numeric,
    status numeric
);


ALTER TABLE public.sa_bizclassification OWNER TO postgres;

--
-- Name: TABLE sa_bizclassification; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_bizclassification IS '业务分类配置';


--
-- Name: COLUMN sa_bizclassification.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.id IS 'ID';


--
-- Name: COLUMN sa_bizclassification.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.code IS '编码';


--
-- Name: COLUMN sa_bizclassification.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.name IS '名称';


--
-- Name: COLUMN sa_bizclassification.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.parent_id IS '父ID';


--
-- Name: COLUMN sa_bizclassification.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.full_id IS '全路径ID';


--
-- Name: COLUMN sa_bizclassification.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.full_name IS '全路径';


--
-- Name: COLUMN sa_bizclassification.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.description IS '描述';


--
-- Name: COLUMN sa_bizclassification.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.sequence IS '排序号';


--
-- Name: COLUMN sa_bizclassification.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.version IS '版本';


--
-- Name: COLUMN sa_bizclassification.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassification.status IS '状态';


--
-- Name: sa_bizclassificationdetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_bizclassificationdetail (
    id character varying(32),
    biz_classification_id character varying(32),
    biz_type character varying(64),
    biz_property_id character varying(32),
    sequence numeric,
    version numeric,
    entity_class_name character varying(256),
    biz_name character varying(128),
    dialog_width numeric
);


ALTER TABLE public.sa_bizclassificationdetail OWNER TO postgres;

--
-- Name: TABLE sa_bizclassificationdetail; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_bizclassificationdetail IS '业务分类配置明细';


--
-- Name: COLUMN sa_bizclassificationdetail.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.id IS 'ID';


--
-- Name: COLUMN sa_bizclassificationdetail.biz_classification_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.biz_classification_id IS '业务属性配置ID';


--
-- Name: COLUMN sa_bizclassificationdetail.biz_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.biz_type IS '业务参数;业务数据';


--
-- Name: COLUMN sa_bizclassificationdetail.biz_property_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.biz_property_id IS '业务属性ID';


--
-- Name: COLUMN sa_bizclassificationdetail.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.sequence IS '排序号';


--
-- Name: COLUMN sa_bizclassificationdetail.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.version IS '版本';


--
-- Name: COLUMN sa_bizclassificationdetail.entity_class_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.entity_class_name IS '对应实体资源类名';


--
-- Name: COLUMN sa_bizclassificationdetail.biz_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.biz_name IS '业务名称';


--
-- Name: COLUMN sa_bizclassificationdetail.dialog_width; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_bizclassificationdetail.dialog_width IS '对话框宽度';


--
-- Name: sa_codebuildrule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_codebuildrule (
    id character varying(32),
    code character varying(64),
    name character varying(128),
    rule character varying(256),
    current_value numeric,
    folder_id character varying(32),
    status numeric,
    version numeric,
    sequence numeric,
    last_modified_date timestamp(6) without time zone
);


ALTER TABLE public.sa_codebuildrule OWNER TO postgres;

--
-- Name: sa_commonhandler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_commonhandler (
    id character varying(32),
    biz_id character varying(32),
    kind_id character varying(32),
    org_unit_id character varying(65),
    org_unit_name character varying(256),
    org_kind_id character varying(32),
    full_id character varying(1024),
    version numeric,
    sequence numeric,
    group_id numeric,
    sub_proc_unit_name character varying(256)
);


ALTER TABLE public.sa_commonhandler OWNER TO postgres;

--
-- Name: TABLE sa_commonhandler; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_commonhandler IS '通用处理人设置';


--
-- Name: COLUMN sa_commonhandler.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.id IS 'ID';


--
-- Name: COLUMN sa_commonhandler.biz_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.biz_id IS '业务ID';


--
-- Name: COLUMN sa_commonhandler.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.kind_id IS 'receiver 接收人 feedbacker 反馈人 feedbackViewer 反馈查看人';


--
-- Name: COLUMN sa_commonhandler.org_unit_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.org_unit_id IS '机构ID';


--
-- Name: COLUMN sa_commonhandler.org_unit_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.org_unit_name IS '组织单元名称';


--
-- Name: COLUMN sa_commonhandler.org_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.org_kind_id IS '组织单元类别';


--
-- Name: COLUMN sa_commonhandler.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.full_id IS 'ID全路径';


--
-- Name: COLUMN sa_commonhandler.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.version IS '版本号';


--
-- Name: COLUMN sa_commonhandler.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.sequence IS '序号';


--
-- Name: COLUMN sa_commonhandler.group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.group_id IS '分组ID';


--
-- Name: COLUMN sa_commonhandler.sub_proc_unit_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commonhandler.sub_proc_unit_name IS '环节描述';


--
-- Name: sa_commontree; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_commontree (
    kind_id numeric,
    code character varying(128),
    short_code character varying(64),
    node_kind_id character varying(6),
    name character varying(256),
    remark character varying(512),
    sequence numeric,
    version numeric,
    status numeric,
    full_id character varying(256),
    full_name character varying(1024),
    id character varying(32),
    parent_id character varying(32)
);


ALTER TABLE public.sa_commontree OWNER TO postgres;

--
-- Name: TABLE sa_commontree; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_commontree IS '通用树';


--
-- Name: COLUMN sa_commontree.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.code IS '编码';


--
-- Name: COLUMN sa_commontree.short_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.short_code IS '简码';


--
-- Name: COLUMN sa_commontree.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.node_kind_id IS 'floder文件夹 2 left';


--
-- Name: COLUMN sa_commontree.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.name IS '名称';


--
-- Name: COLUMN sa_commontree.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.remark IS '备注';


--
-- Name: COLUMN sa_commontree.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.sequence IS '排序号';


--
-- Name: COLUMN sa_commontree.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.version IS '版本号';


--
-- Name: COLUMN sa_commontree.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.full_id IS 'ID全路径';


--
-- Name: COLUMN sa_commontree.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.full_name IS '名称全路径';


--
-- Name: COLUMN sa_commontree.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.id IS 'ID';


--
-- Name: COLUMN sa_commontree.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_commontree.parent_id IS '父节点ID';


--
-- Name: sa_dictionary; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_dictionary (
    id character varying(32),
    code character varying(64),
    name character varying(128),
    folder_id character varying(32),
    kind_id numeric,
    status numeric,
    remark character varying(512),
    version numeric,
    sequence numeric
);


ALTER TABLE public.sa_dictionary OWNER TO postgres;

--
-- Name: sa_dictionarydetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_dictionarydetail (
    dictionary_id character varying(32),
    id character varying(32),
    name character varying(512),
    value character varying(256),
    status numeric,
    type_id character varying(128),
    remark character varying(512),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_dictionarydetail OWNER TO postgres;

--
-- Name: sa_excelimportlog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_excelimportlog (
    id character varying(32),
    template_id character varying(32),
    batch_number character varying(64),
    file_name character varying(400),
    error_code numeric(10,0),
    error_message character varying(4000),
    full_id character varying(1024),
    full_name character varying(2048),
    organ_id character varying(32),
    organ_name character varying(128),
    dept_id character varying(32),
    dept_name character varying(128),
    position_id character varying(32),
    position_name character varying(128),
    person_member_id character varying(65),
    person_member_name character varying(64),
    created_date timestamp(6) without time zone,
    error_count numeric,
    success_count numeric,
    version numeric
);


ALTER TABLE public.sa_excelimportlog OWNER TO postgres;

--
-- Name: sa_excelimporttemplate; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_excelimporttemplate (
    id character varying(32),
    folder_id character varying(32),
    code character varying(128),
    name character varying(256),
    table_name character varying(512),
    procedure_name character varying(128),
    created_date timestamp(6) without time zone,
    created_by_id character varying(65),
    created_by_name character varying(64),
    status numeric,
    version numeric,
    sequence numeric,
    remark character varying(1024)
);


ALTER TABLE public.sa_excelimporttemplate OWNER TO postgres;

--
-- Name: sa_excelimporttemplatedetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_excelimporttemplatedetail (
    template_id character varying(32),
    id character varying(32),
    excel_column_number numeric,
    excel_column_name character varying(128),
    column_name character varying(60),
    column_description character varying(128),
    description character varying(512),
    length numeric,
    version numeric
);


ALTER TABLE public.sa_excelimporttemplatedetail OWNER TO postgres;

--
-- Name: sa_flexfieldbizgroup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_flexfieldbizgroup (
    id character varying(32),
    folder_id character varying(32),
    code character varying(64),
    name character varying(128),
    visible numeric,
    biz_code character varying(60),
    is_detail_table numeric,
    ui_style numeric,
    cols numeric,
    remark character varying(1024),
    sequence numeric,
    version numeric,
    model_file_path character varying(256),
    entity_name character varying(128),
    show_model numeric,
    table_layout character varying(256),
    status numeric
);


ALTER TABLE public.sa_flexfieldbizgroup OWNER TO postgres;

--
-- Name: sa_flexfieldbizgroupfield; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_flexfieldbizgroupfield (
    id character varying(32),
    flexfieldbizgroup_id character varying(32),
    flexfielddefinition_id character varying(32),
    sequence numeric,
    version numeric,
    nullable numeric,
    control_width numeric,
    control_height numeric,
    read_only numeric,
    visible numeric,
    new_line numeric,
    label_width numeric,
    col_span numeric
);


ALTER TABLE public.sa_flexfieldbizgroupfield OWNER TO postgres;

--
-- Name: sa_flexfielddefinition; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_flexfielddefinition (
    id character varying(32),
    folder_id character varying(32),
    field_name character varying(60),
    description character varying(128),
    field_type character varying(40),
    field_length numeric,
    field_precision numeric,
    nullable numeric,
    default_value character varying(100),
    min_value numeric(18,2),
    max_value numeric(18,2),
    remark character varying(2400),
    control_type numeric,
    control_width numeric,
    control_height numeric,
    data_source_kind_id character varying(32),
    data_source character varying(4000),
    read_only numeric,
    visible numeric,
    version numeric,
    sequence numeric,
    new_line numeric,
    label_width numeric,
    col_span numeric
);


ALTER TABLE public.sa_flexfielddefinition OWNER TO postgres;

--
-- Name: sa_flexfieldstorage; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_flexfieldstorage (
    id character varying(32),
    biz_kind_id character varying(32),
    biz_id character varying(32),
    detail_id character varying(32),
    flexfielddefinition_id character varying(32),
    field_value character varying(2048),
    flexfieldgroup_id character varying(32),
    look_up_value character varying(1024),
    sequence numeric,
    version numeric,
    field_name character varying(64)
);


ALTER TABLE public.sa_flexfieldstorage OWNER TO postgres;

--
-- Name: sa_historicsession; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_historicsession (
    id character varying(36),
    organ_id character varying(32),
    organ_name character varying(128),
    dept_id character varying(32),
    dept_name character varying(128),
    person_member_id character varying(65),
    person_member_name character varying(128),
    client_ip character varying(64),
    server_ip character varying(64),
    login_date timestamp(6) without time zone,
    logout_date timestamp(6) without time zone,
    logout_kind_id character varying(32),
    logout_person_memeber_id character varying(65),
    logout_person_memeber_name character varying(128),
    version numeric,
    full_id character varying(1024),
    full_name character varying(2048),
    session_id character varying(36),
    login_name character varying(64),
    error_message character varying(1024),
    status numeric
);


ALTER TABLE public.sa_historicsession OWNER TO postgres;

--
-- Name: sa_i18nproperties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_i18nproperties (
    id character varying(32),
    code character varying(256),
    value1 character varying(512),
    value2 character varying(512),
    value3 character varying(512),
    value4 character varying(512),
    value5 character varying(512),
    remark character varying(1024),
    version numeric,
    folder_id character varying(32),
    resource_kind character varying(128)
);


ALTER TABLE public.sa_i18nproperties OWNER TO postgres;

--
-- Name: TABLE sa_i18nproperties; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_i18nproperties IS '数据库数据国际化支持';


--
-- Name: COLUMN sa_i18nproperties.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.code IS 'i18n 编码';


--
-- Name: COLUMN sa_i18nproperties.value1; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.value1 IS '语言值1(如中文显示数据)';


--
-- Name: COLUMN sa_i18nproperties.value2; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.value2 IS '语言值2(如英文显示数据)';


--
-- Name: COLUMN sa_i18nproperties.value3; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.value3 IS '语言值3';


--
-- Name: COLUMN sa_i18nproperties.value4; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.value4 IS '语言值4';


--
-- Name: COLUMN sa_i18nproperties.value5; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.value5 IS '语言值5';


--
-- Name: COLUMN sa_i18nproperties.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.folder_id IS '类别';


--
-- Name: COLUMN sa_i18nproperties.resource_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_i18nproperties.resource_kind IS '资源类型  数据字典i18nResourceKind';


--
-- Name: sa_machine; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_machine (
    id character varying(32),
    code character varying(64),
    name character varying(64),
    ip character varying(64),
    mac character varying(64),
    security_grade character varying(64),
    remark character varying(256),
    version numeric,
    status numeric
);


ALTER TABLE public.sa_machine OWNER TO postgres;

--
-- Name: sa_message_remind; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_message_remind (
    id character varying(32),
    folder_id character varying(32),
    code character varying(128),
    name character varying(256),
    status numeric,
    sequence numeric,
    version numeric,
    remind_title character varying(1024),
    remind_url character varying(1024),
    execute_func character varying(256),
    replace_kind numeric,
    open_kind numeric
);


ALTER TABLE public.sa_message_remind OWNER TO postgres;

--
-- Name: TABLE sa_message_remind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_message_remind IS '系统消息提醒配置表';


--
-- Name: COLUMN sa_message_remind.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.folder_id IS '文件夹ID';


--
-- Name: COLUMN sa_message_remind.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.code IS '编码';


--
-- Name: COLUMN sa_message_remind.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.name IS '名称';


--
-- Name: COLUMN sa_message_remind.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_message_remind.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.sequence IS '排序号';


--
-- Name: COLUMN sa_message_remind.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.version IS '版本号';


--
-- Name: COLUMN sa_message_remind.remind_title; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.remind_title IS '提示文本';


--
-- Name: COLUMN sa_message_remind.remind_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.remind_url IS '连接地址';


--
-- Name: COLUMN sa_message_remind.execute_func; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.execute_func IS '函数';


--
-- Name: COLUMN sa_message_remind.replace_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.replace_kind IS '替换类别  0 顺序替换 1名称替换 2存在则显示';


--
-- Name: COLUMN sa_message_remind.open_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_message_remind.open_kind IS '页面打开方式 0 新窗口 1 弹出';


--
-- Name: sa_onlinesession; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_onlinesession (
    id character varying(36),
    organ_id character varying(32),
    organ_name character varying(128),
    dept_id character varying(32),
    dept_name character varying(128),
    person_member_id character varying(65),
    person_member_name character varying(128),
    client_ip character varying(64),
    server_ip character varying(64),
    login_date timestamp(6) without time zone,
    version numeric,
    full_id character varying(1024),
    full_name character varying(2048),
    session_id character varying(36),
    login_name character varying(64)
);


ALTER TABLE public.sa_onlinesession OWNER TO postgres;

--
-- Name: sa_opagent; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opagent (
    id character varying(32),
    client_id character varying(65),
    agent_id character varying(65),
    start_date timestamp(6) without time zone,
    end_date timestamp(6) without time zone,
    status numeric,
    proc_agent_kind_id numeric,
    created_by_id character varying(65),
    created_by_name character varying(256),
    created_date timestamp(6) without time zone,
    can_tran_agent numeric,
    version numeric,
    remark character varying(1024)
);


ALTER TABLE public.sa_opagent OWNER TO postgres;

--
-- Name: TABLE sa_opagent; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opagent IS '代理';


--
-- Name: COLUMN sa_opagent.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.id IS 'ID';


--
-- Name: COLUMN sa_opagent.client_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.client_id IS '委托人ID';


--
-- Name: COLUMN sa_opagent.agent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.agent_id IS '代理人ID';


--
-- Name: COLUMN sa_opagent.start_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.start_date IS '开始时间';


--
-- Name: COLUMN sa_opagent.end_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.end_date IS '结束时间';


--
-- Name: COLUMN sa_opagent.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_opagent.proc_agent_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.proc_agent_kind_id IS '代理方式ID';


--
-- Name: COLUMN sa_opagent.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.created_by_id IS '创建人ID';


--
-- Name: COLUMN sa_opagent.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.created_by_name IS '创建人';


--
-- Name: COLUMN sa_opagent.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.created_date IS '创建时间';


--
-- Name: COLUMN sa_opagent.can_tran_agent; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.can_tran_agent IS '是否允许把代理工作转交给其他人';


--
-- Name: COLUMN sa_opagent.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.version IS '版本号';


--
-- Name: COLUMN sa_opagent.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opagent.remark IS '备注';


--
-- Name: sa_opagentproc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opagentproc (
    id character varying(32),
    agent_id character varying(32),
    proc_id character varying(32),
    version numeric
);


ALTER TABLE public.sa_opagentproc OWNER TO postgres;

--
-- Name: sa_opauthorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opauthorize (
    org_id character varying(65),
    role_id character varying(32)
);


ALTER TABLE public.sa_opauthorize OWNER TO postgres;

--
-- Name: TABLE sa_opauthorize; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opauthorize IS '授权';


--
-- Name: COLUMN sa_opauthorize.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opauthorize.org_id IS '组织机构ID';


--
-- Name: COLUMN sa_opauthorize.role_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opauthorize.role_id IS '角色ID';


--
-- Name: sa_opbasefunctiontype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opbasefunctiontype (
    id numeric,
    folder_id numeric,
    code character varying(128),
    name character varying(256),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_opbasefunctiontype OWNER TO postgres;

--
-- Name: TABLE sa_opbasefunctiontype; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opbasefunctiontype IS '基础职能角色
';


--
-- Name: COLUMN sa_opbasefunctiontype.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasefunctiontype.id IS 'BaseFunctionTypeID';


--
-- Name: COLUMN sa_opbasefunctiontype.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasefunctiontype.folder_id IS '文件夹ID';


--
-- Name: COLUMN sa_opbasefunctiontype.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasefunctiontype.code IS '编码';


--
-- Name: COLUMN sa_opbasefunctiontype.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasefunctiontype.name IS '名称';


--
-- Name: COLUMN sa_opbasefunctiontype.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasefunctiontype.sequence IS '排序号';


--
-- Name: COLUMN sa_opbasefunctiontype.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasefunctiontype.version IS '版本号';


--
-- Name: sa_opbasemanagementtype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opbasemanagementtype (
    id character varying(32),
    code character varying(128),
    name character varying(256),
    biz_management_type_id character varying(32),
    sequence numeric,
    version numeric,
    folder_id character varying(32),
    remark character varying(256),
    status numeric
);


ALTER TABLE public.sa_opbasemanagementtype OWNER TO postgres;

--
-- Name: TABLE sa_opbasemanagementtype; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opbasemanagementtype IS '管理权限类别';


--
-- Name: COLUMN sa_opbasemanagementtype.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.id IS 'ID';


--
-- Name: COLUMN sa_opbasemanagementtype.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.code IS '编码';


--
-- Name: COLUMN sa_opbasemanagementtype.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.name IS '名称';


--
-- Name: COLUMN sa_opbasemanagementtype.biz_management_type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.biz_management_type_id IS '业务权限ID';


--
-- Name: COLUMN sa_opbasemanagementtype.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.sequence IS '排序号';


--
-- Name: COLUMN sa_opbasemanagementtype.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.version IS '版本号';


--
-- Name: COLUMN sa_opbasemanagementtype.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.folder_id IS '目录ID';


--
-- Name: COLUMN sa_opbasemanagementtype.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.remark IS '备注';


--
-- Name: COLUMN sa_opbasemanagementtype.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbasemanagementtype.status IS '状态';


--
-- Name: sa_opbizfunction; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opbizfunction (
    id numeric,
    org_id character varying(32),
    code character varying(64),
    name character varying(128),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_opbizfunction OWNER TO postgres;

--
-- Name: TABLE sa_opbizfunction; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opbizfunction IS '业务职能角色
';


--
-- Name: COLUMN sa_opbizfunction.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunction.id IS 'BizFunctionTypeId';


--
-- Name: COLUMN sa_opbizfunction.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunction.org_id IS '组织ID';


--
-- Name: COLUMN sa_opbizfunction.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunction.code IS '编码';


--
-- Name: COLUMN sa_opbizfunction.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunction.name IS '名称';


--
-- Name: COLUMN sa_opbizfunction.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunction.sequence IS '排序号';


--
-- Name: COLUMN sa_opbizfunction.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunction.version IS '版本号';


--
-- Name: sa_opbizfunctionownbase; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opbizfunctionownbase (
    id numeric,
    biz_function_id numeric,
    base_function_type_id numeric,
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_opbizfunctionownbase OWNER TO postgres;

--
-- Name: TABLE sa_opbizfunctionownbase; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opbizfunctionownbase IS '业务职能角色对应基础职能';


--
-- Name: COLUMN sa_opbizfunctionownbase.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunctionownbase.id IS 'BizFunctionOwnBaseID';


--
-- Name: COLUMN sa_opbizfunctionownbase.biz_function_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunctionownbase.biz_function_id IS 'BizFunctionTypeId';


--
-- Name: COLUMN sa_opbizfunctionownbase.base_function_type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizfunctionownbase.base_function_type_id IS 'BaseFunctionTypeID';


--
-- Name: sa_opbizmanagement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opbizmanagement (
    id character varying(32),
    manager_id character varying(65),
    manage_type_id character varying(32),
    subordination_id character varying(65),
    created_by_id character varying(65),
    created_by_name character varying(64),
    created_date timestamp(6) without time zone,
    last_modified_by_id character varying(65),
    last_modified_by_name character varying(64),
    last_modified_date timestamp(6) without time zone,
    version numeric
);


ALTER TABLE public.sa_opbizmanagement OWNER TO postgres;

--
-- Name: TABLE sa_opbizmanagement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opbizmanagement IS '管理权限';


--
-- Name: COLUMN sa_opbizmanagement.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.id IS 'ID';


--
-- Name: COLUMN sa_opbizmanagement.manager_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.manager_id IS '管理者ID';


--
-- Name: COLUMN sa_opbizmanagement.manage_type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.manage_type_id IS '业务权限类型ID';


--
-- Name: COLUMN sa_opbizmanagement.subordination_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.subordination_id IS '下属ID';


--
-- Name: COLUMN sa_opbizmanagement.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.created_by_id IS '创建人ID';


--
-- Name: COLUMN sa_opbizmanagement.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.created_by_name IS '创建人';


--
-- Name: COLUMN sa_opbizmanagement.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.created_date IS '创建时间';


--
-- Name: COLUMN sa_opbizmanagement.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagement.version IS '版本号';


--
-- Name: sa_opbizmanagementtype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opbizmanagementtype (
    id character varying(32),
    code character varying(128),
    name character varying(256),
    manage_org_kind_id character varying(64),
    manage_org_kind_name character varying(512),
    kind_id character varying(6),
    version numeric,
    sequence numeric,
    parent_id character varying(32),
    full_id character varying(512),
    node_kind_id numeric,
    remark character varying(256),
    full_name character varying(2048),
    status integer
);


ALTER TABLE public.sa_opbizmanagementtype OWNER TO postgres;

--
-- Name: TABLE sa_opbizmanagementtype; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opbizmanagementtype IS '业务权限类别';


--
-- Name: COLUMN sa_opbizmanagementtype.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.id IS 'ID';


--
-- Name: COLUMN sa_opbizmanagementtype.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.code IS '编码';


--
-- Name: COLUMN sa_opbizmanagementtype.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.name IS '名称';


--
-- Name: COLUMN sa_opbizmanagementtype.manage_org_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.manage_org_kind_id IS '管理组织类别';


--
-- Name: COLUMN sa_opbizmanagementtype.manage_org_kind_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.manage_org_kind_name IS '管理组织类别名称';


--
-- Name: COLUMN sa_opbizmanagementtype.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.kind_id IS 'sys 系统 def 自定义';


--
-- Name: COLUMN sa_opbizmanagementtype.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.version IS '版本号';


--
-- Name: COLUMN sa_opbizmanagementtype.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.sequence IS '排序号';


--
-- Name: COLUMN sa_opbizmanagementtype.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.parent_id IS '父节点ID';


--
-- Name: COLUMN sa_opbizmanagementtype.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.full_id IS 'ID全路径';


--
-- Name: COLUMN sa_opbizmanagementtype.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.node_kind_id IS '节点类别ID';


--
-- Name: COLUMN sa_opbizmanagementtype.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.remark IS '备注';


--
-- Name: COLUMN sa_opbizmanagementtype.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opbizmanagementtype.full_name IS '名称全路径';


--
-- Name: sa_opdatakind; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatakind (
    id character varying(32),
    code character varying(32),
    name character varying(64),
    data_kind character varying(32),
    data_source character varying(256),
    remark character varying(256),
    sequence numeric,
    status numeric,
    version numeric
);


ALTER TABLE public.sa_opdatakind OWNER TO postgres;

--
-- Name: TABLE sa_opdatakind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatakind IS '数据管理权限维度定义';


--
-- Name: COLUMN sa_opdatakind.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.id IS 'ID';


--
-- Name: COLUMN sa_opdatakind.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.code IS '编码';


--
-- Name: COLUMN sa_opdatakind.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.name IS '名称';


--
-- Name: COLUMN sa_opdatakind.data_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.data_kind IS '类型';


--
-- Name: COLUMN sa_opdatakind.data_source; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.data_source IS '数据源';


--
-- Name: COLUMN sa_opdatakind.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.remark IS '备注';


--
-- Name: COLUMN sa_opdatakind.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.sequence IS 'SEQUENCE';


--
-- Name: COLUMN sa_opdatakind.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.status IS 'status';


--
-- Name: COLUMN sa_opdatakind.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatakind.version IS 'VERSION';


--
-- Name: sa_opdatamanagebusiness; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagebusiness (
    id character varying(32),
    code character varying(32),
    name character varying(128),
    parent_id character varying(32),
    node_kind_id character varying(32),
    full_id character varying(1024),
    full_name character varying(1024),
    sequence numeric,
    status numeric,
    remark character varying(256),
    data_manage_id character varying(32),
    version numeric
);


ALTER TABLE public.sa_opdatamanagebusiness OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagebusiness; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagebusiness IS '数据管理权限业务类型';


--
-- Name: COLUMN sa_opdatamanagebusiness.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.id IS 'id';


--
-- Name: COLUMN sa_opdatamanagebusiness.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.code IS '编码';


--
-- Name: COLUMN sa_opdatamanagebusiness.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.name IS '名称';


--
-- Name: COLUMN sa_opdatamanagebusiness.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.parent_id IS '父ID';


--
-- Name: COLUMN sa_opdatamanagebusiness.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.node_kind_id IS '节点类型(分类，类型)';


--
-- Name: COLUMN sa_opdatamanagebusiness.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.full_id IS 'full_id';


--
-- Name: COLUMN sa_opdatamanagebusiness.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.full_name IS 'full_name';


--
-- Name: COLUMN sa_opdatamanagebusiness.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.sequence IS 'SEQUENCE';


--
-- Name: COLUMN sa_opdatamanagebusiness.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.status IS 'status';


--
-- Name: COLUMN sa_opdatamanagebusiness.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.remark IS 'REMARK';


--
-- Name: COLUMN sa_opdatamanagebusiness.data_manage_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.data_manage_id IS '数据管理权限ID';


--
-- Name: COLUMN sa_opdatamanagebusiness.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness.version IS 'version';


--
-- Name: sa_opdatamanagebusiness_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagebusiness_field (
    id character varying(32),
    datamanagebusiness_id character varying(32),
    is_org_condition numeric,
    data_kind_name character varying(32),
    data_kind_code character varying(128),
    table_column character varying(32),
    column_data_type character varying(64),
    column_symbol character varying(32),
    table_alias character varying(32),
    formula character varying(256),
    data_kind character varying(32),
    manage_type character varying(32),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_opdatamanagebusiness_field OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagebusiness_field; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagebusiness_field IS '数据管理权限业务过滤字段定义';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.id IS 'id';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.datamanagebusiness_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.datamanagebusiness_id IS '数据管理权限业务类型ID';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.is_org_condition; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.is_org_condition IS '特殊组织条件';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.data_kind_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.data_kind_name IS '资源维度名称';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.data_kind_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.data_kind_code IS '资源维度编码';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.table_column; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.table_column IS 'column';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.column_data_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.column_data_type IS 'type';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.column_symbol; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.column_symbol IS 'symbol';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.table_alias; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.table_alias IS 'alias';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.formula; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.formula IS 'Formula';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.data_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.data_kind IS '类型';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.manage_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.manage_type IS '数据管理权限编码';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.sequence IS 'SEQUENCE';


--
-- Name: COLUMN sa_opdatamanagebusiness_field.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagebusiness_field.version IS 'version';


--
-- Name: sa_opdatamanagedetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagedetail (
    id character varying(32),
    data_manage_id character varying(32),
    name character varying(128),
    remark character varying(256),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_opdatamanagedetail OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagedetail; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagedetail IS '数据管理权限取值定义';


--
-- Name: COLUMN sa_opdatamanagedetail.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetail.id IS 'ID';


--
-- Name: COLUMN sa_opdatamanagedetail.data_manage_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetail.data_manage_id IS '数据管理权限类别';


--
-- Name: COLUMN sa_opdatamanagedetail.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetail.name IS '名称';


--
-- Name: COLUMN sa_opdatamanagedetail.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetail.remark IS '备注';


--
-- Name: COLUMN sa_opdatamanagedetail.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetail.sequence IS 'SEQUENCE';


--
-- Name: COLUMN sa_opdatamanagedetail.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetail.version IS 'version';


--
-- Name: sa_opdatamanagedetailresource; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagedetailresource (
    id character varying(32),
    data_managedetal_id character varying(32),
    data_kind_id character varying(32),
    data_kind character varying(32),
    resource_key character varying(128),
    resource_value character varying(128),
    full_id character varying(1024),
    full_name character varying(1024),
    version numeric,
    org_data_kind character varying(32)
);


ALTER TABLE public.sa_opdatamanagedetailresource OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagedetailresource; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagedetailresource IS '数据管理权限包含维度资源';


--
-- Name: COLUMN sa_opdatamanagedetailresource.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.id IS 'ID';


--
-- Name: COLUMN sa_opdatamanagedetailresource.data_managedetal_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.data_managedetal_id IS '数据取值定义ID';


--
-- Name: COLUMN sa_opdatamanagedetailresource.data_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.data_kind_id IS '资源维度ID';


--
-- Name: COLUMN sa_opdatamanagedetailresource.data_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.data_kind IS '资源类型';


--
-- Name: COLUMN sa_opdatamanagedetailresource.resource_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.resource_key IS '资源KEY';


--
-- Name: COLUMN sa_opdatamanagedetailresource.resource_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.resource_value IS '资源值';


--
-- Name: COLUMN sa_opdatamanagedetailresource.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.full_id IS 'full_id';


--
-- Name: COLUMN sa_opdatamanagedetailresource.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.full_name IS 'full_name';


--
-- Name: COLUMN sa_opdatamanagedetailresource.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.version IS 'version';


--
-- Name: COLUMN sa_opdatamanagedetailresource.org_data_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagedetailresource.org_data_kind IS '组织权限类型';


--
-- Name: sa_opdatamanagement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagement (
    id character varying(32),
    data_manage_id character varying(32),
    data_managedetal_id character varying(32),
    manager_id character varying(65),
    created_by_id character varying(65),
    created_by_name character varying(64),
    created_date timestamp(6) without time zone,
    version numeric
);


ALTER TABLE public.sa_opdatamanagement OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagement IS '数据管理权限授权';


--
-- Name: COLUMN sa_opdatamanagement.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.id IS 'id';


--
-- Name: COLUMN sa_opdatamanagement.data_manage_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.data_manage_id IS '数据管理权限类别';


--
-- Name: COLUMN sa_opdatamanagement.data_managedetal_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.data_managedetal_id IS '数据取值定义ID';


--
-- Name: COLUMN sa_opdatamanagement.manager_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.manager_id IS '管理者ID';


--
-- Name: COLUMN sa_opdatamanagement.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.created_by_id IS '创建人ID';


--
-- Name: COLUMN sa_opdatamanagement.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.created_by_name IS '创建人';


--
-- Name: COLUMN sa_opdatamanagement.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.created_date IS '创建时间';


--
-- Name: COLUMN sa_opdatamanagement.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagement.version IS '版本号';


--
-- Name: sa_opdatamanagetype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagetype (
    id character varying(32),
    code character varying(32),
    name character varying(64),
    parent_id character varying(32),
    node_kind_id character varying(32),
    full_id character varying(1024),
    full_name character varying(1024),
    sequence numeric,
    version numeric,
    remark character varying(256),
    status numeric
);


ALTER TABLE public.sa_opdatamanagetype OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagetype; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagetype IS '数据管理权限类型';


--
-- Name: COLUMN sa_opdatamanagetype.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.id IS 'id';


--
-- Name: COLUMN sa_opdatamanagetype.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.code IS '编码';


--
-- Name: COLUMN sa_opdatamanagetype.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.name IS '名称';


--
-- Name: COLUMN sa_opdatamanagetype.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.parent_id IS '父ID';


--
-- Name: COLUMN sa_opdatamanagetype.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.node_kind_id IS '节点类型(分类，数据权限)';


--
-- Name: COLUMN sa_opdatamanagetype.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.full_id IS 'full_id';


--
-- Name: COLUMN sa_opdatamanagetype.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.full_name IS 'full_name';


--
-- Name: COLUMN sa_opdatamanagetype.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.sequence IS 'SEQUENCE';


--
-- Name: COLUMN sa_opdatamanagetype.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.version IS 'version';


--
-- Name: COLUMN sa_opdatamanagetype.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.remark IS 'REMARK';


--
-- Name: COLUMN sa_opdatamanagetype.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetype.status IS 'status';


--
-- Name: sa_opdatamanagetypekind; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opdatamanagetypekind (
    id character varying(32),
    data_manage_id character varying(32),
    data_kind_id character varying(32),
    version numeric
);


ALTER TABLE public.sa_opdatamanagetypekind OWNER TO postgres;

--
-- Name: TABLE sa_opdatamanagetypekind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opdatamanagetypekind IS '数据管理权限包含维度明细';


--
-- Name: COLUMN sa_opdatamanagetypekind.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetypekind.id IS 'ID';


--
-- Name: COLUMN sa_opdatamanagetypekind.data_manage_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetypekind.data_manage_id IS '数据管理权限类别';


--
-- Name: COLUMN sa_opdatamanagetypekind.data_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetypekind.data_kind_id IS '资源维度ID';


--
-- Name: COLUMN sa_opdatamanagetypekind.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opdatamanagetypekind.version IS 'version';


--
-- Name: sa_operationlog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_operationlog (
    id character varying(32) NOT NULL,
    app_id character varying(32),
    app_code character varying(64),
    app_name character varying(256),
    organ_id character varying(32),
    organ_name character varying(128),
    role_kind_id character varying(32),
    role_kind_name character varying(64),
    dept_id character varying(32),
    dept_name character varying(128),
    position_id character varying(32),
    position_name character varying(128),
    person_member_id character varying(65),
    person_member_name character varying(128),
    full_id character varying(1024),
    full_name character varying(2048),
    begin_date timestamp(6) without time zone,
    end_date timestamp(6) without time zone,
    ip character varying(64),
    mac character varying(64),
    class_name character varying(256),
    method_name character varying(256),
    log_type character varying(64),
    operate_name character varying(512),
    status_id numeric,
    status_name character varying(64),
    person_security_level_name character varying(64),
    resource_security_level_name character varying(64),
    machine_security_level_name character varying(64),
    person_security_level_id character varying(32),
    resource_security_level_id character varying(32),
    machine_security_level_id character varying(32),
    version numeric,
    description character varying(2048)
);


ALTER TABLE public.sa_operationlog OWNER TO postgres;

--
-- Name: TABLE sa_operationlog; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_operationlog IS '操作日志';


--
-- Name: sa_operationlogdetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_operationlogdetail (
    id character varying(32),
    operationlog_id character varying(32),
    params text,
    error_message text,
    description text,
    before_image text,
    after_image text,
    version numeric
);


ALTER TABLE public.sa_operationlogdetail OWNER TO postgres;

--
-- Name: TABLE sa_operationlogdetail; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_operationlogdetail IS '日志明细';


--
-- Name: sa_opfunction; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opfunction (
    id character varying(32),
    parent_id character varying(32),
    code character varying(128),
    name character varying(256),
    full_name character varying(2048),
    node_kind_id character varying(6),
    key_code numeric,
    url character varying(256),
    icon character varying(512),
    remark character varying(512),
    depth numeric,
    status numeric,
    sequence numeric,
    version numeric,
    description character varying(256),
    operation_map_id numeric,
    full_id character varying(1024)
);


ALTER TABLE public.sa_opfunction OWNER TO postgres;

--
-- Name: TABLE sa_opfunction; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opfunction IS '功能';


--
-- Name: COLUMN sa_opfunction.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.id IS '功能ID';


--
-- Name: COLUMN sa_opfunction.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.parent_id IS '父节点ID';


--
-- Name: COLUMN sa_opfunction.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.code IS '编码';


--
-- Name: COLUMN sa_opfunction.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.name IS '名称';


--
-- Name: COLUMN sa_opfunction.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.full_name IS '全名称';


--
-- Name: COLUMN sa_opfunction.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.node_kind_id IS 'node 节点 left 叶子 ';


--
-- Name: COLUMN sa_opfunction.key_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.key_code IS '快捷键码';


--
-- Name: COLUMN sa_opfunction.url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.url IS '路径';


--
-- Name: COLUMN sa_opfunction.icon; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.icon IS '图标';


--
-- Name: COLUMN sa_opfunction.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.remark IS '备注';


--
-- Name: COLUMN sa_opfunction.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.depth IS '深度';


--
-- Name: COLUMN sa_opfunction.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_opfunction.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.sequence IS '排序号';


--
-- Name: COLUMN sa_opfunction.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.version IS '版本号';


--
-- Name: COLUMN sa_opfunction.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.description IS '描述';


--
-- Name: COLUMN sa_opfunction.operation_map_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction.operation_map_id IS '管理业务导图ID';


--
-- Name: sa_opfunction_field_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opfunction_field_group (
    function_field_group_id numeric,
    function_id numeric,
    name character varying(64),
    code character varying(64)
);


ALTER TABLE public.sa_opfunction_field_group OWNER TO postgres;

--
-- Name: TABLE sa_opfunction_field_group; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opfunction_field_group IS '功能字段权限设置表';


--
-- Name: COLUMN sa_opfunction_field_group.function_field_group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_field_group.function_field_group_id IS 'function_field_group_id';


--
-- Name: COLUMN sa_opfunction_field_group.function_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_field_group.function_id IS '功能ID';


--
-- Name: COLUMN sa_opfunction_field_group.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_field_group.name IS '名称';


--
-- Name: COLUMN sa_opfunction_field_group.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_field_group.code IS '编码';


--
-- Name: sa_opfunction_permissionfield; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opfunction_permissionfield (
    permission_field_id numeric,
    function_field_group_id numeric,
    field_name character varying(128),
    field_code character varying(128),
    field_type numeric(1,0),
    field_authority character varying(32)
);


ALTER TABLE public.sa_opfunction_permissionfield OWNER TO postgres;

--
-- Name: TABLE sa_opfunction_permissionfield; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opfunction_permissionfield IS '功能字段权限对应表';


--
-- Name: COLUMN sa_opfunction_permissionfield.permission_field_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_permissionfield.permission_field_id IS 'Permission_field_id';


--
-- Name: COLUMN sa_opfunction_permissionfield.function_field_group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_permissionfield.function_field_group_id IS 'function_field_group_id';


--
-- Name: COLUMN sa_opfunction_permissionfield.field_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_permissionfield.field_name IS '字段名称';


--
-- Name: COLUMN sa_opfunction_permissionfield.field_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_permissionfield.field_code IS '字段编码';


--
-- Name: COLUMN sa_opfunction_permissionfield.field_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_permissionfield.field_type IS '字段类型';


--
-- Name: COLUMN sa_opfunction_permissionfield.field_authority; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opfunction_permissionfield.field_authority IS '权限';


--
-- Name: sa_opoperation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opoperation (
    id character varying(32),
    code character varying(64),
    name character varying(128),
    status numeric,
    sequence numeric,
    version numeric,
    is_common numeric,
    resource_kind_id character varying(32)
);


ALTER TABLE public.sa_opoperation OWNER TO postgres;

--
-- Name: sa_oporg; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oporg (
    id character varying(65),
    type_id character varying(32),
    code character varying(360),
    name character varying(360),
    long_name character varying(2048),
    parent_id character varying(65),
    full_id character varying(1024),
    full_code character varying(2048),
    full_name character varying(2048),
    org_kind_id character varying(5),
    depth numeric,
    person_id character varying(32),
    node_kind_id character varying(6),
    description character varying(512),
    status integer,
    sequence character varying(32),,
    version character varying(32),,
    org_code character varying(360),
    dept_code character varying(360),
    position_code character varying(360),
    person_member_code character varying(360),
    is_center character varying(32),,
    center_code character varying(64),
    org_id character varying(32),
    dept_id character varying(32),
    position_id character varying(32),
    person_member_id character varying(65),
    center_id character varying(32),
    org_name character varying(128),
    dept_name character varying(128),
    position_name character varying(128),
    person_member_name character varying(128),
    center_name character varying(128),
    full_sequence character varying(256),
    full_org_kind_id character varying(128),
    is_virtual character varying(32),,
    dept_level character varying(64),
    tenant_id character varying(32)
);


ALTER TABLE public.sa_oporg OWNER TO postgres;

--
-- Name: TABLE sa_oporg; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_oporg IS '组织';


--
-- Name: COLUMN sa_oporg.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.id IS '组织ID';


--
-- Name: COLUMN sa_oporg.type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.type_id IS '组织类型ID';


--
-- Name: COLUMN sa_oporg.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.code IS '编码';


--
-- Name: COLUMN sa_oporg.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.name IS '名称';


--
-- Name: COLUMN sa_oporg.long_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.long_name IS '长名称';


--
-- Name: COLUMN sa_oporg.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.parent_id IS '父节点ID';


--
-- Name: COLUMN sa_oporg.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.full_id IS 'ID全路径';


--
-- Name: COLUMN sa_oporg.full_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.full_code IS '编码全路径';


--
-- Name: COLUMN sa_oporg.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.full_name IS '全名称';


--
-- Name: COLUMN sa_oporg.org_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.org_kind_id IS 'ogn 机构 dpt 部门 pos 岗位 psm 人员成员';


--
-- Name: COLUMN sa_oporg.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.depth IS '深度';


--
-- Name: COLUMN sa_oporg.person_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.person_id IS '人员ID';


--
-- Name: COLUMN sa_oporg.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.node_kind_id IS 'node 节点 leaf 叶子 ';


--
-- Name: COLUMN sa_oporg.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.description IS '描述';


--
-- Name: COLUMN sa_oporg.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_oporg.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.sequence IS '排序号';


--
-- Name: COLUMN sa_oporg.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.version IS '版本号';


--
-- Name: COLUMN sa_oporg.org_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.org_code IS '公司编码';


--
-- Name: COLUMN sa_oporg.dept_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.dept_code IS '部门编码';


--
-- Name: COLUMN sa_oporg.position_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.position_code IS '岗位编码';


--
-- Name: COLUMN sa_oporg.person_member_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.person_member_code IS '人员成员编码';


--
-- Name: COLUMN sa_oporg.is_center; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.is_center IS '是否中心';


--
-- Name: COLUMN sa_oporg.center_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.center_code IS '中心编码';


--
-- Name: COLUMN sa_oporg.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.org_id IS '公司名称';


--
-- Name: COLUMN sa_oporg.dept_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.dept_id IS '部门名称';


--
-- Name: COLUMN sa_oporg.position_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.position_id IS '岗位ID';


--
-- Name: COLUMN sa_oporg.person_member_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.person_member_id IS '人员成员ID';


--
-- Name: COLUMN sa_oporg.center_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.center_id IS '中心ID';


--
-- Name: COLUMN sa_oporg.org_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.org_name IS '公司名称';


--
-- Name: COLUMN sa_oporg.dept_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.dept_name IS '部门名称';


--
-- Name: COLUMN sa_oporg.position_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.position_name IS '岗位名称';


--
-- Name: COLUMN sa_oporg.person_member_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.person_member_name IS '人员成员名称';


--
-- Name: COLUMN sa_oporg.center_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.center_name IS '中心名称';


--
-- Name: COLUMN sa_oporg.full_sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.full_sequence IS '排序号全路径';


--
-- Name: COLUMN sa_oporg.is_virtual; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.is_virtual IS '是否虚拟组织';


--
-- Name: COLUMN sa_oporg.dept_level; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.dept_level IS '部门级别';


--
-- Name: COLUMN sa_oporg.tenant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporg.tenant_id IS '租户ID';


--
-- Name: sa_oporgproperty; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oporgproperty (
    id character varying(32),
    org_id character varying(65),
    property_definition_id character varying(32),
    property_value character varying(64),
    property_display character varying(128),
    version numeric
);


ALTER TABLE public.sa_oporgproperty OWNER TO postgres;

--
-- Name: TABLE sa_oporgproperty; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_oporgproperty IS '组织机构属性';


--
-- Name: COLUMN sa_oporgproperty.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgproperty.id IS 'ID';


--
-- Name: COLUMN sa_oporgproperty.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgproperty.org_id IS '机构ID';


--
-- Name: COLUMN sa_oporgproperty.property_definition_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgproperty.property_definition_id IS '属性定义ID';


--
-- Name: COLUMN sa_oporgproperty.property_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgproperty.property_value IS '属性值';


--
-- Name: COLUMN sa_oporgproperty.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgproperty.version IS '版本号';


--
-- Name: sa_oporgpropertydefinition; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oporgpropertydefinition (
    id character varying(32),
    org_kind_id character varying(6),
    name character varying(64),
    description character varying(128),
    data_source character varying(1024),
    version numeric,
    sequence numeric
);


ALTER TABLE public.sa_oporgpropertydefinition OWNER TO postgres;

--
-- Name: sa_oporgroleauthorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oporgroleauthorize (
    id numeric,
    org_id character varying(65),
    role_kind_id numeric,
    version numeric
);


ALTER TABLE public.sa_oporgroleauthorize OWNER TO postgres;

--
-- Name: COLUMN sa_oporgroleauthorize.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgroleauthorize.id IS 'ID';


--
-- Name: COLUMN sa_oporgroleauthorize.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgroleauthorize.org_id IS '组织ID';


--
-- Name: COLUMN sa_oporgroleauthorize.role_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgroleauthorize.role_kind_id IS '角色类别ID';


--
-- Name: COLUMN sa_oporgroleauthorize.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgroleauthorize.version IS '版本号';


--
-- Name: sa_oporgtemplate; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oporgtemplate (
    id character varying(32),
    type_id character varying(32),
    parent_id character varying(32),
    sequence numeric,
    version numeric,
    status numeric
);


ALTER TABLE public.sa_oporgtemplate OWNER TO postgres;

--
-- Name: TABLE sa_oporgtemplate; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_oporgtemplate IS '组织机构模板';


--
-- Name: COLUMN sa_oporgtemplate.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtemplate.id IS 'ID';


--
-- Name: COLUMN sa_oporgtemplate.type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtemplate.type_id IS '组织类型ID';


--
-- Name: COLUMN sa_oporgtemplate.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtemplate.parent_id IS '父节点ID';


--
-- Name: COLUMN sa_oporgtemplate.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtemplate.sequence IS '排序号';


--
-- Name: COLUMN sa_oporgtemplate.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtemplate.version IS '版本号';


--
-- Name: COLUMN sa_oporgtemplate.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtemplate.status IS '状态';


--
-- Name: sa_oporgtype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oporgtype (
    id character varying(32),
    folder_id character varying(32),
    code character varying(128),
    name character varying(256),
    org_kind_id character varying(5),
    status integer,
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_oporgtype OWNER TO postgres;

--
-- Name: TABLE sa_oporgtype; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_oporgtype IS '组织机构类型';


--
-- Name: COLUMN sa_oporgtype.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.id IS 'ID';


--
-- Name: COLUMN sa_oporgtype.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.folder_id IS '文件夹ID';


--
-- Name: COLUMN sa_oporgtype.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.code IS '编码';


--
-- Name: COLUMN sa_oporgtype.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.name IS '名称';


--
-- Name: COLUMN sa_oporgtype.org_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.org_kind_id IS 'ogn 机构 dpt 部门 pos 岗位';


--
-- Name: COLUMN sa_oporgtype.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_oporgtype.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.sequence IS '排序号';


--
-- Name: COLUMN sa_oporgtype.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oporgtype.version IS '版本号';


--
-- Name: sa_oppermission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oppermission (
    id character varying(32),
    parent_id character varying(32),
    code character varying(128),
    name character varying(256),
    full_id character varying(1024),
    full_name character varying(2048),
    resource_kind_id character varying(32),
    resource_id character varying(32),
    operation_id character varying(32),
    status numeric,
    sequence numeric,
    version numeric,
    node_kind_id character varying(32),
    remark character varying(256)
);


ALTER TABLE public.sa_oppermission OWNER TO postgres;

--
-- Name: COLUMN sa_oppermission.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.id IS 'ID';


--
-- Name: COLUMN sa_oppermission.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.parent_id IS '父ID';


--
-- Name: COLUMN sa_oppermission.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.code IS '编码';


--
-- Name: COLUMN sa_oppermission.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.name IS '名称';


--
-- Name: COLUMN sa_oppermission.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.full_id IS 'ID全路径';


--
-- Name: COLUMN sa_oppermission.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.full_name IS '名称全路径';


--
-- Name: COLUMN sa_oppermission.resource_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.resource_kind_id IS '资源类型ID';


--
-- Name: COLUMN sa_oppermission.resource_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.resource_id IS '资源ID';


--
-- Name: COLUMN sa_oppermission.operation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.operation_id IS '操作ID';


--
-- Name: COLUMN sa_oppermission.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.status IS '状态';


--
-- Name: COLUMN sa_oppermission.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.sequence IS '排序号';


--
-- Name: COLUMN sa_oppermission.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.version IS '版本号';


--
-- Name: COLUMN sa_oppermission.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oppermission.remark IS '备注';


--
-- Name: sa_opperson; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opperson (
    id character varying(32),
    code character varying(128),
    name character varying(256),
    login_name character varying(64),
    password character varying(128),
    password_time_limit numeric,
    password_modify_time timestamp(6) without time zone,
    main_org_id character varying(32),
    sequence numeric,
    status numeric,
    description character varying(512),
    sex character varying(12),
    birthday timestamp(6) without time zone,
    join_date timestamp(6) without time zone,
    home_place character varying(128),
    degree character varying(64),
    graduate_school character varying(256),
    speciality character varying(256),
    school_length character varying(64),
    title character varying(128),
    marriage character varying(12),
    certificate_no character varying(128),
    certificate_kind_id character varying(64),
    family_address character varying(512),
    zip character varying(32),
    msn character varying(64),
    qq character varying(64),
    email character varying(128),
    mobile_phone character varying(128),
    family_phone character varying(64),
    office_phone character varying(128),
    version numeric,
    photo_file_id numeric,
    country character varying(128),
    province character varying(128),
    city character varying(128),
    english_name character varying(256),
    pay_password character varying(128),
    is_operator numeric,
    is_hidden numeric,
    weixin character varying(64),
    num numeric,
    security_grade_id character varying(32),
    person_security_grade_id character varying(32),
    ca_status numeric,
    ca_no character varying(64),
    tenant_id character varying(32),
    person_kind character varying(64)
);


ALTER TABLE public.sa_opperson OWNER TO postgres;

--
-- Name: TABLE sa_opperson; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opperson IS '人员';


--
-- Name: COLUMN sa_opperson.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.code IS '编码';


--
-- Name: COLUMN sa_opperson.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.name IS '名称';


--
-- Name: COLUMN sa_opperson.login_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.login_name IS '登录名';


--
-- Name: COLUMN sa_opperson.password; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.password IS '密码';


--
-- Name: COLUMN sa_opperson.password_time_limit; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.password_time_limit IS '密码时限';


--
-- Name: COLUMN sa_opperson.password_modify_time; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.password_modify_time IS '密码修改时间';


--
-- Name: COLUMN sa_opperson.main_org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.main_org_id IS '所属部门';


--
-- Name: COLUMN sa_opperson.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.sequence IS '排序号';


--
-- Name: COLUMN sa_opperson.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_opperson.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.description IS '描述';


--
-- Name: COLUMN sa_opperson.sex; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.sex IS '性别';


--
-- Name: COLUMN sa_opperson.birthday; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.birthday IS '出生日期';


--
-- Name: COLUMN sa_opperson.join_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.join_date IS '参加工作日期';


--
-- Name: COLUMN sa_opperson.home_place; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.home_place IS '出生地';


--
-- Name: COLUMN sa_opperson.degree; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.degree IS '学历';


--
-- Name: COLUMN sa_opperson.graduate_school; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.graduate_school IS '毕业院校';


--
-- Name: COLUMN sa_opperson.speciality; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.speciality IS '专业';


--
-- Name: COLUMN sa_opperson.school_length; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.school_length IS '学年制';


--
-- Name: COLUMN sa_opperson.title; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.title IS '职称';


--
-- Name: COLUMN sa_opperson.marriage; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.marriage IS '婚姻状况';


--
-- Name: COLUMN sa_opperson.certificate_no; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.certificate_no IS '证件号码';


--
-- Name: COLUMN sa_opperson.certificate_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.certificate_kind_id IS '证件类型';


--
-- Name: COLUMN sa_opperson.family_address; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.family_address IS '家庭住址';


--
-- Name: COLUMN sa_opperson.zip; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.zip IS '邮编';


--
-- Name: COLUMN sa_opperson.msn; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.msn IS 'Msn';


--
-- Name: COLUMN sa_opperson.qq; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.qq IS 'QQ';


--
-- Name: COLUMN sa_opperson.email; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.email IS '电子邮件';


--
-- Name: COLUMN sa_opperson.mobile_phone; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.mobile_phone IS '移动电话';


--
-- Name: COLUMN sa_opperson.family_phone; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.family_phone IS '家庭电话';


--
-- Name: COLUMN sa_opperson.office_phone; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.office_phone IS '办公电话';


--
-- Name: COLUMN sa_opperson.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.version IS '版本号';


--
-- Name: COLUMN sa_opperson.photo_file_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.photo_file_id IS '照片';


--
-- Name: COLUMN sa_opperson.country; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.country IS '国家';


--
-- Name: COLUMN sa_opperson.province; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.province IS '省';


--
-- Name: COLUMN sa_opperson.city; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.city IS '市';


--
-- Name: COLUMN sa_opperson.english_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.english_name IS '英文名称';


--
-- Name: COLUMN sa_opperson.pay_password; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.pay_password IS '薪资密码';


--
-- Name: COLUMN sa_opperson.is_operator; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.is_operator IS '是否操作员';


--
-- Name: COLUMN sa_opperson.is_hidden; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.is_hidden IS '是否隐藏';


--
-- Name: COLUMN sa_opperson.weixin; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.weixin IS '微信';


--
-- Name: COLUMN sa_opperson.security_grade_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.security_grade_id IS '密级';


--
-- Name: COLUMN sa_opperson.person_security_grade_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.person_security_grade_id IS '人员涉密登记';


--
-- Name: COLUMN sa_opperson.tenant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.tenant_id IS '租户ID';


--
-- Name: COLUMN sa_opperson.person_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opperson.person_kind IS '人员类别';


--
-- Name: sa_opremind; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opremind (
    id character varying(32),
    role_id character varying(32),
    remind_id character varying(32)
);


ALTER TABLE public.sa_opremind OWNER TO postgres;

--
-- Name: TABLE sa_opremind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opremind IS '角色提醒授权';


--
-- Name: sa_oprole; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oprole (
    id character varying(32),
    role_kind_id character varying(32),
    code character varying(128),
    name character varying(256),
    description character varying(512),
    status numeric,
    sequence numeric,
    version numeric,
    tenant_id character varying(32),
    parent_id character varying(32),
    full_id character varying(1024),
    full_name character varying(2048),
    node_kind_id numeric,
    folder_id character varying(32),
    role_person_kind character varying(64)
);


ALTER TABLE public.sa_oprole OWNER TO postgres;

--
-- Name: TABLE sa_oprole; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_oprole IS '角色';


--
-- Name: COLUMN sa_oprole.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.id IS 'ID';


--
-- Name: COLUMN sa_oprole.role_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.role_kind_id IS 'fn 功能 data 数据';


--
-- Name: COLUMN sa_oprole.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.code IS '编码';


--
-- Name: COLUMN sa_oprole.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.name IS '名称';


--
-- Name: COLUMN sa_oprole.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.description IS '描述';


--
-- Name: COLUMN sa_oprole.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.status IS '1 启用 0 禁用';


--
-- Name: COLUMN sa_oprole.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.sequence IS '排序号';


--
-- Name: COLUMN sa_oprole.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.version IS '版本号';


--
-- Name: COLUMN sa_oprole.tenant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.tenant_id IS '租户ID';


--
-- Name: COLUMN sa_oprole.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.parent_id IS '父ID';


--
-- Name: COLUMN sa_oprole.full_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.full_id IS 'ID全路径';


--
-- Name: COLUMN sa_oprole.full_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.full_name IS '名称全路径';


--
-- Name: COLUMN sa_oprole.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.node_kind_id IS '节点类型';


--
-- Name: COLUMN sa_oprole.role_person_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprole.role_person_kind IS '人员类别';


--
-- Name: sa_oprolepermission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_oprolepermission (
    id character varying(32),
    role_id character varying(32),
    permission_id character varying(32),
    created_by_id character varying(65),
    created_date timestamp(6) without time zone,
    created_by_name character varying(64),
    version numeric
);


ALTER TABLE public.sa_oprolepermission OWNER TO postgres;

--
-- Name: COLUMN sa_oprolepermission.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprolepermission.created_by_id IS '创建人ID';


--
-- Name: COLUMN sa_oprolepermission.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprolepermission.created_date IS '创建时间';


--
-- Name: COLUMN sa_oprolepermission.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprolepermission.created_by_name IS '创建人';


--
-- Name: COLUMN sa_oprolepermission.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_oprolepermission.version IS '版本号';


--
-- Name: sa_optenant; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_optenant (
    id character varying(32),
    code character varying(64),
    name character varying(256),
    folder_id character varying(32),
    industry_org_id character varying(32),
    description character varying(1024),
    contacts character varying(256),
    contact_number character varying(512),
    status numeric,
    org_id character varying(32),
    root_full_id character varying(1024),
    version numeric,
    is_industry numeric
);


ALTER TABLE public.sa_optenant OWNER TO postgres;

--
-- Name: sa_opuielement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opuielement (
    id character varying(32),
    folder_id character varying(32),
    kind_id character varying(32),
    code character varying(128),
    name character varying(128),
    default_operation_id character varying(32),
    status numeric,
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_opuielement OWNER TO postgres;

--
-- Name: TABLE sa_opuielement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opuielement IS '界面元素';


--
-- Name: COLUMN sa_opuielement.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.folder_id IS '文件夹ID';


--
-- Name: COLUMN sa_opuielement.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.code IS '编码';


--
-- Name: COLUMN sa_opuielement.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.name IS '名称';


--
-- Name: COLUMN sa_opuielement.default_operation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.default_operation_id IS '默认操作';


--
-- Name: COLUMN sa_opuielement.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.status IS '状态';


--
-- Name: COLUMN sa_opuielement.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.sequence IS '序列号';


--
-- Name: COLUMN sa_opuielement.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielement.version IS '版本号';


--
-- Name: sa_opuielementpermission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_opuielementpermission (
    id character varying(32),
    permission_id character varying(32),
    resource_id character varying(32),
    code character varying(128),
    name character varying(128),
    kind_id character varying(32),
    operation_id character varying(32),
    version numeric,
    sequence numeric
);


ALTER TABLE public.sa_opuielementpermission OWNER TO postgres;

--
-- Name: TABLE sa_opuielementpermission; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_opuielementpermission IS '界面元素权限';


--
-- Name: COLUMN sa_opuielementpermission.permission_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.permission_id IS '权限ID';


--
-- Name: COLUMN sa_opuielementpermission.resource_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.resource_id IS '资源ID';


--
-- Name: COLUMN sa_opuielementpermission.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.code IS '编码';


--
-- Name: COLUMN sa_opuielementpermission.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.name IS '名称';


--
-- Name: COLUMN sa_opuielementpermission.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.kind_id IS '类别';


--
-- Name: COLUMN sa_opuielementpermission.operation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.operation_id IS '操作ID';


--
-- Name: COLUMN sa_opuielementpermission.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.version IS '版本号';


--
-- Name: COLUMN sa_opuielementpermission.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_opuielementpermission.sequence IS '排序号';


--
-- Name: sa_orgfun; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_orgfun (
    id character varying(32),
    code character varying(128),
    name character varying(128),
    parent_id character varying(32),
    is_last numeric,
    remark character varying(512),
    sequence numeric,
    status numeric,
    version numeric
);


ALTER TABLE public.sa_orgfun OWNER TO postgres;

--
-- Name: TABLE sa_orgfun; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_orgfun IS '系统可用组织机构函数';


--
-- Name: COLUMN sa_orgfun.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.id IS 'id';


--
-- Name: COLUMN sa_orgfun.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.code IS 'code';


--
-- Name: COLUMN sa_orgfun.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.name IS 'name';


--
-- Name: COLUMN sa_orgfun.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.parent_id IS 'parent_id';


--
-- Name: COLUMN sa_orgfun.is_last; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.is_last IS 'is_last';


--
-- Name: COLUMN sa_orgfun.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.remark IS 'remark';


--
-- Name: COLUMN sa_orgfun.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.sequence IS 'sequence';


--
-- Name: COLUMN sa_orgfun.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.status IS 'status';


--
-- Name: COLUMN sa_orgfun.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_orgfun.version IS 'version';


--
-- Name: sa_parameter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_parameter (
    id character varying(32),
    code character varying(128),
    name character varying(128),
    value character varying(2048),
    remark character varying(1024),
    version numeric,
    folder_id character varying(32),
    status numeric,
    sequence numeric
);


ALTER TABLE public.sa_parameter OWNER TO postgres;

--
-- Name: TABLE sa_parameter; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_parameter IS '系统参数';


--
-- Name: COLUMN sa_parameter.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.id IS 'id';


--
-- Name: COLUMN sa_parameter.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.code IS '参数编码';


--
-- Name: COLUMN sa_parameter.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.name IS '参数名称';


--
-- Name: COLUMN sa_parameter.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.value IS '参数值';


--
-- Name: COLUMN sa_parameter.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.remark IS '备注';


--
-- Name: COLUMN sa_parameter.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.version IS '版本号';


--
-- Name: COLUMN sa_parameter.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.folder_id IS '父编码';


--
-- Name: COLUMN sa_parameter.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_parameter.status IS '状态';


--
-- Name: sa_pdscreen; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_pdscreen (
    id character varying(32),
    person_id character varying(32),
    version numeric
);


ALTER TABLE public.sa_pdscreen OWNER TO postgres;

--
-- Name: TABLE sa_pdscreen; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_pdscreen IS '用户桌面分屏设置';


--
-- Name: sa_pdscreenfunction; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_pdscreenfunction (
    id character varying(32),
    screen_id character varying(32),
    function_id character varying(32),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_pdscreenfunction OWNER TO postgres;

--
-- Name: TABLE sa_pdscreenfunction; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_pdscreenfunction IS '用户分屏应用记录表';


--
-- Name: COLUMN sa_pdscreenfunction.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_pdscreenfunction.id IS 'id';


--
-- Name: COLUMN sa_pdscreenfunction.screen_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_pdscreenfunction.screen_id IS '分屏ID';


--
-- Name: COLUMN sa_pdscreenfunction.function_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_pdscreenfunction.function_id IS '功能ID';


--
-- Name: COLUMN sa_pdscreenfunction.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_pdscreenfunction.sequence IS '排序号';


--
-- Name: sa_personaccountmanagement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_personaccountmanagement (
    id character varying(32),
    login_name character varying(64),
    status numeric,
    locked_date timestamp(6) without time zone,
    last_login_date timestamp(6) without time zone,
    last_modified_password_date timestamp(6) without time zone,
    version numeric,
    full_id character varying(1024)
);


ALTER TABLE public.sa_personaccountmanagement OWNER TO postgres;

--
-- Name: sa_personcalendar; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_personcalendar (
    id character varying(32),
    version numeric,
    subject character varying(256),
    start_time timestamp(6) without time zone,
    end_time timestamp(6) without time zone,
    is_alldayevent numeric,
    person_id character varying(32),
    created_by_id character varying(65),
    created_by_name character varying(128),
    created_date timestamp(6) without time zone,
    last_modified_by_id character varying(65),
    last_modified_by_name character varying(128),
    last_modified_date timestamp(6) without time zone,
    business_id character varying(32),
    link_bill_url character varying(256)
);


ALTER TABLE public.sa_personcalendar OWNER TO postgres;

--
-- Name: TABLE sa_personcalendar; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_personcalendar IS '日程安排';


--
-- Name: COLUMN sa_personcalendar.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.id IS '主键';


--
-- Name: COLUMN sa_personcalendar.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.version IS '版本号';


--
-- Name: COLUMN sa_personcalendar.subject; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.subject IS '标题';


--
-- Name: COLUMN sa_personcalendar.start_time; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.start_time IS '开始时间';


--
-- Name: COLUMN sa_personcalendar.end_time; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.end_time IS '结束时间';


--
-- Name: COLUMN sa_personcalendar.is_alldayevent; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.is_alldayevent IS '是否全天';


--
-- Name: COLUMN sa_personcalendar.person_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.person_id IS '用户ID';


--
-- Name: COLUMN sa_personcalendar.business_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.business_id IS '业务单据ID';


--
-- Name: COLUMN sa_personcalendar.link_bill_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personcalendar.link_bill_url IS '业务单据链接';


--
-- Name: sa_personloginlimit; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_personloginlimit (
    id character varying(32),
    machine_id character varying(32),
    person_id character varying(32),
    login_name character varying(64),
    sequence numeric,
    version numeric,
    full_id character varying(1024)
);


ALTER TABLE public.sa_personloginlimit OWNER TO postgres;

--
-- Name: sa_personqueryscheme; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_personqueryscheme (
    id character varying(32),
    person_id character varying(32),
    kind_id character varying(32),
    name character varying(128),
    param character varying(4000),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_personqueryscheme OWNER TO postgres;

--
-- Name: TABLE sa_personqueryscheme; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_personqueryscheme IS '用户查询方案';


--
-- Name: COLUMN sa_personqueryscheme.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.id IS 'ID';


--
-- Name: COLUMN sa_personqueryscheme.person_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.person_id IS '人员ID';


--
-- Name: COLUMN sa_personqueryscheme.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.kind_id IS '类别';


--
-- Name: COLUMN sa_personqueryscheme.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.name IS '名称';


--
-- Name: COLUMN sa_personqueryscheme.param; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.param IS '参数';


--
-- Name: COLUMN sa_personqueryscheme.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.sequence IS '序号';


--
-- Name: COLUMN sa_personqueryscheme.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_personqueryscheme.version IS '版本号';


--
-- Name: sa_scheduling_job; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_scheduling_job (
    job_id character varying(32),
    job_name character varying(64),
    job_group character varying(128),
    job_status character varying(64),
    cron_expression character varying(64),
    job_class_name character varying(512),
    job_desc character varying(512),
    job_param character varying(512),
    bean_name character varying(512),
    last_execute_time timestamp(6) without time zone
);


ALTER TABLE public.sa_scheduling_job OWNER TO postgres;

--
-- Name: sa_scheduling_job_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_scheduling_job_log (
    id character varying(32),
    job_id character varying(32),
    execute_time timestamp(6) without time zone,
    message character varying(2048),
    status numeric
);


ALTER TABLE public.sa_scheduling_job_log OWNER TO postgres;

--
-- Name: sa_securitypolicy; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_securitypolicy (
    id character varying(32),
    enable_internet_login numeric,
    intranet_segment character varying(128),
    password_validity_interval numeric,
    password_expire_give_days numeric,
    password_minimum_length numeric,
    lock_user_password_error_time numeric,
    enable_complexity numeric,
    auto_unlock_time numeric,
    security_grade character varying(64),
    number_count numeric,
    uppercase_count numeric,
    lowercase_count numeric,
    special_character_count numeric,
    init_password character varying(64),
    status numeric,
    version numeric
);


ALTER TABLE public.sa_securitypolicy OWNER TO postgres;

--
-- Name: sa_synbasedataversion; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_synbasedataversion (
    code character varying(64),
    max_version numeric,
    remark character varying(512),
    version numeric,
    max_timestamp timestamp(6) without time zone,
    id character varying(32),
    name character varying(128),
    status numeric
);


ALTER TABLE public.sa_synbasedataversion OWNER TO postgres;

--
-- Name: TABLE sa_synbasedataversion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_synbasedataversion IS '系统新信息同步';


--
-- Name: COLUMN sa_synbasedataversion.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.code IS '类别编码';


--
-- Name: COLUMN sa_synbasedataversion.max_version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.max_version IS '最大版本号';


--
-- Name: COLUMN sa_synbasedataversion.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.remark IS '备注';


--
-- Name: COLUMN sa_synbasedataversion.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.version IS '版本号';


--
-- Name: COLUMN sa_synbasedataversion.max_timestamp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.max_timestamp IS '修改时间';


--
-- Name: COLUMN sa_synbasedataversion.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.id IS '主键ID';


--
-- Name: COLUMN sa_synbasedataversion.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.name IS '类别名称';


--
-- Name: COLUMN sa_synbasedataversion.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_synbasedataversion.status IS '状态';


--
-- Name: sa_tmauthorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_tmauthorize (
    id character varying(32),
    subordination_id character varying(65),
    subordination_full_id character varying(255),
    system_id character varying(32),
    role_kind_id character varying(32),
    manager_id character varying(65),
    created_by_id character varying(65),
    created_by_name character varying(64),
    created_date timestamp(6) without time zone,
    version character varying(64)
);


ALTER TABLE public.sa_tmauthorize OWNER TO postgres;

--
-- Name: sa_usergroup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_usergroup (
    id character varying(32),
    code character varying(64),
    name character varying(128),
    folder_id character varying(32),
    kind_id character varying(8),
    status numeric,
    function_name character varying(512),
    created_by_id character varying(65),
    created_by_name character varying(128),
    created_date timestamp(6) without time zone,
    remark character varying(512),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_usergroup OWNER TO postgres;

--
-- Name: TABLE sa_usergroup; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.sa_usergroup IS '用户分组';


--
-- Name: COLUMN sa_usergroup.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.id IS 'ID';


--
-- Name: COLUMN sa_usergroup.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.code IS '分组编码';


--
-- Name: COLUMN sa_usergroup.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.name IS '分组名称';


--
-- Name: COLUMN sa_usergroup.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.kind_id IS '分组类别(系统,个人)';


--
-- Name: COLUMN sa_usergroup.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.status IS '状态';


--
-- Name: COLUMN sa_usergroup.function_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.function_name IS '函数名';


--
-- Name: COLUMN sa_usergroup.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.created_by_id IS 'CREATEd_BY_ID';


--
-- Name: COLUMN sa_usergroup.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.created_by_name IS 'CREATEd_BY_name';


--
-- Name: COLUMN sa_usergroup.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.created_date IS 'created_date';


--
-- Name: COLUMN sa_usergroup.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.remark IS '备注';


--
-- Name: COLUMN sa_usergroup.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.sequence IS '序号';


--
-- Name: COLUMN sa_usergroup.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sa_usergroup.version IS '版本号';


--
-- Name: sa_usergroupdetail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sa_usergroupdetail (
    id character varying(32),
    group_id character varying(32),
    org_id character varying(65),
    full_id character varying(1024),
    sequence numeric,
    version numeric
);


ALTER TABLE public.sa_usergroupdetail OWNER TO postgres;

--
-- Name: test; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test (
    id character varying(64),
    name character varying(64)
);


ALTER TABLE public.test OWNER TO postgres;

--
-- Name: test_staff; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_staff (
    user_name character varying(255),
    password character varying(255),
    name character varying(255),
    age character varying(255),
    sex character varying(255),
    birthday character varying(255),
    id character varying(255) NOT NULL,
    version numeric
);


ALTER TABLE public.test_staff OWNER TO postgres;

--
-- Name: wf_procdef; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_procdef (
    id character varying(32) NOT NULL,
    code character varying(256),
    name character varying(512),
    parent_id character varying(32),
    status numeric,
    description character varying(1200),
    sequence numeric,
    version numeric,
    approval_bridge_proc_id character varying(64),
    node_kind_id character varying(32),
    need_timing numeric,
    full_name character varying(2048),
    full_id character varying(1024),
    show_query_handlers numeric,
    proc_id character varying(128),
    proc_name character varying(256),
    limit_time numeric,
    assistant_must_approve numeric,
    merge_handler_kind numeric
);


ALTER TABLE public.wf_procdef OWNER TO postgres;

--
-- Name: COLUMN wf_procdef.limit_time; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procdef.limit_time IS '限制时间';


--
-- Name: COLUMN wf_procdef.merge_handler_kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procdef.merge_handler_kind IS '处理人合并类型 0 不合并  1 相邻合并  2 向后合并';


--
-- Name: v_act_hi_procinst; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_act_hi_procinst AS
 SELECT pe.id_ AS proc_inst_id_,
    pe.business_key_,
    pe.proc_def_id_,
    pe.key_ AS process_definition_key_,
    pdf.full_id AS proc_full_id,
    pdf.full_name AS proc_full_name,
    pdf.name AS proc_name,
        CASE
            WHEN (public.instr(pdf.full_name, '/'::character varying, 2) < 2) THEN substr((pdf.full_name)::text, 2, 0)
            WHEN (public.instr(pdf.full_name, '/'::character varying, 2) >= 2) THEN substr((pdf.full_name)::text, 2, (public.instr(pdf.full_name, '/'::character varying, 2) - 2))
            ELSE NULL::text
        END AS proc_sys_name,
    pe.start_time_,
    pe.end_time_,
    pe.applicant_person_member_id_,
    pe.applicant_person_member_name_,
    pe.applicant_dept_name_,
    pe.applicant_org_name_,
    pe.status_id_ AS proc_status_id_
   FROM (public.wf_procdef pdf
     LEFT JOIN (public.act_hi_procinst_extension pe
     JOIN public.act_re_procdef pd ON (((pe.proc_def_id_)::text = (pd.id_)::text))) ON (((pd.key_)::text = (pdf.proc_id)::text)))
  WHERE ((pdf.node_kind_id)::text = 'proc'::text);


ALTER TABLE public.v_act_hi_procinst OWNER TO postgres;

--
-- Name: v_sa_oporg_exclude_pos; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_sa_oporg_exclude_pos AS
 SELECT sa_oporg.id,
    sa_oporg.type_id,
    sa_oporg.code,
    sa_oporg.name,
    sa_oporg.long_name,
        CASE sa_oporg.org_kind_id
            WHEN 'psm'::text THEN sa_oporg.dept_id
            ELSE sa_oporg.parent_id
        END AS parent_id,
    sa_oporg.full_id,
    sa_oporg.full_code,
    sa_oporg.full_name,
    sa_oporg.org_kind_id,
    sa_oporg.depth,
    sa_oporg.person_id,
    sa_oporg.node_kind_id,
    sa_oporg.description,
    sa_oporg.status,
    sa_oporg.sequence,
    sa_oporg.version,
    sa_oporg.org_code,
    sa_oporg.dept_code,
    sa_oporg.position_code,
    sa_oporg.person_member_code,
    sa_oporg.is_center,
    sa_oporg.center_code,
    sa_oporg.org_id,
    sa_oporg.dept_id,
    sa_oporg.position_id,
    sa_oporg.person_member_id,
    sa_oporg.center_id,
    sa_oporg.org_name,
    sa_oporg.dept_name,
    sa_oporg.position_name,
    sa_oporg.person_member_name,
    sa_oporg.center_name,
    sa_oporg.full_sequence,
    sa_oporg.full_org_kind_id,
    sa_oporg.is_virtual
   FROM public.sa_oporg
  WHERE ((sa_oporg.org_kind_id)::text <> 'pos'::text);


ALTER TABLE public.v_sa_oporg_exclude_pos OWNER TO postgres;

--
-- Name: version_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.version_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.version_seq OWNER TO postgres;

--
-- Name: wf_approvalelement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalelement (
    id character varying(32) NOT NULL,
    code character varying(128),
    name character varying(256),
    kind_id numeric,
    sequence numeric,
    version numeric,
    data_source_config character varying(1024),
    status numeric
);


ALTER TABLE public.wf_approvalelement OWNER TO postgres;

--
-- Name: TABLE wf_approvalelement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalelement IS '审批要素';


--
-- Name: COLUMN wf_approvalelement.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalelement.id IS 'ID';


--
-- Name: COLUMN wf_approvalelement.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalelement.code IS '编码';


--
-- Name: COLUMN wf_approvalelement.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalelement.name IS '名称';


--
-- Name: COLUMN wf_approvalelement.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalelement.kind_id IS '1系统 2业务';


--
-- Name: COLUMN wf_approvalelement.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalelement.sequence IS '排序号';


--
-- Name: COLUMN wf_approvalelement.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalelement.version IS '版本号';


--
-- Name: wf_approvalhandlerkind; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalhandlerkind (
    id character varying(32) NOT NULL,
    code character varying(128),
    name character varying(256),
    data_source_id numeric,
    data_source_config character varying(1024),
    sequence numeric,
    version numeric,
    status numeric
);


ALTER TABLE public.wf_approvalhandlerkind OWNER TO postgres;

--
-- Name: TABLE wf_approvalhandlerkind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalhandlerkind IS '审批人类别';


--
-- Name: COLUMN wf_approvalhandlerkind.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.id IS 'ID';


--
-- Name: COLUMN wf_approvalhandlerkind.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.code IS '编码';


--
-- Name: COLUMN wf_approvalhandlerkind.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.name IS '名称';


--
-- Name: COLUMN wf_approvalhandlerkind.data_source_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.data_source_id IS '数据源';


--
-- Name: COLUMN wf_approvalhandlerkind.data_source_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.data_source_config IS '数据源配置';


--
-- Name: COLUMN wf_approvalhandlerkind.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.sequence IS '排序号';


--
-- Name: COLUMN wf_approvalhandlerkind.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalhandlerkind.version IS '版本号';


--
-- Name: wf_approvalrule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrule (
    id character varying(32) NOT NULL,
    parent_id character varying(32),
    proc_id character varying(64),
    proc_name character varying(256),
    proc_unit_id character varying(64),
    proc_unit_name character varying(256),
    node_kind_id numeric,
    name character varying(256),
    priority numeric,
    status numeric,
    remark character varying(512),
    created_date timestamp(6) without time zone,
    created_by_name character varying(64),
    created_by_id character varying(65),
    last_modified_date timestamp(6) without time zone,
    last_modified_by_name character varying(100),
    last_modified_by_id character varying(65),
    version numeric,
    org_id character varying(32),
    full_id character varying(512),
    full_name character varying(2048),
    scope_kind_id numeric,
    code character varying(64),
    sequence numeric
);


ALTER TABLE public.wf_approvalrule OWNER TO postgres;

--
-- Name: TABLE wf_approvalrule; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalrule IS '审批规则';


--
-- Name: COLUMN wf_approvalrule.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.id IS '规则ID';


--
-- Name: COLUMN wf_approvalrule.parent_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.parent_id IS '父节点ID';


--
-- Name: COLUMN wf_approvalrule.proc_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.proc_id IS '流程ID';


--
-- Name: COLUMN wf_approvalrule.proc_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.proc_name IS '流程名称';


--
-- Name: COLUMN wf_approvalrule.proc_unit_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.proc_unit_id IS '环节ID';


--
-- Name: COLUMN wf_approvalrule.proc_unit_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.proc_unit_name IS '环节名称';


--
-- Name: COLUMN wf_approvalrule.node_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.node_kind_id IS '节点类别 1 分类 2 规则 ';


--
-- Name: COLUMN wf_approvalrule.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.name IS '名称';


--
-- Name: COLUMN wf_approvalrule.priority; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.priority IS '优先级';


--
-- Name: COLUMN wf_approvalrule.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.status IS '状态 1 启用 0 禁用';


--
-- Name: COLUMN wf_approvalrule.remark; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.remark IS '备注';


--
-- Name: COLUMN wf_approvalrule.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.created_date IS '创建时间';


--
-- Name: COLUMN wf_approvalrule.created_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.created_by_name IS '创建人姓名';


--
-- Name: COLUMN wf_approvalrule.created_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.created_by_id IS '创建人ID';


--
-- Name: COLUMN wf_approvalrule.last_modified_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.last_modified_date IS '最后修改时间';


--
-- Name: COLUMN wf_approvalrule.last_modified_by_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.last_modified_by_name IS '最后修改人姓名';


--
-- Name: COLUMN wf_approvalrule.last_modified_by_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.last_modified_by_id IS '最后修改人ID';


--
-- Name: COLUMN wf_approvalrule.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.version IS '版本号';


--
-- Name: COLUMN wf_approvalrule.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.org_id IS '组织ID（公司ID：organ_id，以后可扩展为组织ID）';


--
-- Name: COLUMN wf_approvalrule.scope_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrule.scope_kind_id IS '适用范围';


--
-- Name: wf_approvalruleelement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalruleelement (
    approval_rule_id character varying(32),
    id character varying(32) NOT NULL,
    element_code character varying(128),
    foperator character varying(20),
    fvalue_id character varying(1024),
    fvalue character varying(1000),
    sequence numeric,
    version numeric,
    element_id character varying(32)
);


ALTER TABLE public.wf_approvalruleelement OWNER TO postgres;

--
-- Name: TABLE wf_approvalruleelement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalruleelement IS '审批规则要素';


--
-- Name: COLUMN wf_approvalruleelement.approval_rule_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.approval_rule_id IS 'ApprovalRule';


--
-- Name: COLUMN wf_approvalruleelement.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.id IS 'ID';


--
-- Name: COLUMN wf_approvalruleelement.element_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.element_code IS '审批要素编码';


--
-- Name: COLUMN wf_approvalruleelement.foperator; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.foperator IS '操作符';


--
-- Name: COLUMN wf_approvalruleelement.fvalue_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.fvalue_id IS '值ID';


--
-- Name: COLUMN wf_approvalruleelement.fvalue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.fvalue IS '值';


--
-- Name: COLUMN wf_approvalruleelement.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.sequence IS '排序号';


--
-- Name: COLUMN wf_approvalruleelement.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.version IS '版本号';


--
-- Name: COLUMN wf_approvalruleelement.element_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalruleelement.element_id IS '审批要素ID';


--
-- Name: wf_approvalrulehandler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrulehandler (
    approval_rule_id character varying(32),
    id character varying(32) NOT NULL,
    description character varying(512),
    handler_kind_code character varying(128),
    handler_id character varying(128),
    handler_name character varying(128),
    sequence numeric,
    version numeric,
    kind_id character varying(32),
    allow_add numeric,
    allow_subtract numeric,
    allow_transfer numeric,
    allow_abort numeric,
    need_timing numeric,
    help_section character varying(256),
    chief_id numeric,
    group_id numeric,
    biz_handler_param character varying(60),
    handler_kind_id character varying(64),
    must_pass numeric,
    approval_handler_kind_id character varying(32),
    limit_time numeric,
    send_message numeric
);


ALTER TABLE public.wf_approvalrulehandler OWNER TO postgres;

--
-- Name: TABLE wf_approvalrulehandler; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalrulehandler IS '审批规则审批人';


--
-- Name: COLUMN wf_approvalrulehandler.approval_rule_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.approval_rule_id IS 'ApprovalRuleID';


--
-- Name: COLUMN wf_approvalrulehandler.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.id IS 'ID';


--
-- Name: COLUMN wf_approvalrulehandler.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.description IS '描述';


--
-- Name: COLUMN wf_approvalrulehandler.handler_kind_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.handler_kind_code IS '管理权限、部门、岗位、人员成员、函数';


--
-- Name: COLUMN wf_approvalrulehandler.handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.handler_id IS '审批人ID';


--
-- Name: COLUMN wf_approvalrulehandler.handler_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.handler_name IS '审批人';


--
-- Name: COLUMN wf_approvalrulehandler.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.sequence IS '排序号';


--
-- Name: COLUMN wf_approvalrulehandler.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.version IS '版本号';


--
-- Name: COLUMN wf_approvalrulehandler.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.kind_id IS ' chief 主审 assistant 协审 cc抄送';


--
-- Name: COLUMN wf_approvalrulehandler.allow_add; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.allow_add IS '允许加签';


--
-- Name: COLUMN wf_approvalrulehandler.allow_subtract; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.allow_subtract IS '允许被减签';


--
-- Name: COLUMN wf_approvalrulehandler.allow_transfer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.allow_transfer IS '允许转交';


--
-- Name: COLUMN wf_approvalrulehandler.allow_abort; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.allow_abort IS '允许终止';


--
-- Name: COLUMN wf_approvalrulehandler.need_timing; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.need_timing IS '需要计时';


--
-- Name: COLUMN wf_approvalrulehandler.help_section; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.help_section IS '审批要点';


--
-- Name: COLUMN wf_approvalrulehandler.chief_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.chief_id IS '主审环节ID';


--
-- Name: COLUMN wf_approvalrulehandler.group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.group_id IS '分组ID';


--
-- Name: COLUMN wf_approvalrulehandler.biz_handler_param; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.biz_handler_param IS '业务处理人参数';


--
-- Name: COLUMN wf_approvalrulehandler.handler_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.handler_kind_id IS '环节ID';


--
-- Name: COLUMN wf_approvalrulehandler.must_pass; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.must_pass IS '是否必经节点';


--
-- Name: COLUMN wf_approvalrulehandler.limit_time; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.limit_time IS '限制时间';


--
-- Name: COLUMN wf_approvalrulehandler.send_message; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler.send_message IS '发送消息';


--
-- Name: wf_approvalrulehandler_auth; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrulehandler_auth (
    handler_auth_id numeric NOT NULL,
    approval_rule_id numeric,
    handler_id numeric,
    field_code character varying(128),
    field_name character varying(128),
    field_type character varying(128),
    field_authority character varying(128),
    sequence numeric,
    version numeric
);


ALTER TABLE public.wf_approvalrulehandler_auth OWNER TO postgres;

--
-- Name: TABLE wf_approvalrulehandler_auth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalrulehandler_auth IS '审批人字段权限表';


--
-- Name: COLUMN wf_approvalrulehandler_auth.handler_auth_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.handler_auth_id IS '审批人字段权限主键';


--
-- Name: COLUMN wf_approvalrulehandler_auth.approval_rule_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.approval_rule_id IS '审批规则ID';


--
-- Name: COLUMN wf_approvalrulehandler_auth.handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.handler_id IS '审批人ID';


--
-- Name: COLUMN wf_approvalrulehandler_auth.field_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.field_code IS '字段编码';


--
-- Name: COLUMN wf_approvalrulehandler_auth.field_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.field_name IS '字段名称';


--
-- Name: COLUMN wf_approvalrulehandler_auth.field_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.field_type IS '字段类型';


--
-- Name: COLUMN wf_approvalrulehandler_auth.field_authority; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandler_auth.field_authority IS '字段权限';


--
-- Name: wf_approvalrulehandlerassist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrulehandlerassist (
    approval_rule_handler_id character varying(32),
    id character varying(32) NOT NULL,
    description character varying(512),
    handler_id character varying(128),
    handler_name character varying(128),
    sequence numeric,
    version numeric,
    kind_id character varying(32),
    handler_kind_code character varying(128)
);


ALTER TABLE public.wf_approvalrulehandlerassist OWNER TO postgres;

--
-- Name: wf_approvalrulehandlergroup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrulehandlergroup (
    id character varying(32) NOT NULL,
    approval_rule_id character varying(32),
    task_execute_mode_id character varying(32),
    group_id numeric,
    version numeric
);


ALTER TABLE public.wf_approvalrulehandlergroup OWNER TO postgres;

--
-- Name: wf_approvalrulehandleruiperm; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrulehandleruiperm (
    id character varying(32) NOT NULL,
    approval_rule_handler_id character varying(32),
    code character varying(128),
    name character varying(128),
    kind_id character varying(64),
    operation_id character varying(64),
    sequence numeric,
    version numeric
);


ALTER TABLE public.wf_approvalrulehandleruiperm OWNER TO postgres;

--
-- Name: TABLE wf_approvalrulehandleruiperm; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalrulehandleruiperm IS '审批人字段权限表';


--
-- Name: COLUMN wf_approvalrulehandleruiperm.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandleruiperm.id IS '审批人字段权限主键';


--
-- Name: COLUMN wf_approvalrulehandleruiperm.approval_rule_handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandleruiperm.approval_rule_handler_id IS '审批人ID';


--
-- Name: COLUMN wf_approvalrulehandleruiperm.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandleruiperm.code IS '字段编码';


--
-- Name: COLUMN wf_approvalrulehandleruiperm.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandleruiperm.name IS '字段名称';


--
-- Name: COLUMN wf_approvalrulehandleruiperm.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandleruiperm.kind_id IS '字段类型';


--
-- Name: COLUMN wf_approvalrulehandleruiperm.operation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulehandleruiperm.operation_id IS '字段权限';


--
-- Name: wf_approvalrulescope; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_approvalrulescope (
    id character varying(32) NOT NULL,
    approval_rule_id character varying(32),
    org_id character varying(32),
    version numeric
);


ALTER TABLE public.wf_approvalrulescope OWNER TO postgres;

--
-- Name: TABLE wf_approvalrulescope; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_approvalrulescope IS '审批规则适用范围';


--
-- Name: COLUMN wf_approvalrulescope.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulescope.id IS 'ID';


--
-- Name: COLUMN wf_approvalrulescope.approval_rule_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulescope.approval_rule_id IS '审批规则ID';


--
-- Name: COLUMN wf_approvalrulescope.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulescope.org_id IS '组织机构ID';


--
-- Name: COLUMN wf_approvalrulescope.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_approvalrulescope.version IS '版本号';


--
-- Name: wf_basesegmentationtype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_basesegmentationtype (
    base_segmentation_type_id numeric NOT NULL,
    code character varying(64),
    name character varying(128),
    sequence numeric,
    version numeric,
    folder_id numeric
);


ALTER TABLE public.wf_basesegmentationtype OWNER TO postgres;

--
-- Name: TABLE wf_basesegmentationtype; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_basesegmentationtype IS '基础分段类';


--
-- Name: COLUMN wf_basesegmentationtype.base_segmentation_type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_basesegmentationtype.base_segmentation_type_id IS 'BaseSegmentationTypeID';


--
-- Name: COLUMN wf_basesegmentationtype.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_basesegmentationtype.code IS '编码';


--
-- Name: COLUMN wf_basesegmentationtype.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_basesegmentationtype.name IS '名称';


--
-- Name: COLUMN wf_basesegmentationtype.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_basesegmentationtype.sequence IS '排序号';


--
-- Name: COLUMN wf_basesegmentationtype.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_basesegmentationtype.version IS '版本号';


--
-- Name: COLUMN wf_basesegmentationtype.folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_basesegmentationtype.folder_id IS '文件夹ID';


--
-- Name: wf_bizsegmentation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_bizsegmentation (
    biz_segmentation_id numeric NOT NULL,
    org_id character varying(65),
    code character varying(64),
    name character varying(128),
    version numeric,
    sequence numeric,
    kind_id numeric
);


ALTER TABLE public.wf_bizsegmentation OWNER TO postgres;

--
-- Name: TABLE wf_bizsegmentation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_bizsegmentation IS '组织业务段';


--
-- Name: COLUMN wf_bizsegmentation.biz_segmentation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.biz_segmentation_id IS 'BizSegmentationID';


--
-- Name: COLUMN wf_bizsegmentation.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.org_id IS 'Org_ID';


--
-- Name: COLUMN wf_bizsegmentation.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.code IS '编码';


--
-- Name: COLUMN wf_bizsegmentation.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.name IS '名称';


--
-- Name: COLUMN wf_bizsegmentation.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.version IS '版本号';


--
-- Name: COLUMN wf_bizsegmentation.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.sequence IS '排序号';


--
-- Name: COLUMN wf_bizsegmentation.kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentation.kind_id IS '1 私有段 2 公开段 3 私有公开段';


--
-- Name: wf_bizsegmentationauthorize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_bizsegmentationauthorize (
    biz_segmentation_authorize_id numeric NOT NULL,
    biz_segmentation_id numeric,
    base_segmentation_type_id numeric,
    org_id character varying(65),
    sequence numeric,
    version numeric
);


ALTER TABLE public.wf_bizsegmentationauthorize OWNER TO postgres;

--
-- Name: TABLE wf_bizsegmentationauthorize; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_bizsegmentationauthorize IS '组织分段授权';


--
-- Name: COLUMN wf_bizsegmentationauthorize.biz_segmentation_authorize_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentationauthorize.biz_segmentation_authorize_id IS 'SegmentationAuthorizeID';


--
-- Name: COLUMN wf_bizsegmentationauthorize.biz_segmentation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentationauthorize.biz_segmentation_id IS 'BizSegmentationTypeID';


--
-- Name: COLUMN wf_bizsegmentationauthorize.base_segmentation_type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentationauthorize.base_segmentation_type_id IS 'BaseSegmentationTypeID';


--
-- Name: COLUMN wf_bizsegmentationauthorize.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentationauthorize.org_id IS '组织Id';


--
-- Name: COLUMN wf_bizsegmentationauthorize.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentationauthorize.sequence IS '排序号';


--
-- Name: COLUMN wf_bizsegmentationauthorize.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_bizsegmentationauthorize.version IS '版本号';


--
-- Name: wf_hi_procunithandler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_hi_procunithandler (
    id numeric NOT NULL,
    biz_id numeric,
    proc_unit_id character varying(64),
    proc_unit_name character varying(128),
    handle_kind_id character varying(64),
    handle_kind_name character varying(256),
    handler_id character varying(65),
    handler_name character varying(128),
    position_id character varying(32),
    position_name character varying(128),
    dept_id character varying(32),
    dept_name character varying(128),
    org_id character varying(32),
    org_name character varying(128),
    handle_time timestamp(6) without time zone,
    result numeric,
    opinion character varying(1024),
    status numeric,
    sequence numeric,
    version numeric,
    full_name character varying(2048),
    full_id character varying(1024),
    cooperation_model_id character varying(32),
    task_execute_mode_id character varying(32),
    group_id numeric,
    chief_id numeric,
    approval_rule_handler_id numeric,
    approval_rule_id numeric,
    assistant_sequence numeric,
    biz_code character varying(64),
    operate_kind_id character varying(32),
    operator_id character varying(65),
    vers numeric,
    operator_name character varying(256)
);


ALTER TABLE public.wf_hi_procunithandler OWNER TO postgres;

--
-- Name: COLUMN wf_hi_procunithandler.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_hi_procunithandler.version IS '数据版本';


--
-- Name: COLUMN wf_hi_procunithandler.operate_kind_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_hi_procunithandler.operate_kind_id IS '操作类型 add delete ';


--
-- Name: COLUMN wf_hi_procunithandler.vers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_hi_procunithandler.vers IS '版本';


--
-- Name: COLUMN wf_hi_procunithandler.operator_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_hi_procunithandler.operator_name IS '处理人';


--
-- Name: wf_hi_procunithandlerinst; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_hi_procunithandlerinst (
    id numeric NOT NULL,
    biz_id numeric,
    proc_unit_id character varying(64),
    version numeric,
    vers numeric
);


ALTER TABLE public.wf_hi_procunithandlerinst OWNER TO postgres;

--
-- Name: wf_id_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_id_log (
    old_id numeric,
    new_id numeric
);


ALTER TABLE public.wf_id_log OWNER TO postgres;

--
-- Name: wf_procapprovalelement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_procapprovalelement (
    id character varying(32) NOT NULL,
    proc_id character varying(32),
    proc_name character varying(256),
    proc_unit_id character varying(64),
    proc_unit_name character varying(256),
    element_id character varying(32),
    sequence numeric,
    proc_key character varying(510),
    version numeric
);


ALTER TABLE public.wf_procapprovalelement OWNER TO postgres;

--
-- Name: TABLE wf_procapprovalelement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_procapprovalelement IS '流程审批要素';


--
-- Name: COLUMN wf_procapprovalelement.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.id IS '流程审批要素ID';


--
-- Name: COLUMN wf_procapprovalelement.proc_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.proc_id IS '流程ID';


--
-- Name: COLUMN wf_procapprovalelement.proc_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.proc_name IS '流程名称';


--
-- Name: COLUMN wf_procapprovalelement.proc_unit_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.proc_unit_id IS '环节ID';


--
-- Name: COLUMN wf_procapprovalelement.proc_unit_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.proc_unit_name IS '环节名称';


--
-- Name: COLUMN wf_procapprovalelement.element_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.element_id IS '审批要素ID';


--
-- Name: COLUMN wf_procapprovalelement.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.sequence IS '排序号';


--
-- Name: COLUMN wf_procapprovalelement.proc_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procapprovalelement.proc_key IS '流程Key';


--
-- Name: wf_procunithandler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_procunithandler (
    id character varying(32) NOT NULL,
    biz_id character varying(32),
    proc_unit_id character varying(64),
    proc_unit_name character varying(128),
    sub_proc_unit_id character varying(64),
    sub_proc_unit_name character varying(256),
    handler_id character varying(65),
    handler_name character varying(128),
    position_id character varying(32),
    position_name character varying(128),
    dept_id character varying(32),
    dept_name character varying(128),
    org_id character varying(32),
    org_name character varying(128),
    handled_date timestamp(6) without time zone,
    result numeric,
    opinion character varying(2048),
    status numeric,
    sequence numeric,
    version numeric,
    full_name character varying(2048),
    full_id character varying(1024),
    cooperation_model_id character varying(32),
    task_execute_mode_id character varying(32),
    group_id numeric,
    chief_id character varying(32),
    approval_rule_handler_id character varying(32),
    approval_rule_id character varying(32),
    assistant_sequence numeric,
    biz_code character varying(64),
    principal_id character varying(65),
    principal_name character varying(128),
    execution_times numeric,
    send_message numeric
);


ALTER TABLE public.wf_procunithandler OWNER TO postgres;

--
-- Name: TABLE wf_procunithandler; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_procunithandler IS '环节处理人';


--
-- Name: COLUMN wf_procunithandler.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.id IS 'ID';


--
-- Name: COLUMN wf_procunithandler.biz_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.biz_id IS '业务ID';


--
-- Name: COLUMN wf_procunithandler.proc_unit_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.proc_unit_id IS '环节ID';


--
-- Name: COLUMN wf_procunithandler.proc_unit_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.proc_unit_name IS '环节名称';


--
-- Name: COLUMN wf_procunithandler.sub_proc_unit_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.sub_proc_unit_id IS '子环节ID';


--
-- Name: COLUMN wf_procunithandler.sub_proc_unit_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.sub_proc_unit_name IS '子环节名称';


--
-- Name: COLUMN wf_procunithandler.handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.handler_id IS '处理人ID';


--
-- Name: COLUMN wf_procunithandler.handler_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.handler_name IS '处理人姓名';


--
-- Name: COLUMN wf_procunithandler.position_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.position_id IS '岗位ID';


--
-- Name: COLUMN wf_procunithandler.position_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.position_name IS '岗位';


--
-- Name: COLUMN wf_procunithandler.dept_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.dept_id IS '部门ID';


--
-- Name: COLUMN wf_procunithandler.dept_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.dept_name IS '部门';


--
-- Name: COLUMN wf_procunithandler.org_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.org_id IS '机构ID';


--
-- Name: COLUMN wf_procunithandler.org_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.org_name IS '机构';


--
-- Name: COLUMN wf_procunithandler.handled_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.handled_date IS '处理时间';


--
-- Name: COLUMN wf_procunithandler.result; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.result IS '处理结果';


--
-- Name: COLUMN wf_procunithandler.opinion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.opinion IS '处理意见';


--
-- Name: COLUMN wf_procunithandler.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.status IS '1 启用 0 禁用';


--
-- Name: COLUMN wf_procunithandler.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.sequence IS '主审序号';


--
-- Name: COLUMN wf_procunithandler.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.version IS '版本号';


--
-- Name: COLUMN wf_procunithandler.cooperation_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.cooperation_model_id IS '协作模式 chief 主审 assistant 协审';


--
-- Name: COLUMN wf_procunithandler.task_execute_mode_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.task_execute_mode_id IS '任务执行模式 preempt 抢占模式 sequential 顺序执行 simultaneous 并行执行';


--
-- Name: COLUMN wf_procunithandler.group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.group_id IS '分组ID';


--
-- Name: COLUMN wf_procunithandler.chief_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.chief_id IS '主审人ID';


--
-- Name: COLUMN wf_procunithandler.approval_rule_handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.approval_rule_handler_id IS '审批规则处理人ID';


--
-- Name: COLUMN wf_procunithandler.approval_rule_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.approval_rule_id IS '审批规则ID';


--
-- Name: COLUMN wf_procunithandler.assistant_sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.assistant_sequence IS '协审序号';


--
-- Name: COLUMN wf_procunithandler.biz_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.biz_code IS '业务编码';


--
-- Name: COLUMN wf_procunithandler.principal_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.principal_id IS '委托人ID';


--
-- Name: COLUMN wf_procunithandler.principal_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.principal_name IS '委托人ID';


--
-- Name: COLUMN wf_procunithandler.execution_times; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.execution_times IS '执行次数';


--
-- Name: COLUMN wf_procunithandler.send_message; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandler.send_message IS '发送消息';


--
-- Name: wf_procunithandler_cache; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_procunithandler_cache (
    id character varying(32) NOT NULL,
    biz_id character varying(32),
    proc_unit_id character varying(64),
    proc_unit_name character varying(128),
    sub_proc_unit_id character varying(64),
    sub_proc_unit_name character varying(256),
    handler_id character varying(65),
    handler_name character varying(128),
    position_id character varying(32),
    position_name character varying(128),
    dept_id character varying(32),
    dept_name character varying(128),
    org_id character varying(32),
    org_name character varying(128),
    handled_date timestamp(6) without time zone,
    result numeric,
    opinion character varying(2048),
    status numeric,
    sequence numeric,
    version numeric,
    full_name character varying(2048),
    full_id character varying(1024),
    cooperation_model_id character varying(32),
    task_execute_mode_id character varying(32),
    group_id numeric,
    chief_id character varying(32),
    approval_rule_handler_id character varying(32),
    approval_rule_id character varying(32),
    assistant_sequence numeric,
    biz_code character varying(64),
    principal_id character varying(65),
    principal_name character varying(128)
);


ALTER TABLE public.wf_procunithandler_cache OWNER TO postgres;

--
-- Name: wf_procunithandlermanuscript; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_procunithandlermanuscript (
    id character varying(32) NOT NULL,
    biz_id character varying(32),
    proc_unit_handler_id character varying(32),
    height numeric,
    opinion_30 text,
    opinion_64 text,
    version numeric
);


ALTER TABLE public.wf_procunithandlermanuscript OWNER TO postgres;

--
-- Name: COLUMN wf_procunithandlermanuscript.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.id IS 'ID';


--
-- Name: COLUMN wf_procunithandlermanuscript.biz_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.biz_id IS '业务ID';


--
-- Name: COLUMN wf_procunithandlermanuscript.proc_unit_handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.proc_unit_handler_id IS '环节处理人ID';


--
-- Name: COLUMN wf_procunithandlermanuscript.height; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.height IS '高度';


--
-- Name: COLUMN wf_procunithandlermanuscript.opinion_30; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.opinion_30 IS '处理意见';


--
-- Name: COLUMN wf_procunithandlermanuscript.opinion_64; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.opinion_64 IS '处理意见';


--
-- Name: COLUMN wf_procunithandlermanuscript.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_procunithandlermanuscript.version IS '版本号';


--
-- Name: wf_segmentationhandler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_segmentationhandler (
    segmentation_handler_id numeric NOT NULL,
    segmentation_id numeric,
    description character varying(512),
    handler_kind_code character varying(64),
    handler_id character varying(256),
    handler_name character varying(256),
    group_id numeric,
    version numeric,
    sequence numeric
);


ALTER TABLE public.wf_segmentationhandler OWNER TO postgres;

--
-- Name: TABLE wf_segmentationhandler; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_segmentationhandler IS '组织业务段处理人';


--
-- Name: COLUMN wf_segmentationhandler.segmentation_handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.segmentation_handler_id IS 'SegmentationHandlerID';


--
-- Name: COLUMN wf_segmentationhandler.segmentation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.segmentation_id IS 'SegmentationID';


--
-- Name: COLUMN wf_segmentationhandler.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.description IS '描述';


--
-- Name: COLUMN wf_segmentationhandler.handler_kind_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.handler_kind_code IS '管理权限、部门、岗位、人员成员、函数';


--
-- Name: COLUMN wf_segmentationhandler.handler_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.handler_id IS '处理人ID';


--
-- Name: COLUMN wf_segmentationhandler.handler_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.handler_name IS '处理人名称';


--
-- Name: COLUMN wf_segmentationhandler.group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.group_id IS '分组ID';


--
-- Name: COLUMN wf_segmentationhandler.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.version IS '版本号';


--
-- Name: COLUMN wf_segmentationhandler.sequence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_segmentationhandler.sequence IS '排序号';


--
-- Name: wf_taskcollection; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wf_taskcollection (
    id character varying(32) NOT NULL,
    task_id character varying(64) NOT NULL,
    person_id character varying(32) NOT NULL,
    created_date timestamp(6) without time zone,
    version numeric
);


ALTER TABLE public.wf_taskcollection OWNER TO postgres;

--
-- Name: TABLE wf_taskcollection; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.wf_taskcollection IS '用户收藏任务';


--
-- Name: COLUMN wf_taskcollection.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_taskcollection.id IS 'ID';


--
-- Name: COLUMN wf_taskcollection.task_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_taskcollection.task_id IS '任务ID';


--
-- Name: COLUMN wf_taskcollection.person_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_taskcollection.person_id IS '人员ID';


--
-- Name: COLUMN wf_taskcollection.created_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_taskcollection.created_date IS '创建时间';


--
-- Name: COLUMN wf_taskcollection.version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.wf_taskcollection.version IS '版本号';


--
-- Data for Name: act_ge_bytearray; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ge_bytearray VALUES ('c3749aae-ffab-11e9-9c73-0028f86b42f3', 1, 'var-handlerList', NULL, '\xaced0005737200136a6176612e7574696c2e41727261794c6973747881d21d99c7619d03000149000473697a65787000000001770400000001740020373034343332303530444144343134464136363438463335453135304641363978', NULL);
INSERT INTO public.act_ge_bytearray VALUES ('c3749ab0-ffab-11e9-9c73-0028f86b42f3', 1, 'hist.var-handlerList', NULL, '\xaced0005737200136a6176612e7574696c2e41727261794c6973747881d21d99c7619d03000149000473697a65787000000001770400000001740020373034343332303530444144343134464136363438463335453135304641363978', NULL);
INSERT INTO public.act_ge_bytearray VALUES ('0589d446-ffab-11e9-9c73-0028f86b42f3', 1, 'bpm/demo/leave.bpmn', '058603b5-ffab-11e9-9c73-0028f86b42f3', '\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', 0);
INSERT INTO public.act_ge_bytearray VALUES ('05f1e4e7-ffab-11e9-9c73-0028f86b42f3', 1, 'bpm/demo/leave.leave.png', '058603b5-ffab-11e9-9c73-0028f86b42f3', '\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', 1);


--
-- Data for Name: act_ge_property; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ge_property VALUES ('schema.version', '5.21.0.0', 1);
INSERT INTO public.act_ge_property VALUES ('schema.history', 'create(5.14)', 1);
INSERT INTO public.act_ge_property VALUES ('next.dbid', '969881', 27871);


--
-- Data for Name: act_hi_actinst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_actinst VALUES ('c3535707-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'startevent1', NULL, NULL, 'Start', 'startEvent', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05', 9, NULL);
INSERT INTO public.act_hi_actinst VALUES ('c354dda8-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'Apply', 'c354dda9-ffab-11e9-9c73-0028f86b42f3', NULL, '填写请假条', 'userTask', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '2019-11-05 17:07:05', '2019-11-05 17:07:05', 230, NULL);
INSERT INTO public.act_hi_actinst VALUES ('c3786b42-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c377f611-ffab-11e9-9c73-0028f86b42f3', 'Approve', 'c378e079-ffab-11e9-9c73-0028f86b42f3', NULL, '审批请假条', 'userTask', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '2019-11-05 17:07:05', NULL, NULL, NULL);
INSERT INTO public.act_hi_actinst VALUES ('0a2adcdd-284f-11ea-9881-d8f2ca5d0a25', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', 'startevent1', NULL, NULL, 'Start', 'startEvent', NULL, '2019-12-27 10:17:03', '2019-12-27 10:17:03', 244, NULL);
INSERT INTO public.act_hi_actinst VALUES ('0a503f2e-284f-11ea-9881-d8f2ca5d0a25', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', 'Apply', '0a503f2f-284f-11ea-9881-d8f2ca5d0a25', NULL, '填写请假条', 'userTask', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '2019-12-27 10:17:03', NULL, NULL, NULL);


--
-- Data for Name: act_hi_comment; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: act_hi_identitylink; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_identitylink VALUES ('c3552bca-ffab-11e9-9c73-0028f86b42f3', NULL, 'participant', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', NULL, 'c3535706-ffab-11e9-9c73-0028f86b42f3');
INSERT INTO public.act_hi_identitylink VALUES ('c379078a-ffab-11e9-9c73-0028f86b42f3', NULL, 'participant', '704432050DAD414FA6648F35E150FA69', NULL, 'c3535706-ffab-11e9-9c73-0028f86b42f3');
INSERT INTO public.act_hi_identitylink VALUES ('0a5b3bb0-284f-11ea-9881-d8f2ca5d0a25', NULL, 'participant', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', NULL, '0a286bdc-284f-11ea-9881-d8f2ca5d0a25');


--
-- Data for Name: act_hi_procinst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_procinst VALUES ('0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '9AAB3F1E25A2D78DE050007F010072EA', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '2019-12-27 10:17:03', NULL, NULL, NULL, 'startevent1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.act_hi_procinst VALUES ('c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', '5A7C1C41ECF2429D8CC6F465D8F8E050', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '2019-11-05 17:07:05', NULL, NULL, NULL, 'startevent1', NULL, NULL, NULL, NULL, NULL);


--
-- Data for Name: act_hi_procinst_extension; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_procinst_extension VALUES ('c3535706-ffab-11e9-9c73-0028f86b42f3', '5A7C1C41ECF2429D8CC6F465D8F8E050', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, NULL, 'executing', '正在处理', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '2019-11-05 17:07:05', NULL, NULL, NULL, 'startevent1', NULL, NULL, NULL, NULL, NULL, 'leave', 'c3535706-ffab-11e9-9c73-0028f86b42f3');
INSERT INTO public.act_hi_procinst_extension VALUES ('0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '9AAB3F1E25A2D78DE050007F010072EA', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, NULL, 'executing', '正在处理', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '2019-12-27 10:17:03', NULL, NULL, NULL, 'startevent1', NULL, NULL, NULL, NULL, NULL, 'leave', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25');


--
-- Data for Name: act_hi_taskinst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_taskinst VALUES ('0a503f2f-284f-11ea-9881-d8f2ca5d0a25', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'Apply', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', NULL, '填写请假条', '请假流程', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '2019-12-27 10:17:03', NULL, NULL, NULL, NULL, 50, NULL, 'leave/showLeave.job', NULL, NULL);
INSERT INTO public.act_hi_taskinst VALUES ('c354dda9-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'Apply', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, '填写请假条', '请假流程', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '2019-11-05 17:07:05', NULL, '2019-11-05 17:07:05', 221, 'completed', 50, NULL, 'leave/showLeave.job', NULL, NULL);
INSERT INTO public.act_hi_taskinst VALUES ('c378e079-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'Approve', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', NULL, '审批请假条', '系统管理员审批系统管理员(2019-11-05 17:00:00) 请假流程', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '2019-11-05 17:07:05', NULL, NULL, NULL, NULL, 50, NULL, 'leave/showLeave.job', NULL, NULL);


--
-- Data for Name: act_hi_taskinst_extension; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_taskinst_extension VALUES ('c354dda9-ffab-11e9-9c73-0028f86b42f3', 'process', 'task', NULL, 'leave/showLeave.job', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'completed', '已完成', NULL, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, NULL, '5A7C1C41ECF2429D8CC6F465D8F8E050', 'leave201911050003', 0, NULL, 0, NULL, NULL, NULL, 3575212, 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 0, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'leave', '5EEB2DC861694A65933CB4CE9A8D870A', '5EEB2DC861694A65933CB4CE9A8D870A', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'Apply', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, '填写请假条', '请假流程', '2019-11-05 17:07:05', NULL, '2019-11-05 17:07:05', 210, 'completed', 50, NULL, 'leave/showLeave.job', NULL, NULL, 'advance', NULL);
INSERT INTO public.act_hi_taskinst_extension VALUES ('c378e079-ffab-11e9-9c73-0028f86b42f3', 'process', 'task', NULL, 'leave/showLeave.job', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'executing', '正在处理', NULL, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'c354dda9-ffab-11e9-9c73-0028f86b42f3', '704432050DAD414FA6648F35E150FA69', '5A7C1C41ECF2429D8CC6F465D8F8E050', 'leave201911050003', 1, NULL, 0, NULL, NULL, NULL, 3575214, 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'chief', 0, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'leave', '5EEB2DC861694A65933CB4CE9A8D870A', '5EEB2DC861694A65933CB4CE9A8D870A', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'Approve', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', NULL, '审批请假条', '系统管理员审批系统管理员(2019-11-05 17:00:00) 请假流程', '2019-11-05 17:07:05', NULL, NULL, NULL, NULL, 50, NULL, 'leave/showLeave.job', NULL, NULL, 'advance', '系统管理员审批');
INSERT INTO public.act_hi_taskinst_extension VALUES ('0a503f2f-284f-11ea-9881-d8f2ca5d0a25', 'process', 'task', NULL, 'leave/showLeave.job', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'executing', '正在处理', NULL, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, NULL, '9AAB3F1E25A2D78DE050007F010072EA', 'leave201912270001', 0, NULL, 0, NULL, NULL, NULL, 3581270, '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', NULL, 0, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'leave', '5EEB2DC861694A65933CB4CE9A8D870A', '5EEB2DC861694A65933CB4CE9A8D870A', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 'Apply', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', NULL, '填写请假条', '请假流程', '2019-12-27 10:17:03', NULL, NULL, NULL, NULL, 50, NULL, 'leave/showLeave.job', NULL, NULL, 'save', NULL);


--
-- Data for Name: act_hi_taskinst_relation; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: act_hi_varinst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_hi_varinst VALUES ('c35e2c7b-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'approveFinished', 'boolean', 0, NULL, NULL, 0, NULL, NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c35e2c7c-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'chiefApprovePassed', 'boolean', 0, NULL, NULL, 0, NULL, NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c35e2c7d-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'approvePassed', 'boolean', 0, NULL, NULL, 0, NULL, NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c3749aaf-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'handlerList', 'serializable', 0, 'c3749ab0-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c3786b43-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c377f611-ffab-11e9-9c73-0028f86b42f3', NULL, 'nrOfInstances', 'integer', 0, NULL, NULL, 1, '1', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c3786b44-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c377f611-ffab-11e9-9c73-0028f86b42f3', NULL, 'nrOfCompletedInstances', 'integer', 0, NULL, NULL, 0, '0', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c3786b45-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c377f611-ffab-11e9-9c73-0028f86b42f3', NULL, 'nrOfActiveInstances', 'integer', 0, NULL, NULL, 1, '1', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c378b967-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', NULL, 'loopCounter', 'integer', 0, NULL, NULL, 0, '0', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c378b968-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', NULL, 'assignee', 'string', 0, NULL, NULL, NULL, '704432050DAD414FA6648F35E150FA69', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');
INSERT INTO public.act_hi_varinst VALUES ('c37de98c-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, '_procUnitHandlerId_', 'string', 0, NULL, NULL, NULL, '704432050DAD414FA6648F35E150FA69', NULL, '2019-11-05 17:07:05', '2019-11-05 17:07:05');


--
-- Data for Name: act_re_deployment; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_re_deployment VALUES ('058603b5-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, '2019-11-05 17:02:04', NULL);


--
-- Data for Name: act_re_procdef; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_re_procdef VALUES ('leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', 1, 'http://www.activiti.org/leave', '请假流程', 'leave', 1, '058603b5-ffab-11e9-9c73-0028f86b42f3', 'bpm/demo/leave.bpmn', 'bpm/demo/leave.leave.png', NULL, 0, 1, NULL, 1);


--
-- Data for Name: act_re_procdef_tree_del; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: act_ru_event_subscr; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: act_ru_execution; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ru_execution VALUES ('0a286bdc-284f-11ea-9881-d8f2ca5d0a25', 1, '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '9AAB3F1E25A2D78DE050007F010072EA', NULL, 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', NULL, 'Apply', 1, 0, 1, 0, 1, 2, NULL, NULL, NULL);
INSERT INTO public.act_ru_execution VALUES ('c3535706-ffab-11e9-9c73-0028f86b42f3', 2, 'c3535706-ffab-11e9-9c73-0028f86b42f3', '5A7C1C41ECF2429D8CC6F465D8F8E050', NULL, 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, 0, 0, 1, 0, 1, 0, NULL, NULL, NULL);
INSERT INTO public.act_ru_execution VALUES ('c377f611-ffab-11e9-9c73-0028f86b42f3', 1, 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', NULL, 'Approve', 0, 0, 1, 0, 1, 6, NULL, NULL, NULL);
INSERT INTO public.act_ru_execution VALUES ('c3786b46-ffab-11e9-9c73-0028f86b42f3', 1, 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'c377f611-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', NULL, 'Approve', 1, 1, 0, 0, 1, 7, NULL, NULL, NULL);


--
-- Data for Name: act_ru_identitylink; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ru_identitylink VALUES ('0a5b3bb0-284f-11ea-9881-d8f2ca5d0a25', 1, NULL, 'participant', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', NULL, '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', NULL);
INSERT INTO public.act_ru_identitylink VALUES ('c3552bca-ffab-11e9-9c73-0028f86b42f3', 1, NULL, 'participant', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', NULL, 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL);
INSERT INTO public.act_ru_identitylink VALUES ('c379078a-ffab-11e9-9c73-0028f86b42f3', 1, NULL, 'participant', '704432050DAD414FA6648F35E150FA69', NULL, 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL);


--
-- Data for Name: act_ru_job; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: act_ru_task; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ru_task VALUES ('0a503f2f-284f-11ea-9881-d8f2ca5d0a25', 1, '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '填写请假条', NULL, '请假流程', 'Apply', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', NULL, 50, '2019-12-27 10:17:03', NULL, 1, NULL, NULL, 'leave/showLeave.job');
INSERT INTO public.act_ru_task VALUES ('c378e079-ffab-11e9-9c73-0028f86b42f3', 1, 'c3786b46-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '审批请假条', NULL, '系统管理员审批系统管理员(2019-11-05 17:00:00) 请假流程', 'Approve', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', NULL, 50, '2019-11-05 17:07:05', NULL, 1, NULL, NULL, 'leave/showLeave.job');


--
-- Data for Name: act_ru_task_extension; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ru_task_extension VALUES ('c378e079-ffab-11e9-9c73-0028f86b42f3', 'process', 'task', NULL, 'leave/showLeave.job', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'executing', '正在处理', NULL, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'c354dda9-ffab-11e9-9c73-0028f86b42f3', '704432050DAD414FA6648F35E150FA69', '5A7C1C41ECF2429D8CC6F465D8F8E050', 'leave201911050003', 1, NULL, NULL, NULL, 3575214, 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'chief', NULL, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'leave', '5EEB2DC861694A65933CB4CE9A8D870A', '5EEB2DC861694A65933CB4CE9A8D870A', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '审批请假条', NULL, '系统管理员审批系统管理员(2019-11-05 17:00:00) 请假流程', 'Approve', NULL, 50, '2019-11-05 17:07:05', NULL, 1, NULL, NULL, 'leave/showLeave.job', 'advance', '系统管理员审批');
INSERT INTO public.act_ru_task_extension VALUES ('0a503f2f-284f-11ea-9881-d8f2ca5d0a25', 'process', 'task', NULL, 'leave/showLeave.job', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'executing', '正在处理', NULL, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, NULL, '9AAB3F1E25A2D78DE050007F010072EA', 'leave201912270001', 0, NULL, NULL, NULL, 3581270, '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', NULL, 0, '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 'leave', '5EEB2DC861694A65933CB4CE9A8D870A', '5EEB2DC861694A65933CB4CE9A8D870A', '0a286bdc-284f-11ea-9881-d8f2ca5d0a25', 'leave:1:05f20bf8-ffab-11e9-9c73-0028f86b42f3', '填写请假条', NULL, '请假流程', 'Apply', NULL, 50, '2019-12-27 10:17:03', NULL, 1, NULL, NULL, 'leave/showLeave.job', 'save', NULL);


--
-- Data for Name: act_ru_variable; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.act_ru_variable VALUES ('c35e2c7b-ffab-11e9-9c73-0028f86b42f3', 1, 'boolean', 'approveFinished', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 0, NULL, NULL);
INSERT INTO public.act_ru_variable VALUES ('c35e2c7c-ffab-11e9-9c73-0028f86b42f3', 1, 'boolean', 'chiefApprovePassed', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 0, NULL, NULL);
INSERT INTO public.act_ru_variable VALUES ('c35e2c7d-ffab-11e9-9c73-0028f86b42f3', 1, 'boolean', 'approvePassed', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 0, NULL, NULL);
INSERT INTO public.act_ru_variable VALUES ('c3749aaf-ffab-11e9-9c73-0028f86b42f3', 1, 'serializable', 'handlerList', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, 'c3749aae-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, NULL);
INSERT INTO public.act_ru_variable VALUES ('c3786b43-ffab-11e9-9c73-0028f86b42f3', 1, 'integer', 'nrOfInstances', 'c377f611-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 1, '1', NULL);
INSERT INTO public.act_ru_variable VALUES ('c3786b44-ffab-11e9-9c73-0028f86b42f3', 1, 'integer', 'nrOfCompletedInstances', 'c377f611-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 0, '0', NULL);
INSERT INTO public.act_ru_variable VALUES ('c3786b45-ffab-11e9-9c73-0028f86b42f3', 1, 'integer', 'nrOfActiveInstances', 'c377f611-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 1, '1', NULL);
INSERT INTO public.act_ru_variable VALUES ('c378b967-ffab-11e9-9c73-0028f86b42f3', 1, 'integer', 'loopCounter', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, 0, '0', NULL);
INSERT INTO public.act_ru_variable VALUES ('c378b968-ffab-11e9-9c73-0028f86b42f3', 1, 'string', 'assignee', 'c3786b46-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, NULL, '704432050DAD414FA6648F35E150FA69', NULL);
INSERT INTO public.act_ru_variable VALUES ('c37de98c-ffab-11e9-9c73-0028f86b42f3', 1, 'string', '_procUnitHandlerId_', 'c3535706-ffab-11e9-9c73-0028f86b42f3', 'c3535706-ffab-11e9-9c73-0028f86b42f3', NULL, NULL, NULL, NULL, '704432050DAD414FA6648F35E150FA69', NULL);


--
-- Data for Name: avic_imp_employee; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liushujiang', '刘淑江', '司机', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4B42F148C77B47F1B0B431EF90E9A867', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'qilianghai001', '戚良海', '司机', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A9EBA56A42F54CC09D742F06B3EE8D0D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guanxu', '关旭', '司机', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FD38782A45A14180AEB74F25777C5EFE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'luchunlin', '卢春林', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C582C113428C4D909DFB6A678DF5482B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'meetingbj', '北京会议室', '林敬惠', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4D793F8A868143BFAA3AE82EB23B4353', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guoyuxi', '郭宇溪', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '520F568C84B94534AB02A0CF7531418C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'sf', '沈枫', '公文', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '30367BF6816C4BD2BF418391D69A9609', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'avicbsinfo', '工商信息', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6FDCC8D804C84A5CB484E9DF003FFB55', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'sunyu', '孙宇', '董监办主任', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6BD453E16F174BC6973E3B1C63329E0D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'liuyi', '刘裔', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '79A6BD28A4BA411B8507539354B615BE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '修史办', NULL, NULL, NULL, NULL, 'hbin', '黄斌', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '348FEE7F15724CB9940F7C28CC754947', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'wanghong', '王红', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4A3753DC8420449189D4886335D28868', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'luanht', '栾海涛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'CFF98C3D8ABA4F3B8AD698EB06AF6EAF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'fangxiaohua', '方小华', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8CDF4ECD823940A589629D5ACBE28C81', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lixin', '李欣', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6B1DC3CFA27B4205A23D0359557145EB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'shaoyong', '邵勇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3932F2E8A21843D09121191C3E5B5794', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicstj', '中航国际苏同骏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '72541350E2F24598862E415D8F297BEC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhangjie001', '张杰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5F96DF203D77424C85511E96F30712E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lcgem', '李晨光', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7F4DCE99FCF6430E97728870CED4EF37', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'hwh', '侯卫红', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C0768C3A25A54DC4B5C93ECA22E64EED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liubinliao001', '刘濒辽', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2AB454A9FCF34ECC908B84EC4E710566', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'shenghua', '盛华', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8A88082FDDFE4CA5A79260EF4EC93F82', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liuhuayi', '刘华奕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3EFF115F35834A7394D0917F6CF24993', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'lixiaomeng', '李晓曚', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F4F7EFCCC3F94902B1DF7F943D468823', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhanglinyi', '张临意', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4602C98AD8F94390AA40ABB24B29852B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangsai', '张赛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8E5112D717774F9E9C4D8073DC81DB5E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'chenn', '陈楠', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2AEA086EF1DE419CB895252E7D76541B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'qiwenjuan', '祁文娟', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '858BCF8EA6AA48C5826854F0C4CF0C2B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangzhen', '张振', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C85A1F8034C34DE18C16B1C5D6341641', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhuwenting', '祝文婷', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '432E1FD91B244A798A3CDBE1F06600DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'songling', '宋凌', '事业部总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7EDBCF631D0246728BCCD4C044E17A77', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'elu', '吕中华', '总会计师', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0ABA687B0EE741C3AD4F335A61128F62', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'xubomj', '徐波', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '66850A1D20354C2BA2FE9D2DF29D82BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'heran', '张赫然', '专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9AC240AFAA49407C873EB4EBB51F49B6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jinxing', '金星', '专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '166B9FB5A028439EB2D28C3F5032B760', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'wangxiaobo', '王晓波', '专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B9FC0C8F2EA1487AA40069E445981509', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jiangjin', '蒋金', '专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '47B8BF2683174FD89A54C96514ECCE54', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'lilaclinda', '林征', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '88CB5E2666564ECCA44D93DEB7620565', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'suqian', '苏倩', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BDFEF8CB65FC421A9C0AE45583D710A6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'xujing666', '徐晶', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0ECA18253AF445FA85DCA803F945852C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'jiaomeng', '焦萌', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0ECFBCBA7BB440F78A3996BF179A76DF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'fengbinyun', '冯彬芸', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B52AFC2F29B0476E84402CEA3D468946', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'guxuan', '谷轩', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AD1ACAA197A34EBEA7AF366028E4A542', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'wanghao', '王昊', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A0BF7C78D6544BCAAC7301C4E8377566', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'zhangwenfei', '张文飞', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '48A9F337DF024945BAC1D93530FB5500', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'yyzc', '航空运营支持事业部', '王昊', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '720A3BC7AF554DC493AA85C4F8ED7B8B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'dingli', '丁黎', '党建人力部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8A592250F90040EDB117A3846A4B22C5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'xuchangfeng', '徐长凤', '党建人力副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'EB5619071BE04FCB91F4AAC98F748038', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangweichen', '张伟琛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ABF61165E82244A3B5B8401884D2C5A1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'huanghe', '黄河', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '84BF775F99E1401D9C1D9A80903D0935', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangyanan', '张亚楠', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '39038FCD15BF47F1A6F8FAA4CA418009', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'nijiaxu', '倪嘉序', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9A92B43358704131B1A8D0283EC612BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicszg', '中航国际宋治纲', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8D49A361962E4F72B0A7767D607C84FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'mzhy', '毛周勇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'CB269CA9BE0E44B69DA40734BE6EF0EE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhaochunwei', '赵春伟', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6883EDF8801C47FAB25610B6158B252C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhaoyc', '赵玉成', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'EEA6FD1199D9492F916E3C379AB011ED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhangmy', '张明月', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '93B1B7B66ADA4A6DA772B565594D76D6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lili', '李丽', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '61802FF76B4349AAA03FEE235DF1F6DA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'tangq', '唐群', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E3B83D399C024C00B8388A5B8B61D50B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lisha', '李莎', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6E265C09B0DF4E689A03E7DC3A316078', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'xqzyy', '薛智勇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D88C3B2DA4A14B16903D3712DF0E515E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'wmg', '王明贵', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '218D814E659F43D79964D53D7356A636', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'guojing', '郭晶', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '223E7737600F420F89F2733BF1FCEFEA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'fudebin', '付德斌', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '618CB9E713B442128A917784BA3ED0E8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhanglw', '张立伟', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1DC222DA36934C4CB8B99D1115438DD6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhaochen', '赵晨', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '15D430ACDFC84921ABA0B8FD0045BC5B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'wangguoping', '王国平', '领导干部管理办主任', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A69EDE3352EE41E58B8EF60322B80DAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangxu', '杨旭', '杨乐', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B6C1982F95BA43A0A4841890B10A6AFC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'huangjing', '黄静', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4815965AF7EC47D69E269C514ABFF698', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hechuan', '何川', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '20BCB5BF9B3F48EA87778845CFEA9E7B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhimin', '智敏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AC16B29595A14D728E0F5A61B536805B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'houfanglong', '侯方龙', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '60E30C37240443378F50570751A44EC0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'xupei', '徐佩', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4A45480A88694D9C864C22F6E9F97222', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yuett', '岳婷婷', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1AF8AB6F27224961A0C20032C16CDDEB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'liaohaitao', '廖海涛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2063E33363024D46BB01D0C46F6F568E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'ehr', '人力资源系统专用邮箱', '彭潇', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '12D03E34D71E4208A7E9D73CE97C90A8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'rlzyb', '人力资源部公共邮箱', '杨旭', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '83278092B05D4EA098E96DFCB055FDBF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hrtest', '人才测评系统', '王国平', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A6DE255A558D49429CBF522FEC27B37E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangle', '杨乐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B15B6C7D0D554C0E913A7B5577FD48B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'pengxiao', '彭潇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C8CB472EF88048359A4C72682212EFC1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'zhaopin', '人力资源招聘', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '50D23E492D334F4AB39CD5F98B43B61F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'libin', '李斌', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3F8F91EC1E4A4197893F9BCCBEE1868B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lipeiyin', '李培寅', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FEB8AC03F7264A7083CD1A4650363BD5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyuan', '章苑', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '257F8D80732F4A78A5A310BE039EF261', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'muyan', '穆焱', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C959371FDF23477A884F935F5408A4E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liangmaolei', '梁茂蕾', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ADAF575D6AF54B33AD9F0C89E18CB8BD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wanlina', '万莉娜', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A0AB25B8466A4193B61DA0E5B84556CE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangying', '王莹', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '864A5297BC09484A96866E323064DC1D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lynan', '林彦男', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '24F78F6E358245AA92B4F039518A0ABE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'xuxingxing', '徐幸幸', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '94F6C5F0A80243A7A0FC7932A3C859D1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhaocx', '赵晨雪', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0ABF686F85DD414C8BB7611DC2512003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'luobaiwen', '罗白雯', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AB13AA306DA14E1DA2947D4F4D84BF1A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'sunyitong', '孙一桐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '83682A7B4290452798211B57F3BB1840', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangt', '汪涛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '30D34AD8C7A54C2F822BA60DAC4F2BB2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'huangzy', '黄卓妍', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AE0C4E25D5244685B5057BAF495F2188', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'suirong', '隋榕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AE2F628AB3BB44549854C62AE82A3690', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangjintao', '王金涛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '63EFEE67A98A4C00A70F4242FAF81CA8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yanailing', '严蔼玲', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'CB94E2E089A84853BE074AD72CFF2D8F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangf', '王丰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ED7291A45C7E45D58F67B1CFAB1342B0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liuyx', '刘彦希', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '65D61EFA42D2422D8C3373DC87F76214', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'fanxiaowei', '范笑薇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '14E9B319D5684F17AA9846A82822CB9F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'maoli', '毛立', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F374E3044EBB4936A4A3344410D60C0E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyundi', '张云迪', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D05C5E091CD14257A66298B10F1760CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'chenzheng001', '陈政', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1C54CC7221E64CA89BD9E596FD39D541', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lvkaifeng', '吕凯风', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B368323206CE4CA39EA42630C56B7EB6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yangpishi', '杨皮石', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '101DB660E35348F2AED6B3FB9B5A9F9A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'ljing', '刘晶', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1ADDCF3C870D47CD9E188EDEA4B550A0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'mochendong', '莫晨东', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8833A94D8D1748F485255F7C95C33262', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yinguangquan', '殷广泉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '82D71091DD0545AD843D7B2EAC69C6FB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'xuyachao', '徐亚超', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D2737F5E2B774BBFA162660AD04A9B45', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jiangq', '江强', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D1F9678C4ACF4D789AE1803C1D0DFC22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'lichuangrong', '李创荣', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '978468E1DA54440EB9DCDE6229F8EF25', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'cw-yxzp', '财务永续中票', '刘苏晋', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '501F4CDBED074C048C5ABD43B4488CDD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jenniferwb', '王彬', '李培寅代管', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D0D1E1616DD0464499159E2136DB61E2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'zhangyulong', '张玉龙', '常驻法国', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '56916D9E87994AA885E8B2394B6868BF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'liusujin', '刘苏晋', '常驻美国', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '356670770FFD44829DF0AC1D034F361E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'wangsh', '王双', '常驻英国', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B984715B2F13460191B348EF281879C7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'yaoyuanjm', '姚远', '范帅帅代管', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1E5DAD17B3B0445CB8E21F2B910F0B77', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'qiqing', '齐晴', '马亮代管', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7B122D85E57940A0AC449BDDF25DF519', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'fanshuaishuai', '范帅帅', '陈政代管', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B3194351B9724CA7BA665E42ED015C3C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'linjining', '林纪宁', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6B94CE7280E343D99018262B998C4CA1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jinrx', '金如心', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4EC4BB63A4534715A5CEF753BE83BD70', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'chenshiya', '陈诗亚', '张云迪代管', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E1A5A011BDB644B3BB614121CB903CDD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'maliang', '马亮', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3D54CCB3F75B4C42821C839CF0A3AD7B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'youyanchun', '由艳春', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BAF0AD0D8E02415FB81F56A3D6C85E24', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'zhanghui', '张辉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7BC30FBECAA44AE3A780C38DF14E4CF5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'xuxg', '徐新纲', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D7BC90C0BAB84AE9AF416F737CF3B615', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'jp', '姜萍', '常驻', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B4DCC411E0BA470A8919812CD926BAC0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhangzhibiao', '张志标', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BAC88991D22C4CF7AA2CCFD2B3A37F40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'guojian', '郭剑', '专务兼副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7D14FBB5FB8E40DD984CE63083E14C30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'chenxh', '陈晓红', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '870F46A1B10F42F5A82BDD6E9E5CDACF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'hpl', '韩沛霖', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '24005DD337B245FD93FF5CBCDA8BE783', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'ltj', '刘铁军', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FA80008BF7C643EEA004BD1D7DB8CCDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'yanglei', '杨蕾', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0C4CEB92DE5A4530A73758F577EB6089', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'lfchuan', '李方川', '国际航空板块业务办公室主任', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '923D159DFE2342C4B3C8018D89FF1896', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'fqy', '傅麒玉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '590EA043899F482CA9ABFF3C77E2211C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhp', '朱贺鹏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4431B8873BE3426881CFA0F4E8A6661D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'dengjiani', '邓佳妮', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '539787D37DF44D49B0A0F40BE4DF4EAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhenli', '甄李', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5CFC163D97C54C898F640B40ABD523FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wxy', '王心宇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '45EA9F90D5B5471F8423E7C1C20407AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'julia', '朱立新', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9B927B6A0B9C4B0685B5D293EB8B1179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhouxiaoling', '周小玲', '邓佳妮代管', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '19A0261F71744B408109965949369E3E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wbing', '王兵', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BA3383383C1444C4AF12AC353E966D5B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'baifeng001', '白峰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '35AC9C4647054FCFB875614EB3E7AE9B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'zhuli', '朱力', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E5C2C3F498104CA69201EA97BAB98BFF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jinshaohua', '金少华', '专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '98770520EF884F7089E2E542F1504128', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'sqh', '宋清浩', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '58706DAFF25A4BE1AB801217C75BBBD6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'hunq', '胡乃庆', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '400944A3073D4785A1C219369882A131', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'songxiaodong', '宋晓东', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '991F1AA24C9F4D7B817EA8DAC69744A9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'chenyang', '陈阳', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '700775EA2E234F92B13FEBDFC5EAE0D7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'quning', '曲宁', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8CF308AEBD9347BB899FD4DCF756901A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'tanqi', '谭奇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '42A6AADF3657415388F91D3679182855', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'wangying626', '王颖', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '585F9BD8EF3144D6925AAA552623FE01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'liujinghua', '刘菁华', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9687E8F8F8294B2495DC5AEC307F9362', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jin', '纪宁', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '08FC7885D686425E9D1C8EDCE0B1AA9C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'intl', '海外机构联络', '曲宁', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F042A6160E5C413E8F0F95A585B0BF26', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'qiaojuan', '乔娟', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '61AA010521D24399A3AAC88C80028BB4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'xiaofu', '付潇', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '69D536D376AC40DFB01F6961C07B5EFF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'wangxiuming', '王秀明', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7EDB3F580F1A4BF9A3C070B5900CBD88', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'maxiaoxu', '马晓旭', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '485CB1AAD94E4A4792786317E071ADA8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'yuweiye', '于伟业', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '26495841167A4294A982A471EFC2EAE6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'guotianji', '郭天骥', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8F93499EB24B424B84ED6F22DD026C4A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'lengfengyang', '冷奉阳', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6FEA44D3B29D42C9B15C4A7D8B3E635C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'czy', '陈兹勇', '部长一纪检组副组长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F1C467865A044B66A63DA6ECA415A26D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guowei', '郭薇', '专务兼副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ACB1E8C8D88F4B0B8D46B093B9C2712A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guxiaozhong', '顾筱中', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '926F23572FB445699FF71FC7D12A234B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangjunmin', '张军民', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '52D17558C1974F4CA48DA76CDF59784B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'huangqian', '黄倩', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D9A1D63974C7477C80A5694F7ABC3702', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangp', '张鹏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B432F6C312A34B3B900A5DB944AC0C90', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangshuang', '张爽', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D9C3F16475DF4632B3E69A92A09DEED4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'jubao', '中航国际审计部举报邮箱', '张爽', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9116E81DC713475CB0B6EE5119AC8BB8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'shenji', '审计专用', '张军民', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A834A9CB73A743C4A04B89FB3057CFEC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'liuying001', '刘颖', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '12A7112A169547B6837640B03AA69954', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'sxt', '史笑彤', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E3A8EB68972445E1B3785659749059DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wudan', '吴丹', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AAA34EA425EF4A4B8EA8051BEE8E61EC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lipeng', '李鹏', '党委副书记纪委书记', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6697F29745CE4751AE365873998A2D51', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhangwen', '张文', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '87D8A04EB7524C40A1A19B7A3EC3DE37', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lily723', '刘美希', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FB2225CFD9844D82802BAF5ED160F629', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'xuli', '许莉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D5C83244AFBC4FF3910831D90496D855', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wwt', '魏文韬', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7D5E967763C2408098362704B8AEF109', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'mingpian', '名片制作', '刘美希', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '17A55982C5784D6A938855B5C12BF2FA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'qywhb', '企业文化部公用', '许莉', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1F65E314132544DF899AFEA762398992', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhgjyjx', '中航国际意见箱', '许莉', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '892EE284165044D7B30539CD64DFF582', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'zoukangning', '邹康宁', '事业部总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A401484E3D6241EEA83DE790C0C21C48', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'suzhenyu', '苏振宇', '事业部副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C686A961EEBD455AA797AD010744F04F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'hyw', '何跃武', '事业部总会计师', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '49B08BB1B7414200A0E32637E627FE2F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部专务', NULL, NULL, NULL, NULL, 'yanna', '杨慧君', '专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D97EFF834E70410A89AD7B43F6D9561D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'liuruiyan', '刘睿妍', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4B09E6659B5B4395B7AB66C213205F67', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'linxiaojie', '林晓杰', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9F5EF8BEF2FD45CB9958D5F55F2166D0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangbowen', '张博文', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9F6FC543FC264F4CBB8D23B2AE2B5683', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'qiaofl', '乔芳林', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FC3B8350DD2140D288EC9D44F9564060', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'yon', '叶宁', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'EE37E9D5818148479D53A8AFBC3CFBE7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'niuds', '牛德胜', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F5866E7D2C89466FAEA871658F4BABFD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'jinbo', '金波', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1C94DAA89FD14929A9C5CA24B3824CF6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangyuan001', '张媛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'DA59E1A690E04ABF893AB32FF27FD103', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'ytt', '岳婷婷', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FA325B574A614BD4AAB1FDD140BF03C9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'songchen', '宋晨', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D2E7D1C26DD2404C837140478D764FFF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'hezuozp', '合作发展事业部招聘', '岳婷婷', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'EF236141B4A049EF8A7E698BBC2F8720', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'lishengnan', '李圣男', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ED8E44E3B56E4C479FFDF5BA805CD05D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'liuhui', '刘辉', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B893032346144BFF9E4AAD18CDCBE9B4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'xuyi', '徐奕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2BD925848696420282CA3148541D1BD9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhenghui', '郑辉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BA4766B67DB5466F97ACDAD5E474B01C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhanggang', '张刚', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '19554AF992A04F88943AADFDE8D2E860', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', NULL, NULL, NULL, NULL, 'luchangchun', '卢长春', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '01378B8850F44086A4EF637BF2D68F48', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyp', '张艳萍', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AB2C375971D844EBAF91D099DDE3B691', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'lihuayun', '李华云', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5AB94973E39246E493CD4CC12710CFA2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'yut', '喻彤', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B2E5B1ECEBEC47FEBAB19140D5AC9186', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyi', '张怡', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D3C9CA8CF23B400AA5878DFB30CCBC46', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'shihuanan', '史华楠', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1DCE2DB26F89416BB335A4E5FC23C899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhoushujuan', '周淑娟', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6162FE31FC694174930EB457B26F5388', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', NULL, NULL, NULL, NULL, 'hanke', '韩可', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '186030A3EF674A309F0D978F4AE31578', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'shihong', '石红', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '473B308D809642BB81DE7FEACACB72AD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'zhangmeng', '张萌', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2F61C3253EF54ACF8B594A2DD47ED3C3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'gaochuan', '高川', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F7A5874427A445C2B9AD87069A0580EF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'jxy', '景小燕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C2E1F8FF0AE1403DAB34293EF3299959', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'chenzhigong', '陈志功', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '99250E4D0F134D33801BA63A7B42FC40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'daiwen', '戴闻', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '681EB32C75754507A6853287CC16F179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'liguangnian', '李广年', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B51E819A048E4603802FC085881354AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'geyihong', '葛译鸿', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2ECA39EF738346DEA5FB50314EDB7A71', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'zhaoyuxiao', '赵宇骁', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F088DDD3EF714D18BFBA1EEDBDDA4056', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', NULL, NULL, NULL, NULL, 'xuyonggang', '徐永刚', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9CD364F6171143CC993499AEB55C5D80', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'wangxuefei', '王雪飞', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '921BEFC691494585ADD04650CF36EF44', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'zhaowenzheng', '赵温政', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5668745353E6401A821601FF71774825', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'mhf', '苗鸿飞', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '33DF0130A935452183730105997085F0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'jianghui', '姜晖', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3CA7C1AB88FE4F4298EDDD40DAFC6737', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'huangxin001', '黄欣', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '90E34FD1E3114D21931FCC348B9515E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', NULL, NULL, NULL, NULL, 'zhhui', '张辉', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9609FFCE51334CAD89182AB19160C722', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'miao_sue', '缪苏', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '475399BA47744D1EA7292766E7E29610', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'yesheng', '叶盛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ECA2A27315384AE8A60B34CA596DAAB8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'liuxian', '刘先', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5A99F105134E46C4ADC06F0D59CE2970', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'milong', '米龙', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '166A26559F52417C83E05497413EDD7C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'wangyq', '王雅琦', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B11F03F8B18944948B261DE44B5E34C7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'avicct-tianyuan', '田园', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '54EECA1563134D17A16214479083D8B6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'yaolai', '姚来', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6C53CA1663A24AA0A0194D96527D878E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'marongze', '马榕泽', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '38B2A82D0546404D91034A54A930335E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'liwanyu', '李琬玉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B3710BBA9A444DBF8EF77252795F06BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'ningjing', '宁婧', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '59728EFF376F4752859E6F5428E08BC8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangfeng', '王丰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '63D2087F70F84A6DBE04EFCF27687701', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangyan001', '王燕', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '983EF9DEF8CB4958A2CE58F5F60E73A2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'xingguanghui', '邢光辉', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '41533A19986F4BAEAFA987E4F64B5143', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '董事会', NULL, NULL, NULL, NULL, NULL, 'jyan', '焦燕', '董事会秘书总法律顾问', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4FC6F8E1ACFE4919B79DA69646BEF4E4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liuhd', '刘洪德', '董事长分党组书记', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '04F4177D563B4CB387847CEDA6445980', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'laiwx', '赖伟宣', '总经理分党组副书记', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FE4382EAFB044D2C90996653E83A7D84', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'chengbz', '程保忠', '分党组副书记', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1820383D61524993BC70B25DF2029634', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liujun', '刘军', '分党组成员副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9CF709340EDF4043A05A4F328BD3FAB2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'diaoweicheng', '刁伟程', '分党组成员副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '45BE0E7629774464ADBBC2FD3FAA85BC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'hanxy', '韩晓阳', '分党组成员纪检组组长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '59F76B9BE35649A59BB6DF14E3D8F5C3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liqifeng', '李其峰', '分党组成员副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'CA3B42DDA7D74B58B5643BF385A92B6E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'fufangxing', '傅方兴', '分党组成员总会计师', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2293CA7660F74926A39B3E16E161CB2A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhui', '张辉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2B0B5FEAE6F942BDBAE703F50C6F8AD4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'wentao', '文涛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7CA4D7C6E94C4C1990D1B4C271A8880E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'huangg', '黄光', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D7482DC3DF3B4B6EA41231B9070558C0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'yangyouqing', '杨有青', '高级专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '252DA2FEC644461EA8EA58C68DC8985F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhangguangjian', '张光剑', '高级专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '93F356BE93B943CB80E1D573D9656535', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'xiaoyi', '肖益', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8B0F5E67B77346879FECA7A8F0E76EF9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'chenhongguang', '陈红光', '离退办主任', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3A9EAFCFD033480692E105CC6211070B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'czg', '陈志刚', '安全生产总监兼副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '53CCD38BBE204340BF5B6F1B87A5BED4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liu_jie', '柳杰', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0FA000BCDFCB4A9BB59990C446674E12', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangkewei', '张可为', '部长助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F9F26BCAF1C54B96AF07E32B22D7A8E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangxudong', '张旭东', '业委会办公室主任', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ECDE3E346FD044ADA15251F2A80A836C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lisiqi', '李思齐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '83E26E1D2F1F4AE8A2A1DF68F65CC3CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'panwm', '潘为民', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '819833F7D0434F408094A33964E09B0F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'linjinghui', '林敬惠', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '21C9A1D76AA84C089B0EBFB6A812B6FB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'yangqing', '杨青', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2AADD8B546964507B670DFD9CFBF4F2A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'shenfeng', '沈枫', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3DCA6EA21E7E4F1D890AB6645AFDC618', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lpr', '凌佩冉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4CA27AD5342D46848B2225DA6DA6C702', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wulw', '吴力伟', '车队队长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7BCB43A3FD75408BB43F52668C9D7522', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wangqian', '汪黔', '司机', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4212E72F8E8546D2A7C9EC47E36288E5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'diaoweicheng', '刁伟程', '分党组成员副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9BD4C7970B2E4DAC978F1B44D618BE29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'hanxy', '韩晓阳', '分党组成员纪检组组长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'EECC923BE41D48CF8EBF05AE81F847A7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liqifeng', '李其峰', '分党组成员副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '10484ECBE37F49D4897DBFB3AFBDDA85', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'fufangxing', '傅方兴', '分党组成员总会计师', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2783A6C7E07149E890B37C608B5244CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhui', '张辉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '19B6247E44994B5CB5178CC6878A2284', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'wentao', '文涛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4CC411BE0D1D48E1947036B197E9EE71', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'huangg', '黄光', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '295BF7B3D5C74B20B292B7AEAF18389B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'yangyouqing', '杨有青', '高级专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '41081A1D50544EDCBD30D47F32104C5D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhangguangjian', '张光剑', '高级专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B7BC4DC6F84D4E21BB1A227D2C87DF04', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'xiaoyi', '肖益', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8E326321962B4F8EAA0929911AB719BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'chenhongguang', '陈红光', '离退办主任', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C1A66E62BC6B4263A97B1925A5B0607C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'czg', '陈志刚', '安全生产总监兼副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '32D612CB8C5C4DF69DD8DE587148D554', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liu_jie', '柳杰', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1132C4AEC7A54634B90AD9228B34EC2F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangkewei', '张可为', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6E2A5E8EAA7846F8ABF186E1D9A1525E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangxudong', '张旭东', '业委会办公室主任', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '92B135844F294936893F1595EB1663BE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lisiqi', '李思齐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E9D9F44E40FD4EAF9ABE8B848B47872E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'panwm', '潘为民', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '347811C3D93148E5BEB0C701E0892209', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'linjinghui', '林敬惠', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '784359746E9A461193C902DE0993A74E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'yangqing', '杨青', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '74A17CDC84CE4FCBA379D4C981D3EB49', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'shenfeng', '沈枫', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A7B9492E43A04920924D5BDE3D0BA066', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lpr', '凌佩冉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9A4E95B7A2B34DF88D8EC3ADE05C11ED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wulw', '吴力伟', '车队队长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A1EDB265210B444EBCDBB5CC8C137867', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wangqian', '汪黔', '司机', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9B2037894DB3436F8170BF72C38D2B60', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liushujiang', '刘淑江', '司机', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '061EF1706FD54762B452DD0891D36BC2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'qilianghai001', '戚良海', '司机', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D6B7DBF913794DF89EC544D4C63D66AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guanxu', '关旭', '司机', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7E888C1C39F8418A86CDDEB8BC587AAE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'luchunlin', '卢春林', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '180CB082B8CC41ADB210B7EDCC387D1C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'meetingbj', '北京会议室', '林敬惠', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '636FCE439421435286B7952CBFB9ED3F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guoyuxi', '郭宇溪', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AFEFD71D67DB4881B178151FAD8C9B46', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'sf', '沈枫', '公文', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8B6EF7F2CA654609B703F68DF9940BCF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'avicbsinfo', '工商信息', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '53EC9F738322463BA440868180B4138C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'sunyu', '孙宇', '董监办主任', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6AEAF039FB3A4E078F6DAC264179263A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'liuyi', '刘裔', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1C017A8C67E6472AB617273FAF6164BC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '修史办', NULL, NULL, NULL, NULL, 'hbin', '黄斌', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E4DC8E3EFFFE41CEAD2E1539C5ECC70C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'wanghong', '王红', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '999D6C63EA374876AF7D4067429B4A21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'luanht', '栾海涛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '426B67B73362486788A1D471D87DC92F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'fangxiaohua', '方小华', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '805913B6609C4EE69EA32B79C85135A2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lixin', '李欣', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A9C77288D33E4EBB907465F02DBB1294', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'shaoyong', '邵勇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C4894D9BF51F4CCEB4AEADB41FECA0C8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicstj', '中航国际苏同骏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E11A191831E2439797582A6C6B981034', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhangjie001', '张杰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2B2105DBAAD14C02A0A89D73C3CF008F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lcgem', '李晨光', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1DE5231BE15844F9AB5AF33C13AFE86D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'hwh', '侯卫红', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '94EA67200CBE4DBC9BF75AEBE7688EA7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'nijiaxu', '倪嘉序', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '02552E506A5242B684E6B8B443184FCF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicszg', '中航国际宋治纲', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DD9469E3450C40DF8D4488A32429DD0A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'mzhy', '毛周勇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2E9F653A33564B0CBD7AEB7BBCEB2342', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhaochunwei', '赵春伟', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '384C7FFD52854E3BB7B37447107D0899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhaoyc', '赵玉成', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '18DA1304E99945109F5D1389874B1A01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhangmy', '张明月', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6B4E7B5A88D84BDCAD2F2B77599942DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lili', '李丽', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '50D2F4347FBE462DAD8422B5B18A0A88', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'tangq', '唐群', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E245C4D08AEA4E79AE36E1DB46538643', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lisha', '李莎', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D58331A857FA4ACFBC6DB42BD22DE144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'xqzyy', '薛智勇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '51B1A60C608746CA98E0C319F638C2A1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'wmg', '王明贵', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D5E94BB964C34B8496DA5D0F3498C34B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'guojing', '郭晶', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '351E67723FDD4A8FBE6A40E829341993', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'fudebin', '付德斌', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3A649022CC3B4D50A8A32BF8F9242D4E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhanglw', '张立伟', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '72EAA290C8F84B7C847FF5DFE81EAF30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhaochen', '赵晨', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3B1DB4A141D845DD9832FADC9F991DC8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'wangguoping', '王国平', '领导干部管理办主任', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F31C48A78DE54E7994C06C1829B3E6BE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangxu', '杨旭', '杨乐', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '341CFC76198F4BCFBB3AFA4233831FCC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'huangjing', '黄静', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4FF3711E3E614AB48EDED4F5E768A9EB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hechuan', '何川', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E504EEA4346248BFBF788F5D01D331FA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhimin', '智敏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D145AF70A69F45AD83D7297F168C7A9C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'houfanglong', '侯方龙', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4903873A2F3B43EF9CC56DBF106EC7D0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'xupei', '徐佩', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '038A850C90944E4093FED735141F57F5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yuett', '岳婷婷', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '42EEE877A07944DD8DD2848A1D0B7997', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'liaohaitao', '廖海涛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DDBDFB00DBB94488BC2A39EDDE0F87F9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'ehr', '人力资源系统专用邮箱', '彭潇', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '558F67CE0F734BD78CD5925C4AC5B145', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'rlzyb', '人力资源部公共邮箱', '杨旭', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DF3283BFC1EB447783885099CC287EFC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hrtest', '人才测评系统', '王国平', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '93E9682C73D84166B88729E8A2682420', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangle', '杨乐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6F80923C16D344ECB8F9210DE5E03D2D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'pengxiao', '彭潇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6257C0E3FED447738C75AA792981F9B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'zhaopin', '人力资源招聘', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B32D2138A0F847168D75AB189ECE4CA2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'libin', '李斌', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '92BD73F4C35D48158D7037604EAFA641', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lipeiyin', '李培寅', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '15D4F5D8FF9A457AAB480FD1F0824F7E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyuan', '章苑', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B9941ADCC90944079FA3396A71AC6FF1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'muyan', '穆焱', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DEEEF81FD7BE48958638F51A059275D1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liangmaolei', '梁茂蕾', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C87E4F9ECDE5419DAC1D7DF75F6961D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wanlina', '万莉娜', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '93FBC76919E24679B28A7A648BA44A59', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangying', '王莹', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '47B5B7F00D2B4F829BC9E2277644CCBF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lynan', '林彦男', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F157E4F5035C46C19E6C2EF3D27D3060', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'xuxingxing', '徐幸幸', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F12E6521007C4B10B56C2FB358629AA2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhaocx', '赵晨雪', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C94508D8FED24621B09CA716F0E192CE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'luobaiwen', '罗白雯', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FC24AFF9F2344119BD0B9D8381376A46', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'sunyitong', '孙一桐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E8A674826AA34C5FA09E34F079E0B490', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangt', '汪涛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9AF16088D1EE48AD82CF2ED5D23347F6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'huangzy', '黄卓妍', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B8A07DFCDBAC4B22A1461B5618603B60', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'suirong', '隋榕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8E8F6D5501354A3A97D6ABF5AC37D333', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangjintao', '王金涛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '01090D0A60DD49DDAA5BB14FB0213289', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yanailing', '严蔼玲', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2CD3D6FBBFB04F07A33E25CAF0A08F4B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangf', '王丰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '90C49AC66842492D86AB25DA2374CB3B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liuyx', '刘彦希', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '55CEF0544AFB4F2396EF8E97A9F5F086', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'fanxiaowei', '范笑薇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4B8CCCE2EBA1488FBE096BAC84A342E7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'maoli', '毛立', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9DCC4DBD95E944FAB2AB7EC1EE1AB3D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyundi', '张云迪', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '375E050C59AA41248104DF40784CF575', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'chenzheng001', '陈政', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1466461A0ED14EBEBF9F340858EBA7E5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lh0020', '李辉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6D7E3E0C146440E79359237AB319507C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'chengyijun', '成一君', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '11A5936C1DE047AAB330B983B76B4DA1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lvzhidong', '吕志东', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B238B013A1C142CBB41EC5FA48F0F34E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'xuwei', '徐伟', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '81BA1DA3380D48E597FF6A8712C61282', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'jiangqingxiang', '蒋庆祥', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D7BA6A45414F466FBE3717DD657F1662', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'dingyong', '丁勇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5971B28835644DE7A5B47FF20E21EC78', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'gengjianxin', '耿健新', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7F3D1873D6EC482B9C288DD675E0879E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'yinmu', '尹沐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F899B71DEB1C4131A1AFFAD6CD488BC5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'nihong', '倪虹', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '67F59727FFDE4497A73125773528D04E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'yangxi14', '杨茜', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3C6AC3AFE0E34E22ABEA029651B37F42', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhouyue', '周越', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1AA99E8F261743409E7289387F01F708', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhangfutian', '张福天', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7D9E6C6747A945EBA63500D808032D29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'miaoqing', '苗青', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '856E985093C548C28EE90260D2E7E80E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'mowenjia', '莫文佳', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '38C54FE7F3F54F269E2A7D61CD98BB85', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'liyangyang', '李洋', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F87FEDAF53614630826AAB60F1543AC0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhqy', '郑启源', '公司专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4A38BF9A4C3047BD8548601D7FF7E187', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'guanlq', '关力群', '公司专务兼行政总监', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A0542F9A6EF04387B3313F75FB26342A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'licn', '李承宁', '公司专务', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '71D43C9DBCD843BDA7691522126C22B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'liubinliao', '刘滨辽', '贸易部副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '97C90F78E05148069D92976D8A6AE073', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'yel', '叶岭', '投资公司总经理助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '319AF3E49F0F448BB70ACF0360048323', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'juyanfeng', '鞠岩峰', '投资公司总经理助理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F270A55D4C3949338C41FAC0F4506916', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'fangdaojun', '方道军', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7CDFE82924F240DDA83CCA8D4A8D94BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'waferlinjining', '林纪宁', '财务副总监', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3E167806F5D74511B8BB7A06B6BF22BC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhaoy', '赵扬', '财务部副财务总监', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7D1303F2F34644649E3C4B5BE30FB0E5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhousha', '周莎', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1C0A9AFB9D0C431885D64E40CFFA2A92', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'wafertangir', '唐岳震', '总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BFE8144BED85444689D4B77E0E98001B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'lihao', '李昊', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '163135F722BB4B429D6268D4B1E8B40A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferfengqiao', '冯乔', '总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3FD1370D668E4F1185FEE72CBC542BE0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferzongdian', '宗滇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '88D9257DFAAE4DC9883E8098097798B0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'zongdian', '宗滇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '051D7DF28F874B84B790DF9CA8379CE0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '柬埔寨代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun', '孙会兵', '总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '371149AD35B94F0F9AD24668A1574AF5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度尼西亚代表处', NULL, NULL, NULL, NULL, 'waferzhangchenxiao', '张晨虓', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '067D506E7C5E4ED68508D54E92389558', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度代表处', NULL, NULL, NULL, NULL, 'luxiuchen', '陆秀臣', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '84C86A9330E34F92AA24AAD33D07B193', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liduanchang', '李端昌', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F89E0A8BD1E149ACA130D2F6E82E93E6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'linjianxin', '林建新', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B7151253CA8E42119B7B12AA33F4AA06', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liuanghui', '刘昂徽', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '61F53F9568184FAEB3A1316EAC3D106D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', NULL, NULL, NULL, NULL, 'jinxi', '金曦', '部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E591FC0B06F146338B2B07155B9A14BA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangzhenxing', '张振兴', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8AC55961B9C24BB4A21B15E6167D9C0A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangxiaofeng', '张晓峰', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F9E733AD6B4B4E4EADDA89B695930B91', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'guojiesi', '郭洁斯', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4112AACB0DDA4CA4AE02EB02BE6E6A28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'liangxiao', '梁霄', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3516899B86534A6E8056B1D18B3F5B7E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'yuxi', '于曦', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0237A27901C94A7E860B35C2B94F1384', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'fangzhou', '方舟', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1C6DE5FB24F140838F513F4EA6CF3A23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'wangda', '王达', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5DCA64D9E27C4489BAD82DC5D9EE820E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'chenshuai', '陈帅', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '11FFA7F8A0D74D1E981116E542D4DF90', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'chenfei', '陈飞', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '685E9B9B2E264EAD867D7A4B75432FEF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'jiangshan001', '江山', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '36750CCFA8F544BAB33082065A05AC97', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangxiaoke', '张筱珂', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '73E16A0FC24549EFADAE2A3AB2398491', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangyi002', '张祎', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BE57EEDDA0804C4FBAD9E430EBC9A3AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhayong', '查勇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F027D5B1044B4F72A54254F99212FB78', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'zhaoleiyu', '赵雷宇', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5ABE400AF6694EEFAFCE904433FF3423', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'liuyu', '刘宇', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '300011C12E1A434F8B5923B2B24375E0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'lilei001', '李蕾', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0C78272A72504A00BE818D8AC2C0374B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'tianchunyang', '田春阳', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FD42CF151CBF43088F6CEFB4ABE631D6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'houjiafeng', '侯嘉峯', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '17BAD8F42BC54F42A230DFFF4510CB57', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'wusimeng', '吴思萌', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2531C366D278456B8244A5978873D0E7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'jiangping', '蒋平', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1EE12FF5EDD64DB9A7326A4BC85829E0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'lht', '林海涛', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '93F7683A98064D3BAEA3A5515FD48D83', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'guojiexiang', '郭杰翔', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '32179AA0E2CE498B80534EF43930AC60', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'hubing', '胡冰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1AC1ED56C01C40738946E6C22AAD9000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'wangxiaochen', '王晓晨', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '44841FB190E545B7B19BBD0CFC310DE1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhanglu', '张璐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B3B094A3198B471BB2835DFA6B775EE6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'fjcwurui', '武锐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '16062A8716C04FF094A87495E440FB82', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'huangbowen', '黄博文', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '148BA93707DF444A83968EC65A10852F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhumingshuo', '朱明烁', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '75D838BE83C84CA180D0DC77D9185851', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', NULL, NULL, NULL, NULL, 'guolichuan', '郭利川', '副部长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3BF83663E3C54935B0CABBC6A1A7C530', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaoyajiao', '赵亚姣', '处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4F93EF932F4B48F19AF4EFC088D9CDA0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yinjie', '殷杰', '副处长', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '872BF7E292994BB7A39143790280ED32', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'jiangyuting', '姜玉婷', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '405CB21A243840F4B42358863FCD78AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'lishuai', '李帅', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '33DF613C5AB54B5EBC853D8D1CAB8FE5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'sunyan', '孙妍', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'FC26336FD2E14001A1C3FA937816DA01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'wangyang001', '王洋', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E45D5ACCB3394A0F98480B608947D8AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yanjunxi', '闫俊羲', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8AE3D96D008A4799B9529C3E0407E7CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaokeqing', '赵可卿', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4A26E77EB39C427FB4CB2BC12DF66AC8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zuoxinyang', '左心扬', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7C4D5B3764DD41FCAC7287AC90CCCA82', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'lisonglin', '李松林', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '844C8CF8DB874CF5B5B52B194134B9D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'duanbaorong', '段宝荣', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A39668AAD9CD446D9E40DF79F6C97EDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'songchao', '宋超', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6CF41F8E1D4C4C12A73171C7490489B7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'wangxiao001', '王潇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '231E0D4E0DBA4DFC83754527DA70E7C7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'mada', '马达', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E9DB522EED254D50832F7A33F0A4125F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'huangsong', '黄松', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '00E735D66C744C0E8865E2B4B9790DD5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'guoyongpeng', '郭永鹏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3FE0AAE576AB4D1692A3894237C74055', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'xiongkai', '熊凯', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '90B199471A6542338B2B82A66FA84E88', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yangzheng', '杨铮', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9FE13A87C5F1414FA2AC3F11757A62E7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'wangyao', '王垚', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'EC9B2AB50ACA4174A9DA17056241FF00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yanxiang', '燕翔', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6796E551EF2D4C72AB18DAE958753B08', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'luojianbo', '罗剑波', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C1C84FF275504D699BBAF856B3B65749', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'liqing', '李青', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7574D1D204BA4C45B51E9B09FC83E0D3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'lisihai', '李四海', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '523E9BF2D7E84818A895628E1AF8003C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'jiangboqun', '姜博群', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '520002E665734209AEBC6966C11F5172', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'chengenhuan', '陈亘欢', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A27DA2E11E4B41F5A61E382A7485EA35', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'yangkai', '杨凯', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5405BBA8A90E4E97B8328C1074C6A2AB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'cuihai', '崔海', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '53CDAB8A7AB54119B962A5C844FA2ADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'gaoqi', '高琦', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '17F60EAFBC7243FE8192BAD901B7249B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'zhaobingxin', '赵冰心', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A6A192433ABF447A8E975C4E160B0DB6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'ahelibai', '阿合力拜黑那提', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '97DACD25A6944CC0A1159D2B02BCDBBB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'luli', '吕莉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1630291BDAFD43C5A36B2218276FC818', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'cuixiaoqiang', '崔小强', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '009A364442BD407A92E970937A57652F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'qiulij', '邱丽君', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8E2717993D76425AB69672F7855B2143', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'feibinsong', '费滨松', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7A6603C87CB642C895821610B5E57890', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'suiqing', '隋晴', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '83422E3C5F964EFB9F395012E9A703E5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'liyixue', '李艺雪', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7F70F4F57876483DB84AB355903FE830', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'guoyuchen', '郭禹晨', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '381D242F1C41421FA89178797472B60E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'wangzhen001', '王震', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2EEA9F9657AA4C76AB1580B0C56AD6CF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'baofengling', '包凤岭', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DAC453F31BD245E6AC161BDBE86E97B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'wangyonghong', '王永红', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C72FA9FCC5734EF68AC35AED79FD7690', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liguanchen', '李冠辰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D976254585BA4192948D59F8129AA229', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liheng', '李享', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1B23D412F03D4C2FBCB97CDD6D5E13C0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'zhaoweizhou', '赵伟州', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '93C6D8BD989943F48685B0F4E9E0C6A1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lpr', '凌佩冉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '94A5D0BFF8E3465F934C30E3AA0FA5D1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'jiangsongyang', '江淞洋', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '650799ADB8EE4EC5A99C5FBCABAD6929', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liuzaiping', '刘再平', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '724D93855206419B8CB22595EDB14C29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'lixiang001', '李享', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4A8273E475B14121A10107B662D79FD2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'weiguangjie', '魏广杰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6FF3C044B83C46068DC4E15B6E05017E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lishichao', '李世超', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'CCE2D42886A7490E9CD96563ABDB2F83', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lh0020', '李辉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FF01306F6F63474D8330AD1343235AA3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'chengyijun', '成一君', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5C01EC4E1B0A4C63BCE5CE43AA5F6E32', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lvzhidong', '吕志东', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D7B7E604EFC04F028521272DDB97049D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'xuwei', '徐伟', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C7F015AFEF0A4887BB55FFE05EF5106C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'jiangqingxiang', '蒋庆祥', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7EC184D275964CBAB6DE21916E4790D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'dingyong', '丁勇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '245F8158050444CA81FAA86BD7B615E0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'gengjianxin', '耿健新', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AD1E4526E119411FAD4ADD6129AE2703', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'yinmu', '尹沐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3D94D386E83247D494163DAF7A6EC5F2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'nihong', '倪虹', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E1E7CACA2ACC45BDB2E133DB4E04FDBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'yangxi14', '杨茜', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '22E86B4282E74BCFAE358CC1F40638DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhouyue', '周越', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AB41D71CA27941DBB1361C38053FF144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhangfutian', '张福天', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2F88BDFD147042569E1371A8B0DF956E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'miaoqing', '苗青', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '37D7A54FB8F9492DBE4622CF8A7BC48B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'mowenjia', '莫文佳', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '259108F55DD846EABA71ABC2CB16461A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'liyangyang', '李洋', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '524DF925880544BEA1CB7893CDFAD4FF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'hanxinli', '韩新利', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7739C1CC0A4E483F807FD2F29C0614D0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'hb', '韩冰', '部门副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D32ECC91AA13494D841583D59C06F821', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'gaonan', '高楠', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2826F7FDE42946F391F48CC786BE7A61', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'momo', '陈默', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '43BC3C4D328B43539F3A98659A695A3F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'wangshuo', '王硕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '066690BDCA7C4C9DA05950330D08C430', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'jiangh', '姜辉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BAB7509367A3461CA60BC4A1FF4E4C0B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'yangth', '杨天昊', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '658C611EA667469ABBE3A804F61B5FDF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'zhangxiaof', '张晓风', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BCB4DA4717FC48C3B5EC24124C09FABF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'anqi', '安琦', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '75265E633B5E44FE932CB6EBF174598D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'liuyang', '刘洋', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '93D44556DD944065BC9743080018F6A0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'qiaosen', '乔森', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '024507D6735B49D285A128107F17CA8E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'zhouyong', '周泳', '部门总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D68BA8AEE8B440FF8DD684675910E215', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'sxg', '史新刚', '部门副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0EDE653971C1468C891EF0A75B384F09', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'beil', '林蓓蓓', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2FF2564A5721467FA112E78A29419861', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'yimin', '伊敏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '94F594FF621B4E3687434507B54A21E9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'zhaohao', '赵豪', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FEC934E8EB684CDDA7E14472A6628814', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'wuzhaohan', '吴昭含', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '70BD0900F6AC453496406695E4537E16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'jinyiran', '靳怡然', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2FF88162AC6D448185091BD3F8863EB9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'xuchumeng', '徐楚朦', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D073259173F94A568326FF5A64F96D7A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'fjj', '傅金鉴', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '09649E1D45DF4FAF96601EFE0C3C727B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'gaohai', '高海峰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '99233AF4F5A649E6BD6F150EF59F8430', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'slj', '苏立军', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '262BF2905BB643F0B3B0FEFBF81B595D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'majinghuan', '马靖寰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1B1120299ABA4D459D5929624D40F88E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'huanglingrui', '黄泠瑞', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8E3BA4E8E8864960B6EC74F56462CA63', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'getong', '葛桐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FE57C4D7567D429580C2D7CD8508C309', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'liangpengfei', '梁鹏飞', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3AE5F64A4A244BC3853C539C26C8870A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'wenyanping', '温燕苹', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E6943472E48A473EBECDBF4C300CDD9B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'shibiao', '石飚', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '25A07BAD98CD4E99ADBA6E1A600D95C9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'hanxinli', '韩新利', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '42416867DCCF463E9CE7C7EF9C460235', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'hb', '韩冰', '部门副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BF3A63C872A840DC9CA7846C7FF81208', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'gaonan', '高楠', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '270EA71E32C94128BF71D7D0E47C86E1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'momo', '陈默', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E1F2655D2F3E42998E5760F80C0F925D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'wangshuo', '王硕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0587C5506ACF46EA8A3DEA7350413B36', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'jiangh', '姜辉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A8C7CC2A44064AEDB7CAA3B8FD4E4D4E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'yangth', '杨天昊', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C8F86A94BA3D4A25BF9AC85674CC3950', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'zhangxiaof', '张晓风', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '96D49C7C9A0846A38F46A972CA703AC5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'anqi', '安琦', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B82E83DF425A41D2A28EFCB04B64F9AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'liuyang', '刘洋', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '264DBBB46CF149DCAA3131601FC80DC0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'qiaosen', '乔森', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8D64247568924D95A3DD062E7A243844', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'zhouyong', '周泳', '部门总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '68EDA34E302A480E96C2B3FD9F81EB1E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'sxg', '史新刚', '部门副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AFB43E5575854B04BB2D8F5A81D65633', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'beil', '林蓓蓓', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'CF250D35DA164AEBADDD27C670327CCB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'yimin', '伊敏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '76120EDDB548488E8FC1C9DA0BA1DC9F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'zhaohao', '赵豪', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D634F9C87CE24A11ACCD74508AE05159', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'wuzhaohan', '吴昭含', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B21D1034120A4B16B6D6E53D4BD6718A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'jinyiran', '靳怡然', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6CE9D0E55C644B41856614C8C79D9246', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'xuchumeng', '徐楚朦', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E076D5515E47422FA940B403BCCC71E9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'fjj', '傅金鉴', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0E703D42EF284C5ABC67D963C5BEA1B8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'gaohai', '高海峰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D23D3A638DB74E6397EC8F76756634B0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'slj', '苏立军', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '31EDC1AD17824BD386FFD623CBD6EAAB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'majinghuan', '马靖寰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0F0940CA846A434CAF733D52F1F65B8D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'huanglingrui', '黄泠瑞', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3A857618B2B04BF78AFFA3AD6F96D21E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'getong', '葛桐', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D177AFFAFBE44C95A4FB3B4F47230692', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'liangpengfei', '梁鹏飞', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '28936A4A167747C98774CAC8709D687B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'wenyanping', '温燕苹', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '06636E980073488CBA357F2CD34AA4C3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'shibiao', '石飚', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3E6DEA564FEE40B1B53ECFB0DDBE34B8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'chenyan', '陈燕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4CF7054C2DDF4BD9B361986FF1744BF5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'yangyuewei', '杨月炜', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C2EDAE3EF88F420F80646D7ABD8A9002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'lzt', '李振堂', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8BE987AA562E410B9EE13A030EE8B9FF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'niyang', '倪杨', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '99EBEFEEA17142C0A34EFE23B051552B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'jishenxin', '吉申莘', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0C32DAAC7AB14904A900BCECA40CE4C7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangruoyu', '王若愚', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '21E25DF61581450C931CA80D3AD3970B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liuxianghui', '刘湘徽', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '327DE60451E14E6CB09589B5675A6C59', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangnan', '王楠', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F1D3FC467011487598488196EEBAEF34', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'zhangkl', '张凯亮', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6B69BD79AF59498E8798725E664A63A1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'panyu', '潘钰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0BB026CBF1864AE8AC749A8165D962B4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'shenyunzhu', '沈云竹', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BE93F15A1EBA41BE9673276229848232', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liqimin', '李齐敏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9153FF94F2FF43DC9E7E1317D9823D5D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'linsong', '林松', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '68E049C5E3DD4698948F8BD1B3B5871E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'zhangyan01', '张燕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C1602AB8C82747B3BDBA83E9A4AEB0B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'lijing826', '李晶', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C9B33A8F138F4AC79502169230FA6226', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'mxj', '马晓珺', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3306B76CDBA045E7AA506F19DA808C1F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangxuan', '张轩', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'B0481312FB59486E9A496A2FCA208B3F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yuhao', '于浩', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '33C2D573D2ED426B92FEC3FE474E8293', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangzhaopeng', '张兆鹏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6A7851E973CE479E9A02AE0FB0E40CB0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'daishouhua', '戴寿华', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A1727920DBB3464D86599BCF77CEF523', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yanbaohong', '闫宝红', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '012D2CC766544E288CF4BA23B74628D0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'lihongjie', '李鸿杰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '556044961C034367A08B92C47E6F5E22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'wangxuejiao', '王雪娇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9099BEE2E9D14F4B8A28036439F1A16C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhudan', '朱丹', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1F22690938AF4C97B6BE2D2D7ABF985F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangshuo', '张硕', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2CDBFC9733CA41E49E59F0D99FADC844', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'shiyanfeng', '史彦峰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9EB3DF4D49A849A8B010FBDEF3EF522C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'yangkunbang', '杨坤榜', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8F7BD84C837648EF8B7C360AC6083EE8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'lisonglin', '李松林', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A5FA11F21FDD407FBFD236579335B412', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'duanbaorong', '段宝荣', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E5FACF6E0BAA40ADAD0A21AADBB6BB54', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'songchao', '宋超', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C68C51CE1F1B44FAA7264F497DE2FD30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'wangxiao001', '王潇', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D5C6A0B597B54C0A925FFBA78D2ED6A7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'mada', '马达', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '97A951C3345744608FEF3A3C08B9AD75', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'maliang', '马亮', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4AF565AF9A9B408CB8EF655C1F3B7F94', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'huangsong', '黄松', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '86D1711A48EF4CCBB428F4507558B463', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'guoyongpeng', '郭永鹏', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '15008AF5865A434AAE5DB2B367B1941C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'xiongkai', '熊凯', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '86F15A0CFA3447128061BDBEC08F255F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yangzheng', '杨铮', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9F122FD2AF384ECD972F2F134EFFC7F4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'wangyao', '王垚', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '89A6C45592F14DC5BEF40D9755B957D9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yanxiang', '燕翔', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'DF1D2487F0F14B3D95DED90BAB6E5636', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'luojianbo', '罗剑波', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '21319AC300F24D8EB617BF71FE367059', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'liqing', '李青', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0AF3AF036C654C6494FEEE80B778D0EB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'lisihai', '李四海', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5DC7C0C70E734B788B5C4150D5DF7B36', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'jiangboqun', '姜博群', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'AE5BD7571F9E4A9AA351DF49C13E3503', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'chengenhuan', '陈亘欢', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '4BDF1B096DEB4383BD096B802E9DC35C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'yangkai', '杨凯', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9AE980EFF41E41668DBC843CFC61A9B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'cuihai', '崔海', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '690F18BBA0B043A684EAE38BA883886E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'gaoqi', '高琦', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1D1FF2DEA97A4DF59F65CD474EDEA38E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'zhaobingxin', '赵冰心', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D6A73BB96DF640A89CF99D993CD462B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'ahelibai', '阿合力拜黑那提', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'CA94D6BC0BA0404EB874CA3534EA5EC9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'luli', '吕莉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '784D1AE46568442985F5DD50719FB939', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'cuixiaoqiang', '崔小强', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '47780D02B41B45EC99070E4A40490FB5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'qiulij', '邱丽君', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '44B677A6FC334B7BB03ADA5258D09FAE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'feibinsong', '费滨松', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '20D3C822B43645CE89539B9B4DACEB51', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'suiqing', '隋晴', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'C945175D35C94B8CBA54419CE76B1042', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'liyixue', '李艺雪', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8ACC42C92CDC4C729EF35F9A4F964B29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'guoyuchen', '郭禹晨', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3727C3F6E400450385973D1E322A3DCF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'wangzhen001', '王震', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0024E595F09E4A0B9A7BBD4FD1F7C0BC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'baofengling', '包凤岭', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3011E1AB3D9C410F9D604ABEAA019697', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'wangyonghong', '王永红', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '24AF4059C2984C4E92BE25786EF13811', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liguanchen', '李冠辰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1DAEAE8C4F49471FBDA663022F83A959', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liheng', '李享', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'EB640356C57942E9A1AA02AB5722C314', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'zhaoweizhou', '赵伟州', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E43F85FE0082403B8F260419F5202B76', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'jiangsongyang', '江淞洋', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D210631EA4924C39AB424CB252B4C90B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liuzaiping', '刘再平', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '83B0FAEDC72A46308133EC23A6F0D9A6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'lixiang001', '李享', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0A6FAE9D4E9A4AC6ABA12432CF46873F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'weiguangjie', '魏广杰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '970A1D7B21CE48C78D6AA1568D7F5E44', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lishichao', '李世超', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '491D531D156C42DF9B0160B1473E0D45', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'wafersunhedong', '孙和东', '副总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '78E9B0AD905545548115D4356E0EF894', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'sunhedong', '孙和东', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '895DB9E33784497F9A6E1EEAD2F94707', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '塔吉克斯坦代表处', NULL, NULL, NULL, NULL, 'waferchennan', '陈楠', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1B91838464F7472A86C19EBB58F91548', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '老挝代表处', NULL, NULL, NULL, NULL, 'zhanhongyuan', '湛洪元', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2D2B44066F6243AF820680F73F7FE3E9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '肯尼亚代表处', NULL, NULL, NULL, NULL, 'avicct-sutianshu', '苏天舒', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '73758C1267C043E4995C65F9053F5ECC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '赞比亚代表处', NULL, NULL, NULL, NULL, 'wafercuiji', '崔季', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '87FC2A445398441C86367FEB6D322E2D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃塞俄比亚代表处', NULL, NULL, NULL, NULL, 'wuping', '吴平', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6B2C9619A40A48848C113FF80C0147B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃及代表处', NULL, NULL, NULL, NULL, 'waferyangjinshan', '杨金山', '副总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'DF8CBAF4A0B540D8A1E7E62C42870EC4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'lihuan', '李欢', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5A866A74F31A40F588E9052FB20EC35C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'yangtianhao', '杨天昊', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '57B6A0FCBD98440BACEC20674B24CC81', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '乌干达代表处', NULL, NULL, NULL, NULL, 'waferdingsonghe', '丁松鹤', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D49F62AD5D884AB6B5E7A360F525EE54', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加纳代表处', NULL, NULL, NULL, NULL, 'waferyuhongpeng', '余鸿鹏', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2E260E3A7C144C8F99522BA8EE87ED65', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加蓬代表处', NULL, NULL, NULL, NULL, 'wafersunyang', '孙阳', '副总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '379CF02C7041436E99670047C89DAE8D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '刚果代表处', NULL, NULL, NULL, NULL, 'zhangxf', '张晓风', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '03E3451C471A4F3E8D3181E906A25973', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '科特迪瓦代表处', NULL, NULL, NULL, NULL, 'wafertangzj', '唐忠杰', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '609E70D8C847482DA3B1BA58F83B0936', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '津巴布韦代表处', NULL, NULL, NULL, NULL, 'wafermachengyuan', '马骋远', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '6A173980228A477DA232F79DA05C0F57', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '莫桑比克代表处', NULL, NULL, NULL, NULL, 'wafertierigen', '铁日根', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '5504E47B44144390B8316D5EDDBDE74C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '喀麦隆代表处', NULL, NULL, NULL, NULL, 'jianghui002', '姜辉', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'DC8F8CD604134DA2876A9BDE217CFA67', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '尼日利亚代表处', NULL, NULL, NULL, NULL, 'ganlijun', '甘黎军', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'DCFCF1EB26E945438CB683560032BCEA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '安哥拉代表处', NULL, NULL, NULL, NULL, 'suiyongjie', '隋永杰', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E0BE62F55A474CDEABFE28ED8B991B4E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge', '德国代表处', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F04C68F0353A416881B18C9DD85BAB6B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge-ltd', '德国公司', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7D2DFBC73A34474D8D40A878FC989186', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.germany', '德国代表处', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'DAAB9CABC76E43098FA1834A372D497D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'chenzhen', '陈震', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'A71D11A68A874D268AEB302C72E632AE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'liqijiang', '李琦江', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3839A85E482C44639279CE8DABDB33C6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'sunjian', '孙健', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D39076B582564FC4A0E9F4F9B575424B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferzhangyulong', '张玉龙', '财务代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '30A30958AEC5471D85A645281F057BB9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferliyudong', '李煜东', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '47C60A3EF01943C88E8353AE3A33E545', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermikelou01', '娄玉成', '总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '8D70A5A318874E36A80FBA32766F2667', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'waferwangsh', '王双', '财务代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'D87E1DBD387544739F5C9CEBA9CDDEEC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermenghaitao', '孟海涛', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'E7A5A2622BC246D983310A0BC7A6D330', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国公司', NULL, NULL, NULL, NULL, 'wafermikelou011', '娄玉成', '总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '2F914EF7DD4C47F893AE4C207FCBD00F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '德国代表处', NULL, NULL, NULL, NULL, 'wan', '万春雷', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '0D7DF3BAE6CB41D690B9E22C43325AE5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '俄罗斯代表处', NULL, NULL, NULL, NULL, 'waferjp', '姜萍', '财务代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '34670E38774448618736E6D84BEAB7A8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '挪威代表处', NULL, NULL, NULL, NULL, 'huanglei', '黄磊', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7EB3A5B8B6D0425B9799E4F3A8BEBB07', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'zhangxuming', '张旭明', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'BD7F004D49F14188AF6EFA073C3331D3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferfrankyang', '杨方', '副总经理', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '9D50B9499A0E48BC8BAD4AEE0F769135', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'hanke001', '韩珂', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '99EC997F1D5E42DFAD1CD0E95AEFCA7A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'emyang', '杨明', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'F82996B44FB24DC18B8C3B114D930C00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferliusujin', '刘苏晋', '财务代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '1928D7C1CDC647FCA4C254AF426DE6F4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哥斯达黎加代表处', NULL, NULL, NULL, NULL, 'waferlingxinwei', '凌欣伟', '公司代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '3253666F3A41483BA0D62D34C2ED4ADB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '古巴代表处', NULL, NULL, NULL, NULL, 'miaojingdan', '缪景丹', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '49E41D75AA3149D6830CAA0FBDCEA19B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '巴西代表处', NULL, NULL, NULL, NULL, 'pengbo', '彭博', NULL, 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, 'ACE11D9BAE394918ABC0F60977177DA9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES (NULL, NULL, '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7865D145A3824A23B66B4E903DFDE67A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', 'B1C359ADF149427EA4722B2DBB4FF2C2', NULL, 1, '7CF5DB247D6E4954BEBF1D54A9B6F8DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '董事会', NULL, NULL, NULL, NULL, NULL, 'jyan', '焦燕', '董事会秘书总法律顾问', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D301EF8880DD4052A6F3ABA63532B851', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liuhd', '刘洪德', '董事长分党组书记', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DC577D42D874480AB3BA14BC9CA79DDF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'wangxiuming', '王秀明', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '44E13E10B75C421BBD2E014A487F8C26', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'laiwx', '赖伟宣', '总经理分党组副书记', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3EE2A5BBE20046898BDE1590239136B4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'chengbz', '程保忠', '分党组副书记', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3FA712E0FF234CC8AB6E855EF00DB623', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liujun', '刘军', '分党组成员副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C4EBA7B5376A417EA861A1A20371A990', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhanglu', '张璐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C108963A4F414B9DAADA5F9DAC4DDA14', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'fjcwurui', '武锐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '66BFAC6A1AD242C680F1970AB0450CBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'huangbowen', '黄博文', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DFBCAA9EC17342BF839110545041242B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhumingshuo', '朱明烁', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CBDFF02D447A478EA202A2DEF15D4CF2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', NULL, NULL, NULL, NULL, 'guolichuan', '郭利川', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5E4CAD5DAC7C46B6A0EADF93926A5CDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaoyajiao', '赵亚姣', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7644AD442C244677AB3F89CA7C2F1F08', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yinjie', '殷杰', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AB0D139C7F734D5DBBD56392C688CA04', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'jiangyuting', '姜玉婷', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D6F56FCB1BEF462D901990B091BAD6B1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'lishuai', '李帅', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5DC3996EFFB8496A85200EB4FD860134', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'sunyan', '孙妍', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DB0CB74B234A42A28AEE8E74D91BC762', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'wangyang001', '王洋', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '401392EA5E9E44759309126161791E9A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yanjunxi', '闫俊羲', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A511B219C133458289A0BBD22B4A105A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaokeqing', '赵可卿', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F9D9EDDDC9DA4CB596796F5CB7FF6BEF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zuoxinyang', '左心扬', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C27BA67530AA4655935A5BA5F68F73D1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liubinliao001', '刘濒辽', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '911813553E64471382B296367948F65B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '董事会', NULL, NULL, NULL, NULL, NULL, 'jyan', '焦燕', '董事会秘书总法律顾问', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '59266B0FE5324D2B97C39D819781DC8B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liuhd', '刘洪德', '董事长分党组书记', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '011E90A6F90E4C9F9610835A16E03AB8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'laiwx', '赖伟宣', '总经理分党组副书记', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1CB54B1AF0F344B2AA05E0FC17D0E776', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'chengbz', '程保忠', '分党组副书记', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DB810C1B96A7499D97A1E115E69D6B45', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liujun', '刘军', '分党组成员副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CAC82D672A104235A7C8767977EB3016', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'diaoweicheng', '刁伟程', '分党组成员副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '48B224CA6E7740EA982539CEE35B00A3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'hanxy', '韩晓阳', '分党组成员纪检组组长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F2F702B436F6409097A456F800935DCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liqifeng', '李其峰', '分党组成员副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B559FF48520D43B88D72425530ED890C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'fufangxing', '傅方兴', '分党组成员总会计师', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EF69CDE4EECE4D3ABE1734CB8BDE5268', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhui', '张辉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F08991A643C946E7A1935F778DBC22FF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'wentao', '文涛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DF3C4EAD0DF64CD68EE9A07F0F5DFD9D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'huangg', '黄光', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DD3A548C356C4DF39F007407ACFBF9F3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'yangyouqing', '杨有青', '高级专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A5DB79251DE04A9DA5BAB4402CB2A164', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhangguangjian', '张光剑', '高级专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F84FE4A285854AC39E7DDC8334746FAF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'xiaoyi', '肖益', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EFECD540FCFB4AB58E9E871874359499', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'chenhongguang', '陈红光', '离退办主任', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '08BAD65DF80741C58696420156683270', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'czg', '陈志刚', '安全生产总监兼副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0E41DF1975A746BDB80E0317B73C6778', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liu_jie', '柳杰', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '37E2BEB591694D68BEBBE5E7B189016B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangkewei', '张可为', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1B9B53D0120A4A5D8EC309DC655BC1F3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangxudong', '张旭东', '业委会办公室主任', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '76F2EBC70A27440DA566146A395D8E7D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lisiqi', '李思齐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4AA652A7469B48EBB0475D46C81DA894', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'panwm', '潘为民', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DCDA29C1DA2144C8BA502F759624695F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'linjinghui', '林敬惠', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D7832B526A8C4640B3C26EC1F8967AC8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'yangqing', '杨青', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F8B84779772444C3B61A313FCEC85AB1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'shenfeng', '沈枫', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E792B4469BE646EE96EAFFFFE437460B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wulw', '吴力伟', '车队队长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8762F2B6464D414EACAF7462A8F45C1A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wangqian', '汪黔', '司机', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AC74E70A4F37457793B1568D93355F8C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liushujiang', '刘淑江', '司机', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3A2C91179DFF4DF585CCC6C8297DF259', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'qilianghai001', '戚良海', '司机', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E28C5C56B00D4F68B049AD9C234BB3A7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guanxu', '关旭', '司机', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CA0626B9A7E1407B8D60DED106FA1324', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'luchunlin', '卢春林', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '13C2FB272FC34C0B909F7882DB9D73F7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'meetingbj', '北京会议室', '林敬惠', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '851ACD3384E040E4B9B9C7D11ED52AB0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guoyuxi', '郭宇溪', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2B0ABF3A6AA241F38051A850D27164E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'sf', '沈枫', '公文', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '71C9E9F79E4547A38D6067012CA2A581', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'avicbsinfo', '工商信息', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8843F4CF6411444CBE9E5F640ED2ED67', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'sunyu', '孙宇', '董监办主任', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9EBA083D1E824B6DAD7812B2A532AD21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'liuyi', '刘裔', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B03540FE720D4969B047032D00E174D0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '修史办', NULL, NULL, NULL, NULL, 'hbin', '黄斌', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '20179A61C3FE42E1A5CC48C45453107E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'wanghong', '王红', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3E5AE8324DC94B028B2FBAB5A40F8821', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'luanht', '栾海涛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '18AA6075ADD743A98B7030E4BEFE30CD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'fangxiaohua', '方小华', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A2E69B6CF3544C1AA60AF78E0AA9A557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lixin', '李欣', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D1AD24A2067046FC8DA5CF9A3F4608B4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'shaoyong', '邵勇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '69485F6958374D9F8722C96B19A0B411', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicstj', '中航国际苏同骏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F627EFA8B0E542EBA059EE069120A413', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhangjie001', '张杰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CBE680379A2B41FEABE2F78DCA64C7CE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lcgem', '李晨光', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BA1154CCD82A4BA6920365871F9D365F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'hwh', '侯卫红', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EDAE22E02D014A28A6B3074BA75F1303', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'nijiaxu', '倪嘉序', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '60D369C0CD1C486C86A0527DD7FF00E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicszg', '中航国际宋治纲', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '48A95214FF2C47298A5DFFAD915C88D8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'mzhy', '毛周勇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'ECFC251F19CA454392CB2198751445E7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhaochunwei', '赵春伟', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '95B2153114CB4A3CAD72EC45C32EE74E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhaoyc', '赵玉成', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BA1ED56F23C742769658F2E8C317587B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhangmy', '张明月', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DF5AE430AFBF4D70B741BC2C51DB180C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lili', '李丽', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F99DBDADF51A4E1A83B09A93B443A704', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'tangq', '唐群', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FA5987457C3541D6AFDF148E3CF887A6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lisha', '李莎', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6CC5D67ED4EA4476829BFB3C6A2CB32E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'xqzyy', '薛智勇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1EF8E502625D49AAAACCE8330DA07B66', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'wmg', '王明贵', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E56CD21EB79041A29E771BA0D4CC1B25', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'guojing', '郭晶', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1C6A37E7367D4C639ADF9A4819044D59', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'fudebin', '付德斌', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F71BB712928C429881C017F8E6EA97D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhanglw', '张立伟', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AC2D4A83305C42DF89921AC016AE7696', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhaochen', '赵晨', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F223E7DF40844DCBA74CDDB2672B0180', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'wangguoping', '王国平', '领导干部管理办主任', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EB9A324E8AD54BF3A326119AB3AD2333', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangxu', '杨旭', '杨乐', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D0722667691C418996B839AFFAB1925B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'huangjing', '黄静', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '178F0614382E441091DD339B45A8191E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hechuan', '何川', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DD87C156165C4A9F8D2B649C447CB136', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhimin', '智敏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '20E304C8D3A1449F9FFFA03AF7241165', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'houfanglong', '侯方龙', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '02B42127DEF545EC8162EE6ADA63F6A3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'xupei', '徐佩', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5105D70D52E8475792ABBC6BFA124B3D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yuett', '岳婷婷', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5910BED8DAD247349623CC8DFD4C6931', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'liaohaitao', '廖海涛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A86EEC36C1B945AEB073D27B1C08ADE1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'ehr', '人力资源系统专用邮箱', '彭潇', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B98C0FE0CB3F4371B834EAC84662556D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'rlzyb', '人力资源部公共邮箱', '杨旭', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E0C6D33DC4A14AF1AE5F02396A2BF56E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hrtest', '人才测评系统', '王国平', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '41D10DEDCFEF4155994C4EA308CE6286', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangle', '杨乐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BE5DCBF48A85423ABBB0283413B29855', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'pengxiao', '彭潇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '21C07E684B4142B1BBE3FF44A0F730B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'zhaopin', '人力资源招聘', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FDC7B50530AA491B844B04A4C4C29894', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'libin', '李斌', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D9E16ED7DEB6466E80ECC6C112853616', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lipeiyin', '李培寅', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C4B2A21FEC444074B88A4883B5C3EB6F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyuan', '章苑', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4A04F94DB6D34140B246121D93258A85', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'muyan', '穆焱', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '06CCF4546C04473DA63DC7D166B8540A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liangmaolei', '梁茂蕾', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7FCD53757BC34E918430F8CF45F6E8BD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wanlina', '万莉娜', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '774841C484DF4E4EADC8E640D997DFB1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangying', '王莹', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '49EE85CF5A3843A2A8E6B05BEAF60FAF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lynan', '林彦男', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '18BB0DAB4B2D42759109A3A7E1DF3BA4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'xuxingxing', '徐幸幸', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '306124D9FBA449BF852A8DED77F2ECA1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhaocx', '赵晨雪', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7B8712F4CE80420786B9EA6E5B0166CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'luobaiwen', '罗白雯', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6744DDB092344BCFA466338C0F30ACB3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'sunyitong', '孙一桐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E30CA6478F0B4F85BD2F746ECB1C1C5F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangt', '汪涛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2964601DA6EA4D1981CC6A2F4616BE48', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'huangzy', '黄卓妍', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3D55A16BE95347B5BAC66563ABF55015', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'suirong', '隋榕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '779604EB25F24CBEB2583A4B7FB2B3EF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangjintao', '王金涛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2E251A9F47E14EFE8629F48CCE4C51C8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yanailing', '严蔼玲', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B36836082DC44F7294E4F7509BE46E28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangf', '王丰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9E7DEA61ACAD46E997D6C38DAB62EAC8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liuyx', '刘彦希', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '44038EB85D164E87B64839769F7C0A3D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'fanxiaowei', '范笑薇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '502AE5097ED74A95BD0AE969CBDC2386', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'maoli', '毛立', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '282E7C30488C49019A90F982DE33D8EA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyundi', '张云迪', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '78209045BE534F51A8032C521C9C92A5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'chenzheng001', '陈政', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '85EB009BEF4A4B7EADF92ED0ABE2E164', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lvkaifeng', '吕凯风', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F39CABD6A78042D1B44C910EAB41CFA2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yangpishi', '杨皮石', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B1D2BFBB79A249E9B96BA3E093315BD5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'ljing', '刘晶', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4F47FE8EDBB84DC494DC9F1595E662EC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'mochendong', '莫晨东', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '19322751EE164B04B64A9C93F608E554', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yinguangquan', '殷广泉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '03EFC30466FC46FCA0DA87A528B25C59', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'xuyachao', '徐亚超', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F2F22CBE8AD640A5889EB4B75971B7F8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jiangq', '江强', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4A8F7217A0C24F32B422809DB1CC0492', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'lichuangrong', '李创荣', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EFDC3C64C3D34EACB48F52803C315E7A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'cw-yxzp', '财务永续中票', '刘苏晋', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E1C33095A15D4A1AB33A4C055461D467', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jenniferwb', '王彬', '李培寅代管', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '360E06B4D34546528EFCFAFE296E5791', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'zhangyulong', '张玉龙', '常驻法国', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '578F19AC26684BC0BD428E0A66D334CE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'liusujin', '刘苏晋', '常驻美国', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7FC469AF6D5E49C1A1DDF018C1819027', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'wangsh', '王双', '常驻英国', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '79626784D74940E7825A57E091FBFA8F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'yaoyuanjm', '姚远', '范帅帅代管', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5A900A5B6B094A31BA69908A5AC8F911', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'qiqing', '齐晴', '马亮代管', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '509D8F1E8CDD47CD8A0FD55625D0EBF4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'fanshuaishuai', '范帅帅', '陈政代管', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '43E04E32FF964190B0FAC5AB06D29F92', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'linjining', '林纪宁', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DB7977D926924DAFA7F714F64C7B7591', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jinrx', '金如心', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2DA55AAD90AC4AA090D0A5A4319B0C79', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'chenshiya', '陈诗亚', '张云迪代管', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B843B29D9E594D458DF7BE6F09B29F7F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'youyanchun', '由艳春', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6425B0E1B7764241B7DDFF384BA9AD76', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'zhanghui', '张辉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '67A7A7085FC244E2AD4E82D5F5CB2CB5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'xuxg', '徐新纲', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '384DE56FA5E241C6B510287608171DBB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'jp', '姜萍', '常驻', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0899C5E37416429EA87FD276AD113044', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhangzhibiao', '张志标', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E967CA1A66B34177897B8D1766D36925', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'guojian', '郭剑', '专务兼副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '86BF235186D348D1BEDD689FDBC89780', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'chenxh', '陈晓红', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '55F293AB90E9480D8C5DC9161C55CD24', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'hpl', '韩沛霖', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A329A31E441F41F6B51E0C4847BEC3C2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'ltj', '刘铁军', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F4C7B6C341184431A739EB751C20551D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'yanglei', '杨蕾', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1463383CF34B44408F57D85BF84240AE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'lfchuan', '李方川', '国际航空板块业务办公室主任', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '62BDD894BEA64E0483143AC438DAE033', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'fqy', '傅麒玉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3A93BFC8F64541FDA0D9D98EBEF4EC18', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhp', '朱贺鹏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '14984E9FD242426CB9DE0E2C33993A3B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'dengjiani', '邓佳妮', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B50864CEDD1244D9B6C599D21C817FBF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhenli', '甄李', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '340B9FDF12B84215B70425E3EE57E3D6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wxy', '王心宇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '99D2C8208D5445EFBF1C4ECE3C4036CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'julia', '朱立新', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '83BB101E03EA4A309740B87E777B28AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhouxiaoling', '周小玲', '邓佳妮代管', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '250D5A7A23FE47C4B6D96F4FC30E2EAF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wbing', '王兵', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '495EBB79740D4AC4BF87BFD2EEBA5AA5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'baifeng001', '白峰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AC9E89DC2C63431EB69301DE920ED9B7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'zhuli', '朱力', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BA7AC2E01B4743329122C3E9D9EEFCED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jinshaohua', '金少华', '专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F8CC1B9AFA894EA08F1A8AFDD1B68A46', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'sqh', '宋清浩', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '54C70E87D23A443E9A466A7B1C73A51D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'hunq', '胡乃庆', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '68EB769FE86941589EEE0743DAC58481', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'songxiaodong', '宋晓东', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0FFDA298D2F441A98DE38EE20ACCEB7F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'chenyang', '陈阳', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1CB5AA3050934AF08DCF18CA21D29743', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'quning', '曲宁', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D0C1048325674920B66FD38988C105DE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'tanqi', '谭奇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '55C2F7D36BEE4087B17ABB2C8235FD41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'wangying626', '王颖', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E5ABC6CB0D804BBAA9B08175C7BF71D9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'liujinghua', '刘菁华', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3A28F950F2E54C7B8956570967695D01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jin', '纪宁', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1599C613070C4EC7BCB095EC8B526A26', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'intl', '海外机构联络', '曲宁', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9242E4FE35954E68AD61AAB5AD913DF1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'qiaojuan', '乔娟', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '98FFA07B4FD14721B98B1E1EBA2DAA92', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'xiaofu', '付潇', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E1F614EC1E864AC2AFA9158436782638', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'wangxiuming', '王秀明', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '749FA3325CA64627812E51F66F840ECB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'maxiaoxu', '马晓旭', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '76BD8F41313C4B00AF675EB635ECB196', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'yuweiye', '于伟业', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E68950BAC8BB4BE79F43E8A563264A53', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'guotianji', '郭天骥', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0167593270684CE08144B7EB3375FE58', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'lengfengyang', '冷奉阳', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5C928E346414469481F09C7B73ADEB7F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'czy', '陈兹勇', '部长一纪检组副组长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '22876C49EEFC478A8DD2E5E7E980C818', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guowei', '郭薇', '专务兼副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0F1491208DBA4E9085CD93215A32C7A9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guxiaozhong', '顾筱中', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6994A6527325484F87BB54B9E9985A0B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangjunmin', '张军民', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8349E653C0AA4D91AF3D006C6116E7F7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'huangqian', '黄倩', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5436AF31195C4987BA4E18D404E786A8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangp', '张鹏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '78AF27913E3C43018A3EA23703C81F89', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangshuang', '张爽', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1DA8A3EB1F254A3882426F0D3676509C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'jubao', '中航国际审计部举报邮箱', '张爽', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '50A6F7C7FC274D009E9E47F35C7B9439', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'shenji', '审计专用', '张军民', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B68A962CB57D442DB91D629E2F805BE8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'liuying001', '刘颖', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8598D75AD4AB48F099139C3310F6FE4D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'sxt', '史笑彤', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '97667C72B05B4D4BB7412700FC47F05B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wudan', '吴丹', '部长助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C8DA48F766F64BB996B628389F2626F6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lipeng', '李鹏', '党委副书记纪委书记', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BED24C6ABAB045BFB2672A86BC5DD26F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhangwen', '张文', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '45FC15C376C7402EA4A7980C199AE4C5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lily723', '刘美希', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5B6EFAEF6B8A4B6987C7A4BB4E78D894', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'xuli', '许莉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '648A9554CB76434996E18418C9BCBE47', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wwt', '魏文韬', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '50DA3BC10DA448EBB6F7F6B1D09F994F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'mingpian', '名片制作', '刘美希', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B528EAB1BC5F438F9440E781D807507F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'qywhb', '企业文化部公用', '许莉', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B98E01E54CF24BE889502F2A11A4DAC4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhgjyjx', '中航国际意见箱', '许莉', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D7313E1BE9F74507A57B13F48E805EDB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'zoukangning', '邹康宁', '事业部总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '54D62099843049268D017A8102B87ABD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'suzhenyu', '苏振宇', '事业部副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E9BADCDD0EAF4BB58928262A330C2EAE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'hyw', '何跃武', '事业部总会计师', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C426DA596A0940E993D4F8D131C131D3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部专务', NULL, NULL, NULL, NULL, 'yanna', '杨慧君', '专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DD50E2ACB95C4A8E83B795AE2E85F002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'liuruiyan', '刘睿妍', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AF4B643FAF9A4A87BC588404188E5217', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'linxiaojie', '林晓杰', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0B8CBE86145E40F2B5DF74C0170A1FF8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangbowen', '张博文', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '350C6B740E8C46B180C75F0DC9656A98', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'qiaofl', '乔芳林', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1296DFB9C7CD4B3CBD35D671B633687D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'yon', '叶宁', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FDA9ABD7823146059A70259C10DBA117', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'niuds', '牛德胜', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '68F119DDB08442CDB9D43999C6D6F3B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'jinbo', '金波', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0FCEED0D3D74407A8DE154AE5DA71BBC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangyuan001', '张媛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '96C5DF034C404FD89D6DB96DE8A30CF0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'ytt', '岳婷婷', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '77EC591B68564CA796B9C9F4DEA28D3C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'songchen', '宋晨', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5A40A3DB454241D294003380545C7469', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'hezuozp', '合作发展事业部招聘', '岳婷婷', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '098AB3E46AE44E2988D53855AC83CC72', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lvkaifeng', '吕凯风', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '05ACC5DAD9184AB8AB6DA746C3D96599', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yangpishi', '杨皮石', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '84E5E9E27A794682A42A872B3E1B92D9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'ljing', '刘晶', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0E80077523D04DA7A9276ED923EFFE8E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'mochendong', '莫晨东', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '696F979909D44827A66320AF747BD173', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yinguangquan', '殷广泉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D3A1EFC7EE0447B9B595A6CD4BB674CC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'xuyachao', '徐亚超', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8773E12CC8B44FE0A817F04816C60B58', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jiangq', '江强', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6D29B1F2E7E743D0B5E36A93334F65AD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'lichuangrong', '李创荣', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '909B5328379745C0BB45E9A2CE4CBE0B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'cw-yxzp', '财务永续中票', '刘苏晋', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3F9C8005490B49D98D40176191727099', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jenniferwb', '王彬', '李培寅代管', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F1893668462E4A76A537F410499264E1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'zhangyulong', '张玉龙', '常驻法国', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '33865928BE0E4BB48466A8B619FCA853', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'chenyan', '陈燕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0C0E787A920E48DAB523904EFED7CC63', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'yangyuewei', '杨月炜', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6DEC008C371E4DD28603C4CFAC2A81DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'lzt', '李振堂', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A4DDFA669F334080A1D8A636C47CD2B1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'niyang', '倪杨', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A1B83E73D19E4F80A48DB90D932287C7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'jishenxin', '吉申莘', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DBB958D0E8D0416395EE34C9DCB38922', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangruoyu', '王若愚', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'ADC92D141E494B1CB39843D3A2EA4170', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liuxianghui', '刘湘徽', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B772B1ECCC4A4F53896A7BF3B1C128D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangnan', '王楠', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '41F39C4B20DE45B29D1F9C8CB5909E6E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'zhangkl', '张凯亮', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8D85BAF11BC444D5A71D8E14572796D1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'panyu', '潘钰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8BC3713A29B642258630EF8BA70EC4BD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'shenyunzhu', '沈云竹', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9CFB8E3AF9164B40AAA6A85D2DB2BF1B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liqimin', '李齐敏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '435F72B784C9416A8B29F10BD698F236', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'linsong', '林松', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B37ED5F2B8824DB397B3338E593D7FA3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'zhangyan01', '张燕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '40A69B9F5814439DBEADF9AD5CD8DBDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'lijing826', '李晶', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1269407F08534CC99A0E93E62399B74B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'mxj', '马晓珺', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '378E5CC30A80428B9A8FD6242DFB5F45', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhqy', '郑启源', '公司专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '096AD85EA0D14EAAB655EBCD948DD0B6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'guanlq', '关力群', '公司专务兼行政总监', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A930A54B9F564BB5997DB422862181D6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'licn', '李承宁', '公司专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6F4699EFC04A48BE9EAB049AA8437186', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'liubinliao', '刘滨辽', '贸易部副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0CA4ABF118A144D6BF10ED6CF349EF5D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'yel', '叶岭', '投资公司总经理助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2C0AD47CD6F847E5AD0F241C5A3E0BFE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'juyanfeng', '鞠岩峰', '投资公司总经理助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'EE64035696B94FFF97B6696283B68BFA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'fangdaojun', '方道军', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E87D9C7586B449CEAF692A5EAB3C63B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'waferlinjining', '林纪宁', '财务副总监', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8E3D63C545824CB68E143AB193BD5A91', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhaoy', '赵扬', '财务部副财务总监', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DC4A211130D74BCE9C6ED4634DCBAD55', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhousha', '周莎', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '92D30A663EE84C5CA0B887ED1DFAA1DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'wafertangir', '唐岳震', '总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '06A81BCFBD0541C5B94F5D9C790A6D0D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'lihao', '李昊', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5AE03EAF848947CFB07FB00DDD9C95C8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferfengqiao', '冯乔', '总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9C9E91E65C8742218AE4A5714773CD1A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferzongdian', '宗滇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8C46CFF33DCD4638853550C46CB99E10', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'zongdian', '宗滇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3EFE567A31C548BDB2027CB4A5C72AE1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '柬埔寨代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun', '孙会兵', '总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '37B042A0087B42C9A6C6D664220D9A60', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度尼西亚代表处', NULL, NULL, NULL, NULL, 'waferzhangchenxiao', '张晨虓', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D1DE90474C6342EF91E08D269A6581C7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度代表处', NULL, NULL, NULL, NULL, 'luxiuchen', '陆秀臣', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6591B69F00D44B17BA3E5B1367EA930D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'wafersunhedong', '孙和东', '副总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1D532932B1704EC5A8BA48DA9CA82515', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'sunhedong', '孙和东', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '31A0B57F6511467A9E517512CB5C10DC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '塔吉克斯坦代表处', NULL, NULL, NULL, NULL, 'waferchennan', '陈楠', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9FD804BCB5114248BB69D40C3958EC9C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '老挝代表处', NULL, NULL, NULL, NULL, 'zhanhongyuan', '湛洪元', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8E35E6CA06ED4E09A821E9E3BFA26FE3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '肯尼亚代表处', NULL, NULL, NULL, NULL, 'avicct-sutianshu', '苏天舒', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7B18719BF7224C0B99CF775719EB52D5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '赞比亚代表处', NULL, NULL, NULL, NULL, 'wafercuiji', '崔季', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E2C3ACC5B3364EE9A2CB9BA52E7B0295', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃塞俄比亚代表处', NULL, NULL, NULL, NULL, 'wuping', '吴平', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'ECBBA7EC60F448FDAEFF985A6F804531', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃及代表处', NULL, NULL, NULL, NULL, 'waferyangjinshan', '杨金山', '副总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7E6F0CAAD09440BB80AE25F1768C8656', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'lihuan', '李欢', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7DD52248175B457ABB5C7B712A9C43B4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'yangtianhao', '杨天昊', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9796DE14904A48529FC22B7669226886', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '乌干达代表处', NULL, NULL, NULL, NULL, 'waferdingsonghe', '丁松鹤', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D05A383780154B3F801761E4C50AB780', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加纳代表处', NULL, NULL, NULL, NULL, 'waferyuhongpeng', '余鸿鹏', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6238BD2B9A5A470088375DE5918CC33C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加蓬代表处', NULL, NULL, NULL, NULL, 'wafersunyang', '孙阳', '副总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A73351FBAF444CDAA97B324A172C40CC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '刚果代表处', NULL, NULL, NULL, NULL, 'zhangxf', '张晓风', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2F4A72883BEA4C61839D77550321FAD8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '科特迪瓦代表处', NULL, NULL, NULL, NULL, 'wafertangzj', '唐忠杰', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5F44D8610E004F999581A9DB7D3EF100', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '津巴布韦代表处', NULL, NULL, NULL, NULL, 'wafermachengyuan', '马骋远', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3264D17AAB7942228DE84946C32C7361', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '莫桑比克代表处', NULL, NULL, NULL, NULL, 'wafertierigen', '铁日根', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6D4BF3D5C70745B8858A72B13440DE64', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '喀麦隆代表处', NULL, NULL, NULL, NULL, 'jianghui002', '姜辉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8EF66BA6D45D4AB78E11CF5E28C9BD0B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '尼日利亚代表处', NULL, NULL, NULL, NULL, 'ganlijun', '甘黎军', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '52DB0A04E0974AD69E6A1A3DB624672D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '安哥拉代表处', NULL, NULL, NULL, NULL, 'suiyongjie', '隋永杰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B1521DBC65BE468095E11EE1D130B3AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge', '德国代表处', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'CD4A3817EE2643C8ABA8B7CAE6D50EAE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge-ltd', '德国公司', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B7ADFB0BB1F24B97AB6CCE3BAE6F5F8D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.germany', '德国代表处', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B56A9948FC114CDA856CAADC6BE997E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'chenzhen', '陈震', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6BCCACD5C5D046A081AC47FE996C6CF0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'liqijiang', '李琦江', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A2CCE20CFB914BC7ACDB4B81DADB3AA7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'sunjian', '孙健', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'EEC05359E2014514A22E0CE8E41A485D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferzhangyulong', '张玉龙', '财务代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3B64B0B5B04349659C4B96AB46B0D23B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferliyudong', '李煜东', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B8D0285BBD8A41A8AEF41E664B83EE18', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermikelou01', '娄玉成', '总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '863FEEA6F0D3494C9A4B9AA72BAD9E8E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'waferwangsh', '王双', '财务代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2A1AF39F4B32422F91454DA539DD0D76', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermenghaitao', '孟海涛', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D751373692D84C718101594B140D14CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国公司', NULL, NULL, NULL, NULL, 'wafermikelou011', '娄玉成', '总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '778E08E7EB874B268EEB2569EAD07CF4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '德国代表处', NULL, NULL, NULL, NULL, 'wan', '万春雷', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1127D58FB59849A880DB55B08024A568', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '俄罗斯代表处', NULL, NULL, NULL, NULL, 'waferjp', '姜萍', '财务代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FCE8ED1BAFD34B10BCC1C3E8F6BBEF14', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '挪威代表处', NULL, NULL, NULL, NULL, 'huanglei', '黄磊', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A0AC466AA6B1417298BD84CA309D4C18', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'zhangxuming', '张旭明', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'EADEF57C696142D58FA7F0707A9A6A0A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferfrankyang', '杨方', '副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '50DFDCBAC4C34E3CB7B3CCD21DD7DA38', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'hanke001', '韩珂', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BFB5882302474FC5B60BB02228CAB9E1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'emyang', '杨明', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '22579A95EE2645C68837FA73E336023E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferliusujin', '刘苏晋', '财务代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E438C08B2E29475883F273900A6EFF71', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哥斯达黎加代表处', NULL, NULL, NULL, NULL, 'waferlingxinwei', '凌欣伟', '公司代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '19776954E51C4E11A783FAADE7ED84D4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '古巴代表处', NULL, NULL, NULL, NULL, 'miaojingdan', '缪景丹', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1BF3B6EF5B8D459C8749A53FC2B4152C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '巴西代表处', NULL, NULL, NULL, NULL, 'pengbo', '彭博', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DE280993163341FC84794AA5177B25D8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES (NULL, NULL, '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '590F74C1390C4167AB2F3162DC33F80D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '763632049D2344DA93FF9E8AD2F57695', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'lishengnan', '李圣男', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4C97236418364CEDBBB5C060995E62DD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'liuhui', '刘辉', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C8177917A3A547FCB8BBE6114A4ADA15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'xuyi', '徐奕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EDC29103C76B42BCAE7879669485CD5C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhenghui', '郑辉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '82997C2E98D24F93912A7411A40E1D4B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhanggang', '张刚', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5066C86E3D54455A841E0D29F8530C64', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', NULL, NULL, NULL, NULL, 'luchangchun', '卢长春', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FC1D3C54CB124987B99383C62A3087A7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyp', '张艳萍', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C7F8966B0AAE4D37A3364DCB0B6872CF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'lihuayun', '李华云', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5AA6F100A1F24DA48A6F333958783818', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'yut', '喻彤', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3E1DD9C8E3F24A0CAF47B937BF09A9AF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyi', '张怡', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7B41A30EFCE841CABC91DE933C1CE9F6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'shihuanan', '史华楠', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E0EA62DD78904D05BF540CDE7B9F9A86', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhoushujuan', '周淑娟', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BACCEE53F7214109B726EAB260783360', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', NULL, NULL, NULL, NULL, 'hanke', '韩可', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BB6AE9906E654F4699687F2989659F90', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'shihong', '石红', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BE59D39220514F12AEEC4394133B7E77', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'zhangmeng', '张萌', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C85E1B7AE9524649BF297AB7DB9792AF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'gaochuan', '高川', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FCF69F9ABB964AE8A255FC707DD4F874', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'jxy', '景小燕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B4977149E7F04944AB6FC8A90AE1671A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'chenzhigong', '陈志功', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7CB9E651279E4915A6B13D5C37E266D4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'daiwen', '戴闻', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '706552440543473BB2301CAE4A9CA0A4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'liguangnian', '李广年', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'ED57178F47CB48368C7290F54CEE9FF0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'geyihong', '葛译鸿', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2B6BF83EAA5341DC84FBE138B2288EDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'zhaoyuxiao', '赵宇骁', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DAAB1AF259754958A6340C88619D7695', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', NULL, NULL, NULL, NULL, 'xuyonggang', '徐永刚', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8A9D2D77BB8C4895B85450E0F0E1AFD2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'wangxuefei', '王雪飞', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '31DB7CFA2523478B88A123F8398B495B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'zhaowenzheng', '赵温政', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7EC409F0646547CEBD46D9C18E41D6A8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'mhf', '苗鸿飞', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3B389801C6794BE6844A3FB7F5776E22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'jianghui', '姜晖', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3175BF163DAE4D5AAB00A0A7C42AA1CC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'huangxin001', '黄欣', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '804DDC00A7C14B928C4C214083F1AB15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', NULL, NULL, NULL, NULL, 'zhhui', '张辉', '副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '75D1629D3D544A558F70D95228ACD644', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'miao_sue', '缪苏', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7AC7977436624A0D8D4EE1E57C0393C8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'yesheng', '叶盛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C666F2753D2E424A88587BF2622B8E82', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'liuxian', '刘先', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4212075BF742429BB9696374BB9A9FB0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'milong', '米龙', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '64020BBAE3624717BE6B26CD96FCC0F6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'wangyq', '王雅琦', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '87B2F7C426454F22864922F85557C58E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'avicct-tianyuan', '田园', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '66CAEF56BFF8493BB50B78E5884DCAE8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'yaolai', '姚来', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '410069E8D3C04E5496B2B20ED42A56FC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'marongze', '马榕泽', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DAE8B13A31524631B9303726542D736F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'liwanyu', '李琬玉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '77E4D02C97BF4B598B5378107CE9BAAE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'ningjing', '宁婧', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '103898D5BABC4BAC9E910271757E1EC5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangfeng', '王丰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A3883346CD7541869D617CDEF905DEFF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangyan001', '王燕', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0EC100DB65EC46C3BD467330A38A0F4D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'xingguanghui', '邢光辉', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2B8936C558F34DE488766BD85B5228D8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liduanchang', '李端昌', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A28643053F8B451B9C96C2C1895ADFF1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'linjianxin', '林建新', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '49F294A8031344CFAF459ECA98A95FC2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liuanghui', '刘昂徽', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CF5F8026B67A49CAAA6B0EC1E5A044B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', NULL, NULL, NULL, NULL, 'jinxi', '金曦', '部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2D1F5A014ECF45F193A5B8667C4C51B7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangzhenxing', '张振兴', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '80ABE809DF134C579D1A8B23BBCB1B9C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangxiaofeng', '张晓峰', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '027C3F223A634F16B6D5D727FD928FC1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'guojiesi', '郭洁斯', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '77933B3C77A84298934ABB1747C2EDED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'liangxiao', '梁霄', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2C6B6ED808C0427884A7CB8E8140727A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'yuxi', '于曦', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C1B369B5917A4F818792A9036541B3CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'fangzhou', '方舟', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '150A31F313D6426788327AD3B3873DD9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'wangda', '王达', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '70C04D6D141B480BAC5786EB92FE0DE2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'chenshuai', '陈帅', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2C06A044EC2C402EB7615545E9FCBF57', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'chenfei', '陈飞', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '34A885B243794F1C94769FEB8134931B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'jiangshan001', '江山', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CEA2AB4D3CA045E5B00D90AAB9DABAC8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangxiaoke', '张筱珂', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DC2433CD16EA4231A88E468F83959960', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangyi002', '张祎', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '00B8C42D77D242A7BB7D50EA083EA9A2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhayong', '查勇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '33DC495EB59B4D2D8387BFD87E4C7C4B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'zhaoleiyu', '赵雷宇', '处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F21069AA74AC49F78E55A767FAEDCE15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'liuyu', '刘宇', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3E83B70F3FDC4C91B5FC404FD9E003B1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'lilei001', '李蕾', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'ECBC7091C04E4E61855ADFD862F57C6A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'tianchunyang', '田春阳', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F0456823900B4B78B212D91EB07EE29D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'houjiafeng', '侯嘉峯', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F4579BB2A8E644A0845936D47193A111', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'wusimeng', '吴思萌', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CF2A05273DB2491191C4DC81C7E66A97', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'jiangping', '蒋平', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '956D0FF97DE142D7ACF96C25655E7C88', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'lht', '林海涛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '86F43205CE02485F805D95C8D602112E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'guojiexiang', '郭杰翔', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '966D2A2E1E14420F96F1732EF03E806C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'hubing', '胡冰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2E675C3DB892425DBD793E6D68B312E6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'wangxiaochen', '王晓晨', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '18FBE57284164D10962ABD37FB653B84', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', NULL, NULL, NULL, NULL, 'xuyonggang', '徐永刚', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E101ACB2E51041A8A5641505915D26C9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'wangxuefei', '王雪飞', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4F98E3D200414A21A519ABD64C92093E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'zhaowenzheng', '赵温政', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E1C901334B7F4B54A726809A2017A718', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'mhf', '苗鸿飞', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FD486D96BD7E451594CE6FA06315F709', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'jianghui', '姜晖', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '208432A3DC6247768B4BD04EBF4EAC02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'huangxin001', '黄欣', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '677306DABC184AD6B3ECF5D9B57ECEFC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', NULL, NULL, NULL, NULL, 'zhhui', '张辉', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3EA65C4C1E584782AADECBF88E431AE9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'miao_sue', '缪苏', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '33C6BCABE6E44BB8AB8AF653B4880BBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'yesheng', '叶盛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6A05F58AB0D64E0BA26BE6C317E35B08', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'liuxian', '刘先', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AA6362EEE6824648B98C4D825DA2DE5D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'milong', '米龙', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A5A352F7048945F29DA173A5365C440C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'wangyq', '王雅琦', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0BF018054F1C480F826699D543BB747B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'avicct-tianyuan', '田园', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6723CB79C4544585B5B845C461ED1B1C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'yaolai', '姚来', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E93659CDE4CF41FBBF46B464F08777CC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'marongze', '马榕泽', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '53DDF5E8305442F1873A607251E3C337', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'liwanyu', '李琬玉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '758350DE8849432185CF26584A59731C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'ningjing', '宁婧', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '09FD05E3304E474D89063E57A1A4576B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangfeng', '王丰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '72554CE482E54582BB52E64756C66EB9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangyan001', '王燕', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '94941AA5FDF24F5C84DBC758ED0DA86A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'xingguanghui', '邢光辉', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8D8518964A3C499C886CF84DCAE335BF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liduanchang', '李端昌', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C041A30D84E44EF1BDA9FA0D4E4AAA7F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'linjianxin', '林建新', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8DA80632AD954F8BA45ED54DDFE43CDF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liuanghui', '刘昂徽', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '88E2E754B98E4E8F9F7B0A3CE81A0964', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', NULL, NULL, NULL, NULL, 'jinxi', '金曦', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B85501BE43D24A3CAC8706BE2A59E305', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangzhenxing', '张振兴', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '58A24B6FFE424DCEA5434F7D63D7B0FC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangxiaofeng', '张晓峰', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A3BB5DEAF27243BB8C6B735384B1EE0E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'guojiesi', '郭洁斯', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'ADF5D70DF6D94C3DB03E3AFAB9077777', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'liangxiao', '梁霄', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2A17B71193CC48B2B74EBDA95E4125F0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'yuxi', '于曦', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D79DC5022A764FCCBE4B1B06A5F2869A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'fangzhou', '方舟', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A7854BA26970442DA96D98CAACDEE001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'wangda', '王达', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '90CDE47387F245A8BA763D075ED8D841', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'chenshuai', '陈帅', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BC6516D6BE9F4DCFB6768F5220421778', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'chenfei', '陈飞', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FDE67F4154D54B36AE40B68DCC81E755', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'jiangshan001', '江山', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '31B2A5F6CC4347D99D1AF5752A8927F9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangxiaoke', '张筱珂', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8F9EB272EE1E4C31B8BF5FC2CF8B1AE6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangyi002', '张祎', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BCB339D6ED5545BFB0752AAE12B94206', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhayong', '查勇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '339E21E8BE994AD5BD18BE53B9028776', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'zhaoleiyu', '赵雷宇', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '251CD84A51D84EFD96368A52F0A6E771', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'liuyu', '刘宇', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B421CC5949B8486F8D54FB4F2C9364D1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'lilei001', '李蕾', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '51A302F30541416782382C558CD65C56', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'tianchunyang', '田春阳', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7B669B1D4D774019B2309FCD6643F80D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'houjiafeng', '侯嘉峯', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2A09586F30F94D219CB7212D6543B397', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'wusimeng', '吴思萌', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4CB3324082204CC6807F8886F04798B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'jiangping', '蒋平', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F5097B1D0FDF48409B3FDFA4E9039318', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'lht', '林海涛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4CD1BEEB8D324AA3A57B9B08C6E6935A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'guojiexiang', '郭杰翔', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '44FF4E9569C343DA952F626CA7433658', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'hubing', '胡冰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AB6183C296E84EA6A21B98CEE62B8D6C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'wangxiaochen', '王晓晨', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6DE48EB2DD314B41A32FC85B1C78291D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhanglu', '张璐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'CA074A90E7F04CACA02E115C2221B741', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'fjcwurui', '武锐', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '748C16F32B0B49068BD907B63958224B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'huangbowen', '黄博文', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '37BDE11856AE4C20B76D79733DCF981F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhumingshuo', '朱明烁', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DB0CB0E8F41E4B8D926116F7F24EB6F2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', NULL, NULL, NULL, NULL, 'guolichuan', '郭利川', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '818FF57A6832489F9FD3B7B4A0998C01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaoyajiao', '赵亚姣', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C78A39A2383D4A828691EF358CAD2E6B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yinjie', '殷杰', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B7DDA4089EE240F9A8B35EC714F04FE3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'jiangyuting', '姜玉婷', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8A680F058F984FE4B38759C7EC562F87', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'lishuai', '李帅', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3C9CD98941F74CFD844ACB9C60749803', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'sunyan', '孙妍', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2F541B5614FB45DEB70D433CBA916E05', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'wangyang001', '王洋', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DE1F23FB2B494916AD3C4B7530FE6058', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yanjunxi', '闫俊羲', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2DB9BE28A7AC48EAAA594BDC94696F1E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaokeqing', '赵可卿', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'EDCB7F1F3142417FBD384C638BE5C72E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zuoxinyang', '左心扬', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9150BEBBF4304DCA9F457985B84307D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liubinliao001', '刘濒辽', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '86CC66B0EA7E43DEB12D0F1BF4D6036E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'shenghua', '盛华', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2A3DB62D57A24BD08C9832DB529BFB86', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liuhuayi', '刘华奕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '822EA771E27C41D59E5B67C88905BC32', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'lixiaomeng', '李晓曚', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F5271B3285FA43AAA6599C7A8CFD3430', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhanglinyi', '张临意', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1F201B168BBE4A428C1B0B84819F54F7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangsai', '张赛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D4747AE2A86E4603B783DEC4227A10BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'chenn', '陈楠', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2D2AAE7FBD0D40C2940F56194E79B1E0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'qiwenjuan', '祁文娟', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '95CD2A9EB0ED4C75B2DF530625DFA75F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangzhen', '张振', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5847CFD874E9485BADD0F8A0C0F25768', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhuwenting', '祝文婷', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8EA662549300423496A7D4BAF9F55714', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'songling', '宋凌', '事业部总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '611DAD04E4D04C9BB6DF3D2A08F59E1F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'elu', '吕中华', '总会计师', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1C4673B05E33403D8169A9A69931471F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'xubomj', '徐波', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '02F6808ADC6E4A4097C3567781B99E37', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'heran', '张赫然', '专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '30D277E62B89436489B87FBC53D95A52', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jinxing', '金星', '专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2B3C6074AA4C44D2BBB83119F08022BE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'wangxiaobo', '王晓波', '专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4C3E6D3A31B94301B1207FB69B2C1283', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jiangjin', '蒋金', '专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E93B4C48463441B49BA65311047C39FB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'lilaclinda', '林征', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B469A046D06649A5B2B50C3124F29CFC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'suqian', '苏倩', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A909941B35854229A192B9511F22A7F7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'xujing666', '徐晶', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '312CBE2AEBA94ECDB3081019E1D564CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'jiaomeng', '焦萌', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'CC2AFD2F94AE491593B4BE63D8B7741B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'fengbinyun', '冯彬芸', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2856682813EF467CBB7A0C55A17DB2FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'guxuan', '谷轩', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2D98D4C3DD0B41DD85DA3D3A7AC1A18C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'wanghao', '王昊', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9D9A812105514AC6A7218568972EF829', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'zhangwenfei', '张文飞', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FDC2938149DE431F8E39886D8FB8F308', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'yyzc', '航空运营支持事业部', '王昊', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '935D33037A224417B53EDF15D0195D62', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'dingli', '丁黎', '党建人力部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '969DFFEED6A940AC90DC2B63AADA8C0C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'xuchangfeng', '徐长凤', '党建人力副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '8814560301F14BD198A75E8B9E2A841D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangweichen', '张伟琛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '197AB54CCB364BFB93F965988ADD7BC7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'huanghe', '黄河', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'ED01EDBFC44340E096BD9BAB75BF64E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangyanan', '张亚楠', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AEE9FF52AB0C48CEBEC22A0B56780DB4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangxuan', '张轩', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9B32B00294C74BC7B15425943706C5B7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'maxiaoxu', '马晓旭', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E32C224498C54D1C886CAE852B9DF82C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yuhao', '于浩', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '44463EFCEA4C4866BB4751A8A4ACF811', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangzhaopeng', '张兆鹏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E723AD278669493EA2C0A9BB0E13B3A4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'daishouhua', '戴寿华', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '98FC235D23AB437CAD6C64A9FD1897D5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yanbaohong', '闫宝红', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B2960988B6A84B05A692AEF3A4522661', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'lihongjie', '李鸿杰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '55C26917ECC44EB0B6BC8AE60E05A30A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'lixiaomeng', '李晓曚', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D72CF32E20B24CAE86DBAA8AC31F725B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhanglinyi', '张临意', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AD49D87C388D486D927E64F17F94729F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangsai', '张赛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '414CD413D4CB4F0CB0A74D5D2D2B11AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'chenn', '陈楠', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '09926F16C995448DA23AB8725DE75218', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'qiwenjuan', '祁文娟', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9C4C8476AA654E3E9939AD41F79F1C38', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangzhen', '张振', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DDF85FBBC7704181AFA9D1D96F9BEAF2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhuwenting', '祝文婷', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1D6B3A7107B24D988DBB0EAED52DA162', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'songling', '宋凌', '事业部总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BD78E774868E4699A2CAB671DFDB6378', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'elu', '吕中华', '总会计师', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7D5ECB8EED7240FA852D382F1E769BDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'xubomj', '徐波', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D0C1CA489D5B43209832C4CD42736F16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'heran', '张赫然', '专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5EDE5F378BA140B5827F26FD55765423', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jinxing', '金星', '专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B7F77D57146A47DB9ECEE385631CC627', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'wangxiaobo', '王晓波', '专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '83EEE7BE50F1436D85371FF70A1658EF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jiangjin', '蒋金', '专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0FD6B4F0A06B4DD0AC2F48BB6616CE5E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'lilaclinda', '林征', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '46934FC20F534AE1AB01DDE8F0783601', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'suqian', '苏倩', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'DB046536AB2648498C111B65C41C6C62', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'xujing666', '徐晶', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0B7696AFFD7347E0A74E2F3616D3F3FC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'jiaomeng', '焦萌', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D54FFC34BEC84B31AF94BA4D696906A0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'fengbinyun', '冯彬芸', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D38285A3EB4B4986AE5644DED8DD7218', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'guxuan', '谷轩', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '00F3AEAC6F894E3C864688BBAF02C311', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'wanghao', '王昊', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '340B05D2AB254E649788F7DD2283C308', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'zhangwenfei', '张文飞', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FC8EAF8A9432465994BF8E4E0D52CAF4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'yyzc', '航空运营支持事业部', '王昊', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '33A378ABCBFF4F52B6BA8DC5FF1D480D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'dingli', '丁黎', '党建人力部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CC512B0A5C074BBB807B3CA7184680DF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'xuchangfeng', '徐长凤', '党建人力副部长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2852F7E9E8DB479393D0EFFC2DB516BC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangweichen', '张伟琛', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '188AB8EF21084DC499FEB0DF1881BB7D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'huanghe', '黄河', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3EAFEE36EEFF410FB5AA9345A59833C2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangyanan', '张亚楠', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '907927A90D294E7988A97709E4841F60', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangxuan', '张轩', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0D455B93FAFB49C5963631DA5E90CBB4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yuhao', '于浩', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EAD8D79C7B834529A0DDBE30EB71748E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangzhaopeng', '张兆鹏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '714A39A6785745AC9AE0205810D5324F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'daishouhua', '戴寿华', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D724E98F3A8645548FE50CDD95346C2A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yanbaohong', '闫宝红', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C8BD8086A7CF4A60AA3F03BEE1833328', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'lihongjie', '李鸿杰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EFD9ACA5409045EB97E81447430F6743', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'yuweiye', '于伟业', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4B82BDED77674574971B42E6A3256767', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'wangxuejiao', '王雪娇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7F1590E32FC4432FB46826E348C69B16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhudan', '朱丹', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BE19397DAF3D48B6A8C561F86CD8D2B2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangshuo', '张硕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5DBB551825F9456AB480E57583DE6BFE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'shiyanfeng', '史彦峰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '43C86EE0F7074102A4DDFC69E7D7551E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'yangkunbang', '杨坤榜', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6874AC5CC62C42649BB4FE86C7E0E8D6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'lisonglin', '李松林', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D3A08411CC2F4AB6A9871F9802C97B10', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'duanbaorong', '段宝荣', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7DB820A1356E49BEB71FFBB274361378', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'songchao', '宋超', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BB271F16A12B4E5F8C7F302A439A37AE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'wangxiao001', '王潇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C9D123D823AD4EAF98A9F928F2C386AD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'mada', '马达', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6EAF9A95F5BC488F9446CE3FDCE12296', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'huangsong', '黄松', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '991016B03C7748EE9D779C9C8161789C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'guoyongpeng', '郭永鹏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3784EEEEA53E4A6E8A244F41D0A09F04', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'xiongkai', '熊凯', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C85B5CAACA1B42BD8A4701E839CA57F3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yangzheng', '杨铮', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9017557861604440A6100793ED21A3E1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'wangyao', '王垚', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '363DCCB0DCC2426FBC47C0F8F8BA7378', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yanxiang', '燕翔', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '596533318F4B45EA9347AB471383FCCF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'luojianbo', '罗剑波', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2311031EFBA341D39497665BC5642AEE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'liqing', '李青', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0F6935FBEABA40D38DFAC5D0576796BC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'lisihai', '李四海', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4F02F65366A246E7A087D7AFA52156A0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'jiangboqun', '姜博群', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '42C0A753C9674686A298257D8BC0F270', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'chengenhuan', '陈亘欢', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D4DED11B66824E08948482AAD7F6EE55', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'yangkai', '杨凯', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '01BBC8731F6441B7AB71E10700F41D6B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'cuihai', '崔海', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '55AC78A96CAD4E2F91F66FD11E6EF2CB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'gaoqi', '高琦', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FDEDA18AFEFE4F9B86BE1710C79BDE4C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'zhaobingxin', '赵冰心', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6EB1D0EFAAFB42E2B51EEDCD68081117', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'ahelibai', '阿合力拜黑那提', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '66E0363BBCD94E1E994946E0354DA878', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'luli', '吕莉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7F0B60E4C8A2411E89CA19A706886863', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'cuixiaoqiang', '崔小强', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '40ABE72C863E4EFDA3CCA05CD17D1AFD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'qiulij', '邱丽君', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9F17379F2327439090157B8F59565C30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'feibinsong', '费滨松', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D0AE79D3177D45EFA284A0905F13BC5A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'suiqing', '隋晴', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C27C858EEBBF4D5BA78722C75D81D1C1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'liyixue', '李艺雪', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D8BC888B48D545E79838479917F199F4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'guoyuchen', '郭禹晨', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0BD747D325DB463E831520C77D8382FD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'wangzhen001', '王震', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CE046995DDFD4342BB120CAA696339AF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'baofengling', '包凤岭', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '03820B4C4B0F459C91D853A92D357763', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'wangyonghong', '王永红', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9EA6FAF8A7CD48CEAB9FCDC05BC95E6D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liguanchen', '李冠辰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9759902236FA4C5787CC7812E3DFB7FA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'guotianji', '郭天骥', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B8C6596F72FC46CD8D8DA2E6B92D134E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liheng', '李享', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9BCA8E0851D048C98CB249A77B92635B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'zhaoweizhou', '赵伟州', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7C58175C522B4B44A78FC41C5BA1F458', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'jiangsongyang', '江淞洋', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9C5D46B8B79A4D1986D7FB34B765B113', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liuzaiping', '刘再平', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E89B99AAC5EC48E49EE39AF249606D21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'lixiang001', '李享', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1429550FB8204F21B2ECD42B28C868E7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'weiguangjie', '魏广杰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '01592D41869045A48DEF8B5BBA7BC84D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lishichao', '李世超', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '80EE730467584E8B9F8AB458A79666A4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lh0020', '李辉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D2A79C8461ED439D8AA632AB8C96FF6F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'chengyijun', '成一君', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '97DD3A785A9D467CA24E94172A5FB479', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lvzhidong', '吕志东', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A38AD97A1DC542988C7F505F5278338E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'xuwei', '徐伟', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C73221370DF447A8AAC5E1B224E39005', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'jiangqingxiang', '蒋庆祥', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6EAAEF92CCB741D195EA3DB39D88B12F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'dingyong', '丁勇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '17D6CEF501C14067B68DEE2CC95C20C9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'gengjianxin', '耿健新', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5456AD6ECBEE45D292DEC94097699B03', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'yinmu', '尹沐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FA11E0116F414C7893E6469A981C5D62', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'nihong', '倪虹', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D10DA4B31F504B61B1639E8B8351A99D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'yangxi14', '杨茜', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '40FC31179F914732A011D150BC51631B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhouyue', '周越', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8E8F388A58F94DDFABC6029E1756E4D3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhangfutian', '张福天', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '17F19E71FB97411F805F2DAE53892FA4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'miaoqing', '苗青', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8486DA32D7144F8D8831827BB94CCAB8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'mowenjia', '莫文佳', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '84F5BD817FEA41A3BB87581F6DD89953', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'liyangyang', '李洋', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5250A07B7AD44EDBB7739AE8C646EE30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'hanxinli', '韩新利', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8F929CCE1E9847B6AB9031D5D4AF044C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'hb', '韩冰', '部门副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BBDA07B22360462085ABF207FA6C8BC9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'gaonan', '高楠', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '495E6316E43541F6BD3F4481D68AFBE7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'momo', '陈默', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7156A33EEBCF4B149A986EF0DB54EA23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'wangshuo', '王硕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '68CDE0B818EE45BFB41FBBE87536E802', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'jiangh', '姜辉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '65A35117DEAB41609434C0C9D1920F9B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'yangth', '杨天昊', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7F5D1039DB204C3A946CD028041AEA82', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'zhangxiaof', '张晓风', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '42434569F2704B40AE9720332E79B0FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'anqi', '安琦', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5821BB8F82A84AE5A597335EE4BEDD40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'liuyang', '刘洋', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E17CE06C5CAE4F45B6660FD1D5B18917', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'qiaosen', '乔森', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D1838588EA79469ABF1839D6AEF37F7E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'zhouyong', '周泳', '部门总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D50205B965C744F8A78CAA6B64722966', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'sxg', '史新刚', '部门副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AF41EF204BB84F5F8CC0980E10E34FB3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'beil', '林蓓蓓', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1C3E047006CE45E4A8013200414B59A9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'yimin', '伊敏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '325BF45C4B9F4C02BEC4A024C78A3CDB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'zhaohao', '赵豪', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8D89108F08C241FB8860EEAA4379815D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'wuzhaohan', '吴昭含', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FA901058211D40A38C75A18675DDDB71', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'jinyiran', '靳怡然', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BB64661AC6FF48B3AD9EC12EB4A9919B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'xuchumeng', '徐楚朦', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8BA219C31D94431CB7555898B57AF10A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'fjj', '傅金鉴', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '24342B03791344CCA213F46F21B5FEB7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'gaohai', '高海峰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F5857C048DD74321B8925A282E3E562B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'slj', '苏立军', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '9D76854A09D3467D9A72E3CA5FD017B9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'majinghuan', '马靖寰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '20BAA29E239F41F9B72F3A83B9DD0449', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'huanglingrui', '黄泠瑞', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D34BEE82464847D892916BF7E8292D98', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'getong', '葛桐', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0619902C56F34FFC95E46CB0D9DB0754', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'liangpengfei', '梁鹏飞', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AD987120E6794C1FA94B3F176A504669', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'wenyanping', '温燕苹', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F9A4FE3B7CDF44C38F836578446B7D7A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'shibiao', '石飚', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D77160BAC63C414DB02763756EB2060F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'chenyan', '陈燕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7A132EEEE0AC4810903A6F0F282BBBEB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'yangyuewei', '杨月炜', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4B5D7E1138D947788448B3970D57587E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'lzt', '李振堂', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D67356C54B83427AA12116A1813663AE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'niyang', '倪杨', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1CA5C4022E904C819A0371FE6E2643CD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'jishenxin', '吉申莘', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '77C88A2FA9924C0AAD91D03CC29003CC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangruoyu', '王若愚', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '978860038D964A32A2A417F3DD5BF506', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liuxianghui', '刘湘徽', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C8C496E9888147B1AC1A30F4865C9C00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangnan', '王楠', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C4D1E7D01D6648328909B03F757E77F6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'zhangkl', '张凯亮', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1DADE3937F654095ADAE62A3AF03C26F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'panyu', '潘钰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '58DE225A045E4071967F80A4B62F6A15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'shenyunzhu', '沈云竹', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3010B1E7CD804DB4A4AED5F02CB9D877', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liqimin', '李齐敏', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0562D77575C245DCBC330D1C7172072F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'linsong', '林松', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '752D510790F941A8A6962D9B9A3E71FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'zhangyan01', '张燕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '63DF77070B0F46F8B9F5A800433C90B3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'lijing826', '李晶', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '68402C14B9B24F19ABCBCC6DF72764FA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'mxj', '马晓珺', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1F30BEEEE1414F2F97C6B9126538EED7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhqy', '郑启源', '公司专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'F500F818758141149214034428EEF1D7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'guanlq', '关力群', '公司专务兼行政总监', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5BCB478CAE73455F9AA136DE2FA6B963', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'wangxuejiao', '王雪娇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '780638CED5F4411991D847F7897399EC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhudan', '朱丹', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '694C3C76035A4266BB6178C160BAECB9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangshuo', '张硕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '36AC9F6CCA8D437490536D476583E196', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'shiyanfeng', '史彦峰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AAD3E4BB7483412BB5E8C0BE903422A3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'yangkunbang', '杨坤榜', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'FD512968FBF8468487719F52981E1CAC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhp', '朱贺鹏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '259439BCEDD84E55957D39DD28A366F3', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'dengjiani', '邓佳妮', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3B731CD5868842549D203F4FEC004B12', '邓', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhenli', '甄李', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '83DFDE220035400E96E9ADA2853E0226', '甄李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wxy', '王心宇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CECF0FC70F2E48738A279A7C0C12BC3F', '王心宇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'julia', '朱立新', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '65C1A76742614880A4D5E390B4B224EF', '朱立新', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhouxiaoling', '周小玲', '邓佳妮代管', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '81AE428F45414049812FF456557BEE24', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wbing', '王兵', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B27D0C6E56FD4FB9B90C88463DB00973', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'baifeng001', '白峰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E3EFDC4F0B344A33B28359FA8E7FDF44', '白', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'zhuli', '朱力', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D884BBB0C80343AA86CEB0551E8B175C', '朱力', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jinshaohua', '金少华', '专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0C3CCE75BACC45548B6F86F32BABF162', '金少华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'sqh', '宋清浩', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E4ADEBF2C3DC4E1A997A210A9E61722C', '宋清浩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'hunq', '胡乃庆', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ED982C1CFF9B4CD39610F07C6BC75C91', '胡', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'songxiaodong', '宋晓东', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5F6AC7EC6B9F45A694987523040C23BC', '宋晓东', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'chenyang', '陈阳', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '500417B274C74E8F94E7C2B72F8ACC7C', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'quning', '曲宁', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F651DAD400ED4259BDE50CEFAC2B9160', '曲', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'tanqi', '谭奇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F3784AB666CC49C2956904950531CD1C', '谭奇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'wangying626', '王颖', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8BDACD1B9920422B915A093850CB421B', '王颖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'liujinghua', '刘菁华', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B4D68EC451B34F37BB2F97B858A87452', '刘菁华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jin', '纪宁', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2F41A788729C4AA8B39C79E32E335C9A', '纪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'intl', '海外机构联络', '曲宁', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '26827AA02C69423CBF5BDD4DDDA1CABB', '海外机构联络', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'qiaojuan', '乔娟', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7A4BA2F72E1441679AE19A49198A259B', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'xiaofu', '付潇', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8596B63BAA3C4E56AFBA5C7F6A7E2A31', '付', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'wangxiuming', '王秀明', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FC5912A33F844BA59B913DB5B50338DC', '王秀明', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'maxiaoxu', '马晓旭', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '66242DE291C1496FBFBF0468356FFE16', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'yuweiye', '于伟业', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BCD686D75B384274B9B4286FDC9338A4', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'guotianji', '郭天骥', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CCBC9448862A48FCB9BF160251166F3C', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'lengfengyang', '冷奉阳', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '092AC19467D644BB942D975157B03CB1', '冷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'czy', '陈兹勇', '部长一纪检组副组长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '58F08D8D4B914000AC8C97AA0A8EAE93', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guowei', '郭薇', '专务兼副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D4895A93F5EA4F3E9BA6E31DF719738C', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guxiaozhong', '顾筱中', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3B424472009E47DD894DDE910457141A', '顾筱中', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangjunmin', '张军民', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B3887DED485D4A3ABC6E2F5662D33732', '张军民', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'huangqian', '黄倩', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D6E1AED21E5B47449B4D2C581070D8FF', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangp', '张鹏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8002DF6BDD464B1C86D6B2FBFFF081D0', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangshuang', '张爽', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '09383A8DCEBA4E11B77FF7021B898EC5', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'jubao', '中航国际审计部举报邮箱', '张爽', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6E0655F7F094446F8A7E207229B3371A', '举报邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'shenji', '审计专用', '张军民', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0B5AFE7CFBC0476D92EA2E5F7334D276', '审计专用', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'liuying001', '刘颖', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '50CA40B95D564A188C6DC703589AB6BE', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'sxt', '史笑彤', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ECA7FC38B7E74E87893B3970CAACBD65', '史笑彤', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wudan', '吴丹', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8DEF2EA1AFD44D5B969079B9BE9BAA5C', '吴丹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lipeng', '李鹏', '党委副书记纪委书记', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D1F0DEB91E6249ED9E9E0B0A6B768E90', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhangwen', '张文', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8E22F2C7FCB24916BB8AAF4D12200095', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lily723', '刘美希', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '835ED5AEBFDD4A9996009DBE36CCB84E', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'shenghua', '盛华', '副处长', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0DE3D6AB97F64F3682DE1712C5D18677', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liuhuayi', '刘华奕', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '89987373EFD5485FA67A02FAD5165229', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'liusujin', '刘苏晋', '常驻美国', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '45AC91A6F8C84D7696982CC19B168E16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'wangsh', '王双', '常驻英国', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4C333B7579F44223B48D1F60957256B2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'yaoyuanjm', '姚远', '范帅帅代管', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9F6EC162176C46BEB46CF727F49FD2A7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'qiqing', '齐晴', '马亮代管', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1343B392346A440B836B9807BFF58C17', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'fanshuaishuai', '范帅帅', '陈政代管', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'CBBC62BFE3B347A6A5C06CA8A783E5D9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'linjining', '林纪宁', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2F7F6BCEFE9841E58F80EDD581340335', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jinrx', '金如心', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1386BA342D99406D8BCA50D9487C1438', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'chenshiya', '陈诗亚', '张云迪代管', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B8058BEB9DF340B1ADC63DCD8FA5F93C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'maliang', '马亮', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7AE9BA5D9BC54B6B8906F9C7678CD675', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'youyanchun', '由艳春', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6B05650AF83B4B02B93CA9C5AD192F13', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'zhanghui', '张辉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B33792E0A1824E2BAB52F36C7C159BBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'xuxg', '徐新纲', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0F02DF59BE9A4EB8A5088D97F6D73B8A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'jp', '姜萍', '常驻', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BF8280FCDBAC4EE9AAC8E13810F1CC75', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhangzhibiao', '张志标', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4925A554A16F4FFE9039A448A49A6FEA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'guojian', '郭剑', '专务兼副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '211461439E4C45D4862F36E95DDE55DA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'chenxh', '陈晓红', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '33A7FFDB864142B8B8A98374F57EF2D8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'hpl', '韩沛霖', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '31AE89C5554F4704BD77455E1352617B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'ltj', '刘铁军', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E51CF76E8A264A529617BBAF95531B17', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'yanglei', '杨蕾', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D77108B60E2344FEAD22D78BF7CBC0E8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'lfchuan', '李方川', '国际航空板块业务办公室主任', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '45F36C0BBA194030A114CA2137552404', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'fqy', '傅麒玉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '691ACF5CE94243328D593767EFDCE678', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhp', '朱贺鹏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0F0EB6945D414953A3DB1AA81D0E3EDB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'dengjiani', '邓佳妮', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E01D664CCD9943C1AA606014954C65B5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhenli', '甄李', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5FAAA67CAF024A5E8019C72B016B8C15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wxy', '王心宇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6605E82F8DA040F5BE55C69931DD0E91', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'julia', '朱立新', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D33ECD583FAA44AF92B074F495166155', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhouxiaoling', '周小玲', '邓佳妮代管', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'A4BD8D66D89F40DB87C14F37944E73B4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wbing', '王兵', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '54C7AF28032148D3851EF0E5A87B4D90', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'baifeng001', '白峰', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5B4A10B97A2A42F48031D4022BB06383', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'zhuli', '朱力', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '72ACA92D175647F484D2B1B72373E9FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jinshaohua', '金少华', '专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1AA850A47D064EEF952F18531530C344', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'sqh', '宋清浩', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '97A02184CAC04B54A6C0F0BDE097FD7C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'hunq', '胡乃庆', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DDDB73C1DA704A98AF75B1A99CBF8F74', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'songxiaodong', '宋晓东', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BCE21122CD8A4BF79A2A5EBEA7A7AA70', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'chenyang', '陈阳', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'ED42B5844FD644CCA22EBBC4140511D7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'quning', '曲宁', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '34225E4284B8466CBF8A5987069D193E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'tanqi', '谭奇', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C1CE02E6ACB74F1A9DA530D3D9A44C81', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'wangying626', '王颖', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BC9332774DF04A0A8EFCF89F4E984816', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'liujinghua', '刘菁华', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D31CD09C7FC84BC3837419841F841FC2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jin', '纪宁', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '843C6FFB4E2F4A9FB5D486D7285329F4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'intl', '海外机构联络', '曲宁', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '387B5747B0F14442A6AB8E8643772120', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'qiaojuan', '乔娟', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '34307AFFCC6D4D18BAE4AA440F855696', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'xiaofu', '付潇', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E55BD9A7F3834D1591D0219AB7E95DB9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'lengfengyang', '冷奉阳', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6290E0880A9B4FDEA23B15ADAF15B4C2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'czy', '陈兹勇', '部长一纪检组副组长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F53B14261BA14F769B1228B64ECA00A6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guowei', '郭薇', '专务兼副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0E766D6D23F548DAA6DE2873E89D92F2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guxiaozhong', '顾筱中', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E6232C4478F94F41AA04C0523077D9A8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangjunmin', '张军民', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '576CAEA8D913435DAAC8256F14C6D5A1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'huangqian', '黄倩', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '0586B26ED054417289CB71902A197B00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangp', '张鹏', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9D3E27ECA786459FABC0C1F0AB629230', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangshuang', '张爽', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C01ABBE19BF84702AE85F86DE1FE72FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'jubao', '中航国际审计部举报邮箱', '张爽', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '07FE9CD5659A477C9F0BF2C5B4B9FFA2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'shenji', '审计专用', '张军民', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '620EB6B238184EEE9614E601E35EABA3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'liuying001', '刘颖', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E0013296490D4FD7BE5FEA026352B453', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'sxt', '史笑彤', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '2128A1F8795241B8AD1FAA3CCA351739', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wudan', '吴丹', '部长助理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '56303AA2DECD43B4BAE6E26D544FB0E3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lipeng', '李鹏', '党委副书记纪委书记', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E1DAEAC30821444EA84DBB76739E57F4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhangwen', '张文', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5523EDA820FA4E5C883023DAA6E01148', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lily723', '刘美希', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '40BD55A189E94BFD975FECFDCFF7A4D0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'xuli', '许莉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '64903905308447848105672F71206ADF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wwt', '魏文韬', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '03448F2564D34F6C8E4A0A830DBBFAAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'mingpian', '名片制作', '刘美希', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C2BFDBF758C94AF084C4214D1837DE1C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'qywhb', '企业文化部公用', '许莉', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '3BE3C66A6D9049C79ECDFD1AC55FD311', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhgjyjx', '中航国际意见箱', '许莉', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '13A16797C0F244BC85B9BEFAE3EA17E0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'zoukangning', '邹康宁', '事业部总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F4877E5825774525BE898EB826558264', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'suzhenyu', '苏振宇', '事业部副总经理', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '788FEFF09CE0459782BEA6754B6F78D6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'hyw', '何跃武', '事业部总会计师', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '7D9728504A53466C8E56B978AD2CCCE9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部专务', NULL, NULL, NULL, NULL, 'yanna', '杨慧君', '专务', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '38B80400CF354F6487255D5734A7ADB3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'liuruiyan', '刘睿妍', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '711C1721CC5042A18AC0B6A439A3E3BB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'linxiaojie', '林晓杰', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '54A5FB4CE1D24037B2AF9FBDCAC97D4B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangbowen', '张博文', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '399771410D7241B0B5EA9E41DB740CAF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'qiaofl', '乔芳林', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '94437455DE92467FA65C10AFAC23127F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'yon', '叶宁', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B9B0937FE0C940C3AD9B08A5F4AD4AC5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'niuds', '牛德胜', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'BE0B102F78314564BAF22696C97BD27C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'jinbo', '金波', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5B4CD1D4ED4A4CE393517AAFCE3A56DB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangyuan001', '张媛', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1D1D054A006140ECB28325E750B4E15C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'ytt', '岳婷婷', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D22987191B294467B5BE9F2534C2D744', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'songchen', '宋晨', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'DF7B90F446D54AEAB6EF7B57A980DC5D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'hezuozp', '合作发展事业部招聘', '岳婷婷', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5060A6A2CAF148B0BE6E5B18326B1E42', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'lishengnan', '李圣男', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '58E08F690553490193CB6E9959C2789F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'liuhui', '刘辉', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1143ADF3842C4452AFF51B638FDAF96C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'xuyi', '徐奕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'D71BDCFE18844E8EB1BE8E82E7ECE8C0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhenghui', '郑辉', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'C031515BBB8B483492ABBBECDC3B7684', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhanggang', '张刚', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B4FB694BC7D24E49B81D6104E54E461D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', NULL, NULL, NULL, NULL, 'luchangchun', '卢长春', '部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B67B2ACD346741C3BA0756B537678F93', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyp', '张艳萍', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'B1306AB05EB843F7A161418D3DF01C31', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'lihuayun', '李华云', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'F7C2A17CC5774A8A8375E0A951185927', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'yut', '喻彤', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '1B7B694CCC054E828A1BA4BB499B4C5C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyi', '张怡', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '5A5FF7F189054A389375A0FFB375C639', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'shihuanan', '史华楠', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '696E2D7231FE407CBF71B9F716010E43', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhoushujuan', '周淑娟', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '4B2FFC95C27C4DF3A054BD9E68F3C65E', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', NULL, NULL, NULL, NULL, 'hanke', '韩可', '副部长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '51C3FBEA3AD64FE0A0D3A773BE545E2A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'shihong', '石红', '处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '01A2EF0501E04588AC8259CECADEB79C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'zhangmeng', '张萌', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '9772F8DBA2FC4C31A3F5D08A2D05BA57', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'gaochuan', '高川', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'E34B15E03575407AA5C14E03A8232DE2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'jxy', '景小燕', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '6BAE4960FFC14B588AEA86D6925A1A84', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'chenzhigong', '陈志功', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '39FF7796492349CD9F76CB6BC8395745', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'daiwen', '戴闻', '副处长', 'B2B519441EF845388120021D8EFA845B', NULL, 1, '84F8525263894A66BF477E90A7D69A91', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'liguangnian', '李广年', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, 'AF5BCE5AC2464024B25BD678D2312581', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'geyihong', '葛译鸿', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '37AAF212D64C4D8A90412DF04738BD8B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'zhaoyuxiao', '赵宇骁', NULL, 'B2B519441EF845388120021D8EFA845B', NULL, 1, '41BCC434308949F9BBDCFB9274026CEE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yangzheng', '杨铮', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F28737FC671E414DA72F8EFBFEE9AAAB', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'wangyao', '王垚', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'EDC7B02190B044D19EAD5B583D990BE3', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yanxiang', '燕翔', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F2C1256EE8894BCA844DBC328D17BBD3', '燕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'luojianbo', '罗剑波', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D19405C830984827A6A5203F07611346', '罗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'liqing', '李青', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '63766E0CD6B24546AF002F453D84AA4A', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'lisihai', '李四海', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7818210AC3404967BD5FE06DC6B770F8', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'jiangboqun', '姜博群', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '320E9CE1B86749A9969502A8FCA4993A', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'chengenhuan', '陈亘欢', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B147762B57EC4B9CB650BDCC7883402C', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'yangkai', '杨凯', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5E696FB9C19C451CB6465A251486F540', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'cuihai', '崔海', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C54B324CDAC746058FF4B187BF8898A4', '崔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'gaoqi', '高琦', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7E1F14C66D2E4419A7371E6A3A16803C', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'zhaobingxin', '赵冰心', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '79E81AAD1FB24CF8A5287F7F4D0C9A46', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'ahelibai', '阿合力拜黑那提', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '030DCEB9121F47E8BCFCF91576C2D74F', '阿合力拜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'luli', '吕莉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D745579B13BC41EAB73E0EE39A0A8B57', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'cuixiaoqiang', '崔小强', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '569E6016F7A944BBB3DDE9B4C9924BB4', '崔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'qiulij', '邱丽君', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E2856B033010435A80B0347278C93EAB', '邱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'feibinsong', '费滨松', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '4C144F0167184F9B94FB92B9B1388851', '费', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'suiqing', '隋晴', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E0CBFFE792B7410BB10EA0C55A615413', '隋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'liyixue', '李艺雪', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F0DB9828D6F847F591860AD6731907C0', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'guoyuchen', '郭禹晨', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9AE1F3E737B14EFFA1933D659C58AF75', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'wangzhen001', '王震', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6B0DFB8A870B435BA15902188ABB418F', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'baofengling', '包凤岭', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8A0A459A9140476DBE47F13A1B37FA22', '包', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'wangyonghong', '王永红', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2E96BB5559824E599CFF3531DA6C3EDE', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liguanchen', '李冠辰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D9B05F1B9FCB440A8DB94C8CD33619CB', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liheng', '李享', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C7D4D662988440DE886009EAB9874137', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'zhaoweizhou', '赵伟州', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BFD7D8655EE344BE8227E145AA588FBF', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'jiangsongyang', '江淞洋', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5DF156AA357941DAB63B1A70E7DFB7E9', '江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liuzaiping', '刘再平', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6CE7852D72714903843C789146909D98', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'lixiang001', '李享', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E3CEA80FECA841C0B03EC8DDA5363737', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'weiguangjie', '魏广杰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AC29B83712B4419F860555272F1A2D1A', '魏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lishichao', '李世超', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2CD98BB3B4AA47F0A8EBDB6DF72AC8A6', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lh0020', '李辉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B9783D654ABF4838AE0AD4ED83A4C826', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'chengyijun', '成一君', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5DD703EF67B9480681D8CAB3165F5A15', '成', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lvzhidong', '吕志东', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2944F6E244254ECAAF228F72B63BFD02', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'xuwei', '徐伟', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3E51884C149A43C7842707F95F94F086', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'jiangqingxiang', '蒋庆祥', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '55F576AEE412477CB3389447CDEC157E', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'dingyong', '丁勇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F18A5DD332AA4B7C994E253F5ED994AC', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'gengjianxin', '耿健新', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9ED29ACD608D430A850F6B17B8996B82', '耿', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'yinmu', '尹沐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ED641AC6D4C14530B70F3C0E19C0D81D', '尹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'nihong', '倪虹', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8481E276DE674761A4A50CA82D039FE0', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'yangxi14', '杨茜', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8AB5A4FF86FF458F9044FCE633671DDF', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhouyue', '周越', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A3FA9490184C4D78A22A738157A4C2A9', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhangfutian', '张福天', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '45535AC13D0B47A08101813A8660943D', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'miaoqing', '苗青', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8E55C1A7377645B6874E9A0AE2313E92', '苗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'mowenjia', '莫文佳', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '78ECF139CCC44BF08511C290D5F2140F', '莫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'liyangyang', '李洋', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3846C4E4B479475BBDFB5B8CBFE489A3', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'hanxinli', '韩新利', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D1859F6A45794F0EB353982E8C9A2A0A', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'hb', '韩冰', '部门副总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D7225A3CCBD740CDB17258E51EE726EC', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'gaonan', '高楠', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '69D2F217E9A44764B9D84CE43177E3AE', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'momo', '陈默', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A5FF80C3191C4B0E82E3C9881E19CEEA', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'wangshuo', '王硕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8E4AA97CEF154F0BB9B15075D85A7AF3', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'jiangh', '姜辉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1F948F2BC5F8401C976C938B63D15AB5', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'yangth', '杨天昊', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '947021FE647A44AA90CDC535E9565B4F', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'zhangxiaof', '张晓风', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3B7E77A1DD61479987A7A73A97672E3E', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'anqi', '安琦', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '38D11652DD924B3BA25BE39F3496D13D', '安', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'liuyang', '刘洋', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C3C5401598F240379B21D92D8D5FF03E', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'qiaosen', '乔森', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E80FE15F73094603AF19B7B2CAFA4D0A', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'zhouyong', '周泳', '部门总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E09566D27047456DB4D7ED932C2B1C20', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'sxg', '史新刚', '部门副总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8B0475CF6B7B494FBBB61A27146FBC8D', '史', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'beil', '林蓓蓓', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A180CE31753E458E9A6104081D688607', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'wangda', '王达', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C311B276FBAF4FBCAD63A8317C13E6F4', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'chenshuai', '陈帅', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '68332966055342AC80881774D32945D7', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'chenfei', '陈飞', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9BD8DD9B47334CC6BFA6C7DFB6C37D76', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'jiangshan001', '江山', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '32E1E8F7E31F4E27968B0C289753CA4A', '江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangxiaoke', '张筱珂', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '88CB4EAEA9E14D2EA957003FDC99F469', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangyi002', '张祎', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '4CBB128E6AF3466AA2B4CE12884760A0', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhayong', '查勇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9BFB5EB09A8241CBBB1DDBE300A308E3', '查', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'zhaoleiyu', '赵雷宇', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CB8E6ADAD8EE446ABC931D8C1D76301E', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'liuyu', '刘宇', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F41CFD5D8CEF497198B553486E37F53C', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'lilei001', '李蕾', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BBFCD13AD2B643AF9601D5A9ED063698', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'tianchunyang', '田春阳', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '03A1A3EC503E4E58AC976052B0D30E8F', '田', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'houjiafeng', '侯嘉峯', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '651554023AC3430E8F7B44E8DA7B5AD7', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'wusimeng', '吴思萌', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ED6CD1E1EDBF45338AC0FF116F20AA05', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'jiangping', '蒋平', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DA106569200241C991CB71BC0A9042F5', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'lht', '林海涛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BB96B73DA9914B58902B2D4BDD13B585', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'guojiexiang', '郭杰翔', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C6AC34E9A4844B08B1C9B3AEEE461836', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'hubing', '胡冰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D1605543CCEF4FD6A423F3F743EF2988', '胡', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'wangxiaochen', '王晓晨', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0EC079ACEEAB4FE8A74CF98916273E4B', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhanglu', '张璐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '042C81EDAA084D03886E78FCBD63A0E8', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'fjcwurui', '武锐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2B701E6FCE1F40BEBB5CC7186284D63A', '武', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'huangbowen', '黄博文', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D2904C0305A541ADB37581CF7240C311', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhumingshuo', '朱明烁', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A7D639AAC6B74E4995EFAD0DB6ED8726', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', NULL, NULL, NULL, NULL, 'guolichuan', '郭利川', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C77419F4BA794F399570A9B81E9CD64F', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaoyajiao', '赵亚姣', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7D15E771FAA9473B99BB6C6ACB37F022', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yinjie', '殷杰', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'EC977F97D0B447F48B2F5A741E91F4E6', '殷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'jiangyuting', '姜玉婷', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5C98EF961CF94B26B167C76024340955', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'lishuai', '李帅', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FF2F6C79219B493FB67571BF46A83E66', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'sunyan', '孙妍', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1C13C0133ECD4C42A23C3B6FA2688CC5', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'wangyang001', '王洋', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '852F1FAE30B64A09A2D9EB7E6AD740A4', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yanjunxi', '闫俊羲', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D1E3CD322E2F4A6883B69237351A204E', '闫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaokeqing', '赵可卿', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '35642D4611334167B71C34A1F8AD5B72', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zuoxinyang', '左心扬', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9A627E3A70704F18A2CBFFB9AECE2A8A', '左', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liubinliao001', '刘濒辽', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CFFBF05B1878433491691DC8DC8F0719', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'shenghua', '盛华', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '278A012A0B434C2999C074AC2DE450F7', '盛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liuhuayi', '刘华奕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B707E2968FDA4B7589CA832374FF265D', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'lixiaomeng', '李晓曚', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8D9C34C39A0D446890BDDC0415E4D962', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhanglinyi', '张临意', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '69F6EBFE82104BA3B59E0A74199F02FB', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangsai', '张赛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C31118C58DAF4E9CB68CAC6D5D0C99B4', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'chenn', '陈楠', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '97CC560045D64607B94B47B6EA0F1E01', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'qiwenjuan', '祁文娟', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BFF74BD6A35346D8BF209B397AEE013E', '祁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangzhen', '张振', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '4B908DCEB28C4807889FF66BE6CCA60F', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhuwenting', '祝文婷', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7D65D97F345B48E48EB17FB75931D9EA', '祝', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'songling', '宋凌', '事业部总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E7C1E1E01F3D4F29BAF751AFE85F5DE0', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'elu', '吕中华', '总会计师', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C0FC5EFB483142A685C373B92C759783', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'xubomj', '徐波', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '79E82866B7604EB788AFEDC89A67E3CE', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'heran', '张赫然', '专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E0B9C7675912420BA4711FFEF5A47E80', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jinxing', '金星', '专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E573C4CCBCAB49228219FB03186D73D0', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'wangxiaobo', '王晓波', '专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9100B55A172E46AE93DE0C50A697E528', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jiangjin', '蒋金', '专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7AD08496CE8A4A71A829DDBE4462E828', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'lilaclinda', '林征', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C0D46E1CB33449A6AC30BD588D66F126', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'suqian', '苏倩', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F0555D858173496D8AA177202B35450E', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'xujing666', '徐晶', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AD01DF203D8B421AB0CFA707585DE77C', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'jiaomeng', '焦萌', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E5E812B6E1AE43AFB088E1F43C3BECEC', '焦', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'fengbinyun', '冯彬芸', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8C5EC4E273EE42B1B16DE88CC712BDCF', '冯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'guxuan', '谷轩', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BD07D2B10B8747358437B92352B8FF1E', '谷轩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'wanghao', '王昊', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '464AABD525BE4A3FA1E9FA4A5DFDAE76', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'zhangwenfei', '张文飞', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'EA83C00CB1704CB7A87A77308A61AC7A', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'yyzc', '航空运营支持事业部', '王昊', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3E5C64124A914929B3CEE4DAAA38BD31', '航空', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'dingli', '丁黎', '党建人力部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '54FFDAE5EF034476B32DA6DC9B59A4F3', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'xuchangfeng', '徐长凤', '党建人力副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B626ED865D1748C8B0ACF621952EE6AB', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangweichen', '张伟琛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C052BB03B40B4D73BCB2D5B3CFEA0CC8', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'huanghe', '黄河', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C80F1198A09D4D96AD8E4D31F95D46ED', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangyanan', '张亚楠', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C96B5930A88D40858CDDA9DAAB271E0B', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangxuan', '张轩', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '03A8CAD0391E4DD39BBB4A577AB8B2DB', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yuhao', '于浩', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '353FBFA1CEC543CABE924109A23F25AB', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangzhaopeng', '张兆鹏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FBCD4AAFB47B48BFBACD14B5A821859A', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'daishouhua', '戴寿华', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F8574D06EBBF452B8B51C2588740C8C6', '戴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yanbaohong', '闫宝红', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3A67FCA015EC4334A308AD859C0C5290', '闫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'lihongjie', '李鸿杰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '41F66ED3AA5E479D9F0D7A46825EDA2F', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'wangxuejiao', '王雪娇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7F539EB693C347ACA3D272E5769C2C70', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhudan', '朱丹', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '93EA7250553C4839B1C0BFFD75186A7B', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangshuo', '张硕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F05EC60845124C1491ED6C1FEDCFB50A', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'shiyanfeng', '史彦峰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AEDDB522A09E41E4AA35E9DA748B2F56', '史', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'yangkunbang', '杨坤榜', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '18DBEB2EDFCC4219865C0F469665F40A', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '董事会', NULL, NULL, NULL, NULL, NULL, 'jyan', '焦燕', '董事会秘书总法律顾问', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A86CEF8A4D964FD8AF1745D7FE3D900C', '焦燕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liuhd', '刘洪德', '董事长分党组书记', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F5439C05C1D5454FA2744935E778ED8A', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'laiwx', '赖伟宣', '总经理分党组副书记', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '69D530B87E1E4ED89A7F2E89C5F4DF1A', '赖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'chengbz', '程保忠', '分党组副书记', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3926AC450D724AE890930FAE2515EC01', '程', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liujun', '刘军', '分党组成员副总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5840196810DE4A86A166EBCA1A80CE20', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'diaoweicheng', '刁伟程', '分党组成员副总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '589152FD0BF24D448816C357A55284E1', '刁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'hanxy', '韩晓阳', '分党组成员纪检组组长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AC89B066E3364900AB37BB1F360194E6', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liqifeng', '李其峰', '分党组成员副总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '4A285EBD60734E6A8EAEFA8296CEC75F', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'fufangxing', '傅方兴', '分党组成员总会计师', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '198A7D79FF52494FA964327E6A275E5E', '傅方兴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhui', '张辉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '455FB732BE4E40C79217E4034CC234D8', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'wentao', '文涛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BA1E68A5B2B9486598B91EF5C75CDAF0', '文涛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'huangg', '黄光', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C6031BD3AC4C4E62A5C6BC3764882501', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'yangyouqing', '杨有青', '高级专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '05268B5DB38342C39358E892D07BA298', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhangguangjian', '张光剑', '高级专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1082F24CDDD2405F988A64C8FE372235', '张光剑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'xiaoyi', '肖益', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '024C083A6BAB4E769128704B98EBCFB9', '肖益', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'chenhongguang', '陈红光', '离退办主任', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9AC114369B3D47AC9957792B4493ED7A', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'czg', '陈志刚', '安全生产总监兼副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '04F2B4B42AA440D7AF0025A79D266B37', '陈志刚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liu_jie', '柳杰', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9CBE864A25CA443F806B41CB580C7ABB', '柳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangkewei', '张可为', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '255529222D104895A7A3E4BE8E8A08F4', '张可为', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangxudong', '张旭东', '业委会办公室主任', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3558B3ECA35F453F8FAF32E5C1126E03', '张旭东', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lisiqi', '李思齐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '239A080DD20E449398567DAFDA7134A4', '李思齐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'panwm', '潘为民', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5A5BAB4C961647BA8C9CDB251EA87516', '潘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'linjinghui', '林敬惠', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E2679C9956744BCDA7E1832826350B08', '林敬惠', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'yangqing', '杨青', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '25C52BB88D57476D8B43A0082C452D2F', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'shenfeng', '沈枫', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DDBE05D3056C4C1DBAACD8C155167605', '沈枫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lpr', '凌佩冉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E0C247E1773349FF9B4DAFC396D4F65D', '凌佩冉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wulw', '吴力伟', '车队队长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '49CED7C236BD40968227088724116DBD', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wangqian', '汪黔', '司机', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '914C78B59BFB4C9FABD922FDDC32EF8F', '汪黔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liushujiang', '刘淑江', '司机', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B1387A9CD7484370A027B56028BD014C', '刘淑江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'qilianghai001', '戚良海', '司机', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0C0631F17E884059B364D9D9F6F51F34', '戚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guanxu', '关旭', '司机', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9099CF45B43743D8AC9DB5D512AE60C9', '关旭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'luchunlin', '卢春林', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '265275D60D394FA7941A91AB540E2A6F', '卢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'meetingbj', '北京会议室', '林敬惠', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ADEB546A61EE4784857B7FA36855F9AA', '北京会议室', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guoyuxi', '郭宇溪', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9EAD613C51AE4DF0B28F5C0F2D74262D', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'sf', '沈枫', '公文', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0A0C3A8FD00149BB927E71D32841E6AC', '沈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'avicbsinfo', '工商信息', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '67BFB904099C4D08806364C2F6DFC156', '工', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'sunyu', '孙宇', '董监办主任', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A1A141C4AC304B04B240EFAFFFC80450', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'liuyi', '刘裔', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '349C3994DAB844A08CE70EFBF406F448', '刘裔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '修史办', NULL, NULL, NULL, NULL, 'hbin', '黄斌', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7D14B4AB27EA4A6382CBDE560E952318', '黄斌', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'wanghong', '王红', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '147E32E6AD314659B6309284C9964A5F', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'luanht', '栾海涛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F587D61FBF67471A8C36C019641E7D8D', '栾', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'fangxiaohua', '方小华', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7CDFBD8E182D48C68B6B4FEF81EDC8E8', '方小华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lixin', '李欣', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FEB48E5F903448C99A0401C7CF03489A', '李欣', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'shaoyong', '邵勇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DAEE9A3E82054F7CA23AB5A072216600', '邵勇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicstj', '中航国际苏同骏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6B0FD7DBC684427C9FD71455728C7293', '中航国际苏同骏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhangjie001', '张杰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '798F706D0BA34FD68A7BA8CCE6E470F9', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'licn', '李承宁', '公司专务', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B9AEFE96A06B47919D89BFBCFDC501DE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'liubinliao', '刘滨辽', '贸易部副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '87738FC1B655460AAEAFC24576F3D30F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'yel', '叶岭', '投资公司总经理助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'CA150DA8EF7F4906A2FD7DE9BC61B433', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'juyanfeng', '鞠岩峰', '投资公司总经理助理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BF138703EB82402EBBC5FB22B8C509AA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'fangdaojun', '方道军', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5FC8D178508D49F4B53CDC841BB62B15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'waferlinjining', '林纪宁', '财务副总监', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '7F07FF1187B44D88B1F9FB6D456889D2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhaoy', '赵扬', '财务部副财务总监', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2632CAC3F6C048BEB3026D521F5BCF82', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhousha', '周莎', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B3993EEF297B458EBBFC8F6CC54693C5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'wafertangir', '唐岳震', '总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3B3C7F5A28984EC89E6C003A8AA87C37', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'lihao', '李昊', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '76E2AA98C2784B33B59923689F12DDED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferfengqiao', '冯乔', '总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C012559039E947B599401D7293D60A0F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferzongdian', '宗滇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '1ACEE47F319047419183C09759601E86', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'zongdian', '宗滇', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E6AF4ED216EE49968AB1E19AE3115784', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '柬埔寨代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun', '孙会兵', '总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B074621C7C5C4B748B6E146969FCF389', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度尼西亚代表处', NULL, NULL, NULL, NULL, 'waferzhangchenxiao', '张晨虓', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '23ECA7034EAF4B1CA3A9C711A2860808', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度代表处', NULL, NULL, NULL, NULL, 'luxiuchen', '陆秀臣', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'AD33723F148B4888AE9FCEF71C69A21B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'wafersunhedong', '孙和东', '副总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '91FF9E3ACE914C7E97DF6DC76E21EA01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'sunhedong', '孙和东', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8C6D56CCE74F457E9E1431A4E6234C0B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '塔吉克斯坦代表处', NULL, NULL, NULL, NULL, 'waferchennan', '陈楠', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'FA6B1914307D4CDDBE07E38D034C69E2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '老挝代表处', NULL, NULL, NULL, NULL, 'zhanhongyuan', '湛洪元', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2975BE6BE6D6461B8461CE6829D63FFC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '肯尼亚代表处', NULL, NULL, NULL, NULL, 'avicct-sutianshu', '苏天舒', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '25F2CC3C73994461B7148FF6E0B24941', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '赞比亚代表处', NULL, NULL, NULL, NULL, 'wafercuiji', '崔季', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '48E6A7C6E93C41F494A3A2E8A839C2A5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃塞俄比亚代表处', NULL, NULL, NULL, NULL, 'wuping', '吴平', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4F4D7BB0CDD945DBA651D8E874AD00D3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃及代表处', NULL, NULL, NULL, NULL, 'waferyangjinshan', '杨金山', '副总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8BA75ACCDDD44A4586307C573E793C0C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'lihuan', '李欢', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '21521478427949B9B29586924134EAD8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'yangtianhao', '杨天昊', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '905797D066654F5C845491F681135DB1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '乌干达代表处', NULL, NULL, NULL, NULL, 'waferdingsonghe', '丁松鹤', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6E1B333397E248CE9D6D28CD5B9D7034', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加纳代表处', NULL, NULL, NULL, NULL, 'waferyuhongpeng', '余鸿鹏', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BE2BAB30FE8D4E6D96771091B6C11458', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加蓬代表处', NULL, NULL, NULL, NULL, 'wafersunyang', '孙阳', '副总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2C8947977AC644FC911E5A374335CD7C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '刚果代表处', NULL, NULL, NULL, NULL, 'zhangxf', '张晓风', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6A75A3A66B4E4C0799565F55ADD40D68', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '科特迪瓦代表处', NULL, NULL, NULL, NULL, 'wafertangzj', '唐忠杰', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B9836D4C06504DE8B73F4FBAE0D9DF53', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '津巴布韦代表处', NULL, NULL, NULL, NULL, 'wafermachengyuan', '马骋远', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '3710AF29768640FFB7184B458F61AD77', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '莫桑比克代表处', NULL, NULL, NULL, NULL, 'wafertierigen', '铁日根', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0CA68E93800D4006AFC3B675BF937EED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '喀麦隆代表处', NULL, NULL, NULL, NULL, 'jianghui002', '姜辉', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BAF1306BF80D4A33836246AA61C4C4DE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '尼日利亚代表处', NULL, NULL, NULL, NULL, 'ganlijun', '甘黎军', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EF6B97A71B49478C8FBB2ECE1CDC3BB5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '安哥拉代表处', NULL, NULL, NULL, NULL, 'suiyongjie', '隋永杰', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '8B9E992718CA43A393C38F16D37378CE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge', '德国代表处', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E7C082A60B064CAC88DA309C84015803', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge-ltd', '德国公司', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'BB229F987FA943D88711F0C5F47F6377', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.germany', '德国代表处', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '4C7F701B332E41059821535DEF1C4131', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'chenzhen', '陈震', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6D6F639376A148C38AAEBF83512658D5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'liqijiang', '李琦江', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'EE02FDEE93C54DD7B68CBF0CA8ACF25A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'sunjian', '孙健', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'D0ED355B1F5047469A98F9877A5CBFE4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferzhangyulong', '张玉龙', '财务代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '310011CD5CB04B579F77E11BD4E6C140', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferliyudong', '李煜东', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C9E3253DB99D4717ABA4D6E71E4CD548', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermikelou01', '娄玉成', '总代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '400749B20B3F43C48856716D803ED4AF', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'waferwangsh', '王双', '财务代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A527B6417FC048C69580AEFF54BBCF60', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermenghaitao', '孟海涛', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '2801967B6C6F46CE9DD8B697EA615962', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国公司', NULL, NULL, NULL, NULL, 'wafermikelou011', '娄玉成', '总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'C187A07A590C4D64BE25724EAD206653', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '德国代表处', NULL, NULL, NULL, NULL, 'wan', '万春雷', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'A32820DDE1534A0DA6E91F3AAD63247C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '俄罗斯代表处', NULL, NULL, NULL, NULL, 'waferjp', '姜萍', '财务代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '758195DC48224A52ADB886DF26AE7FE6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '挪威代表处', NULL, NULL, NULL, NULL, 'huanglei', '黄磊', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '6B726D7AC25349289632F0D7AB840B53', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'zhangxuming', '张旭明', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'B4CD3E454FA44EE5BABA4C3B6F69D098', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferfrankyang', '杨方', '副总经理', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '0E218448785645A6A47458BF519CFBC7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'hanke001', '韩珂', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '5B70144552814688B954AB73C64DEAD9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'emyang', '杨明', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '714875E273AD4288B96832354867CC64', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferliusujin', '刘苏晋', '财务代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '34F816B34A6D46E7A514AAA8215E8BF3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哥斯达黎加代表处', NULL, NULL, NULL, NULL, 'waferlingxinwei', '凌欣伟', '公司代表', '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '24B0EA2402F44EFF886E291E0EC5A3A6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '古巴代表处', NULL, NULL, NULL, NULL, 'miaojingdan', '缪景丹', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, '96535F2DFF6245B08A91B7633359EFED', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '巴西代表处', NULL, NULL, NULL, NULL, 'pengbo', '彭博', NULL, '6894D8B91C034CAC9BF1FC4946A592D2', NULL, 1, 'E67407020AB14CEBA003692E58F6863D', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES (NULL, NULL, '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', '6894D8B91C034CAC9BF1FC4946A592D2', '重复的工号', 2, 'DA450CA13F9545888426DFE087C3A138', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', '6894D8B91C034CAC9BF1FC4946A592D2', '重复的工号', 2, '091965C20C20429DB3C295CA97F21812', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'xuli', '许莉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9F45792D023D4CE7A37B6A063AF91894', '许莉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wwt', '魏文韬', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6EBB5E39D74B4FEAB4E960666052CEF0', '魏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'mingpian', '名片制作', '刘美希', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CC639755F9DA48F883831A070EBE23F0', '名片制作', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'qywhb', '企业文化部公用', '许莉', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A3E2EA4C5A7643B4A1D698079230FDEF', '企业文化部公用', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhgjyjx', '中航国际意见箱', '许莉', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A5BB220DBA53459C8B087F3B5A2359D8', '中航国际', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'zoukangning', '邹康宁', '事业部总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D6C8AF4392AA4DE3AF60637D0D3A1531', '邹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'suzhenyu', '苏振宇', '事业部副总经理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DC1D9C6D90FA4DC1B8816B00F31ECBFC', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'hyw', '何跃武', '事业部总会计师', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B15E043F50B1462CB2A3CC015B3A5864', '何跃武', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部专务', NULL, NULL, NULL, NULL, 'yanna', '杨慧君', '专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2357B426410E4211AEDDA37321DF7889', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'liuruiyan', '刘睿妍', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '729DCF0C65E24D86B5F2165911E6DA84', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'linxiaojie', '林晓杰', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FEB7CF0E48FF4439BBA813F81E96E901', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangbowen', '张博文', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '108E1E599819440199F740F202A7A9F9', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'qiaofl', '乔芳林', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '206F7CAA83E34A729587E11D78AE5185', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'yon', '叶宁', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9F166FCDF6CC4D599742C59F42E7A4C0', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'niuds', '牛德胜', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '95D4170FE8BE4F8BB9D65F66973C6901', '牛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'jinbo', '金波', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CB44B938F0634F8883BF18A56FD161E3', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangyuan001', '张媛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '074E652D943B4B3191EB264AFA9DE419', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'ytt', '岳婷婷', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '51F6F292C77943979485F098B736688C', '岳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'songchen', '宋晨', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7E944FFB09EE480981660E6CDF0F5104', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'hezuozp', '合作发展事业部招聘', '岳婷婷', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B398EBD2E10344C5AFAB0C6393C0C825', '合作发展事业部', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'lishengnan', '李圣男', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2CA34D867818439FA699097759EC0D6F', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'liuhui', '刘辉', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'EAE746528BD44BDFA2C2B12A3FDCECBA', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'xuyi', '徐奕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '473EDED0A66C477F8BE63D047789AD9D', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhenghui', '郑辉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '04DD53D276C04171812CFD7F81B6B796', '郑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhanggang', '张刚', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FCC66818A1C04CE78AD3D97276B2E53A', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', NULL, NULL, NULL, NULL, 'luchangchun', '卢长春', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7A41AE9ADFB0422EB503315524CCFE30', '卢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyp', '张艳萍', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '060A6699B812484E89EE64A0FBE974C5', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'lihuayun', '李华云', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A8C5FBF5E6094131ABCFC11C5FF6165D', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'yut', '喻彤', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CB05E4BE98ED4242BDCF318C926CE882', '喻', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyi', '张怡', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1C059774DA244C7CB9147094EB7A8FD2', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'shihuanan', '史华楠', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5E2B48BBE5E54622975EE73003F14CDD', '史', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhoushujuan', '周淑娟', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2C9561339700444792A48B913C445FF5', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', NULL, NULL, NULL, NULL, 'hanke', '韩可', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '93C0A995D30247EB8A79C852D1A6F822', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'shihong', '石红', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E05FB8A95C314C3DBD76990D04F5EB58', '石', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'zhangmeng', '张萌', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AFF543B50E204ABA87CFF7F93771EAF4', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'gaochuan', '高川', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '35EA298112B042DCBAE562E953950505', '高川', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'jxy', '景小燕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '23F563E6E2F54B0B8864CB7979274333', '景', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'chenzhigong', '陈志功', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BA8CBC01F37C4617BC0E52F719DE5BD2', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'daiwen', '戴闻', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '43D7610381A8495099FAB19C47CD3AB8', '戴闻', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'liguangnian', '李广年', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '99411FC94D5B48D09C3824CC2B7CBB91', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'geyihong', '葛译鸿', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5F0A76E031594BCAAA8BD62ADEC896B0', '葛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'zhaoyuxiao', '赵宇骁', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D27BADBA76D04AACB77E5F3C4AE08A60', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', NULL, NULL, NULL, NULL, 'xuyonggang', '徐永刚', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3EEC9B73232E4610AE77B2143079D4CB', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'wangxuefei', '王雪飞', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9DFD60928A9441FA89F88C84EB0C08FC', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'zhaowenzheng', '赵温政', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0FD394609F284A2ABF6FA14F87CAF253', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'mhf', '苗鸿飞', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '418C92008A734F6C9C5B8E3F92F15177', '苗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'jianghui', '姜晖', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '894B8FEDD557497CA19F5AD4928ED07E', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'huangxin001', '黄欣', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '223D3F7785D74425AB7F54297FF7F69A', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', NULL, NULL, NULL, NULL, 'zhhui', '张辉', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C2DF685F57D14EA280517E97F04EAC8E', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'miao_sue', '缪苏', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FD084DBD1C8B442588B6B2D098A8E289', '缪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'yesheng', '叶盛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ED4E9E8B341648E6B192C0AEEF14552C', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'liuxian', '刘先', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8B6FB56978A844E3A5323B0D10CD3857', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'milong', '米龙', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9386C23208C14C968BB35CC5A8DB3599', '米', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'wangyq', '王雅琦', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1F61AD2DE8274B20A1C2AD7A4C729472', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'avicct-tianyuan', '田园', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6978856D54B24E8D9B48474014D666CA', '田', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'yaolai', '姚来', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '24B57D1B75CC4FFF883685EE85C201A0', '姚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'marongze', '马榕泽', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FC781774968246D5A3C2E0463AA980F6', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'liwanyu', '李琬玉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '4166FD46DE68422F9C18B48F9F0999C2', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'ningjing', '宁婧', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A9F8FFF2D0A846CDBD49C34B853B49A2', '宁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangfeng', '王丰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E9C1B1C53F0B4FB7AE4153052C6EB046', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangyan001', '王燕', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '047223259DD843C0884690981A81FCCF', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'xingguanghui', '邢光辉', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '21B13B6B41FF4DF78404D81CAF6F7BA7', '邢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liduanchang', '李端昌', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D3311771C4294EC8B3AB8824BC50D944', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'linjianxin', '林建新', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A0F4FB11749342DC8E857CAECEF26013', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liuanghui', '刘昂徽', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DA03DADAF3FC4D27B6654E925D6B4F6F', '刘昂徽', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', NULL, NULL, NULL, NULL, 'jinxi', '金曦', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F10CE94E667442BFB35255A2438AD53C', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangzhenxing', '张振兴', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E766DC16BB58489AB405EBE9C6ACA783', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangxiaofeng', '张晓峰', '副处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8E827CA2FFF64A80AC33060F5B3622AE', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'guojiesi', '郭洁斯', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '831523B4466F4F748AAAA5C1B17B4E66', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'liangxiao', '梁霄', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ED7EA2302ED7469394B373EB41F39E88', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'yuxi', '于曦', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6ED27785E4DD49C2B90881383F7EA170', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'fangzhou', '方舟', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E6537FD9B23C41979A879E1B44B5EE6C', '方舟', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'lisonglin', '李松林', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'CB94DB7EA4414BD3A57EACA4AC4C2126', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'duanbaorong', '段宝荣', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'EA1A7A27FDD7434C9645CC6DAD4F0074', '段', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'songchao', '宋超', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1C091E78EFF545DDA49BBC5A9FCBF6FB', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'wangxiao001', '王潇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '96438E3AF07F4B88BF3783BFFE8186EB', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'mada', '马达', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '140AF2B899884B4B95AA2A9EA20D92F7', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'huangsong', '黄松', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C3F34D44CBED49F7B94AA53AA4C48AFD', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'guoyongpeng', '郭永鹏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6976B4A0768649AA8031A62CAFBAEFFF', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'xiongkai', '熊凯', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F0ABE1AF56814A0FB967DDC5D72815B8', '熊', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'heran', '张赫然', '专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '01213F2091B9425995C1D5B056BABDB8', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jinxing', '金星', '专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7416D4418C4D4BD4912832BA00C96E40', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'wangxiaobo', '王晓波', '专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '736B57DF9BBA41EBA7B519A073F517BB', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jiangjin', '蒋金', '专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CCF5FE8E158F43858CCA7F6E611F0B52', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'lilaclinda', '林征', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7A6E497B4D73469184E4AC9F1B419BD8', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'suqian', '苏倩', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '29DB62D6AC1E466DAD2B79DDF4FD4B6B', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'xujing666', '徐晶', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2268197494F6475BBA6AA74280381AF9', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'jiaomeng', '焦萌', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '481EF9AD53DE43A49B79F25005B7C212', '焦', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'fengbinyun', '冯彬芸', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '59FCC505D7B740A8B06C77E8091A1DB1', '冯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'guxuan', '谷轩', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8BFE6B92E3934626A0F73DF373FA81EA', '谷轩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'wanghao', '王昊', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '94A016665B784DE78851F3AE220339C4', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'zhangwenfei', '张文飞', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4B93F8A9D749408C9AFA87D93E203289', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'yyzc', '航空运营支持事业部', '王昊', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '88C3C6D39D5B44628AA8E5808112E0B9', '航空', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'dingli', '丁黎', '党建人力部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '879990EE68EF46F9BCDFB02CCE186789', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'xuchangfeng', '徐长凤', '党建人力副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A0E2252C3E2746D49D25F26D516AA2B5', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangweichen', '张伟琛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '172A98E73DF0426CB470237B4891ACEB', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'huanghe', '黄河', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1B879015C1914E96A68971D64A53C912', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'zhangyanan', '张亚楠', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A7AF23F4AEE041AEA4C06C44B88B8BCF', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangxuan', '张轩', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3F976C5A1BF64E6C9A431AB0F0CB29CC', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yuhao', '于浩', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '76059D21EE164730B3E157E3C684092B', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangzhaopeng', '张兆鹏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7B2567664981427D97A147771E606D30', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'daishouhua', '戴寿华', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0BF20F7FA1444499B61621B8DCAECDD5', '戴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'yanbaohong', '闫宝红', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8185556F499E4E4594D38AF0771F3878', '闫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'lihongjie', '李鸿杰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1311EC8352BE497B95129AF007967BA7', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'wangxuejiao', '王雪娇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BDE2DF3E9E404CD69D63E9246B6A4BF7', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhudan', '朱丹', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2A002FCDD8214B639A8CDEE725313FC1', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持财务部', NULL, NULL, NULL, NULL, 'zhangshuo', '张硕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '74B9BE8249004CA69E3799C0780FE467', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'shiyanfeng', '史彦峰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EF606D71F6564722839ECB748FE9B034', '史', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'yangkunbang', '杨坤榜', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '93D1E6384CF446F9BA075B3C084D3552', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', NULL, NULL, NULL, NULL, 'lisonglin', '李松林', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1B731A6DBE134C3FA0E9D0E2C3CDDFCE', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'duanbaorong', '段宝荣', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D2D30C62F6FD48FEAF49C121ED9AFD05', '段', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'songchao', '宋超', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'ACE11CE1A4474226B3B741762BFEC99C', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'wangxiao001', '王潇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A87CDA2D41C84399B5EF8E3D89860916', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'mada', '马达', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A030C036137540D5954150F5541F8F4D', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'huangsong', '黄松', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '295EAE09062748D3A2DFBEF061839B97', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'guoyongpeng', '郭永鹏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CFDEFAC9A1424ECD87B193BE273E6FD6', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '亚洲及南太区域中心', NULL, NULL, NULL, 'xiongkai', '熊凯', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1E6FE22B6D594D8E9970847AACFBF0CD', '熊', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yangzheng', '杨铮', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FF2C3EFF285044D1810A80CC646AEEB6', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'wangyao', '王垚', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DDFE404A09A243F9B29DE71E2025EA14', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '东南非区域中心', NULL, NULL, NULL, 'yanxiang', '燕翔', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EF359D968096481A9A6E88439E6C5B84', '燕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'luojianbo', '罗剑波', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '198A55C49CE94C94BC91822277FAD3FD', '罗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'liqing', '李青', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '15BA1049A4DE41758444168FE14E17B8', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'lisihai', '李四海', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A3474F907D4D418090CA8F6D3ECB3733', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'jiangboqun', '姜博群', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B279613DF04E4EB1A5A91564C615BF96', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'chengenhuan', '陈亘欢', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1963243B299E4FC899A76F9A9C51B443', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'yangkai', '杨凯', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B6DB7E179EBE4620A7ECD2037E10A5ED', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '拉美区域中心', NULL, NULL, NULL, 'cuihai', '崔海', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A4B13688073742BA890EFD026E8E9DEE', '崔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'gaoqi', '高琦', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C0EC4DE16C4843D189C4A4BD55AE071B', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'zhaobingxin', '赵冰心', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BE9286DA18F84AF09E271DBBFD4DB4E8', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '俄语区域中心', NULL, NULL, NULL, 'ahelibai', '阿合力拜黑那提', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '060106A5A1DD46EC8FD93178E2ACF7A4', '阿合力拜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'luli', '吕莉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A6E5C757A3D740DE844855093C90519D', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'cuixiaoqiang', '崔小强', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '281CDD4F1CE148AEA3BAEB78324D1465', '崔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'qiulij', '邱丽君', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '77B1E41877004EDB92DF82060A0C6D4D', '邱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'feibinsong', '费滨松', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A1BFBE597F5E4484A6C2EA6F494CCC91', '费', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'suiqing', '隋晴', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BC3F5C7C16E64AD79D242713D54F3FE9', '隋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'liyixue', '李艺雪', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4AE8E345576844448AE3D25AE4F15B38', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'guoyuchen', '郭禹晨', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0E49BB15FC4F4ACF8F9F6DD6455C0BD1', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'wangzhen001', '王震', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1826460812B9495AB23CCA5F2623BE6C', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '营销支持处', NULL, NULL, NULL, 'baofengling', '包凤岭', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DAF31D69725649EE933D3EBFBBBEB0AB', '包', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'wangyonghong', '王永红', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A77D757822AA4480969B4F5E3DC38B2B', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liguanchen', '李冠辰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D5A592FECC5F45A396C3F9E55D666288', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liheng', '李享', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '713EDE7E40F14878936399F23209CDF9', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'zhaoweizhou', '赵伟州', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '72A64D73E1014E2FA0592E6AC35A0B86', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'jiangsongyang', '江淞洋', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '10D646C4DFE44031A71B2239A6841B06', '江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'liuzaiping', '刘再平', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E6173A3974BE448180EEC32605266228', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '商务工程处', NULL, NULL, NULL, 'lixiang001', '李享', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D6EE643F51B0440F8AE4002CCE68D5E6', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'weiguangjie', '魏广杰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '02B62EA956954433A90FDF3F482935C0', '魏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lishichao', '李世超', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C89F023DC78B436A9918B31B3908E8E8', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lh0020', '李辉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '64E3E8D07C6C44B2832E7BDC71B144E3', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'chengyijun', '成一君', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EE3266DF070F4398B7926FCB51033754', '成', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'lvzhidong', '吕志东', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E7E727F2669F4404AAABA2BF0C22D8F3', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'xuwei', '徐伟', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '62C8FEE2BAA64D0DB5ADB02422EC7FC1', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '客户服务处', NULL, NULL, NULL, 'jiangqingxiang', '蒋庆祥', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '08D96ACBC2BB4BEB8081706C61B6E3A8', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'dingyong', '丁勇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CD7975EEBE8645C5B2BBA8EC6AABB613', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'gengjianxin', '耿健新', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '73C6469408DE4EB69A12F29EDE15CC19', '耿', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '运营发展处', NULL, NULL, NULL, 'yinmu', '尹沐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F44A2EE7FE904EFC94FFC462495E0939', '尹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'nihong', '倪虹', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EDA719D6B51F4F99A771CA72040AFCB7', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'yangxi14', '杨茜', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '62030FDD7698406DBDE25EA9C249B458', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhouyue', '周越', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FFEDBA9014AE4F56A67E5574246B180B', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'zhangfutian', '张福天', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3859B2EAFB664A9CB76A5F950DC91515', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'miaoqing', '苗青', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2B31E0E40FA44AE3A1FD77B564C740DA', '苗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'mowenjia', '莫文佳', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '20AA623BC2F74DC689D8A2AF84F5F715', '莫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'liyangyang', '李洋', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E2AFAA1527E0497AAE4E24A3F5FBF965', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '航材保障处', NULL, NULL, NULL, 'hanxinli', '韩新利', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D8F060A16C154531975C65DDF0B6074B', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'hb', '韩冰', '部门副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '421842E2D8DC4A13B00B361B596DBEA3', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'gaonan', '高楠', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2930EDA0D4FE4535B8A6DD50A94797F1', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'momo', '陈默', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9C4AD09A6A184E03985DC8F0D0B211D9', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhqy', '郑启源', '公司专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F636B967BE9B411FBBC6F1C4E55E9E84', '郑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'guanlq', '关力群', '公司专务兼行政总监', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '30069B0A875E4C3EAAADB7E04AA41C94', '关', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'licn', '李承宁', '公司专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CA5834631B674B8B8CE2D2F2A4301F82', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'liubinliao', '刘滨辽', '贸易部副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BF9BE657FFAE40309237748BB2CA9094', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'yel', '叶岭', '投资公司总经理助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8519C6996976461BBA69E824A9D838F4', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'juyanfeng', '鞠岩峰', '投资公司总经理助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6F14A45F1067489286A33A63F6F0A4AC', '鞠', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'fangdaojun', '方道军', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4E97B229E047418DA1E90BA931E45BE8', '方道军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'waferlinjining', '林纪宁', '财务副总监', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1F1B8AD6B59149B48EC1FB9928C3C98D', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhaoy', '赵扬', '财务部副财务总监', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'AA8B5E5E8BCB42988AE405F7E1ADEECF', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhousha', '周莎', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7B39F97DF2A54F1B94A494AA0FE4A39F', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'wafertangir', '唐岳震', '总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0982D1CD418345F28F091771518BC372', '唐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'lihao', '李昊', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8436932DBD7E4A488F4B4AA746A57DCB', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferfengqiao', '冯乔', '总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0629971BB901417C9D162F67774CCC9B', '冯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferzongdian', '宗滇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A684C04FE1874D5EA3DB3057E2F6BE5F', '宗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'zongdian', '宗滇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FBA34ECBC46D427AA080A0CE2606FDED', '宗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '柬埔寨代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun', '孙会兵', '总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'ED398E8436BB49D6B79C42B88E385E19', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度尼西亚代表处', NULL, NULL, NULL, NULL, 'waferzhangchenxiao', '张晨虓', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8B0FC905CBEE4B9390F1A819ED40268A', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度代表处', NULL, NULL, NULL, NULL, 'luxiuchen', '陆秀臣', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7FDA6EF558F245D6B7A5AE7D7A74B2D9', '陆', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'wafersunhedong', '孙和东', '副总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '88582B6838CD4D96B35C18FA4C6E0982', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'sunhedong', '孙和东', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FA483D22ABC0422EA86A6E05E55D4110', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '塔吉克斯坦代表处', NULL, NULL, NULL, NULL, 'waferchennan', '陈楠', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0A8367D3BF8C4E3884623BB71751F2C2', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '老挝代表处', NULL, NULL, NULL, NULL, 'zhanhongyuan', '湛洪元', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6C34709E87034C9F986ABCD02F69A3C5', '湛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '肯尼亚代表处', NULL, NULL, NULL, NULL, 'avicct-sutianshu', '苏天舒', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '750A871DC6A343A789343F7C3C69CF1B', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '赞比亚代表处', NULL, NULL, NULL, NULL, 'wafercuiji', '崔季', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D768387305994ADCBAFD6C354CF2B6A7', '崔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃塞俄比亚代表处', NULL, NULL, NULL, NULL, 'wuping', '吴平', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6D3386833B374C6783C06C5B05D44D39', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃及代表处', NULL, NULL, NULL, NULL, 'waferyangjinshan', '杨金山', '副总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6401EF9E28B646FD80B6AC13A719755E', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'lihuan', '李欢', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EA6CD9B71B4340B8A5B5BD8604B45E34', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'yangtianhao', '杨天昊', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3A9121A116524BC8933790B0615E92E0', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '乌干达代表处', NULL, NULL, NULL, NULL, 'waferdingsonghe', '丁松鹤', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F4B46EFAC155406496D7A28066E4E22F', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加纳代表处', NULL, NULL, NULL, NULL, 'waferyuhongpeng', '余鸿鹏', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '91AA3437490440569A6F869FBB142045', '余', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加蓬代表处', NULL, NULL, NULL, NULL, 'wafersunyang', '孙阳', '副总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7202F8DC0FCE47BBA9203EB6E1D096B6', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '刚果代表处', NULL, NULL, NULL, NULL, 'zhangxf', '张晓风', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FF1986A284904888B0CD6D1D84754444', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '科特迪瓦代表处', NULL, NULL, NULL, NULL, 'wafertangzj', '唐忠杰', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3F0DDAFC1ABF4C9DADA745623847832E', '唐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '津巴布韦代表处', NULL, NULL, NULL, NULL, 'wafermachengyuan', '马骋远', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B2C6E23E2CC343688E98B74E4D127FAF', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '莫桑比克代表处', NULL, NULL, NULL, NULL, 'wafertierigen', '铁日根', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4C6C5C418A844E559B36E4F24222BD5C', '铁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '喀麦隆代表处', NULL, NULL, NULL, NULL, 'jianghui002', '姜辉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A6609A7F4AF34AD18C90C485216DBD60', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '尼日利亚代表处', NULL, NULL, NULL, NULL, 'ganlijun', '甘黎军', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D0E29A169B694F2391A9C421F16DBD69', '甘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '安哥拉代表处', NULL, NULL, NULL, NULL, 'suiyongjie', '隋永杰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1EE951F384FA4F9D908FC483B2C8B2B7', '隋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge', '德国代表处', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '46F28801834040E0B1525EEEE0D32F3A', '德国代表处', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge-ltd', '德国公司', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D7561457E70C4E5DA65F8D5B3E5A1CD2', '德国公司', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.germany', '德国代表处', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9601C50D1C9B47D0AF48AF36DCFD88B7', '德', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'chenzhen', '陈震', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9EF9BDAFBBD14743B4EB5C3319530065', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'liqijiang', '李琦江', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1B67FABED4644254A374B7DABAD975D7', '李琦江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'sunjian', '孙健', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '530EACDEF81A4C8B896220EA4A5AC1F4', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferzhangyulong', '张玉龙', '财务代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '44B9A18417B54B0C9C3BF765F2ACFD39', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferliyudong', '李煜东', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '44E0D45B890A4A69B4396BADAEA580FE', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermikelou01', '娄玉成', '总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8665A6B966464E4DABAF66DE4DE5535D', '娄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'waferwangsh', '王双', '财务代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9DCD6FAEB0A74DACB3AA080005F2A4D3', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermenghaitao', '孟海涛', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B9616BA8797B422785FFE73DA2E65EBE', '孟', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国公司', NULL, NULL, NULL, NULL, 'wafermikelou011', '娄玉成', '总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F2D114FB9FE241BA81BD93EDDFB7DB3A', '娄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '德国代表处', NULL, NULL, NULL, NULL, 'wan', '万春雷', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DE9D538A185D47A78DD6101003A88744', '万', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '俄罗斯代表处', NULL, NULL, NULL, NULL, 'waferjp', '姜萍', '财务代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DF70E87F9DD240C789BCC1803CEE32CA', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '挪威代表处', NULL, NULL, NULL, NULL, 'huanglei', '黄磊', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B2FA054DEA1543DDBA3420478EC0C49A', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'zhangxuming', '张旭明', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D7E99A902F48418C888BEE6AC4B4A14F', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferfrankyang', '杨方', '副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E956FDD4F1C441E3AD222299A3F431F6', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'hanke001', '韩珂', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8C5B70ED027147178D6A8A08D8AD7919', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'emyang', '杨明', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '91ACFF4BD0194D399A8098A4F6CD4B51', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferliusujin', '刘苏晋', '财务代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '417464C83FD2455C9FB78403170FFA52', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哥斯达黎加代表处', NULL, NULL, NULL, NULL, 'waferlingxinwei', '凌欣伟', '公司代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '94EFE18B42364DBE95C4C9F1189D551A', '凌', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '古巴代表处', NULL, NULL, NULL, NULL, 'miaojingdan', '缪景丹', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '67FD6EF0287746239AA37071DF1DFF49', '缪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '巴西代表处', NULL, NULL, NULL, NULL, 'pengbo', '彭博', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '95F41E32F7B047F396C236C3294113D0', '彭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '澳大利亚代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun1', '孙会兵', '总代表', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '46B1354A0F474ED984133E34A99BE6E8', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'quning', '曲宁', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '5066A973375548E09C33101FB6C3DBC2', '曲', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'tanqi', '谭奇', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '1E9EBE1599BB46A19DC1BA51FCA75604', '谭奇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'wangying626', '王颖', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '29C5C81F5E304F4DB316DADB8DDA28E3', '王颖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'liujinghua', '刘菁华', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '4B8039CD08674E338CF2D225CA6D4FFC', '刘菁华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jin', '纪宁', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '7971218B543045B38774D0216D3B3565', '纪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'intl', '海外机构联络', '曲宁', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '01070A03291848BEB3F4E7440A18F4E0', '海外机构联络', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'qiaojuan', '乔娟', '副部长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'A26A343AD15E46F685E2D017E7500265', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'xiaofu', '付潇', '部长助理', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '3E01DE0E82544ECB986269F1645DC898', '付', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'wangxiuming', '王秀明', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'D981CB0C0E164B6C8FCA4095CB474C2A', '王秀明', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'maxiaoxu', '马晓旭', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '3E15702513D34AF29B04BFD2F79D68C9', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'yuweiye', '于伟业', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '26833F1C13674F0D97D56B00AA5D013C', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'guotianji', '郭天骥', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '844F829B35FC46CF8CBF028D7E843FDD', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'lengfengyang', '冷奉阳', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'F6866DD46D4645F1AE65BF5E428D2D1A', '冷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'czy', '陈兹勇', '部长一纪检组副组长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '259F9DF9C747452381BB7A42DF5EC9C5', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guowei', '郭薇', '专务兼副部长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '968B0A6AE7634795B6868D0DCBE964AE', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guxiaozhong', '顾筱中', '副部长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '95CDA989EB2C41A49336414D8B580406', '顾筱中', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangjunmin', '张军民', '部长助理', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'F766BAA2D1654953853E1108A9833029', '张军民', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'huangqian', '黄倩', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '9CC1AD03A3674A17ADE0B29932F4665F', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangp', '张鹏', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'EAC7F0F180F946538D4FECB3C507DF28', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangshuang', '张爽', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '6DD58E65ED994352B30588DD99347C80', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'jubao', '中航国际审计部举报邮箱', '张爽', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '91CF8573C28F4872835B9CCF89AD09EB', '举报邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'shenji', '审计专用', '张军民', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '90903B7205024620A718D86A5B5E600F', '审计专用', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'liuying001', '刘颖', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '8785215FA5804775BF5B62652FFF35EB', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'sxt', '史笑彤', '副部长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '6D40FE878A044ED2914FDBEB124CFF26', '史笑彤', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wudan', '吴丹', '部长助理', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'D777B63F2CFC4F74986829B478E02BC5', '吴丹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lipeng', '李鹏', '党委副书记纪委书记', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '35A25F1CF6574742B88E64FE8C9EB27D', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhangwen', '张文', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'CE7F9584308F4DA7AB22301513745F01', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lily723', '刘美希', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'A9281A72E1CF45258BABDAAF9332DAC0', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'xuli', '许莉', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '9ED21B5FFD9C48B3AC086CA7BBF034F2', '许莉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wwt', '魏文韬', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'B891728158C843E3A4BD25A6EF5983FD', '魏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'mingpian', '名片制作', '刘美希', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '280E1A79C47444D489D11783AC51C71A', '名片制作', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'qywhb', '企业文化部公用', '许莉', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '8BFEE0B792B04FBFA2C974B4C2271F6D', '企业文化部公用', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhgjyjx', '中航国际意见箱', '许莉', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '1FBA0D8AD6FF41A8A83F49C4EE37E21B', '中航国际', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'zoukangning', '邹康宁', '事业部总经理', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '84850D5B7E81415C941C5CA68167610A', '邹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'suzhenyu', '苏振宇', '事业部副总经理', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '1B4C9EFDD05A4185B2350DB053E4E5AA', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'hyw', '何跃武', '事业部总会计师', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'ADC65DFD429D4E0899C73FD15108A5A4', '何跃武', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部专务', NULL, NULL, NULL, NULL, 'yanna', '杨慧君', '专务', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, 'F9E976BC16A7402C88C633AD34942675', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'liuruiyan', '刘睿妍', '副部长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '9E1F655C58FC4F7FA10994E7B13A1BF9', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'linxiaojie', '林晓杰', '副部长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '8E041AA8F6C1484CBBEA894F72097602', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangbowen', '张博文', '副处长', '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '32C62957575C44229E4FAA6132AEC348', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'qiaofl', '乔芳林', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '41C992FB7D704FBBA160F6B5D4D67498', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'yon', '叶宁', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '992FFA0D2D8B4C5BBA80DFCB631A7E87', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'niuds', '牛德胜', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '8DFC6011FB984A329C1839273F544587', '牛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'jinbo', '金波', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '2929E3DE0952458CA5DB2EE65DD84DB6', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangyuan001', '张媛', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '5E17EECBCA7848BDBA999174CFBF5D25', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'ytt', '岳婷婷', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '89B6C5EF393B4573BC6703636AE6B16C', '岳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'songchen', '宋晨', NULL, '13829A0BD3994A69BC167BE8145A5444', NULL, 1, '714EF9E1827442AEA10E9EA6398B50DA', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '董事会', NULL, NULL, NULL, NULL, NULL, 'jyan', '焦燕', '董事会秘书总法律顾问', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2FDE0271D46647E79670FB169ACBBFED', '焦燕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liuhd', '刘洪德', '董事长分党组书记', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '886B0745FA6E40D58093710228B51649', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'suirong', '隋榕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E5AEB7968DB9436B88BFF73AF3292ECD', '隋榕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'laiwx', '赖伟宣', '总经理分党组副书记', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '89D03AEAC8374067BA73E2EBCFD3D81E', '赖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'chengbz', '程保忠', '分党组副书记', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '24D10B053AD74BF9865592A34482B6A0', '程', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liujun', '刘军', '分党组成员副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F7C62AB736B446B4A48D5CAF424653C3', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'diaoweicheng', '刁伟程', '分党组成员副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8398B2DBEB424B84B8814FD1CB2E7B55', '刁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'hanxy', '韩晓阳', '分党组成员纪检组组长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2894C0DC8EAB4145B5F000A4A7CFB97D', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'liqifeng', '李其峰', '分党组成员副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '29BF859C8A694CCDB5DEBC3C97EDD3C8', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '中航国际领导', NULL, NULL, NULL, NULL, NULL, 'fufangxing', '傅方兴', '分党组成员总会计师', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0B0D632415614D87B878FFC99FCD7649', '傅方兴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhui', '张辉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F9C36711627544C9A31E5FCBFCF9406B', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'wentao', '文涛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D8297886790D47C8B6264C960D5FBE8D', '文涛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'huangg', '黄光', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F1B17FCDF2B247D8B937F3788258DE48', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'yangyouqing', '杨有青', '高级专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E44D4C354BC743728F646ECAB6F96C68', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '公司高级专务', NULL, NULL, NULL, NULL, NULL, 'zhangguangjian', '张光剑', '高级专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '02DD36F9D5FA46B9BED6C697729B74F1', '张光剑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'xiaoyi', '肖益', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '199EC2F21C2C4DD9B26311371DB3FDCA', '肖益', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'chenhongguang', '陈红光', '离退办主任', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9F459B8BE1444B17AB413220F4715651', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'czg', '陈志刚', '安全生产总监兼副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '162E0E36808F4439A6525F97946BFA63', '陈志刚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liu_jie', '柳杰', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '15072B32EA3E4B339108566C6031B394', '柳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangkewei', '张可为', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B65FAC45F8914AB6AD7AD1ACD3DC5ACA', '张可为', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'zhangxudong', '张旭东', '业委会办公室主任', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2F1F7D38857C4769A36EC86D04446991', '张旭东', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lisiqi', '李思齐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '78F728DBA80346599CBDF0A789EC6264', '李思齐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'panwm', '潘为民', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4749AB3ADAF24AECB183026223EE5D9D', '潘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'linjinghui', '林敬惠', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9B7D61CDE401486FADCCDB6F94E1E4F4', '林敬惠', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'yangqing', '杨青', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2DFCCC18C8CD40C9A2AEACE56663C516', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'shenfeng', '沈枫', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '43CBDDAD7B264A2F85103B9EE32ABC51', '沈枫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lpr', '凌佩冉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '19C45DC5A58F444C8231DE7532AF27D8', '凌佩冉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wulw', '吴力伟', '车队队长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '37159CF3953040829AD7E09F44EE72B6', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wangqian', '汪黔', '司机', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '16DB7F321F5448F29AB3E7F0CFE14045', '汪黔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liushujiang', '刘淑江', '司机', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2B088C8077C245938C1E23C0444BCE61', '刘淑江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'qilianghai001', '戚良海', '司机', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '115655F21CDA4EF08470CBD69D399060', '戚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guanxu', '关旭', '司机', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '255FE61C71FA4062BDA3A0CD325C103A', '关旭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'luchunlin', '卢春林', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '762550E186A3496C89483F8908633A8B', '卢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'meetingbj', '北京会议室', '林敬惠', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B1D64DDA1EC74494AE3D4502F003D431', '北京会议室', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guoyuxi', '郭宇溪', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5E7CB09BE5754CAB846D51F84250D9C9', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '飞行培训处', NULL, NULL, NULL, 'wangshuo', '王硕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F5C6BBE895924B1DA2D730A65366F2E3', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'jiangh', '姜辉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B9E00FDFAB044468A8B68415E6F02B18', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'yangth', '杨天昊', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9D1007FE53C3469F90A9E4B5815E2C2A', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中航国际代表', NULL, NULL, NULL, 'zhangxiaof', '张晓风', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BD74F7CCB6614CCF9EF41422E1CB91BB', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'anqi', '安琦', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F3D89AE5835C4A2FBA2F2C1814814BC7', '安', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'liuyang', '刘洋', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DB42950111CB44FC9C675A180364408E', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持民机部', '中西非区域中心', NULL, NULL, NULL, 'qiaosen', '乔森', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EBDE8594BF1846A4921724D806C17336', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'zhouyong', '周泳', '部门总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F4455DD679C64F5496ED43E1CD6C7489', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', NULL, NULL, NULL, NULL, 'sxg', '史新刚', '部门副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E590100956654C18A1604C15C6F7CE47', '史', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'beil', '林蓓蓓', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '073C04EB6D1A4F79BB0E036A98CCFC15', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'yimin', '伊敏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B2F39DC5D395412CAB9F8923BD4600A2', '伊敏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'zhaohao', '赵豪', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '72CD6C7B85964BC59D2F1099FA66B1BB', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'wuzhaohan', '吴昭含', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '26194ED1EFD841FCB10CDC6E1C5DDD7F', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'jinyiran', '靳怡然', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '27757DC57980496F955AED5ED367421C', '靳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'xuchumeng', '徐楚朦', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C4468E5BCF504B6C87D0AA5C4342C9DA', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'fjj', '傅金鉴', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C4DE3600E47546E2B2674E0F5A8B653D', '傅', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'gaohai', '高海峰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1C367BD9CA1041578B8B73E981A38F2C', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'slj', '苏立军', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '207AB62901934F1CA6BF0AAA5C759851', '苏立军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'majinghuan', '马靖寰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '74382F50B9054660A23A8729C5F3143F', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'huanglingrui', '黄泠瑞', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'ABD020D093D34CD582D50C9FE2A75E25', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'getong', '葛桐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0CC19A257B174017B08C707CE9AF2A55', '葛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'liangpengfei', '梁鹏飞', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0442DB20D9EE4DE58D515785397AD8C0', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'wenyanping', '温燕苹', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8B1620BEE558471BA8D5B82B39E8552D', '温', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'shibiao', '石飚', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '41745BCA5434466DA6DEDD04497CC4C4', '石', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'chenyan', '陈燕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '482A08443E694DBFA4A509BAF6730113', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'yangyuewei', '杨月炜', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '17547A9EBB7444A283E1FA75A802582A', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'lzt', '李振堂', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1B45A88CE5F8408A8E7DAF6CA6FA9944', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'niyang', '倪杨', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '27C98B57E5BA4C47B73F8961EB0454E8', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'jishenxin', '吉申莘', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C43578235C1A4E44A4F2F1C5EA569CFB', '吉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangruoyu', '王若愚', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '401C3966678F4C7F9EA74B494E1936F9', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liuxianghui', '刘湘徽', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C5184897AA3A4F72BD099478DA5693C9', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangnan', '王楠', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '66E72C7A09D8441BB917D713C36B3CA8', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'zhangkl', '张凯亮', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '58ADC5EA4E6B47CCADFBCFBD545C2A18', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'panyu', '潘钰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6064F3BC2872467C9ADFB2CDE522C603', '潘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'shenyunzhu', '沈云竹', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '383FFCFA32274D61BD38BB402BCA9994', '沈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liqimin', '李齐敏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B6E6F68F50D741019A394CD09A416219', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'linsong', '林松', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '82D1A776E906450EA10541E779E420B5', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'zhangyan01', '张燕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '89EC06DA3F214E8E8DD48FEC5FDFDCB1', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'lijing826', '李晶', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '26E73E65482F436AACAD3D788372F434', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'mxj', '马晓珺', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '57C8967AEFE7420A81A137183DB5B1F5', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lcgem', '李晨光', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FCF89E5712C8471A813E1F1483AE3D5A', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'hwh', '侯卫红', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7D8A92410498436C8E32D26D22BF0389', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'nijiaxu', '倪嘉序', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D481D309579E42E287B191803898A88C', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicszg', '中航国际宋治纲', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DFEE6B49874D42679D64CDA98200EDBD', '中航国际宋治纲', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'mzhy', '毛周勇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E5433988A644467BBCE2CFC333AFA269', '毛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhaochunwei', '赵春伟', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D664D6AED9F147BD940B5BA6D7DED379', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhaoyc', '赵玉成', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E2ED982B374E453E888C24F154736026', '赵玉成', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhangmy', '张明月', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F6647697F2014722ADE654B933B23D45', '张明月', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lili', '李丽', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'F3B6484092094004BE05B0FFF665D178', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'tangq', '唐群', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0949A0564E9641A4885EF195AD8854A5', '唐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lisha', '李莎', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7D3B045D425C440E9806852CE7D83291', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'xqzyy', '薛智勇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AA2A18C19F164B2AA7E02619F8F57D71', '薛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'wmg', '王明贵', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '25CB771A633C401BAB7B8FE0199A760A', '王明贵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'guojing', '郭晶', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '40E2AA8EC7774E04844356373D953192', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'fudebin', '付德斌', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6CB9764AC44C4B55BA49BFC330661235', '付', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhanglw', '张立伟', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C308CB9A58BB40F48F215799C393BCD1', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhaochen', '赵晨', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '116D200CBFC54155A09E2B446DCDE00B', '赵晨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'wangguoping', '王国平', '领导干部管理办主任', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '943374FDE92C4ADD8D6B6D0433FBE023', '王国平', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangxu', '杨旭', '杨乐', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '13E06EAD476546E58C90155C8321B848', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'huangjing', '黄静', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2CCC832195364A379E02424B4CCBA469', '黄静', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hechuan', '何川', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C2C3FC2EABCC438A990D28876C09CE7D', '何', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhimin', '智敏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E8541B99F04D42EAB92CA62B864CBFFB', '智', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'houfanglong', '侯方龙', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8E034496441B4917A9ADA756D948A7D7', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'xupei', '徐佩', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B4201553FA3A4677B3D51B5B89CB81F3', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yuett', '岳婷婷', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E4629C0943784A66990E558D3E9A14B9', '岳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'liaohaitao', '廖海涛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '106CEBE2E04D4F73968832BC56BD27E5', '廖海涛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'ehr', '人力资源系统专用邮箱', '彭潇', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A4A2292B119C4D5692CB53D6CA8E4881', '人力资源系统专用邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'rlzyb', '人力资源部公共邮箱', '杨旭', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '216BA4DD23D748CF8240EF8A9EC43485', '人力资源部公共邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hrtest', '人才测评系统', '王国平', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '404AFD128375439AA34EC2893F3378D0', '人才测评系统', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangle', '杨乐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '792600A018204DB5A896544096C98975', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'pengxiao', '彭潇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9BE325C5E1404DA09B94B6907E7C9DAD', '彭潇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'zhaopin', '人力资源招聘', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5876D9000B95403CA83CEE1617DC0DC9', '人力资源', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'libin', '李斌', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '20664F9C7A614C00B86E13FC64DEE18A', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lipeiyin', '李培寅', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3203B2BD070043989A477B6629E81A54', '李培寅', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyuan', '章苑', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E6C1BA3B41694B9BA7D203567CB99DB8', '章', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'muyan', '穆焱', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C6F1028A207D44DE87B38C64A9B884E3', '穆焱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liangmaolei', '梁茂蕾', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '77770007106F4A4A9D53398E1D5C60F3', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wanlina', '万莉娜', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '46657AB6A0BF49E1B9E9528D0EC8B95A', '万莉娜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangying', '王莹', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0D442D7BC33E4491ACE1DBA8D88496D4', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lynan', '林彦男', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'DACBD6FD13AA49E1855E3EB2FBD702BA', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'xuxingxing', '徐幸幸', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8B9D4ED58C3F44DC9E16CBA7C87F16E8', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhaocx', '赵晨雪', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '559E62A012344FE391E3B0BB2ABB5173', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'luobaiwen', '罗白雯', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '802EB5BED00A455EAFCF39C028B11428', '罗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'sunyitong', '孙一桐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FA9574B662E84358A4EB39F626E01E4F', '孙一桐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangt', '汪涛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '24BA6A2CE5BC4240957E53444AB89D14', '汪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'huangzy', '黄卓妍', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6EEA703345FF4CDBA11EE21A17262AD2', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangjintao', '王金涛', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A40D346D1ED54497820F6C12531285FF', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yanailing', '严蔼玲', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D7CF0CE7A2BB4DA5A0523D1822DA794D', '严', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangf', '王丰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'EB382B83582B4636ACC9A40FDE47A331', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liuyx', '刘彦希', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '77A56ED073B44282814EBF117EA74158', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'fanxiaowei', '范笑薇', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '055B6B65039C4D0C89D5CD6E61C4B72E', '范', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'maoli', '毛立', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AB8D0CB5151146E99A388CCCB1753918', '毛立', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyundi', '张云迪', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '70322331482D4424B9D560915171A153', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'chenzheng001', '陈政', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3612DE5946A44B19ADF6ED73274FF62F', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lvkaifeng', '吕凯风', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AA9FABC420E64D2CB7EB3135D94A2A85', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yangpishi', '杨皮石', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6FDFA886AD1A4C9783587F74440F535E', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'ljing', '刘晶', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '040D64999801477B8CD84201AD4FD317', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'mochendong', '莫晨东', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7CED7ADC97D9451789FBAF1DDEC630D9', '莫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yinguangquan', '殷广泉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '38880D33D23F450BBA363E7A9BC37B51', '殷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'xuyachao', '徐亚超', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '282F379A42A1496B8DC135AA491B522E', '徐亚超', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jiangq', '江强', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '41A1B31F24BC41BF8EE878843E71E4B5', '江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'lichuangrong', '李创荣', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '36A8988B2B2C4263968E6EA88DDE1E60', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'cw-yxzp', '财务永续中票', '刘苏晋', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1969B74B07534F8BACDBAC38CD1F0E48', 'cw', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jenniferwb', '王彬', '李培寅代管', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3DE7E39087024714A22ED8DCC357F0CF', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'zhangyulong', '张玉龙', '常驻法国', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C5FDB9E255974D82ADE3DC7B38DEDD9C', '张玉龙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'liusujin', '刘苏晋', '常驻美国', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '14562F04B261456EB8052103D32E7F3E', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'wangsh', '王双', '常驻英国', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9306F2A1BB4A487CAB9185842B292EB8', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'yaoyuanjm', '姚远', '范帅帅代管', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1D05EC90BE8F44D18E8E81E510D9ACE9', '姚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'qiqing', '齐晴', '马亮代管', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C314B1094A9243D7A9D1B94DA8FC5335', '齐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'fanshuaishuai', '范帅帅', '陈政代管', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '6677496A8A9A47B48C79C4F15DC7CBDE', '范', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'linjining', '林纪宁', '副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '02A32D6622FA43E7A5E3CAAC3FFBEB78', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jinrx', '金如心', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '259CC2E6C019443E9B653FC1B0270F3D', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'chenshiya', '陈诗亚', '张云迪代管', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FC65F0AD2852415CA6853361496A9BB3', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'maliang', '马亮', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '96278D4D1C8A4661AC9CB8E00B1D8BE5', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'youyanchun', '由艳春', '处长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '4DD6393B79F245A18A081BC85026998B', '由艳春', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'zhanghui', '张辉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C9855B8FDF944048BB4D0F9270F1223A', '张辉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'xuxg', '徐新纲', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D7129F03139A4CFE982AE6EB841CB6F6', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'jp', '姜萍', '常驻', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E18944C2531F40178C8A79209271AB6D', '姜萍', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhangzhibiao', '张志标', '部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D7D611BF42CF4249962FAF8DF2C41D33', '张志标', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'guojian', '郭剑', '专务兼副部长', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'BA3A03B2535844E6A07F1B216B4925EC', '郭剑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'chenxh', '陈晓红', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'D36982F5982147B9850DDDC00864F1BD', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'hpl', '韩沛霖', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A6B80B6F9D9A4863B435A2BE6CF5919E', '韩沛霖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'ltj', '刘铁军', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B17A9641FB6A4C4C85A4D30CC467485E', '刘铁军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'yanglei', '杨蕾', '部长助理', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3F49A63B5A3940B8956B1BDAF2AA11CE', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'lfchuan', '李方川', '国际航空板块业务办公室主任', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E348C2BE48B14073A2A706EE19512FBF', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'fqy', '傅麒玉', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '71AFD5DAA2EC44EC91D6642C0967FD25', '傅麒玉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liubinliao001', '刘濒辽', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'ABED301CCBB64FE18C712718CC108C74', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'shenghua', '盛华', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2D15831B495F47668D9CEA57E3610F14', '盛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liuhuayi', '刘华奕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FF2F20325D5C45769EE42267534EEC5A', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangle', '杨乐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EFCBA7FDD8CE41BAB35BE1D4C9EB1C01', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'lixiaomeng', '李晓曚', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '85515114CF6E42319EF1628901CDFC9E', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhanglinyi', '张临意', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B910D4056A72474886750B088B9D74F2', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangsai', '张赛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4FDCCF3A4B0E4283A3E438191985112F', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'chenn', '陈楠', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2756E49C2E114521B626FB27973F849B', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'qiwenjuan', '祁文娟', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1197E3287F2D4B658FB316CCE2320A9A', '祁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangzhen', '张振', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9CAD7B0ACAC34B94B73075A655FBC79D', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhuwenting', '祝文婷', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B7DADEA5F22F41D0A25D44B9FA6DC979', '祝', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'songling', '宋凌', '事业部总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '996F37FC6E104686B960E9F2847092D6', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'elu', '吕中华', '总会计师', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '30E04116F34143BCADA1CAD20FF231EA', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'xubomj', '徐波', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5751F5E2A55A41CCB69B95CB860BEABA', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'liuruiyan', '刘睿妍', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D833FF1AB8CB46498AD5297E51514303', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', NULL, NULL, NULL, NULL, 'linxiaojie', '林晓杰', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2BFEC5829130470BA30618CF8BAA019F', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangbowen', '张博文', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5EB8B0CF66C3415DAD7293226BFA27A0', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'qiaofl', '乔芳林', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E9036111BA7545CBB0B5E9E6324C516D', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'yon', '叶宁', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '383725A158954C41A45C2B0EAC17A6BB', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'niuds', '牛德胜', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '11612D1B98834F85B9221A832C2636AA', '牛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'jinbo', '金波', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '985805C814F64875A42ABE3CE628CA03', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'zhangyuan001', '张媛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B70D5C6E88EC4314A4A5E401CE8C1AE0', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'ytt', '岳婷婷', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F51ED1B2483E45D8A2A122B3A2F3016B', '岳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'songchen', '宋晨', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6343EE7DAE184A3EB4D0FC76FD205624', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'hezuozp', '合作发展事业部招聘', '岳婷婷', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B57F7608F80E47EC87D575B94022CAF4', '合作发展事业部', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '综合处', NULL, NULL, NULL, 'lishengnan', '李圣男', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '418B947397524FD2818C9E6E988A6D57', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'liuhui', '刘辉', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '07616FFFD2B941AE9A366D95E3F9E12E', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'xuyi', '徐奕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '92DD1B83501E4325965EBE26536CE6E0', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhenghui', '郑辉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '18410F7542474DC0BD656F147A90065B', '郑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作综管部', '海关免税处', NULL, NULL, NULL, 'zhanggang', '张刚', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F5113B4BDA144E3294DAB77A35A870BC', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', NULL, NULL, NULL, NULL, 'luchangchun', '卢长春', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '11B5D489947B4634A43728BD98D88FB4', '卢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyp', '张艳萍', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3AE9EF7296F046A2B269E43F6355C380', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'lihuayun', '李华云', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9A6D1154437F4F2584F4566A6824D046', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'yut', '喻彤', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '406BA7323750473B9FDEFA219EAC67E5', '喻', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhangyi', '张怡', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '726C8FD5B2B34147BF6E0AFB0CE4F56C', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'yimin', '伊敏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'C323894837584B65B9D8E0D1E20DB54E', '伊敏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'zhaohao', '赵豪', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '0E3E218BA16B400AA3530F3E19C73E01', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'wuzhaohan', '吴昭含', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '3155F4D35F004372A7DF75FF1D1C8DEE', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'jinyiran', '靳怡然', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'AF1BF5164C134C85B18F91B1957FFEE6', '靳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'xuchumeng', '徐楚朦', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '93F9DFF0ABDB43CE852F823C17535D8B', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'fjj', '傅金鉴', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '81C3992144FD4D44B0D127720520B8D0', '傅', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'gaohai', '高海峰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1AAADF3D09E3470EB87DB7F10F363FEE', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'slj', '苏立军', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '77726F39CC2644169E38F2C01DA91EBC', '苏立军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'majinghuan', '马靖寰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '94261E97A7BC49F98236C26CC55D8420', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'huanglingrui', '黄泠瑞', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '210774F6C32A495380FD1A759807F89B', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'getong', '葛桐', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'B6333B55B796429E91F2EAD279259A3F', '葛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'liangpengfei', '梁鹏飞', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '7DF7540163284E5293619A810A179767', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'wenyanping', '温燕苹', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '2B4BFFA0A70F4D2C9D5EDCD45B19B260', '温', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'shibiao', '石飚', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'A8A1D9DE154F4237BDB752807485988E', '石', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'chenyan', '陈燕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1E887CAF9B8F4A1D9B9F62CF7BE155B2', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'yangyuewei', '杨月炜', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '73FB5E980E5A4D5598E7FC500AAA771A', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'lzt', '李振堂', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '1EA5513D97E3465EAA69F9FDA7309637', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'niyang', '倪杨', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E19CC684BDD049AB8600451E3A72D46C', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'jishenxin', '吉申莘', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'FC581C842ACB47FE8E207D7C74A6ED51', '吉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangruoyu', '王若愚', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '60C64068FB8741CABE4DDB0917C6032A', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liuxianghui', '刘湘徽', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5321E7B05BA448A884DE7329E559BC3B', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangnan', '王楠', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '976744F99CCA44F2A7840F11EA70D436', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'zhangkl', '张凯亮', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '8A7F7249680943F28D8EC2E293FE51D4', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'panyu', '潘钰', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'ADC28C2C20B944C4AF7D03DAB0E8AB8A', '潘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'shenyunzhu', '沈云竹', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, 'E9F4DF14512C4D0BA75835EE28B3D951', '沈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liqimin', '李齐敏', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '5779C30728844F1296518B96A18C9FDB', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'linsong', '林松', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '60BC808CC4184EF48DC0589870A2691E', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'zhangyan01', '张燕', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '97944FBCDBD54A67A1645B1845129B73', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'lijing826', '李晶', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '04F3FF95C9164EA2BD321728FE7E9339', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'mxj', '马晓珺', NULL, 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '772CCB5D526945A0B19CE40D877E3DA6', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhqy', '郑启源', '公司专务', 'ABDF5332EC78419E94FFB5F86210E4D8', NULL, 1, '9D5679171D764B09AB36C1CAC57FBE68', '郑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'shihuanan', '史华楠', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F19BFDC07D8841E19B346BC9657ABE9B', '史', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '国际合作财务部', '财务处', NULL, NULL, NULL, 'zhoushujuan', '周淑娟', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1BB53F7E94EE42E69D4632E7E8276B93', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', NULL, NULL, NULL, NULL, 'hanke', '韩可', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '59FBD0EE86344866A83EC3738C786FCC', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'shihong', '石红', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9C3A2A6655FC41A38CCECF2578336A92', '石', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'zhangmeng', '张萌', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BA28481FE73048F18EB1AC8FBAABF23B', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'gaochuan', '高川', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A3468874CCDB43ED9223DB207F0EDBE5', '高川', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'jxy', '景小燕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '92E7BE471D0F4FC892C65EE7BBE8F774', '景', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '重大项目处', NULL, NULL, NULL, 'chenzhigong', '陈志功', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BEB12D367F764B3A932159195C3B8F07', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'daiwen', '戴闻', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A72209D54A6A46A69A19992D17125235', '戴闻', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'liguangnian', '李广年', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9C5568892E154DEBA03E7BCF6BC834D0', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'geyihong', '葛译鸿', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B2E5B6EB76CD45CEA149A5FED12B5E45', '葛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '重大项目部', '合作处', NULL, NULL, NULL, 'zhaoyuxiao', '赵宇骁', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '020169B1A3F94D53990E0AB37FA0A7FD', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', NULL, NULL, NULL, NULL, 'xuyonggang', '徐永刚', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9C8AEC8D639440DEAC990CC047531744', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'wangxuefei', '王雪飞', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '887E79DFFDED4EC3A2B7988DEF0BF15F', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'zhaowenzheng', '赵温政', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7C43B57C69A34DAE8A81905D2387022E', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'mhf', '苗鸿飞', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2F143B9897B545858386FC03BC26B357', '苗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'jianghui', '姜晖', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A879CB44D99B4C6B841775BB93CA9CF9', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '商法部', '引进处', NULL, NULL, NULL, 'huangxin001', '黄欣', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '460EBC1B39A8414181ABA487741BCA15', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', NULL, NULL, NULL, NULL, 'zhhui', '张辉', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9685C5CE29154674B913DA66D7D4315C', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'miao_sue', '缪苏', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D48A4EB6C8224E51A7788AE320179AC8', '缪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'yesheng', '叶盛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E2F4FA73026443109975A8F7F02728CA', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'liuxian', '刘先', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '59A1ADB2059D4D61ACEF4189412B1B40', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'milong', '米龙', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FBFE4BA1AC2C412F8064BB1E2E197B38', '米', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'wangyq', '王雅琦', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4C2156B84CD64886BC6E4EDE0B70DF7D', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '动力处', NULL, NULL, NULL, 'avicct-tianyuan', '田园', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '310FFFF3B8204024965DF42EFB430617', '田', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'yaolai', '姚来', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3B320F6A472F45C28C29D79103C0B240', '姚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'marongze', '马榕泽', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0D5C695B0FFB430898FB8198CE7ED869', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'liwanyu', '李琬玉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0D764257A2454C219866EE817035DCC3', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'ningjing', '宁婧', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '07E623CB1A2443B198BA90C1B2596646', '宁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangfeng', '王丰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '13B41E6820F74C5EB52892DF4A6978A5', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '飞机处', NULL, NULL, NULL, 'wangyan001', '王燕', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5B18A7F41BBC4111BC5A9CDBA198ACFE', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'xingguanghui', '邢光辉', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CF7B4C0F3ADC400498B3A49BFA368F4C', '邢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liduanchang', '李端昌', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E9BB2165655441E4A843CA6C748C574D', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'linjianxin', '林建新', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5446F141362F40CFB5381D5B65AE3A85', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '业务发展部', '开发处', NULL, NULL, NULL, 'liuanghui', '刘昂徽', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C57CB754DE7A4895883AC13C2C642F8B', '刘昂徽', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', NULL, NULL, NULL, NULL, 'jinxi', '金曦', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E078C1AF6CE941AC964420644037E513', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangzhenxing', '张振兴', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E652078B7DE448FA9FBA0CA7CA25B4B4', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'zhangxiaofeng', '张晓峰', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5B8056B39E3449C398359733EAFA1654', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'guojiesi', '郭洁斯', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9544FA5150A240909649C84833C2B6CA', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'liangxiao', '梁霄', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '450406F999F548838DB0E7F30D9251AF', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'yuxi', '于曦', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1FA1F4B3C0054D86B6169AE5AEE125E6', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'fangzhou', '方舟', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '62E2AB6E4A2E48EEB516829C3CCAD105', '方舟', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'wangda', '王达', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BC64E64ABC2C4081BA3CCD6242D2E11C', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购一处', NULL, NULL, NULL, 'chenshuai', '陈帅', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F4DCF078D3EB45C79FB163B7D22A92C5', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'chenfei', '陈飞', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C1E84E342C2E44859EF5E4CDF2922CC3', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'jiangshan001', '江山', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0D26D4BE02D04DF08DF8504376D98F64', '江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangxiaoke', '张筱珂', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9ED059F3AF864553B803D9528A9CAB9C', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhangyi002', '张祎', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EEC4FBE31CD2499E91572711DDE33F44', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购三处', NULL, NULL, NULL, 'zhayong', '查勇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '81A7C432CEDE49889B2EC884DC66255B', '查', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'zhaoleiyu', '赵雷宇', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6E1080DD3B2A46F7B7187218570DA7EF', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'liuyu', '刘宇', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5E57CAF817894C46B0B215EF3227F565', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'lilei001', '李蕾', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4DC930F38375432AACC11617758B109B', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'tianchunyang', '田春阳', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '345D4F734A324C90A833049456A2F36B', '田', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'houjiafeng', '侯嘉峯', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'EC785781EA6C4FA39C220C11D406344C', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'wusimeng', '吴思萌', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2BF4042B19434B51ADBC7715D8EA5C32', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'jiangping', '蒋平', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7BCCCC6CC43247B1BA9CE90F9E858894', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'lht', '林海涛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '771BB4C275A24F89BABCE2ACF16C95FB', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'guojiexiang', '郭杰翔', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9BD7A8A4E6BD4063B86DAA5F3B35025E', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'hubing', '胡冰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '139EA2B4AACA4C4E901B512F7A21452C', '胡', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'wangxiaochen', '王晓晨', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '099B23CBC9EB4AE8BD77F53120001ABB', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhanglu', '张璐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BA0C6F3D58EB4A77BC45ECD86F486ECF', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'fjcwurui', '武锐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '22DED1F336BB4EECA0C24DE523328D72', '武', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'huangbowen', '黄博文', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B21135C9AD024F67939B00AA53A2D594', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhumingshuo', '朱明烁', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '47AE4C58406B49BAABD43BB71154CB02', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', NULL, NULL, NULL, NULL, 'guolichuan', '郭利川', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '242F0F59788D44658C604B4C41CBFC9D', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaoyajiao', '赵亚姣', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2985644C617E4634B7D016EE946F6E6D', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yinjie', '殷杰', '副处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '895C30CA9A03404D857266A2DC6F6348', '殷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'jiangyuting', '姜玉婷', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '69570FC94C0C451480F930419405644B', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'lishuai', '李帅', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0376ECBF204F47169A1465206C6E6608', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'sunyan', '孙妍', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F72E213B4B974F2F842F2C3196F95C65', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'wangyang001', '王洋', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4AAF3B9AF47B41E98B534682C1171FE8', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yanjunxi', '闫俊羲', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A8C021C43EBB44CD85ABD8245B5D526F', '闫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaokeqing', '赵可卿', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CB3F1E43A05643D090EC0076A76F9464', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zuoxinyang', '左心扬', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '946947A25548404C91E8B8C017A10379', '左', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'tianchunyang', '田春阳', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '1B51A3AE404F4C9390EF3D144F3AC99C', '田', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'houjiafeng', '侯嘉峯', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '9A305C3B5689419B9BB1A8FC0A9ABC87', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '装备部', '采购二处', NULL, NULL, NULL, 'wusimeng', '吴思萌', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '4D46A8D45BE74785AAE29A81735D07AB', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'jiangping', '蒋平', '副处长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E81BF06D031846F0B7EF15946BE3CE90', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'lht', '林海涛', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '67D44E4741BA457784BBFAEACDB36BE5', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'guojiexiang', '郭杰翔', '副处长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'B913439238B84631BC28FFAD64BD58A1', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'hubing', '胡冰', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'DEC3BB9D61604D22BAEA629B7F32A478', '胡', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '航空技术处', NULL, NULL, NULL, 'wangxiaochen', '王晓晨', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'B2117AC4ECAA4464885585D9A3EF2D8A', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhanglu', '张璐', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '46071AD1195A460B83CB8BA7ACAAA11D', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'fjcwurui', '武锐', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'B844C55250974E5590B2092C02FD5CBF', '武', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'huangbowen', '黄博文', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '0E2D63BAC48F4BE9A917A59A4E840C18', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '技术合作部', '配套处', NULL, NULL, NULL, 'zhumingshuo', '朱明烁', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '65AAA155A2884854B51F7BC7FC1A69C9', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', NULL, NULL, NULL, NULL, 'guolichuan', '郭利川', '副部长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A20004BB0C1F4ACB9D6600FAE42314CA', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaoyajiao', '赵亚姣', '处长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'CEABF7EFE906490FAECCBF4C500A9D28', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yinjie', '殷杰', '副处长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '167A65092AA143B68C88B722CF436A28', '殷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'jiangyuting', '姜玉婷', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '358658FE671E4349B960C0FF251F1510', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'lishuai', '李帅', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '69B9E8175AD843B489A1876C6407715C', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'sunyan', '孙妍', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'AA32370185994CCB9CF0056943BCC012', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'wangyang001', '王洋', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '203807B375FB4BFE99227DFD7CF91225', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'yanjunxi', '闫俊羲', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '49A1F14650BF43E48F1815BE87A54901', '闫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zhaokeqing', '赵可卿', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '76AA874B4CA34FFCA211CCBAE5DBF931', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '资源处', NULL, NULL, NULL, 'zuoxinyang', '左心扬', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E8C312923EC1482E99C4442C51B4E26D', '左', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liubinliao001', '刘濒辽', '处长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '0A9E5B5775FC4B01AB8A5388B5E877D9', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'shenghua', '盛华', '副处长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '2907F93DB3994F1382308EA8B88FAB9A', '盛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'liuhuayi', '刘华奕', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '1D2E3A75E72C479BAC8E0FA9E873C740', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'lixiaomeng', '李晓曚', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A968AC9615E044AF91011E901630DC0E', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhanglinyi', '张临意', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '17D62D2DFE594418A00EECA2CBBEEBAD', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangsai', '张赛', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F40FE81452574438940B31A1D22641D0', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'chenn', '陈楠', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '8195E90FCF23405F9C6E3C2029C0A6D3', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'qiwenjuan', '祁文娟', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '608195C756434892B220E1B506C8AF4F', '祁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhangzhen', '张振', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '70D494B54A91463597A3FA4CEB64E4A3', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '材料部', '材料采购处', NULL, NULL, NULL, 'zhuwenting', '祝文婷', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'BD3BFB693D44495BB13C6D6F1B239AB5', '祝', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'songling', '宋凌', '事业部总经理', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C54A4F9FCFB94383A4FE751B00748BFC', '宋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部领导', NULL, NULL, NULL, NULL, 'elu', '吕中华', '总会计师', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '35F2CEF74EA64A629D1FFC6B80FCD3DC', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'xubomj', '徐波', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'AD697B62FEFE4B5DBFF8D04B26078432', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'heran', '张赫然', '专务', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '3B9D1E5721A44432AF9BB3DB86B2919E', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jinxing', '金星', '专务', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '93CCB4A19B7F408092DEFAD593C3AA7B', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'wangxiaobo', '王晓波', '专务', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '775A60EA20CA445AAF2B62C295709CFB', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持事业部专务', NULL, NULL, NULL, NULL, 'jiangjin', '蒋金', '专务', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '4C2E5B230EF04A549402083A242C82DF', '蒋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'lilaclinda', '林征', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A33121757C234D29A5EF04DFFD3F2784', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'suqian', '苏倩', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '7C710F757CA44A0EA4491A5260621F5D', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'xujing666', '徐晶', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'BCDC604A40DF473CB7C538CDB9D34A15', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'jiaomeng', '焦萌', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'B6039D65903F4879B180A38809189E71', '焦', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'fengbinyun', '冯彬芸', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C9B243D1030840C79EE1A9B50518EA14', '冯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'guxuan', '谷轩', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'BD017D7BB8774E51A1B2203930F41715', '谷轩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'wanghao', '王昊', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '982DA3C9A7A14FDBB6653D49C5FDECC8', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'zhangwenfei', '张文飞', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '8B0F028AEF574520BC1DC384848F396E', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持综合管理部', NULL, NULL, NULL, NULL, 'yyzc', '航空运营支持事业部', '王昊', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'CF9480378A2E42FAB4B020701AC3A8B1', '航空', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持党建人力部', NULL, NULL, NULL, NULL, 'dingli', '丁黎', '党建人力部长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '4F478F9600124DC89C0A4AE3B086164B', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'sf', '沈枫', '公文', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F34DD22E920547288EF1E224CB09174A', '沈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'avicbsinfo', '工商信息', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BBB4CA25714A4C65B3793138377E3065', '工', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'sunyu', '孙宇', '董监办主任', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5814A22B29C7484A85B4FA6D25EE6CDA', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'liuyi', '刘裔', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BEF544AA4F53402782FF702E25BB087F', '刘裔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '修史办', NULL, NULL, NULL, NULL, 'hbin', '黄斌', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0D52FE5BCA6C41B7B46D97BD69F0A2DC', '黄斌', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'wanghong', '王红', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6966FB67DB4E44C5AAC691DD2236371A', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'luanht', '栾海涛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A7904AA597DD4EF7ABA0BDFE70665BE5', '栾', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'fangxiaohua', '方小华', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '543BEE68345E4659A986BD96727E397C', '方小华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lixin', '李欣', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '005FF9E3500342178F46C553A1E3E2FA', '李欣', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'shaoyong', '邵勇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5155097B9D324E6A88F30747024537D1', '邵勇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicstj', '中航国际苏同骏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '755ABFEBF3934F3CBA6BE42B3C668D59', '中航国际苏同骏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhangjie001', '张杰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2EC2A61995D143ED8CE830F3824B2ED9', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lcgem', '李晨光', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F53E665228A846D69B65FF6996F4B2E9', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'hwh', '侯卫红', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C9E75FB3CC7A49B2A05FAB130275BEE7', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'nijiaxu', '倪嘉序', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B0D4EEDD135C4689BE912F22F2C172B4', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicszg', '中航国际宋治纲', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3E05DE2C75FC46A782407EB4F2CF7688', '中航国际宋治纲', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'mzhy', '毛周勇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3C4931C08BBE4013AEE6EC941D092296', '毛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhaochunwei', '赵春伟', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '15CC10141CDB47CC88CD596F465CBC85', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhaoyc', '赵玉成', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '83B04B0578AA4A68B1C830D86D65A409', '赵玉成', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'zhangmy', '张明月', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7A8C7883CCA242E4AC2873F82791A9FB', '张明月', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lili', '李丽', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0E8D21DC50524163A7B101BAB5E02D8D', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'tangq', '唐群', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DFBF74C0F5D047AE8036B2BA65494363', '唐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'lisha', '李莎', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3A532370C0D14AEF89BA1E618DF25C30', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'xqzyy', '薛智勇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '51167A72E55A4605969DCB402D0A1475', '薛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'wmg', '王明贵', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9264B03E161E441D97FB46B7E03772C4', '王明贵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '规划发展部', NULL, NULL, NULL, NULL, NULL, 'guojing', '郭晶', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '69510DCD0D8D4DFCA56B329F99729ADB', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'fudebin', '付德斌', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F34F0996E38E4C3CAE19974168F1280A', '付', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhanglw', '张立伟', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1D298F0D9AF54163B81673637B801E0B', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhaochen', '赵晨', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A88146218BBF438DA252F1AF0F2F7453', '赵晨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'wangguoping', '王国平', '领导干部管理办主任', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '79BD57425B954034AA8FFD92C83F566E', '王国平', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yangxu', '杨旭', '杨乐', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '04E44C2B87A941AC9A134FF4558FFB71', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'huangjing', '黄静', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '613A3F6B3AF441279830D010C625843A', '黄静', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hechuan', '何川', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7F7A4495ECFE427CA6B5ABB3BCCED8C9', '何', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'zhimin', '智敏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '213A545157DE4624A2F765593B181163', '智', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'houfanglong', '侯方龙', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9647F25269464BA3AA86501FE9CACE37', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'xupei', '徐佩', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7908DCCDCF3044A0999F7222658060AD', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'yuett', '岳婷婷', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '481F09B7F239419684B16ED54259E6C3', '岳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'liaohaitao', '廖海涛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '555C09754EE04CD2828539054DF3815D', '廖海涛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'ehr', '人力资源系统专用邮箱', '彭潇', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C00F46BEC6154F8298DCFAF131CE2798', '人力资源系统专用邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'rlzyb', '人力资源部公共邮箱', '杨旭', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '881FEA334A3E401899D63CCC5A4C3597', '人力资源部公共邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', NULL, NULL, NULL, NULL, NULL, 'hrtest', '人才测评系统', '王国平', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8E1E98611D8342BD88F88A8509811B77', '人才测评系统', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'pengxiao', '彭潇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '767937C7347849E89AE3360D764D1917', '彭潇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '人力资源部', '中航国际商学院', NULL, NULL, NULL, NULL, 'zhaopin', '人力资源招聘', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'DD4C8FE458BF40FBA34946B1F8AB8450', '人力资源', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'libin', '李斌', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5B32DD0651434AA392CADBF97DB20C21', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lipeiyin', '李培寅', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A581D600FB9F4304AC0491E354E4E5F4', '李培寅', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyuan', '章苑', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '3D24FA2113284F60935F7466109AA231', '章', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'muyan', '穆焱', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6F55593DCC954070AAC103A17E444F7A', '穆焱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liangmaolei', '梁茂蕾', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '73B028C46265441DA49D5BBAEE9275BC', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wanlina', '万莉娜', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '00C4BB7EE2844EF6A052F921C9D888FD', '万莉娜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangying', '王莹', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A5DDE1DF05C54ED3BB5C3B644F72906F', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lynan', '林彦男', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9280265F544F400EB01D95051A6BA982', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'xuxingxing', '徐幸幸', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '55F510E39AC14869B82A32DA6F567D3D', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhaocx', '赵晨雪', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9897D7E8D3C245E6907D11A78BC539D9', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'luobaiwen', '罗白雯', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9173858D87FC4ED790CF44F272E7E334', '罗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'sunyitong', '孙一桐', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5B234BD3AECD40BE88D16A7A3F1C2ACB', '孙一桐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangt', '汪涛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '723034A6E2F743B6B69B597BB295358D', '汪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'huangzy', '黄卓妍', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '00A7796FF79B48EEA5E05F411F6C5A88', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'suirong', '隋榕', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '63CC166358834781B80C36423233588C', '隋榕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangjintao', '王金涛', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '324CE8921C4F4C3693BDA9450E020315', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yanailing', '严蔼玲', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '64B078A8769E49319B8E62AC3429D477', '严', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'wangf', '王丰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '532E4CD69F124A509E495E87A1BBD76A', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'liuyx', '刘彦希', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C680C6EB62AE4DA8B31BCA3BCE306FC1', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'fanxiaowei', '范笑薇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'AD8035D1836241E585A475E219D5D9C7', '范', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'maoli', '毛立', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'A76D1823A7914672B108D0665C018FE4', '毛立', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'zhangyundi', '张云迪', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E5D78E487A5F43939BC843A580A20173', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'chenzheng001', '陈政', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '694BFC6E3F744A95959198E760F67796', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'lvkaifeng', '吕凯风', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'CB9F323C4E63466FB334B20AEB12AF6E', '吕', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yangpishi', '杨皮石', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '76E66F6EE797417D8C396CED861EF1FE', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'ljing', '刘晶', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6526D1995238490AB286490280CF9164', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'mochendong', '莫晨东', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0690D7A970E4480F802EE695F41791A8', '莫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', NULL, NULL, NULL, NULL, NULL, 'yinguangquan', '殷广泉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4373F59DA1644567B976555AAFD35B73', '殷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'xuyachao', '徐亚超', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D176798A9E2F4A81985CF0C0EB52D741', '徐亚超', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jiangq', '江强', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '29EB36135D754D53A6260F215AA6E0BC', '江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'lichuangrong', '李创荣', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B40BC113512D4062A4E901E31BA6B41B', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'cw-yxzp', '财务永续中票', '刘苏晋', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E30C76C7B9F4463496FCBE7A6DC373EA', 'cw', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jenniferwb', '王彬', '李培寅代管', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8EEE4B005D584338919A7238F18B2812', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'zhangyulong', '张玉龙', '常驻法国', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '778856CFD6C04CEFACBE06C10FC43297', '张玉龙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'liusujin', '刘苏晋', '常驻美国', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '304C88CFAA9C428AAE29874143CB4D97', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'wangsh', '王双', '常驻英国', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2D03D48101CE400BBED186B11A972236', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'yaoyuanjm', '姚远', '范帅帅代管', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '93A2A1CF57DE47408E28CDF9927FCF9B', '姚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'qiqing', '齐晴', '马亮代管', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FD16E62D91044AC484EB5EF9DB7B42BB', '齐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'fanshuaishuai', '范帅帅', '陈政代管', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '30DA41D389564F16B3FF4415C7D8C55D', '范', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'linjining', '林纪宁', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F2A1B3A1817944BFAFAA61224942D0EB', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'jinrx', '金如心', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8F69462A5D564C0EA1BF7F91414937F6', '金', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'chenshiya', '陈诗亚', '张云迪代管', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '88BF57CB811048079D659FD16525E4A5', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '其他', NULL, NULL, NULL, NULL, 'maliang', '马亮', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '58A99ACC9EAC41F195F3EEFE12DDD129', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'youyanchun', '由艳春', '处长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5656105FDD1C4F888191361F9BADA95A', '由艳春', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'zhanghui', '张辉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9B88871A0589400FAB35076D164464D0', '张辉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'xuxg', '徐新纲', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2DF051D24B9A443B94F6CE8B92840215', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '财务部', '国际合作部财务', NULL, NULL, NULL, NULL, 'jp', '姜萍', '常驻', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '697D2990042A4487964ED5F3682A8976', '姜萍', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhangzhibiao', '张志标', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '5B5D9C8013F9419E904D745E422C64A4', '张志标', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'guojian', '郭剑', '专务兼副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9541EB816DB746D99A82CAB7084BEB02', '郭剑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'chenxh', '陈晓红', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '760A354F15E440D49640362AE9D836DC', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'hpl', '韩沛霖', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2A5E3161E9A543DCB19A059A63A9C9B8', '韩沛霖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'ltj', '刘铁军', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D3FC5035A1B84E9BADA63EF2B6BD8BEE', '刘铁军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'yanglei', '杨蕾', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9120B097AB85458FAC3395CD7B2B5853', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'lfchuan', '李方川', '国际航空板块业务办公室主任', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '97B7EA8649F340CF80B684886CB82C58', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'fqy', '傅麒玉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '4B4E7E2BFC234AE28B7FA53307F30163', '傅麒玉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhp', '朱贺鹏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '36AD4811C16E48848A0206A5A757403C', '朱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'dengjiani', '邓佳妮', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D4714DDDE4BB4D63A6912614B2AA93CE', '邓', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhenli', '甄李', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F52294E3088A4E68B1A2FD022BD2108A', '甄李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wxy', '王心宇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '459DD62F5D3F4C578F9E7BFF87998DDE', '王心宇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'julia', '朱立新', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F9D200810FA6467582E8485BB88F6285', '朱立新', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'zhouxiaoling', '周小玲', '邓佳妮代管', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0A5161EBE9104C44A455110341878A14', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'wbing', '王兵', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '928910C6C11E462699412215A54D47F6', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '经营管理部', NULL, NULL, NULL, NULL, NULL, 'baifeng001', '白峰', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9FEA9C15C72E4A44A5A75BE2664C5393', '白', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'zhuli', '朱力', '部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F8A7B6DB0167446897DF529B1A5B9B6A', '朱力', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jinshaohua', '金少华', '专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C546476749BE4FACBD8B18F3BFCEEAF3', '金少华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'sqh', '宋清浩', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '47FED14808494BF599FEC208D2B4707D', '宋清浩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'hunq', '胡乃庆', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8FE5076BBB284C148348C97B440EFB97', '胡', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'songxiaodong', '宋晓东', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '122CE23A41184F46A916DE610B19DDCC', '宋晓东', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'chenyang', '陈阳', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '8DCBCA548192495D8B42E1B1E52E4546', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'quning', '曲宁', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '91B244C1DC164208BF1CD601222B1801', '曲', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'tanqi', '谭奇', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '03CFE15EB01D40C2ABE1477851F34AB7', '谭奇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'wangying626', '王颖', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FBDF4D823799439792910EEF4F58EA71', '王颖', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'liujinghua', '刘菁华', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '05E9FA9321014950B7FCE9702A2BAA1B', '刘菁华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'jin', '纪宁', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D6512E2F78384472AF1537AE159B326F', '纪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际业务发展与管理部', NULL, NULL, NULL, NULL, NULL, 'intl', '海外机构联络', '曲宁', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9A703EE545A9481887EA6238EF30ECB3', '海外机构联络', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'qiaojuan', '乔娟', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9288B3D13F074FD1B05F7EDE799BBAE0', '乔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'xiaofu', '付潇', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2D5CDA32B38743E38CBFB467DEE94004', '付', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'wangxiuming', '王秀明', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '0F9304E81684445D8C3B2CB2CD8E3F1F', '王秀明', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'maxiaoxu', '马晓旭', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F0EE5A95CC7A4647B4E93CB7B4F5E697', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'yuweiye', '于伟业', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '6DDAA15E8402423CA3E28FD686FD7F3A', '于', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'guotianji', '郭天骥', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7848ACA65FE94B44979B86FEDE099F13', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '法律事务部', NULL, NULL, NULL, NULL, NULL, 'lengfengyang', '冷奉阳', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1C6EB48E1CDB4967951CC8F917D64E91', '冷', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'czy', '陈兹勇', '部长一纪检组副组长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '12BC6FEAA59E4AABAA3DF42D63CF4469', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guowei', '郭薇', '专务兼副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '18D88D25AD1A4C2C9393E17B81FD7510', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'guxiaozhong', '顾筱中', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '198329F8418E4FC58F954DA09E395D35', '顾筱中', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangjunmin', '张军民', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'FE5406408A9B4D34AA10245798C9E47F', '张军民', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'huangqian', '黄倩', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'BF287271CCC2419ABB63235F48F7C552', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangp', '张鹏', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'E6A61733A3CF410EBAC72971FD3A9015', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'zhangshuang', '张爽', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D3FF3BF25ECA43B393BE778B25F3C344', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'jubao', '中航国际审计部举报邮箱', '张爽', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '48898527E1C949B8BA5A15DA4F098767', '举报邮箱', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'shenji', '审计专用', '张军民', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '54D81916F3994B26B5AF0B99DF371096', '审计专用', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '纪检监察审计部', NULL, NULL, NULL, NULL, NULL, 'liuying001', '刘颖', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '633A8EB8A3764720AFD86AED2BF31019', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'sxt', '史笑彤', '副部长', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'F5288907B2A04CA3A842D9FB1C195D6A', '史笑彤', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wudan', '吴丹', '部长助理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'C262A1539D1B4EC1A37A0C19EE49B86E', '吴丹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lipeng', '李鹏', '党委副书记纪委书记', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'ED6C2AAFF9294338BACD085B6657CBA6', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhangwen', '张文', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '9622B53352A84FF9B148F68B65C85876', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'lily723', '刘美希', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'D978E95988B143B8A51FEF41460E3261', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'xuli', '许莉', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B2AB223DD731443F805796E15D77694E', '许莉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'wwt', '魏文韬', NULL, 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, 'B0C1CD59A1BB43968D6526703035EF81', '魏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'mingpian', '名片制作', '刘美希', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '124CEEF195DB4CF6A35AC4373FCD4969', '名片制作', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'qywhb', '企业文化部公用', '许莉', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '59182910FF0642E4A71F5DFC08C2B89F', '企业文化部公用', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '党建和思想政治工作部(企业文化部)', NULL, NULL, NULL, NULL, NULL, 'zhgjyjx', '中航国际意见箱', '许莉', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '2C7A6EF97DA84092A4C7DF60A4FF2C7F', '中航国际', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'zoukangning', '邹康宁', '事业部总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '73FFDC652C934709884B7D68DFAEFF41', '邹', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'suzhenyu', '苏振宇', '事业部副总经理', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '7D6EEEBEEC604F23B42F11FE99A6D504', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部领导', NULL, NULL, NULL, NULL, 'hyw', '何跃武', '事业部总会计师', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '063D93F8BC4349DF9997732BE2D825FC', '何跃武', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '国际合作发展事业部', '事业部专务', NULL, NULL, NULL, NULL, 'yanna', '杨慧君', '专务', 'D7FD3F20DE8648D29340F81B994C840A', NULL, 0, '1F8C8A7C6591423E9D9257E4AE91E989', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'wuzhaohan', '吴昭含', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F93D637906F3488E878A05763F87ABC8', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'jinyiran', '靳怡然', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '6850578057FE465EB28D55E9B74AB625', '靳', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'xuchumeng', '徐楚朦', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '620AEFCF0E0F40018BC7301582D034F8', '徐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '政府项目服务处', NULL, NULL, NULL, 'fjj', '傅金鉴', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E943C450D06C41A8930F3B324F197082', '傅', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'gaohai', '高海峰', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '773BF417EB714CBCA72FA1BEFC1BD76A', '高', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'slj', '苏立军', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '5A678A2EA0E4441DA97234FE871D0F6F', '苏立军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'majinghuan', '马靖寰', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '7025FC0B0E454F1DBEABC646681BC41A', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'huanglingrui', '黄泠瑞', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '768336E7B9E9423883C35B742E1C4E8C', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '通用飞机销售处', NULL, NULL, NULL, 'getong', '葛桐', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'ECB95637F04344C8BB03948B5525EC68', '葛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'liangpengfei', '梁鹏飞', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E834CEB0E063487898B8B1C23D98ACBD', '梁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'wenyanping', '温燕苹', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '83D106B1AF3448AB989D3572CC7476A4', '温', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'shibiao', '石飚', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '97B1677F279049D8951474EC60B3982D', '石', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '产品发展处', NULL, NULL, NULL, 'chenyan', '陈燕', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '3A25293ACA264C9F87692E3EF29683E3', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'yangyuewei', '杨月炜', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '7B28055CBD2C4757BDE3D58E93F26A15', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'lzt', '李振堂', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E5005F3B76344933BA60381C85E5D483', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'niyang', '倪杨', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '416D16546874401D92271FA32F4993B2', '倪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'qilianghai001', '戚良海', '司机', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '8F313F90D2244E829A9C41F85FF98A70', '戚', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '无人机业务处', NULL, NULL, NULL, 'jishenxin', '吉申莘', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C5DCC0DDED6A4B69A963283358CC957B', '吉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangruoyu', '王若愚', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '00D4D8C727874872850C1F1DDA8F02F3', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liuxianghui', '刘湘徽', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A24761CC4C5D4B2DA3EB6B44A4251CA0', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'wangnan', '王楠', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '83CB1A25DB5F4441BC99B552FCB273B4', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'zhangkl', '张凯亮', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'B60FAB1766124ECC86D43FD4411668B1', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'panyu', '潘钰', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '2AF409FC61AB41C49C175EA941B378AC', '潘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'shenyunzhu', '沈云竹', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '3A196786E5A54F709464EE9B864E6B2E', '沈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '售后支持处', NULL, NULL, NULL, 'liqimin', '李齐敏', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '2D9B4AECFAD8491BAB6C7AA48D8D1839', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'linsong', '林松', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '010F2F37351C4DB08A1083CFF3DE0869', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'zhangyan01', '张燕', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A93EFE7355D842FFB17CC3E7BD196088', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'lijing826', '李晶', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E8AD15A9F4A54F9BAE4478AFF67F4684', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '航空运营支持事业部', '运营支持通航产品发展与支持部', '培训与综合处', NULL, NULL, NULL, 'mxj', '马晓珺', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'D7561FF7300444B19E6E0C41473ECA79', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhqy', '郑启源', '公司专务', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'BE9C56E66DE4420A91D62948581C781F', '郑', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'guanlq', '关力群', '公司专务兼行政总监', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '98D0D4EA1028475791BFE08ED8FBA785', '关', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'licn', '李承宁', '公司专务', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '9B117B1D2D1E4CC0AC50C1065F50C60E', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'liubinliao', '刘滨辽', '贸易部副总经理', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E06B76C2C0B842B1AC900F9A0ED380ED', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'yel', '叶岭', '投资公司总经理助理', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '102BCBE1033A435488568E21659C1AD7', '叶', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'juyanfeng', '鞠岩峰', '投资公司总经理助理', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '238E0D0A309C447781DE3FD66EFCEC53', '鞠', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'fangdaojun', '方道军', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '41EDFED1374A43CDA5F2F0F0994E3777', '方道军', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'waferlinjining', '林纪宁', '财务副总监', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '67BA9EE9393C4C31AB2F506F3EF1EA0A', '林', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhaoy', '赵扬', '财务部副财务总监', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '3518F2C4E56C4B46913498A6B56F279B', '赵', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '香港集团有限公司', NULL, NULL, NULL, NULL, 'zhousha', '周莎', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '56B8860CBDDB40AAA853FAD09C0378A1', '周', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'wafertangir', '唐岳震', '总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F3A046091DD14CDA9835003F7AA3455F', '唐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '伊朗代表处', NULL, NULL, NULL, NULL, 'lihao', '李昊', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '48A0167986CF45EFA4F34C14FE95D88F', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferfengqiao', '冯乔', '总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '282408FD520B44FAAAF4794D821CDDC6', '冯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'waferzongdian', '宗滇', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '86831AF64C054705A626AAAAF7659508', '宗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '土耳其代表处', NULL, NULL, NULL, NULL, 'zongdian', '宗滇', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'D102E45D52834546BA83230B5801C349', '宗', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '柬埔寨代表处', NULL, NULL, NULL, NULL, 'waferhuibingsun', '孙会兵', '总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C51B81AE65D544999BF03BC291F6100C', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度尼西亚代表处', NULL, NULL, NULL, NULL, 'waferzhangchenxiao', '张晨虓', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '76C94E35A0414947B581E5647BB51543', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '印度代表处', NULL, NULL, NULL, NULL, 'luxiuchen', '陆秀臣', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'FEE66BB730D54209B29E2F4A36706632', '陆', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'wafersunhedong', '孙和东', '副总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '5A01F85F163D4C76B341BB21D8E73765', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哈萨克斯坦代表处', NULL, NULL, NULL, NULL, 'sunhedong', '孙和东', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '799EEB4F9293471983D24A6F1C025DE0', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '塔吉克斯坦代表处', NULL, NULL, NULL, NULL, 'waferchennan', '陈楠', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'DA1551C4CB0C4E759EA20197A725A252', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '老挝代表处', NULL, NULL, NULL, NULL, 'zhanhongyuan', '湛洪元', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'ABC3E5E11AC4413C91964B26BE194D2F', '湛', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '肯尼亚代表处', NULL, NULL, NULL, NULL, 'avicct-sutianshu', '苏天舒', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C42A8F0D781E462A9DFC241BB9691C2B', '苏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '赞比亚代表处', NULL, NULL, NULL, NULL, 'wafercuiji', '崔季', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '2EE3F564CD9F4BB387EE15EE87FB2619', '崔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃塞俄比亚代表处', NULL, NULL, NULL, NULL, 'wuping', '吴平', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'CE04B838F58046D3952BF83461815819', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '埃及代表处', NULL, NULL, NULL, NULL, 'waferyangjinshan', '杨金山', '副总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'CE5098B519AC49BEBD337F2812A695AB', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'lihuan', '李欢', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '16327F9411CF412483AB874FD696CB12', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '坦桑代表处', NULL, NULL, NULL, NULL, 'yangtianhao', '杨天昊', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '62648BC503B44B89A3B4B192CAD4AD0A', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '乌干达代表处', NULL, NULL, NULL, NULL, 'waferdingsonghe', '丁松鹤', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E915DFDF0FA34DE2985812B09D4A26A9', '丁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加纳代表处', NULL, NULL, NULL, NULL, 'waferyuhongpeng', '余鸿鹏', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '7E71E0738E5846AB82AE59F6F3A226E6', '余', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '加蓬代表处', NULL, NULL, NULL, NULL, 'wafersunyang', '孙阳', '副总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A612609DA6B046E29F07A410DC07C80C', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '刚果代表处', NULL, NULL, NULL, NULL, 'zhangxf', '张晓风', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E1E025917DC64239843C44C8A4A69FA2', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '科特迪瓦代表处', NULL, NULL, NULL, NULL, 'wafertangzj', '唐忠杰', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '0BF2921CC9DB4D7A8A9965A8133D186B', '唐', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '津巴布韦代表处', NULL, NULL, NULL, NULL, 'wafermachengyuan', '马骋远', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '25863D75054146FF922BAF39D72EF265', '马', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '莫桑比克代表处', NULL, NULL, NULL, NULL, 'wafertierigen', '铁日根', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '842B4699985C4958A6A7ECA760190B36', '铁', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '喀麦隆代表处', NULL, NULL, NULL, NULL, 'jianghui002', '姜辉', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '353392C2B6934597800A6E28B106D2E0', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '尼日利亚代表处', NULL, NULL, NULL, NULL, 'ganlijun', '甘黎军', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '26E717296CE94271983D3A814A77EA5F', '甘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '安哥拉代表处', NULL, NULL, NULL, NULL, 'suiyongjie', '隋永杰', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'FD5BE116A4B34987853C4FCEEEFFA064', '隋', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge', '德国代表处', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '1B4EBE58FB844B3F9B80C533173EEB3F', '德国代表处', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.ge-ltd', '德国公司', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '70140476F8FF407FA90E2B12C625FBC1', '德国公司', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'avic.germany', '德国代表处', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C4CF331F490D4D84A720F752C3B8B4BC', '德', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'chenzhen', '陈震', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '6565735B889E4974B6AD536ADB6E73A5', '陈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'liqijiang', '李琦江', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '248B6876B10C45EE8DA27525B0F45236', '李琦江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'sunjian', '孙健', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '355646BA3BCA482C9724A7B57A00A37F', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferzhangyulong', '张玉龙', '财务代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F53A3821745D4FC0A4EBD0CB5699B2DF', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '欧洲代表处', NULL, NULL, NULL, NULL, 'waferliyudong', '李煜东', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E1D09BF763614F1FA6C1E3B5C7CA9A43', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermikelou01', '娄玉成', '总代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C657B52DFD9E4BE2A0ED358382D8C2F3', '娄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'waferwangsh', '王双', '财务代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '5316AD3E7A8B433CA2A0FF9559DA7C98', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国代表处', NULL, NULL, NULL, NULL, 'wafermenghaitao', '孟海涛', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '33C8B236B901473BB2C7BCD1D671C768', '孟', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '英国公司', NULL, NULL, NULL, NULL, 'wafermikelou011', '娄玉成', '总经理', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'BF2315E518E24FE6BB0649B88E73BA66', '娄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '德国代表处', NULL, NULL, NULL, NULL, 'wan', '万春雷', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E57FEDBBB553419BA210251120805170', '万', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '俄罗斯代表处', NULL, NULL, NULL, NULL, 'waferjp', '姜萍', '财务代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'AE314C380FFC4C08ADED1F4AEB9F10A4', '姜', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '挪威代表处', NULL, NULL, NULL, NULL, 'huanglei', '黄磊', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '97A4AE3823C842D5BD04D62C7013A0FB', '黄', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'zhangxuming', '张旭明', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '12A535B5A74941F8AA9D2C4EA2AD061D', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferfrankyang', '杨方', '副总经理', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '3632377C0E6B487289BC22B551AAB326', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'hanke001', '韩珂', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '84295A8013DC4076806DBB9A8EC7D16C', '韩', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'emyang', '杨明', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '5DA926B4ADE44BCCB7FF921DA753FFFC', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '美国公司', NULL, NULL, NULL, NULL, 'waferliusujin', '刘苏晋', '财务代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '1C9A99AC71104414B77DE470DDE094CC', '刘', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '哥斯达黎加代表处', NULL, NULL, NULL, NULL, 'waferlingxinwei', '凌欣伟', '公司代表', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '9AC4F3F967AB4800A61FE0232B2EA3B6', '凌', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '古巴代表处', NULL, NULL, NULL, NULL, 'miaojingdan', '缪景丹', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '37B5E68A9A3D4CFFA2EC27EFA4293D93', '缪', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '驻外机构', '巴西代表处', NULL, NULL, NULL, NULL, 'pengbo', '彭博', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C5984436DA1D42F581EFBA5F86702004', '彭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'yangqing', '杨青', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '20103F3502FC4DE998FABFF2FF97734C', '杨', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'shenfeng', '沈枫', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C0C35207E6F64376AC62FBB594D44537', '沈枫', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'lpr', '凌佩冉', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'BFB4873476E14539B56C21A6DAB6F5C7', '凌佩冉', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wulw', '吴力伟', '车队队长', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '01E6B6B9E8C94053AD2522686A8159FE', '吴', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'wangqian', '汪黔', '司机', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F748D701B5CB440587520B1696400F28', '汪黔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'liushujiang', '刘淑江', '司机', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F9E98B492CB9484A93389C257A31754A', '刘淑江', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guanxu', '关旭', '司机', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'AB8E3443E49F4779A81CA0536692FACF', '关旭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'luchunlin', '卢春林', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A9FE7E7D5E5A4171BF5E2117F9B5C760', '卢', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'meetingbj', '北京会议室', '林敬惠', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'A2F34E16EEE1486A9BB08DAC3A860C27', '北京会议室', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'guoyuxi', '郭宇溪', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '3B7B7B15DC97434F9B273DE935E5B195', '郭', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'sf', '沈枫', '公文', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '9B1393DA634540B9B15171DC615A1F9B', '沈', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', NULL, NULL, NULL, NULL, NULL, 'avicbsinfo', '工商信息', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '31FF9A609E194EC2B755343CA72484CC', '工', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'sunyu', '孙宇', '董监办主任', '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'D4308AB394C94431B06A2615542EC4F2', '孙', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '董监办', NULL, NULL, NULL, NULL, 'liuyi', '刘裔', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '2F280AD6F3B74B6EB7BF097EDFA7AC5F', '刘裔', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '修史办', NULL, NULL, NULL, NULL, 'hbin', '黄斌', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '397D08E66E654F8B9BCB2B2CA4871DFE', '黄斌', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'wanghong', '王红', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'C868B64B6CFD4BAA9A725E6A9B8B255A', '王', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'luanht', '栾海涛', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '8C389AF0733B4200BEC2646EE86432F7', '栾', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '综合管理部', '离退休人员管理办公室', NULL, NULL, NULL, NULL, 'fangxiaohua', '方小华', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '81A4E96F2E924BE1B85078889C636BBD', '方小华', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lixin', '李欣', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'E6D154C4A110402E9F51B20E99335220', '李欣', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'shaoyong', '邵勇', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '5847C5889B70480CA4D5E8CBDA52B752', '邵勇', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'avicstj', '中航国际苏同骏', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '10FC7CD902DD457DBE98327264B885C8', '中航国际苏同骏', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'zhangjie001', '张杰', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'F57CBFDC8836470A832C2EA6BCE9E87E', '张', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'lcgem', '李晨光', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'B19CAB4AE7314DAFB0F560BD096A6FF6', '李', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'hwh', '侯卫红', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, '6881ABC3055A44E99FDC83D2D72CAC5A', '侯', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '本职', NULL);
INSERT INTO public.avic_imp_employee VALUES ('中航国际总部', '信息化推进办公室', '信息化服务人员', NULL, NULL, NULL, NULL, 'nijiaxu', '倪嘉序', NULL, '3099D9477C5B460E89F9FD04C3B6FA86', NULL, 0, 'ACC27FABD760439299FB65C8BCF72DEB', '倪', NULL, NULL, NULL, NULL, NULL, NULL,