SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for act_ge_bytearray
-- ----------------------------
DROP TABLE IF EXISTS `act_ge_bytearray`;
CREATE TABLE `act_ge_bytearray`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  `NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `DEPLOYMENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BYTES_` longblob NULL,
  `GENERATED_` smallint(1) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_BYTEAR_DEPL`(`DEPLOYMENT_ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ge_property
-- ----------------------------
DROP TABLE IF EXISTS `act_ge_property`;
CREATE TABLE `act_ge_property`  (
  `NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `VALUE_` varchar(1200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`NAME_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of act_ge_property
-- ----------------------------
INSERT INTO `act_ge_property` VALUES ('next.dbid', '969881', 27871);
INSERT INTO `act_ge_property` VALUES ('schema.history', 'create(5.14)', 1);
INSERT INTO `act_ge_property` VALUES ('schema.version', '5.21.0.0', 1);

-- ----------------------------
-- Table structure for act_hi_actinst
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_actinst`;
CREATE TABLE `act_hi_actinst`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CALL_PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ACT_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `ACT_TYPE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ASSIGNEE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `START_TIME_` datetime(0) NULL,
  `END_TIME_` datetime(0) NULL DEFAULT NULL,
  `DURATION_` bigint(20) NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_END`(`END_TIME_`) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_EXEC`(`EXECUTION_ID_`, `ACT_ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_PROCINST`(`PROC_INST_ID_`, `ACT_ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_START`(`START_TIME_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_comment
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_comment`;
CREATE TABLE `act_hi_comment`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TYPE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TIME_` datetime(0) NULL,
  `USER_ID_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ACTION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `MESSAGE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `FULL_MSG_` longblob NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_identitylink
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_identitylink`;
CREATE TABLE `act_hi_identitylink`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `GROUP_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TYPE_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `USER_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_procinst
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_procinst`;
CREATE TABLE `act_hi_procinst`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BUSINESS_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `START_TIME_` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `END_TIME_` datetime NOT NULL,
  `DURATION_` int(11) NULL DEFAULT NULL,
  `START_USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `START_ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `END_ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SUPER_PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DELETE_REASON_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_procinst_extension
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_procinst_extension`;
CREATE TABLE `act_hi_procinst_extension`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BUSINESS_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_ORG_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_ORG_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_FULL_NAME_` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION_` bigint(20) NULL DEFAULT NULL,
  `DESCRIPTION_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_NAME_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `START_TIME_` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `END_TIME_` datetime(0) NOT NULL,
  `DURATION_` int(11) NULL DEFAULT NULL,
  `START_USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `START_ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `END_ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SUPER_PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DELETE_REASON_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_taskinst
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_taskinst`;
CREATE TABLE `act_hi_taskinst`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_DEF_KEY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `DESCRIPTION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `OWNER_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `ASSIGNEE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `START_TIME_` datetime(0) NULL,
  `CLAIM_TIME_` datetime(0) NULL DEFAULT NULL,
  `END_TIME_` datetime(0) NULL DEFAULT NULL,
  `DURATION_` bigint(20) NULL DEFAULT NULL,
  `DELETE_REASON_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `PRIORITY_` int(11) NULL DEFAULT NULL,
  `DUE_DATE_` datetime(0) NULL DEFAULT NULL,
  `FORM_KEY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `CATEGORY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `IDX_HI_TASKINST_ET`(`END_TIME_`) USING BTREE,
  INDEX `IX_HI_TASKINST_PIID`(`PROC_INST_ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_taskinst_extension
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_taskinst_extension`;
CREATE TABLE `act_hi_taskinst_extension`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CATALOG_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `KIND_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_URL_` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_URL_` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_OGN_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_OGN_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_FULL_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `EXECUTOR_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_OGN_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_OGN_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_FULL_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `STATUS_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_NAME_` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_NAMES_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `OWNER_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_OGN_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_OGN_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_FULL_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `PREVIOUS_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_UNIT_HANDLER_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BUSINESS_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BUSINESS_CODE_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NEED_TIMING_` int(11) NULL DEFAULT NULL,
  `OPINION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `RESULT_` int(11) NULL DEFAULT NULL,
  `SLEEPED_DATE_` date NULL DEFAULT NULL,
  `SIGN_PUNISH_` int(11) NULL DEFAULT NULL,
  `SIGN_NEED_TIMING_` int(11) NULL DEFAULT NULL,
  `VERSION_` bigint(20) NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COOPERATION_MODEL_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LIMIT_TIME_` int(11) NULL DEFAULT NULL,
  `APPLICANT_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROCESS_DEFINITION_KEY_` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_PERSON_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_PERSON_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_DEF_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DESCRIPTION_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `START_TIME_` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `CLAIM_TIME_` datetime(0) NOT NULL,
  `END_TIME_` datetime(0) NOT NULL,
  `DURATION_` int(11) NULL DEFAULT NULL,
  `DELETE_REASON_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PRIORITY_` int(11) NULL DEFAULT NULL,
  `DUE_DATE_` datetime(0) NULL,
  `FORM_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CATEGORY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `GENERATE_REASON_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SUB_PROC_UNIT_NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_taskinst_relation
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_taskinst_relation`;
CREATE TABLE `act_hi_taskinst_relation`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `CREATED_BY_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATED_BY_NAME` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `BUSINESS_KEY` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
  `PROC_INST_ID` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程实例ID',
  `TASK_ID` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '任务ID',
  `RELATED_TASK_ID` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关联任务ID',
  `VERSION` decimal(65, 30) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IDX_TASKINST_RELATION_BIZ_ID`(`BUSINESS_KEY`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '任务关联' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_hi_varinst
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_varinst`;
CREATE TABLE `act_hi_varinst`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `VAR_TYPE_` varchar(400) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  `BYTEARRAY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DOUBLE_` decimal(22, 10) NULL DEFAULT NULL,
  `LONG_` int(11) NULL DEFAULT NULL,
  `TEXT_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TEXT2_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATE_TIME_` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `LAST_UPDATED_TIME_` datetime(6) NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_re_deployment
-- ----------------------------
DROP TABLE IF EXISTS `act_re_deployment`;
CREATE TABLE `act_re_deployment`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `CATEGORY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `DEPLOY_TIME_` datetime(0) NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_re_procdef
-- ----------------------------
DROP TABLE IF EXISTS `act_re_procdef`;
CREATE TABLE `act_re_procdef`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` decimal(65, 30) NULL DEFAULT NULL,
  `CATEGORY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `KEY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `VERSION_` bigint(20) NOT NULL,
  `DEPLOYMENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RESOURCE_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `DGRM_RESOURCE_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `DESCRIPTION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `HAS_START_FORM_KEY_` tinyint(1) NULL DEFAULT NULL,
  `SUSPENSION_STATE_` int(11) NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HAS_GRAPHICAL_NOTATION_` tinyint(1) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_re_procdef_tree_del
-- ----------------------------
DROP TABLE IF EXISTS `act_re_procdef_tree_del`;
CREATE TABLE `act_re_procdef_tree_del`  (
  `RE_PROCDEF_TREE_ID` bigint(20) NOT NULL COMMENT '主键',
  `CODE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '编码',
  `NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
  `PATH` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父节点ID',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '状态',
  `DESCRIPTION` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT '排序号',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `KEY` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程KEY',
  `APPROVAL_RULE_PROC_DEF_KEY` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '审批规则流程ID',
  `NODE_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '节点类型 folder 文件夹 proc 流程 procUnit 流程环节',
  `NEED_TIMING` int(11) NULL DEFAULT NULL COMMENT '需要计时',
  `APP_MODEL_ID` int(11) NULL DEFAULT NULL COMMENT 'APP模型ID',
  `FULL_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
  `FULL_ID` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
  `SHOW_QUERY_HANDLERS` int(11) NULL DEFAULT NULL COMMENT '显示询问处理人对话框 1 是 0 否',
  PRIMARY KEY (`RE_PROCDEF_TREE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '流程定义树' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_event_subscr
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_event_subscr`;
CREATE TABLE `act_ru_event_subscr`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  `EVENT_TYPE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `EVENT_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ACTIVITY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CONFIGURATION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `CREATED_` datetime(0) NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_execution
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_execution`;
CREATE TABLE `act_ru_execution`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BUSINESS_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PARENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SUPER_EXEC_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `IS_ACTIVE_` tinyint(1) NULL DEFAULT NULL,
  `IS_CONCURRENT_` tinyint(1) NULL DEFAULT NULL,
  `IS_SCOPE_` tinyint(1) NULL DEFAULT NULL,
  `IS_EVENT_SCOPE_` tinyint(1) NULL DEFAULT NULL,
  `SUSPENSION_STATE_` bigint(20) NULL DEFAULT NULL,
  `CACHED_ENT_STATE_` bigint(20) NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOCK_TIME_` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_identitylink
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_identitylink`;
CREATE TABLE `act_ru_identitylink`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  `GROUP_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TYPE_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `USER_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_job
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_job`;
CREATE TABLE `act_ru_job`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` decimal(65, 30) NULL DEFAULT NULL,
  `TYPE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LOCK_EXP_TIME_` datetime(0) NULL DEFAULT NULL,
  `LOCK_OWNER_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `EXCLUSIVE_` decimal(1, 0) NULL DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RETRIES_` decimal(65, 30) NULL DEFAULT NULL,
  `EXCEPTION_STACK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXCEPTION_MSG_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `DUEDATE_` datetime(0) NULL DEFAULT NULL,
  `REPEAT_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `HANDLER_TYPE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `HANDLER_CFG_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_JOB_EXCEPTION`(`EXCEPTION_STACK_ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_task
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_task`;
CREATE TABLE `act_ru_task`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `REV_` decimal(65, 30) NULL DEFAULT NULL COMMENT '版本号',
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '执行实例ID',
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程实例ID',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
  `NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '节点定义名称',
  `PARENT_TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点实例ID',
  `DESCRIPTION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '节点定义描述',
  `TASK_DEF_KEY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '节点定义的KEY',
  `OWNER_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '实际签收人',
  `ASSIGNEE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '签收人或委托人',
  `DELEGATION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '委托类型',
  `PRIORITY_` decimal(65, 30) NULL DEFAULT NULL COMMENT '优先级别',
  `CREATE_TIME_` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `DUE_DATE_` datetime(0) NULL DEFAULT NULL COMMENT '过期时间',
  `SUSPENSION_STATE_` decimal(65, 30) NULL DEFAULT NULL COMMENT '是否挂起',
  `CATEGORY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FORM_KEY_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_TASK_CREATE`(`CREATE_TIME_`) USING BTREE,
  INDEX `ACT_IDX_TASK_EXEC`(`EXECUTION_ID_`) USING BTREE,
  INDEX `ACT_IDX_TASK_PROCDEF`(`PROC_DEF_ID_`) USING BTREE,
  INDEX `ACT_IDX_TASK_PROCINST`(`PROC_INST_ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_task_extension
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_task_extension`;
CREATE TABLE `act_ru_task_extension`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CATALOG_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `KIND_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_URL_` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_URL_` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_OGN_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_OGN_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_FULL_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `EXECUTOR_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_OGN_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_OGN_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_FULL_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `STATUS_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_NAME_` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_NAMES_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `OWNER_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_POS_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_POS_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_DEPT_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_DEPT_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_OGN_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_OGN_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_FULL_ID_` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OWNER_FULL_NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `PREVIOUS_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_UNIT_HANDLER_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BUSINESS_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BUSINESS_CODE_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NEED_TIMING_` int(11) NULL DEFAULT NULL,
  `OPINION_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `RESULT_` bigint(20) NULL DEFAULT NULL,
  `SLEEPED_DATE_` date NULL DEFAULT NULL,
  `VERSION_` bigint(20) NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COOPERATION_MODEL_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LIMIT_TIME_` int(11) NULL DEFAULT NULL,
  `APPLICANT_PERSON_MEMBER_ID_` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `APPLICANT_PERSON_MEMBER_NAME_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROCESS_DEFINITION_KEY_` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATOR_PERSON_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTOR_PERSON_ID_` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DESCRIPTION_` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_DEF_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DELEGATION_` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PRIORITY_` int(11) NULL DEFAULT NULL,
  `START_TIME_` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DUE_DATE_` datetime NOT NULL,
  `SUSPENSION_STATE_` int(11) NULL DEFAULT NULL,
  `CATEGORY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `FORM_KEY_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `GENERATE_REASON_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SUB_PROC_UNIT_NAME_` varchar(1020) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for act_ru_variable
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_variable`;
CREATE TABLE `act_ru_variable`  (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REV_` bigint(20) NULL DEFAULT NULL,
  `TYPE_` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME_` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BYTEARRAY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DOUBLE_` decimal(10, 10) NULL DEFAULT NULL,
  `LONG_` decimal(19, 0) NULL DEFAULT NULL,
  `TEXT_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TEXT2_` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_VARIABLE_TASK_ID`(`TASK_ID_`) USING BTREE,
  INDEX `ACT_IDX_VAR_BYTEARRAY`(`BYTEARRAY_ID_`) USING BTREE,
  INDEX `ACT_IDX_VAR_EXE`(`EXECUTION_ID_`) USING BTREE,
  INDEX `ACT_IDX_VAR_PROCINST`(`PROC_INST_ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for hibernate_sequences
-- ----------------------------
DROP TABLE IF EXISTS `hibernate_sequences`;
CREATE TABLE `hibernate_sequences`  (
  `SEQUENCE_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NEXT_VAL` bigint(65) NULL DEFAULT NULL,
  PRIMARY KEY (`SEQUENCE_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_applicationsystem
-- ----------------------------
DROP TABLE IF EXISTS `sa_applicationsystem`;
CREATE TABLE `sa_applicationsystem`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CODE` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `CLASS_PREFIX` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_applicationsystem
-- ----------------------------
INSERT INTO `sa_applicationsystem` VALUES ('5C7273733D82ABEFE050007F010066C9', 'tech', '上海科技大学', 'com.huigou.tech', 2, 277854);
INSERT INTO `sa_applicationsystem` VALUES ('A6A3D854550B43F7B549B25292938597', 'Platform', '平台', 'com.huigou.uasp', 1, 252264);

-- ----------------------------
-- Table structure for sa_approval_rejected_reason
-- ----------------------------
DROP TABLE IF EXISTS `sa_approval_rejected_reason`;
CREATE TABLE `sa_approval_rejected_reason`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类ID',
  `CONTENT` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'content',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT 'sequence',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT 'status',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT 'version',
  `REJECTED_REASON_KIND` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '审批驳回理由维护' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_approval_rejected_reason
-- ----------------------------
INSERT INTO `sa_approval_rejected_reason` VALUES ('4C22EEC795A84E18A852FD7612A5A149', '50', '缺：项目负责人签字/会议负责人签字', NULL, 0, 267347, NULL);
INSERT INTO `sa_approval_rejected_reason` VALUES ('5A23A0D678A44A70864EF1739078AD6D', '9E3AF30038A7481DAEABC4E7428E22AD', '缺：项目负责人/报销人签字', NULL, 0, 267356, NULL);
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C8267FF113B8E24E050007F0100184C', '7045B38ED0AB47B991536307BE68EA0B', '缺：项目负责人签字/会议负责人签字', 1, 0, 279821, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C8268662FA0F979E050007F01001858', '7045B38ED0AB47B991536307BE68EA0B', '缺：会议预算/决算/相关材料', 2, 0, 279822, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C8268662FA1F979E050007F01001858', '7045B38ED0AB47B991536307BE68EA0B', '发票日期与会议日期不一致', 3, 0, 279823, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C8269408D78BB4FE050007F01001860', '7045B38ED0AB47B991536307BE68EA0B', '缺：会议议程、成果、出席人员名单', 4, 0, 279824, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C8269408D79BB4FE050007F01001860', '9E3AF30038A7481DAEABC4E7428E22AD', '缺项目负责人/报销人签字', 5, 0, 279825, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C826B51E2A5E2F7E050007F0100187B', '9E3AF30038A7481DAEABC4E7428E22AD', '缺：版面录取通知/培训通知/会议通知', 6, 0, 279828, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C826BC41B2E04AFE050007F0100188B', '9E3AF30038A7481DAEABC4E7428E22AD', '相关合同或协议不规范', 7, 0, 279829, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C826C4DBC797636E050007F0100188D', '9E3AF30038A7481DAEABC4E7428E22AD', '出租车发票连号', 8, 0, 279830, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C826CAA3EAF4A47E050007F0100188F', '9E3AF30038A7481DAEABC4E7428E22AD', '发票内容超项目报销预算范围', 9, 0, 279831, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('5C826CAA3EB04A47E050007F0100188F', '9E3AF30038A7481DAEABC4E7428E22AD', '缺审批表:1、设备 2、家具 3、工程', 10, 0, 279832, 'techRb');
INSERT INTO `sa_approval_rejected_reason` VALUES ('FC461F50785C4B1BA394A61530CE9C79', '50', '缺：会议预算/决算/相关材料', NULL, 0, 267348, NULL);

-- ----------------------------
-- Table structure for sa_attachment
-- ----------------------------
DROP TABLE IF EXISTS `sa_attachment`;
CREATE TABLE `sa_attachment`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `BIZ_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务类别ID',
  `BIZ_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
  `BIZ_SUB_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务子类别ID',
  `PATH` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '路径',
  `FILE_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '文件名称',
  `FILE_SIZE` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件大小',
  `FILE_KIND` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件类别',
  `CREATED_BY_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `CREATED_BY_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CLEAR_CACHE` bigint(20) NULL DEFAULT NULL COMMENT '清楚缓存',
  `UPLOAD_KIND` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上传类型',
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '状态',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT '排序号',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_attachmentconfig
-- ----------------------------
DROP TABLE IF EXISTS `sa_attachmentconfig`;
CREATE TABLE `sa_attachmentconfig`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ALLOW_DELETE` int(11) NULL DEFAULT NULL,
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_attachmentconfigdetail
-- ----------------------------
DROP TABLE IF EXISTS `sa_attachmentconfigdetail`;
CREATE TABLE `sa_attachmentconfigdetail`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ATTACHMENTCONFIG_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ALLOW_MULTIPLE` int(11) NULL DEFAULT NULL,
  `FILE_KIND` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `COL_SPAN` int(11) NULL DEFAULT NULL,
  `IS_REQUIRED` int(11) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_bizclassification
-- ----------------------------
DROP TABLE IF EXISTS `sa_bizclassification`;
CREATE TABLE `sa_bizclassification`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
  `NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `PARENT_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
  `FULL_ID` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '全路径ID',
  `FULL_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '全路径',
  `DESCRIPTION` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT '排序号',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务分类配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_bizclassificationdetail
-- ----------------------------
DROP TABLE IF EXISTS `sa_bizclassificationdetail`;
CREATE TABLE `sa_bizclassificationdetail`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `BIZ_CLASSIFICATION_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务属性配置ID',
  `BIZ_TYPE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务参数;业务数据',
  `BIZ_PROPERTY_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务属性ID',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT '排序号',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `ENTITY_CLASS_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '对应实体资源类名',
  `BIZ_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务名称',
  `DIALOG_WIDTH` bigint(20) NULL DEFAULT NULL COMMENT '对话框宽度',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '业务分类配置明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_codebuildrule
-- ----------------------------
DROP TABLE IF EXISTS `sa_codebuildrule`;
CREATE TABLE `sa_codebuildrule`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RULE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `CURRENT_VALUE` bigint(20) NULL DEFAULT NULL,
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `LAST_MODIFIED_DATE` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_commonhandler
-- ----------------------------
DROP TABLE IF EXISTS `sa_commonhandler`;
CREATE TABLE `sa_commonhandler`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `BIZ_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务ID',
  `KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'receiver 接收人 feedbacker 反馈人 feedbackViewer 反馈查看人',
  `ORG_UNIT_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构ID',
  `ORG_UNIT_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '组织单元名称',
  `ORG_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织单元类别',
  `FULL_ID` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT '序号',
  `GROUP_ID` int(11) NULL DEFAULT NULL COMMENT '分组ID',
  `SUB_PROC_UNIT_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '环节描述',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '通用处理人设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_commontree
-- ----------------------------
DROP TABLE IF EXISTS `sa_commontree`;
CREATE TABLE `sa_commontree`  (
  `KIND_ID` int(11) NULL DEFAULT NULL,
  `CODE` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
  `SHORT_CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '简码',
  `NODE_KIND_ID` varchar(6) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'floder文件夹 2 left',
  `NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称',
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `SEQUENCE` bigint(20) NULL DEFAULT NULL COMMENT '排序号',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `STATUS` int(11) NULL DEFAULT NULL,
  `FULL_ID` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ID全路径',
  `FULL_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '名称全路径',
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ID',
  `PARENT_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父节点ID'
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '通用树' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_commontree
-- ----------------------------
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '57919862B53C48CEB9EF00A3DFCA0667', '92208DB64565346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4C6B885215A647B3B5763AE00561151A', '5B1A2386CCD9ECF9E050007F01003D30');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8A7A60C3891D45B6A228E502430F4F9C', '5EEB2DC861694A65933CB4CE9A8D870A');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CE61637F2E81416BB9FA0BBFB12B2E81', '100661');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CD617D0E91D34893B803FC6F548D92F9', '5E17123168A376FFE050007F01006612');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8DD02C178E62467D99B9DBAAA175A836', '92208DB644EF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7E9EF881011848C6AC3C0716CEB9B5F5', '92208DB644F0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ECEA86907E6C460493A34B2D09D353C6', '92208DB644F1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F236BC031E7F493BA30F7B7D2F7778F0', '92208DB644F2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0D6136063A62429B9CB726DAEB0661DA', '92208DB644F3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '66A2D9745C3D4C4AACB26030F5C08CF4', '92208DB644F4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '035FE2EE98624DF89C84249DB1E19BD1', '92208DB644F5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2A278EC9BF504ADF942252F9EFE227E6', '92208DB644F6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3769EA4E6A8F41EB97CB88334340A20B', '92208DB644F7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E16762F90A2D443C8564CD0FF0F09C53', '92208DB644F8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7B437699173F4191BB9BB510CFD96ECC', '92208DB644F9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5C6123CAE43A4A8680CC811CF6638F1F', '92208DB644FA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C860ED9CA4494B1BAFAA3384368860C8', '92208DB644FB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '65B7C822171945DAA9868A0FCDA16623', '92208DB644FC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7E3EC6E6673C4C4CBE36467978752D5A', '92208DB644FD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0A3B204EC12A4D61882287B63634B122', '92208DB644FE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C2BF9A636F834BE998B1D90422FC1D55', '92208DB644FF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AAEBF6D4E88849D08BFCE18CF0F7EF88', '92208DB64500346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BC31C26721FE4C3E8F0FE8212AC6A402', '92208DB64501346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AB83DE5D4C1F4F119839510151A723A0', '92208DB64502346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9BA3C7BCF668461FBE7567A74EB65574', '92208DB64503346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1D4B48A8B5284FECBD0529D9EFD08892', '92208DB64504346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '06153C58721C44828DCCA879F57E1F4A', '92208DB64505346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '74AEC97D80D949C6AF54996050D7B758', '92208DB64506346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C33CBCA0E8AE41D49F27AC534454157E', '92208DB64507346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CE7CC5AA2FA7437D8DD6F380BE41E552', '92208DB64508346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6FA7BA6E2A484674B98B5546D5004CD8', '92208DB64509346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5E8141669C59488DB246C84D883BC960', '92208DB6450A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B8030DC614334A128134AF903EFF3773', '92208DB6450B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BEFC09D701464F2F90F4F662DD84BD5A', '92208DB6450C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '98CD962CAD714BE5935B520B03365F6C', '92208DB6450D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '44B2AC430E7E4BC08DCFDEE6361E71E6', '92208DB6450E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2E050D9617654F75A84E63F8C5E55C5B', '92208DB6450F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4B1AC228BAF949C196DA22251E7F2D6B', '92208DB64510346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7FDFCDB1515B4EB8B717D8EB0C88ACD5', '92208DB64511346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B6E89CC04BCC43F18F529D0C9203DAA4', '92208DB64512346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6A1266E86EEB4DC3955309AC268C8471', '92208DB64513346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '296451E68B1F41138742D4BB397E6A5F', '92208DB64514346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '061E026A15674F6C96BB99E8D502BC04', '92208DB64515346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '017B869344164FCE9E4289993F6BDBDA', '92208DB64516346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '16AF3E197A734018BF999C8E35E64278', '92208DB64517346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A3BE9C467ED740B5B6B9388614E34255', '92208DB64518346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D9117E83C86447A990311720DE756251', '92208DB64519346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E0EFEE50152144F3AA8D05AB1D3048DE', '92208DB6451A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '458E814D2F2F4E5A97C21CF5B02A4D59', '92208DB6451B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7B727E8F4BDA427B8F73A79199AE2CF4', '92208DB6451C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8A0B4F91607948E1A2E05850DF3E2BEB', '92208DB6451D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2E216C753F7B43E98F1441E5B563FF71', '92208DB6451E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A9346BE050007F010012C2', '/报告树', '92208DB646A9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646AA346BE050007F010012C2', '/报告树', '92208DB646AA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646AB346BE050007F010012C2', '/报告树', '92208DB646AB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646AC346BE050007F010012C2', '/报告树', '92208DB646AC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646AD346BE050007F010012C2', '/报告树', '92208DB646AD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/73F7E37330834BA5A9D30CCC2D4DCF0A', '/报告树', '73F7E37330834BA5A9D30CCC2D4DCF0A', NULL);
INSERT INTO `sa_commontree` VALUES (62, '2019', NULL, 'FOLDER', '2018', '76767', 1, 3577465, 1, '/2DF134EB2AF84F07870E74D36EC7C362/A8EFC5FB82D1430896B452D0453729CC', '/我的报告/2018', 'A8EFC5FB82D1430896B452D0453729CC', '2DF134EB2AF84F07870E74D36EC7C362');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C5339D4FA9554E1A9F3B5C50D6367F79', '92208DB6451F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5A3E3D06A2FC4D35B4ECA3C8101DDFD7', '92208DB64520346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '584C40E9F68E453DBEAA64DAD9F72639', '92208DB64521346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1A122446F3E147EB81E3ADB0A5E342FD', '92208DB64522346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FB775EB38FD04C1A8E603201B554302C', '92208DB64523346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '18AB8A2F83BA40398C988A3292F3B521', '92208DB64524346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EBA050CB0866402F868A57B5F285CC9A', '92208DB64525346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7E19756564184C1396929399237D4A34', '92208DB64526346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D37E79D5A6D546608DEADADFB2B3245C', '92208DB64527346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '119F3629968C409CB206BFBEB0D820ED', '92208DB64528346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7CF24085B43040878C4B7A017F8CF683', '92208DB64529346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '13E9B5BB27A1416E8A2D8147296ADCC9', '92208DB6452A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3AF82D8C9C404C93911F15528C99B2EE', '92208DB6452B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7164F1C34F6940AE93859A8A1833C878', '92208DB6452C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C2DA3CF00D8A49F7BD03957E086ABA80', '92208DB6452D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D1D72A7EDA83408FBCB179C663A7E7FC', '92208DB6452E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F581BF5826B44029ACD4058034F536DE', '92208DB6452F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F8300DE09FDD4026BE9BC962C14FBBDF', '92208DB64530346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DC0F150CDBF942CBBD25FE904CCBFAB4', '92208DB64531346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D9AA23BBAB834E368960CDEF5C5307F2', '92208DB64532346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '23CC594B252C46F8B6861DA679D9DEA9', '92208DB64533346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '34F1C703527E4FFBB86D5297740AD9EC', '92208DB64534346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7399D8A7DF184B8F88860300AEF1ED98', '92208DB64535346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D2435D5EA701442AA942AFB33BA8067B', '92208DB64536346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '04496C052EFE438AA2B884EB472BC854', '92208DB64537346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7E0C8253E5BB4AEB825F70159C9B0A48', '92208DB64538346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E5A7A3A248F84F0496BCDFB25C3C9AB5', '92208DB64539346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4263A21B7F5A415A9B17B3E7BE89B0C5', '92208DB6453A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6C815786698E400FAD0CBD26162B3F45', '92208DB6453B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4B50FB725898474684D00C732DFB1E97', '92208DB6453C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2421D5AA4F6A4078BAF956F3B9C47691', '92208DB6453D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AA60FD75B9064EA38A5768B6F7C75C01', '92208DB6453E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0183D954C7E64E9AAEEC191D732AA13C', '92208DB6453F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C7BCDCE517D645C7A37DD321E26FBCD1', '92208DB64540346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7C9CF5E045284F34BA8AC76694C256F2', '92208DB64541346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3979B6D02D3142EEA00E4BDBB93F6191', '92208DB64542346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4A3C770B8FA6462489BD27BD0B370902', '92208DB64543346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B20804B1FA7C42079A3F80CA98CABF83', '92208DB64544346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F418574DBD044D9984BD3D37875CF7B4', '92208DB644D0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BA9DAFC6E91F45BEA2BBD8F57BB2B153', '92208DB644D1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DC193D89337F49DD960E344148785C6C', '92208DB644D2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E8DC5C2359A7448D9BFBD802A8EB7AE4', '92208DB644D3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C808669DF0234EFE83617E2F83E892BB', '92208DB644D4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0CB8F2CF7D914D32B20CDDF880B762AD', '92208DB644D5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '97D74F5A245C4132AB53C43587486AAA', '92208DB644D6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3AEF5FBD868C4C0990C95C38F9406107', '92208DB644D7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EEDEBC7D4B8C4EFAA42C9C8123D29476', '92208DB644D8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8C645D23B161435CA6DAE08A6F898C79', '92208DB644D9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '040C5C27204E421DB1D38E3C3AFF45FD', '92208DB644DA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9C85DC9691B74FFBBBD9BF9E90122A7A', '92208DB644DB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4012C40CDA12422998937CAE6D977844', '92208DB644DC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '758634F4E722466E88718268F1F73895', '92208DB644DD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CFB1A6FF268E404F81318A30321C83F6', '92208DB644DE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F0973D56CD374830B0A73EE44AB1F543', '92208DB644DF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E74C0C87C91F4618AC2EE041550EE857', '92208DB644E0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BDF638A657D74E4DB8B5BC832E81BD2A', '92208DB644E1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '14D5F62B830F43F08EFED3CE54402777', '92208DB644E2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2E366CD3CD9A4D3397C36B3E8D215A8C', '92208DB644E3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '92F1BC3D05344EB4B0EC38CAFD7DF2AB', '92208DB644E4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '71052972FF04446DB5434814140B2A02', '92208DB644E5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '34574B8A49C54AB5B4C4C8A48389FF7F', '92208DB644E6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2D7D497F91F3477F9A554B1C16529608', '92208DB644E7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '74571E9B072C4C43A5BEE9FA89E8C29A', '92208DB644E8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8A46196898F7486FB105B7357C4796D9', '92208DB644E9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2B5A3BF4B3FF4766897A5D87B6DDCA2A', '92208DB644EA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5AEC7C8D66B84A0E8EB8384FE4046A97', '92208DB644EB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '864B5FC232004E49B395EB92C16539A2', '92208DB644EC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '440838AFF0044E13856D9CB7B4CD771F', '92208DB644ED346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7314D289D0F34C54BDE305202AF71C04', '92208DB644EE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1C89D0576A33497E97ABBA9F1F866E53', '92208DB64548346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0FB4938A03E04C87BBE0CCEE81C12D87', '92208DB64549346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '384E764F9B6E4AA886613B20F1856A21', '92208DB6454A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C13F1EE908284D9BBAC7C1072A18265F', '92208DB6454B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '24CAE6D951524CACA34FA780ABAF50AF', '92208DB6454C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DB9036C7D0CA4AE5A48A6214FFFD66AC', '92208DB6454D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3376023913DE43F3B10CD0459AF63CA7', '92208DB6454E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8786D437657241988D90A5FBE3F24E00', '92208DB6454F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '28F5A796559748498186815241730920', '92208DB64550346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '91812066C3394BC89F919C5FFA943582', '92208DB64551346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2F0EF5C4BA364B76BE8422B530BD9D93', '92208DB64552346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '652875C18D7D46FC85E102D68212D2D9', '92208DB64553346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2C4FE741C7A447879534C05B0CD6EFF7', '92208DB64554346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '68971252939B4FCE94C766C2B553A825', '92208DB64555346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '853FF81CDCCB492E940ED07947493D0D', '92208DB64556346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9F5E398A11BE44479DF80EC57887C01E', '92208DB64557346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '92C0E6F9E48D40859700F162C60016BC', '92208DB64558346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '34511C1184F542BEB5D4E87FA8D05931', '92208DB64559346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CCAFB9349C4343C0A18FC1EBD39F94A7', '92208DB6455A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BD785D1D3A224B6BA9A6544604722125', '92208DB6455B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B07BEC8A5663484EB4835F6295CA972D', '92208DB6455C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '220F9BF4841341CEBF88313CE15C1888', '92208DB6455D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ED40D0A1E48D459B9657E93BFDCFF993', '92208DB6455E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F3D1FF58CCE448F99EEFAFED55688AD3', '92208DB6455F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1FBEBC23E8C14F9FAEC60B3B43B497E5', '92208DB64560346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F4792D6F37454FE090213897697EBA4A', '92208DB64561346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '182F32884E634986A09BBAFF35A66B4A', '92208DB64562346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '30C8972483C7437F988771EE8B6957CB', '92208DB64563346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A1E3AF194AB94915830CB5DB078D989C', '92208DB64564346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2A7E69F41DEC44569014E8B2931CCFD3', '92208DB6465A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C62E35861FB74ACB84544A1BF7A79D8F', '92208DB6465B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6F26A818D3D24D91B70B28EA71DFF9C0', '92208DB6465C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CD20841460B84A0B9383A861989F7E30', '92208DB6465D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '84F1492355D54A499A1D3C3552C06D9B', '92208DB645E3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5FA632C996EB4AB39F423B0B3D19AC66', '92208DB645E4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6678CD9895E54041A6588AAF78ED0A13', '92208DB645E5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0F310DBA630C4EA3829A95EEE46AC629', '92208DB645E6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EB10289AFD2444FB9621519150860307', '92208DB645E7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7A432F84112E492BA77F239FCCBB0CF2', '92208DB645E8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D7A41DAF67C4452498B9D7D30E6EF3AE', '92208DB645E9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '071A4F405D0849B4BC541C3BBA90BA26', '92208DB645EA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2C3B0F91A51649BD81AF81543A721FB0', '92208DB645EB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1340D9CBF47A4A0EA8388558855A13BF', '92208DB645EC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4D5A725CF69248B4B1DF300F899ECBA9', '92208DB645ED346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '14BCEC6D72DA474BA6F2E9CB7C7AC8CE', '92208DB645EE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (1, '组织类型', NULL, 'FOLDER', '组织类型', NULL, 1, 104426, 1, '/1', '/组织类型', '1', '0');
INSERT INTO `sa_commontree` VALUES (1, 'CDHG', NULL, 'FOLDER', '系统默认', NULL, 2, 282373, 1, '/1/49530B56651A484196B80818734A49F6', '/组织类型/系统默认', '49530B56651A484196B80818734A49F6', '1');
INSERT INTO `sa_commontree` VALUES (2, '01', NULL, 'FOLDER', '系统默认', NULL, 1, 3551256, 1, '/2/181', '/部门类型/系统默认', '181', '2');
INSERT INTO `sa_commontree` VALUES (2, '部门类型', NULL, 'FOLDER', '部门类型', NULL, 1, 3551257, 1, '/2', '/部门类型', '2', '0');
INSERT INTO `sa_commontree` VALUES (3, '01', NULL, 'FOLDER', '系统默认', NULL, 1, 24482, 1, '/3/189', '/岗位类型/系统默认', '189', '3');
INSERT INTO `sa_commontree` VALUES (3, '岗位类型', NULL, 'FOLDER', '岗位类型', NULL, 1, 79214, 1, '/3', '/岗位类型', '3', '0');
INSERT INTO `sa_commontree` VALUES (4, 'system', NULL, 'FOLDER', '系统角色', NULL, 2, 6138, 1, '/4/286', '/角色树/系统角色', '286', '4');
INSERT INTO `sa_commontree` VALUES (4, 'JSS', NULL, 'FOLDER', '角色树', NULL, 1, 84172, 1, '/4', '/角色树', '4', '0');
INSERT INTO `sa_commontree` VALUES (5, 'flexfielddefinition', NULL, 'FOLDER', '扩展字段定义', NULL, 1, 98810, 1, '/5', '/扩展字段定义', '5', '0');
INSERT INTO `sa_commontree` VALUES (5, 'system', NULL, 'FOLDER', '系统', NULL, 1, 148148, 1, '/5/6603F93BCD3244BD8B6E5CBE0AC3AAE4', '/扩展字段定义/系统', '6603F93BCD3244BD8B6E5CBE0AC3AAE4', '5');
INSERT INTO `sa_commontree` VALUES (6, 'flexfieldgroup', NULL, 'FOLDER', '扩展字段分组', NULL, 1, 98268, 1, '/6', '/扩展字段分组', '6', '0');
INSERT INTO `sa_commontree` VALUES (7, '系统参数', NULL, 'FOLDER', '系统参数', NULL, 2, 104442, 1, '/7', '/系统参数', '7', '0');
INSERT INTO `sa_commontree` VALUES (7, 'organConst', NULL, 'FOLDER', '机构常量', 'a', 1, 129721, 1, '/7/424955/424959', '/系统参数/组织权限常量/机构常量', '424959', '424955');
INSERT INTO `sa_commontree` VALUES (7, 'OPMConst', NULL, 'FOLDER', '组织权限常量', NULL, 8, 129723, 1, '/7/424955', '/系统参数/组织权限常量', '424955', '7');
INSERT INTO `sa_commontree` VALUES (7, '01', NULL, 'FOLDER', '系统参数', NULL, 6, 133392, 1, '/7/1320', '/系统参数/系统参数', '1320', '7');
INSERT INTO `sa_commontree` VALUES (7, '界面参数', NULL, 'FOLDER', '界面参数', NULL, 1, 262749, 1, '/7/1320/7C9A74E0F19A4C5FB89746E80F788A6D', '/系统参数/系统参数/界面参数', '7C9A74E0F19A4C5FB89746E80F788A6D', '1320');
INSERT INTO `sa_commontree` VALUES (7, '工作流', NULL, 'FOLDER', '工作流', NULL, 9, 338201, 1, '/7/AD048D2BF97D4AD5896892A4422D98F3', '/系统参数/工作流', 'AD048D2BF97D4AD5896892A4422D98F3', '7');
INSERT INTO `sa_commontree` VALUES (7, 'posCost', NULL, 'FOLDER', '岗位常量', NULL, 4, NULL, 1, '/7/424955/424962', '/系统参数/组织权限常量/岗位常量', '424962', '424955');
INSERT INTO `sa_commontree` VALUES (7, 'deptConst', NULL, 'FOLDER', '部门常量', NULL, 3, NULL, 1, '/7/424955/424961', '/系统参数/组织权限常量/部门常量', '424961', '424955');
INSERT INTO `sa_commontree` VALUES (7, 'mangeType', NULL, 'FOLDER', '管理权限', NULL, 9, NULL, 1, '/7/424955/425521', '/系统参数/组织权限常量/管理权限', '425521', '424955');
INSERT INTO `sa_commontree` VALUES (8, '01', NULL, 'FOLDER', '编码类别', NULL, 1, NULL, 1, '/8', '/编码类别', '8', '0');
INSERT INTO `sa_commontree` VALUES (9, '01', NULL, 'FOLDER', '系统管理', NULL, 1, 25171, 1, '/9/1395', '/数据字典/系统管理', '1395', '9');
INSERT INTO `sa_commontree` VALUES (9, '01', NULL, 'FOLDER', '数据字典', NULL, 9, 104308, 1, '/9', '/数据字典', '9', '0');
INSERT INTO `sa_commontree` VALUES (10, 'root', NULL, 'FOLDER', '导入模板根节点', NULL, NULL, 103888, NULL, NULL, '/导入模板根节点', '20161202', '0');
INSERT INTO `sa_commontree` VALUES (15, 'remind', NULL, 'FOLDER', '消息提醒', NULL, 1, 105035, 1, '/15', '/消息提醒', '15', '0');
INSERT INTO `sa_commontree` VALUES (16, '01', NULL, 'FOLDER', '字段分类', NULL, 16, 1, 1, '/16', '/字段分类', '16', '0');
INSERT INTO `sa_commontree` VALUES (17, 'system', NULL, 'FOLDER', '系统', '系统', 3, 27951, 1, '/17/34DAC78038EE466F9595A73B001A8CF8', '/基础管理权限/系统', '34DAC78038EE466F9595A73B001A8CF8', '17');
INSERT INTO `sa_commontree` VALUES (17, '01', NULL, 'FOLDER', '基础管理权限', NULL, 1, 27952, 1, '/17', '/基础管理权限', '17', '0');
INSERT INTO `sa_commontree` VALUES (18, '01', NULL, 'FOLDER', '业务管理权限', NULL, 1, 1, 1, '/18', '/业务管理权限', '18', '0');
INSERT INTO `sa_commontree` VALUES (18, 'pmBaseManage', NULL, 'FOLDER', '基础管理', NULL, 2, 1290163, 1, '/18/1272445/1290162', '/业务管理权限/物业/基础管理', '1290162', '1272445');
INSERT INTO `sa_commontree` VALUES (18, '01', NULL, 'FOLDER', '系统', NULL, 1, NULL, 1, '/18/896255', '/业务管理权限/系统', '896255', '18');
INSERT INTO `sa_commontree` VALUES (21, '01', NULL, 'FOLDER', '附件配置', NULL, 1, 1, 1, '/21', '/附件配置', '21', '0');
INSERT INTO `sa_commontree` VALUES (25, 'userGroup', NULL, 'FOLDER', '用户分组', NULL, 1, 115112, 1, '/2001', '/用户分组', '2001', '0');
INSERT INTO `sa_commontree` VALUES (50, 'approvalRejectedReason', NULL, 'FOLDER', '网上报销', NULL, 1, 50, 1, '/50', '/网上报销', '50', 'techRb');
INSERT INTO `sa_commontree` VALUES (50, '主办及承办会议报销', NULL, 'FOLDER', '主办及承办会议报销', NULL, 1, 267344, 1, '/50/4C1CCFE31BD341C4B0BBA53F09C757C2/7045B38ED0AB47B991536307BE68EA0B', '/网上报销/主办及承办会议报销', '7045B38ED0AB47B991536307BE68EA0B', '50');
INSERT INTO `sa_commontree` VALUES (50, '报销单', NULL, 'FOLDER', '发票及附件', NULL, 2, 286881, 1, '/50/9E3AF30038A7481DAEABC4E7428E22AD', '/网上报销/发票及附件', '9E3AF30038A7481DAEABC4E7428E22AD', '50');
INSERT INTO `sa_commontree` VALUES (61, '董事会', NULL, 'FOLDER', '董事会', NULL, 1, 3575142, 1, '/90AC8A318DE2BC95E050007F01003009/92E3D806C0231A71E050007F0100761E/92E3D8A3981158A3E050007F01007631', '/中航国际/中航国际总部/董事会', '92E3D8A3981158A3E050007F01007631', '92E3D806C0231A71E050007F0100761E');
INSERT INTO `sa_commontree` VALUES (60, '信息收集类别', NULL, 'FOLDER', '信息收集类别', NULL, 1, 319443, 1, '/5EF486A1B554196AE050007F01001ED3', '/信息收集类别', '5EF486A1B554196AE050007F01001ED3', '0');
INSERT INTO `sa_commontree` VALUES (55, 'i18nProperties', NULL, 'FOLDER', '国际化资源分类', NULL, 1, 55, 1, '/55', '/国际化资源分类', '55', '0');
INSERT INTO `sa_commontree` VALUES (55, '系统参数', NULL, 'FOLDER', '系统参数', NULL, 1, 270772, 1, '/55/31D05A903AB9462CAD701B4F92D899C2', '/国际化资源分类/系统参数', '31D05A903AB9462CAD701B4F92D899C2', '55');
INSERT INTO `sa_commontree` VALUES (55, '系统字典', NULL, 'FOLDER', '系统字典', NULL, 2, 270774, 1, '/55/7D63574CB124454F92AF30F6EE368240', '/国际化资源分类/系统字典', '7D63574CB124454F92AF30F6EE368240', '55');
INSERT INTO `sa_commontree` VALUES (55, '功能菜单', NULL, 'FOLDER', '功能菜单', NULL, 4, 270776, 1, '/55/78D047EC4A044AFEA1A1DBC4792A2C91', '/国际化资源分类/功能菜单', '78D047EC4A044AFEA1A1DBC4792A2C91', '55');
INSERT INTO `sa_commontree` VALUES (55, '审批环节名', NULL, 'FOLDER', '审批环节名', NULL, 5, 270778, 1, '/55/F90540F6C2224D2E9E4BEF6ACAB40A29', '/国际化资源分类/审批环节名', 'F90540F6C2224D2E9E4BEF6ACAB40A29', '55');
INSERT INTO `sa_commontree` VALUES (55, '附件配置', NULL, 'FOLDER', '附件配置', NULL, 3, 270780, 1, '/55/9A8C89F070FB4B55BDDA40E3B66D2835', '/国际化资源分类/附件配置', '9A8C89F070FB4B55BDDA40E3B66D2835', '55');
INSERT INTO `sa_commontree` VALUES (22, 'root', NULL, 'FOLDER', '专家组', NULL, 1, 1, 1, '/1', '/专家组', '22', '0');
INSERT INTO `sa_commontree` VALUES (22, '生命科学', NULL, 'FOLDER', '生命科学', '生命科学专家组', 1, 342456, 1, '/1/7881D4BC138940628F342042E360BB11', '/专家组/生命科学', '7881D4BC138940628F342042E360BB11', '22');
INSERT INTO `sa_commontree` VALUES (22, '物质科学', NULL, 'FOLDER', '物质科学', '物质科学专家组', 2, 342462, 1, '/1/0266228AE05242E28485509C1710BCEC', '/专家组/物质科学', '0266228AE05242E28485509C1710BCEC', '22');
INSERT INTO `sa_commontree` VALUES (22, '活细胞', NULL, 'FOLDER', '活细胞', '活细胞', 1, 356275, 1, '/1/7881D4BC138940628F342042E360BB11/4DB3702E2DA24C31B3FC8D06CDBDF712', '/专家组/生命科学/活细胞', '4DB3702E2DA24C31B3FC8D06CDBDF712', '7881D4BC138940628F342042E360BB11');
INSERT INTO `sa_commontree` VALUES (22, '生物学', NULL, 'FOLDER', '生物学', '生物学', 2, 362187, 1, '/1/7881D4BC138940628F342042E360BB11/6AB14F2E02A141FB8ACEB6F22A03659B', '/专家组/生命科学/生物学', '6AB14F2E02A141FB8ACEB6F22A03659B', '7881D4BC138940628F342042E360BB11');
INSERT INTO `sa_commontree` VALUES (16, 'buttonJurisdiction', NULL, 'FOLDER', '按钮权限', '按钮权限buttonJurisdiction', 1, 851631, 1, '/16/671DFBC586B14E90E050007F01002A58', '/字段分类/按钮权限', '671DFBC586B14E90E050007F01002A58', '16');
INSERT INTO `sa_commontree` VALUES (61, '规划发展部', NULL, 'FOLDER', '规划发展部', NULL, 2, 3565552, 1, '/90AC8A318DE2BC95E050007F01003009/90B0FA956430A575E050007F0100433C', '/中航国际/规划发展部', '90B0FA956430A575E050007F0100433C', '90AC8A318DE2BC95E050007F01003009');
INSERT INTO `sa_commontree` VALUES (61, '中航国际', NULL, 'FOLDER', '中航国际', NULL, 1, 3551693, 1, '/90AC8A318DE2BC95E050007F01003009', '/中航国际', '90AC8A318DE2BC95E050007F01003009', '0');
INSERT INTO `sa_commontree` VALUES (61, '中航国际总部', NULL, 'FOLDER', '中航国际总部', NULL, 4, 3575136, 1, '/90AC8A318DE2BC95E050007F01003009/92E3D806C0231A71E050007F0100761E', '/中航国际/中航国际总部', '92E3D806C0231A71E050007F0100761E', '90AC8A318DE2BC95E050007F01003009');
INSERT INTO `sa_commontree` VALUES (10, '系统数据', NULL, 'FOLDER', '系统数据', NULL, 3, 1313936, 1, '/6B480BBA27C2FF74E050007F010057E3', '/导入模板根节点/系统数据', '6B480BBA27C2FF74E050007F010057E3', '20161202');
INSERT INTO `sa_commontree` VALUES (61, '经营管理部', NULL, 'FOLDER', '经营管理部', NULL, 3, 3565653, 1, '/90AC8A318DE2BC95E050007F01003009/90B0A8F9B0D9A3DFE050007F010033CE', '/中航国际/经营管理部', '90B0A8F9B0D9A3DFE050007F010033CE', '90AC8A318DE2BC95E050007F01003009');
INSERT INTO `sa_commontree` VALUES (7, '在线报告制作', NULL, 'FOLDER', '在线报告制作', NULL, 10, 3578388, 1, '/7/93339221A47E0B62E050007F01005AAE', '/系统参数/在线报告制作', '93339221A47E0B62E050007F01005AAE', '7');
INSERT INTO `sa_commontree` VALUES (62, '我的报告', NULL, 'FOLDER', '我的报告', NULL, 1, 3577054, 1, '/8E9F7EE19C0E41EB9F7EFF560E8DD6FD', '/我的报告', '8E9F7EE19C0E41EB9F7EFF560E8DD6FD', '0');
INSERT INTO `sa_commontree` VALUES (62, '2019', NULL, 'FOLDER', '2019', '测试', 1, 3577233, 1, '/8E9F7EE19C0E41EB9F7EFF560E8DD6FD/1465E0C6EAA04D58BDD9C8E8601BBB48', '/我的报告/2019', '1465E0C6EAA04D58BDD9C8E8601BBB48', '8E9F7EE19C0E41EB9F7EFF560E8DD6FD');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1BD05F22C0B54790863EB1AAD6C2C958', '92208DB64578346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '494B9AAE409A4F64A3E7B6283334AA1D', '92208DB64579346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2AF6FDED6DD94AF894CD65C3D7868F6F', '92208DB6457A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E7C6F9E4E9F049728D61C87173CFFAFC', '92208DB6457B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DE6191A1585049C792096B5756609246', '92208DB6457C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CE2FB911759B4D2989C8B97092B73DE1', '92208DB6457D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ECA62886F9C84369AA184F5690D2A341', '92208DB6457E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E5B2918C1E2B4047BC785B1F5C0FBEA0', '92208DB6457F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9372F682D3074BF3B921B27CF76D531F', '92208DB64580346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '92A7FD4DDFD14578B16EC0BCD10C1CF0', '92208DB64581346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A40679C8EDB84002B7AF5F82B033C44E', '92208DB64582346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FA2667144ABC443FA2F997F6E78EF1C4', '92208DB64583346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '23637461BE214C60941A8A5E0BC0B5F1', '92208DB64584346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E065DAB4609B47629398ADCC74F25AF6', '92208DB645EF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '985A7D955DC5441195AFE4F5E8076B7A', '92208DB645F0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E52EA1FD260C44DABC2F2E450ADD7AA4', '92208DB645F1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6876318589FC4BDEB2A1479C21DBA1DE', '92208DB645F2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E835037E9D5F4C1DB44F406B374B0A36', '92208DB645F3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D97C5BCB67D941D183FC39EEC8343DCA', '92208DB645F4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C44890F91BA046389205D9D45B444846', '92208DB645F5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F346769C25AD4A4DA25FBF274B78FA60', '92208DB645F6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EBD5D00F941249038CDD65B0A3B816F5', '92208DB645F7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '682F4036F6FA463AA64AA4A277AAEF07', '92208DB645F8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AE35E874BCA04A7E84D3C0D483260A88', '92208DB645F9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0C676F47F7A84225943034C92D5E38D6', '92208DB645FA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0447F186A61D4D829FD034818D977601', '92208DB645FB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '68ABB720FBCB43259E07CAFD646FE290', '92208DB645FC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '664B6549A2DF424998BFBB5EEAAFA930', '92208DB645FD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F8942382C35945A28ED93E7F47CF1903', '92208DB645FE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1EE388A8F5C2420295D1FD04073C883F', '92208DB645FF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6AE3A8401C1F48D795A3A2B5D210C8EB', '92208DB64600346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3C3800D894F748E88F6D5623337B59D6', '92208DB64601346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1C52C16CD5C14C3BAB03FDFF8B600731', '92208DB64566346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2177A9AF9F824561BAAF88116ADB11DA', '92208DB64567346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '00F0322DBCD046DCA065D0AACBD07A8F', '92208DB64568346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B03A411CDEE54F329EA764D1A2D1BD3D', '92208DB64569346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C05B4657FCB94FBF8FF5915EC47B8A89', '92208DB6456A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '79A2363A8D7440539F5478F458D1D9C5', '92208DB6456B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '11302AA1549A4EBD8B14288A7A64755E', '92208DB6456C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4C1162AD86374B29993793306A753BCE', '92208DB6456D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3711B11F70B2420D8FBC84602760F71F', '92208DB6456E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CB97EC2BC57C4A349A7ADA0301BC5CE0', '92208DB6456F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E8F3E7898FBB443DA4EF07A1D8B7E428', '92208DB64570346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B4B79DCB148444588CC089AFA4F87A52', '92208DB64571346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1F1E7269E0C04CE6BEE907EB926EE3AB', '92208DB64572346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E48E7FE155D142E88FDFF1E2049B27C1', '92208DB64573346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B718AD662C904E8FB29C5D6D690D0EAC', '92208DB64574346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C0EC4E9042584DF98D46E56DB356DAE8', '92208DB64575346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '26C1025A7025402CA8E44049A8ED755D', '92208DB64576346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '471A988289A84B46B614349C7E3C221F', '92208DB64577346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F10CCE5A62FA4BD9BA96EBD645C92D19', '92208DB64585346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E3F13E6E0EC443BAA13FE227617BC4A4', '92208DB64586346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '573F547208B4493FA92FE27F342BA18C', '92208DB64587346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '52773201F1054F12928A522C45CF7622', '92208DB64588346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FEFDE7B85FE14148833ED97F66FD2901', '92208DB64589346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '14F12A7673AF4364A15BBC2CD38392DE', '92208DB6458A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0BBA5940717B4931A17A993495C667AC', '92208DB6458B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D5F2482887A64B9E9E7AF91D345ED532', '92208DB6458C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A0E3E8CB94F441A0AC7D02FF047A48DA', '92208DB6458D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CF9883D9415B4BD0BABAB644F08E933D', '92208DB6458E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '16BCD6DFDC914D7D9D8B20F7D0E86A24', '92208DB6458F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5B1030A0204C46018002D6A93AF95A16', '92208DB64590346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A795BAE70035443E8CD61F5917DFF1FF', '92208DB64591346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AFEFAF9C499641E08363DA0065D95D38', '92208DB64592346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5E806CE391534787AED9AEADE8B96F38', '92208DB64593346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DFCF90A0E80C47A7AFB10AD0DE2A5395', '92208DB64594346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ABA0C254A2F6448FBA7BFD2F01E8DCD0', '92208DB64595346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2BD0DA6FF1054C2889BCB14BC3236C1A', '92208DB64596346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1032B1D446A54EC88099B8241A5ECE6D', '92208DB64597346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '247C6F5D2AFD4FC19C0515D9C9B7DA26', '92208DB64598346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '214FF636F5FA419B8EC8DE4442C07A81', '92208DB64599346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8FE416D64EDF446D85751220CCE31DCD', '92208DB6459A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2E6DF01174B74A7888FAC96DCF57E2DB', '92208DB6459B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C293923EE76B415895995E4E923CBA04', '92208DB6459C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A515FFBBC75A4C31B47353DF4588256B', '92208DB6459D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5DD82C0B77474B5294F3FC00ECDD7793', '92208DB6459E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '827803220B05412392F76917C673A3A9', '92208DB6459F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '398348FA00384D49A0B0F58E9BF4BC25', '92208DB645A0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '90B5ED7D1F7742EE975904AB8DA30370', '92208DB645A1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AE0E77737B0B49A8918847AA70E69139', '92208DB645A2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '45C084720D00492F825EAEDC98CD0ACA', '92208DB645A3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AEDF41BC412C470DB96E0819DF0D1432', '92208DB645A4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9809A9888916436CBBA07248D5DC44C4', '92208DB645A5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '09F92926A96E45BFAC2D443CCF0F30C2', '92208DB645A6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F2AEAC4E8B20425F87A14F101F6AA6AC', '92208DB645A7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C327798E700D460882634D91F9AA7EC3', '92208DB645A8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F2A3230833E0410BBD29362C9072F1FD', '92208DB645A9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3E2FC8F923484743B5D96E9A319A4209', '92208DB645AA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FEF97B75154141F9A5B199EF9B8E7B80', '92208DB645AB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5F7AA040153E4E94861371E6E8DC94A5', '92208DB645AC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '56603AD42D094635A6486ABBB7D4E189', '92208DB645AD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7A235541D5474B32AC4B2AB54101E3EF', '92208DB645AE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '665C5FC303764FEDAC2FAEAAE17BF980', '92208DB645AF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C1269519C10B4112BCB2D4583A40D189', '92208DB645B0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AA08FDC055304B4AA77D0A09BBD58904', '92208DB645B1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4772C33102D447EF891686C2EBAC74B7', '92208DB645B2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '86DEE9AFEACE4A8686AA9EE7E222234C', '92208DB645B3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EF99F1F0476249439A79D112A9FA179D', '92208DB645B4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '31FFA6957DA24CCAAEC4D0B09D30425D', '92208DB645B5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1ADD20C53AA84D44AF816032A6B375A4', '92208DB645B6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '10F71552AA3C418FA2E4505A46D4D0E5', '92208DB645B7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DD11A04BFE7C410182C9ED88A95D49D9', '92208DB645B8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1A9C1FB036634AE3A9A99B67E7B31354', '92208DB645B9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F1AA2A9DAD6F4AFCB8CCE7CE6CCE6E75', '92208DB645BA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3EF9BB3B4D8B48738F0E43F60B72605B', '92208DB645BB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '02B54C52BADA42228C1A14D3E757735F', '92208DB645BC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '84DDEA208645465DB5C7E505E5567CBD', '92208DB64545346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F7F915E7B2A4456F8419B3B9DEA7B3F1', '92208DB64546346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6D7A977CF75C4295BDEB39E8CB2D8CEB', '92208DB64547346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B923AD1503E94CFEB544E0938B80E9F1', '92208DB645C3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/5B1A2386CCD9ECF9E050007F01003D30', '/报告树', '5B1A2386CCD9ECF9E050007F01003D30', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/5EEB2DC861694A65933CB4CE9A8D870A', '/报告树', '5EEB2DC861694A65933CB4CE9A8D870A', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/100661', '/报告树', '100661', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/5E17123168A376FFE050007F01006612', '/报告树', '5E17123168A376FFE050007F01006612', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644EF346BE050007F010012C2', '/报告树', '92208DB644EF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F0346BE050007F010012C2', '/报告树', '92208DB644F0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F1346BE050007F010012C2', '/报告树', '92208DB644F1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F2346BE050007F010012C2', '/报告树', '92208DB644F2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F3346BE050007F010012C2', '/报告树', '92208DB644F3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F4346BE050007F010012C2', '/报告树', '92208DB644F4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F5346BE050007F010012C2', '/报告树', '92208DB644F5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F6346BE050007F010012C2', '/报告树', '92208DB644F6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F7346BE050007F010012C2', '/报告树', '92208DB644F7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F8346BE050007F010012C2', '/报告树', '92208DB644F8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644F9346BE050007F010012C2', '/报告树', '92208DB644F9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644FA346BE050007F010012C2', '/报告树', '92208DB644FA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644FB346BE050007F010012C2', '/报告树', '92208DB644FB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644FC346BE050007F010012C2', '/报告树', '92208DB644FC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644FD346BE050007F010012C2', '/报告树', '92208DB644FD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644FE346BE050007F010012C2', '/报告树', '92208DB644FE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644FF346BE050007F010012C2', '/报告树', '92208DB644FF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64500346BE050007F010012C2', '/报告树', '92208DB64500346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64501346BE050007F010012C2', '/报告树', '92208DB64501346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64502346BE050007F010012C2', '/报告树', '92208DB64502346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64503346BE050007F010012C2', '/报告树', '92208DB64503346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64504346BE050007F010012C2', '/报告树', '92208DB64504346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64505346BE050007F010012C2', '/报告树', '92208DB64505346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64506346BE050007F010012C2', '/报告树', '92208DB64506346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64507346BE050007F010012C2', '/报告树', '92208DB64507346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64508346BE050007F010012C2', '/报告树', '92208DB64508346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64509346BE050007F010012C2', '/报告树', '92208DB64509346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6450A346BE050007F010012C2', '/报告树', '92208DB6450A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6450B346BE050007F010012C2', '/报告树', '92208DB6450B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6450C346BE050007F010012C2', '/报告树', '92208DB6450C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6450D346BE050007F010012C2', '/报告树', '92208DB6450D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6450E346BE050007F010012C2', '/报告树', '92208DB6450E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6450F346BE050007F010012C2', '/报告树', '92208DB6450F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64510346BE050007F010012C2', '/报告树', '92208DB64510346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64565346BE050007F010012C2', '/报告树', '92208DB64565346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64511346BE050007F010012C2', '/报告树', '92208DB64511346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64512346BE050007F010012C2', '/报告树', '92208DB64512346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64513346BE050007F010012C2', '/报告树', '92208DB64513346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64514346BE050007F010012C2', '/报告树', '92208DB64514346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64515346BE050007F010012C2', '/报告树', '92208DB64515346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64516346BE050007F010012C2', '/报告树', '92208DB64516346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64517346BE050007F010012C2', '/报告树', '92208DB64517346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64518346BE050007F010012C2', '/报告树', '92208DB64518346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64519346BE050007F010012C2', '/报告树', '92208DB64519346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6451A346BE050007F010012C2', '/报告树', '92208DB6451A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6451B346BE050007F010012C2', '/报告树', '92208DB6451B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6451C346BE050007F010012C2', '/报告树', '92208DB6451C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6451D346BE050007F010012C2', '/报告树', '92208DB6451D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6451E346BE050007F010012C2', '/报告树', '92208DB6451E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6451F346BE050007F010012C2', '/报告树', '92208DB6451F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64520346BE050007F010012C2', '/报告树', '92208DB64520346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64521346BE050007F010012C2', '/报告树', '92208DB64521346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64522346BE050007F010012C2', '/报告树', '92208DB64522346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64523346BE050007F010012C2', '/报告树', '92208DB64523346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64524346BE050007F010012C2', '/报告树', '92208DB64524346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64525346BE050007F010012C2', '/报告树', '92208DB64525346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64526346BE050007F010012C2', '/报告树', '92208DB64526346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64527346BE050007F010012C2', '/报告树', '92208DB64527346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64528346BE050007F010012C2', '/报告树', '92208DB64528346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64529346BE050007F010012C2', '/报告树', '92208DB64529346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6452A346BE050007F010012C2', '/报告树', '92208DB6452A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6452B346BE050007F010012C2', '/报告树', '92208DB6452B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6452C346BE050007F010012C2', '/报告树', '92208DB6452C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6452D346BE050007F010012C2', '/报告树', '92208DB6452D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6452E346BE050007F010012C2', '/报告树', '92208DB6452E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6452F346BE050007F010012C2', '/报告树', '92208DB6452F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64530346BE050007F010012C2', '/报告树', '92208DB64530346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64531346BE050007F010012C2', '/报告树', '92208DB64531346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64532346BE050007F010012C2', '/报告树', '92208DB64532346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64533346BE050007F010012C2', '/报告树', '92208DB64533346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64534346BE050007F010012C2', '/报告树', '92208DB64534346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64535346BE050007F010012C2', '/报告树', '92208DB64535346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64536346BE050007F010012C2', '/报告树', '92208DB64536346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64537346BE050007F010012C2', '/报告树', '92208DB64537346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64538346BE050007F010012C2', '/报告树', '92208DB64538346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64539346BE050007F010012C2', '/报告树', '92208DB64539346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6453A346BE050007F010012C2', '/报告树', '92208DB6453A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6453B346BE050007F010012C2', '/报告树', '92208DB6453B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6453C346BE050007F010012C2', '/报告树', '92208DB6453C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6453D346BE050007F010012C2', '/报告树', '92208DB6453D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6453E346BE050007F010012C2', '/报告树', '92208DB6453E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6453F346BE050007F010012C2', '/报告树', '92208DB6453F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64540346BE050007F010012C2', '/报告树', '92208DB64540346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64541346BE050007F010012C2', '/报告树', '92208DB64541346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64542346BE050007F010012C2', '/报告树', '92208DB64542346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64543346BE050007F010012C2', '/报告树', '92208DB64543346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64544346BE050007F010012C2', '/报告树', '92208DB64544346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D0346BE050007F010012C2', '/报告树', '92208DB644D0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D1346BE050007F010012C2', '/报告树', '92208DB644D1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D2346BE050007F010012C2', '/报告树', '92208DB644D2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D3346BE050007F010012C2', '/报告树', '92208DB644D3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D4346BE050007F010012C2', '/报告树', '92208DB644D4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D5346BE050007F010012C2', '/报告树', '92208DB644D5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D6346BE050007F010012C2', '/报告树', '92208DB644D6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D7346BE050007F010012C2', '/报告树', '92208DB644D7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D8346BE050007F010012C2', '/报告树', '92208DB644D8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644D9346BE050007F010012C2', '/报告树', '92208DB644D9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644DA346BE050007F010012C2', '/报告树', '92208DB644DA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644DB346BE050007F010012C2', '/报告树', '92208DB644DB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644DC346BE050007F010012C2', '/报告树', '92208DB644DC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644DD346BE050007F010012C2', '/报告树', '92208DB644DD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644DE346BE050007F010012C2', '/报告树', '92208DB644DE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644DF346BE050007F010012C2', '/报告树', '92208DB644DF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E0346BE050007F010012C2', '/报告树', '92208DB644E0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E1346BE050007F010012C2', '/报告树', '92208DB644E1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E2346BE050007F010012C2', '/报告树', '92208DB644E2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E3346BE050007F010012C2', '/报告树', '92208DB644E3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E4346BE050007F010012C2', '/报告树', '92208DB644E4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E5346BE050007F010012C2', '/报告树', '92208DB644E5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E6346BE050007F010012C2', '/报告树', '92208DB644E6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E7346BE050007F010012C2', '/报告树', '92208DB644E7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E8346BE050007F010012C2', '/报告树', '92208DB644E8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644E9346BE050007F010012C2', '/报告树', '92208DB644E9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644EA346BE050007F010012C2', '/报告树', '92208DB644EA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644EB346BE050007F010012C2', '/报告树', '92208DB644EB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644EC346BE050007F010012C2', '/报告树', '92208DB644EC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644ED346BE050007F010012C2', '/报告树', '92208DB644ED346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB644EE346BE050007F010012C2', '/报告树', '92208DB644EE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64548346BE050007F010012C2', '/报告树', '92208DB64548346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64549346BE050007F010012C2', '/报告树', '92208DB64549346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6454A346BE050007F010012C2', '/报告树', '92208DB6454A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6454B346BE050007F010012C2', '/报告树', '92208DB6454B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6454C346BE050007F010012C2', '/报告树', '92208DB6454C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6454D346BE050007F010012C2', '/报告树', '92208DB6454D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6454E346BE050007F010012C2', '/报告树', '92208DB6454E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6454F346BE050007F010012C2', '/报告树', '92208DB6454F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64550346BE050007F010012C2', '/报告树', '92208DB64550346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64551346BE050007F010012C2', '/报告树', '92208DB64551346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64552346BE050007F010012C2', '/报告树', '92208DB64552346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64553346BE050007F010012C2', '/报告树', '92208DB64553346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64554346BE050007F010012C2', '/报告树', '92208DB64554346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64555346BE050007F010012C2', '/报告树', '92208DB64555346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64556346BE050007F010012C2', '/报告树', '92208DB64556346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64557346BE050007F010012C2', '/报告树', '92208DB64557346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64558346BE050007F010012C2', '/报告树', '92208DB64558346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64559346BE050007F010012C2', '/报告树', '92208DB64559346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6455A346BE050007F010012C2', '/报告树', '92208DB6455A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6455B346BE050007F010012C2', '/报告树', '92208DB6455B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6455C346BE050007F010012C2', '/报告树', '92208DB6455C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6455D346BE050007F010012C2', '/报告树', '92208DB6455D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6455E346BE050007F010012C2', '/报告树', '92208DB6455E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6455F346BE050007F010012C2', '/报告树', '92208DB6455F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64560346BE050007F010012C2', '/报告树', '92208DB64560346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64561346BE050007F010012C2', '/报告树', '92208DB64561346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64562346BE050007F010012C2', '/报告树', '92208DB64562346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64563346BE050007F010012C2', '/报告树', '92208DB64563346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64564346BE050007F010012C2', '/报告树', '92208DB64564346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6465A346BE050007F010012C2', '/报告树', '92208DB6465A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6465B346BE050007F010012C2', '/报告树', '92208DB6465B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6465C346BE050007F010012C2', '/报告树', '92208DB6465C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6465D346BE050007F010012C2', '/报告树', '92208DB6465D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E3346BE050007F010012C2', '/报告树', '92208DB645E3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E4346BE050007F010012C2', '/报告树', '92208DB645E4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E5346BE050007F010012C2', '/报告树', '92208DB645E5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E6346BE050007F010012C2', '/报告树', '92208DB645E6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E7346BE050007F010012C2', '/报告树', '92208DB645E7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E8346BE050007F010012C2', '/报告树', '92208DB645E8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E9346BE050007F010012C2', '/报告树', '92208DB645E9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645EA346BE050007F010012C2', '/报告树', '92208DB645EA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645EB346BE050007F010012C2', '/报告树', '92208DB645EB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645EC346BE050007F010012C2', '/报告树', '92208DB645EC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645ED346BE050007F010012C2', '/报告树', '92208DB645ED346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645EE346BE050007F010012C2', '/报告树', '92208DB645EE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645EF346BE050007F010012C2', '/报告树', '92208DB645EF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F0346BE050007F010012C2', '/报告树', '92208DB645F0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F1346BE050007F010012C2', '/报告树', '92208DB645F1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F2346BE050007F010012C2', '/报告树', '92208DB645F2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F3346BE050007F010012C2', '/报告树', '92208DB645F3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F4346BE050007F010012C2', '/报告树', '92208DB645F4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F5346BE050007F010012C2', '/报告树', '92208DB645F5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F6346BE050007F010012C2', '/报告树', '92208DB645F6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F7346BE050007F010012C2', '/报告树', '92208DB645F7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F8346BE050007F010012C2', '/报告树', '92208DB645F8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645F9346BE050007F010012C2', '/报告树', '92208DB645F9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645FA346BE050007F010012C2', '/报告树', '92208DB645FA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645FB346BE050007F010012C2', '/报告树', '92208DB645FB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645FC346BE050007F010012C2', '/报告树', '92208DB645FC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645FD346BE050007F010012C2', '/报告树', '92208DB645FD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645FE346BE050007F010012C2', '/报告树', '92208DB645FE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645FF346BE050007F010012C2', '/报告树', '92208DB645FF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64600346BE050007F010012C2', '/报告树', '92208DB64600346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64601346BE050007F010012C2', '/报告树', '92208DB64601346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64566346BE050007F010012C2', '/报告树', '92208DB64566346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64567346BE050007F010012C2', '/报告树', '92208DB64567346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64568346BE050007F010012C2', '/报告树', '92208DB64568346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64569346BE050007F010012C2', '/报告树', '92208DB64569346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6456A346BE050007F010012C2', '/报告树', '92208DB6456A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6456B346BE050007F010012C2', '/报告树', '92208DB6456B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6456C346BE050007F010012C2', '/报告树', '92208DB6456C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6456D346BE050007F010012C2', '/报告树', '92208DB6456D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6456E346BE050007F010012C2', '/报告树', '92208DB6456E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6456F346BE050007F010012C2', '/报告树', '92208DB6456F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64570346BE050007F010012C2', '/报告树', '92208DB64570346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64571346BE050007F010012C2', '/报告树', '92208DB64571346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64572346BE050007F010012C2', '/报告树', '92208DB64572346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64573346BE050007F010012C2', '/报告树', '92208DB64573346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64574346BE050007F010012C2', '/报告树', '92208DB64574346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64575346BE050007F010012C2', '/报告树', '92208DB64575346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64576346BE050007F010012C2', '/报告树', '92208DB64576346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64577346BE050007F010012C2', '/报告树', '92208DB64577346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64578346BE050007F010012C2', '/报告树', '92208DB64578346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64579346BE050007F010012C2', '/报告树', '92208DB64579346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6457A346BE050007F010012C2', '/报告树', '92208DB6457A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6457B346BE050007F010012C2', '/报告树', '92208DB6457B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6457C346BE050007F010012C2', '/报告树', '92208DB6457C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6457D346BE050007F010012C2', '/报告树', '92208DB6457D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6457E346BE050007F010012C2', '/报告树', '92208DB6457E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6457F346BE050007F010012C2', '/报告树', '92208DB6457F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64580346BE050007F010012C2', '/报告树', '92208DB64580346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64581346BE050007F010012C2', '/报告树', '92208DB64581346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64582346BE050007F010012C2', '/报告树', '92208DB64582346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64583346BE050007F010012C2', '/报告树', '92208DB64583346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64584346BE050007F010012C2', '/报告树', '92208DB64584346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64585346BE050007F010012C2', '/报告树', '92208DB64585346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64586346BE050007F010012C2', '/报告树', '92208DB64586346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64587346BE050007F010012C2', '/报告树', '92208DB64587346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64588346BE050007F010012C2', '/报告树', '92208DB64588346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64589346BE050007F010012C2', '/报告树', '92208DB64589346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6458A346BE050007F010012C2', '/报告树', '92208DB6458A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6458B346BE050007F010012C2', '/报告树', '92208DB6458B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6458C346BE050007F010012C2', '/报告树', '92208DB6458C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6458D346BE050007F010012C2', '/报告树', '92208DB6458D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6458E346BE050007F010012C2', '/报告树', '92208DB6458E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6458F346BE050007F010012C2', '/报告树', '92208DB6458F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64590346BE050007F010012C2', '/报告树', '92208DB64590346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64591346BE050007F010012C2', '/报告树', '92208DB64591346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64592346BE050007F010012C2', '/报告树', '92208DB64592346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64593346BE050007F010012C2', '/报告树', '92208DB64593346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64594346BE050007F010012C2', '/报告树', '92208DB64594346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64595346BE050007F010012C2', '/报告树', '92208DB64595346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64596346BE050007F010012C2', '/报告树', '92208DB64596346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64597346BE050007F010012C2', '/报告树', '92208DB64597346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64598346BE050007F010012C2', '/报告树', '92208DB64598346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64599346BE050007F010012C2', '/报告树', '92208DB64599346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6459A346BE050007F010012C2', '/报告树', '92208DB6459A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6459B346BE050007F010012C2', '/报告树', '92208DB6459B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6459C346BE050007F010012C2', '/报告树', '92208DB6459C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6459D346BE050007F010012C2', '/报告树', '92208DB6459D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6459E346BE050007F010012C2', '/报告树', '92208DB6459E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6459F346BE050007F010012C2', '/报告树', '92208DB6459F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A0346BE050007F010012C2', '/报告树', '92208DB645A0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A1346BE050007F010012C2', '/报告树', '92208DB645A1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A2346BE050007F010012C2', '/报告树', '92208DB645A2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A3346BE050007F010012C2', '/报告树', '92208DB645A3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A4346BE050007F010012C2', '/报告树', '92208DB645A4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A5346BE050007F010012C2', '/报告树', '92208DB645A5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A6346BE050007F010012C2', '/报告树', '92208DB645A6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A7346BE050007F010012C2', '/报告树', '92208DB645A7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A8346BE050007F010012C2', '/报告树', '92208DB645A8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645A9346BE050007F010012C2', '/报告树', '92208DB645A9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645AA346BE050007F010012C2', '/报告树', '92208DB645AA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645AB346BE050007F010012C2', '/报告树', '92208DB645AB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645AC346BE050007F010012C2', '/报告树', '92208DB645AC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645AD346BE050007F010012C2', '/报告树', '92208DB645AD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645AE346BE050007F010012C2', '/报告树', '92208DB645AE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645AF346BE050007F010012C2', '/报告树', '92208DB645AF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B0346BE050007F010012C2', '/报告树', '92208DB645B0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B1346BE050007F010012C2', '/报告树', '92208DB645B1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B2346BE050007F010012C2', '/报告树', '92208DB645B2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B3346BE050007F010012C2', '/报告树', '92208DB645B3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B4346BE050007F010012C2', '/报告树', '92208DB645B4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B5346BE050007F010012C2', '/报告树', '92208DB645B5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B6346BE050007F010012C2', '/报告树', '92208DB645B6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B7346BE050007F010012C2', '/报告树', '92208DB645B7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B8346BE050007F010012C2', '/报告树', '92208DB645B8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645B9346BE050007F010012C2', '/报告树', '92208DB645B9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645BA346BE050007F010012C2', '/报告树', '92208DB645BA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645BB346BE050007F010012C2', '/报告树', '92208DB645BB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645BC346BE050007F010012C2', '/报告树', '92208DB645BC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64545346BE050007F010012C2', '/报告树', '92208DB64545346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64546346BE050007F010012C2', '/报告树', '92208DB64546346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64547346BE050007F010012C2', '/报告树', '92208DB64547346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C3346BE050007F010012C2', '/报告树', '92208DB645C3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C4346BE050007F010012C2', '/报告树', '92208DB645C4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C5346BE050007F010012C2', '/报告树', '92208DB645C5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C6346BE050007F010012C2', '/报告树', '92208DB645C6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C7346BE050007F010012C2', '/报告树', '92208DB645C7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C8346BE050007F010012C2', '/报告树', '92208DB645C8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C9346BE050007F010012C2', '/报告树', '92208DB645C9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645CA346BE050007F010012C2', '/报告树', '92208DB645CA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645CB346BE050007F010012C2', '/报告树', '92208DB645CB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645CC346BE050007F010012C2', '/报告树', '92208DB645CC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645CD346BE050007F010012C2', '/报告树', '92208DB645CD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645CE346BE050007F010012C2', '/报告树', '92208DB645CE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645CF346BE050007F010012C2', '/报告树', '92208DB645CF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D0346BE050007F010012C2', '/报告树', '92208DB645D0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D1346BE050007F010012C2', '/报告树', '92208DB645D1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D2346BE050007F010012C2', '/报告树', '92208DB645D2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D3346BE050007F010012C2', '/报告树', '92208DB645D3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D4346BE050007F010012C2', '/报告树', '92208DB645D4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D5346BE050007F010012C2', '/报告树', '92208DB645D5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D6346BE050007F010012C2', '/报告树', '92208DB645D6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D7346BE050007F010012C2', '/报告树', '92208DB645D7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D8346BE050007F010012C2', '/报告树', '92208DB645D8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645D9346BE050007F010012C2', '/报告树', '92208DB645D9346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645DA346BE050007F010012C2', '/报告树', '92208DB645DA346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645DB346BE050007F010012C2', '/报告树', '92208DB645DB346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645DC346BE050007F010012C2', '/报告树', '92208DB645DC346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645DD346BE050007F010012C2', '/报告树', '92208DB645DD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645DE346BE050007F010012C2', '/报告树', '92208DB645DE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645DF346BE050007F010012C2', '/报告树', '92208DB645DF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E0346BE050007F010012C2', '/报告树', '92208DB645E0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E1346BE050007F010012C2', '/报告树', '92208DB645E1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645E2346BE050007F010012C2', '/报告树', '92208DB645E2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64602346BE050007F010012C2', '/报告树', '92208DB64602346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64603346BE050007F010012C2', '/报告树', '92208DB64603346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64604346BE050007F010012C2', '/报告树', '92208DB64604346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64605346BE050007F010012C2', '/报告树', '92208DB64605346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64606346BE050007F010012C2', '/报告树', '92208DB64606346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64607346BE050007F010012C2', '/报告树', '92208DB64607346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64608346BE050007F010012C2', '/报告树', '92208DB64608346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64609346BE050007F010012C2', '/报告树', '92208DB64609346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6460A346BE050007F010012C2', '/报告树', '92208DB6460A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6460B346BE050007F010012C2', '/报告树', '92208DB6460B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6460C346BE050007F010012C2', '/报告树', '92208DB6460C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6460D346BE050007F010012C2', '/报告树', '92208DB6460D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6460E346BE050007F010012C2', '/报告树', '92208DB6460E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6460F346BE050007F010012C2', '/报告树', '92208DB6460F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64610346BE050007F010012C2', '/报告树', '92208DB64610346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64611346BE050007F010012C2', '/报告树', '92208DB64611346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64612346BE050007F010012C2', '/报告树', '92208DB64612346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64613346BE050007F010012C2', '/报告树', '92208DB64613346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64614346BE050007F010012C2', '/报告树', '92208DB64614346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64615346BE050007F010012C2', '/报告树', '92208DB64615346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64616346BE050007F010012C2', '/报告树', '92208DB64616346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64617346BE050007F010012C2', '/报告树', '92208DB64617346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64618346BE050007F010012C2', '/报告树', '92208DB64618346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64619346BE050007F010012C2', '/报告树', '92208DB64619346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6461A346BE050007F010012C2', '/报告树', '92208DB6461A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6461B346BE050007F010012C2', '/报告树', '92208DB6461B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6461C346BE050007F010012C2', '/报告树', '92208DB6461C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6461D346BE050007F010012C2', '/报告树', '92208DB6461D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6461E346BE050007F010012C2', '/报告树', '92208DB6461E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6461F346BE050007F010012C2', '/报告树', '92208DB6461F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64620346BE050007F010012C2', '/报告树', '92208DB64620346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64621346BE050007F010012C2', '/报告树', '92208DB64621346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64622346BE050007F010012C2', '/报告树', '92208DB64622346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64623346BE050007F010012C2', '/报告树', '92208DB64623346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64624346BE050007F010012C2', '/报告树', '92208DB64624346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64625346BE050007F010012C2', '/报告树', '92208DB64625346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64626346BE050007F010012C2', '/报告树', '92208DB64626346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64627346BE050007F010012C2', '/报告树', '92208DB64627346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64628346BE050007F010012C2', '/报告树', '92208DB64628346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64629346BE050007F010012C2', '/报告树', '92208DB64629346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6462A346BE050007F010012C2', '/报告树', '92208DB6462A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6462B346BE050007F010012C2', '/报告树', '92208DB6462B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6462C346BE050007F010012C2', '/报告树', '92208DB6462C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6462D346BE050007F010012C2', '/报告树', '92208DB6462D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6462E346BE050007F010012C2', '/报告树', '92208DB6462E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6462F346BE050007F010012C2', '/报告树', '92208DB6462F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64630346BE050007F010012C2', '/报告树', '92208DB64630346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64631346BE050007F010012C2', '/报告树', '92208DB64631346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64632346BE050007F010012C2', '/报告树', '92208DB64632346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64633346BE050007F010012C2', '/报告树', '92208DB64633346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64634346BE050007F010012C2', '/报告树', '92208DB64634346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64635346BE050007F010012C2', '/报告树', '92208DB64635346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64636346BE050007F010012C2', '/报告树', '92208DB64636346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64637346BE050007F010012C2', '/报告树', '92208DB64637346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64638346BE050007F010012C2', '/报告树', '92208DB64638346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64639346BE050007F010012C2', '/报告树', '92208DB64639346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6463A346BE050007F010012C2', '/报告树', '92208DB6463A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6463B346BE050007F010012C2', '/报告树', '92208DB6463B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6463C346BE050007F010012C2', '/报告树', '92208DB6463C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6463D346BE050007F010012C2', '/报告树', '92208DB6463D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6463E346BE050007F010012C2', '/报告树', '92208DB6463E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6463F346BE050007F010012C2', '/报告树', '92208DB6463F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64640346BE050007F010012C2', '/报告树', '92208DB64640346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64641346BE050007F010012C2', '/报告树', '92208DB64641346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64642346BE050007F010012C2', '/报告树', '92208DB64642346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64643346BE050007F010012C2', '/报告树', '92208DB64643346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64644346BE050007F010012C2', '/报告树', '92208DB64644346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64645346BE050007F010012C2', '/报告树', '92208DB64645346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64646346BE050007F010012C2', '/报告树', '92208DB64646346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64647346BE050007F010012C2', '/报告树', '92208DB64647346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64648346BE050007F010012C2', '/报告树', '92208DB64648346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64649346BE050007F010012C2', '/报告树', '92208DB64649346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6464A346BE050007F010012C2', '/报告树', '92208DB6464A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6464B346BE050007F010012C2', '/报告树', '92208DB6464B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6464C346BE050007F010012C2', '/报告树', '92208DB6464C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6464D346BE050007F010012C2', '/报告树', '92208DB6464D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6464E346BE050007F010012C2', '/报告树', '92208DB6464E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6464F346BE050007F010012C2', '/报告树', '92208DB6464F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64650346BE050007F010012C2', '/报告树', '92208DB64650346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64651346BE050007F010012C2', '/报告树', '92208DB64651346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64652346BE050007F010012C2', '/报告树', '92208DB64652346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64653346BE050007F010012C2', '/报告树', '92208DB64653346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64654346BE050007F010012C2', '/报告树', '92208DB64654346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64655346BE050007F010012C2', '/报告树', '92208DB64655346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64656346BE050007F010012C2', '/报告树', '92208DB64656346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64657346BE050007F010012C2', '/报告树', '92208DB64657346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64658346BE050007F010012C2', '/报告树', '92208DB64658346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64659346BE050007F010012C2', '/报告树', '92208DB64659346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645BD346BE050007F010012C2', '/报告树', '92208DB645BD346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645BE346BE050007F010012C2', '/报告树', '92208DB645BE346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645BF346BE050007F010012C2', '/报告树', '92208DB645BF346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C0346BE050007F010012C2', '/报告树', '92208DB645C0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C1346BE050007F010012C2', '/报告树', '92208DB645C1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB645C2346BE050007F010012C2', '/报告树', '92208DB645C2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6465E346BE050007F010012C2', '/报告树', '92208DB6465E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6465F346BE050007F010012C2', '/报告树', '92208DB6465F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64660346BE050007F010012C2', '/报告树', '92208DB64660346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64661346BE050007F010012C2', '/报告树', '92208DB64661346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64662346BE050007F010012C2', '/报告树', '92208DB64662346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64663346BE050007F010012C2', '/报告树', '92208DB64663346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64664346BE050007F010012C2', '/报告树', '92208DB64664346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64665346BE050007F010012C2', '/报告树', '92208DB64665346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64666346BE050007F010012C2', '/报告树', '92208DB64666346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64667346BE050007F010012C2', '/报告树', '92208DB64667346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64668346BE050007F010012C2', '/报告树', '92208DB64668346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64669346BE050007F010012C2', '/报告树', '92208DB64669346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6466A346BE050007F010012C2', '/报告树', '92208DB6466A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6466B346BE050007F010012C2', '/报告树', '92208DB6466B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6466C346BE050007F010012C2', '/报告树', '92208DB6466C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6466D346BE050007F010012C2', '/报告树', '92208DB6466D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6466E346BE050007F010012C2', '/报告树', '92208DB6466E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6466F346BE050007F010012C2', '/报告树', '92208DB6466F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64670346BE050007F010012C2', '/报告树', '92208DB64670346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64671346BE050007F010012C2', '/报告树', '92208DB64671346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64672346BE050007F010012C2', '/报告树', '92208DB64672346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64673346BE050007F010012C2', '/报告树', '92208DB64673346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64674346BE050007F010012C2', '/报告树', '92208DB64674346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64675346BE050007F010012C2', '/报告树', '92208DB64675346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64676346BE050007F010012C2', '/报告树', '92208DB64676346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64677346BE050007F010012C2', '/报告树', '92208DB64677346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64678346BE050007F010012C2', '/报告树', '92208DB64678346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64679346BE050007F010012C2', '/报告树', '92208DB64679346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6467A346BE050007F010012C2', '/报告树', '92208DB6467A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6467B346BE050007F010012C2', '/报告树', '92208DB6467B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6467C346BE050007F010012C2', '/报告树', '92208DB6467C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6467D346BE050007F010012C2', '/报告树', '92208DB6467D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6467E346BE050007F010012C2', '/报告树', '92208DB6467E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6467F346BE050007F010012C2', '/报告树', '92208DB6467F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64680346BE050007F010012C2', '/报告树', '92208DB64680346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64681346BE050007F010012C2', '/报告树', '92208DB64681346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64682346BE050007F010012C2', '/报告树', '92208DB64682346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64683346BE050007F010012C2', '/报告树', '92208DB64683346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64684346BE050007F010012C2', '/报告树', '92208DB64684346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64685346BE050007F010012C2', '/报告树', '92208DB64685346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64686346BE050007F010012C2', '/报告树', '92208DB64686346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64687346BE050007F010012C2', '/报告树', '92208DB64687346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64688346BE050007F010012C2', '/报告树', '92208DB64688346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64689346BE050007F010012C2', '/报告树', '92208DB64689346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6468A346BE050007F010012C2', '/报告树', '92208DB6468A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6468B346BE050007F010012C2', '/报告树', '92208DB6468B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6468C346BE050007F010012C2', '/报告树', '92208DB6468C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6468D346BE050007F010012C2', '/报告树', '92208DB6468D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6468E346BE050007F010012C2', '/报告树', '92208DB6468E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6468F346BE050007F010012C2', '/报告树', '92208DB6468F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64690346BE050007F010012C2', '/报告树', '92208DB64690346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64691346BE050007F010012C2', '/报告树', '92208DB64691346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64692346BE050007F010012C2', '/报告树', '92208DB64692346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64693346BE050007F010012C2', '/报告树', '92208DB64693346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64694346BE050007F010012C2', '/报告树', '92208DB64694346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64695346BE050007F010012C2', '/报告树', '92208DB64695346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/D5A2B2C7B8054BAA97C78C4CD5984442', '/报告树', 'D5A2B2C7B8054BAA97C78C4CD5984442', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/804BDC10B4C74994907333A3C881E7A4', '/报告树', '804BDC10B4C74994907333A3C881E7A4', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/432669F01E7647F1BDBD6C50DEE83DBB', '/报告树', '432669F01E7647F1BDBD6C50DEE83DBB', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/71FEA43853F248CA85851B49455479E2', '/报告树', '71FEA43853F248CA85851B49455479E2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/607BD4AFE1F64458ACD6E5A31C102E80', '/报告树', '607BD4AFE1F64458ACD6E5A31C102E80', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/D188C535D12B483B91ABC29603B6847C', '/报告树', 'D188C535D12B483B91ABC29603B6847C', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64696346BE050007F010012C2', '/报告树', '92208DB64696346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64697346BE050007F010012C2', '/报告树', '92208DB64697346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64698346BE050007F010012C2', '/报告树', '92208DB64698346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB64699346BE050007F010012C2', '/报告树', '92208DB64699346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6469A346BE050007F010012C2', '/报告树', '92208DB6469A346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6469B346BE050007F010012C2', '/报告树', '92208DB6469B346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6469C346BE050007F010012C2', '/报告树', '92208DB6469C346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6469D346BE050007F010012C2', '/报告树', '92208DB6469D346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6469E346BE050007F010012C2', '/报告树', '92208DB6469E346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB6469F346BE050007F010012C2', '/报告树', '92208DB6469F346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A0346BE050007F010012C2', '/报告树', '92208DB646A0346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A1346BE050007F010012C2', '/报告树', '92208DB646A1346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A2346BE050007F010012C2', '/报告树', '92208DB646A2346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A3346BE050007F010012C2', '/报告树', '92208DB646A3346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A4346BE050007F010012C2', '/报告树', '92208DB646A4346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A5346BE050007F010012C2', '/报告树', '92208DB646A5346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A6346BE050007F010012C2', '/报告树', '92208DB646A6346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A7346BE050007F010012C2', '/报告树', '92208DB646A7346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, NULL, 1, '/92208DB646A8346BE050007F010012C2', '/报告树', '92208DB646A8346BE050007F010012C2', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D4B0947DCC6D4112AB5E7BED2C50AD85', '92208DB645C4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D7E80AE670544F5D8568673434FE12B9', '92208DB645C5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '571232C129324241997AE77CF40EAC52', '92208DB645C6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '90D50D225C6C44E78D711126211DFEB5', '92208DB645C7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E7E65FD635D043D09EEF75DC78C71C82', '92208DB645C8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '071595916F164F329C11C1B2D944ADC3', '92208DB645C9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4A025C6A950B4E0EB66A4887C8BCACBC', '92208DB645CA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '64F6D1223C02495E8D44A3468F0D4AAD', '92208DB645CB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C7E813CDE588418398900B542A6D7886', '92208DB645CC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '116C8CC141384678B60B75393E35DC07', '92208DB645CD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '36D6369072234B1692F8E0F68596D1CE', '92208DB645CE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C1E8871B81AB40DEB14319F4120D3506', '92208DB645CF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6F61FBA65C1D4CC4B24020B435CD0472', '92208DB645D0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3A690883E35D4E9692F7FF2CC07A049C', '92208DB645D1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BCB3D8D9D88745CBB3FD6D3B9B1F3BA6', '92208DB645D2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5CB36BDF8C6640AE8DCE0F01551F96CD', '92208DB645D3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FDE721F44C8247BC86603383C083FDD6', '92208DB645D4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7CFB9D2C3B7641CA90FC09E3512B7CC2', '92208DB645D5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8178B103A6174EFCBACD2B2CC626B3D0', '92208DB645D6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '62539423B5E549AA8CB3EF32B0F8FB96', '92208DB645D7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0CBA251E3EEC4EF7AB2D17875B7F2E9F', '92208DB645D8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1E2324D9852340C2AA591E385945AFBD', '92208DB645D9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D488C89A3AE548CCBDEABB6B8D4D4FB3', '92208DB645DA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '798ED29EF20F40BAB944A5535C75CEB3', '92208DB645DB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B8B202FA311A4612B24B642ACCCB9DBF', '92208DB645DC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C2FE47DE4208448DAD55DBFCFB452B3C', '92208DB645DD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3D8B547EE6144F1FB9F8EEA55339911D', '92208DB645DE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B93EB447E8AD42FFB193FA3B27F136FD', '92208DB645DF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F3AC925EEA6A4B9DBE66273DF18B9861', '92208DB645E0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CF692A233C514DA28C7087C1E056E8C5', '92208DB645E1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '398F2B2BF9DE4BBF9729C8BBCFF4C107', '92208DB645E2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3A1CFA7FA309476CBEED1DA702DD3854', '92208DB64602346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7CD14D9AAF5E487FAA414C8F2A2B6C2A', '92208DB64603346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7A94D90775E14C59B4C31C4FF15B08BF', '92208DB64604346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '617402E611F44E06B0EAE20207E98BCC', '92208DB64605346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DC4AFA6FC24240C292E0B7DB4069EE70', '92208DB64606346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D8D7D66260B3435C8EEA129A016422CB', '92208DB64607346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ED6A99AECE0C4F97B7E78559F15F9A9A', '92208DB64608346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D4F8876A581145358F40D7BFC759E4D1', '92208DB64609346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FA10A30B5E4541E7BE00E24E4F873E8F', '92208DB6460A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '21B9DB63FFE642388ACC146785516EEF', '92208DB6460B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '06E995E2F7E145999CCED94BF84E2C3A', '92208DB6460C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7D3C8DF2F2B944F2ACAD51E71F16BAB1', '92208DB6460D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '96DE74A95D8B4C33A04A43666A558955', '92208DB6460E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DEC74258324B434ABB9E9CF320DF164D', '92208DB6460F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DEF3F4590C3E4EDF98F64F29B5365437', '92208DB64610346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DAAA0A4E6F8B47D08BCBC2743D63229A', '92208DB64611346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '78F001C55C894588961FEFE7F48FECCD', '92208DB64612346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '02687FD23EC64707B1BBCB8E547D3C6C', '92208DB64613346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E53ACC4690B044CA976B6F7107BD23BA', '92208DB64614346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DA94C3B5D7CE414CB3A99F5B98ECE8B8', '92208DB64615346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1C0FA00EC4444ECAAC615037F4CC671A', '92208DB64616346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E440B71E985347D2ADF34AFE48F92A7F', '92208DB64617346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7CE178F9F1B445799AF4F681D155CA98', '92208DB64618346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '50E8961CFF734D6AAF0E556D568ED052', '92208DB64619346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AADB127DE2A444E5B8347616B57B9259', '92208DB6461A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6D1A9C4E301A4053A29DC8794736AD7B', '92208DB6461B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6173EA7EAFDF4E988E1E2B70976C9717', '92208DB6461C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7AC371187C824DE480B1A07571F8BA10', '92208DB6461D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, '测试报告', NULL, 'FOLDER', '测试报告', NULL, 1, 3578904, 1, '/5EEB2DC861694A65933CB4CE9A8D870A/F785431F03DC46EAB903FC16541908E7', '/报告树/测试报告', 'F785431F03DC46EAB903FC16541908E7', '5EEB2DC861694A65933CB4CE9A8D870A');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, 3578623, 1, '/D188C535D12B483B91ABC29603B6847C/778709BA71E948FA8CB740F2DE0B9FAE', '/报告树/我的报告', '778709BA71E948FA8CB740F2DE0B9FAE', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, 3578537, 1, '/71FEA43853F248CA85851B49455479E2', '/报告树', '0B7372C621014237820AD48A254001CA', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, 3578539, 1, '/71FEA43853F248CA85851B49455479E2/15FA299B528D422E9A9720ACC0E3DE70', '/报告树/我的报告', '15FA299B528D422E9A9720ACC0E3DE70', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '报告树', NULL, NULL, 3578621, 1, '/D188C535D12B483B91ABC29603B6847C', '/报告树', '7F646B18207C4E1FA46AE71AA9CD546A', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, 3578651, 1, '/73F7E37330834BA5A9D30CCC2D4DCF0A/799A4C4041D4402B94DB6457A6B72803', '/报告树/我的报告', '799A4C4041D4402B94DB6457A6B72803', NULL);
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C900713F3524466D8B7EA5887FA4A015', '92208DB6461E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4FFFD1B319EF4E72BCF37D1EEF32254A', '92208DB6461F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A46D8F9A3FFC4A248AE94B37A1ABB256', '92208DB64620346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '768A81444CC241C0BC34BB3520F843C6', '92208DB64621346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7383372D87AF4810B23FEDB31C598943', '92208DB64622346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EC66ECD159F8447DA6AEE410D2192DAA', '92208DB64623346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D882F6B73A9B4A58B918E8F9737622DC', '92208DB64624346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'DC2FF2978D90488D97A587B182BB7DDA', '92208DB64625346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '64F29E9F27B94EFA93CD2A1F476D65A1', '92208DB64626346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '18172E2CE9E44F96A26C0E087819DB92', '92208DB64627346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '967154EFFA9A49F0B94F1C488D2F7AB3', '92208DB64628346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'FCE085F7D0384352A069A12C0463D7A9', '92208DB64629346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EC1E309E9EDE4FC7B0B661CCE6B51D3F', '92208DB6462A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A50DDA0E2EDB40AC9DA2B91F753265B6', '92208DB6462B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B2D5A4DE9800487F95543815061D044D', '92208DB6462C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BF1A6B96647A447098888969A3463CC2', '92208DB6462D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B161B6E205AA4D12AC6165E9C601D516', '92208DB6462E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C2BF4B50B56645219349558B2464FE5F', '92208DB6462F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4C9CFF0715DC478486732147FB927842', '92208DB64630346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '479C49CACCFF49A189ED922F823DD4D6', '92208DB64631346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '452E934105C44B31AF25D714ABB30C03', '92208DB64632346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '16C6F1D495A64DF48BA85218E9DAF04A', '92208DB64633346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7A2CFABE52AE4A07BE2E42DEA1FD6B24', '92208DB64634346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6D7E91A46F144C878C9796D413729639', '92208DB64635346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '83B1077C47F841599BBFEFB82126BA17', '92208DB64636346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2AE4ED8B4DB14FCCAAC03BE74D2DD0C7', '92208DB64637346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2BBCE042C6D94F15A22444AB4E6377AD', '92208DB64638346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8673081491EA4012A092CFAC30A7F47E', '92208DB64639346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B80C273DC0864162BF52D28F400AA9DA', '92208DB6463A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E298DAA1705D4AE78C176B1EBA1645C6', '92208DB6463B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '14418C982E444CA494695E1638993EA2', '92208DB6463C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '88146EB9443B4C52AAD1505F2A310EBC', '92208DB6463D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C51CADD7495842798F7EEE92EF16901C', '92208DB6463E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4E5D7C9AA6E2402AAE5383F88F05AE55', '92208DB6463F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1CBB5CB05D444A2FA0E6081D2B4FCBA2', '92208DB64640346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2869F3B50B8843D390598A77C370ED47', '92208DB64641346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '610B8F0545B341C2BF5500031131F832', '92208DB64642346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '62B420FB6202464F936D55F82147D44D', '92208DB64643346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1F1DDBBEB3A045109E802C76123ACE19', '92208DB64644346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E24DC1F2E95045C2A1B5A9528D76F64A', '92208DB64645346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3FDB040424404252AFF375596F0B960D', '92208DB64646346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F894A11A48D14A61B13C2741D0410062', '92208DB64647346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0C4E895CFDED4F36AD69B44E14B93385', '92208DB64648346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '63C74527A3F140308BB3C6A2736B170B', '92208DB64649346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7FFB5FC67CC440FDA38158ACCF9EE911', '92208DB6464A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F19E9A04517447899054DA3A2580CFF9', '92208DB6464B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '52FF62BE17C54685B66B5A3BD791646B', '92208DB6464C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9738C43615E344268F8FC4C7DD44B6BE', '92208DB6464D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '60F4556C6746417B9F55A06AA05E0EEE', '92208DB6464E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '23929B7621A14B348B2366F66EF9E3FC', '92208DB6464F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C41D0C2FE5924D2DA14E9F4C9114C2BE', '92208DB64650346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C088AD553B6D493E98C3A2610A9A9ACC', '92208DB64651346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '86DF85701BE74AF6A2AA2146F5CC2FA2', '92208DB64652346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '777FC60777454D3FAEDC4E062BE9DF98', '92208DB64653346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E6A2522CB0B84FE9AA9A8ED33FC73DFF', '92208DB64654346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1187FA0296E8498992AF28ACEC94BCAC', '92208DB64655346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '2DDA1A6ABBBF48DC8ECDBAE42778026A', '92208DB64656346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9E99E0E818D64560930E493C80F87056', '92208DB64657346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6A4E9AE6F3194A85AD941BA3CB1C920F', '92208DB64658346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '70A66BF63988414A90C4CDF28E6E280C', '92208DB64659346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'E0150FEECA0347BCA67FB257653AA44F', '92208DB64675346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9765D3B041334879A5D90F509222CEC6', '92208DB64676346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9CE9AFAA81894B2297A6BDA0048C38A3', '92208DB64677346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F61EC564CD8A46F6AD0E7156C732C819', '92208DB64678346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9B628DFC0CCC41DF9B925ACBB5F9C67D', '92208DB64679346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ECD3DDABFC2B46E490F6F0BA9AB2DDBB', '92208DB6467A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '078713DC6F6F4D55872F9E9D60324576', '92208DB6467B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '38ABC9D6ACA44D3289CD34C8D2AB746E', '92208DB6467C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AE501666C9B94ADCBA53CF2C77EB308D', '92208DB6467D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CA84CB8C21714EDCBD29F9527CE4749F', '92208DB6467E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A48B9FD0E4354FBA9EE384639F19FF63', '92208DB6467F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5704686C51194325BE41B4649A857F8C', '92208DB64680346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D25C996D36E34015B21AAE263E7C27A1', '92208DB64681346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B0794C7FDB7347D3ABBD6F742E3CE933', '92208DB64682346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AAEF4EA51606423F9BBBCA9731E5DF0A', '92208DB64683346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5DCE9819B95B462A81AFA665B66F8DB8', '92208DB64684346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '01E32B24DC764481BE7E441FF0EDDBA6', '92208DB64685346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9B8F7F31E1DE41B7A86E561DEEA463CE', '92208DB64686346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BC9B9B2631CA4950AC7DE5D0CFA1B249', '92208DB64687346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '924EC62F45854B968ECDA8D7C2A8BCB1', '92208DB64688346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1CA24B53060A48698B27D9D5552DB58D', '92208DB64689346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B978C251BA1B4B928D9DB76A874E3492', '92208DB6468A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '790DA524297B401F9F00B24F43766267', '92208DB6468B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0683414031164D069D397E1A15099AD5', '92208DB6468C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D92A7D4656704C89BD3163A932B76115', '92208DB6468D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F7ABB187A8DB42A89B0B84571F3AF939', '92208DB6468E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5AB09F35944443FCA9714E5335796A71', '92208DB6468F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5E9642AB06654F18839B3D85E91E7276', '92208DB64690346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C1A1AC971F4C4D5B9250ED8FFF1141E6', '92208DB64691346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BBCAAC0A7934407A90BE46BAF0233C53', '92208DB64692346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '3574428A11044674A0C5BB021EE0D404', '92208DB645BD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AFFF1C4317F248BB9509700097B57AAA', '92208DB645BE346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7BA0A470681A45778806A26C68F542FD', '92208DB645BF346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '7C46E4F63EFA4E229DE3F6D3EE60105F', '92208DB645C0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '34D170193BF04621B176ADA89C508D2B', '92208DB645C1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9EADBDD7C13E412892BA8196852FBE52', '92208DB645C2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D09393A157424508838E48A1A709DF27', '92208DB6465E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1310FD593ED248B4A6F033976E8C04C5', '92208DB6465F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'F73016DA9D6C40C1BE530D38B8156CCE', '92208DB64660346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '99A2A69626FE48BBBECBE9A3689950FD', '92208DB64661346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B73798CFB7394DA48EF52B558CED1890', '92208DB64662346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '19019081177340B490288D83C9CC6A8B', '92208DB64663346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '934E02B689DE403F980BDC9FC7863A00', '92208DB64664346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'AA835895D9F448D0AEC4F1D1B670C5ED', '92208DB64665346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '51CEBFE0007846CD827381EC7EEC172F', '92208DB64666346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '47CA204CB4384D22BC32DAC0DF65C758', '92208DB64667346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BAF1F363D03C44939A98B710BC156480', '92208DB64668346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '17AEDBFA79E84740858B4A76F5909AD5', '92208DB64669346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A98AAB65DCB2459182341945E1796697', '92208DB6466A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5F88EC77A22B4ACFBFF6B000720E1DC6', '92208DB6466B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D3F3405C0B5C49FF874FECC820651C43', '92208DB6466C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A0C05BF27E154D089B7CE011935B0185', '92208DB6466D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '5A12649CF38E4813B16BD6A5EE99273D', '92208DB6466E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8D51C586F82E4B6C83C6B46E9129E54A', '92208DB6466F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BC2A9FAEFE64407E9FC58085BD00DF3B', '92208DB64670346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'BA9E693806684A54BA70A1A15E80AD33', '92208DB64671346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1BD315392DC640FF895F0F427529A749', '92208DB64672346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '94A8ECCF7B0F4E44A6B45C9F5299851C', '92208DB64673346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D454DE0059CB4A2BB49642AEBB1741AF', '92208DB64674346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '79948288A7734636A4C5D0FE54A43DBF', '92208DB64693346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '9EF957D7952B43DE84C04B744F97E8AB', '92208DB64694346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '99463230AD1E400491EB938E39DFB0A9', '92208DB64695346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'CFA5E92D6E314DDB894A82394B48C80D', 'D5A2B2C7B8054BAA97C78C4CD5984442');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '68E1D20ED8E84158870DB69BC1DF9478', '804BDC10B4C74994907333A3C881E7A4');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8BEFDED69848455A8F5F6A8A4EC009F4', '432669F01E7647F1BDBD6C50DEE83DBB');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8098E2CAB40543B1A221DF0153A1AD31', '71FEA43853F248CA85851B49455479E2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '0148444D1F044ABAAB9E67425BE58BC2', '607BD4AFE1F64458ACD6E5A31C102E80');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '4DCF4B46B06A472DAEDAE755FE504F72', 'D188C535D12B483B91ABC29603B6847C');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '102533C283B547BF903DFBD576EF2696', '92208DB64696346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6999B74F8A544B5DA543A9674EF3B6C5', '92208DB64697346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C4DD6EEC02014C198BB7A6F0BEA4FE29', '92208DB64698346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '97F10194AC3741029C75B99B3AE964DF', '92208DB64699346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '1A1939300B6947339757ADCF3EC068A4', '92208DB6469A346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '30EA783C24CA48F3A74D260E16E53C7D', '92208DB6469B346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'A2C2517EA564400087034A40C92F2085', '92208DB6469C346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '589F8B25CABF478E8474E81BA8AAF662', '92208DB6469D346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'B7330E5FCBE0464CB59DAEFEB7E98D13', '92208DB6469E346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '6A7763FA043E49238D5CAFF4F8205464', '92208DB6469F346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '06168823B4D64CDD8484B40404A8A061', '92208DB646A0346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8D8C88AEE4F74152A7CC30C7D8D02CFB', '92208DB646A1346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '936F4BA7E4A344329193083DDCA8AEE5', '92208DB646A2346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '07FAC0B7FBB44FB088620EB8B708B94A', '92208DB646A3346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D9C5F88DD2934405BBF6A6BD3B96D940', '92208DB646A4346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '64CF8F8637744B9AB8618B5CC6E77650', '92208DB646A5346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'ACC5AEFB500F479F972C01784D925FDD', '92208DB646A6346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D72ACA46E2224C00B7F057C5241CBA5C', '92208DB646A7346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'C98A5B014F1149C1B2AB8ECD97C498A7', '92208DB646A8346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'D8F5088B7AD846F7B4796CADC3AB2690', '92208DB646A9346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '90D86CAF844D482DBB78A1298704C0AC', '92208DB646AA346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '810C0895540442609EAEFE933ADE498F', '92208DB646AB346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '8FAAEEC6B3C64735BF656EADE646B1BD', '92208DB646AC346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', '49B9DD3311C540C3A56B506EC090FF99', '92208DB646AD346BE050007F010012C2');
INSERT INTO `sa_commontree` VALUES (62, NULL, NULL, NULL, '我的报告', NULL, NULL, NULL, 1, NULL, '/报告树/我的报告', 'EB921DD8D6174DC6B0C1AB680D4A71E1', '73F7E37330834BA5A9D30CCC2D4DCF0A');
INSERT INTO `sa_commontree` VALUES (62, 'PPT', NULL, 'FOLDER', 'PPT', NULL, 1, 3578914, 1, '/B9336E1CE1B444BD89DE9192366AF0FA', '/报告树/我的报告/PPT', 'B9336E1CE1B444BD89DE9192366AF0FA', '8A7A60C3891D45B6A228E502430F4F9C');

-- ----------------------------
-- Table structure for sa_dictionary
-- ----------------------------
DROP TABLE IF EXISTS `sa_dictionary`;
CREATE TABLE `sa_dictionary`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `KIND_ID` int(11) NULL DEFAULT NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_dictionary
-- ----------------------------
INSERT INTO `sa_dictionary` VALUES ('0318D3F4E7F145469873708DED37391D', 'secretLevel', '密级级别', '1395', 0, 1, '密级级别', 86498, NULL);
INSERT INTO `sa_dictionary` VALUES ('067825F78AF5493E82ABF74FB1BEDEA2', 'uiElementStatus', '界面元素状态', '1395', 0, 1, NULL, 86506, NULL);
INSERT INTO `sa_dictionary` VALUES ('1', 'nation', '民族', '1395', 0, 1, NULL, NULL, NULL);
INSERT INTO `sa_dictionary` VALUES ('10592', 'orgAdminKind', '机构类型', '1395', 0, 1, NULL, 24841, NULL);
INSERT INTO `sa_dictionary` VALUES ('10601', 'dutyLevel', '层级', '1395', 0, 1, '层级', 86476, NULL);
INSERT INTO `sa_dictionary` VALUES ('10859', 'managerFun', '管理人员函数', '1395', 0, 1, NULL, 257240, NULL);
INSERT INTO `sa_dictionary` VALUES ('1266292', 'messageNodeType', '消息节点类型', '1266290', 0, 1, '消息节点类型', 86484, NULL);
INSERT INTO `sa_dictionary` VALUES ('1317646', 'taskKind', '任务类别', '1395', 0, 1, NULL, 1317647, NULL);
INSERT INTO `sa_dictionary` VALUES ('1405', 'sex', '性别', '1395', 0, 1, NULL, NULL, NULL);
INSERT INTO `sa_dictionary` VALUES ('1A3ECD959A8A464B8CF14630578D59C7', 'roleStatus', '角色状态', '1395', 0, 1, NULL, 86496, NULL);
INSERT INTO `sa_dictionary` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', 'businessKind', '业务类型', '11DC2E4FFF094A828B079EEE1F2CD731', 0, 1, NULL, 253330, NULL);
INSERT INTO `sa_dictionary` VALUES ('3C89377D4E384DD6876B38FEF86B7041', 'processManageStatus', '流程状态', '1395', 0, 1, NULL, 86494, NULL);
INSERT INTO `sa_dictionary` VALUES ('4188EF96566546A1951A1044B40348E6', 'commonTreeKind', '通用树类别', '1395', 0, 1, NULL, 3577479, NULL);
INSERT INTO `sa_dictionary` VALUES ('424949', 'organKind', '公司类别', '1395', 0, -1, '公司类别-需要删除', NULL, NULL);
INSERT INTO `sa_dictionary` VALUES ('427180', 'orgProperty', '机构属性', '1395', 0, 1, NULL, 24812, NULL);
INSERT INTO `sa_dictionary` VALUES ('434B00E325504AEC9B2E8D2DB00BA123', 'procAgentKind', '代理方式', '1395', 0, 1, NULL, 86492, NULL);
INSERT INTO `sa_dictionary` VALUES ('4C43956329A947278BA13F43E76E7FE2', 'deptLevel', '部门级别', '1395', 0, 1, NULL, 1203021, NULL);
INSERT INTO `sa_dictionary` VALUES ('62279D8505584A91BF523813FCFF8344', 'education', '学历', '1395', 0, 1, NULL, 308186, NULL);
INSERT INTO `sa_dictionary` VALUES ('6272911', 'subjectType', '专业类别', '9', 0, 1, NULL, 6520834, NULL);
INSERT INTO `sa_dictionary` VALUES ('634343', 'roleKindId', '角色类别', '1395', 0, 1, NULL, 70098, NULL);
INSERT INTO `sa_dictionary` VALUES ('6365941', 'orgAreaKind', '组织机构区域类型', '1395', 0, 1, NULL, 55422476, NULL);
INSERT INTO `sa_dictionary` VALUES ('6554A38109EA495786ECA295F53DEAAA', 'maritalStatus', '婚姻状况', '1395', 0, 1, NULL, 270577, NULL);
INSERT INTO `sa_dictionary` VALUES ('6A4F9F6C7FCF4EAC8479AE6A79458541', 'orgFunctionNodeKind', '机构函数节点类别', '1395', 0, 1, NULL, 86488, NULL);
INSERT INTO `sa_dictionary` VALUES ('726077', 'fieldAuthority', '字段权限', '1395', 0, 1, NULL, NULL, NULL);
INSERT INTO `sa_dictionary` VALUES ('726372', 'fieldType', '字段分类', '1395', 0, 1, '数据测试数', 2110, NULL);
INSERT INTO `sa_dictionary` VALUES ('739055A2A3D54C0AA5C06D848DA6334A', 'bizManagementNodeKind', '业务权限节点类别', '1395', 0, 1, NULL, 107988, NULL);
INSERT INTO `sa_dictionary` VALUES ('768E1E81BCF14DC78FC843EDBA4CF800', 'agentStatus', '代理状态', '1395', 0, 1, NULL, 260141, NULL);
INSERT INTO `sa_dictionary` VALUES ('780205', 'permissionKind', '权限类别', '1395', 0, 1, NULL, NULL, NULL);
INSERT INTO `sa_dictionary` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', 'weekKindId', '星期', '1395', 0, 1, NULL, 5387, NULL);
INSERT INTO `sa_dictionary` VALUES ('7D48D910A4B840E8908FC572ABCC7B71', 'treeNodeKind', '树节点类型', '1395', 0, 1, NULL, 294044, NULL);
INSERT INTO `sa_dictionary` VALUES ('7F0F082C3A8643D9829BAE5A8AC19F48', 'scopeKind', '流程范围', '1395', 0, 1, NULL, 86497, NULL);
INSERT INTO `sa_dictionary` VALUES ('81F17B971A114700B7FD3B6C9E51307A', 'subjection', '隶属公司', '11DC2E4FFF094A828B079EEE1F2CD731', 0, 1, NULL, 240990, NULL);
INSERT INTO `sa_dictionary` VALUES ('898180', 'deptProperty', '部门属性', '1395', 0, 1, NULL, 32125199, NULL);
INSERT INTO `sa_dictionary` VALUES ('8C850449D9314D70A446361BC291150E', 'bizManagementType', '业务权限类别', '1395', 0, 1, NULL, 253374, NULL);
INSERT INTO `sa_dictionary` VALUES ('8C94DDC67C2840D8871BB630E008FFCB', 'processManageNodeKind', '流程类别', '1395', 0, 1, NULL, 86493, NULL);
INSERT INTO `sa_dictionary` VALUES ('8E9E997A5FEB4287B30E6A6A65D83817', 'fieldTypeList', '字段类型', '1395', 0, 1, NULL, 86479, NULL);
INSERT INTO `sa_dictionary` VALUES ('9059', 'posLevel', '行政级别', '1395', 0, 1, NULL, 32524, NULL);
INSERT INTO `sa_dictionary` VALUES ('909D888B4AC661D7E050007F01005BD7', 'pubTempType', '模板类型', '1395', 0, 1, '中航国际-公共模板类型', 3552735, NULL);
INSERT INTO `sa_dictionary` VALUES ('91C5EC53E16F4B8697E17C02699ED33E', 'showModel', '显示模式', '1395', 0, 1, NULL, 86499, NULL);
INSERT INTO `sa_dictionary` VALUES ('91DF8F0A2683CD12E050007F01007C77', 'tempSourceType', '在线模板来源', '9', 0, 1, '中航国际-模板来源', 3562458, NULL);
INSERT INTO `sa_dictionary` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', 'editControlType', '控件类型', '1395', 0, 1, NULL, 135085, NULL);
INSERT INTO `sa_dictionary` VALUES ('9765', 'yesorno', '是否', '1395', 0, 1, NULL, 14834, NULL);
INSERT INTO `sa_dictionary` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', 'handleResult', '处理结果', '1395', 0, 1, NULL, 252241, NULL);
INSERT INTO `sa_dictionary` VALUES ('9D9822AA3DFF4B0FB84DEE0D501D1276', 'dictionaryKind', '字典类别', '1395', 0, 1, NULL, 98240, NULL);
INSERT INTO `sa_dictionary` VALUES ('ACCCC370E59E4F74B19B677D03114FA0', 'dataSourceKind', '数据源类型', '1395', 0, 1, NULL, 86472, NULL);
INSERT INTO `sa_dictionary` VALUES ('B4F33EA8EF2546F8A626ECAB8DA841A4', 'status', '状态', '1395', 0, 1, NULL, 86503, NULL);
INSERT INTO `sa_dictionary` VALUES ('B6F5801335AD4525B87668DD2634C063', 'orgFunctionKind', '机构函数', '1395', 0, 1, NULL, 86487, NULL);
INSERT INTO `sa_dictionary` VALUES ('CF4B535B1E914756B0FC688BEF6C94B9', 'orgKindStatus', '组织类型状态', '1395', 0, 1, NULL, 86489, NULL);
INSERT INTO `sa_dictionary` VALUES ('D5A465C4B9B643FD8D7EC6B94E90AF21', 'dictionaryStatus', '字段状态', '1395', 0, 1, NULL, 86475, NULL);
INSERT INTO `sa_dictionary` VALUES ('E9302BB1D5C74FC6999954EF535949AA', 'personSecurityGrade', '涉密等级', '1395', 0, 1, NULL, 270586, NULL);
INSERT INTO `sa_dictionary` VALUES ('F7D3A2AD863B48FC87F942D2A2C8125B', 'securityGrade', '密级', '1395', 0, 1, NULL, 103459, NULL);

-- ----------------------------
-- Table structure for sa_dictionarydetail
-- ----------------------------
DROP TABLE IF EXISTS `sa_dictionarydetail`;
CREATE TABLE `sa_dictionarydetail`  (
  `DICTIONARY_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `VALUE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  `TYPE_ID` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_dictionarydetail
-- ----------------------------
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '0073C130B0744F42B95C01CEEDF75940', '获取当前人员单位行政管理权限管理者', 'findCurrentPersonCenterAdminManager()', 1, NULL, NULL, 8, 347829);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', '0123B50A714C4D149B086A2DE651FC25', 'combox', '2', 1, NULL, NULL, 2, 135086);
INSERT INTO `sa_dictionarydetail` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', '02D7D5E92D01486587AEB992DDF96510', '系统完成', '5', 1, NULL, NULL, 0, 252240);
INSERT INTO `sa_dictionarydetail` VALUES ('D5A465C4B9B643FD8D7EC6B94E90AF21', '03368A5B74BB4BD3923AD8CAC8E8C6A4', '草稿', '-1', 1, NULL, NULL, 1, 81778);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '044D8A661AFC478B9A4604E5A4FCA47F', 'CodeBuildRule,folderId', '8', 1, NULL, NULL, 8, 98084);
INSERT INTO `sa_dictionarydetail` VALUES ('F7D3A2AD863B48FC87F942D2A2C8125B', '046505719CB043668837280D41CA6B0B', '秘密', 'SECRET', 1, NULL, NULL, NULL, 103453);
INSERT INTO `sa_dictionarydetail` VALUES ('1A3ECD959A8A464B8CF14630578D59C7', '06C8528AFC9E4E0B998B7D383CBCDC78', '启用', '1', 1, NULL, NULL, 1, 81791);
INSERT INTO `sa_dictionarydetail` VALUES ('F7D3A2AD863B48FC87F942D2A2C8125B', '08EEFFD994184A74B95F1AA8DF87EA3B', '机密', 'CONFIDENTIALITY', 1, NULL, NULL, NULL, 103454);
INSERT INTO `sa_dictionarydetail` VALUES ('726372', '09F5D59AEEFF4810A24109641817A6BB', '其他', '3', 1, NULL, NULL, 4, 775219);
INSERT INTO `sa_dictionarydetail` VALUES ('62279D8505584A91BF523813FCFF8344', '0B45D3440F204A6480321EFB0BAFCC8E', '学士', '学士', 1, '学士', NULL, 2, 270580);
INSERT INTO `sa_dictionarydetail` VALUES ('8C850449D9314D70A446361BC291150E', '0DAA500B3030461698C82BB28FFD3316', '系统', '0', 1, NULL, NULL, 1, 81988);
INSERT INTO `sa_dictionarydetail` VALUES ('739055A2A3D54C0AA5C06D848DA6334A', '0DBC7C5F3DE3416E85110CB757B18CB8', '业务权限', '2', 1, NULL, NULL, 2, 81993);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '1', '汉族', '1', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '10', '朝鲜族', '10', 1, NULL, NULL, 10, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10601', '10602', '核心层', '1', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10601', '10603', '中高层', '2', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10601', '10604', '中层', '3', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10601', '10605', '基层骨干', '4', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10601', '10606', '基层', '5', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '11', '满族', '11', 1, NULL, NULL, 11, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('634343', '11758B55A22F48BEAB963CC62D93C655', '审计员', 'auditor', 1, NULL, NULL, 4, 70093);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '11EE96BCC0B8442FB3320A16D633E7F0', 'Formula,folderId', '30', 1, NULL, NULL, 30, 104396);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '12', '侗族', '12', 1, NULL, NULL, 12, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1266292', '1266295', '欢迎', 'welcome', 1, NULL, NULL, 2, 1266302);
INSERT INTO `sa_dictionarydetail` VALUES ('1266292', '1266297', '文本', 'text', 1, NULL, NULL, 1, 1266303);
INSERT INTO `sa_dictionarydetail` VALUES ('1266292', '1266299', '图文', 'pic', 1, NULL, NULL, 3, 1266304);
INSERT INTO `sa_dictionarydetail` VALUES ('1266292', '1271373', '链接', 'link', 1, NULL, NULL, 4, 1271377);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '13', '瑶族', '13', 1, NULL, NULL, 13, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1317646', '1317648', '任务', 'task', 1, NULL, NULL, 1, 1317649);
INSERT INTO `sa_dictionarydetail` VALUES ('1317646', '1317650', '通知', 'notice', 1, NULL, NULL, 2, 1317651);
INSERT INTO `sa_dictionarydetail` VALUES ('1317646', '1317652', '抄送', 'makeACopyFor', 1, NULL, NULL, 3, 1317653);
INSERT INTO `sa_dictionarydetail` VALUES ('1317646', '1317654', '催办', 'remind', 1, NULL, NULL, 4, 1317655);
INSERT INTO `sa_dictionarydetail` VALUES ('F7D3A2AD863B48FC87F942D2A2C8125B', '13D0F8C53B7B4B7093C5BBA3239CB0AF', '绝密', 'TOP_SECRET', 1, NULL, NULL, NULL, 103455);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '14', '白族', '14', 1, NULL, NULL, 14, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '15', '土家族', '15', 1, NULL, NULL, 15, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '16', '哈尼族', '16', 1, NULL, NULL, 16, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '17', '哈萨克族', '17', 1, NULL, NULL, 17, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1405', '1781', '男', '1', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1405', '1782', '女', '2', 1, NULL, NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '18', '傣族', '18', 1, NULL, NULL, 18, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('ACCCC370E59E4F74B19B677D03114FA0', '188530A3A41B48A68C11D5DF3FAAD688', '数据字典', '3', 1, NULL, NULL, 3, 81979);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '19', '黎族', '19', 1, NULL, NULL, 19, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('E9302BB1D5C74FC6999954EF535949AA', '1ABF160C4D294BD6B794DB737BCF7273', '一般', 'COMMON', 1, NULL, NULL, 2, 270588);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '1C8DA2FF3016477A844FFD94B9FED39D', 'FlexFieldDefinition,folderId', '5', 1, NULL, NULL, 5, 107919);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '1D7CDBCF30784F4FA1D21A437EA04313', 'ExcelImportTemplate,folderId', '10', 1, NULL, NULL, 10, 98086);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '2', '蒙古族', '2', 1, NULL, NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '20', '傈僳族', '20', 1, NULL, NULL, 20, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '21', '佤族', '21', 1, NULL, NULL, 21, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '22', '畲族', '22', 1, NULL, NULL, 22, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '23', '高山族', '23', 1, NULL, NULL, 23, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '24', '拉祜族', '24', 1, NULL, NULL, 24, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '25', '水族', '25', 1, NULL, NULL, 25, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('E9302BB1D5C74FC6999954EF535949AA', '25CCD0FFBCCD41D880FACD6D94320DDF', '重要', 'IMPORTANCE', 1, NULL, NULL, 3, 270589);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '26', '东乡族', '26', 1, NULL, NULL, 26, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('7F0F082C3A8643D9829BAE5A8AC19F48', '262F3E4BA99941829E2FE9EACAB5DF50', '本组织', '1', 1, NULL, NULL, 1, 81961);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', '263F9E4B98584197A3C0D6543853AF82', '副部长', '2', -1, NULL, NULL, 6, 31510);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '27', '纳西族', '27', 1, NULL, NULL, 27, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '28', '景颇族', '28', 1, NULL, NULL, 28, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '29', '柯尔克孜族', '29', 1, NULL, NULL, 29, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '2A2D8DA74EB84A4BBCA536CFAE689018', 'SysParameter,folderId', '7', 1, NULL, NULL, 7, 98083);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '2CAEF6BA26684D9D9A1BFE3C953691EE', '指定单位管理者', 'findTechOrgCodeManagers(@orgCoe,\'manageType\')', 1, NULL, NULL, 9, 347857);
INSERT INTO `sa_dictionarydetail` VALUES ('067825F78AF5493E82ABF74FB1BEDEA2', '2D8F270478E941CB9391D67959B12EC5', '启用', '1', 1, NULL, NULL, 1, 82010);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '3', '回族', '3', 1, NULL, NULL, 3, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '30', '土族', '30', 1, NULL, NULL, 30, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '31', '达斡尔族', '31', 1, NULL, NULL, 31, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '32', '仫佬族', '32', 1, NULL, NULL, 32, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '33', '羌族', '33', 1, NULL, NULL, 33, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('0318D3F4E7F145469873708DED37391D', '33B23A1BD3CC4AB68ECC83A0C8B729EA', '普通', '1', 1, NULL, NULL, 1, 73785);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '34', '布朗族', '34', 1, NULL, NULL, 34, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '35', '撒拉族', '35', 1, NULL, NULL, 35, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '36', '毛难族', '36', 1, NULL, NULL, 36, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('B6F5801335AD4525B87668DD2634C063', '3635BE863D204922A398D895C34F5F39', '系统', '0', 1, NULL, NULL, 1, 81996);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '37', '仡佬族', '37', 1, NULL, NULL, 37, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '38', '锡伯族', '38', 1, NULL, NULL, 38, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '39', '阿昌族', '39', 1, NULL, NULL, 39, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', '3D1F9711223248BA967EFB88F43CF0FE', 'textbox', '1', 1, NULL, NULL, 1, 81965);
INSERT INTO `sa_dictionarydetail` VALUES ('8E9E997A5FEB4287B30E6A6A65D83817', '3E6D1A5D511242D78D2B88CE0F793BD8', 'date', '3', 1, NULL, NULL, NULL, 84017);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', '3E714F5C46EA402AB462B14C9CD6EEBC', '商业数据分析项目', '2', 1, NULL, NULL, 2, 253331);
INSERT INTO `sa_dictionarydetail` VALUES ('62279D8505584A91BF523813FCFF8344', '3EB0A0BC5F5D4DF7B85F725B2B09BBAB', '本科', '本科', 1, '本科', NULL, 3, 270581);
INSERT INTO `sa_dictionarydetail` VALUES ('634343', '3F937306B0D4416B80450B0A52AA7F0B', '管理员', 'administrator', 1, NULL, NULL, 5, 70094);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '4', '藏族', '4', 1, NULL, NULL, 4, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '40', '普米族', '40', 1, NULL, NULL, 40, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', '40CC9EB991034040A13C2C9FC308A90C', '分管领导', '4', -1, NULL, NULL, 4, 31512);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '41', '塔吉克族', '41', 1, NULL, NULL, 41, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', '41619ECD376A4F74B9F04E979473B396', 'radio', '6', 1, NULL, NULL, 6, 81970);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '4188EF96566546A1951A1044B40348E6', 'Customer,folderId', '35', 1, NULL, NULL, 35, 104470);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '42', '怒族', '42', 1, NULL, NULL, 42, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('424949', '424952', '成长型公司', '3', 1, '0', NULL, 3, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('424949', '424953', '领跑型公司', '2', 1, '0', NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('424949', '427174', '总部', '1', 0, '1', NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10592', '427179', '分公司', 'two', 1, NULL, NULL, 5, 5460239);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '43', '乌孜别克族', '43', 1, NULL, NULL, 43, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '44', '俄罗斯族', '44', 1, NULL, NULL, 44, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('91C5EC53E16F4B8697E17C02699ED33E', '44D61A1F14D2447897F57A1098EAE8B7', '表格', '1', 1, NULL, NULL, 1, 81983);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '45', '鄂温克族', '45', 1, NULL, NULL, 45, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', '4584E1EF22634124926AB3415D5E1945', 'SAP软件销售项目', '4', 1, NULL, NULL, 4, 253333);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '46', '崩龙族', '46', 1, NULL, NULL, 46, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '47', '保安族', '47', 1, NULL, NULL, 47, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('81F17B971A114700B7FD3B6C9E51307A', '4716C7DC797A4CAB95A514087C214030', '母公司', 'parent_company', 1, NULL, NULL, 0, 240991);
INSERT INTO `sa_dictionarydetail` VALUES ('10592', '4789114', '总部', 'one', 1, NULL, NULL, 7, 5336738);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '48', '裕固族', '48', 1, NULL, NULL, 48, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '48B1D56FA164408BB15A7600D303B860', 'Report,folderId', '62', 1, NULL, NULL, 21, 3577474);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '49', '京族', '49', 1, NULL, NULL, 49, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1A3ECD959A8A464B8CF14630578D59C7', '4CE302E2C3A84490896F67F4D19817C5', '禁用', '2', 1, NULL, NULL, 2, 81792);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', '4E98A9DE6DAE41DFAEE88713A8F5CF1A', '星期五', '5', 1, NULL, NULL, 5, 5380);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '5', '维吾尔族', '5', 1, NULL, NULL, 5, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '50', '塔塔尔族', '50', 1, NULL, NULL, 50, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '51', '独龙族', '51', 1, NULL, NULL, 51, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('7D48D910A4B840E8908FC572ABCC7B71', '51B8C5DB44094A58B1458BF3232D5707', '叶节点', '2', 1, NULL, NULL, 0, 155942);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '52', '鄂伦春族', '52', 1, NULL, NULL, 52, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('ACCCC370E59E4F74B19B677D03114FA0', '52679A5F389A4554B08F6E265855BEB9', '无', '1', 1, NULL, NULL, 1, 81977);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '53', '赫哲族', '53', 1, NULL, NULL, 53, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', '536436F051AC4615AD15392BECDA92F3', '开发型项目', '7', 1, NULL, NULL, 7, 253336);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '54', '门巴族', '54', 1, NULL, NULL, 54, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '540AB4FAE9124726A994A4DC907B995F', '查找流程实例申请人', 'findApplicant()', 1, NULL, NULL, 4, 347808);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '55', '珞巴族', '55', 1, NULL, NULL, 55, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', '55B3A34973B24C488D3C47EC3E7D870C', '员工', '1', -1, NULL, NULL, 7, 31509);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '56', '基诺族', '56', 1, NULL, NULL, 56, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '564E492D3F3644359A4D78EB2AFAFBD5', 'EnterpriseTemplateFolde,parentId', '32', 1, NULL, NULL, 32, 114647);
INSERT INTO `sa_dictionarydetail` VALUES ('CF4B535B1E914756B0FC688BEF6C94B9', '5834E85CA416405E89DBCC38EC49CC59', '禁用', '0', 1, NULL, NULL, 2, 81785);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '5A2E55303CBC4C8C9129A22484DF07C9', '获取指定单位管理者', 'findTechCenterManagers(@fullId,\'manageType\')', 1, NULL, NULL, 6, 347822);
INSERT INTO `sa_dictionarydetail` VALUES ('D5A465C4B9B643FD8D7EC6B94E90AF21', '5A8116A23BC549929780781A5342688B', '禁用', '0', 1, NULL, NULL, 2, 81780);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '5AB87B27F2DC48AAA94301A99B6FCCED', '获取当前人员的指定管理权限的管理者', 'findCurrentNearestManagers(\'manageType\')', 1, NULL, NULL, 7, 347828);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '5C0ACBBD9C0D44ECA4143644642D1EAF', 'UserGroup,folderId', '25', 1, NULL, NULL, 25, 98089);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '5C2937EDD15C44C99DE5D0D0520C5F4F', 'BaseManagementType,folderId', '17', 1, NULL, NULL, 17, 98087);
INSERT INTO `sa_dictionarydetail` VALUES ('6554A38109EA495786ECA295F53DEAAA', '5D4924E292C944E188C800D1B9D7D74D', '离异', '离异', 1, '离异', NULL, 3, 270575);
INSERT INTO `sa_dictionarydetail` VALUES ('F7D3A2AD863B48FC87F942D2A2C8125B', '5D64359163EC49F0904B7F878663AC44', '非密', 'NON_SECRET', 1, NULL, NULL, NULL, 103458);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', '5DA0DDB5CD6944FFA9DC7CCD7C5FB0C6', '星期一', '1', 1, NULL, NULL, 1, 5376);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', '5DAA9CEA490341EA8031C18F480E995F', '副总经理', '8', -1, NULL, NULL, 3, 31507);
INSERT INTO `sa_dictionarydetail` VALUES ('8E9E997A5FEB4287B30E6A6A65D83817', '5DD3F0AA2D02465D8E690D5B689DC8AF', 'bool', '5', 1, NULL, NULL, NULL, 84019);
INSERT INTO `sa_dictionarydetail` VALUES ('0318D3F4E7F145469873708DED37391D', '5E2F6B5F95F54719A334EBADF3DC4A77', '一般', '2', 1, NULL, NULL, 2, 73786);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '6', '苗族', '6', 1, NULL, NULL, 6, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6272913', '建筑', '1', 1, NULL, NULL, 1, 6272920);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6272915', '景观', '2', 1, NULL, NULL, 1, 6272916);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6272917', '装饰', '3', 1, NULL, NULL, 1, 6272918);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6297795', '机电', '4', 1, NULL, NULL, 1, 6297796);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6297797', '结构', '5', 1, NULL, NULL, 1, 6297798);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6322570', '给排水', '41', 1, NULL, NULL, 1, 6322571);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6322572', '暖通', '42', 1, NULL, NULL, 1, 6322573);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6322574', '强电', '43', 1, NULL, NULL, 1, 6322575);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6322576', '弱电', '44', 1, NULL, NULL, 1, 6322577);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '641E49892E4F4784BED508CF1480B893', 'ApprovalRejectedReason,folderId', '50', 1, NULL, NULL, 50, 98089);
INSERT INTO `sa_dictionarydetail` VALUES ('6272911', '6520835', '示范区', '99', 1, NULL, NULL, 1, 6520836);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', '664A5CF4B25645FA81E10B496AD7749C', '星期六', '6', 1, NULL, NULL, 6, 5381);
INSERT INTO `sa_dictionarydetail` VALUES ('91C5EC53E16F4B8697E17C02699ED33E', '67588F573ED74C0197592D0BAC83067C', 'DIV', '0', 1, NULL, NULL, 2, 81984);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '6854B61F41D9420FBFC5B6F5047CA3B4', '获取指定项目管理者', 'findPSProjectPerson(@projectId)', 0, NULL, NULL, 20, 348061);
INSERT INTO `sa_dictionarydetail` VALUES ('4C43956329A947278BA13F43E76E7FE2', '689E3D19FA771B46E050007F01003C19', '总体', 'zt', 1, NULL, NULL, 3, 1203028);
INSERT INTO `sa_dictionarydetail` VALUES ('4C43956329A947278BA13F43E76E7FE2', '689E3D19FA781B46E050007F01003C19', '分总体', 'fzt', 1, NULL, NULL, 4, 1203029);
INSERT INTO `sa_dictionarydetail` VALUES ('4C43956329A947278BA13F43E76E7FE2', '689E3D19FA791B46E050007F01003C19', '系统', 'xt', 1, NULL, NULL, 5, 1203030);
INSERT INTO `sa_dictionarydetail` VALUES ('739055A2A3D54C0AA5C06D848DA6334A', '69DBB109C9324A90BE1BB19A66C86A66', '分类', '1', 1, NULL, NULL, 1, 81992);
INSERT INTO `sa_dictionarydetail` VALUES ('634343', '6D4F7485008747B4AD36C0DA3BF08791', '超级管理员', 'superAdministrator', 1, NULL, NULL, 2, 70091);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '7', '彝族', '7', 1, NULL, NULL, 7, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '7219766ABB3347208BA7CF12C7F66A0A', 'MessageRemind,folderId', '15', 1, NULL, NULL, 15, 107914);
INSERT INTO `sa_dictionarydetail` VALUES ('726077', '726078', '读写', 'readwrite', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('726077', '726079', '只读', 'readonly', 1, NULL, NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('726077', '726080', '无权限', 'noaccess', 1, NULL, NULL, 3, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('726372', '726373', '主集', '0', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('726372', '726374', '子集', '1', 1, NULL, NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', '72925EBED1454703B2BFF2F058FE43D7', 'lookUp', '9', 1, NULL, NULL, 9, 81973);
INSERT INTO `sa_dictionarydetail` VALUES ('780205', '780206', '功能权限', 'fun', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('780205', '780207', '字段权限', 'field', 1, NULL, NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('780205', '780208', '按钮权限', 'button', -1, NULL, NULL, 3, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', '782E0FCD60314B51A02C8DFF76E0516F', '打回', '4', 1, NULL, NULL, 0, 252239);
INSERT INTO `sa_dictionarydetail` VALUES ('B4F33EA8EF2546F8A626ECAB8DA841A4', '78382CFB415048249E1A7A58E275533E', '禁用', '0', 1, NULL, NULL, 2, 362823);
INSERT INTO `sa_dictionarydetail` VALUES ('4C43956329A947278BA13F43E76E7FE2', '78F12454BD284A1FB76D07C390FD22ED', '一级部门', 'First', 1, NULL, NULL, 1, 1203026);
INSERT INTO `sa_dictionarydetail` VALUES ('6554A38109EA495786ECA295F53DEAAA', '7ADB40B99524419B99DF3C53602D31DE', '未婚', '未婚', 1, '未婚', NULL, 1, 270573);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '7C5B724E0383402D92FA2E10CF9026FD', 'I18nproperties,folderId', '55', 1, NULL, NULL, 55, 98088);
INSERT INTO `sa_dictionarydetail` VALUES ('ACCCC370E59E4F74B19B677D03114FA0', '7CC1A5D31693401E83C96CEB8F970782', 'JSON', '4', 1, NULL, NULL, 4, 81980);
INSERT INTO `sa_dictionarydetail` VALUES ('4C43956329A947278BA13F43E76E7FE2', '7E94A49B2BBA4FF891970AD642318464', '二级部门', 'Secondary', 1, NULL, NULL, 2, 1203027);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '8', '壮族', '8', 1, NULL, NULL, 8, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', '8054DAF161A8444FA8832BF21FA3BEA8', '其它项目', '8', 1, NULL, NULL, 8, 253337);
INSERT INTO `sa_dictionarydetail` VALUES ('726372', '809957', '按钮', '2', 1, NULL, NULL, 3, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', '81AD6DECE3ED43C8AD5F596C7E22C225', 'treebox', '10', 1, NULL, NULL, 10, 81974);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', '84F85DF2535F4EEBA284C946DB403D9E', '星期四', '4', 1, NULL, NULL, 4, 5379);
INSERT INTO `sa_dictionarydetail` VALUES ('067825F78AF5493E82ABF74FB1BEDEA2', '870161AAAFD44BEAA41CCE4CDCA90F73', '禁用', '0', 1, NULL, NULL, 2, 82011);
INSERT INTO `sa_dictionarydetail` VALUES ('8C94DDC67C2840D8871BB630E008FFCB', '872D39B8D2E8480296508E571BA1A462', '文件夹', 'folder', 1, NULL, NULL, 1, 81951);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '896595', '获取指定组织单元的管理者', 'findManagers()', 1, NULL, NULL, 1, 347809);
INSERT INTO `sa_dictionarydetail` VALUES ('CF4B535B1E914756B0FC688BEF6C94B9', '89A8E20780DF4865AA7002FB3E37C8F4', '启用', '1', 1, NULL, NULL, 1, 81784);
INSERT INTO `sa_dictionarydetail` VALUES ('7F0F082C3A8643D9829BAE5A8AC19F48', '8C340CB06787461A92E3D90079897497', '自定义组织', '2', 1, NULL, NULL, 2, 81962);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', '8CA6E5D06947436ABBDD4F70B69B01F0', 'SAP实施项目', '1', 1, NULL, NULL, 1, 253329);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '8DB2819CD55E44EAAEBDC82A61C61DD6', 'OrgType3,folderId', '3', 0, NULL, NULL, 3, 3577021);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', '8F59511A25BB4D38BC0D3970448E72B7', '系统集成项目', '3', 1, NULL, NULL, 3, 253332);
INSERT INTO `sa_dictionarydetail` VALUES ('1', '9', '布依族', '9', 1, NULL, NULL, 9, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '906353', '获取当前人员的行政权限管理者', 'findCurrentPersonMemberAdminManager()', 1, NULL, NULL, 3, 347817);
INSERT INTO `sa_dictionarydetail` VALUES ('909D888B4AC661D7E050007F01005BD7', '909D888B4AC761D7E050007F01005BD7', 'word', '1', 1, NULL, NULL, 2, 3561278);
INSERT INTO `sa_dictionarydetail` VALUES ('909D888B4AC661D7E050007F01005BD7', '909D888B4AC861D7E050007F01005BD7', 'excel', '2', 0, NULL, NULL, 3, 3561279);
INSERT INTO `sa_dictionarydetail` VALUES ('909D888B4AC661D7E050007F01005BD7', '91022A8DEC396AE2E050007F01002E63', 'ppt', '0', 1, NULL, NULL, 1, 3561280);
INSERT INTO `sa_dictionarydetail` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', '912965E172484C63AED5AF8F414AA20B', '已阅', '3', 1, NULL, NULL, 0, 252238);
INSERT INTO `sa_dictionarydetail` VALUES ('91DF8F0A2683CD12E050007F01007C77', '91DF8F0A2684CD12E050007F01007C77', '公共模板', '0', 1, NULL, NULL, 1, 3562341);
INSERT INTO `sa_dictionarydetail` VALUES ('91DF8F0A2683CD12E050007F01007C77', '91DF8F0A2685CD12E050007F01007C77', '个人模板', '1', 1, NULL, NULL, 2, 3574437);
INSERT INTO `sa_dictionarydetail` VALUES ('91DF8F0A2683CD12E050007F01007C77', '91DF8F0A2686CD12E050007F01007C77', '分享', '2', 1, NULL, NULL, 3, 3574438);
INSERT INTO `sa_dictionarydetail` VALUES ('634343', '92BFE2324652439A85EEB46A39A10BB2', '普通角色', 'common', 1, NULL, NULL, 1, 70090);
INSERT INTO `sa_dictionarydetail` VALUES ('B4F33EA8EF2546F8A626ECAB8DA841A4', '9332FDB7116049BD8995EF5A1BF518C3', '启用', '1', 1, NULL, NULL, 1, 362824);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '93B59D1F4A2E44F09798E17BD9742090', 'OrgType,folderId', '1', 1, NULL, NULL, 1, 107915);
INSERT INTO `sa_dictionarydetail` VALUES ('3C89377D4E384DD6876B38FEF86B7041', '94C4EED23D2842CB8E933BD733B125E9', '禁用', '2', 1, NULL, NULL, 2, 81958);
INSERT INTO `sa_dictionarydetail` VALUES ('9765', '9766', '是', '1', 1, NULL, NULL, 1, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('9765', '9767', '否', '0', 1, NULL, NULL, 2, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('8E9E997A5FEB4287B30E6A6A65D83817', '97BC44331AA34CE9822D9FAC65119F91', 'number', '2', 1, NULL, NULL, NULL, 84016);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', '9C35F090D8474008A549BA65F548C870', '获取指定组织单元最近的管理者', 'findNearestManagers(@personMemberId,\'admin\')', 1, NULL, NULL, 2, 347810);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '9CE8A02A2DEF42959R8B2376BA85162E', 'BmDataCollectionKind,folderId', '60', 1, NULL, NULL, NULL, NULL);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', '9E674A5E642B480A91ACE5222F4E1737', 'OrgType2,folderId', '2', 0, NULL, NULL, 2, 3577020);
INSERT INTO `sa_dictionarydetail` VALUES ('434B00E325504AEC9B2E8D2DB00BA123', '9F54B3DDAA234011AD2ED5068C6B45DA', '自定义流程', '2', 1, NULL, NULL, 2, 81876);
INSERT INTO `sa_dictionarydetail` VALUES ('62279D8505584A91BF523813FCFF8344', '9FD3CCA6EA544C16A818738F46783B36', '专科', '专科', 1, '专科', NULL, 4, 270582);
INSERT INTO `sa_dictionarydetail` VALUES ('634343', 'A787465417C146C8838103E3EA2F3726', '安全员', 'securityGuard', 1, NULL, NULL, 3, 70092);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', 'AA84822543E4463F95F577588F2B9FF3', '其它软件销售项目', '6', 1, NULL, NULL, 6, 253335);
INSERT INTO `sa_dictionarydetail` VALUES ('B6F5801335AD4525B87668DD2634C063', 'AC39BFAF98AC44CD8249E10F57D15E55', '自定义', '1', 1, NULL, NULL, 2, 81997);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', 'ACB0C9E59C784CD3AB2FA6723688615D', 'select', '8', 1, NULL, NULL, 8, 81972);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', 'ACCA56F52C2E495B924F77C9E1D5DFE1', 'Role,folderId', '4', 1, NULL, NULL, 4, 107918);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', 'AD0434A969E843D5B462E833F7464C75', 'Template,folderId', '31', 1, NULL, NULL, 31, 130342);
INSERT INTO `sa_dictionarydetail` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', 'AD2C20C232054DD5B8021B83775ABC81', '不通过', '2', 1, NULL, NULL, 0, 252237);
INSERT INTO `sa_dictionarydetail` VALUES ('427180', 'AD9B06BE8649446C8F37EED6ACD62EFA', '机构类型', 'orgAdminKind', -1, NULL, NULL, NULL, 24811);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', 'ADBC27AC26D3481B8639A49D871D2D05', 'spinner', '3', 1, NULL, NULL, 3, 81967);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', 'AF6126F7D5C74D22977DD1D950635561', '星期日', '7', 1, NULL, NULL, 7, 5382);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', 'AFECEC9462A541B480A267EEE9D17A5A', '部长', '3', -1, NULL, NULL, 5, 31511);
INSERT INTO `sa_dictionarydetail` VALUES ('62279D8505584A91BF523813FCFF8344', 'B225ED2551DC4093AE5A41CA80401F71', '博士', '博士', 1, '博士', NULL, 1, 270579);
INSERT INTO `sa_dictionarydetail` VALUES ('81F17B971A114700B7FD3B6C9E51307A', 'B308FFAAB0434EF28E59C6AE3518A54B', '子公司', 'sub_company', 1, NULL, NULL, 0, 240992);
INSERT INTO `sa_dictionarydetail` VALUES ('E9302BB1D5C74FC6999954EF535949AA', 'B3E189FB7FAB442D873B05AB1B66CCCF', '非密', 'NON_SECRET', 1, NULL, NULL, 1, 270587);
INSERT INTO `sa_dictionarydetail` VALUES ('6A4F9F6C7FCF4EAC8479AE6A79458541', 'B46F1BBB156D4C59BE8D03C8F181A44A', '分类', '1', 1, NULL, NULL, 1, 82001);
INSERT INTO `sa_dictionarydetail` VALUES ('434B00E325504AEC9B2E8D2DB00BA123', 'B672237B11204656B8BB631E2D6EE4F2', '全部', '1', 1, NULL, NULL, 1, 81875);
INSERT INTO `sa_dictionarydetail` VALUES ('8C94DDC67C2840D8871BB630E008FFCB', 'BBC3E957ED994B7691BAB8A3467D5EE2', '流程环节', 'procUnit', 1, NULL, NULL, 3, 81953);
INSERT INTO `sa_dictionarydetail` VALUES ('8C94DDC67C2840D8871BB630E008FFCB', 'BEDA643D8AA94FFAADA7B94F131F112D', '流程', 'proc', 1, NULL, NULL, 2, 81952);
INSERT INTO `sa_dictionarydetail` VALUES ('8E9E997A5FEB4287B30E6A6A65D83817', 'BFA34DD0FAEE43878861C3D560D95D4E', 'datetime', '4', 1, NULL, NULL, NULL, 84018);
INSERT INTO `sa_dictionarydetail` VALUES ('768E1E81BCF14DC78FC843EDBA4CF800', 'BFD7F2F0C54041CA94EF0F37F216C896', '启用', '1', 1, NULL, NULL, 1, 117126);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', 'C75C82B7E3444BA792691679C1BBAACF', 'date', '4', 1, NULL, NULL, 4, 81968);
INSERT INTO `sa_dictionarydetail` VALUES ('9D9822AA3DFF4B0FB84DEE0D501D1276', 'C7E2E003FF15405E8A964E63AF99DB24', '用户', '1', 1, NULL, NULL, 2, 81772);
INSERT INTO `sa_dictionarydetail` VALUES ('7D48D910A4B840E8908FC572ABCC7B71', 'C89BC2CD43284F7EA1A0F70AD47DF6CF', '文件夹', '1', 1, NULL, NULL, 0, 155941);
INSERT INTO `sa_dictionarydetail` VALUES ('10859', 'CA8F1057C95F4B54AE320E6DF7D06E68', '获取预算申报管理人', 'findBmManagers(@declareId,\'auditorType\')', 1, NULL, NULL, 21, 381648);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', 'CDEB6C8E3DC846998A28FE4D7FDEC357', '董事长', '7', -1, NULL, NULL, 1, 31514);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', 'CFA3CF5DC5874E62B07541C286105C48', 'AttachmentConfiguration,folderId', '21', 1, NULL, NULL, 21, 98088);
INSERT INTO `sa_dictionarydetail` VALUES ('9059', 'D164DA8CFCFC482E9FADC3CC99EE25F8', '总经理', '6', -1, NULL, NULL, 2, 31513);
INSERT INTO `sa_dictionarydetail` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', 'D3C311CA829B43AE8D180BEFCDA40CC0', '通过', '1', 1, NULL, NULL, 0, 252236);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', 'D485AB0B6C7A4880BED8039CFC8E12C4', 'SysDictionary,folderId', '9', 1, NULL, NULL, 9, 98085);
INSERT INTO `sa_dictionarydetail` VALUES ('3C89377D4E384DD6876B38FEF86B7041', 'D4BB7C933CD04D47A3E42CE4DE05A87D', '启用', '1', 1, NULL, NULL, 1, 81957);
INSERT INTO `sa_dictionarydetail` VALUES ('9D9822AA3DFF4B0FB84DEE0D501D1276', 'D56FD68CBDA64A05A0E3BC162365FA99', '系统', '0', 1, NULL, NULL, 1, 81771);
INSERT INTO `sa_dictionarydetail` VALUES ('768E1E81BCF14DC78FC843EDBA4CF800', 'D5AD8F18345941EB9606B860A3887025', '禁用', '0', 1, NULL, NULL, 2, 117128);
INSERT INTO `sa_dictionarydetail` VALUES ('31CD452985D940D6BFF9FF9F97C4B465', 'D83BA9FB31674B109A5D1C8A1DD4409C', 'TA软件销售项目', '5', 1, NULL, NULL, 5, 253334);
INSERT INTO `sa_dictionarydetail` VALUES ('F7D3A2AD863B48FC87F942D2A2C8125B', 'DDCE85728D9C44CB9093D71F5D06B7A0', '内部', 'INTERIOR', 1, NULL, NULL, NULL, 103452);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', 'E07738AA181B444387B918D97AA2B3A1', 'datetime', '5', 1, NULL, NULL, 5, 81969);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', 'E1078977E48B480CB457797A1FE5CA60', '星期二', '2', 1, NULL, NULL, 2, 5377);
INSERT INTO `sa_dictionarydetail` VALUES ('8E9E997A5FEB4287B30E6A6A65D83817', 'E135EA3E34B149D1B7B08F55CB7F854B', 'string', '1', 1, NULL, NULL, NULL, 84015);
INSERT INTO `sa_dictionarydetail` VALUES ('ACCCC370E59E4F74B19B677D03114FA0', 'E327B8C5EF554B248F43706380157240', '集合', '2', 1, NULL, NULL, 2, 81978);
INSERT INTO `sa_dictionarydetail` VALUES ('4188EF96566546A1951A1044B40348E6', 'E3A009A8BA7E4129A5FE6B097016980B', 'FlexFieldBizGroup,folderId', '6', 1, NULL, NULL, 6, 107920);
INSERT INTO `sa_dictionarydetail` VALUES ('D5A465C4B9B643FD8D7EC6B94E90AF21', 'E975D8BD284247019395AC8D32F1125D', '启用', '1', 1, NULL, NULL, 3, 81781);
INSERT INTO `sa_dictionarydetail` VALUES ('6554A38109EA495786ECA295F53DEAAA', 'EAFBADDD3D27464790A709040F4FBDEA', '已婚', '已婚', 1, '已婚', NULL, 2, 270574);
INSERT INTO `sa_dictionarydetail` VALUES ('6A4F9F6C7FCF4EAC8479AE6A79458541', 'EC547FC1B27648E4A3875A07C87069D2', '职能', '2', 1, NULL, NULL, 2, 82002);
INSERT INTO `sa_dictionarydetail` VALUES ('7AD5E72E0DEB43AFAC397454A3D97799', 'EF7F0D94C69D46298400F5C224806445', '星期三', '3', 1, NULL, NULL, 3, 5378);
INSERT INTO `sa_dictionarydetail` VALUES ('97689C902E99423DBA3E1D3E026C5FEC', 'F2BBAD7E581843FCA1F628994AFFFCAC', '未填写', '0', 1, NULL, NULL, 0, 252235);
INSERT INTO `sa_dictionarydetail` VALUES ('93C4964B13314B538DF44FC8AD3D3F90', 'F647B80D63864C57B8F47A6455A8BC2C', 'checkbox', '7', 1, NULL, NULL, 7, 81971);
INSERT INTO `sa_dictionarydetail` VALUES ('8C850449D9314D70A446361BC291150E', 'F755C2736A6F4337807C9C9B2E99599A', '自定义', '1', 1, NULL, NULL, 2, 81989);
INSERT INTO `sa_dictionarydetail` VALUES ('E9302BB1D5C74FC6999954EF535949AA', 'FAAE09463918400DBE02D637873D9180', '核心', 'CORE', 1, NULL, NULL, 4, 270590);

-- ----------------------------
-- Table structure for sa_excelimportlog
-- ----------------------------
DROP TABLE IF EXISTS `sa_excelimportlog`;
CREATE TABLE `sa_excelimportlog`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TEMPLATE_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BATCH_NUMBER` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FILE_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `ERROR_CODE` int(11) NULL DEFAULT NULL,
  `ERROR_MESSAGE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `FULL_ID` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `FULL_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `ORGAN_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ORGAN_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DEPT_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DEPT_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `POSITION_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `POSITION_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PERSON_MEMBER_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PERSON_MEMBER_NAME` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL,
  `ERROR_COUNT` bigint(20) NULL DEFAULT NULL,
  `SUCCESS_COUNT` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_excelimportlog
-- ----------------------------
INSERT INTO `sa_excelimportlog` VALUES ('0ED8572A9B2B4F8BA8FA03725D464B8A', '9561F43DBE054C768A9678F1E231EF00', '510518F7F13E4AEEA46931D5C2EDCF39', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572858905911_530.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:15:40', 0, 0, 3574492);
INSERT INTO `sa_excelimportlog` VALUES ('11A0E26B035F49AB8AFDE98A307E05E0', '9561F43DBE054C768A9678F1E231EF00', 'FE19BECC824C4376904789B817E08AA7', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859027699_860.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:18:49', 0, 0, 3574497);
INSERT INTO `sa_excelimportlog` VALUES ('19F9826CDB5849EEB118FE42BA1AA7C6', '9561F43DBE054C768A9678F1E231EF00', '4A0531B2C49A4DAAB1A1B3655F8178FA', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859492441_262.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:26:21', 0, 481, 3574541);
INSERT INTO `sa_excelimportlog` VALUES ('1C9DB8F2CBD44822AE1E9D297DCE3F43', '9561F43DBE054C768A9678F1E231EF00', '871B6DB1067D4A4CBA8A273A4EE3BC7B', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572856621426_311.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 16:38:43', 0, 0, 3574383);
INSERT INTO `sa_excelimportlog` VALUES ('2C3C653927694C42A7E6526648505AE3', '9561F43DBE054C768A9678F1E231EF00', 'BEF4BE34B0C34A24814D44E584EAEAF0', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572860017825_337.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:33:46', 0, 1, 3574577);
INSERT INTO `sa_excelimportlog` VALUES ('3E3334578A8C404792C2784F23D63529', '9561F43DBE054C768A9678F1E231EF00', '3099D9477C5B460E89F9FD04C3B6FA86', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572414449058_952.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-10-30 13:48:36', 0, 0, 3574248);
INSERT INTO `sa_excelimportlog` VALUES ('515DF6F3BCA7486AA47E4D4FEAD68ECC', '9561F43DBE054C768A9678F1E231EF00', '1B583BD174304934BFA577671E9EA22C', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859736791_75.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:29:10', 481, 0, 3574544);
INSERT INTO `sa_excelimportlog` VALUES ('7A9A71D435154619B1990F15C1AA2FBF', '9561F43DBE054C768A9678F1E231EF00', '623C0D78E9A74262957887C4736F8C7F', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859430333_661.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:24:25', 0, 481, 3574538);
INSERT INTO `sa_excelimportlog` VALUES ('7CBB80E939234D2B8DF75F3E285716DA', '9561F43DBE054C768A9678F1E231EF00', '7216FBC3A90E4A7CB5124FCB51828675', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859923448_674.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:32:43', 1, 0, 3574572);
INSERT INTO `sa_excelimportlog` VALUES ('842EC04B638642E7885003E97344F99A', '9561F43DBE054C768A9678F1E231EF00', '4DAB47A0693040238136FF53064FEE58', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859893569_528.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:31:33', 1, 0, 3574563);
INSERT INTO `sa_excelimportlog` VALUES ('987FD2291B9D4847B0723A8BBD08F50D', '9561F43DBE054C768A9678F1E231EF00', '72D654F6BCD54BE088721B339BFDB457', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859238526_740.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:21:14', 0, 481, 3574532);
INSERT INTO `sa_excelimportlog` VALUES ('C9BB5306F28A4FD0BB5E4A3F1179DF79', '9561F43DBE054C768A9678F1E231EF00', 'D7FD3F20DE8648D29340F81B994C840A', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572415457071_813.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-10-30 14:05:18', 0, 0, 3574251);
INSERT INTO `sa_excelimportlog` VALUES ('D8D3D2C3C82D46B186978694C5D248CF', '9561F43DBE054C768A9678F1E231EF00', '426EE2DDE92741E3B098453B3D92C52C', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572856400895_753.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 16:33:59', 0, 0, 3574343);
INSERT INTO `sa_excelimportlog` VALUES ('DC22C86E5683467A92862A3A28DC86AA', '9561F43DBE054C768A9678F1E231EF00', '13829A0BD3994A69BC167BE8145A5444', 'E:\\ide\\apache-tomcat-8.5.39\\temp\\1572859344895_163.xls', NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', 'C18E23AAAA6940E09DF7C122332C51E0', '初始化岗位', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '2019-11-04 17:22:59', 0, 481, 3574535);

-- ----------------------------
-- Table structure for sa_excelimporttemplate
-- ----------------------------
DROP TABLE IF EXISTS `sa_excelimporttemplate`;
CREATE TABLE `sa_excelimporttemplate`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CODE` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `TABLE_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `PROCEDURE_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL,
  `CREATED_BY_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_BY_NAME` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_excelimporttemplate
-- ----------------------------
INSERT INTO `sa_excelimporttemplate` VALUES ('6B4890DFB9BEB143E050007F01005CBD', '6B480BBA27C2FF74E050007F010057E3', 'i18nExcelImp', '国际化资源导入', 'TMP_SA_I18NPROPERTIES', 'i18nImportApplication', '2018-05-03 14:48:21', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', 1, 3229291, NULL, NULL);

-- ----------------------------
-- Table structure for sa_excelimporttemplatedetail
-- ----------------------------
DROP TABLE IF EXISTS `sa_excelimporttemplatedetail`;
CREATE TABLE `sa_excelimporttemplatedetail`  (
  `TEMPLATE_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `EXCEL_COLUMN_NUMBER` bigint(20) NULL DEFAULT NULL,
  `EXCEL_COLUMN_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COLUMN_NAME` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COLUMN_DESCRIPTION` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DESCRIPTION` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `LENGTH` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_excelimporttemplatedetail
-- ----------------------------
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '006D24B92AD4468B88B8456C44C44CD4', 11, 'responsible_person_id', '责任人工号', '责任人工号', NULL, NULL, 771569);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '080D2E7DF79741449C6769A6F1B0E788', 2, 'asset_type', '入库类型', '入库类型', NULL, NULL, 771560);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '09D15C4DFCC8445DA4D313D8635828F4', 9, 'storeman_person_id', '保管人工号', '保管人工号', NULL, NULL, 771567);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '0D6AE4DBB62343128EB18EEA2A41259F', 5, 'asset_status', '资产状态', '资产状态', NULL, NULL, 771563);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '12169A7C9AE64B00B5E005E497C7ED4D', 7, 'asset_achieve_classify', '资产取得方式', '资产取得方式', NULL, NULL, 771565);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '13B86AF795F644DA927ACA8E7878B518', 34, 'purchase_bill_code', '采购单编号', '采购单编号', NULL, NULL, 771592);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '1450265E71D44776AF94BFEC7E1CD1F5', 21, 'parent_asset_name', '父资产名称', '父资产名称', NULL, NULL, 771579);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '2358F7B9CA184A2CA34F41DAA37EB222', 24, 'produce_supplier_name', '生产商', '生产商', NULL, NULL, 771582);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '2E4FB1E5E3EA4D2F9FA7574718035CE5', 10, 'storeman_person_name', '保管人', '保管人', NULL, NULL, 771568);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '35F0A18119B04505A8881E2EE9BCBE41', 55, 'remark', '备注', '备注', NULL, NULL, 771615);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '37F9888A0A44423C8C3C4E2271357484', 3, 'asset_name', '资产名称', '资产名称', NULL, NULL, 771561);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '3D33C8CFA6F54391ACE76BB54F4FE2D8', 1, 'asset_source_type', '资产来源', '资产来源', NULL, NULL, 771559);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '40F9EE6A62DB4508B86B3144D8F341AF', 33, 'is_has_deadline', '是否有有效期', '是否有有效期', NULL, NULL, 771591);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '44AF5FB9510D4E53BEC2D9A78B65984D', 30, 'price', '单价/元', '单价/元', NULL, NULL, 771588);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '480E3C38B37A42A0AF038171C99B3B37', 35, 'operate_person_id', '申购人工号', '申购人工号', NULL, NULL, 771593);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '505A9A639495400E9543CA82F367B426', 51, 'financial_postingddate', '财务入账日期', '财务入账日期', NULL, NULL, 771610);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '5C7ED71E4F21455E93B8ECC510EAF97A', 29, 'end_use_date', '保修截止日期', '保修截止日期', NULL, NULL, 771587);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '60BE49EBD824466EA104364F2D38574B', 17, 'storage_address_code', '资产所在地点编码', '资产所在地点编码', NULL, NULL, 771575);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '62789598218D41258A867F3C4CC6E72F', 37, 'supplier_code', '供应商编码', '供应商编码', NULL, NULL, 771595);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '67AB7DC2C3C7435299EBA61509DF4838', 20, 'parent_asset_code', '父资产编号', '父资产编号', NULL, NULL, 771578);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '6B467A42558D4932B8BE62220D0D55D4', 43, 'duty_free_number', '免税单号', '免税单号', NULL, NULL, 771602);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('6B4890DFB9BEB143E050007F01005CBD', '6B4890DFB9BFB143E050007F01005CBD', 1, '编码', 'code', NULL, NULL, NULL, 1314672);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('6B4890DFB9BEB143E050007F01005CBD', '6B4890DFB9C0B143E050007F01005CBD', 2, '中文', 'value1', NULL, NULL, NULL, 1314673);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('6B4890DFB9BEB143E050007F01005CBD', '6B4890DFB9C1B143E050007F01005CBD', 3, '英文', 'value2', NULL, NULL, NULL, 1314674);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '6B8068A9CD6C4D57B98CF4F932B4F3D8', 15, 'own_center_id', '单位编码', '单位编码', NULL, NULL, 771573);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '6D249B469E5C45FA8F84E4BE525AF24F', 36, 'operate_person_name', '申购人', '申购人', NULL, NULL, 771594);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '6ED71DF4613F445884EBE3E4DDC7C47A', 53, 'dispatch_no', '档案号', '档案号', NULL, NULL, 771612);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '75D2235CEC024115AEE9C69154E59951', 49, 'country_subject_name', '国标分类名称', '国标分类名称', NULL, NULL, 771608);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '790ABF8AC8DD4176A01F265CD131AAAC', 18, 'storage_address', '资产所在地点描述', '资产所在地点描述', NULL, NULL, 771576);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '79DE5CB50DB94E56BC29B2CE01741633', 19, 'is_parts', '是否为增值', '是否为增值', NULL, 0, 771659);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '7AC65967C3C742EFA258869B9EEB5FD3', 47, 'funds_account_resource', '经费来源', '经费来源', NULL, NULL, 771606);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '8407489372BF459A95CF2F5451B2437A', 46, 'funds_account_id', '经费账号', '经费账号', NULL, NULL, 771605);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '8640BA171F994A1DAE16F3529A56BCDB', 28, 'start_use_date', '启用日期', '启用日期', NULL, NULL, 771586);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '8CA15B90A56A4754B53AEC6F599AFB95', 31, 'deadline_date', '有效期', '有效期', NULL, NULL, 771589);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '937EFB26BE6C4DF381274EAADED5B985', 41, 'purchase_contract_number', '国内合同号', '国内合同号', NULL, NULL, 771600);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', '9F490635D7ED40CD9B4B24722B8DEB87', 50, 'financial_document_code', '财务凭证号', '财务凭证号', NULL, NULL, 771609);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'A96F47B545564731BC44D8E248212C19', 39, 'invoice_numer', '发票号码', '发票号码', NULL, NULL, 771597);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'AF9E76A04ABB47F59C7EECC9A100A8D3', 22, 'brand', '品牌', '品牌', NULL, NULL, 771580);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'AFDBB75448A74E13B0146A362DC39DE5', 40, 'purchase_channel', '采购来源', '采购来源', NULL, NULL, 771598);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'B2F0F84BF42E4B26820168F1308C5BE8', 16, 'own_center_name', '资产所属单位', '资产所属单位', NULL, NULL, 771574);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'B4C9D797B3484559AE492CC368D25D5C', 25, 'country_code', '国别码', '国别码', NULL, NULL, 771583);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'BA551C0396CB4EC9A0E96E7B29E2C26E', 4, 'asset_code', '资产编号', '资产编号', NULL, NULL, 771562);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'BC67234680D14DE7B51652A80E77733F', 48, 'country_subject_code', '资产国标分类', '资产国标分类', NULL, NULL, 771607);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'BEAF0E99FDB744AC91D0C396460F18DC', 26, 'country_name', '生产国别', '生产国别', NULL, NULL, 771584);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'C41A4650ADB74ACE94F5CAE468D4E3FD', 12, 'responsible_person_name', '责任人', '责任人', NULL, NULL, 771570);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'C5CFF7D0ED004C40AAA978FB8149B92C', 13, 'own_organ_id', '机构编码', '机构编码', NULL, NULL, 771571);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'C6BB3E512A47417F989D60A375C835E1', 52, 'depreciation_amount', '折旧价值/元', '折旧价值/元', NULL, NULL, 771611);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'C6E0C770F9B54BB5A7963A0E7C6D85C3', 42, 'import_contract_number', '进口合同号', '进口合同号', NULL, NULL, 771601);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'CA25847B118E4636B2E46D4924F3CC69', 38, 'supplier_name', '供应商', '供应商', NULL, NULL, 771596);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'CD5E1D85D9DD42F680FF8E8B676EC3C5', 23, 'specifications', '型号规格', '型号规格', NULL, NULL, 771581);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'D2E0136FAD4D4C4BA99D3EC3988B099F', 6, 'apply_scope_type', '适用范围', '适用范围', NULL, NULL, 771564);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'E000A27FF89348F5BF933EE25643E075', 14, 'own_organ_name', '所属机构名称', '所属机构名称', NULL, NULL, 771572);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'E2940811E1E3465CB3B1F188F6EFD7AD', 8, 'asset_purchase_classify', '采购方式', '采购方式', NULL, NULL, 771566);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'E44817A672D041188DA1BF98A19CED1A', 45, 'funds_account_dtl_id', '经费账号行项目', '经费账号行项目', NULL, NULL, 771604);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'E55FE694363140B9B974018FEC21E4C2', 54, 'financial_asset_code', '财政资产编号', '财政资产编号', NULL, NULL, 771613);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'ECBCD81B444C4357A8DEAC2C87BB2496', 44, 'purchase_date', '购置日期', '购置日期', NULL, NULL, 771603);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'F7FFF37C91A048ED9EF7466E82FAAF1F', 27, 'storage_date', '入库日期', '入库日期', NULL, NULL, 771585);
INSERT INTO `sa_excelimporttemplatedetail` VALUES ('F9773A9476354B5F817092CE83B4817E', 'FE8B0B34F10440CA97099EA6928A181B', 32, 'concurrent_number', '并发数', '并发数', NULL, NULL, 771590);

-- ----------------------------
-- Table structure for sa_flexfieldbizgroup
-- ----------------------------
DROP TABLE IF EXISTS `sa_flexfieldbizgroup`;
CREATE TABLE `sa_flexfieldbizgroup`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CODE` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VISIBLE` int(11) NULL DEFAULT NULL,
  `BIZ_CODE` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `IS_DETAIL_TABLE` int(11) NULL DEFAULT NULL,
  `UI_STYLE` int(11) NULL DEFAULT NULL,
  `COLS` int(11) NULL DEFAULT NULL,
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `MODEL_FILE_PATH` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `ENTITY_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SHOW_MODEL` int(11) NULL DEFAULT NULL,
  `TABLE_LAYOUT` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_flexfieldbizgroupfield
-- ----------------------------
DROP TABLE IF EXISTS `sa_flexfieldbizgroupfield`;
CREATE TABLE `sa_flexfieldbizgroupfield`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FLEXFIELDBIZGROUP_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FLEXFIELDDEFINITION_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `NULLABLE` int(11) NULL DEFAULT NULL,
  `CONTROL_WIDTH` int(11) NULL DEFAULT NULL,
  `CONTROL_HEIGHT` int(11) NULL DEFAULT NULL,
  `READ_ONLY` int(11) NULL DEFAULT NULL,
  `VISIBLE` int(11) NULL DEFAULT NULL,
  `NEW_LINE` int(11) NULL DEFAULT NULL,
  `LABEL_WIDTH` int(11) NULL DEFAULT NULL,
  `COL_SPAN` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_flexfielddefinition
-- ----------------------------
DROP TABLE IF EXISTS `sa_flexfielddefinition`;
CREATE TABLE `sa_flexfielddefinition`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FOLDER_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FIELD_NAME` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DESCRIPTION` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FIELD_TYPE` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FIELD_LENGTH` int(11) NULL DEFAULT NULL,
  `FIELD_PRECISION` int(11) NULL DEFAULT NULL,
  `NULLABLE` int(11) NULL DEFAULT NULL,
  `DEFAULT_VALUE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MIN_VALUE` decimal(18, 2) NULL DEFAULT NULL,
  `MAX_VALUE` decimal(18, 2) NULL DEFAULT NULL,
  `REMARK` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `CONTROL_TYPE` int(11) NULL DEFAULT NULL,
  `CONTROL_WIDTH` int(11) NULL DEFAULT NULL,
  `CONTROL_HEIGHT` int(11) NULL DEFAULT NULL,
  `DATA_SOURCE_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATA_SOURCE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `READ_ONLY` int(11) NULL DEFAULT NULL,
  `VISIBLE` int(11) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `NEW_LINE` int(11) NULL DEFAULT NULL,
  `LABEL_WIDTH` int(11) NULL DEFAULT NULL,
  `COL_SPAN` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_flexfieldstorage
-- ----------------------------
DROP TABLE IF EXISTS `sa_flexfieldstorage`;
CREATE TABLE `sa_flexfieldstorage`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BIZ_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BIZ_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DETAIL_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FLEXFIELDDEFINITION_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FIELD_VALUE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `FLEXFIELDGROUP_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOOK_UP_VALUE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `SEQUENCE` bigint(20) NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `FIELD_NAME` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sa_historicsession
-- ----------------------------
DROP TABLE IF EXISTS `sa_historicsession`;
CREATE TABLE `sa_historicsession`  (
  `ID` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ORGAN_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ORGAN_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DEPT_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DEPT_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PERSON_MEMBER_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PERSON_MEMBER_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CLIENT_IP` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SERVER_IP` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOGIN_DATE` datetime(0) NULL DEFAULT NULL,
  `LOGOUT_DATE` datetime(0) NULL DEFAULT NULL,
  `LOGOUT_KIND_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOGOUT_PERSON_MEMEBER_ID` varchar(65) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOGOUT_PERSON_MEMEBER_NAME` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` bigint(20) NULL DEFAULT NULL,
  `FULL_ID` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `FULL_NAME` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `SESSION_ID` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOGIN_NAME` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ERROR_MESSAGE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `STATUS` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sa_historicsession
-- ----------------------------
INSERT INTO `sa_historicsession` VALUES ('00247a33-04c2-4021-9587-ecc1016075bd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-14 14:08:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('00af740d-91e0-4dca-a887-79192da40e68', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.197', '192.168.31.197', '2019-09-16 16:41:50', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('00c11fdf-5370-4454-b03d-10c47055c48c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 16:42:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('014fc868-a46c-4d85-afaa-83c902db6216', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 09:33:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0172f977-8606-46ba-9e3d-a6ded90e1703', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 10:22:15', '2019-09-20 11:09:58', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0196a3e3-f153-47b4-836b-84e1be917cce', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 13:56:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('01ab8c88-b330-4e83-b01d-e47dbe7a91ce', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-19 14:41:56', '2019-09-19 14:42:03', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('01c7fb66-49d3-42cb-9e5e-fc2dfe63a854', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.31.199', '127.0.0.1', '2019-09-17 15:35:51', '2019-09-17 15:36:35', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('01dd1da2-cd51-43a9-86e6-2718190c2c3b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 16:13:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('02065a72-d725-4721-9f5c-a8950037610e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 15:47:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('0295be07-0cde-477c-97ec-a09600a4c3ba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-16 20:58:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('031ac5ca-031c-466d-a8f4-59504cd9a8d3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 09:47:11', '2019-09-12 11:25:20', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('036e2478-3ce7-4b32-b2c9-580e81d199d7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 13:48:54', '2019-09-23 13:50:10', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('03a06c89-8481-4cb4-adb0-a9b282d3d8ad', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-30 13:46:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('03b1fcb0-ea56-4a33-acca-cf6eb19f4517', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.101', '192.168.122.1', '2017-11-15 16:54:57', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('03e81cfb-1ee8-496e-afd6-cfaa4552da3f', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.101', '192.168.122.1', '2017-11-15 10:55:20', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0436c278-4fea-4635-96bb-6f057f21d0a4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 10:52:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0475d160-91a7-4ea6-b486-5b902c7aa103', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.19.157.175', '192.168.122.1', '2017-10-13 22:17:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('049144d6-52ed-4b58-9703-e1505f89275b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-27 14:39:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('04a74c9f-c5ec-476c-b564-de3366ba147f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-24 11:45:49', '2019-12-24 11:56:28', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('052618d0-cc22-4db5-9daa-6cd4e5306dfa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-22 11:22:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('054741f4-824b-4707-97ce-0b0e4a0a5489', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 10:07:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('054ba6d2-92e1-422c-9da9-1573536ee051', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 11:49:45', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('05b6c5ff-84a8-4baa-b54d-a3131a5358a4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.4', '192.168.122.1', '2017-11-14 19:59:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('05c27126-fba1-4a30-aad2-908c35dec0f8', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-26 09:27:35', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('05d8c658-7ec9-44c4-8c01-11b9a4ac915c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-27 01:28:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('05e1b7dc-4bfb-4ade-a801-54770ab784aa', 'shanghaitech', '上海科技大学', '0107', '财务处', '100110@5C7117E6CE9D4125E050007F010057D5', '杨盈', '10.20.69.82', '192.168.122.1', '2017-11-13 11:13:12', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0107.dpt/5C7117E6CE9D4125E050007F010057D5.pos/100110@5C7117E6CE9D4125E050007F010057D5.psm', '/上海科技大学/财务处/管理岗位/杨盈', NULL, '100110', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('063d1a26-14ed-48c8-a96a-39b000158673', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-24 20:23:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0685c16b-a41d-4118-bcd5-9ce726079a30', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 15:25:14', '2019-07-22 15:25:30', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0696693d-b5c6-44be-80e0-c9a7ead718b0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-03 11:36:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('06aa3993-90bb-4427-861f-0cd869962792', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-26 16:29:13', '2019-07-26 17:24:48', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('06c902e3-7932-4fd9-b85d-601b8468556c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.156.217', '192.168.122.1', '2017-11-03 15:09:29', '2017-11-03 15:09:44', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('06e924a0-4dcb-487b-ab6a-166cddb6d289', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-09 17:07:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('06f0f8ff-a49a-421c-8200-73424ccb0aae', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.197', '192.168.31.197', '2019-09-16 15:47:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('07224cd7-b624-47f2-950e-e61790da84f9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.204.205', '192.168.122.1', '2017-11-15 11:26:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('07233493-f254-4e56-a95c-4d98612ef7ec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 15:59:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0770efb1-7687-44ea-8615-1cb6537e4c6c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2020-01-07 09:51:25', '2020-01-07 10:21:31', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('07a04053-4acf-42ab-ba21-ef57d08f14a3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-16 15:40:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administratoc登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('07ceaca7-f13d-4ec7-b864-59819cd3f7e6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-16 15:18:58', '2019-07-16 15:57:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('07e59ba2-ce1c-4ccf-8a97-fc4302e55ba2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 15:34:15', '2019-07-22 16:54:31', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('080ff46c-5820-426e-9ccb-1a1ffa3e6284', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 09:46:14', '2019-07-25 11:11:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('083c49b1-7371-4107-b013-db06c5f7e6e1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 14:35:33', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('088ba88e-52ef-449a-bca7-fa295f8f2980', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:35:02', '2019-07-08 11:35:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('08b9a8b4-f545-453d-a14f-7354387e9815', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 17:19:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('08eab1e8-26b3-4d3f-8f48-e712737c3183', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-22 10:00:38', '2019-07-22 10:05:49', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', 'lishang.dai登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('09384357-e0cf-4040-bd63-c25e0d6cee1d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.243', '192.168.31.197', '2019-09-16 16:56:41', '2019-09-16 16:57:41', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('09628cf9-ec42-4251-94bc-f760c92e5833', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-05 14:11:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('099cb528-38ee-4317-8e04-b044983ecd08', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 12:09:58', '2019-07-22 15:34:09', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('09e6a7e2-7649-4458-9218-4e50e5ea89dd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.30.1', '192.168.30.16', '2019-06-22 00:31:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0a8570f2-e6f4-4088-aeac-8b1fc9437c26', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-10 16:06:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('0ab29880-71d7-49c4-b26a-80bd348ee93e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.61', '192.168.122.1', '2017-11-14 19:36:19', '2017-11-14 19:37:59', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0ab7a9fb-8526-4c3a-9561-7cf22e942838', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 16:02:11', '2019-07-31 16:20:43', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0acb5228-7dfe-4145-a7b8-5b1a16edab88', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-18 09:31:07', '2019-07-18 10:46:19', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0adb26b9-885e-41f2-b40c-6a577b91d4ae', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 15:48:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0af6aaa6-d81f-4b68-a244-bee10d1e6a19', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '192.168.3.250', '127.0.0.1', '2019-08-06 17:59:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', 'lishang.dai登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('0afe6b8e-db73-47d6-9ebe-025fca0fa2d4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 15:04:47', '2019-07-22 15:05:53', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', '1008040登录，错误信息：用户或密码错误;108040登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('0b221d42-8532-4a85-b581-347e20c27e5a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-17 12:29:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0b3486f5-9ddd-49f9-855a-e436b3b722e8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.236', '192.168.122.1', '2017-11-07 08:47:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0b50d480-b741-41aa-85b0-0eda7f8f1d46', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.156.112', '192.168.122.1', '2017-10-26 19:18:54', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('0bd1462f-65be-4272-879f-a8d68774cb7c', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 13:23:25', '2019-09-23 13:24:53', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0c2d3314-08f7-47f3-9d10-bd69fe9b3e9d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-22 17:01:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0c572911-ef80-492e-ac18-0dfeddce7879', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 15:01:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0cbbb506-129a-4154-97e5-6910b55375f6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:37:12', '2019-07-08 11:37:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0d2ecd38-903a-4288-bb43-e140088c961b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-08 17:02:40', '2019-08-08 17:04:51', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0d537aa2-6391-45de-aaf6-b74621902979', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 22:35:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0dabc7f4-8bc4-4af5-ac12-115312d1dcb3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-26 10:08:16', '2019-07-26 10:12:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0e132c11-fdcc-41be-9413-e78827224e1c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.202.109', '192.168.122.1', '2017-10-18 11:06:30', '2017-10-18 11:06:48', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0e198699-0d31-4224-8abc-6269095c34e0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 10:20:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0e5c26d5-d00a-49db-8d69-3c1afa33820b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 10:24:41', '2019-09-23 10:26:46', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0ee64e14-ef35-40df-b3bf-a80a3ab81d2b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.35', '192.168.122.1', '2017-11-12 10:18:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0efb0b6e-fa14-4c10-bbc2-d2071d8994b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-13 18:10:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0f12a8ff-2511-4fbf-b5f4-e3dfb390a79e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-25 15:53:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('0f440774-2209-4697-addf-7059f63d00b4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 11:40:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('10040ca4-f510-48a0-9f08-81ae3e59e398', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-16 19:32:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'adminstatic登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('1018f311-534e-484c-8da2-23020cfc019a', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 10:29:36', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('10333dc7-c63e-4029-9f35-d7efc4f35199', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-27 09:53:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1035c111-8dab-4a46-8f33-1247de043a67', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-18 16:38:42', '2019-07-18 16:59:31', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('10527a58-eb1d-485e-9408-729b111a9dc7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-29 14:19:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('105a74c3-167a-4fae-8022-86dadfc84447', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.157.199', '192.168.122.1', '2017-11-06 09:05:23', '2017-11-06 09:09:07', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('106cc4db-05a4-47c0-8ee6-fa09c64d05e7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-24 00:34:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('107581a2-8b33-44cd-868d-3840d6035d8a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.122.1', '2019-09-16 15:56:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('108663f2-4a58-465a-b8cb-f4ced8fae11a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-18 10:46:29', '2019-07-18 14:04:16', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'Administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('10cf7065-166f-473e-9571-0baffe6f771c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.194.60', '192.168.122.1', '2017-10-10 08:25:10', '2017-10-10 08:28:08', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('10eaca2d-2425-493c-b34d-7014d186621b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-14 14:44:56', '2019-10-14 14:45:22', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1136f57f-836f-4580-af8b-e53b684b62ba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-06-28 18:11:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('11fe4c7e-8f98-4831-b6f3-89f352885878', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 14:38:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('121fd975-0ba7-4861-952a-a2f19b5b80d2', NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', '127.0.0.1', '2019-09-23 14:50:58', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'jiacheng', 'jiacheng登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('123a60df-1d0b-42ff-905f-84a523fa7e91', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-16 15:49:50', '2019-09-16 17:05:13', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1285f45d-3049-49e4-bbf8-09b01ca400b2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:35:09', '2019-07-08 11:35:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('12efe3d0-27a7-4729-adba-d1482cf54c2b', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 09:26:43', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1326d3cb-c92e-49ed-add7-fcaec82c97af', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.243', '192.168.31.197', '2019-09-16 15:28:28', '2019-09-16 15:54:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('132ccc57-4a6e-403a-8455-82e4e15bfb9b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-23 17:34:56', '2019-07-23 17:50:53', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('134e17cf-e2fc-4c1b-8e01-edf13c21de85', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.198.211', '192.168.122.1', '2017-10-30 10:37:20', '2017-10-30 10:37:35', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1398efe4-ec5f-45c9-bcd6-3c3eef4fa5dd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.217', '192.168.122.1', '2017-11-03 15:05:59', '2017-11-03 15:07:51', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('13d59a2f-52b1-4247-833c-0f10732df350', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 22:46:43', '2019-10-07 22:54:08', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('13f9eee4-8846-4308-a8c4-c99f5b90d8b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.205.146', '192.168.122.1', '2017-10-31 12:44:50', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', 'admin登录，错误信息：用户或密码错误;cs登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('141c541f-aa7f-4bd7-ad6f-8b005f671eb8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 11:26:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('144ed15e-585f-40fc-89ef-f5d21a09aaeb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.201.1', '192.168.122.1', '2017-10-30 17:46:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('149b135a-f998-4839-8ba0-2e0290599e0d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.202.73', '192.168.122.1', '2017-10-10 10:50:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;tester登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('14ae968e-3986-45fd-8923-9fa592ca8070', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 13:38:40', '2017-10-27 13:47:30', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('14cdb44d-5882-4ab0-a312-e6ef25cdfbbe', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.199.50', '192.168.122.1', '2017-11-08 11:10:01', '2017-11-08 11:10:04', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('14df1fc4-bfae-4620-bd43-a2f159335176', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 14:13:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('15437ddb-4a94-4fb2-8ca6-dd68a1eb4575', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-08 22:25:41', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('15937cef-ecc8-46b6-b6ad-0f4a8a8a353e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-13 09:28:37', '2019-08-13 09:35:06', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1598ee42-8248-47f0-ac68-86b13a558b6a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.207.160', '192.168.122.1', '2017-11-16 13:35:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('15a850a4-a55f-4284-9e1c-14458c11d7ea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 09:34:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('15e8f448-22c1-417a-8a22-230384ceeeca', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-13 11:41:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('16352e90-36cb-4e43-a062-46cc7aabe6c6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-16 10:31:25', '2019-10-16 10:32:09', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('16742286-834c-44c2-9fbd-78cc4472fba4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-21 11:28:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('167602bc-6133-4916-ac5f-f0e8a33179fd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-02 11:02:28', '2019-08-02 11:03:45', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1685fc51-4120-4cd2-b484-2dbb7af768c3', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 16:59:34', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('16f2b69b-c28a-47d1-982a-0272f27f7e7c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-23 11:26:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('17112fcd-2e5a-4002-b490-b56d262b31c1', 'shanghaitech', '上海科技大学', '0108', '公共服务处', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', '127.0.0.1', '127.0.0.1', '2019-07-03 14:38:56', '2019-07-03 14:46:42', 'NORMAL', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', NULL, '/shanghaitech.ogn/0108.dpt/5C7117E6CE814125E050007F010057D5.pos/100184@5C7117E6CE814125E050007F010057D5.psm', '/上海科技大学/公共服务处/管理岗位/胡玲玲', NULL, '100184', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('178c8e12-81b1-4997-b798-2a43202a4db5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-17 17:12:05', '2019-07-17 17:15:18', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('17a04713-e768-48cd-85d4-684b8efcd1c9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-24 16:50:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('17a1e748-9a18-41ef-b022-647ae8a922b8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 09:05:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('17ab7cee-dc4b-41fb-99f6-fa480202b1ab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 16:50:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('17f750de-79a7-4894-a58a-63f32d5630d4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-27 15:58:20', '2019-09-27 16:09:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('183615fc-594e-4d6b-9ea6-3cc159f384fb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.197.184', '192.168.122.1', '2017-10-11 16:25:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('188e1c02-db13-46e5-ac83-9dc0e9db1212', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-12 23:53:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', 'xiyushan登录，错误信息：用户或密码错误;ceshiyonghuyi登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('18a5bb9b-4495-4e2f-9ec4-1d76be91d2bc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-21 15:13:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('18ab2b91-8583-4e37-b37d-2eb6541029aa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-19 09:08:24', '2019-07-19 09:08:54', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1908c169-c450-486f-a63d-3463f343fde4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 10:31:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('19300187-a13f-4356-944a-26bd4998a03d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-07 14:17:04', '2019-08-07 17:03:16', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('19464b02-908e-497d-9759-af1a48aaf374', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-19 11:35:16', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('1976dbf5-613c-401c-9512-e7aab17b6152', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.200.248', '192.168.122.1', '2017-10-11 09:32:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1a188003-12c3-4170-a4a6-dafdb650176f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 21:25:56', '2019-09-30 21:39:07', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1a3be97e-cdf2-4512-a26f-0b338c40ea1f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 17:01:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1ac18e18-97f8-437a-992b-0e88df164488', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 13:51:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1b0683aa-5e54-45b4-bb65-6555771c0795', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 14:39:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1b1e1ea1-bf3c-4eb2-904f-ab07f8d3ce9e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 18:07:25', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1b21c7f4-7fd3-41c2-8344-c47ec14e2392', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-20 02:06:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1bac5892-e8b1-4ccd-8f83-61b33f5ffe3c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.11.128.29', '192.168.122.1', '2017-10-25 17:42:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('1bbf4c38-f70d-4433-bfb4-af10419a9389', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 13:51:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1bcb7e17-e23e-4a24-afb5-81399d2d446c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 22:08:35', '2019-09-19 22:16:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1c966844-3dd7-4816-9fd1-b33128135626', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-23 17:38:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1ce78f88-b800-4f17-9f3c-e1565b3ef5b0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-11 11:11:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1d0484a0-81ab-46cb-a435-f95abff3b4b9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 09:20:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1d4907f0-1f5a-4f03-8009-82a31d49a4e2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-14 14:52:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1d4c71b4-0eba-4938-b963-7a3e2873a93a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-20 11:05:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1d85d7fb-4866-4329-b108-080d54f93247', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 10:39:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1de80ff7-4cfb-4108-8e6a-09f05051ff40', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.240', '127.0.0.1', '2019-06-14 16:55:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1e2a6ce5-7a7d-4104-8ce0-c19eabc09dab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 15:19:47', '2019-10-12 15:36:23', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1e31f291-cb19-4ef2-939a-d35dfe0c2407', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-18 09:31:07', '2019-09-18 10:02:07', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1e4f055e-2a85-4317-9770-de8bf6b742cf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 09:11:59', '2019-07-05 09:12:11', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1eace7e8-de9d-4828-9b64-ece3207e80e7', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-09 16:37:47', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1eb72896-1729-4a92-94f2-0aa71300be95', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 18:05:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1ee3bf60-2a49-4d95-8953-2ec4f29ac318', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.64.170', '192.168.122.1', '2017-10-30 13:23:31', '2017-10-30 13:30:47', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1efb9e6d-e2d6-46fb-a330-edad64ad5f04', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-18 02:24:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1f8cc6d1-7e1e-4158-a86c-972aeede77d2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-18 23:09:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('1fb3b652-6cae-4164-ad86-2a5c89e53d9c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 17:15:22', '2019-07-17 17:15:39', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2034e306-04c7-4ab7-a24a-1b049428c945', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.194.60', '192.168.122.1', '2017-10-09 16:14:58', '2017-10-09 16:45:00', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2045b5c6-90b4-4f23-8896-560ee0dbaed4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 16:58:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('204da89d-38c3-4193-bb8f-20c843a211d0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 09:29:40', '2019-07-31 11:20:45', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('20a0cf07-bd7b-4b79-a594-6abc11a29ad6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-24 09:34:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('20e45597-95f3-4866-b973-77b40764ebbf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '单据填报人', '10.20.193.247', '192.168.122.1', '2017-11-14 18:25:37', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/单据填报人', NULL, 'bxr', 'bxr登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('210498a7-5a04-497a-8198-fd6eb4e643d5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5E17123168A376FFE050007F01006612@C18E23AAAA6940E09DF7C122332C51E0', '部门领导', '127.0.0.1', '127.0.0.1', '2019-12-24 11:56:44', '2019-12-24 12:32:39', 'NORMAL', '5E17123168A376FFE050007F01006612@C18E23AAAA6940E09DF7C122332C51E0', '部门领导', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5E17123168A376FFE050007F01006612@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/部门领导', NULL, 'bmld', 'bmld登录，错误信息：用户或密码错误;bmld登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('21877071-f4fa-44d9-bd49-e12eae75808d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-08-12 11:13:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('21e96941-c434-48ec-b22b-6d54ff58d83a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-30 10:47:13', '2019-07-30 16:21:21', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('22360166-6239-485e-8bad-a8ac6030cc9b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.180', '192.168.122.1', '2017-10-16 08:43:53', '2017-10-16 09:29:25', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('2255299e-ecc1-42f0-86d7-61811c73cad4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 09:12:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2266202d-db03-43ab-a0d7-76faed044b86', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-24 10:43:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('228f3bc4-6664-4c5b-8a98-b93d9cf1cf75', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 16:58:46', '2019-10-12 17:20:00', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('22a9f27d-7962-45ab-a874-fe7a06889b43', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.201.1', '192.168.122.1', '2017-10-30 13:25:41', '2017-10-30 16:51:25', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('22fed93f-aa83-43ce-904c-6146443789b2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 16:07:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('23c2b530-7992-4e25-b878-5c569a61c54a', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 11:28:29', '2019-09-18 11:28:57', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('23d79550-badb-4537-a07c-c58d6e4ed0d2', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 17:14:47', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('23ea7ed6-7b0b-46e3-b78e-fb0f23c2c061', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-20 18:15:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('23f332bc-3bd7-4fe5-8cd0-39b9901c39c8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 22:55:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('240f5c3c-b835-4708-86dd-edcf66523150', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 16:57:22', '2019-07-22 17:01:16', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('24282aa8-1cd0-432e-ac55-56f252ad8371', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 22:09:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('249314c3-a729-4301-8a93-da35a8a04281', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.194.26', '192.168.122.1', '2017-11-02 14:02:37', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('24cd0fa2-a8ea-457c-93be-9da12b4ac4cf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 11:14:58', '2019-07-25 11:16:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('24d1670e-51f3-4951-84bb-2fd18579ee39', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 19:14:01', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2547149f-c638-4e3e-b73f-f4bbdabd02aa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-30 16:38:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('25662f73-e891-4bc5-85bb-b973d8b96558', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-11-01 14:02:21', '2017-11-01 14:02:24', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('256ec564-c189-4fe9-9938-b4a783a4c1d1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 15:10:49', '2019-10-12 15:18:49', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('25a382e6-b65d-4bea-bcc5-059e9bc533f2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-17 10:15:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('25c2e427-1559-4b03-a364-edad612ccfac', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.66.29', '192.168.122.1', '2017-11-09 16:24:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2627fc45-2d87-42c2-aa3e-53f80a3e088d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-17 14:34:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administratoc登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('26349b79-9a06-400c-9f57-4fbcf1159c81', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 13:25:01', '2019-09-23 13:28:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('266d5fdb-2b71-4dd6-b330-9564ad38a1eb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 16:51:05', '2019-07-22 16:55:36', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('268e5daa-1490-474a-bc8d-e7e63fcdb797', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 17:52:10', '2019-07-08 17:58:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('26add469-04ef-452c-a491-0664ec30a747', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-24 13:57:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('26c32cb9-f5bd-4dff-bb24-652ef5e53cf5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-08 22:44:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('26d5a890-7d93-4ef1-97dd-ac40be28320f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 15:49:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('27110f2a-f4c0-4a57-bce4-fe05baab6f19', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 13:28:57', '2017-10-27 13:31:12', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('274053ee-5cfc-4d8a-bc3f-7c0b73ddb6ac', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.241', '192.168.3.51', '2019-09-23 21:57:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2744ef96-f754-4d6e-bf90-ae2fb1550cc9', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 09:45:04', '2019-09-18 10:11:23', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('275412c4-8b8e-449c-9fb3-d30dd3f9660d', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'E063FA370196429C848F251CC26B3F20', '规划发展部', '92208DB64620346BE050007F010012C2@3E05CFC4945A4262802B18041956866D', '李莎', '127.0.0.1', '127.0.0.1', '2019-09-29 18:04:54', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/E063FA370196429C848F251CC26B3F20.dpt/3E05CFC4945A4262802B18041956866D.pos/92208DB64620346BE050007F010012C2@3E05CFC4945A4262802B18041956866D.psm', '/中航国际/中航国际总部/规划发展部/员工/李莎', NULL, 'lisha', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('27a6c097-1ce0-4c39-adbd-1fbd068a83f2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 23:01:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('27c5377e-8cc3-4c33-8f37-4a73fdf04d2f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 14:58:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('27e554a6-d17e-48cd-aed4-f77137eb892c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 16:10:28', '2019-07-23 18:02:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('28445fe8-75ac-4bc9-abc7-ba0899326b27', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2020-01-07 10:21:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('28bda425-599a-4e39-8542-07974f1137a1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-25 13:55:28', '2019-07-25 14:01:04', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('28fd5a49-fa0c-4faf-aec4-27b5a9952bfc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.122.1', '2019-09-16 15:55:47', '2019-09-16 15:56:37', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('292b9962-98cd-468a-aa3d-02ebeafc3fc2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-16 13:32:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('294254c8-4449-486c-a0c3-aeeedc8fbec4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-16 14:59:42', '2019-10-16 15:00:04', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2962463b-7c45-49f1-81fe-6f3b7ca2eedc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 10:33:08', '2019-10-09 10:57:30', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2996e25f-67cd-4934-8a90-690aa04f8a50', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-25 11:12:18', '2019-07-25 13:56:48', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', 'lishang.dai登录，错误信息：用户或密码错误;lishang.dai登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('29d66e9b-1412-461c-8482-721c5221b2c3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.157.188', '192.168.122.1', '2017-10-27 15:08:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('29de61e2-b210-475f-914e-08c6e9ee7fe7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 14:26:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('29ecf8c0-5c2d-4fc7-86ec-fd847bc58ab5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:21:46', '2019-07-08 11:21:48', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2a1c785b-cdfe-437c-8500-05004286332c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 20:32:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2a69ab0e-820d-440d-a284-683bf09230c5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-11-11 11:51:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2a73afea-fa3b-4583-bb4a-029c45a9fbec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.217', '192.168.122.1', '2017-11-03 15:45:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2a7a0e0d-ea1d-4846-9f77-813eb087cd83', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-16 17:48:14', '2019-07-16 17:48:25', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2ab2a7df-0307-472f-9fb2-6962caf5f16f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.64.66', '192.168.122.1', '2017-10-26 10:33:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2ac473f3-fbe7-4a1d-a900-eb34413d580e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:17', '2019-07-08 11:34:22', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2aefc02c-fe60-41ce-9b3c-797492990541', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B', 'user', '192.168.56.1', '127.0.0.1', '2019-10-09 12:58:27', '2019-10-09 13:01:24', 'NORMAL', '607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B', 'user', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/0CBF734CE4184AF382831398B108941B.pos/607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B.psm', '/外部机构/测试使用部门/ETL供应商/user', NULL, 'user', 'user登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('2b580900-ad6d-438a-9f45-f6757c2443c7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-16 15:29:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2b587b04-1257-4614-ae3f-320d988d1642', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.235', '127.0.0.1', '2019-07-02 11:40:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2bc22110-0642-4af5-b110-011cc7997a2e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-27 10:11:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administer登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('2bd67f32-2a20-41f5-bb00-ba1efae5ac44', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 14:01:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2bf8ef0f-fb8e-46e6-b275-bd7c50e6dfdc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-18 14:05:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2c308ad8-5594-489f-88df-095ff6768385', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.3.51', '2019-09-18 17:17:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2c43d2cf-9d8e-4768-ae84-2967d069d822', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 10:03:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2cbe1dcf-0755-4807-851e-239cd9751388', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-08 09:36:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2cbec2e6-145e-4063-b098-533054905e5d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.7', '192.168.122.1', '2017-11-02 13:54:50', '2017-11-02 16:14:55', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('2cecade1-5307-4b18-a5a1-f8f8fe589b72', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-18 17:32:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2d4659bd-b68c-4a1c-8166-66c1f94d2a9e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 11:37:32', '2019-07-31 15:37:29', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2d77bd9c-0fd9-4e34-8bc2-ed14b368a9bd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.157.188', '192.168.122.1', '2017-10-27 15:06:30', '2017-10-27 15:08:04', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2db61ff0-cf1c-4893-8d05-11d7af975e6b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 09:19:19', '2019-07-23 14:35:07', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2de1d12a-b928-4fcd-909e-a99d7d44f545', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 21:39:13', '2019-09-30 21:42:45', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2de3575d-1d74-4d2b-b1a2-57f335176305', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 13:31:21', '2019-08-01 13:53:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2ded965a-08af-4c94-a0a7-21cc59ced68c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2020-01-06 17:48:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2df40487-d823-4ddf-969b-886ab857439c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.16', '192.168.122.1', '2017-10-27 09:40:08', '2017-10-27 09:40:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;adminstrator登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('2e089181-6274-47fb-b984-78f4fbcc0539', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-11-03 13:32:15', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2e3c2f06-3cc5-4c1a-9d89-8cc7cf2be517', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'D3C79FFF28FB4EAFA4E14D0D6CDF39C3', '信息化服务人员', '804BDC10B4C74994907333A3C881E7A4@E9299C3CC14A472199A0D2253E2F40B4', '黄洋', '127.0.0.1', '127.0.0.1', '2019-11-14 23:46:14', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/E40DB1E50C474F4B917E985235CC10F2.dpt/D3C79FFF28FB4EAFA4E14D0D6CDF39C3.dpt/E9299C3CC14A472199A0D2253E2F40B4.pos/804BDC10B4C74994907333A3C881E7A4@E9299C3CC14A472199A0D2253E2F40B4.psm', '/中航国际/中航国际总部/信息化推进办公室/信息化服务人员/员工/黄洋', NULL, 'huangyang', 'yuantao登录，错误信息：用户或密码错误;yuantao登录，错误信息：用户或密码错误;yuantao登录，错误信息：用户或密码错误;yuantao登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('2e6540d6-ec91-4014-ab40-3a38da55ffd2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.240', '127.0.0.1', '2019-06-14 15:08:19', '2019-06-14 16:55:27', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;superAdministrator登录，错误信息：用户或密码错误;Administrator登录，错误信息：用户或密码错误;Administrator登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('2e66e484-9291-4e1f-95cb-83bde7e6e5a5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-08 18:22:37', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2e748549-01d6-4bd5-9714-70f8a95e9195', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-16 15:40:52', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2e8dabb4-b13c-45da-8127-24cd43ac7508', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.156.217', '192.168.122.1', '2017-11-03 15:02:52', '2017-11-03 15:05:51', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2eb99cc2-0acf-47ce-b04b-e8215283bd32', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-02 10:11:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2ecb9044-82b3-4a4e-923d-e1cc54a93eaa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.194.60', '192.168.122.1', '2017-10-10 15:19:27', '2017-10-10 15:21:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2f34481c-a35f-4055-9601-6cce7b0bc225', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 14:26:51', '2019-10-10 14:27:25', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('2faee46b-4428-4855-a9f1-889582032a56', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-16 20:26:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('30050f13-925e-4f38-bc71-ef7f6524ef42', 'shanghaitech', '上海科技大学', 'AC0F9895383D4F10908393C6146438CA', '吴晓燕部', '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '吴晓燕', '127.0.0.1', '127.0.0.1', '2019-07-03 17:34:03', '2019-07-03 18:06:52', 'NORMAL', '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '吴晓燕', NULL, '/shanghaitech.ogn/0108.dpt/AC0F9895383D4F10908393C6146438CA.dpt/15A70AA00CD14296A27315F1A2EB51D4.pos/6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4.psm', '/上海科技大学/公共服务处/吴晓燕部/吴晓燕组/吴晓燕', NULL, 'wuxy', 'wuhy登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('300e2a46-b333-4c52-ab15-faa5f67c9094', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.30.1', '192.168.30.16', '2019-06-21 00:43:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('305c87d7-c1cb-4f80-957c-f1d965469440', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.35', '192.168.122.1', '2017-11-12 10:14:01', '2017-11-12 10:15:39', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('309a3282-aab9-4c54-88ae-69b4d4b6a386', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.156.76', '192.168.122.1', '2017-11-08 23:10:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('30bfc075-999f-4558-bbb7-d5fc2b2b7620', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-07 17:03:24', '2019-08-07 17:04:29', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('30e42ab0-3dda-4c1c-b029-36969a85315d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 15:05:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('30f3da83-3d62-4487-b6d7-8644f8265ebd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-08 17:10:17', '2019-08-08 18:10:05', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('30fd1771-e417-475d-912b-e9f12f38ef89', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-01 16:28:09', '2019-08-01 17:10:12', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('310856ac-b539-4a90-8887-a1134476d51e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 09:19:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('312956b7-3f98-4208-b1f0-f4acdfecc366', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 10:43:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('31459d6f-2514-44cf-8b96-edd7d6460e73', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.199.203', '192.168.122.1', '2017-10-13 11:17:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('31962497-694b-470e-8b59-967ab815fbdc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 13:10:01', '2019-09-20 13:15:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('32179cef-1f31-4124-b070-4a0846d6f415', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 09:40:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('32a5ac6a-ec2e-4762-bb04-9ab2bc678d3b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:27:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('32b2f83e-6f46-4801-859a-f5d0e8fa123c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-19 15:42:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('33a0cb0e-494f-4ed7-9bde-888b0250198a', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 19:10:13', '2019-09-17 19:13:56', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('33ae61c9-136c-44d0-b674-533300b27223', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 23:19:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3447f794-249c-40a6-86a1-5c500faf1c35', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.198.211', '192.168.122.1', '2017-10-30 11:11:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('345387ec-e2cb-43b3-bdf2-47f6e3f9c1c7', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.64.66', '192.168.122.1', '2017-10-27 09:09:30', '2017-10-27 14:04:52', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('352cc9c1-1714-4807-8c74-f9f128ea2042', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-14 14:53:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('35ca343e-45c7-422f-9ce9-235704e62837', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-23 22:45:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('35d61acb-5b92-4ae2-a657-7fa5fc06edf0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.199', '127.0.0.1', '2019-09-17 10:49:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('35dc8a1a-e584-46d4-ab71-9079d8db247a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.157.188', '192.168.122.1', '2017-10-27 14:32:05', '2017-10-27 14:32:58', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('35e8a7cd-f2fb-4b8c-bc5f-5d808fd22781', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-26 14:52:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('365ee12e-3367-4809-98f1-8da28f0cf5ab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-24 18:04:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('36d9989b-9320-49b3-8a5b-5144f9b302d9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 18:24:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('36fd6a3c-0c84-43d3-a94b-7d126c112b68', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-24 16:50:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('37174cce-8cc6-41ad-a933-56c76ab7a857', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-23 10:29:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('37306274-4bed-466b-8be2-063b808449f2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-04 15:54:09', '2019-07-04 16:00:12', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('374f28eb-6909-47a6-8819-3bc3f4b4ee2a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.243', '192.168.31.197', '2019-09-16 15:28:06', '2019-09-16 15:28:13', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('377fcda7-ae61-44cf-9502-d42930ad3ae0', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '192.168.3.250', '127.0.0.1', '2019-06-20 17:52:34', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('37ef243c-b761-4807-b50c-9981fcc74e20', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-13 15:44:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('382eb3e9-1123-4ea2-b01a-265906b1b9e4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 16:22:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('38383e94-537c-4ba0-bf27-c0a7d454f615', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.64.66', '192.168.122.1', '2017-10-27 15:25:02', '2017-10-27 15:32:03', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('386b1034-1988-4564-a9d5-0a985037b852', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-23 15:20:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('387eff96-5871-4b0a-997f-b85460d75e10', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-16 16:03:32', '2019-07-16 16:51:11', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('38f7582a-a964-4e22-a038-8a2a4a9ee311', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 09:57:07', '2019-07-19 10:03:54', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('38fa0751-f477-4c96-9758-9308f9aeaa11', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 15:51:57', '2019-09-23 15:52:22', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('390f1435-4201-4c48-aeaf-763181718286', NULL, NULL, NULL, NULL, NULL, NULL, '10.20.207.18', '192.168.122.1', '2017-10-27 15:22:44', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('39539166-e9a4-4305-901f-2ee53b5cf046', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-16 14:06:00', '2019-07-16 15:09:35', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('396c650b-5875-4dc6-8b1d-e7a214ebb76c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-17 17:00:01', '2019-07-17 17:10:19', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('39743b97-d6ac-4b08-8895-8af7ef5e293e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-30 11:16:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('39b3d8af-ebd6-4c25-9d4e-b57074cd1ce5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-24 09:34:11', '2019-07-24 16:47:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('39baf7a2-8a39-4985-a4b2-bfcafd0eab1a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-17 14:29:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3a0c99c4-275a-49ab-a943-93a31340b333', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-04 17:21:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3a49cdb0-8a2b-474c-8e6d-cd1908c39e6f', 'shanghaitech', '上海科技大学', '0109', '基建管理中心', '8B45CB8C8875A315E050007F010058E2@5C7117E6CE9F4125E050007F010057D5', '子君', '192.168.3.234', '127.0.0.1', '2019-06-17 11:17:09', '2019-06-17 11:26:48', 'NORMAL', '8B45CB8C8875A315E050007F010058E2@5C7117E6CE9F4125E050007F010057D5', '子君', NULL, '/shanghaitech.ogn/0109.dpt/5C7117E6CE9F4125E050007F010057D5.pos/8B45CB8C8875A315E050007F010058E2@5C7117E6CE9F4125E050007F010057D5.psm', '/上海科技大学/基建管理中心/管理岗位/子君', NULL, 'zijun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3a5bfea0-b62d-4859-8df4-0cb37921faba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-15 17:06:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('3a624ef0-06c7-4988-9327-0ab16dd14c8d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-16 10:32:47', '2019-10-16 10:33:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', 'yelin登录，错误信息：用户或密码错误;yeling登录，错误信息：用户或密码错误;yening登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('3affe7c6-27f6-4daf-8f15-a40b5469c7e9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 14:34:01', '2019-10-09 16:42:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3b183d8a-bed4-4904-8637-f1c4465ffe6f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-08 22:45:42', '2019-10-08 22:56:37', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3b439d9b-da2a-46c0-9b34-844cd29679cc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.180', '192.168.122.1', '2017-10-16 10:34:02', '2017-10-16 10:39:40', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3ba22708-32de-462f-87cf-dc9690d5b00f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-05 15:36:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3bc6ce54-5b53-40c6-957e-9ac0eb37e179', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-09 09:56:09', '2019-08-09 15:44:23', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3bca9cd2-6975-4ade-9ec4-c4ca3067cc1f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:36:05', '2019-07-08 11:36:10', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3bd1c36a-8e65-463b-a1fe-87d8390c93e9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 16:06:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3bdb34c9-4484-4d04-bc7c-2e4544606a67', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-25 14:40:30', '2019-07-25 14:42:48', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3be0f25e-8d22-4597-a826-197ca8d8cdb4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.13', '192.168.122.1', '2017-10-29 17:08:25', '2017-10-29 17:08:35', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3bec0e71-2df3-4c3a-afba-ce0ae1953ed6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-08 18:04:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3c0c5821-f096-4dd2-91f1-e81ecfeebdbd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.157.188', '192.168.122.1', '2017-10-27 15:08:27', '2017-10-27 15:08:31', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3c7ee133-240a-492d-b75a-715ab6d39df4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 18:11:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', 'lishang.dai登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('3c7f6dc5-7cb7-4b9b-bfcc-7398b49c25b9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-23 16:09:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3c8d71e9-b2a5-4acf-8f1c-87f4f88b4ca6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 15:27:05', '2019-07-22 15:32:55', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3cce3963-d810-49d3-b77c-ad35d4c02654', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-26 09:27:07', '2019-09-26 09:27:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3d7b1da7-6adc-4148-b2c6-0616444d35ee', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.180', '192.168.122.1', '2017-10-16 12:23:50', '2017-10-16 12:23:58', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3d892678-d1f3-48d0-8a09-6a22fdac5976', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 13:52:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3dc5a85a-31c8-4e2f-ae3b-2924970a2c08', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 14:14:04', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3e174ea2-d704-424d-b489-05f24f70c382', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 16:27:04', '2019-09-17 16:52:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3e4ab4a8-77b6-4820-8859-aec52b743e81', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 15:46:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3e502f9b-c3ff-4a3b-b627-4977f453aa17', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-13 22:14:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3e606d9d-33aa-4836-9da0-1a021a15bbbc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9C23A34E91064D5689F0E2B26F8CCC50', '外部部门', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', '192.168.3.240', '127.0.0.1', '2019-06-14 16:55:38', '2019-06-14 16:55:45', 'NORMAL', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/9C23A34E91064D5689F0E2B26F8CCC50.dpt/BE63FABAF205467788621D9695ED09D7.pos/8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7.psm', '/外部机构/外部部门/初始化岗位/子君', NULL, 'zijun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3eb0d216-cd38-4ee3-8506-55a594c8590f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 15:02:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3f07ae2b-e70d-4552-903d-8913326e6dff', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-04 09:48:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3f20ba55-1bf7-41ff-923c-1eabac0794ab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.180', '192.168.122.1', '2017-10-16 09:29:33', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3fb25851-7053-40db-951d-2161fb9faa83', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.207.65', '192.168.122.1', '2017-11-09 13:57:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3fb2c882-034d-4c21-a8b6-d475630066b9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.180', '192.168.122.1', '2017-10-16 10:39:48', '2017-10-16 12:23:23', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3fb30ea0-ef57-4326-b1b2-d2f79547805f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 13:52:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('3fc7d538-e8ef-48e6-aa09-0a16fec5534a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.122.1', '2019-09-17 20:55:26', '2019-09-17 21:02:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('409e4d9a-f1f5-4145-94ab-b957d25ea6da', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 15:25:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('40dc9fa6-de38-453e-9f89-45b9e123f46a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 18:39:59', '2019-09-19 19:31:56', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('40f602cd-7dce-45aa-8799-ef3c5ba18e04', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-13 00:37:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('411aeab8-1aa2-4b34-bc30-c61913e54f23', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 09:14:35', '2019-07-31 09:29:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('41250393-8c01-4ef2-b44a-dc0d2bd80011', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.206.195', '192.168.122.1', '2017-11-15 16:28:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('413c3967-e609-4404-bbfa-83e10de00587', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-06 18:01:51', '2019-08-06 18:08:41', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('418f9740-2ccc-4a7a-a381-db336dc4fa94', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 15:19:04', '2019-09-23 15:24:39', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('41ac7af9-4413-4988-be75-5a400db96244', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.204.62', '192.168.122.1', '2017-10-31 08:38:21', '2017-10-31 11:10:34', 'NORMAL', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('42036380-20df-4c1a-a896-02d2178c14ff', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-19 09:21:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('42401172-b0f7-4979-a318-6d37368193b9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.13', '192.168.122.1', '2017-10-29 16:55:13', '2017-10-29 16:55:35', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('426ffb59-0c86-41bd-8f3c-31568dd304ad', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 08:54:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4278c5dd-4ca8-4579-accb-e80f9def9ab3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 17:58:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('42ac0d0a-8400-4444-bff3-b24d2e7b8d1e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.64.66', '192.168.122.1', '2017-10-27 15:19:35', '2017-10-27 15:19:47', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('42c3a41d-2e6a-4754-9ee3-083f2a7204df', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-16 15:09:44', '2019-07-16 15:11:48', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('430fab44-2b59-4f19-8586-3018f296d2c8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 17:35:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4391ebc2-34bd-4f0c-acc7-05b988fc6b58', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 15:33:04', '2019-07-22 16:50:26', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4392f296-3ccb-4cb2-af72-09160286491e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.198.21', '192.168.122.1', '2017-11-08 13:35:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('441e9e88-d0e6-4c69-913b-826917b08ab8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-14 22:06:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('44237d41-df59-4410-84b8-b33ea1ed5c40', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.64.170', '192.168.122.1', '2017-10-30 11:31:04', '2017-10-30 13:05:05', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('447a487b-3eb0-4762-834e-7439eacb5012', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:36:40', '2019-07-08 11:36:45', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('44863c7a-ff47-47f5-8515-ea85157a209a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 12:40:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('44bae061-b79d-4030-9807-65d792e0e20e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-05 14:08:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('44ce9f47-2421-4783-896d-38a20304fe85', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.217', '192.168.122.1', '2017-11-03 15:09:51', '2017-11-03 15:45:24', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('44e32e99-312c-4f1d-a453-0bdfadbcbf36', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.157.188', '192.168.122.1', '2017-10-27 14:33:07', '2017-10-27 15:06:01', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('44eace0e-2723-452a-9e64-9d10e7873786', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-23 09:32:54', '2019-07-23 09:33:59', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', '100804登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('45008861-cf21-46ec-b3ed-c0c19cf2f90d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.238', '127.0.0.1', '2019-07-09 09:34:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('45694ec2-f82f-413e-a5f5-7892d46a24f8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.19.156.175', '192.168.122.1', '2017-10-17 18:46:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('457cdff5-b93b-4374-8082-f80ec35ed7f2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9C23A34E91064D5689F0E2B26F8CCC50', '外部部门', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', '192.168.3.240', '127.0.0.1', '2019-06-14 16:56:48', '2019-06-14 16:57:50', 'NORMAL', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/9C23A34E91064D5689F0E2B26F8CCC50.dpt/BE63FABAF205467788621D9695ED09D7.pos/8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7.psm', '/外部机构/外部部门/初始化岗位/子君', NULL, 'zijun', '瀛愬悰登录，错误信息：用户或密码错误;瀛愬悰登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('45aaa78b-016b-48cf-9d43-cee5d2503860', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 14:42:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('45d317ce-e773-41e8-8d3c-1d810981885e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.197', '192.168.31.197', '2019-09-16 13:53:50', '2019-09-16 14:10:05', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('466d4ee8-9c70-40bc-a9b3-9e4593813a11', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-21 10:31:43', '2019-08-21 11:13:38', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('46acf2aa-954d-4341-ba36-bf4997e100d3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-24 11:26:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('46c3f073-bd0c-463f-b641-60f05d6d2ef6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-12 17:16:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('46e522bc-c010-42f1-b7e5-d147d9bd6e7d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '192.168.31.197', '2019-09-16 09:15:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('46ef393a-5d03-4330-82b2-c8b7198193a2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.12', '192.168.122.1', '2017-11-13 23:02:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('474c9054-af67-4b82-abec-8bb60c5b75df', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 09:09:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4771fee2-a506-4f0f-b0b0-a80fed4163e7', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.19.157.25', '192.168.122.1', '2017-10-29 08:55:19', '2017-10-29 08:55:26', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('47b384d3-7080-4077-9da7-8626d13aeb7b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:27:11', '2017-11-01 09:27:15', 'NORMAL', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', 'testjs020登录，错误信息：用户或密码错误;testjs020登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('4820bdf6-62aa-456f-9b1f-26c59641ca3b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-11-11 13:58:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('48917bb9-5aeb-4007-ba9b-0e5beb40e632', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-29 09:29:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('48f127dd-e3a7-4fd6-aca9-9dc8ad0c28fb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 15:06:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4910eb58-dc23-4fcb-bb1f-8db950472919', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 12:26:38', '2019-07-17 13:50:53', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', 'lishang.dai登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('49aeb10d-66cd-4259-b376-204d424a6599', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-21 18:02:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('49b2de3b-46a9-4752-8c60-717401a70c8c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-30 16:21:29', '2019-07-30 16:38:26', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('49c24b31-103d-4a3a-8686-225c952b3ea5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.15', '192.168.122.1', '2017-11-06 13:12:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('49f6f2a4-1c08-4e54-808a-c2db183924fa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2020-01-07 09:22:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4b456bc3-1269-422f-b3af-a81f6afbc9af', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 16:55:45', '2019-07-22 16:56:38', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4b6281a0-738d-4dcb-bdc8-8c24d050845a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-27 14:15:49', '2019-09-27 14:22:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4bd08421-664d-4bae-a923-8c33dc32e42e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.157.28', '192.168.122.1', '2017-11-10 18:48:12', '2017-11-10 19:37:24', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4be195da-501d-4c6e-8f78-6ccf66416b36', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.248', '192.168.3.51', '2019-09-26 17:30:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', 'admin登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('4c027e7e-f841-4f9f-a05c-371f206a4fcb', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.250', '192.168.3.51', '2019-09-20 02:27:03', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4c56f1c4-21b7-4123-959e-416f257e140e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 13:24:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4c65855a-786f-4720-9ba7-1385f00a8981', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.66.246', '192.168.122.1', '2017-10-10 15:15:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4d181b49-48a0-472c-92f9-71dcb6c30255', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 09:41:28', '2019-08-01 11:22:50', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4d78b971-988b-4a33-921a-3126bb0fbe11', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-24 16:48:14', '2019-07-24 16:50:41', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4d90f0f3-7fe8-4bbc-ab22-ed5b8da3076e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-12 15:54:28', '2019-08-12 18:53:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4da2ee0c-9e30-4252-a2f2-2df919b5ccea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 13:26:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4dcca2ac-06f1-4a99-8e2b-9391c78b5bfa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-30 11:41:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4df6b6e8-12cc-404d-9029-b10776b3bdc8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 10:20:31', '2019-07-22 10:55:40', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4e0a6d95-ba7f-4483-b6ee-a01f79d78c12', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.156.76', '192.168.122.1', '2017-11-08 23:09:25', '2017-11-08 23:10:39', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4e174290-4a5b-4708-ab6b-92041c5c2e11', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-24 09:15:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4e29534f-8aa4-460e-8d44-d7a2ca557d5d', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 14:22:10', '2019-09-17 14:24:45', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4e422949-7c36-4930-aaf4-e04819e90427', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-24 11:41:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4e731d86-b1da-4e11-a0e2-b0e571829720', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 13:01:54', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4eeaf9c1-60eb-4866-b34c-6a118d8f0275', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 16:34:56', '2019-10-12 16:53:27', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4f4574de-298d-43d8-94ad-dc9c6844d56f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 12:56:48', '2019-10-09 12:58:18', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4f940a1a-2c2a-4b13-b60d-cc6ecbbb0646', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-20 09:38:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('4ff1d0b0-f78d-4b2d-af8a-73f29b506337', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 15:24:48', '2019-09-23 15:25:34', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5068f3e7-cfee-4b90-a9e9-006cd82c914a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.247', '192.168.122.1', '2017-11-14 17:04:09', '2017-11-14 17:07:13', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('508a44d0-854b-4723-a1d2-74781ad0e6f9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-17 13:51:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('50a83eed-8908-40f2-a0af-f931bec270c1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 11:29:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('50edc60d-e44d-497a-8e71-08d15c951c7f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-27 16:10:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('50f534dc-8492-412e-b661-e8d207503c94', 'shanghaitech', '上海科技大学', '0108', '公共服务处', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', '127.0.0.1', '127.0.0.1', '2019-07-03 14:53:20', '2019-07-03 15:27:46', 'NORMAL', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', NULL, '/shanghaitech.ogn/0108.dpt/5C7117E6CE814125E050007F010057D5.pos/100184@5C7117E6CE814125E050007F010057D5.psm', '/上海科技大学/公共服务处/管理岗位/胡玲玲', NULL, '100184', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('50fef37a-f1ee-4c22-b761-261ddc351d1d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 16:44:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('513b43fc-4365-4427-a454-31440ab020a0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 22:04:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('514cddf8-f74b-4437-a31e-0a49d6354040', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B', 'user', '192.168.56.1', '127.0.0.1', '2019-10-09 13:01:32', '2019-10-09 13:02:41', 'NORMAL', '607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B', 'user', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/0CBF734CE4184AF382831398B108941B.pos/607BD4AFE1F64458ACD6E5A31C102E80@0CBF734CE4184AF382831398B108941B.psm', '/外部机构/测试使用部门/ETL供应商/user', NULL, 'user', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('515ddce1-4ade-4a37-b9a2-272888722ccf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 17:55:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5161ffe5-3d43-4119-89d0-ded5e907d0c0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 11:14:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5169eac9-d999-4d2b-a773-33af23cec378', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 17:06:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('517cd6c1-110e-4a7b-bc2f-aab2f7dc6b11', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-09 15:58:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('51afa11a-4750-49b6-9049-b01632dcac3a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 16:24:08', '2019-07-23 16:41:47', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('51f7b9ff-b665-4f72-8b88-31af19863226', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-10-25 18:26:33', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5202c699-b428-4a3c-a702-3371e7465c69', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 13:08:42', '2019-09-20 13:09:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('521bbc2e-151a-463d-91d7-959f7766d7f5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:37:19', '2019-07-08 11:37:29', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('52b56019-2371-41d2-9ad2-5a1b58359e09', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-05 09:14:51', '2019-08-05 11:11:47', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('52bf674e-fca8-4eb1-a890-c21502da9053', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-12 14:22:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('52ca7295-3273-445e-ae91-aec776d28912', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 11:21:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('52e5ac99-0730-4340-91e4-282dcba96d36', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-18 14:12:54', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('53306731-ce80-460b-a9c6-a33c787efa9e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-16 15:57:26', '2019-07-16 16:00:59', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5419437a-572d-4221-abc0-757a4656117d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 17:50:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('541b892e-7323-45f1-b715-cf303ff6e155', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-28 09:10:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('541c45d9-7ad4-4266-9fe9-cb934b4f6827', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '192.168.31.234', '2019-06-19 16:57:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('547f7ec6-2674-437a-864d-da298a17dcd9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-27 14:29:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5494927b-8445-4283-8b49-f4a180dffdec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-04 16:00:29', '2019-07-04 16:49:18', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('54ba4e76-320c-4247-9180-42604f2f57cd', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-12 11:26:23', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('54c4ddc7-8d9c-43f0-b815-6c36e0a97a45', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 14:38:30', '2019-08-02 14:39:56', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('54dfac0e-6925-4724-9849-52c8297e1fb6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-02 10:44:03', '2019-08-02 11:03:42', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('55043cfa-4625-484e-9b7b-f8235c68b21d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-17 14:12:44', '2019-07-17 14:16:16', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('556018e8-8a2a-41b8-9217-ba3f87156629', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.157.188', '192.168.122.1', '2017-10-27 14:25:32', '2017-10-27 14:26:38', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('556c9bd5-12fc-4c92-91f7-33252bc514d9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.198.211', '192.168.122.1', '2017-10-30 10:19:40', '2017-10-30 10:27:39', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5574f846-27b4-44ed-961c-d5e4bd7dac0a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 11:40:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('55869f85-80c6-4fc6-9282-03189e90441b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.205.146', '192.168.122.1', '2017-11-01 08:46:34', '2017-11-01 09:03:34', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('55ca2729-5d8f-4d76-b686-f04c18cc0a72', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-10 09:26:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('564e57d9-cb76-4d91-8b53-774f94139cdb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 15:54:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('56e045b4-b728-49a7-944c-db0eab03e074', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-29 10:54:53', '2019-07-29 11:50:21', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('57456600-053c-4342-a9cf-70ea1b6f157c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-04 16:49:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('57ae1a2b-dd36-4d93-8d02-462efe0148a1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.157.28', '192.168.122.1', '2017-11-10 18:04:36', '2017-11-10 18:47:22', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('57bfc226-9cc7-4ee9-b900-8740c67da9e3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 11:10:00', '2019-07-31 11:37:18', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('57d8506f-5a66-43bb-af83-b3f3635634ec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 14:46:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('57de26cb-a963-4068-9a51-06827e47d8a6', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-05 14:08:57', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5804ccbe-f069-49d1-8c15-b7b9224924c4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.202.93', '192.168.122.1', '2017-10-11 10:23:33', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5830b4a9-e6e1-4600-9da2-a3d79fdc9f3b', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-10-30 09:16:16', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('583ceaf4-722b-4399-a69e-e94733ca77a5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-29 09:31:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('584aa5db-041c-4c33-90b0-f7128e824557', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 14:14:44', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('585795eb-0afd-40bf-87d1-507a8cab62df', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 10:27:25', '2019-09-23 10:32:39', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('587951a1-49d1-48ce-b218-4d0f74b312ea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-26 10:12:14', '2019-07-26 16:29:07', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('58920955-dea3-4c12-b850-a519765d29d6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 10:26:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('58a1a849-5ce5-4dd7-b335-32ce93be1d36', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-24 10:14:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('58a736df-29b1-4f59-bd51-2e72db2af35d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 09:14:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('58d6076f-c93b-4c50-a963-ed30222ab393', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.61', '192.168.122.1', '2017-11-14 19:38:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('590688b6-c3b6-4476-85ed-9e46fc821c36', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-17 10:08:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('592187da-aaeb-433e-b84f-1a02b9f580b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-24 16:09:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('59685e6a-e698-47b5-a836-e222072c26ff', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-12 19:00:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('59b20ade-b20b-4dce-87cf-a9445802dff5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 10:55:55', '2019-07-22 11:43:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('59dd2a00-b1de-4517-b6cd-2757aa185f66', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 16:54:38', '2019-07-22 16:55:27', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5a361bcb-a77b-4984-8907-e2880d25e32a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.10', '192.168.122.1', '2017-11-03 08:39:41', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5a3775ac-3c11-4381-8865-757979865522', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 09:39:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5a3f6697-fc8a-429c-8dcf-463ef447026c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 13:22:43', '2019-09-23 13:23:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5a41039a-9252-458f-9cd0-d23dd221b0cd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-29 10:14:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5a46fb3e-6b81-4858-8d1e-f1ee58d9dfff', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 14:29:06', '2019-10-10 14:30:35', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5a79acc2-cee4-48c4-8c82-e39438d8a233', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-28 17:23:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5ab52016-f3b8-4d7a-9bc2-e01382802264', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.201.255', '192.168.122.1', '2017-10-10 09:21:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;tester登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('5ab867b3-1470-4991-bca7-a9878e2aeb88', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:36:33', '2019-07-08 11:36:37', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5af094b4-9d20-4931-8d48-b0da5e758b42', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 17:10:18', '2019-08-01 17:34:44', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5b299316-8f3e-44ad-8566-3f2b087c4675', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-27 17:43:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5b2f84d4-987b-4882-a60f-c318d14df502', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-05 16:34:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5b5481d5-2010-451d-bbdb-27748bcd1acc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-09 09:59:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5be8795e-c568-4a5f-8452-737fc36f69d5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 15:09:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5bfc325b-eb5b-4c0d-bb0f-a81a8a70744f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 16:55:32', '2019-07-22 16:56:49', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5c41f2f3-3769-4cd8-9934-eb316c753f9d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 09:11:53', '2019-07-23 16:06:46', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5c80b133-59ad-43fb-9bdd-35f2f0d74ada', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-28 15:29:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5c8b50e0-8620-4842-85ca-dc25b1579cba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-30 17:57:25', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5ca1d948-11e1-4c79-8892-abf46a15193c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-06 15:06:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5da83862-7795-4756-bb75-71004a549a00', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 16:07:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5db81df7-5444-48b2-a3a5-f0286e0c13ef', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-02 15:58:27', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5dcb491e-aa4a-4b08-a855-2fb0c89f20eb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-04 10:19:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5def40fe-b035-49eb-826f-1032177dd184', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 13:58:55', '2019-09-23 14:00:08', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5e339d5d-cb96-4631-8462-b2da4d0db70e', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 13:42:34', '2019-09-23 13:43:16', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5e7f8788-85b8-42cd-96d2-a342be46efe8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.199.50', '192.168.122.1', '2017-11-08 11:10:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5ea60d4e-d509-4e3b-beb5-1e76f7668629', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 09:08:44', '2019-08-02 09:10:00', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5eca4e2e-abec-4005-8b66-01c5820bcd86', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.19.157.25', '192.168.122.1', '2017-10-29 09:00:39', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5f106da7-fa7b-43d5-8e4d-30c27cbe5a89', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-12 11:50:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5f3ee995-bb34-49ca-9343-7f9456dbda7e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-18 21:53:43', '2019-08-18 21:55:08', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5f7af643-a20a-40c3-a0ff-42ce6e34ae42', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-11 14:20:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5f8d3879-3105-45e2-92cf-e58e63425a95', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-02 17:11:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5fdef3fa-e3a4-4cc3-aa72-c98c9a987666', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.13', '192.168.122.1', '2017-10-29 17:08:03', '2017-10-29 17:08:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('5ffdd565-9a13-4691-8371-78653c188fb2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.196.35', '192.168.122.1', '2017-11-01 14:17:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('60b1df2a-9fdc-40d1-9773-7df861690eac', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-05 09:12:17', '2019-07-05 09:12:33', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('60c04a5d-4b9c-43df-a6c0-a47d9bc9e274', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.247', '192.168.122.1', '2017-11-14 17:09:42', '2017-11-14 17:31:56', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('60d0f051-0294-4c03-8351-46445da5624f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 13:43:27', '2019-09-23 13:58:44', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('610c4f74-f4f7-4f0c-b4ac-34f729885300', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-21 16:22:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6184717d-efa9-4b96-89e1-a6b89be5dd08', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-11 10:25:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('618ff93a-6095-41fd-bce1-3f46d09d3831', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 09:27:52', '2019-09-23 10:24:24', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('61b43c92-0e0d-40fa-81db-4d102ef43e7c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.194.60', '192.168.122.1', '2017-10-09 16:06:40', '2017-10-09 16:07:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('61d73448-a8bb-4c5d-b29b-1922c77e5b80', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-05 17:13:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('62221f73-877a-4174-ad5f-6bb7e70cef94', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 16:43:51', '2019-07-23 17:34:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6259b0f1-b19f-4739-a22e-5c1c0605b478', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 15:52:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('62e96c59-7ef7-470f-989b-9ffab5baacf8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 16:19:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('636c8025-d88b-4a8a-b3f1-f1fa678b8a2d', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 15:48:31', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('637162b6-bef5-45fb-b0ea-0b838cec9199', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.10', '192.168.122.1', '2017-11-03 08:36:35', '2017-11-03 08:39:36', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('63be8d71-c185-4620-aecd-4165c8bd74a6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.231', '127.0.0.1', '2019-07-16 15:01:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('63c07015-5f5c-4fde-9ba8-46874f099fad', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 10:14:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('63d4fe93-7954-4eb3-8de1-3f5f99bee4b2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 14:26:09', '2019-10-10 14:26:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('641a2c16-7e53-42bf-a9a0-e96d9d42f471', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.16', '192.168.122.1', '2017-10-27 09:40:39', '2017-10-27 11:31:27', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6424cfbc-a89d-485f-a389-ee37cacc4a47', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 14:31:15', '2019-07-22 14:44:12', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('643eece3-e706-4c2e-8b5d-609ee0df7c6f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 16:15:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('647805d7-95b8-44e2-8ed3-4b22628e1e70', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 09:12:38', '2019-07-05 10:53:30', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('648438d4-539e-412a-9f01-88ccd39da88f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.207.65', '192.168.122.1', '2017-11-09 09:15:10', '2017-11-09 11:03:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('648a2255-2475-441e-86e3-33ce84f84eb5', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100103@5C7117E6CDDC4125E050007F010057D5', '孙小影', '10.20.71.8', '192.168.122.1', '2017-10-30 14:13:29', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CDDC4125E050007F010057D5.pos/100103@5C7117E6CDDC4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/管理岗位/孙小影', NULL, '100103', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('64b7248b-8524-4ab8-9c50-72a6431ef576', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-22 15:55:08', '2019-08-22 17:01:46', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('64c89f81-f5ef-4261-8492-2666c100f0ae', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.55', '192.168.122.1', '2017-11-16 10:35:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('64ed669d-41d3-4315-bb84-ef1ee8693eae', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 14:53:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('64eee200-3d04-4e08-85ab-5173ccaed223', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-25 14:00:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('65444f4f-26af-4793-998f-4ad1e8b5dec4', 'shanghaitech', '上海科技大学', 'AC0F9895383D4F10908393C6146438CA', '吴晓燕部', '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '吴晓燕', '127.0.0.1', '127.0.0.1', '2019-07-03 15:35:33', '2019-07-03 16:47:01', 'NORMAL', '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '吴晓燕', NULL, '/shanghaitech.ogn/0108.dpt/AC0F9895383D4F10908393C6146438CA.dpt/15A70AA00CD14296A27315F1A2EB51D4.pos/6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4.psm', '/上海科技大学/公共服务处/吴晓燕部/吴晓燕组/吴晓燕', NULL, 'wuxy', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('65bcc1b1-7ca2-45a1-8448-1b288f69877d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-16 15:57:17', '2019-07-16 15:57:22', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('65fe4c1d-b4e4-46cc-bf3e-7b177cb4ea99', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-08-06 17:54:51', '2019-08-06 17:59:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6613b9fc-b80e-4210-a3c2-6be13bf2b1f6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.19.157.132', '192.168.122.1', '2017-10-14 22:42:02', '2017-10-14 22:43:11', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('6645829f-889f-42a9-9e1c-244b50fa4b16', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 11:00:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('666d9002-532e-4851-8950-bbfd32161cfd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.156.217', '192.168.122.1', '2017-11-03 13:54:41', '2017-11-03 14:22:52', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('66ccdeb6-0302-4460-b74e-e9bb17e15dc6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 14:13:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('66e9bc14-ccae-4d58-8b22-2db2893a35ae', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-13 21:34:43', '2017-11-13 22:02:07', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('66f0a774-882a-45c3-a6f2-a3d74d4ff2b8', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'A831E75F9B1F492CB2B50589D8D5C741', '中航国际领导', '92208DB645ED346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '刁伟程', '192.168.3.246', '192.168.122.1', '2019-09-17 14:28:49', '2019-09-17 14:29:43', 'NORMAL', '92208DB645ED346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '刁伟程', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/A831E75F9B1F492CB2B50589D8D5C741.dpt/85979EC22D6F4042BE72F256A2089C6E.pos/92208DB645ED346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E.psm', '/中航国际/中航国际总部/中航国际领导/分党组成员副总经理/刁伟程', NULL, 'diaoweicheng', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6721b2d8-a676-4931-a6eb-bdf1e7a84635', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-23 23:45:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('67c8690d-c8f3-4d31-9e0e-ab4e61b77c42', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-22 10:13:45', '2019-07-22 10:20:18', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('67f76ab8-3604-49e9-87b4-7a426943225c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 17:26:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('680e3237-9db1-49f8-8dde-41956dcb67c3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 14:06:21', '2019-07-08 15:39:55', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('681bb8ae-5bb5-441c-b537-a662106b6053', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-02 14:40:03', '2019-08-02 15:48:43', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('68334724-8a36-4cc0-b2e1-a5175c3526e3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 11:36:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6862c116-3e16-4b3e-874f-d00ce746dc97', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.201.255', '192.168.122.1', '2017-10-10 08:47:25', '2017-10-10 09:21:30', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('686fc0c9-758a-486d-815d-caff7093b4a1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-18 15:36:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('68716c62-69d0-4aba-81cd-d2d4d2c177b6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-02 10:30:25', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('687a35d4-54ac-403c-b30c-09f12f5f2671', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 14:29:03', '2019-09-06 15:49:03', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('68ad34a4-66b0-47b9-b32d-4547874c2324', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-09 15:08:54', '2019-07-09 17:57:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('68cb5af2-70b0-4d53-b515-828d05ea8e0e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 12:02:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6940e09c-9784-4e90-bd3b-e644fbf64055', 'shanghaitech', '上海科技大学', '0108', '公共服务处', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', '127.0.0.1', '127.0.0.1', '2019-07-03 16:47:14', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0108.dpt/5C7117E6CE814125E050007F010057D5.pos/100184@5C7117E6CE814125E050007F010057D5.psm', '/上海科技大学/公共服务处/管理岗位/胡玲玲', NULL, '100184', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('69451201-b8d0-46a3-a84e-aa9097ad628c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-04 10:12:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('697cdb23-c640-4fea-93ad-33ddfe0aba1a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-09 14:21:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6a0c5bcf-3c3b-4453-9b51-2455b6c53274', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 16:41:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6a436099-5c3b-4e3b-af92-6d224d716011', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 17:13:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6a808f48-e437-4336-8a39-ec32c14e4956', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-04 16:32:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6ad95103-ad99-4b83-8664-7333024a5820', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 09:19:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6b29f8a0-c47f-4493-8099-c7dc69d69e37', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-11 09:58:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6b37da0d-7b83-4945-91fa-123fcd9b338b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 11:13:27', '2019-07-25 13:55:18', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6b3aa107-f2e6-40e2-adcb-090b71ffff25', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:30:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6bd77175-f20a-4ca4-9bea-a5c55f6c926b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:35:36', '2019-07-08 11:35:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6bf654f9-5c6b-46db-9d1f-337d1e03fb3d', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 13:50:20', '2019-09-23 13:59:15', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6c5457f0-b2eb-4bf2-8180-858cee2a9dfd', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 14:38:57', '2019-09-17 14:39:38', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6c590805-55f0-4882-a68d-0d626cbb2366', 'shanghaitech', '上海科技大学', '0207', '硬X射线自由电子激光', '100946@6764A03B851DF731E050007F01004EF8', '李亚虹', '127.0.0.1', '127.0.0.1', '2019-08-09 15:58:32', '2019-08-09 15:58:43', 'NORMAL', '100946@6764A03B851DF731E050007F01004EF8', '李亚虹', NULL, '/shanghaitech.ogn/0207.dpt/6764A03B851DF731E050007F01004EF8.pos/100946@6764A03B851DF731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/科研岗位/李亚虹', NULL, '100946', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6c59f63d-bc37-44dc-977e-d39a617141c8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 16:18:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6c79d3a0-d7ee-445a-9220-a9a4d8ec122b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 18:42:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6c9bf07f-566d-4298-8850-f6b3caa14c2c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '单据填报人', '10.20.193.247', '192.168.122.1', '2017-11-14 18:22:32', '2017-11-14 18:25:00', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '单据填报人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/单据填报人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6cc817df-7d89-4957-9732-7a45aebceb30', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-23 18:02:35', '2019-07-23 18:05:38', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6d036fb7-6631-4801-9025-67fc44a6fad1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 16:45:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6d53175f-6ca4-4d01-933f-7c2e47031b53', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 13:58:49', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6dc2f0d3-2f03-4843-82bb-fa7e246378bc', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100103@5C7117E6CDDC4125E050007F010057D5', '孙小影', '10.20.71.8', '192.168.122.1', '2017-10-30 11:17:23', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CDDC4125E050007F010057D5.pos/100103@5C7117E6CDDC4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/管理岗位/孙小影', NULL, '100103', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6df163fb-eb59-4dbd-82b2-81dff62d2d81', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 10:05:55', '2019-07-22 12:09:50', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6e00a11d-f005-47c8-a693-758fda3f2527', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-25 14:06:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6e1a22e4-85eb-4802-89b1-8881d6850dde', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-03 15:27:54', '2019-07-03 17:33:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6e26344c-a9b8-4c3b-a743-fdf9db378711', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9C23A34E91064D5689F0E2B26F8CCC50', '外部部门', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', '192.168.3.240', '127.0.0.1', '2019-06-14 16:57:57', '2019-06-14 16:58:28', 'NORMAL', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/9C23A34E91064D5689F0E2B26F8CCC50.dpt/BE63FABAF205467788621D9695ED09D7.pos/8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7.psm', '/外部机构/外部部门/初始化岗位/子君', NULL, 'zijun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6e3ca1d9-4dd6-448c-b36c-d620769f5e82', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.247', '192.168.122.1', '2017-11-14 17:01:53', '2017-11-14 17:04:01', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', 'adminisitor登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('6e3d7a48-14e2-4285-b60e-ad2edd8ffa37', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '43A55627FCD04B1BA0577D5265FAB6A7', '经营管理部', '92208DB6466A346BE050007F010012C2@A97127B2DCA94B14B4B72391A3B017BA', '杨蕾', '192.168.56.1', '127.0.0.1', '2019-10-16 14:33:02', '2019-10-16 14:40:47', 'NORMAL', '92208DB6466A346BE050007F010012C2@A97127B2DCA94B14B4B72391A3B017BA', '杨蕾', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/43A55627FCD04B1BA0577D5265FAB6A7.dpt/A97127B2DCA94B14B4B72391A3B017BA.pos/92208DB6466A346BE050007F010012C2@A97127B2DCA94B14B4B72391A3B017BA.psm', '/中航国际/中航国际总部/经营管理部/部长助理/杨蕾', NULL, 'yanglei', 'xiyushan登录，错误信息：用户或密码错误;xiyushan登录，错误信息：用户或密码错误;ceshiyonghuyi登录，错误信息：用户或密码错误;ceshiyonghuyi登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('6e8f0c26-db89-4c7e-8e32-cfe93ddd6872', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 09:09:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6e92c647-2a9f-442b-be8a-9d057f5fe636', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.201.1', '192.168.122.1', '2017-10-30 16:51:37', '2017-10-30 16:55:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6ea21bf3-27d1-4060-aa5f-aaebf9a54814', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-23 23:31:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6ecf182e-ce94-4376-82f4-344a9b0f6b19', 'shanghaitech', '上海科技大学', '0109', '基建管理中心', '8B45CB8C8875A315E050007F010058E2@5C7117E6CE9F4125E050007F010057D5', '子君', '192.168.3.234', '127.0.0.1', '2019-06-17 11:02:46', '2019-06-17 11:04:13', 'NORMAL', '8B45CB8C8875A315E050007F010058E2@5C7117E6CE9F4125E050007F010057D5', '子君', NULL, '/shanghaitech.ogn/0109.dpt/5C7117E6CE9F4125E050007F010057D5.pos/8B45CB8C8875A315E050007F010058E2@5C7117E6CE9F4125E050007F010057D5.psm', '/上海科技大学/基建管理中心/管理岗位/子君', NULL, 'zijun', 'zijun登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('6ed303fb-fd38-458d-934e-1ce6c3e92ec8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 15:25:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6ee6ae0e-4868-43d5-95b0-f144722773fa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-16 09:50:54', '2019-09-16 10:20:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('6ef49a74-6f5d-4fbb-99d9-5c54bbde2fe4', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-09 15:51:52', '2019-08-09 15:52:07', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('700147b1-16ba-4a32-9dea-43de66818708', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.3.51', '2019-09-18 18:59:21', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('702f6345-8039-4884-81d1-008260c19ac3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-23 18:22:59', '2019-09-23 18:58:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('70d91eca-5f01-4203-8955-4a520ead0873', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-02 15:53:17', '2019-08-02 15:54:08', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('70f90b22-adc5-48db-ac34-1c8f2cd811fe', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 23:08:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('71476164-5ab3-40df-a0a8-3a7f84d51cf1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-25 22:52:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('714d4a59-c2a4-4646-99b2-935657300b71', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:55:08', '2019-09-17 16:57:36', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('720f94e1-c472-43f2-8c7f-95128e2b8868', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-08 14:38:16', '2019-07-08 14:41:01', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('723745a5-b90a-4a53-bc25-13a3d4bcdc7c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-08-06 10:34:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('72793f96-b6e7-4c3e-ae9e-14c6582179db', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.192.150', '192.168.122.1', '2017-11-09 15:30:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('72b218be-ee87-4da7-a6c3-ffcf62738d26', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 13:03:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('72c1bdd2-7f9f-4386-9b51-7289ac735524', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-09 09:58:33', '2019-07-09 09:59:02', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('72f80978-2d28-4f4c-af6e-14ff3b319fd8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-18 09:57:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7301d8b1-2bdb-4823-89b6-d345b55b3bdb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-23 22:43:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('733da433-ceed-4734-879e-edd750a8ef89', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.19.157.115', '192.168.122.1', '2017-10-29 08:39:28', '2017-10-29 08:47:20', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('734c98bb-2c65-4ae5-8e85-c6a52fb2d888', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-15 18:25:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('736f2f71-737d-4e1a-a4bd-d1dc0bb94e75', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-06 21:52:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7380509c-55a4-40f2-86db-605113cac49f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 09:19:50', '2019-08-02 11:02:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('746b2af6-087c-42a5-9dd1-548bc7949384', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.234', '127.0.0.1', '2019-06-17 14:08:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('74aa470f-a649-4598-aa2c-685e04f26f89', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 13:16:28', '2019-09-20 13:20:18', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7517a68e-8396-46bc-b193-5b0c1a1121e3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-01 09:12:30', '2019-08-01 13:31:05', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('751d038e-0421-45e2-8144-94a8eeba9f1e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 15:04:23', '2019-07-17 16:59:55', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('75cedf4f-9cab-4024-989b-6ff5d63981b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-27 11:39:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('75e39943-687c-48c8-b9f3-883c49b4e329', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 12:01:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('763849c4-aeb5-4ec5-b7a6-620218f6f4e4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 11:28:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('76df07d3-d85d-4323-981f-89525fa3264a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 15:48:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('76ea554a-2e9d-43d0-8af8-859b2f4702fe', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.244', '127.0.0.1', '2019-06-18 16:58:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('76fccaa7-63d3-4700-b8d0-ce9b872d2f92', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 13:30:04', '2019-09-23 13:47:37', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('77277803-4e0d-4059-9e3a-d5c5380c13ef', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 22:09:50', '2019-10-07 22:35:16', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('77536ef9-738b-4921-8146-3da4f8560737', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 17:19:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('77b23442-a60d-4df6-abd6-dcb4b615b978', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-24 13:34:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('77e44e91-5c51-4c84-9057-a36241ccfeaa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 18:21:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('77fbc8dd-e8b1-43ba-b705-ee216e91b65a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-01 14:52:20', '2019-08-01 16:01:40', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('780cdd8c-e6a7-4967-b9cd-6b3534deb71a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-08 17:05:14', '2019-08-08 17:10:13', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('78323da5-5167-4774-b777-bdae7e9f033b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 09:27:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7838f856-fd52-4c7c-a501-9893c94e71c4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-30 16:20:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7842b8c2-4006-44b4-be5a-5eb78a381990', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.71.250', '192.168.122.1', '2017-10-13 10:21:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('786b4771-5b35-47c1-a923-f0c80eb7b7a8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '35EFBC500290401B8214BA1E33D15317', '联想科技', '8F1A6F1834322353E050007F010048D6@B711778D87704312BF9970467A646B08', '张三', '127.0.0.1', '127.0.0.1', '2019-08-02 11:05:21', '2019-08-02 15:58:21', 'NORMAL', '8F1A6F1834322353E050007F010048D6@B711778D87704312BF9970467A646B08', '张三', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/35EFBC500290401B8214BA1E33D15317.dpt/B711778D87704312BF9970467A646B08.pos/8F1A6F1834322353E050007F010048D6@B711778D87704312BF9970467A646B08.psm', '/外部机构/测试代理商部门/联想科技/销售员/张三', NULL, 'san.zhang', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('78858baf-6cae-4356-a8ba-2ecf7ea6bed2', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-12 13:46:13', '2019-09-12 14:39:43', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('78970400-68c2-4c90-b794-3f3bc8d3dc74', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100103@5C7117E6CDDC4125E050007F010057D5', '孙小影', '10.19.157.140', '192.168.122.1', '2017-10-26 21:59:11', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CDDC4125E050007F010057D5.pos/100103@5C7117E6CDDC4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/管理岗位/孙小影', NULL, '100103', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('78cc2b35-bff0-47c7-95b9-e0bcb5d20edb', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:51:51', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('78f80dd7-9069-4365-a424-94296f6f3d79', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-05 10:53:36', '2019-07-05 10:54:00', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('791e9db4-9ea7-4670-8e13-35acad04bcc8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 14:01:09', '2019-07-25 14:40:27', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('79327a0b-7cd7-44ed-9119-9d1c6f8da164', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-26 09:23:10', '2019-07-26 10:08:08', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('794b6c9f-3388-4c1d-839a-6102d1e1a9cf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-09 17:57:26', '2019-07-09 18:01:33', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('79702aaf-c493-44b4-bc56-d1f0196a39ab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 12:01:48', '2019-09-03 14:56:45', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('79a17686-e729-46e5-a12b-c1473b51818b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:20:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('79a733ba-0772-4006-9bf9-13aa469f9671', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-29 14:33:45', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('79d2d9fd-a977-4607-8d15-b86b418b80fa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 17:16:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('79eb044c-cb80-459c-b83b-8188767f8dc7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.156.217', '192.168.122.1', '2017-11-03 15:07:58', '2017-11-03 15:08:22', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7a027d98-4a45-4354-be55-8d66b19bcca1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-14 15:42:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('7a499bc4-6933-4853-9226-7bf7df9e7636', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-24 11:04:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('7a59c95f-c8ec-4c8b-bf36-a6ce560cd67b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.203.190', '192.168.122.1', '2017-10-27 13:31:25', '2017-10-27 13:31:30', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7a6fec7f-f908-46b0-b9a4-6d9dc71ebb0e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 22:42:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7a9ce5d0-d6f4-4ad8-aced-b50c4a7c3cdf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-11-11 14:49:25', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7addea84-329d-493e-b915-0aed78a92980', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-16 14:50:44', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7b28821b-fa26-4220-91f2-60106895896a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 09:24:16', '2019-07-25 09:45:44', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7b4cdac6-d42e-41c5-af2a-a17bbcce4c81', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-25 11:16:38', '2019-07-25 16:42:02', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7b7af4ad-d421-48c4-bca1-b15ecab96036', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.243', '192.168.31.197', '2019-09-16 10:00:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7badc3c6-b546-42f3-bbe6-c374a5b85f32', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 09:22:56', '2019-07-31 10:34:56', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7bea8c01-a9a5-48e9-8ef0-f5e469ac0450', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 15:13:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7c775b82-d418-407e-a927-9def235bf402', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-01 16:09:48', '2019-08-01 16:22:21', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7cbc9caa-7a99-4bbb-9187-fb38ff97df9b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-28 14:32:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7ccca0b0-2fd0-4202-b6e8-5bdb839c5fdb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 15:19:22', '2019-09-03 16:18:38', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7d2be603-aa16-466c-8034-214b103e2e0b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.207.131', '192.168.122.1', '2017-10-11 10:27:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7d7e7168-7882-40e9-b4cd-ce8b0f9a77c8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 17:41:57', '2019-07-31 18:07:19', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7e458202-157d-4c9a-b16f-fe452e2957e9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 15:34:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7e4b0761-4d84-4de9-9ae7-77bb7cb5a9eb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 11:28:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7e582aeb-2804-4d89-b836-9d97dfa6e02b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 11:28:34', '2019-10-09 11:46:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7ebb0fb7-a356-40d3-9800-6291b8b4e74d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 22:54:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7ec19067-9d37-4543-b5c0-b03bc2f09e6a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 13:01:16', '2019-10-15 13:52:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7f1f40ed-d49b-48da-a3f9-a8a063928eca', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.217', '192.168.122.1', '2017-11-03 15:08:27', '2017-11-03 15:09:22', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7f2e7e69-ab11-4aac-9ef3-d78a6abe7ce4', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.3.51', '2019-09-18 17:19:05', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7f37751d-c4df-452f-82bb-86e06ee62dba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-08 16:37:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7f8139c6-44b0-46d1-b7fa-006470def42d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 17:50:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7fbb88a3-d36b-4221-83b2-7c130a85d7d3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 16:08:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7fbf72cc-8b9a-4062-bbbc-4d0d3972b3ad', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 12:42:01', '2019-09-23 12:44:18', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7fc661e8-8b7c-4b96-b483-79ceba0fd04e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-03 18:26:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('7fe8f7b3-3e4f-400d-975e-6cc04cd112da', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.241', '192.168.3.51', '2019-09-23 18:12:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('801e3c68-7c92-4ba5-b817-b734ccddd240', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-18 09:28:52', '2019-07-18 09:31:02', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8051fb14-7f57-4306-90f0-f200f128a327', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-26 09:23:00', '2019-06-26 09:32:59', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('80897626-8ca3-437e-aa9b-ddeff2f2c9f3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-16 15:11:50', '2019-07-16 15:11:52', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('808cc227-0529-40b5-888e-ce994bcbadc7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-06 17:58:49', '2019-08-06 17:59:53', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('80bbbad9-ec03-4bb1-8b5b-77c7b4cd7a39', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 21:12:54', '2019-09-30 21:42:30', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('80e358b7-bd36-4158-8e60-dad7b8bc531c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-01 13:31:11', '2019-08-01 13:31:17', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('80f03da7-72ed-46fb-b372-29f453dda928', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-12 14:39:27', '2019-09-12 16:13:12', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('81528c18-8ae4-4fc1-ae49-73157dc03389', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 22:06:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('818d2d1f-b8b2-4b5d-89a3-bdc0da413bf7', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 16:58:06', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('81b022e2-b33f-4e93-80ca-c3711a61b9de', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.244', '127.0.0.1', '2019-07-17 14:38:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('81b988f9-9709-410e-821a-d2f29696d2cd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-09 09:21:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('81bfd836-796a-4c88-8f46-7d2212cc5333', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 14:43:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8236e6d4-eeea-4534-ab1f-f106e968678b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 13:59:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82421523-1213-4adc-ab10-8e045f558992', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.198.211', '192.168.122.1', '2017-10-30 10:19:13', '2017-10-30 10:19:21', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82677dd6-26ba-4a8d-933c-3c9e79c04b52', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 15:48:51', '2019-08-02 15:53:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82683367-c5c2-4502-9fd6-fce731a681a9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 13:42:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82837998-ba77-4f5e-8f7d-9301c344e5ba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-06 10:29:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82d6bd28-4061-4008-b222-881e82569117', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 22:51:41', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82e2a2df-6363-46cd-83b8-e1d7f99cf2db', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.31.197', '192.168.31.197', '2019-09-16 14:10:11', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('82ff3ae1-bf26-45d2-83a1-37792de687f7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 10:23:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('837afa92-4893-4ed7-844e-5e62d8e7c94b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-02 09:12:03', '2019-08-02 09:19:46', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8386b5f4-0e87-41d6-aacf-e343d4373e38', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-28 09:55:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('83a4ba8d-1119-49c9-9071-4c87737e3d3f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-02 17:58:41', '2019-07-02 18:01:34', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('83e95e49-7631-48bc-ad06-b17a2be4f8e6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-26 15:05:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8425f53c-2255-4a5a-ab6a-92dc29a8f7e7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-14 18:18:00', '2017-11-14 19:36:04', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('845687e4-bfcc-45e7-a3ab-9237e4c47ea5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.204.70', '192.168.122.1', '2017-11-03 09:00:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('84710d79-ede1-4ffa-adfe-a6669828201e', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:53:07', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('84d9ac25-3ceb-4d96-87ea-a11ec070a285', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-14 08:37:03', '2017-11-14 13:38:51', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('84e4b1fc-a3c9-48c5-bea1-6416f3916597', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-06 10:51:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('85099ef5-e944-45cd-abe1-8f9d0d021697', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-30 09:54:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('85937a3f-db1d-48e1-adfb-dc23245af0d3', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100103@5C7117E6CDDC4125E050007F010057D5', '孙小影', '10.20.71.8', '192.168.122.1', '2017-10-30 13:42:13', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CDDC4125E050007F010057D5.pos/100103@5C7117E6CDDC4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/管理岗位/孙小影', NULL, '100103', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('86156690-516b-49d4-8ab0-5bce32f38656', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 16:38:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('863b5f72-6d56-4a96-a41d-b7cac07f3724', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.19.157.135', '192.168.122.1', '2017-10-28 10:39:42', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('863d2615-4b63-4b71-8598-90fb928dd0f3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-23 16:20:57', '2019-07-23 16:24:03', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8655f022-cf89-4213-8a07-09408567d67a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-26 14:08:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('865c9767-ac0b-4ad5-8b4e-4e3d6cd1dff6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 11:59:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('86bdb98c-ca7e-43c5-a730-bb9dfa4fc8b4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 17:11:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('86c4b465-47da-48ef-b18b-23c8bd1c7a70', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 14:32:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('871d124a-a584-4dc8-bea7-7387d84525b8', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 14:44:16', '2019-07-22 14:56:25', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('87603022-2648-4bf6-abdd-dcc7c2c9df5f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-08 17:04:55', '2019-08-08 17:05:10', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('87afd532-0140-40b7-8a15-51708c866a73', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 14:28:25', '2019-10-10 14:28:36', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('87e35d62-a252-4637-81a2-20949155e645', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 09:35:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('87e7dd93-be38-4d8a-aa72-7e25f1ac1b5e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 11:39:39', '2017-10-27 12:44:29', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('885ca99e-d0d9-48bc-a8cb-6e60ed06569c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-05 15:46:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('888a5737-3bf9-455a-a4c6-00346207d7c4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-16 20:17:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('88bd20d1-63f6-43dd-8705-5194aeb10ac8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.157.188', '192.168.122.1', '2017-10-27 14:26:54', '2017-10-27 14:31:52', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('88cf70b0-8739-4a1d-b6b7-37105411b6ab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-14 13:39:02', '2017-11-14 15:55:56', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('890ddfd8-81f2-4c9b-b58c-3945d2a47a06', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:36:14', '2019-07-08 11:36:19', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('898bc0a1-d1e6-450e-92c3-c173d8a3767c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-27 11:18:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('89917215-c4f5-4f71-aeb1-cda54622037b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 15:47:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('89964515-5088-4fb0-a053-a86e143bb944', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-28 17:38:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('89ac3655-bdb7-4c73-b67c-8b2d3020f80b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 09:31:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('89c2b838-3cdc-40f6-902d-6210591324cb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 09:46:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('89dd7b98-52a1-49bd-97e2-253fb20c8034', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-18 11:29:08', '2019-09-18 11:29:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8a4dc9b4-3cbb-4a5d-89f2-8cc869d8f7f7', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 18:40:05', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8a7bd2f4-d0fb-43e1-a19a-6bfd5da0fb03', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 10:27:04', '2019-09-23 10:27:19', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8a806eee-2db5-459d-9128-6e4d9296126a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-17 14:37:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8a9b1c10-fdee-4042-a0e5-b8e291418aa8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.67.91', '192.168.122.1', '2017-11-03 12:15:11', '2017-11-03 13:29:06', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8b51515d-b9e8-4505-a998-d1cf42e725fb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-08 18:10:12', '2019-08-08 18:22:31', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8b5383c1-e0d8-49c6-85be-f236690fbef3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 09:57:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c0864fe-ec44-4ac4-b716-9dd74c075d05', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-09 09:20:29', '2019-08-09 09:47:30', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c5270c7-a84b-41a6-acf6-e76f59817297', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 09:24:20', '2019-07-22 10:06:46', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', '180014登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('8c5a849f-6550-4ff2-8bad-053b3a5bf1db', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:21:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c636d88-6647-4d86-a537-937efe1f988f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-18 14:17:49', '2019-07-18 16:48:45', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c6dd27a-afe9-4279-aef5-c373a986f78f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.197', '192.168.31.197', '2019-09-16 09:33:58', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c707411-26ec-4b30-b616-1b0c0b076913', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-16 17:21:45', '2019-09-16 17:45:12', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c8bcd17-6089-4fd5-afbe-4f911523dc4a', 'shanghaitech', '上海科技大学', '0207', '硬X射线自由电子激光', '100946@6764A03B851DF731E050007F01004EF8', '李亚虹', '127.0.0.1', '127.0.0.1', '2019-07-22 17:01:22', '2019-07-22 17:01:34', 'NORMAL', '100946@6764A03B851DF731E050007F01004EF8', '李亚虹', NULL, '/shanghaitech.ogn/0207.dpt/6764A03B851DF731E050007F01004EF8.pos/100946@6764A03B851DF731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/科研岗位/李亚虹', NULL, '100946', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c947f69-2ff7-440d-a4f7-945c5b9b5d98', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 18:11:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8c9acd32-598d-412f-a479-6ae9b6f5f3b9', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100584@5C7117E6CD9C4125E050007F010057D5', '陆成松', '10.20.69.183', '192.168.122.1', '2017-11-03 15:55:31', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100584@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/陆成松', NULL, '100584', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8cc9937f-b81b-4dda-8c92-934963b8f414', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-09 09:47:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8cca0c19-aaf0-45c5-8fc8-25c27edd4860', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 13:44:01', '2019-10-25 15:06:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8d3089e3-0f79-4f6e-b9d6-1f3e411b1ba7', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 13:28:31', '2019-09-23 13:29:41', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8db129cc-1495-4300-8022-5880aaa8f46e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 09:58:25', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8dba21af-959e-44b1-8cca-6df1c8984b6e', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:26:25', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8dbb09a3-d9cc-4954-aa45-189ecd6915ed', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-27 15:37:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8deeab39-2e10-412a-8114-c8a21f6f83d5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-16 09:01:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8df44095-94a3-469c-95fd-7c931ceb6695', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 11:46:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8e23f190-685c-491d-8835-92afffc7bf7c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-17 14:40:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8e7bd5a6-e8b8-43b4-96a0-3f6615edd4d3', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 10:32:17', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8e871bb7-96df-4db1-a4f7-d6c9b124f07f', NULL, NULL, NULL, NULL, NULL, NULL, '192.168.30.1', '192.168.30.16', '2019-06-20 01:40:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 'admin登录，错误信息：用户或密码错误;administator登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('8f54d33e-0069-4d62-8670-bace52602615', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-23 19:00:59', '2019-09-23 19:01:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('8fdadae7-ad67-47b5-83e7-6548325e1517', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 09:46:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('90113e1e-6efe-48c0-8965-dde08b2cb092', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.157.28', '192.168.122.1', '2017-11-10 18:47:46', '2017-11-10 18:48:04', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('90ca4432-5480-4b1b-8b83-ce17acb9c783', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-09 15:58:02', '2019-08-09 15:58:12', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('90e8b10b-6833-46cf-b471-2c5e00b290b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 15:18:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('91159af9-be9d-4cd5-a040-7b087bfbc0c2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-18 15:05:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('911dcfc6-7a14-4a64-864c-2e8df37b5e42', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 11:43:24', '2019-07-22 14:30:22', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('91479c20-9a57-4c1f-8c0c-26b6d324b75b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-05 18:05:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('91561a3f-b74d-480b-9537-6b39daa2e079', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 11:08:51', '2019-07-31 11:09:28', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('91ace529-b976-4559-8685-f53cd620a49c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-24 09:32:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('91de0299-85b5-440d-8700-982874c6504b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.156.167', '192.168.122.1', '2017-11-14 16:16:33', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('91e988cc-e0b5-4958-811e-aaa567ef82a5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.243', '192.168.31.197', '2019-09-16 17:05:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9257e217-ed4c-45c0-a99f-e28d72fb6f4c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:29:54', '2017-11-01 09:30:21', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('92bfcdb8-a917-448b-8916-d6bb376206fd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-18 16:59:37', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('92c59671-7c49-48f4-a953-78c859972b06', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-08 09:24:50', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('92cb7bc4-b6b2-4eeb-9f9a-27114f975be4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-23 23:56:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('92d8a435-4d7f-4d71-a22b-3576678d8318', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-26 17:33:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'chengcheng登录，错误信息：用户或密码错误;chengcheng登录，错误信息：用户或密码错误;chengcheng登录，错误信息：用户或密码错误;chengcheng登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('93420d75-d178-4f5e-bfcf-7fe2f4fdbcfe', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-24 11:02:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('9354afcd-b965-47db-bb26-00ff3d30b637', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.199', '127.0.0.1', '2019-09-17 13:52:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9389fb5e-edb9-4814-a373-40d872763fc2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-04 15:52:11', '2019-07-04 15:54:01', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('93a1b86d-e429-4c34-ba97-3d2388bf9d19', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 18:44:53', '2019-09-17 18:45:44', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('93a56a82-1dfd-4d9b-a9be-b754513d4084', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 09:44:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('93be23b6-2ca4-4273-ae4b-10f69ff58e6c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-02 14:36:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('93cf07e9-d88e-49de-b7b1-9b371bd70029', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 15:16:01', '2019-09-17 15:36:41', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('93e2a78f-9b7b-4cc4-bcfc-d2dcc6bc4fd8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.217', '192.168.122.1', '2017-11-03 14:41:32', '2017-11-03 15:02:45', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', 'bx登录，错误信息：用户或密码错误;bx登录，错误信息：用户或密码错误;bx登录，错误信息：用户或密码错误;bx登录，错误信息：用户或密码错误;bx登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('9413bdb1-1079-4c7a-96d3-6d5b96d2a949', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 18:46:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('946d40a0-2392-449f-b6eb-505ff57db801', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-20 17:59:50', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('94a84310-d7dd-4b77-9dec-4ccb29426f43', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 17:25:26', '2019-07-31 18:06:12', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('94d38f6f-d85d-493b-bde2-840eccf0066a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 17:10:51', '2019-07-17 17:12:00', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('94ef39f5-22e9-4533-96de-3e773d60c5a7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:20:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9500838b-9aad-4088-9ec8-c05dfafa943d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-05 17:14:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9504814d-74ce-49dc-b204-513c86f4412b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-20 21:10:03', '2019-09-20 21:13:10', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('950dfe28-0937-45aa-aed4-e47934082ba8', 'shanghaitech', '上海科技大学', '0107', '财务处', '100110@5C7117E6CE9D4125E050007F010057D5', '杨盈', '10.20.71.18', '192.168.122.1', '2017-11-03 13:22:29', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0107.dpt/5C7117E6CE9D4125E050007F010057D5.pos/100110@5C7117E6CE9D4125E050007F010057D5.psm', '/上海科技大学/财务处/管理岗位/杨盈', NULL, '100110', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('953433d9-22bd-490b-87e4-2f776b545ef7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.204.70', '192.168.122.1', '2017-11-03 08:51:55', '2017-11-03 09:00:15', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('95633790-964b-4860-9544-dacf8667e257', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-11-02 16:47:41', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('957df3c9-f610-401e-a796-c8a8100c6f1a', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '53D08F23B967404A9FA40EAFC0A20ABE', '人力资源部', '92208DB64629346BE050007F010012C2@6629FD1C2F384B6DA96213F979700DD7', '黄静', '192.168.3.246', '192.168.122.1', '2019-09-16 21:57:40', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/53D08F23B967404A9FA40EAFC0A20ABE.dpt/6629FD1C2F384B6DA96213F979700DD7.pos/92208DB64629346BE050007F010012C2@6629FD1C2F384B6DA96213F979700DD7.psm', '/中航国际/中航国际总部/人力资源部/员工/黄静', NULL, 'huangjing', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9606a503-e327-455b-94ca-1e00fc9bfc94', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 11:22:45', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9650fc96-bec5-4cd6-883b-3a7ea7c6907d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 15:40:20', '2019-10-15 15:42:47', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9665bb41-3a8f-4a82-af7b-c34c34921c44', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-18 10:01:33', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;renhaifeng登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('967fb156-a437-4b66-9ff3-cc3b6e040d1b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-20 21:13:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', 'admin登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('9683453a-01ef-43da-b073-91849dab4743', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.64.170', '192.168.122.1', '2017-10-30 13:32:57', '2017-10-30 13:33:11', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('968f1853-9b51-4227-bc72-ccfd516d8685', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-29 17:05:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('97394f55-7f7a-480c-995c-e2fbcd632b10', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.198.211', '192.168.122.1', '2017-10-30 10:35:09', '2017-10-30 10:36:52', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('975dc4fc-771d-433d-a897-892bc6c0e3f6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-27 14:23:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('97af15e9-0acc-433a-b098-478ef084bcb9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 17:08:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('97fdf18d-d1d3-4526-ba7b-e831a9d3f26d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 17:18:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('983b32ef-4cea-4ac5-8dac-895822ce0309', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.193.43', '192.168.122.1', '2017-10-24 10:08:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('98537112-720c-4759-bdf9-a40cdb4807bc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 15:22:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('98576c86-0e8a-47c4-9a70-31ee251d973f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.194.80', '192.168.122.1', '2017-10-17 17:14:25', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('98963233-a45a-41a6-a068-ff50e03501a2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-14 11:17:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9896e67a-2946-446a-a197-96f78f049d89', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-26 09:39:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('98ba97ab-ddec-4026-9d6f-4bec44e9cce0', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.19.156.208', '192.168.122.1', '2017-10-26 21:15:48', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('98d822a2-f51a-496e-a6cf-5efa7287b4e8', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'A831E75F9B1F492CB2B50589D8D5C741', '中航国际领导', '92208DB645EC346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '刘军', '192.168.3.246', '192.168.122.1', '2019-09-17 14:26:21', '2019-09-17 14:26:37', 'NORMAL', '92208DB645EC346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '刘军', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/A831E75F9B1F492CB2B50589D8D5C741.dpt/85979EC22D6F4042BE72F256A2089C6E.pos/92208DB645EC346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E.psm', '/中航国际/中航国际总部/中航国际领导/分党组成员副总经理/刘军', NULL, 'liujun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('98eeabad-09f1-485a-85c3-fab21e668b05', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 14:43:54', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('994ebba7-dd80-4f01-86cb-b82dc5bca8dc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 16:06:53', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('99607fae-0628-4350-b9f3-2c89f2951a9e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 14:33:01', '2019-10-15 14:46:39', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('998e9ca9-1fa0-4f21-b2cc-d101846b7ea2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 15:25:37', '2019-07-22 15:26:09', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('99907df5-3a4c-4c35-b692-16d8c0b154ba', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.201.1', '192.168.122.1', '2017-10-30 16:56:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('99d792bb-5ca5-42a0-a0e3-1698d1447a1e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-13 18:31:14', '2017-11-13 18:32:20', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('99db9c20-63c6-4c44-950b-23e41033ba44', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-14 15:00:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9a07a0cb-6be2-4913-9ba6-7c1d7eee4ce3', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-16 17:45:23', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9a1ceaf5-9688-447c-8076-78343b1b6d3a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-24 10:34:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9a228d72-311c-40bb-a53a-53223d9aad1a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.205.146', '192.168.122.1', '2017-11-01 09:03:46', '2017-11-01 12:24:44', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9a4560a6-e7e2-4569-a810-504e300f5b4d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 18:38:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9a80d532-dc61-4146-b65e-21cc460c3e35', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.196.184', '192.168.122.1', '2017-11-13 18:33:10', '2017-11-13 21:34:34', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9a84285a-c286-4014-904b-91c78008ef27', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 13:57:05', '2019-10-15 13:57:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9ae9c689-6231-463b-805e-4adae0c97f01', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 15:14:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9b915370-bc20-4813-9c0e-44d4d23696e5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:31', '2019-07-08 11:34:35', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9bba6277-6735-4af7-b515-33bd6dbccd98', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-02 18:01:39', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9bf23070-9b4b-4e62-b9d9-ba925eb55cec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 09:20:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9bf6cec3-d124-4317-ab26-c37430b6f57f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.157.83', '192.168.122.1', '2017-10-29 15:33:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9c04afd5-3589-4279-8bcb-47e9a0972351', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.68.67', '192.168.122.1', '2017-11-13 14:48:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9c2d6b12-b813-4896-bdae-268f8932ae10', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:36:23', '2019-07-08 11:36:29', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9c857ccc-ca52-490f-a350-40b9ee3a8ff4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:36:57', '2019-07-08 11:37:01', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9cbc09c4-7c92-4cd0-af76-b94fa4092d1e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 11:02:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9cd94401-a6c7-44c4-90c6-a6d481a91cd9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-18 17:24:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9d68bd9c-0573-41ca-9b40-b0c4f64a2320', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 16:40:30', '2019-06-28 16:42:34', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9dba01bd-a39c-4b91-b8f2-4eaa29ec0c16', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:22:11', '2019-07-08 11:33:25', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9dbeb260-3648-4032-b9be-be9035769ca5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-24 12:54:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('9dd232ff-f3e4-4a14-8bcd-2157a93ba041', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.250', '192.168.122.1', '2019-09-16 15:55:12', '2019-09-16 15:55:39', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9e235773-3fbe-40fa-868a-ece028b50647', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.3.51', '2019-09-18 19:36:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9e69b53b-6298-4bda-bec2-0ac4a155d2b7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.248', '192.168.122.1', '2017-10-30 11:01:58', '2017-10-30 11:05:29', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9ed30dee-2409-4345-b9e2-4a0f4a425877', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 14:58:16', '2019-09-23 15:18:56', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9ef7a1f1-39b2-463f-80e0-d146d0b56bee', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.200.183', '192.168.122.1', '2017-11-03 15:43:49', '2017-11-03 18:02:11', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9f0b0b7a-4176-410a-adc8-cfe2add7de9a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.19.156.149', '192.168.122.1', '2017-10-12 10:14:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9f69cc53-0e35-4c14-be8d-d65923bdcfe2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-27 11:21:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9f707884-1049-4d45-b644-d43411762c22', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:46', '2019-07-08 11:34:51', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('9f8e8427-2ea7-41f5-8343-415eb121fad3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.202.173', '192.168.122.1', '2017-11-16 09:48:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a00928e3-cf10-42ff-acf6-7e352dc575da', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 11:03:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a021ba83-af26-4e50-a964-c2195f0c9c59', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-27 16:14:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a06e2ea8-83f9-4b48-bcad-0123d0b485c2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-11 17:35:05', '2019-09-11 18:07:43', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a08948f2-e25e-4dc4-9059-e94ab1a72dda', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.199', '127.0.0.1', '2019-09-17 10:52:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a09cf265-1efe-4591-93d8-547da47b6fe4', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.31.243', '192.168.31.197', '2019-09-16 16:21:09', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a0a38d23-8431-41b7-860e-333c6b284d0b', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'A831E75F9B1F492CB2B50589D8D5C741', '中航国际领导', '92208DB645EC346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '刘军', '192.168.3.246', '192.168.122.1', '2019-09-17 14:27:08', '2019-09-17 14:27:49', 'NORMAL', '92208DB645EC346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '刘军', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/A831E75F9B1F492CB2B50589D8D5C741.dpt/85979EC22D6F4042BE72F256A2089C6E.pos/92208DB645EC346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E.psm', '/中航国际/中航国际总部/中航国际领导/分党组成员副总经理/刘军', NULL, 'liujun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a0b35db9-8749-450b-99bd-e7c6a6c3476c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.55', '192.168.122.1', '2017-11-15 16:29:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a1110935-98b1-476a-9a5d-e91e815370a8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.194.216', '192.168.122.1', '2017-10-27 15:22:50', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a141f6b7-7934-4a43-9dbe-a127b054980e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.171', '127.0.0.1', '2019-11-11 14:53:37', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a1916446-7a3b-4cba-ac2e-49001ee7032e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-09 16:42:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a1a3f3a9-8466-458e-8faf-78863d911bb2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-17 14:11:51', '2019-09-17 14:21:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a1edcc93-0520-439f-bf44-3b4bdd2371ea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 21:50:03', '2019-10-07 22:06:28', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a25ad3b5-63e2-47d8-9afb-7c03b541878d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:33:57', '2019-07-08 11:34:03', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a2715738-2046-458c-80ea-217b9c3f89f7', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'E063FA370196429C848F251CC26B3F20', '规划发展部', '92208DB64620346BE050007F010012C2@3E05CFC4945A4262802B18041956866D', '李莎', '127.0.0.1', '127.0.0.1', '2019-09-29 17:53:27', '2019-09-29 18:04:21', 'NORMAL', '92208DB64620346BE050007F010012C2@3E05CFC4945A4262802B18041956866D', '李莎', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/E063FA370196429C848F251CC26B3F20.dpt/3E05CFC4945A4262802B18041956866D.pos/92208DB64620346BE050007F010012C2@3E05CFC4945A4262802B18041956866D.psm', '/中航国际/中航国际总部/规划发展部/员工/李莎', NULL, 'lisha', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a282bbdc-7b9a-461e-ad0d-3a0e41dae63c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 15:01:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'adminstrator登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('a2a2c0ac-1852-4520-948b-3882aa73ea2a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 12:41:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a2a93586-8820-49b7-b755-725aaf7a3f6a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.67.40', '192.168.122.1', '2017-10-23 13:30:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a36c0c97-2c2f-4d58-a297-0a2351c10825', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 19:12:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a382a98d-b708-440b-beea-74989c02be34', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.35', '192.168.122.1', '2017-11-12 10:16:42', '2017-11-12 10:18:03', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a38e2e00-658c-4990-84f7-49aad2d4bbfd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.16', '192.168.122.1', '2017-10-27 11:35:17', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a3a18698-a486-433e-ac6d-9a2857678192', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 16:20:48', '2019-07-31 17:41:51', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a3c5e761-7b33-4392-bdd3-84221d59ba86', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-26 14:59:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a3cff47c-669e-42a0-97fe-e3ea84250f46', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-26 18:05:34', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'ceshiyonghuyi登录，错误信息：用户或密码错误;ceshiyonghuyi登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('a4a5e4a6-81ca-450f-80c5-4896cc1dea7d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 16:45:10', '2019-06-28 18:06:37', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a4d60181-1faa-4c2e-a8b6-d8ef1edf4c50', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '192.168.31.234', '2019-06-20 18:07:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a4fdeab2-29f8-4808-ab58-cd3da831a5c1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 17:01:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a59c8b43-726d-4ffb-be8f-7abbf4117f5d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.68.67', '192.168.122.1', '2017-11-13 14:43:47', '2017-11-13 14:44:18', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a5a4b2e5-3b98-4000-8bd0-a55307eeab89', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-08 14:56:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a69c63c7-62b1-4c7d-85fb-402054d1ccb7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 18:40:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('a6a44099-da43-4b0d-b062-d40ec9848a0e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 15:29:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a6c767ce-266b-4150-a008-19f6081efb5b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 13:35:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a6cac7a2-ffe9-402b-a53e-f15ab66bcd1f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:35:26', '2019-07-08 11:35:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a720846e-944e-4fb3-b3ab-73c786e474aa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.19.156.217', '192.168.122.1', '2017-11-03 09:01:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a7b354d3-3361-41e9-b721-c9488d858c19', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 14:55:07', '2019-08-01 15:48:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a7bc7b25-ed6c-4a04-96fc-b1afe938b0dc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 16:49:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', 'admin登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('a7c22024-ce49-4759-9627-00f18e9a87a8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-18 13:56:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a83f117f-c4e5-4730-8637-d5f3142a8cab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-29 10:53:57', '2019-07-29 10:54:43', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a852c886-363f-4ff8-b99a-d2360287bcfa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.198.229', '192.168.122.1', '2017-11-01 15:25:29', '2017-11-01 15:28:01', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a869a1a2-966f-4611-ae04-642bc64607a9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 15:24:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a877fe8c-39ad-4b2e-b0c4-b2ef53804f23', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-09 16:15:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a8d07653-23fd-473f-946f-ffa45046715c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-23 19:39:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a90bbe2e-3f30-499e-a53d-91cb60137001', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 12:44:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a9bd97bb-cc8d-4372-87d1-41e192ce5c65', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '业务系统管理者', '10.20.193.247', '192.168.122.1', '2017-11-14 18:25:04', '2017-11-14 18:25:24', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '业务系统管理者', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/业务系统管理者', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a9f7071e-4d68-4308-a09b-d6bc56acc795', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 15:46:39', '2019-10-15 15:49:09', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('a9f9279b-b089-4e06-8f67-c0481f5737e7', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.31.243', '192.168.31.197', '2019-09-16 15:54:32', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aa1e5860-23a3-44f3-aff3-efac2497b736', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-11 16:17:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aa4f1b6d-deea-454b-aa1f-4b4726c19caa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 10:11:06', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aa74c679-b821-4061-8aeb-fd2bf7c934d3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 11:20:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aa894336-5220-4713-b559-66ffdbfcfca7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 22:05:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aaa1c9ca-ddfd-40c0-9b04-108ff80439fa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-18 16:48:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aac00206-8a9f-4dd0-9214-0d18a0779bc7', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.250', '192.168.3.51', '2019-09-23 18:58:30', '2019-09-23 19:00:52', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aac33bce-121c-40db-b4c4-a92458b3fe15', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.156.117', '192.168.122.1', '2017-11-16 08:56:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aacdd252-5b59-4e4a-bb5c-26710514f1cf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 14:00:25', '2019-09-23 14:01:39', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aae10a14-519b-4bf5-a538-b6b7705c1fc7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-25 09:13:40', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('aaf7d828-36f1-458e-a046-d64e088632b6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.122.1', '2019-09-16 15:54:30', '2019-09-16 15:55:01', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ab618168-2eeb-4073-99a8-0794bda53724', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-03 09:28:01', '2019-07-03 14:38:49', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('abb6e050-3f1d-4787-8cb1-845de42905df', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 10:35:02', '2019-07-31 11:08:47', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('abc8a9fc-f914-45b0-b42f-f89c981d7d43', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-01 16:47:29', '2019-08-01 16:56:14', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('abcd889b-c4a2-4b4b-acea-b3869215d280', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:52:43', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ac23ea1c-551b-43c3-9928-a9d004f20396', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 10:34:37', '2019-09-23 10:35:11', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ac8ad681-dd89-45bd-9188-a0526ed95363', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.31.243', '192.168.31.197', '2019-09-16 16:37:43', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('acdce931-0c43-4c5a-8ebf-00d25ab6c4b1', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-10-30 14:02:46', '2017-10-30 14:26:03', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ace8d3c7-b9d9-4ce8-92f6-ac8453fad724', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.122.1', '2019-09-16 20:19:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('acf7a0c2-380e-4a0f-9e6d-273e84a25059', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.238', '127.0.0.1', '2019-07-18 14:38:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('adb682b2-319b-4031-aa80-36e97739bfd1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:38', '2019-07-08 11:34:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('adf5aaff-c438-473d-9803-4359f0c33580', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-20 13:15:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ae8fafc2-04ba-4ee8-8338-98692d2bf736', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-10-30 11:21:11', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('af459922-6fa4-49a9-9380-58dfa5d3acab', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.67.91', '192.168.122.1', '2017-10-30 14:26:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('af88bf3a-30f4-4c1a-b12d-d1b9d1b5b979', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.184', '192.168.122.1', '2017-11-13 10:07:23', '2017-11-13 11:41:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('afc8f52c-24b5-4f9d-a3c8-b7ead8f714e9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:25:44', '2017-11-01 09:29:46', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('afc90318-0960-45ef-b05e-9ac31e33708c', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-12 16:20:07', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('b01be1b6-58de-471c-baca-61f9f4cb5c1f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.234', '127.0.0.1', '2019-06-17 11:04:17', '2019-06-17 11:17:02', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b04ffda0-2312-4091-9410-ec4ee123b2ec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-12-24 12:32:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b075621c-2107-42ba-ab2f-8d320fea252c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-22 15:30:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b086dd6b-8acf-46b5-bc8a-007bb491307a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9C23A34E91064D5689F0E2B26F8CCC50', '外部部门', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', '192.168.3.240', '127.0.0.1', '2019-06-14 16:59:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/9C23A34E91064D5689F0E2B26F8CCC50.dpt/BE63FABAF205467788621D9695ED09D7.pos/8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7.psm', '/外部机构/外部部门/初始化岗位/子君', NULL, 'zijun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b0fe7afb-b0c7-4e93-9d16-3baf16d85157', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 16:03:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b101d824-5052-435a-b329-f457d9b6ddfa', 'shanghaitech', '上海科技大学', '0108', '公共服务处', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', '127.0.0.1', '127.0.0.1', '2019-07-03 18:07:08', '2019-07-03 18:26:10', 'NORMAL', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', NULL, '/shanghaitech.ogn/0108.dpt/5C7117E6CE814125E050007F010057D5.pos/100184@5C7117E6CE814125E050007F010057D5.psm', '/上海科技大学/公共服务处/管理岗位/胡玲玲', NULL, '100184', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b105c34d-0a5e-4968-a437-fbac5f65adff', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.248', '192.168.122.1', '2017-10-30 11:05:51', '2017-10-30 11:05:56', 'NORMAL', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b11d651f-0739-4780-a018-06188d91a7f9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-27 09:45:06', '2019-06-27 14:29:21', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'admininistrator登录，错误信息：用户或密码错误;admininistrator登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('b18c996c-0f53-4502-81e5-d947649de25b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 09:21:23', '2019-07-22 11:38:46', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b2135533-ff85-4458-83e7-9a11bff5a2c9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.203.190', '192.168.122.1', '2017-10-27 12:53:38', '2017-10-27 12:53:50', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', 'bxr登录，错误信息：用户或密码错误;bxr登录，错误信息：用户或密码错误;bxr登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('b24d0ec0-09fd-4d74-a764-c0dd9f82af69', NULL, NULL, NULL, NULL, NULL, NULL, '192.168.3.250', '127.0.0.1', '2019-07-08 11:20:23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'xx1000', 'xx1000登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('b28456b1-b92f-456a-97ea-3e20b8e13f31', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 13:56:03', '2019-10-15 13:56:41', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b3400955-a913-4f5a-a814-338b6fe459c3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.199.214', '192.168.122.1', '2017-11-01 09:03:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b3e3d1d9-ffdf-4a91-b1e2-23175a1e08e6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-26 14:08:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b3f10780-45a0-4f0c-bb56-8567be6ac1cc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.202.173', '192.168.122.1', '2017-11-16 10:32:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b42b1b02-ec8c-44ff-be63-86d7ae98b0c5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9C23A34E91064D5689F0E2B26F8CCC50', '外部部门', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', '192.168.3.240', '127.0.0.1', '2019-06-14 16:58:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/9C23A34E91064D5689F0E2B26F8CCC50.dpt/BE63FABAF205467788621D9695ED09D7.pos/8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7.psm', '/外部机构/外部部门/初始化岗位/子君', NULL, 'zijun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b4445244-a12a-48ec-98da-b2c32b9b42e5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 15:33:41', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b44e1556-5719-4eed-988b-ddd272e17d91', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 11:34:36', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b45fbcab-6614-41e9-a5e6-fce6c9788525', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 09:02:56', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b46f7700-0b0b-4e86-aa78-d2eeec90fd00', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-08 23:06:06', '2019-10-08 23:06:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b47158c2-f5ee-4445-bff4-9a2c3261ca8d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-25 18:41:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b4b17477-a64c-4d93-a0e3-6c42d62fba28', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 10:33:42', '2019-09-23 10:34:29', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b5136f14-5ef8-4263-9f2f-c12c08ec7c2d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 14:33:28', '2019-08-01 14:54:59', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b52e9043-7d98-4557-ae6a-d9db53a46705', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-02 11:54:00', '2019-07-02 17:56:58', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b552b8cd-7985-4646-9516-84363b6dcaaf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 14:41:10', '2019-07-08 17:51:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b5ba78ca-7dfe-4777-aaad-31afb4bded05', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.247', '192.168.122.1', '2017-11-14 17:34:16', '2017-11-14 17:45:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b61486d7-b4fc-4bea-ad73-9e96e7491476', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-04 15:57:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b635e9a2-c222-4b8a-8c5c-2a110abb5c42', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.234', '127.0.0.1', '2019-06-17 14:14:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b667d498-6f71-4117-8538-d2b6795429e4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.157.28', '192.168.122.1', '2017-11-10 17:52:48', '2017-11-10 18:04:30', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', 'cw登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('b66b02c6-f526-4199-bf8e-13ba02dc411e', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-18 10:02:19', '2019-09-18 10:29:31', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b6c75c92-7c3e-4319-af63-1e63619c8234', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.199', '127.0.0.1', '2019-09-17 15:36:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b6e01292-11c0-4a2e-b7fb-fa15d984aff1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.247', '192.168.122.1', '2017-11-14 16:18:02', '2017-11-14 16:19:39', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b77a67d9-d32b-4d6a-a985-a12fe2a94eaa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.64.170', '192.168.122.1', '2017-10-30 14:08:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b7b8ae67-e836-4e62-bfea-a54a0fec0d95', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 14:33:28', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b7bf4704-1bc9-4c7d-af8e-f03293a2a077', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.198.84', '192.168.122.1', '2017-10-18 09:07:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b7da59d8-426d-4a74-8175-a5cd210cf657', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '192.168.31.234', '2019-06-20 18:01:45', '2019-06-20 18:07:10', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'tsadmin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('b839f754-f774-45c3-9324-8b6ba142d4b1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-08-06 17:50:31', '2019-08-06 17:54:42', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b859a68d-365e-4ab6-a742-b42b98a65f81', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 09:47:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b87966b0-c8f6-4930-b578-0d3e7d3cfb9e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.204.70', '192.168.122.1', '2017-11-03 08:41:34', '2017-11-03 08:47:33', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b8dcc485-7ef8-4558-8d77-28e84257a631', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-13 15:59:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b9230c6a-2741-4c47-9a12-523e43e75788', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9CFD16A01ED045E3AC40592EE1CB829D', '腾讯科技', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-12 18:53:21', '2019-08-12 19:00:20', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/9CFD16A01ED045E3AC40592EE1CB829D.dpt/B6ABC4E9E5334573A137547641F72B60.pos/8BAA4A9090EEC786E050007F010059AB@B6ABC4E9E5334573A137547641F72B60.psm', '/外部机构/测试代理商部门/腾讯科技/销售员/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('b98dadd9-309b-4f15-ac38-6100a0791ab4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.198.211', '192.168.122.1', '2017-10-30 10:37:41', '2017-10-30 11:01:19', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ba246b1d-d03e-4653-9064-ea19542cbd44', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.123', '192.168.122.1', '2017-11-15 17:23:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ba9b6782-fbd6-48f7-a3dc-e1ca96057ae4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 17:43:11', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bad40761-063c-4f91-8a9a-96a3d089d7e7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-05 11:55:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bae3f06a-e3a4-4a3d-991f-7d162a2ce97f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.234', '127.0.0.1', '2019-06-17 11:26:52', '2019-06-17 14:05:11', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bb2952bf-1b71-40c6-b430-885ddaf92e8d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-07 12:47:37', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bb2dbc3c-9eb1-4c60-88f3-39587ec442c7', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 16:57:03', '2019-07-22 16:57:18', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bb51fb95-c98d-4557-8cde-cdb971978aa9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-19 09:26:35', '2019-07-19 09:41:40', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bc09d89e-80bb-4290-acbb-e5e6c199c1bc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.198.211', '192.168.122.1', '2017-10-30 10:27:47', '2017-10-30 10:35:01', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bc1fdd97-9305-4c28-a13c-7446376d14a3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 16:24:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bcba131b-2a7f-454d-96bf-d2fc09e53761', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:55', '2019-07-08 11:34:59', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bcc3b3a4-1a5a-4a6d-86e8-466cb7a08a3e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-19 10:04:00', '2019-07-19 10:30:04', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bce8a890-5128-469b-9836-ae50f29ce53e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.16', '192.168.122.1', '2017-10-27 13:28:26', '2017-10-27 13:39:02', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bcfd6964-9c9b-4302-a362-2fbe905bfc8f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 13:32:09', '2017-10-27 13:38:22', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bd1e0de8-b122-4301-8a62-7a20915b21b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-05 09:20:22', '2019-09-05 11:55:00', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bd1e860a-053d-4571-ae73-5cda25e7dd0b', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', 'A831E75F9B1F492CB2B50589D8D5C741', '中航国际领导', '92208DB645EF346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '李其峰', '192.168.3.246', '192.168.122.1', '2019-09-17 14:28:25', '2019-09-17 14:28:42', 'NORMAL', '92208DB645EF346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E', '李其峰', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/A831E75F9B1F492CB2B50589D8D5C741.dpt/85979EC22D6F4042BE72F256A2089C6E.pos/92208DB645EF346BE050007F010012C2@85979EC22D6F4042BE72F256A2089C6E.psm', '/中航国际/中航国际总部/中航国际领导/分党组成员副总经理/李其峰', NULL, 'liqifeng', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bd3074ab-928d-45cd-b917-c7c0edfb5309', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-05 15:43:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bd403414-1744-4cd9-ada0-c24161f8aba2', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 14:41:06', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bd41033b-fecb-4f44-9f58-c69a049846a4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-04 10:06:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bd64612a-829a-4a92-be5d-8de1306a3888', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 14:26:48', '2019-09-17 14:27:00', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bde861d5-46b2-40c9-b681-de3327091bf4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 22:16:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('be00dc68-10ae-47c9-8215-bb042a473df0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 10:02:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('be2d30a1-601c-4ea8-aeec-c0cd31970cca', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-25 13:55:22', '2019-07-25 13:55:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('be33db74-56ca-40f6-b262-fe9784d06b8f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-03 09:28:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('be8816db-6c6c-45ce-bf2d-4ac34b73791e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-25 10:15:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bec9f6e6-a399-4512-9dd2-e8ff77e45fc2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-18 17:51:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bee064b3-8dac-4d1f-b300-5e7cd9e79860', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-16 11:30:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bf3ec8c9-358e-45fa-a52b-dafbca728907', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:33:33', '2019-07-08 11:33:41', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bf44f46f-e57a-4298-9bb0-469edd992e4a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-02 15:54:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bf582a18-f1f4-4710-9242-27b3ae62d294', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.199.214', '192.168.122.1', '2017-10-30 11:01:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('bf6808ca-9c6b-4e2a-9b32-29f8308f6a5c', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.67.91', '192.168.122.1', '2017-10-31 14:06:07', '2017-10-31 14:06:10', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bf75202f-ec48-4fb2-ab96-f0deb1aa22eb', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:55:59', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bf7dcb48-3523-4eb9-9473-f325878b7d62', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-24 22:30:55', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bf7fc1f4-8021-410f-a87e-04f4cf6dbfa6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '9C23A34E91064D5689F0E2B26F8CCC50', '外部部门', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', '192.168.3.240', '127.0.0.1', '2019-06-14 16:58:56', '2019-06-14 16:59:53', 'NORMAL', '8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7', '子君', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/9C23A34E91064D5689F0E2B26F8CCC50.dpt/BE63FABAF205467788621D9695ED09D7.pos/8B45CB8C8875A315E050007F010058E2@BE63FABAF205467788621D9695ED09D7.psm', '/外部机构/外部部门/初始化岗位/子君', NULL, 'zijun', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bfa18624-8e34-4097-99c5-756735c6fa4d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.68.67', '192.168.122.1', '2017-11-13 14:44:24', '2017-11-13 14:44:33', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bfa4dafa-fbe0-4774-823f-bb4b71105729', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.122', '192.168.122.1', '2017-10-26 17:25:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('bfb102cf-a328-4010-8701-7cbf2ffcbf3f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.194.60', '192.168.122.1', '2017-10-10 08:28:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bfb1e19f-c5c4-4ab5-bf60-c40697920d41', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 11:35:34', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('bfce058d-59bf-427c-95a3-d435835077eb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.196.248', '192.168.122.1', '2017-10-30 11:06:04', '2017-10-30 11:06:08', 'NORMAL', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c07013f8-11c2-47cf-924d-cc739f373ce4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-17 14:37:10', '2019-09-17 14:38:45', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c0a19591-3d56-40d9-b429-74111a10a303', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-23 15:42:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c0af74cd-2116-47fb-99d8-9223b05c7f2f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 17:47:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c0d1f666-9df5-4b5a-b7ae-f8079649ec14', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-08 17:15:04', '2019-08-08 17:16:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c0d88f52-d6cf-4ee4-a784-8c8345215d1b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.157.202', '192.168.122.1', '2017-11-02 18:46:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'admin登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('c143ae55-5ec4-47d4-ba88-b6b66cf23922', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-22 09:59:27', '2019-07-22 09:59:53', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c195e6a0-935c-4568-9910-707f2af44084', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 12:45:14', '2017-10-27 12:52:01', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c1e8b9de-2e2f-4e5d-9e68-78085f37704a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 17:37:44', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c2077b79-57d5-484f-832e-b58ac2aef3af', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.204.70', '192.168.122.1', '2017-11-03 08:47:45', '2017-11-03 08:51:49', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c2271d74-1a6c-46fa-8ed4-b69054f66439', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.246', '192.168.122.1', '2019-09-17 15:57:21', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c2a7cd06-7e3f-4fa8-ba98-56c3eecf758e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 17:58:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c2bc1a02-3ffd-4fec-8152-d740d9566909', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.3.51', '2019-09-18 20:02:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c308fedd-221b-4be9-99f9-56dc169ed6e8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.198.229', '192.168.122.1', '2017-11-01 15:28:10', '2017-11-01 16:37:19', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c30ce610-cbc3-4826-8c52-421d6c55118e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-20 17:51:13', '2019-06-20 17:52:27', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c33a9c88-c587-456c-894b-f70936383baf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.196.35', '192.168.122.1', '2017-11-01 10:35:45', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c370ee4f-eb60-431c-a5b5-84ea08cac136', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-26 10:13:24', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c378fe39-8900-41ad-a28f-5cfc4ec210f3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:11', '2019-07-08 11:34:14', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c3878efc-97a2-4f43-994d-4dd41e8d9e7e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.246', '192.168.122.1', '2019-09-17 18:43:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c3951bc7-49e6-4e04-a9f5-34c02683ce0c', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-01 11:23:13', '2019-08-01 11:43:35', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c3a1039f-79bf-4340-83e7-7ade0c066521', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.31.243', '192.168.31.197', '2019-09-16 16:19:31', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c3a787c3-847d-4df6-bac9-bd4978bb9919', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.196.35', '192.168.122.1', '2017-11-01 10:04:18', '2017-11-01 10:35:43', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c424e016-083b-4c47-a114-d2cbe1a880f7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 17:21:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c4624bb6-c0ca-4120-9f7b-9056fd1e14e6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.67.91', '192.168.122.1', '2017-11-03 13:32:10', '2017-11-03 13:32:13', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c473bd4a-c060-4217-a172-9c5efdb100e8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-17 21:08:27', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c473f6f8-ce90-4a84-93a2-cf4849fd0459', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.196.10', '192.168.122.1', '2017-11-03 18:08:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;administrator登录，错误信息：用户或密码错误;administor登录，错误信息：用户或密码错误;administator登录，错误信息：用户或密码错误;administator登录，错误信息：用户或密码错误;administator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('c48b6001-13ae-4580-8df2-7f91e68b90e2', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.250', '192.168.122.1', '2019-09-17 21:02:42', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('c4f9d98a-51b4-41f8-95e0-d1edff9a7867', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-21 11:13:45', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c4fb1d16-3ec3-448d-a6e9-82feffebdd2a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-29 10:00:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c519e198-5c9e-4513-add6-a8ed04844402', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 14:49:20', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c52faf78-2aa2-428d-a3be-de413b57fb1b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-07 22:35:33', '2019-10-07 22:42:33', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c55916d5-a6af-413f-8254-8944ff8d1010', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.194.156', '192.168.122.1', '2017-10-16 09:54:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c587dc87-e2fb-4138-9c26-07656c15aee4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-17 09:37:32', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c5963357-1b7d-45ac-a921-b2c417b5eb5b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-06 16:10:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c5bed768-3370-4105-a85c-77dd0c581d3d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 10:32:56', '2019-09-23 10:33:36', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c604547c-6160-46af-adb5-9d62e398e432', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-26 09:24:12', '2019-09-26 09:27:03', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c6717978-bf4f-41bf-9467-ac1299a59196', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.122.1', '2019-09-16 15:51:03', '2019-09-16 15:54:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c6b8099f-0c11-41c1-9b82-87fa1d39a331', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 09:41:31', '2017-10-27 11:31:45', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c6d76696-40ec-46a2-adbf-5f10d1ef7cd0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 10:08:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c6df599b-6c59-4d74-9b2a-f1c4ff69f5ce', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.194.60', '192.168.122.1', '2017-10-09 16:07:43', '2017-10-09 16:09:08', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c6e5122b-4060-4401-a4c4-ad20cd01e142', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-16 18:04:23', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c6e5e51f-feca-4f3d-bce4-c65d0359cc7b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-13 09:35:13', '2019-08-13 12:14:24', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c749cd8d-b252-462d-9d50-71fd69463b2a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-16 17:05:23', '2019-09-16 17:21:35', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c77627b0-f187-4b0a-b3f9-fedcf6bc7c91', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-09 15:52:12', '2019-08-09 15:57:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c780801c-36dc-429b-8d2c-b52518b652e6', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 18:07:16', '2019-06-28 18:08:23', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c7cf8b2e-74ae-49c3-a401-9bea134543c2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.127', '192.168.122.1', '2017-10-11 13:25:18', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c817034d-9822-47f2-afc2-72e35fc18516', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 16:56:45', '2019-07-22 16:57:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c859eb72-ad99-498d-beae-43d88c7d3292', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-08-12 09:01:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c89403df-b48c-4420-88a3-cbe3808aaa82', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.199.106', '192.168.122.1', '2017-10-10 15:52:15', '2017-10-10 15:53:50', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c896ad7b-c2b7-4ec5-8ec5-f989de46ac27', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-31 11:09:34', '2019-07-31 11:09:57', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c8c48db3-9590-4f8a-ab53-bdd4ce121ab8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '单据填报人', '10.20.193.247', '192.168.122.1', '2017-11-14 17:36:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/单据填报人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c8cf0295-5e89-4ce3-a32e-bed755608e7c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-09 11:44:51', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c90b6073-6770-4e99-bc6c-f0c317827a31', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', '10.20.196.184', '192.168.122.1', '2017-11-13 18:30:29', '2017-11-13 18:30:44', 'NORMAL', '100614@5C7117E6CD9C4125E050007F010057D5', '杨博', NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100614@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/杨博', NULL, '100614', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c9479ca9-bde1-4a45-a4d1-3943c33ca9a9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 14:56:31', '2019-07-22 15:04:10', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c9b25fd8-01ba-41db-90a6-d2de7b3c0952', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-29 11:50:26', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c9d141bb-414d-4138-85ef-56c81f18b973', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:06', '2019-07-08 11:34:09', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('c9ef4d1c-7b33-45de-af45-e0cc00c339b8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.170', '127.0.0.1', '2019-10-08 13:56:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ca00f334-664f-4f03-8171-a49e173b930d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-12 11:04:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ca0d0b6d-d12a-49f5-846b-0bb1d4d2853e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-16 16:51:16', '2019-07-16 17:48:07', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ca406227-3a25-46f1-90c0-2d469d2de3e9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.200.183', '192.168.122.1', '2017-11-03 18:02:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ca92a985-a6d5-4dcb-a24d-bc900593f167', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 10:17:39', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cae1bf50-1db2-4eb1-97bb-d8b043b9f493', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:34:24', '2019-07-08 11:34:28', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cb25ab25-f2d4-4f70-a40e-cb55b612de9c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 11:43:42', '2019-08-01 11:47:28', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cc13d5da-8e5c-4c15-9c23-4c3f73c5af4d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-26 17:29:43', '2019-09-26 17:56:07', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cc1c60b4-68fb-4afd-ade3-29b2ae23b539', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-13 14:56:59', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cc2b7b7b-51b6-438c-94ec-206685059260', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '单据填报人', '10.20.193.247', '192.168.122.1', '2017-11-14 17:07:26', '2017-11-14 17:09:35', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '单据填报人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/单据填报人', NULL, 'bxr', 'brx登录，错误信息：用户或密码错误;brt登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('cc97db77-e985-4417-be4b-ff28040b3d4d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.190', '192.168.122.1', '2017-10-27 12:55:41', '2017-10-27 13:28:40', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cca24eb6-e54f-4b5d-b8a8-620d1ab4fcbe', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 10:46:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cce33df1-7483-4b70-af68-ed0f317fa83d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-21 15:04:45', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd1f85c8-e34f-4f88-b37d-d2aae970d510', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-27 09:31:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd42b5f1-ef08-494c-b2e6-ea743f65ff66', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:21:01', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd5eb11f-8d5b-456a-9b66-e8717704bf57', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.194.213', '192.168.122.1', '2017-11-01 13:59:52', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd69e49c-302d-4518-be12-3523baabf173', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.206.19', '192.168.122.1', '2017-11-09 13:31:57', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd7933db-525f-4633-bb93-416bcb026554', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-18 14:04:23', '2019-07-18 14:05:02', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd7c80c5-5895-4a41-8bcb-1494777da05c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '192.168.31.234', '2019-06-19 15:51:46', '2019-06-19 16:56:07', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cd9245dd-0992-429f-aa8a-b8262b7456a5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', '10.19.157.188', '192.168.122.1', '2017-10-27 14:00:30', '2017-10-27 14:23:23', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ce1744c7-99db-4bbb-9707-303655116022', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-23 17:28:28', '2019-09-23 17:29:31', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ce48064d-d922-4f15-9614-8d73d948b907', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-06 13:47:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ce845386-a40a-4c0f-b46f-48c0a771082e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-19 13:53:14', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ceba8912-fa1e-45e9-998b-a047c86e1a4e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '192.168.31.197', '2019-09-27 11:47:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cebd61f8-663e-4cc4-a35d-c90cacc9a6bc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-09 17:21:00', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ced0cf78-8380-4e93-ab33-b537795e7abf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.198.211', '192.168.122.1', '2017-10-30 11:20:18', '2017-10-30 11:24:52', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ceec2bf2-88d8-40ab-a716-7acb50053c7e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-15 09:37:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('ceff70fd-0f3b-4edd-b436-487b5e05ab59', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-16 09:19:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cf44b46b-9f83-40a8-9c7c-5d899eb63ecc', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 11:09:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cf696a26-0dd5-45f7-9b44-e68d730d3aa2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-08 21:54:45', '2019-10-08 21:55:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('cfb2267c-a097-482b-ade0-00f224bffef8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 09:06:53', '2019-07-05 10:54:23', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d00be19d-4ffb-4841-9e48-7c6599b341e1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-16 09:02:33', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d010c685-7551-465a-bbcc-718d4a5f4368', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 14:37:17', '2019-08-01 14:52:15', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d01da988-b2d0-422b-98dd-5a094ef36b70', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-05 19:10:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d04baca2-854c-42b1-bd7a-c611f7849c7c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-28 18:09:15', '2019-06-28 18:11:05', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d05f3bb6-acdf-4b72-b2cc-6e9c9fbe2008', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-08 17:51:49', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d06edd78-c96c-4a2a-97f2-ba36509e2bb4', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-08 15:40:14', '2019-07-08 17:51:44', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d08eacb4-e7fd-48ea-937b-04b0e8d6347e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 14:30:30', '2019-07-22 14:31:08', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d0b519eb-6b5e-4f94-9d54-77c362f8981f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-29 23:00:38', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d0b98cac-199e-4546-97b8-14ffe7b8563d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '网报管理人员', '10.20.68.67', '192.168.122.1', '2017-11-13 14:44:38', '2017-11-13 14:48:32', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '网报管理人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/网报管理人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d1121852-c297-4964-bed3-558987c131aa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-22 17:01:43', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d1862a1e-0ed4-4f1e-8647-16eae6ce7c62', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-11 14:02:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d19885f2-977d-406e-b286-da3aa854a799', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-12 10:39:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d1e180c0-1153-40ce-b2b8-ac359d0a35a2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-06 11:47:08', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d1ecacdf-8374-44be-9184-cbab37cba88a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-26 17:56:19', '2019-09-26 18:00:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d22e3a2b-ee0c-4c6b-8ca5-db9e410e6478', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 15:12:19', '2019-07-22 15:25:06', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d232f7a9-f708-4fb9-9732-98966fd60b69', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-19 11:00:27', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d2555a19-5320-4fe0-95ff-4f80a4ee8169', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.207.65', '192.168.122.1', '2017-11-09 11:03:27', '2017-11-09 12:40:18', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d265290e-40e3-458a-946e-03bb747293d7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 19:34:46', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d28605be-54f0-4a20-a0a5-da2d64c93531', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-08-05 11:11:54', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d2a057ef-b478-4f73-9817-af6b50e0eba9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-29 09:44:01', '2019-08-29 10:00:04', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d2cad664-dabe-4458-9c48-3202ac1f0f61', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:10:00', '2017-11-01 09:26:11', 'NORMAL', '5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5CBBE344499E14FCE050007F01002140@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'testjs020', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d3074f6e-18d1-48cc-a340-36722efc597b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-29 15:29:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d360dded-084e-4649-8165-5ad44e5eaeea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-10 14:55:54', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d3af8101-ba8f-4bec-8f82-e39d0fed83e6', 'shanghaitech', '上海科技大学', '0207A', '行政办公室(A)', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', '127.0.0.1', '127.0.0.1', '2019-07-22 15:26:24', '2019-07-22 15:26:56', 'NORMAL', '100804@6764A03B84A4F731E050007F01004EF8', '程诚', NULL, '/shanghaitech.ogn/0207.dpt/0207A.dpt/6764A03B84A4F731E050007F01004EF8.pos/100804@6764A03B84A4F731E050007F01004EF8.psm', '/上海科技大学/硬X射线自由电子激光/行政办公室(A)/管理岗位/程诚', NULL, '100804', '10084登录，错误信息：用户或密码错误;100804登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('d4919629-07d3-4513-8af6-c96cfaab52ee', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 09:08:59', '2019-07-19 09:26:29', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d49e7a98-5f0d-48b7-a6cc-23ca3f0e9f28', 'shanghaitech', '上海科技大学', '0108', '公共服务处', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', '127.0.0.1', '127.0.0.1', '2019-07-03 15:32:59', '2019-07-03 15:35:27', 'NORMAL', '100184@5C7117E6CE814125E050007F010057D5', '胡玲玲', NULL, '/shanghaitech.ogn/0108.dpt/5C7117E6CE814125E050007F010057D5.pos/100184@5C7117E6CE814125E050007F010057D5.psm', '/上海科技大学/公共服务处/管理岗位/胡玲玲', NULL, '100184', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d4b398bb-5802-407b-8fcd-d0c29c43ea66', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-22 09:59:58', '2019-07-22 10:00:26', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d542da07-6207-40ec-a5b1-bf03832ef1d1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-26 14:41:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d590cf7b-e368-4c84-9116-d19f70728370', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 13:55:49', '2019-09-17 14:13:57', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d59dcae0-cfce-41f9-8510-88b6dd5c5072', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-03 14:56:56', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d64de1f7-abfb-4465-8186-7ea69c642e04', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:35:57', '2019-07-08 11:36:01', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d662073d-1700-4f4e-82ae-76bc14cb2e46', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.201.255', '192.168.122.1', '2017-10-10 08:46:04', '2017-10-10 08:47:10', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', 'tech登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('d6911904-456c-420a-a676-401fbbab0ddb', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.248', '192.168.3.51', '2019-09-26 00:19:02', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d69b084e-4da4-49b6-994a-5f632ef2a075', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-29 16:51:10', '2019-09-29 17:05:17', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d6a0009f-9422-47e8-9b17-2a25e7cdd1ea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-12 09:41:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d6c098fb-05a5-4966-a69c-56318c455d5f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 15:24:29', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d6f8fd41-5431-42e4-b4b3-c7c8211526c0', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.198.211', '192.168.122.1', '2017-10-30 10:36:57', '2017-10-30 10:37:11', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d6fc40b5-584c-4785-b9ae-10dcc20eca70', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '192.168.3.51', '2019-09-19 18:28:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d71ef810-acbe-459f-968b-3f5c32ace6f1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.157.199', '192.168.122.1', '2017-11-06 09:09:16', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d72d287a-f75b-4b57-ac56-70dc6eae919d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-05 13:08:35', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d765f05e-5734-4b89-b7a8-39a6d7c40c87', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.250', '192.168.3.51', '2019-09-23 19:01:16', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('d7dba00e-b84a-4c87-b419-72e78a28b68f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-23 15:35:32', '2019-07-23 16:20:51', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d85d93ca-cd8e-490a-b959-47eabd9898a3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-31 11:20:52', '2019-07-31 17:25:16', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d864bd67-83e4-471a-9f85-055dd95faacf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-11 10:32:07', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d87c2584-3095-4ee4-83d0-c1d06ab1c419', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-19 11:59:53', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d8b3b44d-5c90-4c0c-b1ac-7ac8515604ec', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-12 16:13:30', '2019-09-12 16:19:52', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d99338f7-e2df-445e-a6a4-0bb008aa600c', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-31 16:00:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d9a36511-e242-4aa5-a150-5696c67b55bd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', '10.20.195.127', '192.168.122.1', '2017-10-11 09:29:28', '2017-10-11 13:24:56', 'NORMAL', '5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0', '测试人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5B1A2386CCD9ECF9E050007F01003D30@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/测试人员', NULL, 'tester', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d9bbce7b-c268-42c7-b864-1e1aad73640b', 'shanghaitech', '上海科技大学', 'AC0F9895383D4F10908393C6146438CA', '吴晓燕部', '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '吴晓燕', '127.0.0.1', '127.0.0.1', '2019-07-03 14:46:47', '2019-07-03 14:53:11', 'NORMAL', '6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4', '吴晓燕', NULL, '/shanghaitech.ogn/0108.dpt/AC0F9895383D4F10908393C6146438CA.dpt/15A70AA00CD14296A27315F1A2EB51D4.pos/6876E9F1E5049108E050007F01000A9F@15A70AA00CD14296A27315F1A2EB51D4.psm', '/上海科技大学/公共服务处/吴晓燕部/吴晓燕组/吴晓燕', NULL, 'wuxy', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d9bf1980-2845-4741-b981-effc70f82caf', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.31.243', '192.168.31.197', '2019-09-16 09:36:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('d9f718da-d664-4428-a6d0-3afb3eab1663', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-19 09:41:49', '2019-07-19 09:57:02', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('da4ea86b-4e07-4e51-aeb1-81b064a54ca7', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-17 16:52:08', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', 'jyan登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('da81b5e8-a32c-47fb-9aeb-0d3ee63d1286', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-09 15:45:02', '2019-08-09 15:51:46', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('da8876e0-8b12-4768-b11c-5c5487b54b19', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '127.0.0.1', '127.0.0.1', '2019-09-23 14:01:49', '2019-09-23 14:50:39', 'NORMAL', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('daf5e5e8-b365-465f-89ed-43565f684e4a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.56.1', '127.0.0.1', '2019-10-10 15:38:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('db568990-76d5-4408-8714-4f2dcc05460e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-23 10:35:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dbef9314-e00c-4ca2-93d8-6b986d09f662', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-26 18:00:37', '2019-09-26 18:04:44', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dbf1c99c-3b2e-47c4-8220-2102ec253a91', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '192.168.31.234', '2019-06-20 18:01:13', '2019-06-20 18:01:28', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dc0a159f-a850-4a2e-bc98-6257ffa506b3', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.234', '127.0.0.1', '2019-06-17 09:18:53', '2019-06-17 11:02:31', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dc910928-c253-4b44-80da-72ed9435b63e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-06-24 13:51:19', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('dcc2f611-1b00-4513-997c-3896dd52f4c2', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '0802CF8D923246D98C46B18EFE80DEDE', '董事会', '92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2', '焦燕', '192.168.3.250', '192.168.3.51', '2019-09-19 19:32:03', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/0802CF8D923246D98C46B18EFE80DEDE.dpt/6DB0B36E832C41BAB48A8F7262D92CF2.pos/92208DB645E8346BE050007F010012C2@6DB0B36E832C41BAB48A8F7262D92CF2.psm', '/中航国际/中航国际总部/董事会/董事会秘书总法律顾问/焦燕', NULL, 'jyan', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dccafc5a-7d6a-467a-bc3c-40590b94f44a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.201.1', '192.168.122.1', '2017-10-30 18:27:50', '2017-10-30 18:28:21', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dcd7570a-4055-46f1-8f73-927eb6b9adaa', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-30 09:48:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dcef42bc-ec18-4758-ae1e-2ea7ddefa7ea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 16:18:22', '2019-08-01 16:47:20', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dd885ed2-07f9-4763-9ec0-905e101da85d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-11-17 17:54:42', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dd9e40d0-aef6-41d9-b9ed-b9c1c646d2d2', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.236', '192.168.122.1', '2017-11-07 08:35:24', '2017-11-07 08:39:38', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dde064c6-7b8b-4fd5-b2cc-61f30c60b9d9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-01 16:22:28', '2019-08-01 16:28:05', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dde27268-da75-4d77-8e0b-5b70a05b86b5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.64.170', '192.168.122.1', '2017-10-30 13:30:52', '2017-10-30 13:32:54', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('de063499-7b9e-4044-bdf0-badf61078a47', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-28 17:31:22', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('de1a2189-a9f8-46b2-88a8-5b461162109d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-04 09:30:46', '2019-09-04 15:57:31', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('de511ff7-745f-4d1b-9742-ed23a331336d', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.19.156.15', '192.168.122.1', '2017-11-06 13:17:04', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('de662ef7-85b8-423b-9433-03bbfa3a2c9a', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-08-01 17:34:51', '2019-08-01 17:43:04', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('de8c1eb7-45e9-4514-9af0-9a6494c6a697', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.193.247', '192.168.122.1', '2017-11-14 18:15:03', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('dea757f7-846e-4010-951a-2bdeceefc28e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.195.236', '192.168.122.1', '2017-11-06 08:51:43', '2017-11-06 08:52:32', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', 'Administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('deafdb47-3735-444e-a509-9138fe1b33c9', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.19.156.209', '192.168.122.1', '2017-11-15 09:24:36', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('deec8796-f324-47db-92e0-9771a1582fed', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-25 11:21:48', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('df10be94-9d30-4d4b-b310-74371dea9550', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.204.205', '192.168.122.1', '2017-11-15 16:59:47', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('df1f5f68-d918-45c1-b1ed-ba8a9d16dacd', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-24 14:10:12', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('df2a2700-fd76-4b74-8fb5-ed9bf94bf4dc', '4D7E40E9F8A543FCAA64E7F57D35ECBC', '中航国际总部', '364FE6E60D264FD8A120BBCBA5AAAF58', '综合管理部', '92208DB64606346BE050007F010012C2@24705149D18744179B153D2B532D3666', '关旭', '127.0.0.1', '127.0.0.1', '2019-09-17 15:35:36', NULL, NULL, NULL, NULL, NULL, '/7609EDB28F974C5F948CAA24D5ADAB85.ogn/4D7E40E9F8A543FCAA64E7F57D35ECBC.ogn/364FE6E60D264FD8A120BBCBA5AAAF58.dpt/24705149D18744179B153D2B532D3666.pos/92208DB64606346BE050007F010012C2@24705149D18744179B153D2B532D3666.psm', '/中航国际/中航国际总部/综合管理部/司机/关旭', NULL, 'guanxu', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('df8e28ec-f1c9-48bb-8f8b-22b1090dfcc5', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100103@5C7117E6CDDC4125E050007F010057D5', '孙小影', '10.20.71.8', '192.168.122.1', '2017-10-30 11:23:36', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CDDC4125E050007F010057D5.pos/100103@5C7117E6CDDC4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/管理岗位/孙小影', NULL, '100103', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e033a366-e3ca-4cbc-b139-dac146a1856f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-10-29 11:39:31', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'admin', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e0364f65-efcf-4e07-bd94-dd1c47e59b0f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.19.156.231', '192.168.122.1', '2017-11-01 15:35:13', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e04c4585-969f-41b3-b9f9-a9410817d9b8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-22 11:38:52', '2019-07-22 11:40:08', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e07c026b-a1f7-4db5-b68e-ce8ad34032d5', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-25 15:41:30', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e0c53dac-986d-4948-aef7-d0ef06ba3ee8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.67.91', '192.168.122.1', '2017-11-03 13:29:08', '2017-11-03 13:32:07', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e11eaca5-406d-460e-8da2-40e587cf10b9', 'shanghaitech', '上海科技大学', '0111', '图书信息中心', '100584@5C7117E6CD9C4125E050007F010057D5', '陆成松', '10.20.64.111', '192.168.122.1', '2017-10-26 19:29:42', NULL, NULL, NULL, NULL, NULL, '/shanghaitech.ogn/0111.dpt/5C7117E6CD9C4125E050007F010057D5.pos/100584@5C7117E6CD9C4125E050007F010057D5.psm', '/上海科技大学/图书信息中心/支撑岗位/陆成松', NULL, '100584', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e1330dcc-1252-457c-975b-2034c6ebf95d', NULL, NULL, NULL, NULL, NULL, NULL, '10.20.193.211', '192.168.122.1', '2017-10-20 15:14:56', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 'admin登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;guoyin.chen登录，错误信息：用户或密码错误;', 2);
INSERT INTO `sa_historicsession` VALUES ('e13ecaaf-5643-46d8-a8db-b736e5ca2eb8', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', '10.20.196.184', '192.168.122.1', '2017-11-13 18:32:30', '2017-11-13 18:33:01', 'NORMAL', '5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0', '报销人', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C80F5E9C2D04981E050007F0100085D@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/报销人', NULL, 'bxr', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e147247f-cf35-4f21-af56-8963e6e90907', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-07-19 09:07:08', '2019-07-19 09:08:19', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e1797db0-f8d2-47dd-9e48-41fad0e74b20', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-17 13:52:13', '2019-09-17 14:07:51', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e17bc4d9-34e6-469c-b016-8620cb8639ad', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.198.21', '192.168.122.1', '2017-11-08 13:35:22', '2017-11-08 13:35:39', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e195fb60-6af9-4a43-b3d4-a076aeb7a621', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-08-27 10:33:10', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e1c1cfab-7c91-4e04-bd41-c2cf63af36ea', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-06-17 14:06:09', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', 'administrator登录，错误信息：用户或密码错误;admin登录，错误信息：用户或密码错误;tsadmin登录，错误信息：用户或密码错误;Administrator登录，错误信息：用户或密码错误;', 1);
INSERT INTO `sa_historicsession` VALUES ('e1d59915-dc28-4a9b-8ae2-556f49b04d2b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:38:15', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e2926696-4b65-4299-aa7c-d547f68c7d89', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-17 14:16:21', '2019-07-17 14:44:50', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e29cbe94-c9e9-4301-8ab4-beb8ec334b35', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', '10.20.65.7', '192.168.122.1', '2017-11-01 09:08:05', '2017-11-01 09:25:05', 'NORMAL', '5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0', '财务人员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5C808BCA27574337E050007F010003E4@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/财务人员', NULL, 'cw', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e310ec1b-25a4-41c1-a7f4-004a996fba2b', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-25 17:25:21', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e312487c-2394-4742-98f6-616db8363eb1', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.203.12', '192.168.122.1', '2017-11-14 18:17:05', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e348001a-0e8f-4d43-ba13-783e33cad6a7', 'E3B4E5C5C6454F81921CF58B7597CE2F', '初始始化机构', '18FFF477AEEE4609B798015231B400C3', '初始化部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '管理员', '10.20.199.214', '192.168.122.1', '2017-10-30 17:21:28', NULL, NULL, NULL, NULL, NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/初始始化机构/初始化部门/初始化岗位/管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e348424a-1581-4bf8-a6ea-e332e1a20331', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:33:46', '2019-07-08 11:33:53', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e35a9c7c-7562-4218-9db4-2bdf179fae0e', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '8E29A8EEFC134CC7BF7B20F273CDA5C4', '测试代理商部门', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', '127.0.0.1', '127.0.0.1', '2019-07-25 14:32:34', '2019-07-25 14:42:31', 'NORMAL', '8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E', '代理商', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/8E29A8EEFC134CC7BF7B20F273CDA5C4.dpt/2C63A356352A4EE5B09E93C1B277B75E.pos/8BAA4A9090EEC786E050007F010059AB@2C63A356352A4EE5B09E93C1B277B75E.psm', '/外部机构/测试代理商部门/初始化岗位/代理商', NULL, 'lishang.dai', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e377e51c-e4c2-47a1-9169-e773c3f1002f', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '192.168.3.250', '127.0.0.1', '2019-07-08 11:35:45', '2019-07-08 11:35:53', 'NORMAL', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', NULL, '/E3B4E5C5C6454F81921CF58B7597CE2F.ogn/18FFF477AEEE4609B798015231B400C3.dpt/C18E23AAAA6940E09DF7C122332C51E0.pos/5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0.psm', '/外部机构/测试使用部门/初始化岗位/系统管理员', NULL, 'administrator', NULL, 1);
INSERT INTO `sa_historicsession` VALUES ('e3fb2bee-6b48-42d7-8a5c-362135dec896', 'E3B4E5C5C6454F81921CF58B7597CE2F', '外部机构', '18FFF477AEEE4609B798015231B400C3', '测试使用部门', '5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0', '系统管理员', '127.0.0.1', '127.0.0.1', '2019-09-30 20:58:17', '2019-09-30 21:25:51', 'NORMAL'