package com.topsunit.query.binding;

import com.huigou.data.query.executor.SQLExecutorDao;

import java.lang.reflect.Proxy;

/**
 * @param <T>
 * @author yonghuan
 */
public class MapperProxyFactory<T> {

    private final SQLExecutorDao sqlExecutor;
    private final Class<T> mapperInterface;
    private final String xml;

    public MapperProxyFactory(Class<T> mapperInterface, String xml, SQLExecutorDao sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
        this.mapperInterface = mapperInterface;
        this.xml = xml;
    }

    public T newInstance() {
        MapperProxy<T> mapperProxy = new MapperProxy(mapperInterface, xml, sqlExecutor);
        return (T) Proxy.newProxyInstance(mapperInterface.getClassLoader(), new Class[]{this.mapperInterface}, mapperProxy);
    }
}
