package com.huigou.uasp.bmp.opm.domain.model.access;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author yonghuan
 */
@Embeddable
public class AuthorizeId implements Serializable {

    /**
     * 组织id
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 角色id
     */
    @Column(name = "role_id")
    private String roleId;

    public AuthorizeId() {
    }

    public AuthorizeId(String orgId, String roleId) {
        this.orgId = orgId;
        this.roleId = roleId;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuthorizeId that = (AuthorizeId) o;
        return orgId.equals(that.orgId) &&
                roleId.equals(that.roleId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgId, roleId);
    }
}
