package com.huigou.util;

import java.util.HashMap;
import java.util.Map;

/**
 * 文件下载类型对应关系
 * 
 * @author gongmm
 */
public class ContentTypeHelper {

    private static Map<String, String> contentTypes = new HashMap<String, String>();
    static {
        contentTypes.put("123", "application/vnd.lotus-1-2-3");
        contentTypes.put("3dml", "text/vnd.in3d.3dml");
        contentTypes.put("3ds", "image/x-3ds");
        contentTypes.put("3g2", "video/3gpp2");
        contentTypes.put("3gp", "video/3gpp");
        contentTypes.put("7z", "application/x-7z-compressed");
        contentTypes.put("aab", "application/x-authorware-bin");
        contentTypes.put("aac", "audio/x-aac");
        contentTypes.put("aam", "application/x-authorware-map");
        contentTypes.put("aas", "application/x-authorware-seg");
        contentTypes.put("abs", "audio/x-mpeg");
        contentTypes.put("abw", "application/x-abiword");
        contentTypes.put("ac", "application/pkix-attr-cert");
        contentTypes.put("acc", "application/vnd.americandynamics.acc");
        contentTypes.put("ace", "application/x-ace-compressed");
        contentTypes.put("acu", "application/vnd.acucobol");
        contentTypes.put("acutc", "application/vnd.acucorp");
        contentTypes.put("adp", "audio/adpcm");
        contentTypes.put("aep", "application/vnd.audiograph");
        contentTypes.put("afm", "application/x-font-type1");
        contentTypes.put("afp", "application/vnd.ibm.modcap");
        contentTypes.put("ahead", "application/vnd.ahead.space");
        contentTypes.put("ai", "application/postscript");
        contentTypes.put("aif", "audio/x-aiff");
        contentTypes.put("aifc", "audio/x-aiff");
        contentTypes.put("aiff", "audio/x-aiff");
        contentTypes.put("aim", "application/x-aim");
        contentTypes.put("air", "application/vnd.adobe.air-application-installer-package+zip");
        contentTypes.put("ait", "application/vnd.dvb.ait");
        contentTypes.put("ami", "application/vnd.amiga.ami");
        contentTypes.put("anx", "application/annodex");
        contentTypes.put("apk", "application/vnd.android.package-archive");
        contentTypes.put("appcache", "text/cache-manifest");
        contentTypes.put("application", "application/x-ms-application");
        contentTypes.put("apr", "application/vnd.lotus-approach");
        contentTypes.put("arc", "application/x-freearc");
        contentTypes.put("art", "image/x-jg");
        contentTypes.put("asc", "application/pgp-signature");
        contentTypes.put("asf", "video/x-ms-asf");
        contentTypes.put("asm", "text/x-asm");
        contentTypes.put("aso", "application/vnd.accpac.simply.aso");
        contentTypes.put("asx", "video/x-ms-asf");
        contentTypes.put("atc", "application/vnd.acucorp");
        contentTypes.put("atom", "application/atom+xml");
        contentTypes.put("atomcat", "application/atomcat+xml");
        contentTypes.put("atomsvc", "application/atomsvc+xml");
        contentTypes.put("atx", "application/vnd.antix.game-component");
        contentTypes.put("au", "audio/basic");
        contentTypes.put("avi", "video/x-msvideo");
        contentTypes.put("avx", "video/x-rad-screenplay");
        contentTypes.put("aw", "application/applixware");
        contentTypes.put("axa", "audio/annodex");
        contentTypes.put("axv", "video/annodex");
        contentTypes.put("azf", "application/vnd.airzip.filesecure.azf");
        contentTypes.put("azs", "application/vnd.airzip.filesecure.azs");
        contentTypes.put("azw", "application/vnd.amazon.ebook");
        contentTypes.put("bat", "application/x-msdownload");
        contentTypes.put("bcpio", "application/x-bcpio");
        contentTypes.put("bdf", "application/x-font-bdf");
        contentTypes.put("bdm", "application/vnd.syncml.dm+wbxml");
        contentTypes.put("bed", "application/vnd.realvnc.bed");
        contentTypes.put("bh2", "application/vnd.fujitsu.oasysprs");
        contentTypes.put("bin", "application/octet-stream");
        contentTypes.put("blb", "application/x-blorb");
        contentTypes.put("blorb", "application/x-blorb");
        contentTypes.put("bmi", "application/vnd.bmi");
        contentTypes.put("bmp", "image/bmp");
        contentTypes.put("body", "text/html");
        contentTypes.put("book", "application/vnd.framemaker");
        contentTypes.put("box", "application/vnd.previewsystems.box");
        contentTypes.put("boz", "application/x-bzip2");
        contentTypes.put("bpk", "application/octet-stream");
        contentTypes.put("btif", "image/prs.btif");
        contentTypes.put("bz", "application/x-bzip");
        contentTypes.put("bz2", "application/x-bzip2");
        contentTypes.put("c", "text/x-c");
        contentTypes.put("c11amc", "application/vnd.cluetrust.cartomobile-config");
        contentTypes.put("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg");
        contentTypes.put("c4d", "application/vnd.clonk.c4group");
        contentTypes.put("c4f", "application/vnd.clonk.c4group");
        contentTypes.put("c4g", "application/vnd.clonk.c4group");
        contentTypes.put("c4p", "application/vnd.clonk.c4group");
        contentTypes.put("c4u", "application/vnd.clonk.c4group");
        contentTypes.put("cab", "application/vnd.ms-cab-compressed");
        contentTypes.put("caf", "audio/x-caf");
        contentTypes.put("cap", "application/vnd.tcpdump.pcap");
        contentTypes.put("car", "application/vnd.curl.car");
        contentTypes.put("cat", "application/vnd.ms-pki.seccat");
        contentTypes.put("cb7", "application/x-cbr");
        contentTypes.put("cba", "application/x-cbr");
        contentTypes.put("cbr", "application/x-cbr");
        contentTypes.put("cbt", "application/x-cbr");
        contentTypes.put("cbz", "application/x-cbr");
        contentTypes.put("cc", "text/x-c");
        contentTypes.put("cct", "application/x-director");
        contentTypes.put("ccxml", "application/ccxml+xml");
        contentTypes.put("cdbcmsg", "application/vnd.contact.cmsg");
        contentTypes.put("cdf", "application/x-cdf");
        contentTypes.put("cdkey", "application/vnd.mediastation.cdkey");
        contentTypes.put("cdmia", "application/cdmi-capability");
        contentTypes.put("cdmic", "application/cdmi-container");
        contentTypes.put("cdmid", "application/cdmi-domain");
        contentTypes.put("cdmio", "application/cdmi-object");
        contentTypes.put("cdmiq", "application/cdmi-queue");
        contentTypes.put("cdx", "chemical/x-cdx");
        contentTypes.put("cdxml", "application/vnd.chemdraw+xml");
        contentTypes.put("cdy", "application/vnd.cinderella");
        contentTypes.put("cer", "application/pkix-cert");
        contentTypes.put("cfs", "application/x-cfs-compressed");
        contentTypes.put("cgm", "image/cgm");
        contentTypes.put("chat", "application/x-chat");
        contentTypes.put("chm", "application/vnd.ms-htmlhelp");
        contentTypes.put("chrt", "application/vnd.kde.kchart");
        contentTypes.put("cif", "chemical/x-cif");
        contentTypes.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
        contentTypes.put("cil", "application/vnd.ms-artgalry");
        contentTypes.put("cla", "application/vnd.claymore");
        contentTypes.put("class", "application/java");
        contentTypes.put("clkk", "application/vnd.crick.clicker.keyboard");
        contentTypes.put("clkp", "application/vnd.crick.clicker.palette");
        contentTypes.put("clkt", "application/vnd.crick.clicker.template");
        contentTypes.put("clkw", "application/vnd.crick.clicker.wordbank");
        contentTypes.put("clkx", "application/vnd.crick.clicker");
        contentTypes.put("clp", "application/x-msclip");
        contentTypes.put("cmc", "application/vnd.cosmocaller");
        contentTypes.put("cmdf", "chemical/x-cmdf");
        contentTypes.put("cml", "chemical/x-cml");
        contentTypes.put("cmp", "application/vnd.yellowriver-custom-menu");
        contentTypes.put("cmx", "image/x-cmx");
        contentTypes.put("cod", "application/vnd.rim.cod");
        contentTypes.put("com", "application/x-msdownload");
        contentTypes.put("conf", "text/plain");
        contentTypes.put("cpio", "application/x-cpio");
        contentTypes.put("cpp", "text/x-c");
        contentTypes.put("cpt", "application/mac-compactpro");
        contentTypes.put("crd", "application/x-mscardfile");
        contentTypes.put("crl", "application/pkix-crl");
        contentTypes.put("crt", "application/x-x509-ca-cert");
        contentTypes.put("cryptonote", "application/vnd.rig.cryptonote");
        contentTypes.put("csh", "application/x-csh");
        contentTypes.put("csml", "chemical/x-csml");
        contentTypes.put("csp", "application/vnd.commonspace");
        contentTypes.put("css", "text/css");
        contentTypes.put("cst", "application/x-director");
        contentTypes.put("csv", "text/csv");
        contentTypes.put("cu", "application/cu-seeme");
        contentTypes.put("curl", "text/vnd.curl");
        contentTypes.put("cww", "application/prs.cww");
        contentTypes.put("cxt", "application/x-director");
        contentTypes.put("cxx", "text/x-c");
        contentTypes.put("dae", "model/vnd.collada+xml");
        contentTypes.put("daf", "application/vnd.mobius.daf");
        contentTypes.put("dart", "application/vnd.dart");
        contentTypes.put("dataless", "application/vnd.fdsn.seed");
        contentTypes.put("davmount", "application/davmount+xml");
        contentTypes.put("dbk", "application/docbook+xml");
        contentTypes.put("dcr", "application/x-director");
        contentTypes.put("dcurl", "text/vnd.curl.dcurl");
        contentTypes.put("dd2", "application/vnd.oma.dd2+xml");
        contentTypes.put("ddd", "application/vnd.fujixerox.ddd");
        contentTypes.put("deb", "application/x-debian-package");
        contentTypes.put("def", "text/plain");
        contentTypes.put("deploy", "application/octet-stream");
        contentTypes.put("der", "application/x-x509-ca-cert");
        contentTypes.put("dfac", "application/vnd.dreamfactory");
        contentTypes.put("dgc", "application/x-dgc-compressed");
        contentTypes.put("dib", "image/bmp");
        contentTypes.put("dic", "text/x-c");
        contentTypes.put("dir", "application/x-director");
        contentTypes.put("dis", "application/vnd.mobius.dis");
        contentTypes.put("dist", "application/octet-stream");
        contentTypes.put("distz", "application/octet-stream");
        contentTypes.put("djv", "image/vnd.djvu");
        contentTypes.put("djvu", "image/vnd.djvu");
        contentTypes.put("dll", "application/x-msdownload");
        contentTypes.put("dmg", "application/x-apple-diskimage");
        contentTypes.put("dmp", "application/vnd.tcpdump.pcap");
        contentTypes.put("dms", "application/octet-stream");
        contentTypes.put("dna", "application/vnd.dna");
        contentTypes.put("doc", "application/msword");
        contentTypes.put("docm", "application/vnd.ms-word.document.macroenabled.12");
        contentTypes.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        contentTypes.put("dot", "application/msword");
        contentTypes.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
        contentTypes.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        contentTypes.put("dp", "application/vnd.osgi.dp");
        contentTypes.put("dpg", "application/vnd.dpgraph");
        contentTypes.put("dra", "audio/vnd.dra");
        contentTypes.put("dsc", "text/prs.lines.tag");
        contentTypes.put("dssc", "application/dssc+der");
        contentTypes.put("dtb", "application/x-dtbook+xml");
        contentTypes.put("dtd", "application/xml-dtd");
        contentTypes.put("dts", "audio/vnd.dts");
        contentTypes.put("dtshd", "audio/vnd.dts.hd");
        contentTypes.put("dump", "application/octet-stream");
        contentTypes.put("dv", "video/x-dv");
        contentTypes.put("dvb", "video/vnd.dvb.file");
        contentTypes.put("dvi", "application/x-dvi");
        contentTypes.put("dwf", "model/vnd.dwf");
        contentTypes.put("dwg", "image/vnd.dwg");
        contentTypes.put("dxf", "image/vnd.dxf");
        contentTypes.put("dxp", "application/vnd.spotfire.dxp");
        contentTypes.put("dxr", "application/x-director");
        contentTypes.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
        contentTypes.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
        contentTypes.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
        contentTypes.put("ecma", "application/ecmascript");
        contentTypes.put("edm", "application/vnd.novadigm.edm");
        contentTypes.put("edx", "application/vnd.novadigm.edx");
        contentTypes.put("efif", "application/vnd.picsel");
        contentTypes.put("ei6", "application/vnd.pg.osasli");
        contentTypes.put("elc", "application/octet-stream");
        contentTypes.put("emf", "application/x-msmetafile");
        contentTypes.put("eml", "message/rfc822");
        contentTypes.put("emma", "application/emma+xml");
        contentTypes.put("emz", "application/x-msmetafile");
        contentTypes.put("eol", "audio/vnd.digital-winds");
        contentTypes.put("eot", "application/vnd.ms-fontobject");
        contentTypes.put("eps", "application/postscript");
        contentTypes.put("epub", "application/epub+zip");
        contentTypes.put("es3", "application/vnd.eszigno3+xml");
        contentTypes.put("esa", "application/vnd.osgi.subsystem");
        contentTypes.put("esf", "application/vnd.epson.esf");
        contentTypes.put("et3", "application/vnd.eszigno3+xml");
        contentTypes.put("etx", "text/x-setext");
        contentTypes.put("eva", "application/x-eva");
        contentTypes.put("evy", "application/x-envoy");
        contentTypes.put("exe", "application/octet-stream");
        contentTypes.put("exi", "application/exi");
        contentTypes.put("ext", "application/vnd.novadigm.ext");
        contentTypes.put("ez", "application/andrew-inset");
        contentTypes.put("ez2", "application/vnd.ezpix-album");
        contentTypes.put("ez3", "application/vnd.ezpix-package");
        contentTypes.put("f", "text/x-fortran");
        contentTypes.put("f4v", "video/x-f4v");
        contentTypes.put("f77", "text/x-fortran");
        contentTypes.put("f90", "text/x-fortran");
        contentTypes.put("fbs", "image/vnd.fastbidsheet");
        contentTypes.put("fcdt", "application/vnd.adobe.formscentral.fcdt");
        contentTypes.put("fcs", "application/vnd.isac.fcs");
        contentTypes.put("fdf", "application/vnd.fdf");
        contentTypes.put("fe_launch", "application/vnd.denovo.fcselayout-link");
        contentTypes.put("fg5", "application/vnd.fujitsu.oasysgp");
        contentTypes.put("fgd", "application/x-director");
        contentTypes.put("fh", "image/x-freehand");
        contentTypes.put("fh4", "image/x-freehand");
        contentTypes.put("fh5", "image/x-freehand");
        contentTypes.put("fh7", "image/x-freehand");
        contentTypes.put("fhc", "image/x-freehand");
        contentTypes.put("fig", "application/x-xfig");
        contentTypes.put("flac", "audio/flac");
        contentTypes.put("fli", "video/x-fli");
        contentTypes.put("flo", "application/vnd.micrografx.flo");
        contentTypes.put("flv", "video/x-flv");
        contentTypes.put("flw", "application/vnd.kde.kivio");
        contentTypes.put("flx", "text/vnd.fmi.flexstor");
        contentTypes.put("fly", "text/vnd.fly");
        contentTypes.put("fm", "application/vnd.framemaker");
        contentTypes.put("fnc", "application/vnd.frogans.fnc");
        contentTypes.put("for", "text/x-fortran");
        contentTypes.put("fpx", "image/vnd.fpx");
        contentTypes.put("frame", "application/vnd.framemaker");
        contentTypes.put("fsc", "application/vnd.fsc.weblaunch");
        contentTypes.put("fst", "image/vnd.fst");
        contentTypes.put("ftc", "application/vnd.fluxtime.clip");
        contentTypes.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
        contentTypes.put("fvt", "video/vnd.fvt");
        contentTypes.put("fxp", "application/vnd.adobe.fxp");
        contentTypes.put("fxpl", "application/vnd.adobe.fxp");
        contentTypes.put("fzs", "application/vnd.fuzzysheet");
        contentTypes.put("g2w", "application/vnd.geoplan");
        contentTypes.put("g3", "image/g3fax");
        contentTypes.put("g3w", "application/vnd.geospace");
        contentTypes.put("gac", "application/vnd.groove-account");
        contentTypes.put("gam", "application/x-tads");
        contentTypes.put("gbr", "application/rpki-ghostbusters");
        contentTypes.put("gca", "application/x-gca-compressed");
        contentTypes.put("gdl", "model/vnd.gdl");
        contentTypes.put("geo", "application/vnd.dynageo");
        contentTypes.put("gex", "application/vnd.geometry-explorer");
        contentTypes.put("ggb", "application/vnd.geogebra.file");
        contentTypes.put("ggt", "application/vnd.geogebra.tool");
        contentTypes.put("ghf", "application/vnd.groove-help");
        contentTypes.put("gif", "image/gif");
        contentTypes.put("gim", "application/vnd.groove-identity-message");
        contentTypes.put("gml", "application/gml+xml");
        contentTypes.put("gmx", "application/vnd.gmx");
        contentTypes.put("gnumeric", "application/x-gnumeric");
        contentTypes.put("gph", "application/vnd.flographit");
        contentTypes.put("gpx", "application/gpx+xml");
        contentTypes.put("gqf", "application/vnd.grafeq");
        contentTypes.put("gqs", "application/vnd.grafeq");
        contentTypes.put("gram", "application/srgs");
        contentTypes.put("gramps", "application/x-gramps-xml");
        contentTypes.put("gre", "application/vnd.geometry-explorer");
        contentTypes.put("grv", "application/vnd.groove-injector");
        contentTypes.put("grxml", "application/srgs+xml");
        contentTypes.put("gsf", "application/x-font-ghostscript");
        contentTypes.put("gtar", "application/x-gtar");
        contentTypes.put("gtm", "application/vnd.groove-tool-message");
        contentTypes.put("gtw", "model/vnd.gtw");
        contentTypes.put("gv", "text/vnd.graphviz");
        contentTypes.put("gxf", "application/gxf");
        contentTypes.put("gxt", "application/vnd.geonext");
        contentTypes.put("gz", "application/x-gzip");
        contentTypes.put("h", "text/x-c");
        contentTypes.put("h261", "video/h261");
        contentTypes.put("h263", "video/h263");
        contentTypes.put("h264", "video/h264");
        contentTypes.put("hal", "application/vnd.hal+xml");
        contentTypes.put("hbci", "application/vnd.hbci");
        contentTypes.put("hdf", "application/x-hdf");
        contentTypes.put("hh", "text/x-c");
        contentTypes.put("hlp", "application/winhlp");
        contentTypes.put("hpgl", "application/vnd.hp-hpgl");
        contentTypes.put("hpid", "application/vnd.hp-hpid");
        contentTypes.put("hps", "application/vnd.hp-hps");
        contentTypes.put("hqx", "application/mac-binhex40");
        contentTypes.put("htc", "text/x-component");
        contentTypes.put("htke", "application/vnd.kenameaapp");
        contentTypes.put("htm", "text/html");
        contentTypes.put("html", "text/html");
        contentTypes.put("hvd", "application/vnd.yamaha.hv-dic");
        contentTypes.put("hvp", "application/vnd.yamaha.hv-voice");
        contentTypes.put("hvs", "application/vnd.yamaha.hv-script");
        contentTypes.put("i2g", "application/vnd.intergeo");
        contentTypes.put("icc", "application/vnd.iccprofile");
        contentTypes.put("ice", "x-conference/x-cooltalk");
        contentTypes.put("icm", "application/vnd.iccprofile");
        contentTypes.put("ico", "image/x-icon");
        contentTypes.put("ics", "text/calendar");
        contentTypes.put("ief", "image/ief");
        contentTypes.put("ifb", "text/calendar");
        contentTypes.put("ifm", "application/vnd.shana.informed.formdata");
        contentTypes.put("iges", "model/iges");
        contentTypes.put("igl", "application/vnd.igloader");
        contentTypes.put("igm", "application/vnd.insors.igm");
        contentTypes.put("igs", "model/iges");
        contentTypes.put("igx", "application/vnd.micrografx.igx");
        contentTypes.put("iif", "application/vnd.shana.informed.interchange");
        contentTypes.put("imp", "application/vnd.accpac.simply.imp");
        contentTypes.put("ims", "application/vnd.ms-ims");
        contentTypes.put("in", "text/plain");
        contentTypes.put("ink", "application/inkml+xml");
        contentTypes.put("inkml", "application/inkml+xml");
        contentTypes.put("install", "application/x-install-instructions");
        contentTypes.put("iota", "application/vnd.astraea-software.iota");
        contentTypes.put("ipfix", "application/ipfix");
        contentTypes.put("ipk", "application/vnd.shana.informed.package");
        contentTypes.put("irm", "application/vnd.ibm.rights-management");
        contentTypes.put("irp", "application/vnd.irepository.package+xml");
        contentTypes.put("iso", "application/x-iso9660-image");
        contentTypes.put("itp", "application/vnd.shana.informed.formtemplate");
        contentTypes.put("ivp", "application/vnd.immervision-ivp");
        contentTypes.put("ivu", "application/vnd.immervision-ivu");
        contentTypes.put("jad", "text/vnd.sun.j2me.app-descriptor");
        contentTypes.put("jam", "application/vnd.jam");
        contentTypes.put("jar", "application/java-archive");
        contentTypes.put("java", "text/x-java-source");
        contentTypes.put("jisp", "application/vnd.jisp");
        contentTypes.put("jlt", "application/vnd.hp-jlyt");
        contentTypes.put("jnlp", "application/x-java-jnlp-file");
        contentTypes.put("joda", "application/vnd.joost.joda-archive");
        contentTypes.put("jpe", "image/jpeg");
        contentTypes.put("jpeg", "image/jpeg");
        contentTypes.put("jpg", "image/jpeg");
        contentTypes.put("jpgm", "video/jpm");
        contentTypes.put("jpgv", "video/jpeg");
        contentTypes.put("jpm", "video/jpm");
        contentTypes.put("js", "application/javascript");
        contentTypes.put("jsf", "text/plain");
        contentTypes.put("json", "application/json");
        contentTypes.put("jsonml", "application/jsonml+json");
        contentTypes.put("jspf", "text/plain");
        contentTypes.put("kar", "audio/midi");
        contentTypes.put("karbon", "application/vnd.kde.karbon");
        contentTypes.put("kfo", "application/vnd.kde.kformula");
        contentTypes.put("kia", "application/vnd.kidspiration");
        contentTypes.put("kml", "application/vnd.google-earth.kml+xml");
        contentTypes.put("kmz", "application/vnd.google-earth.kmz");
        contentTypes.put("kne", "application/vnd.kinar");
        contentTypes.put("knp", "application/vnd.kinar");
        contentTypes.put("kon", "application/vnd.kde.kontour");
        contentTypes.put("kpr", "application/vnd.kde.kpresenter");
        contentTypes.put("kpt", "application/vnd.kde.kpresenter");
        contentTypes.put("kpxx", "application/vnd.ds-keypoint");
        contentTypes.put("ksp", "application/vnd.kde.kspread");
        contentTypes.put("ktr", "application/vnd.kahootz");
        contentTypes.put("ktx", "image/ktx");
        contentTypes.put("ktz", "application/vnd.kahootz");
        contentTypes.put("kwd", "application/vnd.kde.kword");
        contentTypes.put("kwt", "application/vnd.kde.kword");
        contentTypes.put("lasxml", "application/vnd.las.las+xml");
        contentTypes.put("latex", "application/x-latex");
        contentTypes.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
        contentTypes.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
        contentTypes.put("les", "application/vnd.hhe.lesson-player");
        contentTypes.put("lha", "application/x-lzh-compressed");
        contentTypes.put("link66", "application/vnd.route66.link66+xml");
        contentTypes.put("list", "text/plain");
        contentTypes.put("list3820", "application/vnd.ibm.modcap");
        contentTypes.put("listafp", "application/vnd.ibm.modcap");
        contentTypes.put("lnk", "application/x-ms-shortcut");
        contentTypes.put("log", "text/plain");
        contentTypes.put("lostxml", "application/lost+xml");
        contentTypes.put("lrf", "application/octet-stream");
        contentTypes.put("lrm", "application/vnd.ms-lrm");
        contentTypes.put("ltf", "application/vnd.frogans.ltf");
        contentTypes.put("lvp", "audio/vnd.lucent.voice");
        contentTypes.put("lwp", "application/vnd.lotus-wordpro");
        contentTypes.put("lzh", "application/x-lzh-compressed");
        contentTypes.put("m13", "application/x-msmediaview");
        contentTypes.put("m14", "application/x-msmediaview");
        contentTypes.put("m1v", "video/mpeg");
        contentTypes.put("m21", "application/mp21");
        contentTypes.put("m2a", "audio/mpeg");
        contentTypes.put("m2v", "video/mpeg");
        contentTypes.put("m3a", "audio/mpeg");
        contentTypes.put("m3u", "audio/x-mpegurl");
        contentTypes.put("m3u8", "application/vnd.apple.mpegurl");
        contentTypes.put("m4a", "audio/mp4");
        contentTypes.put("m4b", "audio/mp4");
        contentTypes.put("m4r", "audio/mp4");
        contentTypes.put("m4u", "video/vnd.mpegurl");
        contentTypes.put("m4v", "video/mp4");
        contentTypes.put("ma", "application/mathematica");
        contentTypes.put("mac", "image/x-macpaint");
        contentTypes.put("mads", "application/mads+xml");
        contentTypes.put("mag", "application/vnd.ecowin.chart");
        contentTypes.put("maker", "application/vnd.framemaker");
        contentTypes.put("man", "text/troff");
        contentTypes.put("mar", "application/octet-stream");
        contentTypes.put("mathml", "application/mathml+xml");
        contentTypes.put("mb", "application/mathematica");
        contentTypes.put("mbk", "application/vnd.mobius.mbk");
        contentTypes.put("mbox", "application/mbox");
        contentTypes.put("mc1", "application/vnd.medcalcdata");
        contentTypes.put("mcd", "application/vnd.mcd");
        contentTypes.put("mcurl", "text/vnd.curl.mcurl");
        contentTypes.put("mdb", "application/x-msaccess");
        contentTypes.put("mdi", "image/vnd.ms-modi");
        contentTypes.put("me", "text/troff");
        contentTypes.put("mesh", "model/mesh");
        contentTypes.put("meta4", "application/metalink4+xml");
        contentTypes.put("metalink", "application/metalink+xml");
        contentTypes.put("mets", "application/mets+xml");
        contentTypes.put("mfm", "application/vnd.mfmp");
        contentTypes.put("mft", "application/rpki-manifest");
        contentTypes.put("mgp", "application/vnd.osgeo.mapguide.package");
        contentTypes.put("mgz", "application/vnd.proteus.magazine");
        contentTypes.put("mid", "audio/midi");
        contentTypes.put("midi", "audio/midi");
        contentTypes.put("mie", "application/x-mie");
        contentTypes.put("mif", "application/x-mif");
        contentTypes.put("mime", "message/rfc822");
        contentTypes.put("mj2", "video/mj2");
        contentTypes.put("mjp2", "video/mj2");
        contentTypes.put("mk3d", "video/x-matroska");
        contentTypes.put("mka", "audio/x-matroska");
        contentTypes.put("mks", "video/x-matroska");
        contentTypes.put("mkv", "video/x-matroska");
        contentTypes.put("mlp", "application/vnd.dolby.mlp");
        contentTypes.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
        contentTypes.put("mmf", "application/vnd.smaf");
        contentTypes.put("mmr", "image/vnd.fujixerox.edmics-mmr");
        contentTypes.put("mng", "video/x-mng");
        contentTypes.put("mny", "application/x-msmoney");
        contentTypes.put("mobi", "application/x-mobipocket-ebook");
        contentTypes.put("mods", "application/mods+xml");
        contentTypes.put("mov", "video/quicktime");
        contentTypes.put("movie", "video/x-sgi-movie");
        contentTypes.put("mp1", "audio/mpeg");
        contentTypes.put("mp2", "audio/mpeg");
        contentTypes.put("mp21", "application/mp21");
        contentTypes.put("mp2a", "audio/mpeg");
        contentTypes.put("mp3", "audio/mpeg");
        contentTypes.put("mp4", "video/mp4");
        contentTypes.put("mp4a", "audio/mp4");
        contentTypes.put("mp4s", "application/mp4");
        contentTypes.put("mp4v", "video/mp4");
        contentTypes.put("mpa", "audio/mpeg");
        contentTypes.put("mpc", "application/vnd.mophun.certificate");
        contentTypes.put("mpe", "video/mpeg");
        contentTypes.put("mpeg", "video/mpeg");
        contentTypes.put("mpega", "audio/x-mpeg");
        contentTypes.put("mpg", "video/mpeg");
        contentTypes.put("mpg4", "video/mp4");
        contentTypes.put("mpga", "audio/mpeg");
        contentTypes.put("mpkg", "application/vnd.apple.installer+xml");
        contentTypes.put("mpm", "application/vnd.blueice.multipass");
        contentTypes.put("mpn", "application/vnd.mophun.application");
        contentTypes.put("mpp", "application/vnd.ms-project");
        contentTypes.put("mpt", "application/vnd.ms-project");
        contentTypes.put("mpv2", "video/mpeg2");
        contentTypes.put("mpy", "application/vnd.ibm.minipay");
        contentTypes.put("mqy", "application/vnd.mobius.mqy");
        contentTypes.put("mrc", "application/marc");
        contentTypes.put("mrcx", "application/marcxml+xml");
        contentTypes.put("ms", "text/troff");
        contentTypes.put("mscml", "application/mediaservercontrol+xml");
        contentTypes.put("mseed", "application/vnd.fdsn.mseed");
        contentTypes.put("mseq", "application/vnd.mseq");
        contentTypes.put("msf", "application/vnd.epson.msf");
        contentTypes.put("msh", "model/mesh");
        contentTypes.put("msi", "application/x-msdownload");
        contentTypes.put("msl", "application/vnd.mobius.msl");
        contentTypes.put("msty", "application/vnd.muvee.style");
        contentTypes.put("mts", "model/vnd.mts");
        contentTypes.put("mus", "application/vnd.musician");
        contentTypes.put("musicxml", "application/vnd.recordare.musicxml+xml");
        contentTypes.put("mvb", "application/x-msmediaview");
        contentTypes.put("mwf", "application/vnd.mfer");
        contentTypes.put("mxf", "application/mxf");
        contentTypes.put("mxl", "application/vnd.recordare.musicxml");
        contentTypes.put("mxml", "application/xv+xml");
        contentTypes.put("mxs", "application/vnd.triscape.mxs");
        contentTypes.put("mxu", "video/vnd.mpegurl");
        contentTypes.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
        contentTypes.put("n3", "text/n3");
        contentTypes.put("nb", "application/mathematica");
        contentTypes.put("nbp", "application/vnd.wolfram.player");
        contentTypes.put("nc", "application/x-netcdf");
        contentTypes.put("ncx", "application/x-dtbncx+xml");
        contentTypes.put("nfo", "text/x-nfo");
        contentTypes.put("ngdat", "application/vnd.nokia.n-gage.data");
        contentTypes.put("nitf", "application/vnd.nitf");
        contentTypes.put("nlu", "application/vnd.neurolanguage.nlu");
        contentTypes.put("nml", "application/vnd.enliven");
        contentTypes.put("nnd", "application/vnd.noblenet-directory");
        contentTypes.put("nns", "application/vnd.noblenet-sealer");
        contentTypes.put("nnw", "application/vnd.noblenet-web");
        contentTypes.put("npx", "image/vnd.net-fpx");
        contentTypes.put("nsc", "application/x-conference");
        contentTypes.put("nsf", "application/vnd.lotus-notes");
        contentTypes.put("ntf", "application/vnd.nitf");
        contentTypes.put("nzb", "application/x-nzb");
        contentTypes.put("oa2", "application/vnd.fujitsu.oasys2");
        contentTypes.put("oa3", "application/vnd.fujitsu.oasys3");
        contentTypes.put("oas", "application/vnd.fujitsu.oasys");
        contentTypes.put("obd", "application/x-msbinder");
        contentTypes.put("obj", "application/x-tgif");
        contentTypes.put("oda", "application/oda");
        contentTypes.put("odb", "application/vnd.oasis.opendocument.database");
        contentTypes.put("odc", "application/vnd.oasis.opendocument.chart");
        contentTypes.put("odf", "application/vnd.oasis.opendocument.formula");
        contentTypes.put("odft", "application/vnd.oasis.opendocument.formula-template");
        contentTypes.put("odg", "application/vnd.oasis.opendocument.graphics");
        contentTypes.put("odi", "application/vnd.oasis.opendocument.image");
        contentTypes.put("odm", "application/vnd.oasis.opendocument.text-master");
        contentTypes.put("odp", "application/vnd.oasis.opendocument.presentation");
        contentTypes.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        contentTypes.put("odt", "application/vnd.oasis.opendocument.text");
        contentTypes.put("oga", "audio/ogg");
        contentTypes.put("ogg", "audio/ogg");
        contentTypes.put("ogv", "video/ogg");
        contentTypes.put("ogx", "application/ogg");
        contentTypes.put("omdoc", "application/omdoc+xml");
        contentTypes.put("onepkg", "application/onenote");
        contentTypes.put("onetmp", "application/onenote");
        contentTypes.put("onetoc", "application/onenote");
        contentTypes.put("onetoc2", "application/onenote");
        contentTypes.put("opf", "application/oebps-package+xml");
        contentTypes.put("opml", "text/x-opml");
        contentTypes.put("oprc", "application/vnd.palm");
        contentTypes.put("org", "application/vnd.lotus-organizer");
        contentTypes.put("osf", "application/vnd.yamaha.openscoreformat");
        contentTypes.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
        contentTypes.put("otc", "application/vnd.oasis.opendocument.chart-template");
        contentTypes.put("otf", "application/x-font-otf");
        contentTypes.put("otg", "application/vnd.oasis.opendocument.graphics-template");
        contentTypes.put("oth", "application/vnd.oasis.opendocument.text-web");
        contentTypes.put("oti", "application/vnd.oasis.opendocument.image-template");
        contentTypes.put("otp", "application/vnd.oasis.opendocument.presentation-template");
        contentTypes.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
        contentTypes.put("ott", "application/vnd.oasis.opendocument.text-template");
        contentTypes.put("oxps", "application/oxps");
        contentTypes.put("oxt", "application/vnd.openofficeorg.extension");
        contentTypes.put("p", "text/x-pascal");
        contentTypes.put("p10", "application/pkcs10");
        contentTypes.put("p12", "application/x-pkcs12");
        contentTypes.put("p7b", "application/x-pkcs7-certificates");
        contentTypes.put("p7c", "application/pkcs7-mime");
        contentTypes.put("p7m", "application/pkcs7-mime");
        contentTypes.put("p7r", "application/x-pkcs7-certreqresp");
        contentTypes.put("p7s", "application/pkcs7-signature");
        contentTypes.put("p8", "application/pkcs8");
        contentTypes.put("pas", "text/x-pascal");
        contentTypes.put("paw", "application/vnd.pawaafile");
        contentTypes.put("pbd", "application/vnd.powerbuilder6");
        contentTypes.put("pbm", "image/x-portable-bitmap");
        contentTypes.put("pcap", "application/vnd.tcpdump.pcap");
        contentTypes.put("pcf", "application/x-font-pcf");
        contentTypes.put("pcl", "application/vnd.hp-pcl");
        contentTypes.put("pclxl", "application/vnd.hp-pclxl");
        contentTypes.put("pct", "image/pict");
        contentTypes.put("pcurl", "application/vnd.curl.pcurl");
        contentTypes.put("pcx", "image/x-pcx");
        contentTypes.put("pdb", "application/vnd.palm");
        contentTypes.put("pdf", "application/pdf");
        contentTypes.put("pfa", "application/x-font-type1");
        contentTypes.put("pfb", "application/x-font-type1");
        contentTypes.put("pfm", "application/x-font-type1");
        contentTypes.put("pfr", "application/font-tdpfr");
        contentTypes.put("pfx", "application/x-pkcs12");
        contentTypes.put("pgm", "image/x-portable-graymap");
        contentTypes.put("pgn", "application/x-chess-pgn");
        contentTypes.put("pgp", "application/pgp-encrypted");
        contentTypes.put("pic", "image/pict");
        contentTypes.put("pict", "image/pict");
        contentTypes.put("pkg", "application/octet-stream");
        contentTypes.put("pki", "application/pkixcmp");
        contentTypes.put("pkipath", "application/pkix-pkipath");
        contentTypes.put("plb", "application/vnd.3gpp.pic-bw-large");
        contentTypes.put("plc", "application/vnd.mobius.plc");
        contentTypes.put("plf", "application/vnd.pocketlearn");
        contentTypes.put("pls", "audio/x-scpls");
        contentTypes.put("pml", "application/vnd.ctc-posml");
        contentTypes.put("png", "image/png");
        contentTypes.put("pnm", "image/x-portable-anymap");
        contentTypes.put("pnt", "image/x-macpaint");
        contentTypes.put("portpkg", "application/vnd.macports.portpkg");
        contentTypes.put("pot", "application/vnd.ms-powerpoint");
        contentTypes.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
        contentTypes.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        contentTypes.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
        contentTypes.put("ppd", "application/vnd.cups-ppd");
        contentTypes.put("ppm", "image/x-portable-pixmap");
        contentTypes.put("pps", "application/vnd.ms-powerpoint");
        contentTypes.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
        contentTypes.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        contentTypes.put("ppt", "application/vnd.ms-powerpoint");
        contentTypes.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
        contentTypes.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        contentTypes.put("pqa", "application/vnd.palm");
        contentTypes.put("prc", "application/x-mobipocket-ebook");
        contentTypes.put("pre", "application/vnd.lotus-freelance");
        contentTypes.put("prf", "application/pics-rules");
        contentTypes.put("ps", "application/postscript");
        contentTypes.put("psb", "application/vnd.3gpp.pic-bw-small");
        contentTypes.put("psd", "image/vnd.adobe.photoshop");
        contentTypes.put("psf", "application/x-font-linux-psf");
        contentTypes.put("pskcxml", "application/pskc+xml");
        contentTypes.put("ptid", "application/vnd.pvi.ptid1");
        contentTypes.put("pub", "application/x-mspublisher");
        contentTypes.put("pvb", "application/vnd.3gpp.pic-bw-var");
        contentTypes.put("pwn", "application/vnd.3m.post-it-notes");
        contentTypes.put("pya", "audio/vnd.ms-playready.media.pya");
        contentTypes.put("pyv", "video/vnd.ms-playready.media.pyv");
        contentTypes.put("qam", "application/vnd.epson.quickanime");
        contentTypes.put("qbo", "application/vnd.intu.qbo");
        contentTypes.put("qfx", "application/vnd.intu.qfx");
        contentTypes.put("qps", "application/vnd.publishare-delta-tree");
        contentTypes.put("qt", "video/quicktime");
        contentTypes.put("qti", "image/x-quicktime");
        contentTypes.put("qtif", "image/x-quicktime");
        contentTypes.put("qwd", "application/vnd.quark.quarkxpress");
        contentTypes.put("qwt", "application/vnd.quark.quarkxpress");
        contentTypes.put("qxb", "application/vnd.quark.quarkxpress");
        contentTypes.put("qxd", "application/vnd.quark.quarkxpress");
        contentTypes.put("qxl", "application/vnd.quark.quarkxpress");
        contentTypes.put("qxt", "application/vnd.quark.quarkxpress");
        contentTypes.put("ra", "audio/x-pn-realaudio");
        contentTypes.put("ram", "audio/x-pn-realaudio");
        contentTypes.put("rar", "application/x-rar-compressed");
        contentTypes.put("ras", "image/x-cmu-raster");
        contentTypes.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
        contentTypes.put("rdf", "application/rdf+xml");
        contentTypes.put("rdz", "application/vnd.data-vision.rdz");
        contentTypes.put("rep", "application/vnd.businessobjects");
        contentTypes.put("res", "application/x-dtbresource+xml");
        contentTypes.put("rgb", "image/x-rgb");
        contentTypes.put("rif", "application/reginfo+xml");
        contentTypes.put("rip", "audio/vnd.rip");
        contentTypes.put("ris", "application/x-research-info-systems");
        contentTypes.put("rl", "application/resource-lists+xml");
        contentTypes.put("rlc", "image/vnd.fujixerox.edmics-rlc");
        contentTypes.put("rld", "application/resource-lists-diff+xml");
        contentTypes.put("rm", "application/vnd.rn-realmedia");
        contentTypes.put("rmi", "audio/midi");
        contentTypes.put("rmp", "audio/x-pn-realaudio-plugin");
        contentTypes.put("rms", "application/vnd.jcp.javame.midlet-rms");
        contentTypes.put("rmvb", "application/vnd.rn-realmedia-vbr");
        contentTypes.put("rnc", "application/relax-ng-compact-syntax");
        contentTypes.put("roa", "application/rpki-roa");
        contentTypes.put("roff", "text/troff");
        contentTypes.put("rp9", "application/vnd.cloanto.rp9");
        contentTypes.put("rpss", "application/vnd.nokia.radio-presets");
        contentTypes.put("rpst", "application/vnd.nokia.radio-preset");
        contentTypes.put("rq", "application/sparql-query");
        contentTypes.put("rs", "application/rls-services+xml");
        contentTypes.put("rsd", "application/rsd+xml");
        contentTypes.put("rss", "application/rss+xml");
        contentTypes.put("rtf", "application/rtf");
        contentTypes.put("rtx", "text/richtext");
        contentTypes.put("s", "text/x-asm");
        contentTypes.put("s3m", "audio/s3m");
        contentTypes.put("saf", "application/vnd.yamaha.smaf-audio");
        contentTypes.put("sbml", "application/sbml+xml");
        contentTypes.put("sc", "application/vnd.ibm.secure-container");
        contentTypes.put("scd", "application/x-msschedule");
        contentTypes.put("scm", "application/vnd.lotus-screencam");
        contentTypes.put("scq", "application/scvp-cv-request");
        contentTypes.put("scs", "application/scvp-cv-response");
        contentTypes.put("scurl", "text/vnd.curl.scurl");
        contentTypes.put("sda", "application/vnd.stardivision.draw");
        contentTypes.put("sdc", "application/vnd.stardivision.calc");
        contentTypes.put("sdd", "application/vnd.stardivision.impress");
        contentTypes.put("sdkd", "application/vnd.solent.sdkm+xml");
        contentTypes.put("sdkm", "application/vnd.solent.sdkm+xml");
        contentTypes.put("sdp", "application/sdp");
        contentTypes.put("sdw", "application/vnd.stardivision.writer");
        contentTypes.put("see", "application/vnd.seemail");
        contentTypes.put("seed", "application/vnd.fdsn.seed");
        contentTypes.put("sema", "application/vnd.sema");
        contentTypes.put("semd", "application/vnd.semd");
        contentTypes.put("semf", "application/vnd.semf");
        contentTypes.put("ser", "application/java-serialized-object");
        contentTypes.put("setpay", "application/set-payment-initiation");
        contentTypes.put("setreg", "application/set-registration-initiation");
        contentTypes.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
        contentTypes.put("sfs", "application/vnd.spotfire.sfs");
        contentTypes.put("sfv", "text/x-sfv");
        contentTypes.put("sgi", "image/sgi");
        contentTypes.put("sgl", "application/vnd.stardivision.writer-global");
        contentTypes.put("sgm", "text/sgml");
        contentTypes.put("sgml", "text/sgml");
        contentTypes.put("sh", "application/x-sh");
        contentTypes.put("shar", "application/x-shar");
        contentTypes.put("shf", "application/shf+xml");

        contentTypes.put("sid", "image/x-mrsid-image");
        contentTypes.put("sig", "application/pgp-signature");
        contentTypes.put("sil", "audio/silk");
        contentTypes.put("silo", "model/mesh");
        contentTypes.put("sis", "application/vnd.symbian.install");
        contentTypes.put("sisx", "application/vnd.symbian.install");
        contentTypes.put("sit", "application/x-stuffit");
        contentTypes.put("sitx", "application/x-stuffitx");
        contentTypes.put("skd", "application/vnd.koan");
        contentTypes.put("skm", "application/vnd.koan");
        contentTypes.put("skp", "application/vnd.koan");
        contentTypes.put("skt", "application/vnd.koan");
        contentTypes.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
        contentTypes.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
        contentTypes.put("slt", "application/vnd.epson.salt");
        contentTypes.put("sm", "application/vnd.stepmania.stepchart");
        contentTypes.put("smf", "application/vnd.stardivision.math");
        contentTypes.put("smi", "application/smil+xml");
        contentTypes.put("smil", "application/smil+xml");
        contentTypes.put("smv", "video/x-smv");
        contentTypes.put("smzip", "application/vnd.stepmania.package");
        contentTypes.put("snd", "audio/basic");
        contentTypes.put("snf", "application/x-font-snf");
        contentTypes.put("so", "application/octet-stream");
        contentTypes.put("spc", "application/x-pkcs7-certificates");
        contentTypes.put("spf", "application/vnd.yamaha.smaf-phrase");
        contentTypes.put("spl", "application/x-futuresplash");
        contentTypes.put("spot", "text/vnd.in3d.spot");
        contentTypes.put("spp", "application/scvp-vp-response");
        contentTypes.put("spq", "application/scvp-vp-request");
        contentTypes.put("spx", "audio/ogg");
        contentTypes.put("sql", "application/x-sql");
        contentTypes.put("src", "application/x-wais-source");
        contentTypes.put("srt", "application/x-subrip");
        contentTypes.put("sru", "application/sru+xml");
        contentTypes.put("srx", "application/sparql-results+xml");
        contentTypes.put("ssdl", "application/ssdl+xml");
        contentTypes.put("sse", "application/vnd.kodak-descriptor");
        contentTypes.put("ssf", "application/vnd.epson.ssf");
        contentTypes.put("ssml", "application/ssml+xml");
        contentTypes.put("st", "application/vnd.sailingtracker.track");
        contentTypes.put("stc", "application/vnd.sun.xml.calc.template");
        contentTypes.put("std", "application/vnd.sun.xml.draw.template");
        contentTypes.put("stf", "application/vnd.wt.stf");
        contentTypes.put("sti", "application/vnd.sun.xml.impress.template");
        contentTypes.put("stk", "application/hyperstudio");
        contentTypes.put("stl", "application/vnd.ms-pki.stl");
        contentTypes.put("str", "application/vnd.pg.format");
        contentTypes.put("stw", "application/vnd.sun.xml.writer.template");
        contentTypes.put("sub", "text/vnd.dvb.subtitle");
        contentTypes.put("sus", "application/vnd.sus-calendar");
        contentTypes.put("susp", "application/vnd.sus-calendar");
        contentTypes.put("sv4cpio", "application/x-sv4cpio");
        contentTypes.put("sv4crc", "application/x-sv4crc");
        contentTypes.put("svc", "application/vnd.dvb.service");
        contentTypes.put("svd", "application/vnd.svd");
        contentTypes.put("svg", "image/svg+xml");
        contentTypes.put("svgz", "image/svg+xml");
        contentTypes.put("swa", "application/x-director");
        contentTypes.put("swf", "application/x-shockwave-flash");
        contentTypes.put("swi", "application/vnd.aristanetworks.swi");
        contentTypes.put("sxc", "application/vnd.sun.xml.calc");
        contentTypes.put("sxd", "application/vnd.sun.xml.draw");
        contentTypes.put("sxg", "application/vnd.sun.xml.writer.global");
        contentTypes.put("sxi", "application/vnd.sun.xml.impress");
        contentTypes.put("sxm", "application/vnd.sun.xml.math");
        contentTypes.put("sxw", "application/vnd.sun.xml.writer");
        contentTypes.put("t", "text/troff");
        contentTypes.put("t3", "application/x-t3vm-image");
        contentTypes.put("taglet", "application/vnd.mynfc");
        contentTypes.put("tao", "application/vnd.tao.intent-module-archive");
        contentTypes.put("tar", "application/x-tar");
        contentTypes.put("tcap", "application/vnd.3gpp2.tcap");
        contentTypes.put("tcl", "application/x-tcl");
        contentTypes.put("teacher", "application/vnd.smart.teacher");
        contentTypes.put("tei", "application/tei+xml");
        contentTypes.put("teicorpus", "application/tei+xml");
        contentTypes.put("tex", "application/x-tex");
        contentTypes.put("texi", "application/x-texinfo");
        contentTypes.put("texinfo", "application/x-texinfo");
        contentTypes.put("text", "text/plain");
        contentTypes.put("tfi", "application/thraud+xml");
        contentTypes.put("tfm", "application/x-tex-tfm");
        contentTypes.put("tga", "image/x-tga");
        contentTypes.put("thmx", "application/vnd.ms-officetheme");
        contentTypes.put("tif", "image/tiff");
        contentTypes.put("tiff", "image/tiff");
        contentTypes.put("tmo", "application/vnd.tmobile-livetv");
        contentTypes.put("torrent", "application/x-bittorrent");
        contentTypes.put("tpl", "application/vnd.groove-tool-template");
        contentTypes.put("tpt", "application/vnd.trid.tpt");
        contentTypes.put("tr", "text/troff");
        contentTypes.put("tra", "application/vnd.trueapp");
        contentTypes.put("trm", "application/x-msterminal");
        contentTypes.put("tsd", "application/timestamped-data");
        contentTypes.put("tsv", "text/tab-separated-values");
        contentTypes.put("ttc", "application/x-font-ttf");
        contentTypes.put("ttf", "application/x-font-ttf");
        contentTypes.put("ttl", "text/turtle");
        contentTypes.put("twd", "application/vnd.simtech-mindmapper");
        contentTypes.put("twds", "application/vnd.simtech-mindmapper");
        contentTypes.put("txd", "application/vnd.genomatix.tuxedo");
        contentTypes.put("txf", "application/vnd.mobius.txf");
        contentTypes.put("txt", "text/plain");
        contentTypes.put("u32", "application/x-authorware-bin");
        contentTypes.put("udeb", "application/x-debian-package");
        contentTypes.put("ufd", "application/vnd.ufdl");
        contentTypes.put("ufdl", "application/vnd.ufdl");
        contentTypes.put("ulw", "audio/basic");
        contentTypes.put("ulx", "application/x-glulx");
        contentTypes.put("umj", "application/vnd.umajin");
        contentTypes.put("unityweb", "application/vnd.unity");
        contentTypes.put("uoml", "application/vnd.uoml+xml");
        contentTypes.put("uri", "text/uri-list");
        contentTypes.put("uris", "text/uri-list");
        contentTypes.put("urls", "text/uri-list");
        contentTypes.put("ustar", "application/x-ustar");
        contentTypes.put("utz", "application/vnd.uiq.theme");
        contentTypes.put("uu", "text/x-uuencode");
        contentTypes.put("uva", "audio/vnd.dece.audio");
        contentTypes.put("uvd", "application/vnd.dece.data");
        contentTypes.put("uvf", "application/vnd.dece.data");
        contentTypes.put("uvg", "image/vnd.dece.graphic");
        contentTypes.put("uvh", "video/vnd.dece.hd");
        contentTypes.put("uvi", "image/vnd.dece.graphic");
        contentTypes.put("uvm", "video/vnd.dece.mobile");
        contentTypes.put("uvp", "video/vnd.dece.pd");
        contentTypes.put("uvs", "video/vnd.dece.sd");
        contentTypes.put("uvt", "application/vnd.dece.ttml+xml");
        contentTypes.put("uvu", "video/vnd.uvvu.mp4");
        contentTypes.put("uvv", "video/vnd.dece.video");
        contentTypes.put("uvva", "audio/vnd.dece.audio");
        contentTypes.put("uvvd", "application/vnd.dece.data");
        contentTypes.put("uvvf", "application/vnd.dece.data");
        contentTypes.put("uvvg", "image/vnd.dece.graphic");
        contentTypes.put("uvvh", "video/vnd.dece.hd");
        contentTypes.put("uvvi", "image/vnd.dece.graphic");
        contentTypes.put("uvvm", "video/vnd.dece.mobile");
        contentTypes.put("uvvp", "video/vnd.dece.pd");
        contentTypes.put("uvvs", "video/vnd.dece.sd");
        contentTypes.put("uvvt", "application/vnd.dece.ttml+xml");
        contentTypes.put("uvvu", "video/vnd.uvvu.mp4");
        contentTypes.put("uvvv", "video/vnd.dece.video");
        contentTypes.put("uvvx", "application/vnd.dece.unspecified");
        contentTypes.put("uvvz", "application/vnd.dece.zip");
        contentTypes.put("uvx", "application/vnd.dece.unspecified");
        contentTypes.put("uvz", "application/vnd.dece.zip");
        contentTypes.put("vcard", "text/vcard");
        contentTypes.put("vcd", "application/x-cdlink");
        contentTypes.put("vcf", "text/x-vcard");
        contentTypes.put("vcg", "application/vnd.groove-vcard");
        contentTypes.put("vcs", "text/x-vcalendar");
        contentTypes.put("vcx", "application/vnd.vcx");
        contentTypes.put("vis", "application/vnd.visionary");
        contentTypes.put("viv", "video/vnd.vivo");
        contentTypes.put("vob", "video/x-ms-vob");
        contentTypes.put("vor", "application/vnd.stardivision.writer");
        contentTypes.put("vox", "application/x-authorware-bin");
        contentTypes.put("vrml", "model/vrml");
        contentTypes.put("vsd", "application/vnd.visio");
        contentTypes.put("vsf", "application/vnd.vsf");
        contentTypes.put("vss", "application/vnd.visio");
        contentTypes.put("vst", "application/vnd.visio");
        contentTypes.put("vsw", "application/vnd.visio");
        contentTypes.put("vtu", "model/vnd.vtu");
        contentTypes.put("vxml", "application/voicexml+xml");
        contentTypes.put("w3d", "application/x-director");
        contentTypes.put("wad", "application/x-doom");
        contentTypes.put("wav", "audio/x-wav");
        contentTypes.put("wax", "audio/x-ms-wax");
        contentTypes.put("wbmp", "image/vnd.wap.wbmp");
        contentTypes.put("wbs", "application/vnd.criticaltools.wbs+xml");
        contentTypes.put("wbxml", "application/vnd.wap.wbxml");
        contentTypes.put("wcm", "application/vnd.ms-works");
        contentTypes.put("wdb", "application/vnd.ms-works");
        contentTypes.put("wdp", "image/vnd.ms-photo");
        contentTypes.put("weba", "audio/webm");
        contentTypes.put("webm", "video/webm");
        contentTypes.put("webp", "image/webp");
        contentTypes.put("wg", "application/vnd.pmi.widget");
        contentTypes.put("wgt", "application/widget");
        contentTypes.put("wks", "application/vnd.ms-works");
        contentTypes.put("wm", "video/x-ms-wm");
        contentTypes.put("wma", "audio/x-ms-wma");
        contentTypes.put("wmd", "application/x-ms-wmd");
        contentTypes.put("wmf", "application/x-msmetafile");
        contentTypes.put("wml", "text/vnd.wap.wml");
        contentTypes.put("wmlc", "application/vnd.wap.wmlc");
        contentTypes.put("wmls", "text/vnd.wap.wmlscript");
        contentTypes.put("wmlsc", "application/vnd.wap.wmlscriptc");
        contentTypes.put("wmv", "video/x-ms-wmv");
        contentTypes.put("wmx", "video/x-ms-wmx");
        contentTypes.put("wmz", "application/x-msmetafile");
        contentTypes.put("woff", "application/x-font-woff");
        contentTypes.put("wpd", "application/vnd.wordperfect");
        contentTypes.put("wpl", "application/vnd.ms-wpl");
        contentTypes.put("wps", "application/vnd.ms-works");
        contentTypes.put("wqd", "application/vnd.wqd");
        contentTypes.put("wri", "application/x-mswrite");
        contentTypes.put("wrl", "model/vrml");
        contentTypes.put("wsdl", "application/wsdl+xml");
        contentTypes.put("wspolicy", "application/wspolicy+xml");
        contentTypes.put("wtb", "application/vnd.webturbo");
        contentTypes.put("wvx", "video/x-ms-wvx");
        contentTypes.put("x32", "application/x-authorware-bin");
        contentTypes.put("x3d", "model/x3d+xml");
        contentTypes.put("x3db", "model/x3d+binary");
        contentTypes.put("x3dbz", "model/x3d+binary");
        contentTypes.put("x3dv", "model/x3d+vrml");
        contentTypes.put("x3dvz", "model/x3d+vrml");
        contentTypes.put("x3dz", "model/x3d+xml");
        contentTypes.put("xaml", "application/xaml+xml");
        contentTypes.put("xap", "application/x-silverlight-app");
        contentTypes.put("xar", "application/vnd.xara");
        contentTypes.put("xbap", "application/x-ms-xbap");
        contentTypes.put("xbd", "application/vnd.fujixerox.docuworks.binder");
        contentTypes.put("xbm", "image/x-xbitmap");
        contentTypes.put("xdf", "application/xcap-diff+xml");
        contentTypes.put("xdm", "application/vnd.syncml.dm+xml");
        contentTypes.put("xdp", "application/vnd.adobe.xdp+xml");
        contentTypes.put("xdssc", "application/dssc+xml");
        contentTypes.put("xdw", "application/vnd.fujixerox.docuworks");
        contentTypes.put("xenc", "application/xenc+xml");
        contentTypes.put("xer", "application/patch-ops-error+xml");
        contentTypes.put("xfdf", "application/vnd.adobe.xfdf");
        contentTypes.put("xfdl", "application/vnd.xfdl");
        contentTypes.put("xht", "application/xhtml+xml");
        contentTypes.put("xhtml", "application/xhtml+xml");
        contentTypes.put("xhvml", "application/xv+xml");
        contentTypes.put("xif", "image/vnd.xiff");
        contentTypes.put("xla", "application/vnd.ms-excel");
        contentTypes.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
        contentTypes.put("xlc", "application/vnd.ms-excel");
        contentTypes.put("xlf", "application/x-xliff+xml");
        contentTypes.put("xlm", "application/vnd.ms-excel");
        contentTypes.put("xls", "application/vnd.ms-excel");
        contentTypes.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
        contentTypes.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
        contentTypes.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        contentTypes.put("xlt", "application/vnd.ms-excel");
        contentTypes.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
        contentTypes.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        contentTypes.put("xlw", "application/vnd.ms-excel");
        contentTypes.put("xm", "audio/xm");
        contentTypes.put("xml", "application/xml");
        contentTypes.put("xo", "application/vnd.olpc-sugar");
        contentTypes.put("xop", "application/xop+xml");
        contentTypes.put("xpi", "application/x-xpinstall");
        contentTypes.put("xpl", "application/xproc+xml");
        contentTypes.put("xpm", "image/x-xpixmap");
        contentTypes.put("xpr", "application/vnd.is-xpr");
        contentTypes.put("xps", "application/vnd.ms-xpsdocument");
        contentTypes.put("xpw", "application/vnd.intercon.formnet");
        contentTypes.put("xpx", "application/vnd.intercon.formnet");
        contentTypes.put("xsl", "application/xml");
        contentTypes.put("xslt", "application/xslt+xml");
        contentTypes.put("xsm", "application/vnd.syncml+xml");
        contentTypes.put("xspf", "application/xspf+xml");
        contentTypes.put("xul", "application/vnd.mozilla.xul+xml");
        contentTypes.put("xvm", "application/xv+xml");
        contentTypes.put("xvml", "application/xv+xml");
        contentTypes.put("xwd", "image/x-xwindowdump");
        contentTypes.put("xyz", "chemical/x-xyz");
        contentTypes.put("xz", "application/x-xz");
        contentTypes.put("yang", "application/yang");
        contentTypes.put("yin", "application/yin+xml");
        contentTypes.put("z", "application/x-compress");
        contentTypes.put("Z", "application/x-compress");
        contentTypes.put("z1", "application/x-zmachine");
        contentTypes.put("z2", "application/x-zmachine");
        contentTypes.put("z3", "application/x-zmachine");
        contentTypes.put("z4", "application/x-zmachine");
        contentTypes.put("z5", "application/x-zmachine");
        contentTypes.put("z6", "application/x-zmachine");
        contentTypes.put("z7", "application/x-zmachine");
        contentTypes.put("z8", "application/x-zmachine");
        contentTypes.put("zaz", "application/vnd.zzazz.deck+xml");
        contentTypes.put("zip", "application/zip");
        contentTypes.put("zir", "application/vnd.zul");
        contentTypes.put("zirz", "application/vnd.zul");
        contentTypes.put("zmm", "application/vnd.handheld-entertainment+xml");
    }

    public static String getContentType(String ext) {
        String type = contentTypes.get(ext.toLowerCase());
        return type != null ? type : "application/unknown";
    }
}
