package com.topsunit.query.binding;

import com.huigou.data.query.executor.SQLExecutorDao;

/**
 * 调用上下文。
 *
 * @author yonghuan
 * @since 1.1.3
 */
public interface InvokeContext<T> {

    /**
     * 获取Mapper代理接口的类信息
     *
     * @return Mapper代理接口的类信息
     */
    Class<T> getMapperInterface();

    /**
     * 获取 SQLExecutorDao。
     *
     * @return SQLExecutorDao
     */
    SQLExecutorDao getSqlExecutor();

    /**
     * 获取配置xml文件。
     *
     * @return 配置xml文件
     */
    String getXml();

}
