package com.huigou.explorer.converters.mxgraph;

import com.mxgraph.view.mxGraph;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;

/**
 * mxgraph 元素转换器。
 *
 * @author yonghuan
 */
public interface MxElementConverter {

    boolean supports(BaseElement baseElement);

    /**
     * 将activiti元素转换为mxgraph 元素
     *
     * @param bpmnModel   activiti bpmnModel
     * @param process     activiti 流程模型
     * @param graph       mxGraph
     * @param baseElement activiti元素
     */
    void convert(BpmnModel bpmnModel, org.activiti.bpmn.model.Process process, mxGraph graph, BaseElement baseElement);

}
