package com.huigou.explorer.converters.bpmn;

import com.alibaba.fastjson.JSONObject;
import org.activiti.bpmn.model.ActivitiListener;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yonghuan
 */
public class ActivitiListenerParserImpl implements ActivitiListenerParser {

    @Override
    public List<ActivitiListener> parse(List<Object> listeners) {
        return listeners.stream()
                .map(JSONObject.class::cast)
                .map(json -> json.toJavaObject(ActivitiListener.class))
                .collect(Collectors.toList());
    }
}
