package com.huigou.uasp.bmp.opm.application;

import com.huigou.data.domain.query.EmptyQueryRequest;
import com.huigou.uasp.bmp.opm.domain.query.RoleBizManagementQueryRequest;

import java.util.List;
import java.util.Map;

/**
 * 角色业务管理权限
 *
 * @author yonghuan
 */
public interface RoleBizManagementApplication {

    /**
     * 分配下属
     *
     * @param managerId        管理者ID
     * @param manageTypeId     业务管理权限类别ID
     * @param subordinationIds 下属ID列表
     */
    void allocateSubordinations(String managerId, String manageTypeId, List<String> subordinationIds);

    Map<String, Object> slicedQuerySubordination(RoleBizManagementQueryRequest queryRequest);

    void deleteByIds(List<String> id);

}
