﻿var gridManager=null, refreshFlag = false;
$(function () {
	bindEvent();
	initializeGrid();
});

function bindEvent(){
	$("#queryName").orgTree({
        filter: "psm", excludePos: 1, param: {orgRoot: "55CC78F4502C46F6A174804E9D02F91F"},
        back: {text: "#queryName"},
        // manageType: 'taskQuery,admin',
        onChange:function(value,data){
        	$('#queryCode').val(data.code);
        }
    });
	
	$('#procName').treebox({
		name : 'procTreeView',
		param: {nodeKindId: "folder,proc"},
		back: {text: "#procName"},
		onChange:function(value,data){
			$('#procFullId').val(data.fullId);
		}
	});
	$('#selectDateRange').combox({onChange:function(){
		setTimeout(function(){initdateRange();},10);
	}})
	initdateRange();
}

function initdateRange(){
	var dateRange=$('#selectDateRange').val();
	if(dateRange=='10'){
		UICtrl.enable('#editStartDate');
		UICtrl.enable('#editEndDate');
	}else{
		UICtrl.disable('#editStartDate');
		UICtrl.disable('#editEndDate');
	}
}

function initializeGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler:addOtherSystemConfig,
		updateHandler: updateHandler,
		deleteHandler: deleteHandler,
		enableHandler: enableHandler,
		disableHandler: disableHandler
	});
    gridManager = UICtrl.grid("#maingrid", {
        columns:  [
                 { display:"系统名称", name: "name", width:350, minWidth: 60, type: "string", align: "left"},
       	         { display:"系统编码", name: "code", width: 150, minWidth: 60, type: "string", align: "left" },
       	         { display:"接口名称", name: "systemServiceName", width: 150, minWidth: 60, type: "string", align: "left" },
       	         { display:"接口编码",name: "systemServiceCategory", width:120, minWidth: 60, type: "date", align: "left" },
				 { display:"是否启用规则验证",name: "isEnableRuleTextView", width:120, minWidth: 60, type: "string", align: "center" },
				 { display:"规则编码",name: "ruleCode", width:120, minWidth: 60, type: "string", align: "left" },
				 { display:"规则名称",name: "ruleName", width:160, minWidth: 60, type: "string", align: "left" },
				 { display:"备注",name: "remark", width: 220, minWidth: 60, type: "string", align: "left" },
				 { display: "状态", name: "status", width: "60", minWidth: 60, type: "string", align: "center",
					render: function (item) {
						return UICtrl.getStatusInfo(item.status);
					}
				 }
       	],
        dataAction: "server",
        url: web_app.name + "/webservice/findOtherSystemConfig.ajax",
        pageSize: 20,
		checkbox: true,
        width: "99.8%",
        height: '100%',
        heightDiff: -2,
        // fixedCellHeight: true,
        // selectRowButtonOnly: true,
		toolbar:toolbarOptions
		// ,
        // delayLoad: true
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
	var param = $(obj).formToJSON();
	if(!param) return;
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

/**
 * 新增第三方系统WEB SERVICE 配置
 */
function addOtherSystemConfig(){
	UICtrl.showAjaxDialog({
		title:"新增配置",
		url:web_app.name+"/webservice/forwardInsertWebServiceConfig.load",
		width: 800,
		height: 400,
		ok: doSave,
		init:initSystem,
		close:dialogClose
	});
}

/**
 * 修改第三方系统WEB SERVICE 配置
 */
function updateHandler(){
	var row = DataUtil.getSelectedRow(gridManager);
	if(!row){
		return;
	}
	UICtrl.showAjaxDialog({
		title:"修改配置",
		url:web_app.name+"/webservice/forwardUpdateWebServiceConfig.load",
		width: 800,
		param:row,
		height: 400,
		ok: doSave,
		init:initSystem,
		close:dialogClose
	});
}
/**
 * 删除第三方系统WEB SERVICE 配置
 */
function deleteHandler(){
	DataUtil.del({
		action: 'webservice/deleteOtherSystemConfig.ajax',
		gridManager: gridManager, idFieldName: 'id',
		onSuccess: function () {
			reloadGrid();
		}
	});
}
/**
 * 启用第三方系统WEB SERVICE 配置
 */
function enableHandler(){
	updateStatus('您确定要启用选中数据吗?', 1);
}
/**
 * 禁用第三方系统WEB SERVICE 配置
 */
function disableHandler(){
	updateStatus('您确定要禁用选中数据吗?', 0);
}
//修改状态
function updateStatus(message, status) {
	DataUtil.updateById({
		action: 'webservice/updateOtherSystemConfigStatus.ajax',
		gridManager: gridManager, param: {status: status},
		message: message,
		onSuccess: function () {
			reloadGrid();
		}
	});
}

/**
 * 保存表单数据
 */
function doSave(){
	var _self = this;
	var url = "/webservice/saveOtherSystemConfig.ajax";
	$('#submitForm').ajaxSubmit({
		url: web_app.name + url,
		success: function () {
			refreshFlag = true;
			_self.close();
		}
	});
}

//关闭对话框
function dialogClose(){
	if(refreshFlag){
		reloadGrid();
		refreshFlag = false;
	}
}

/**
 * 详情页加载组织机构
 */
function initSystem() {
	$("#code").orgTree({
		filter: "psm", excludePos: 1, param: {orgRoot: "376D128202054464B0890B93ED774D72"},
		back: {text: "#name"},
		// manageType: 'taskQuery,admin',
		onChange:function(value,data){
			$('#code').setValue(data.code);
			$('#systemId').setValue(data.personId);
		}
	});

	$("#systemServiceName").searchbox({
		type : "webservice",name : "webServiceConfigType",
		back:{
			code:'#systemServiceCategory',
			name:'#systemServiceName'
		}
		// onChange:function(value,data){
		// 	$('#systemServiceCategory').val(data.code);
		// }
	});
	initSelectRule();
}

/**
 * 加载 规则选择框
 */
function initSelectRule(){
	$("#ruleName").searchbox({
		type : "rule",name : "rule",
		back:{
			code:'#ruleCode',
			name:'#ruleName'
		}
	});
}