﻿var gridManager=null,configManager=null, refreshFlag = false;
$(function () {
	initializeUI();
	initializeGrid();
	initializeConfigGrid();
});

function initializeUI(){
	UICtrl.layout("#layout", {leftWidth : 3,heightDiff : -5});
	$("#queryFormBtn").click(function(){
		var param = $("#queryConfigForm").formToJSON();
		if(!param) return;
		UICtrl.gridSearch(configManager, param);
	});
}

function initializeGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler:addHandler,
		updateHandler: updateHandler,
		deleteHandler: deleteHandler,
		enableHandler: enableHandler,
		disableHandler: disableHandler
	});
    gridManager = UICtrl.grid("#maingrid", {
        columns:  [
                 { display:"参数名称", name: "parameterName", width:80, minWidth: 60, type: "string", align: "left"},
       	         { display:"本地参数名称", name: "localParameterName", width: 100, minWidth: 60, type: "string", align: "left" },
       	         { display:"参数类型", name: "typeTextView", width: 80, minWidth: 60, type: "string", align: "center" },
       	         { display:"参数传递类型",name: "callTypeTextView", width:100, minWidth: 60, type: "string", align: "center" },
				 { display:"备注",name: "remark", width: 220, minWidth: 60, type: "string", align: "left" },
				 { display: "状态", name: "status", width: "60", minWidth: 60, type: "string", align: "center",
					render: function (item) {
						return UICtrl.getStatusInfo(item.status);
					}
				 }
       	],
        dataAction: "server",
        url: web_app.name + "/sapWebServiceParameter/slicedQueryList.ajax",
        pageSize: 20,
		checkbox: true,
        width: "99.8%",
        height: '100%',
        heightDiff: -2,
        // fixedCellHeight: true,
        // selectRowButtonOnly: true,
		toolbar:toolbarOptions
		// ,
        // delayLoad: true
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 加载SAP接口配置
 */
function initializeConfigGrid() {
	configManager = UICtrl.grid("#configGrid", {
		columns:  [
			{ display:"接口名称", name: "name", width:110, minWidth: 60, type: "string", align: "left"},
			{ display:"接口编码", name: "code", width: 110, minWidth: 60, type: "string", align: "left" }
		],
		dataAction: "server",
		url: web_app.name + "/sapWebService/slicedQueryList.ajax",
		pageSize: 20,
		// usePager:false,
		parms:{status:1},
		// checkbox: true,
		width: "99.8%",
		height: '100%',
		heightDiff: -2,
		onSelectRow:function(data){
			var html=[],parentId=data.id;
			if(!data){
				parentId="";
				html.push($.i18nProp('system.webservice.sap.parameter'));
			}else{
				html.push('<span class="tomato-color">[',data.name,']</span>',$.i18nProp('system.webservice.sap.parameter'));
			}
			$('#layout').layout('setCenterTitle',html.join(''));
			$("#selectConfigId").val(data.id);
			if (gridManager) {
				UICtrl.gridSearch(gridManager,{configId:parentId});
			}
		}
	});
	UICtrl.setSearchAreaToggle(configManager);
}

function query(obj) {
	var param = $(obj).formToJSON();
	if(!param) return;
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

/**
 * 新增第三方系统WEB SERVICE 配置
 */
function addHandler(){
	var selectConfigId=$("#selectConfigId").val();
	if(selectConfigId==''){
		Public.tip('system.webservice.sap.warning.not.config');
		return;
	}
	UICtrl.showAjaxDialog({
		title:"新增配置",
		url:web_app.name+"/sapWebServiceParameter/forwardInsert.load",
		width: 800,
		height: 400,
		ok: doSave,
		close:dialogClose
	});
}

/**
 * 修改第三方系统WEB SERVICE 配置
 */
function updateHandler(){
	var row = DataUtil.getSelectedRow(gridManager);
	if(!row){
		return;
	}
	UICtrl.showAjaxDialog({
		title:"修改配置",
		url:web_app.name+"/sapWebServiceParameter/forwardUpdate.load",
		width: 800,
		param:row,
		height: 400,
		ok: doSave,
		close:dialogClose
	});
}
/**
 * 删除第三方系统WEB SERVICE 配置
 */
function deleteHandler(){
	DataUtil.del({
		action: 'sapWebServiceParameter/delete.ajax',
		gridManager: gridManager, idFieldName: 'id',
		onSuccess: function () {
			reloadGrid();
		}
	});
}
/**
 * 启用第三方系统WEB SERVICE 配置
 */
function enableHandler(){
	updateStatus('您确定要启用选中数据吗?', 1);
}
/**
 * 禁用第三方系统WEB SERVICE 配置
 */
function disableHandler(){
	updateStatus('您确定要禁用选中数据吗?', 0);
}
//修改状态
function updateStatus(message, status) {
	DataUtil.updateById({
		action: 'sapWebServiceParameter/updateStatus.ajax',
		gridManager: gridManager, param: {status: status},
		message: message,
		onSuccess: function () {
			reloadGrid();
		}
	});
}

/**
 * 保存表单数据
 */
function doSave(){
	var _self = this;
	var url = "/sapWebServiceParameter/save.ajax";
	if(!$("#configId").val()){
		$("#configId").val($("#selectConfigId").val());
	}
	$('#submitForm').ajaxSubmit({
		url: web_app.name + url,
		success: function () {
			refreshFlag = true;
			_self.close();
		}
	});
}

//关闭对话框
function dialogClose(){
	if(refreshFlag){
		reloadGrid();
		refreshFlag = false;
	}
}