<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib tagdir="/WEB-INF/tags" prefix="t" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,tree,dialog,grid,combox,comboDialog,flexField,commonTree,formButton"/>
    <script src='<c:url value="/system/tbpm/service/serviceList.js"/>' type="text/javascript"></script>
</head>
<body>
<div class="container-fluid">
    <t:layout id="layout">
        <t:box position="left" title="服务分类树">
            <t:tree id="maintree"
                    loadTreesAction="/bpm/service/sliceQuery.ajax"
                    loadNodeAction="/bpm/service/forwardKind.ajax"
                    appendAction="/bpm/service/addKind.ajax"
                    deleteAction="/bpm/service/deleteById.ajax"
                    updateAction="/bpm/service/updateById.ajax"
                    updateSequenceAction="/bpm/service/updateSequence.ajax"
                    idFieldName="id"
                    parentIdFieldName="parentId"
                    textFieldName="name"
                    showMenu="true"
                    getParamFn="getTreeParam"
                    isLeafFn="checkLeafNode"
                    onClickFn="onClickTreeNode"
            />
        </t:box>
        <t:box position="center" title="服务列表">
            <t:grid id="maingrid"
                    url="/bpm/service/sliceQuery.ajax" style="margin: 2px;"
                    height="93%"
                    width="98%"
                    heightDiff="-13"
                    fixedCellHeight="true"
                    selectRowButtonOnly="true"
                    checkbox="true"
                    params="{nodeKindId: 1}">
                <t:tool-button id="addHandler" clickFn="showAddDialog"/>
                <t:tool-button id="updateHandler" clickFn="showUpdateDialog"/>
                <t:tool-button id="deleteHandler" clickFn="deleteHandler"/>
                <t:tool-button id="saveSortIDHandler" clickFn="updateSequence"/>
                <t:tool-button id="showParamHandler" clickFn="showParamHandler" text="参数"/>
                <t:grid-column name="name" display="名称" type="string" width="200"/>
                <t:grid-column name="code" display="编码" type="string" width="200"/>
                <t:grid-column name="fullName" display="全路径" type="string" width="400" align="left"/>
                <t:grid-column name="kindIdTextView" display="服务类型" type="string" width="100" align="left"/>
                <t:grid-column name="uri" display="服务地址" type="string" width="300"/>
                <t:grid-column name="sequence" display="排序号" type="string" width="100" renderFn="sequenceRender"/>
            </t:grid>
        </t:box>
    </t:layout>
</div>
</body>
</html>
