var baseUrl = web_app.name + '/bpm/service';
var lastSelectedId;
var maingridManager;

function getTreeParam() {
    return {
        nodeKindId: 0
    }
}

function onClickTreeNode(data) {
    $("#layout").layout("setCenterTitle", "<span class='tomato-color'>[" + data.name + "]</span>服务列表");
    lastSelectedId = data.id;
    var params = $("#queryMainForm").formToJSON();
    params.parentId = lastSelectedId;
    UICtrl.gridSearch(maingridManager, params);
}

function checkLeafNode(data) {
    return data.hasChildren == 0;
}

function showAddDialog() {
    var node = $('#maintree').commonTree('getSelected');
    if (!node) {
        Public.errorTip('请选择左侧分类。');
        return;
    }
    UICtrl.showAjaxDialog({
        title: "添加服务",
        width: 400,
        url: baseUrl + '/forwardAdd.load',
        param: {parentId: node.id},
        ok: doSave,
        init: initServiceDetailsDialog
    });
}

/**
 * 初始化服务详情对话框。
 */
function initServiceDetailsDialog() {
    $('#uriSelector').val($('#uri').val());
    initUriSelector({kindId: $('#kindId').val()});
    $('#kindId').combox({
        'onChange': function (value) {
            initUriSelector({kindId: value.value})
        }
    })
}

/**
 * 初始化服务地址输入框。
 * @param op
 */
function initUriSelector(op) {
    switch (op.kindId) {
        case 'jms':
            initJmsSelector();
            break;
        case 'sap':
            initSapSelector();
            break;
    }
}

/**
 * 初始化JMS服务地址输入框
 */
function initJmsSelector() {
    $('#uriSelector').removeData('ui-combox')
        .removeClass('ui-combox-element')
        .show();
    $('#uriSelector_text').parent().remove();
    $('#uriSelector').change(function () {
        var uri = $(this).val();
        $('#uri').val(uri);
    });
}

/**
 * 初始化SAP服务地址输入框
 */
function initSapSelector() {
    $('#uriSelector').searchbox({
        type: 'webservice',
        name: 'sapWebServiceConfig',
        onChange: function (value, data) {
            $('#uri').val(data.code);
            $('#name').val(data.name);
            $('#code').val(data.code);
        }
    });
    if ($('#id')) {
        $('#uriSelector_text').val($('#uri').val());
    }
}

function doSave() {
    var _self = this;
    var id = $("#id").val();
    $('#submitForm').ajaxSubmit({
        url: baseUrl + (id ? '/updateById.ajax' : '/add.ajax'),
        success: function () {
            reloadGrid();
            _self.close();
        }
    });
}

function deleteHandler() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.confirm('您确定要删除选择的服务吗？',
        function () {
            Public.ajax(baseUrl + '/deleteById.ajax',
                {id: row.id},
                function (data) {
                    reloadGrid();
                });
        });
}

function showUpdateDialog() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.showAjaxDialog({
        title: "修改服务",
        param: {id: row.id},
        width: 400,
        url: baseUrl + '/forwardUpdate.load',
        ok: doSave,
        init: initServiceDetailsDialog
    });
}

function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(maingridManager, params);
}

function sequenceRender(item) {
    item.id = item.id; //只为了能够更新sequence
    return UICtrl.sequenceRender(item);
}

function updateSequence() {
    var action = "/bpm/service/updateSequence.ajax";
    DataUtil.updateSequence({
        action: action,
        idFieldName: "id",
        gridManager: maingridManager,
        onSuccess: reloadGrid
    });
}

function showParamHandler() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.showFrameDialog({
        url: 'bpm/serviceParam/forwardList.do?serviceId=' + row.id,
        title: "服务[" + row.name + "]参数",
        width: 920,
        height: 540,
    });
}