var baseUrl = web_app.name + '/bpm/serviceParam';
var lastSelectedId;
var maingridManager;


function showAddDialog() {
    UICtrl.showAjaxDialog({
        title: "添加服务参数",
        width: 400,
        url: baseUrl + '/forwardAdd.load',
        param: {serviceId: $('#serviceId').val()},
        ok: doSave
    });
}

function doSave() {
    var _self = this;
    var id = $("#id").val();
    $('#submitForm').ajaxSubmit({
        url: baseUrl + (id ? '/updateById.ajax' : '/add.ajax'),
        success: function () {
            reloadGrid();
            _self.close();
        }
    });
}

function deleteHandler() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.confirm('您确定要删除选择的服务参数吗？',
        function () {
            Public.ajax(baseUrl + '/deleteById.ajax',
                {id: row.id},
                function (data) {
                    reloadGrid();
                });
        });
}

function showUpdateDialog() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.showAjaxDialog({
        title: "修改服务参数",
        param: {id: row.id},
        width: 400,
        url: baseUrl + '/forwardUpdate.load',
        ok: doSave
    });
}

function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(maingridManager, params);
}


function getOutConverter() {
    return $('#outConverter').val();
}