function showAddProcVarDialog() {
    UICtrl.showAjaxDialog({
        title: "添加流程变量",
        width: 400,
        param: {procdefId: $('#procdefId').val()},
        url: web_app.name + '/bpm/procVar/forwardAddProcVar.load',
        ok: doSaveProcVar
    });
}

function doSaveProcVar() {
    var _self = this;
    var id = $("#id").val();
    $('#submitForm').ajaxSubmit({
        url: web_app.name + (id ? '/bpm/procVar/updateById.ajax' : '/bpm/procVar/addProcVar.ajax'),
        success: function () {
            reloadGrid();
            _self.close();
        }
    });
}

function deleteProcVar() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.confirm('您确定要删除选择的流程变量吗？',
        function () {
            Public.ajax(web_app.name + '/bpm/procVar/deleteById.ajax',
                {id: row.id},
                function (data) {
                    reloadGrid();
                });
        });
}

function showUpdateProcVarDialog() {
    var row = DataUtil.getSelectedRow(maingridManager);
    if (!row) {
        return;
    }
    UICtrl.showAjaxDialog({
        title: "修改流程变量",
        param: {id: row.id},
        width: 400,
        url: web_app.name + '/bpm/procVar/forwardUpdateProcVar.load',
        ok: doSaveProcVar
    });
}

function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(maingridManager, params);
}


function importVariableHandler() {
    UICtrl.showAjaxDialog({
       url: web_app.name + '/bpm/service/showParamList.load',
    });
}