<%@ page contentType="text/html; charset=utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib prefix="t" tagdir="/WEB-INF/tags" %>
<%
    String serverHost = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    String basePath = serverHost + request.getContextPath();
    request.setAttribute("basePath", basePath);
%>
<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=5,IE=9" ><![endif]-->
<!DOCTYPE html>
<html>
<head>
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <x:base include="layout,flexField,combox,grid,tree,attachment"/>
    <x:i18n name="messages,bpm" />
    <script type="text/javascript">
        var basePath = '${basePath}';
        var mxBasePath = basePath + '/system/tbpm/editor/mxClient';
        var STYLE_PATH = basePath + '/system/tbpm/editor/styles';
        var STENCIL_PATH = basePath + '/system/tbpm/editor/stencils';

        var urlParams = (function (url) {
            var result = new Object();
            var idx = url.lastIndexOf('?');

            if (idx > 0) {
                var params = url.substring(idx + 1).split('&');

                for (var i = 0; i < params.length; i++) {
                    idx = params[i].indexOf('=');

                    if (idx > 0) {
                        result[params[i].substring(0, idx)] = params[i].substring(idx + 1);
                    }
                }
            }

            return result;
        })(window.location.href);

        // Sets the base path, the UI language via URL param and configures the
        // supported languages to avoid 404s. The loading of all core language
        // resources is disabled as all required resources are in grapheditor.
        // properties. Note that in this example the loading of two resource
        // files (the special bundle and the default bundle) is disabled to
        // save a GET request. This requires that all resources be present in
        // each properties file since only one file is loaded.
        var mxLoadResources = false;
        var mxBasePath = basePath + '/system/tbpm/editor/mxClient';
    </script>
    <script type="text/javascript" src="${basePath}/system/tbpm/editor/sanitizer/sanitizer.min.js"></script>
    <script type="text/javascript" src="${basePath}/system/tbpm/editor/mxClient/js/mxClient.js"></script>
    <script type="text/javascript" src="${basePath}/system/tbpm/editor/js/Graph.js"></script>
    <script type="text/javascript" src="${basePath}/system/tbpm/editor/js/Shapes.js"></script>
    <script type="text/javascript" src="${basePath}/lib/underscore-min.js"></script>
</head>
<body>
<x:hidden name="id"/>
<x:hidden name="procdefId"/>
<textarea id="xml" hidden> <c:out value="${xml}"></c:out> </textarea>
<t:layout id="layout" rightWidth="3">
    <t:box position="center">
        <div class="geEditor">
            <div id="graph"></div>
        </div>
    </t:box>
    <t:box position="right" title="流程信息">
        <div id='infoTabs'>
            <div class="ui-tab-links">
                <ul>
                    <li id="propertyTab">属性</li>
                    <li id="businessActionTab">业务动作</li>
                    <li id="exeEfficiencyTab">执行情况</li>
                </ul>
            </div>
            <div class="ui-tab-content" style="border: 0; padding: 2px;">
                <div class="layout">
                    <div id="info"></div>
                </div>
                <div class="layout">
                    <div id="businessAction">
                    </div>
                </div>
                <div class="layout">
                    <div id="exeEfficiency">
                    </div>
                </div>
            </div>
        </div>
    </t:box>
</t:layout>
<script type="text/javascript" src="${basePath}/system/tbpm/editor/chart.js"></script>
<script type="text/javascript" src="${basePath}/system/tbpm/editor/viewer.js"></script>
</body>
</html>
