<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%
    String serverHost = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    String basePath = serverHost + request.getContextPath();
    request.setAttribute("basePath", basePath);
%>
<html>
<head>
    <x:base include="base"/>
    <link data-name="vs/editor/editor.main" rel="stylesheet"
          href="${basePath}/lib/monaco-editor/min/vs/editor/editor.main.css">
    <x:script src="/lib/jquery/jquery.base64.js"/>
    <x:script src="lib/monaco-editor/min/vs/loader.js"/>
    <script>var basePath = '${basePath}'</script>
    <x:script src="system/rule/ruleDetail.js"/>
</head>
<body>
<form class="hg-form" method="post" action="#" id="submitForm">
    <x:hidden name="id"/>
    <x:hidden name="folderId"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="code" required="true" label="规则编码" maxLength="64" fieldCol="4"/>
            <x:inputC name="name" required="true" label="规则名称" maxLength="128" fieldCol="4"/>
        </div>
        <div class="hg-form-row">
            <x:radioC dictionary="Status" name="status" value="1" label="状态" fieldCol="10"/>
        </div>
        <div class="hg-form-row">
            <x:textareaC name="remark" label="备注" maxLength="2000" rows="3" fieldCol="10"/>
        </div>
        <div class="blank_div clearfix"></div>
        <x:title title="规则内容" name="group"/>
        <x:hidden name="rules"/>
        <div class="hg-form-row">
            <div id="editor" style="float:left;width: 100%;height:600px;border: 1px solid grey; margin: 2px;"></div>
        </div>
    </div>
</form>
<div class="hg-form-row" style="text-align: right; padding: 5px 10px;">
    <button id="btn-save" class="btn btn-success">保存</button>
</div>
</body>
</html>
