﻿var gridManager = null, refreshFlag = false, parentId = "";
$(function () {
    bindEvent();
    initializeGrid();
    UICtrl.initDefaultLayout();
    $('#maintree').commonTree({
        kindId: CommonTreeKind.Rule,
        onClick: onFolderTreeNodeClick
    });
});

function bindEvent() {
}

function initializeGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addRule,
        updateHandler: updateHandler,
        deleteHandler: deleteHandler,
        enableHandler: enableHandler,
        disableHandler: disableHandler,
        moveHandler: moveHandler,
        deployToBpmEngine: {id: 'deployToBpmEngine', text: '部署到流程引擎', click: deployToBpmEngineHandler}
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "规则编码", name: "code", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "规则名称", name: "name", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "备注", name: "remark", width: 350, minWidth: 60, type: "string", align: "left"},
            {
                display: "状态", name: "status", width: "60", minWidth: 60, type: "string", align: "center",
                render: function (item) {
                    return UICtrl.getStatusInfo(item.status);
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + "/rule/slicedQueryRules.ajax",
        pageSize: 20,
        checkbox: true,
        width: "99.8%",
        height: '100%',
        heightDiff: -2,
        toolbar: toolbarOptions,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function onFolderTreeNodeClick(data, folderId) {
    var html = [];
    parentId = folderId;
    if (folderId == CommonTreeKind.Rule) {
        parentId = "";
        html.push('业务规则列表');
    } else {
        html.push('<span class="tomato-color">[', data.name, ']</span>业务规则列表');
    }
    $('#layout').layout('setCenterTitle', html.join(''));
    $('#treeParentId').val(folderId);
    if (gridManager) {
        UICtrl.gridSearch(gridManager, {folderId: parentId});
    }
}

function moveHandler() {
    UICtrl.showMoveTreeDialog({
        gridManager: gridManager, title: '移动业务规则', kindId: CommonTreeKind.Rule,
        save: function (parentId) {
            DataUtil.updateById({
                action: 'rule/moveRules.ajax',
                gridManager: gridManager, idFieldName: 'id', param: {folderId: parentId},
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
    });
}

function deployToBpmEngineHandler() {
    var ids = DataUtil.getSelectedIds({gridManager: gridManager});
    if (!ids) {
        return;
    }
    Public.ajax(web_app.name + '/rule/deployToBpmEngine.ajax', {ids: $.toJSON(ids)});
}

function query(obj) {
    var param = $(obj).formToJSON();
    if (!param) return;
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

/**
 * 新增第三方系统WEB SERVICE 配置
 */
function addRule() {
    if (!parentId) {
        Public.errorTip('请先选择左侧分类');
        return;
    }
    UICtrl.addTabItem({
        tabid: 'insertRule',
        text: '新增规则',
        url: web_app.name + '/rule/forwardInsertRule.do?folderId=' + parentId
    });
}

function updateHandler() {
    var row = DataUtil.getSelectedRow(gridManager);
    if (!row) {
        return;
    }

    UICtrl.addTabItem({
        tabid: 'updateRule',
        text: '修改规则',
        url: web_app.name + '/rule/forwardUpdateRule.do?code=' + row.code
    });
}


/**
 * 删除第三方系统WEB SERVICE 配置
 */
function deleteHandler() {
    DataUtil.del({
        action: 'rule/deleteRule.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

/**
 * 启用第三方系统WEB SERVICE 配置
 */
function enableHandler() {
    updateStatus('您确定要启用选中数据吗?', 1);
}

/**
 * 禁用第三方系统WEB SERVICE 配置
 */
function disableHandler() {
    updateStatus('您确定要禁用选中数据吗?', 0);
}

//修改状态
function updateStatus(message, status) {
    DataUtil.updateById({
        action: 'rule/updateRuleStatus.ajax',
        gridManager: gridManager, param: {status: status},
        message: message,
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function enableBtn() {
    var div = document.getElementById('btns');
    var btns = UE.dom.domUtils.getElementsByTagName(div, "button");
    for (var i = 0, btn; btn = btns[i++];) {
        UE.dom.domUtils.removeAttributes(btn, ["disabled"]);
    }
}

function disableBtn(str) {
    var div = document.getElementById('btns');
    var btns = UE.dom.domUtils.getElementsByTagName(div, "button");
    for (var i = 0, btn; btn = btns[i++];) {
        if (btn.id == str) {
            UE.dom.domUtils.removeAttributes(btn, ["disabled"]);
        } else {
            btn.setAttribute("disabled", "true");
        }
    }
}