var mdmBusinessTypeGridManager, folderId = null,data, fullId, id = $('#treeParentId').val(), refreshFlag = false;
$(document).ready(function () {
        initializeUI();
        initMdmBusinessTypeListGrid();
        initializeTree();
    }
);
function initializeTree() {
    $('#maintree').commonTree(
        {
            loadTreesAction: 'mdmBusinessType/queryBusinessType.ajax',
            idFieldName: 'id',
            parentId:'',
            isLeaf: function (data) {
                data.children = [];
                var flag=data.hasChildren==0;
                return flag;
            },
            onClick: function (data) {
                    onFolderTreeNodeClick(data,data.id);

            },

            IsShowMenu: false
        });
}


function initializeUI() {
    UICtrl.initDefaultLayout();
}

function onFolderTreeNodeClick(data, id) {

    folderId = data.id;
    fullId = data.fullId;
    var html = [];
    if (id == "") {
        html.push('请选择业务分类列表');
    } else {
        html.push('<span class="tomato-color"></span>行业分类列表');
    }
    $('#layout').layout('setCenterTitle', html.join(''));
    $('#treeParentId').val(data.id);
    if (mdmBusinessTypeGridManager) {
        UICtrl.gridSearch(mdmBusinessTypeGridManager, {id: data.id, parentId: folderId});
    }
}

function initMdmBusinessTypeListGrid() {
    var toolbarOptions = [];
    toolbarOptions = UICtrl.getDefaultToolbarOptions({
            addHandler: addHandler,
            updateHandler: updateHandler,
            deleteHandler: deleteHandler,
            enableHandler: enableHandler,
            disableHandler: disableHandler
        }
    );
    mdmBusinessTypeGridManager = UICtrl.grid('#mdmBusinessTypeGrid', {
            columns: [{display: "分类名称", name: "name", width: "24.0%", minWidth: "60", align: "center", type: "string"}
                , {display: "分类编码", name: "code", width: "24.0%", minWidth: "60", align: "center", type: "string"}
                , {display: "顺序号", name: "sequence", width: "24.0%", minWidth: "60", align: "center", type: "int"}
                , {
                    display: '启用状态', name: 'status', width: 60, minWidth: 60, align: "center",
                    render: function (item) {
                        return UICtrl.getStatusInfo(item.status);
                    }
                }
                , {display: "备注", name: "remark", width: "23.0%", minWidth: "60", align: "center", type: "string"}

            ],
            dataAction: 'server',
            url: web_app.name + '/mdmBusinessType/slicedQueryMdmBusinessType.ajax',
            parms: {id: folderId, type: 0},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            heightDiff: -4,
            sortName: 'id',
            sortOrder: 'asc',
            checkbox: true,
            usePager: true,
            rownumbers: false,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
        onBeforeShowData:function(){
            refreshTree();
        },
            onDblClickRow: function (data, rowindex, rowobj) {
                doShowUpdateDialog(data.id, data.parentId);
            },
            onLoadData: function () {
                return fullId ? true : false;
            }
        }
    );
    UICtrl.setSearchAreaToggle(mdmBusinessTypeGridManager, false);
}

//刷新Gird方法;
function reloadMdmBusinessTypeGrid() {
    var param = $("#queryMainForm").formToJSON();
    param = $.extend(param, {id: folderId});refreshTree();
    UICtrl.gridSearch(mdmBusinessTypeGridManager, {id: folderId,parentId: folderId});
}
//刷新树节点方法
function refreshTree() {
    var node = $('#maintree').commonTree('getSelected');
    if (node == null || (node != null && node.nodeType == 1)) {
        var g = $("#maintree").ligerGetTreeManager();
        $('#maintree').commonTree('refresh', node.id);
    }
}

function getId() {
    return $("#id").val() || "";
}

//增加方法
function addHandler() {
    if(folderId== null){
        Public.tip('请选择业务分类树。');
        return;
    }
    UICtrl.showAjaxDialog({
            title: "添加分类",
            param: {id: folderId},
            url: web_app.name + '/mdmBusinessType/ loadMdmBusinessTypeDetail.load',
            width: 800, height: 460,
            init: function () {
                initAddMdmBusinessType();
            },
            ok: doSaveMdmBusinessType,
            close: onDialogCloseHandler
        }
    );
}

function initAddMdmBusinessType() {
}

//保存方法 ;
function doSaveMdmBusinessType() {
    var _self = this;
    var id = getId();
    var url = '/mdmBusinessType/saveMdmBusinessType.ajax';
    $('#mdmBusinessTypeForm').ajaxSubmit({
            url: web_app.name + url, success: function (data) {
                reloadMdmBusinessTypeGrid();
                refreshFlag = true;
                _self.close();
            }
        }
    );
}

//跳转至修改方法
function updateHandler() {
    var row = UICtrl.checkSelectedRows(mdmBusinessTypeGridManager);
    if (row) {
        doShowUpdateDialog(row.id);
    }
}

//修改方法
function doShowUpdateDialog(id) {
    UICtrl.showAjaxDialog({
            title: "修改分类",
            url: web_app.name + '/mdmBusinessType/loadMdmBusinessTypeCurrentDetail.load',
            param: {id: id},
            width: 900,
            ok: doSaveMdmBusinessType,
            close: onDialogCloseHandler
        }
    );
}

//删除数据方法;
function deleteHandler() {
    var row = UICtrl.checkSelectedRows(mdmBusinessTypeGridManager);
    // var row = UICtrl.checkSelectedRows(mdmBusinessTypeGridManager);
    var action = "/mdmBusinessType/deleteMdmBusinessTypes.ajax";
    DataUtil.delSelectedRows({
           param: {id: row.id,fullId:row.fullId},
            action: action,
            idFieldName: 'id',
            gridManager: mdmBusinessTypeGridManager,
            onSuccess: reloadMdmBusinessTypeGrid
        }
    );
}

//查询方法;
function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(mdmBusinessTypeGridManager, param);
}

//重置表单;
function resetForm(obj) {
    $(obj).formClean();
}

function onDialogCloseHandler() {
    if (refreshFlag) {
        reloadMdmBusinessTypeGrid();
        refreshFlag = false;
    }
}

//启用
function enableHandler() {
    enableStatus('确实要启用选中数据吗?', 1);
}
//调用启动方法
function enableStatus(message, status) {
    var action = "/mdmBusinessType/enableMdmBusinessTypesStatus.ajax";
    DataUtil.updateById({
        action: action,
        gridManager: mdmBusinessTypeGridManager,
        param: {status: status},
        message: message,
        onSuccess: function () {
            reloadMdmBusinessTypeGrid();
        }
    });
}
//禁用
function disableHandler() {
    prohibitStatus('确实要禁用选中数据吗?', 0);
}
//启用禁用方法
function  prohibitStatus(message, status) {
    var action = "/mdmBusinessType/prohibitMdmBusinessTypesStatus.ajax";
    DataUtil.updateById({
        action: action,
        gridManager: mdmBusinessTypeGridManager,
        param: {status: status},
        message: message,
        onSuccess: function () {
            reloadMdmBusinessTypeGrid();
        }
    });
}

