var syfFormsGridManager = null, refreshFlag = false;
$(document).ready(function () {
    initUI();
    initsyfFormsListGrid();
});

function initUI() {
    UICtrl.initDefaultLayout();
}

function initsyfFormsListGrid() {
    var toolbarOptions = [];
    toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addFormHandler: {
            id: 'addForm', img: 'fa-plus', text: '添加表单', click: function () {
                addForm();
            }
        },

        editFormBasic: {
            id: 'editFormBasic', img: 'fa-edit', text: '编辑表单', click: function () {
                editFormBasic();
            }
        },
        deleteHandler: deleteHandler,
        setFormFunctions: {
            id: 'setFormFunctions', img: 'fa-cog', text: '功能配置', click: function () {
                setFormFunctions();
            }
        },
        setFormSetting: {
            id: 'setFormSetting', img: 'fa-table', text: '表单配置', click: function () {
                setFormSetting();
            }
        },
        procductMenu: {
            id: 'procductMenu', img: 'fa-play', text: '生成菜单', click: function () {
                procductMenu();
            }
        },
        procductCoder: {
            id: 'procductCoder', img: 'fa-random', text: '生成代码', click: function () {
                procductCoder();
            }
        },
        procductPage: {
            id: 'setFormPage', img: 'fa-gift', text: '表单发布', click: function () {
                procductPage();
            }
        }
    });

    syfFormsGridManager = UICtrl.grid('#syfFormsMainGrid', {
        columns: [
            {
                display: "表单编号", name: "formNo", width: 150, minWidth: "60", align: "left", type: "string"
            },
            {
                display: "表单名称", name: "formName", width: 180, minWidth: "60", align: "left", type: "string"
            },
            {
                display: "表名称", name: "tableName", width: 450, minWidth: "60", align: "left", type: "string"
                /*,render: function (item) {
                         var html=item.tableName;
                         if (item.id!=""){
                        html="<a href='#' class='GridStyle' onclick='editTableProperty(\"" + item.id +"\",\"" + item.tableName + "\",\"" + item.name+"\")'><font color=blue><u>"+item.tableName+"</u></font></a>";
                         }
                              return  html;
                      }	*/
            },
            {
                display: "数据保存方式",
                name: "saveModeTextView",
                width: "120",
                minWidth: "100",
                align: "center",
                type: "string"
            },

            // {display:"*JAVA文件包名",name:"packageName",width:150,minWidth:"60",align:"left",type:"string"},
            //  {display:"*页面文件路径",name:"formPath",width:120,minWidth:"60",align:"left",type:"string"},

            //{display:"表单编辑字段",name:"showfieldsEn",width:260,minWidth:"60",align:"left",type:"string"},
            {
                display: "操作", name: "showfieldsCh", width: "10%", minWidth: "60", align: "left", type: "string"
                , render: function (item) {
                    var html = item.tableName;
                    if (item.id != "") {
                        //  html="<a href='#' class='GridStyle' onclick='formDesign(\"" + item.id +"\",\"" + item.tableName + "\",\"" + item.formName+"\")'><font color=blue><u>表单设计</u></font></a>";
                        html = "<a href='#' class='GridStyle' onclick='formDesign(\"" + item.id + "\",\"" + item.formNo + "\",\"" + item.formName + "\")'><font color=blue><u>表单设计</u></font></a>";
                    }
                    return html;
                }
            },
            // {display:"显示控件/行",name:"pagedatailCols",width:90,minWidth:"60",align:"left",type:"string"},
            // {display:"字段标题占列",name:"labelCols",width:90,minWidth:"60",align:"left",type:"string"},
            // {display:"字段内容占列",name:"fieldCols",width:90,minWidth:"60",align:"left",type:"string"},
            /*  {display:"上传附件",name:"existAttachment",width:60,minWidth:"60",align:"left",type:"string",
                   render: function (item) {
                         if (item.existAttachment=="1"){
                              return "是";
                          } else {
                              return "否";
                          }
                       }
              },*/
            {display: "", name: "id", hide: true}
        ],
        dataAction: 'server',
        url: web_app.name + '/safFormslist/slicedQuerySyfForms.ajax',
        toolbar: toolbarOptions,
        width: '99.8%',
        height: '100%',
        heightDiff: -4,
        sortName: 'tableName',
        sortOrder: 'asc',
        checkbox: true,
        usePager: true,
        rownumbers: false,
        enabledEdit: false,
        fixedCellHeight: false,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doShowUpdateDialog(data.id);
        }
    });
    UICtrl.setSearchAreaToggle(syfFormsGridManager);
}

function reloadGrid() {
    syfFormsGridManager.loadData();
}

function getId() {
    return $("#id").val() || "";
}


function initAddSyfForms() {

}


//设置表的属性
function editTableProperty(id, tableName, name) {

    var _url = web_app.name + '/safFormslist/forwardTableProperty.do';
    _url += '?id=' + id + "&tableName=" + tableName + '&name=' + name;
    var title = '属性';
    top.addTabItem({text: '设置' + name + title, url: _url,});

}

//编辑表单基本信息
function editFormBasic() {
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    if (row) {
        doShowUpdateDialog(row.id);
    }
}

//添加表单功能按钮
function setFormFunctions() {
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    if (row) {
        UICtrl.showAjaxDialog({
            title: "添加功能",
            // param: {id: folderId},
            url: web_app.name + '/safFormslist/loadSyfFormsFunction.load?id=' + row.id,
            width: 800, height: 460,
            init: function () {
                // initAddMdmMetaData(folderId);
            },
            // ok: doSaveFormData,
            close: onDialogCloseHandler
        });
    } else {
        Public.tip('请选择一行数据！');
    }
}

//表单配置项设置
function setFormSetting() {
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    if (row) {
        UICtrl.showAjaxDialog({
            title: "添加表单" + row.formNo + "配置信息",
            // param: {id: folderId},
            url: web_app.name + '/safFormslist/loadSyfFormsSetting.load?id=' + row.id,
            width: 800, height: 460,
            init: function () {
                // initAddMdmMetaData(folderId);
            },
            // ok: doSaveFormData,
            close: onDialogCloseHandler
        });
    } else {
        Public.tip('请选择一行数据！');
    }
}

function doShowUpdateDialog(id) {
    UICtrl.showAjaxDialog({
        title: "修改自定义表单",
        url: web_app.name + '/safFormslist/loadSyfFormsDetail.load',
        param: {id: id},
        width: 980,
        ok: doSaveFormData,
        close: onDialogCloseHandler
    });
}

//添加业务表单
function addForm() {
    UICtrl.showAjaxDialog({
            title: "添加表单",
            // param: {id: folderId},
            url: web_app.name + '/safFormslist/loadSyfFormsDetail.load',
            width: 980, height: 460,
            init: function () {
                // initAddMdmMetaData(folderId);
            },
            ok: doSaveFormData,
            close: onDialogCloseHandler
        }
    );
}

//保存业务表单信息 及表信息
function doSaveFormData() {
    var rows = DataUtil.getGridData({gridManager: existfileclassGridManager, isAllData: true});
    var _self = this;
    var url = "/safFormslist/saveSafForms.ajax";
    $('#safFormsForm').ajaxSubmit({
        url: web_app.name + url,
        param: {detailData1: encodeURI($.toJSON(rows)), id: $("#id").val()},
        success: function () {
            // refreshFlag = true;
            // gridManager1.loadData();
            // refreshFlag = true;
            syfFormsGridManager.loadData();
            //_self.close();
        }
    });
}

//跳转表单设计 页面
function formDesign(id, formno, name) {
    var _url = web_app.name + "/formDesign/forwardFormMaking.do?formno=" + formno;
    //var _url = 'http://127.0.0.1:8080/index.html?formno=' + formno;
    // _url="http://www.baidu.com";
    //document.getElementById('frame_form_edit').src = _url;
    //alert(_url);
    //$('#form_edit').dialog('open');
    var _self = this;
    // top.addTabItem({ tabid: 'frm_index'+id, text: name+"-设计", url: _url });
    UICtrl.addTabItem({
        tabid: 'frm_index' + id, text: name + "-设计", url: _url, getURL: function (url) {
            return url;
        }
    });
    // window.open(_url,"_blank");
}

/// old 方法
function formDesign_old(id, tableName, name) {
    var _url = web_app.name + '/safFormslist/forwardEditSafForm.do?id=' + id;
    //document.getElementById('frame_form_edit').src = _url;
    //alert(_url);
    //$('#form_edit').dialog('open');
    var _self = this;
    top.addTabItem({tabid: 'frm_index' + id, text: name + "-设计", url: _url});

}

//删除表单;
function deleteHandler() {
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    // alert(row.id);
    var action = "/safFormslist/deleteSyfForms.ajax";
    DataUtil.delSelectedRows({
            action: action,
            idFieldName: 'id',
            gridManager: syfFormsGridManager,
            onSuccess: reloadGrid
        }
    );
}

//生成菜单
function procductMenu() {
    ///alert(1);
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    if (row) {
        // if (row.packageName==""||row.formPath==""){
        //	  Public.tip('请先设置表单的属性！');
        //  return false;
        // }

        Public.ajax(web_app.name + '/safFormslist/produceMenuList.ajax', {
            id: row.id, tableName: row.tableName
        }, function (data) {
            alert(data);
            // if (data==""){
            //  Public.tip('源代码生成成功!['+$("#uploadPath").val()+"]");
            //  } else {
            //	  Public.tip("错误："+data);
            //  }
        });
    } else {
        Public.tip('请选择一行数据！');
    }
}

//生成源代码
function procductCoder() {
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    if (row) {
        // if (row.packageName==""||row.formPath==""){
        //	  Public.tip('请先设置表单的属性！');
        //  return false;
        // }
        if (row.showfieldsEn == "") {
            Public.tip('请设置表单编辑字段！');
            return false;
        }
        Public.ajax(web_app.name + '/safFormslist/produceSourceCode.ajax', {
            id: row.id, tableName: row.tableName, formNo: row.formNo
        }, function (data) { //alert(data);
            if (data == "") {
                Public.tip('源代码生成成功![' + $("#uploadPath").val() + "]");
            } else {
                Public.tip("错误：" + data);
            }
        });
    } else {
        Public.tip('请选择一行数据！');
    }
}

//生成页面文件
function procductPage() {
    var row = UICtrl.checkSelectedRows(syfFormsGridManager);
    if (row) {
        // if (row.packageName==""||row.formPath==""){
        //	  Public.tip('请先设置表单的属性！');
        //  return false;
        // }

        Public.ajax(web_app.name + '/safFormslist/producePageFile.ajax', {
            id: row.id, tableName: row.tableName, formNo: row.formNo
        }, function (data) {
            alert("表单发布成功！");
        });
    } else {
        Public.tip('请选择一行数据！');
    }
}

//查询
function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(syfFormsGridManager, param);
}

//重置表单
function resetForm(obj) {
    $(obj).formClean();
}

function onDialogCloseHandler() {
    if (refreshFlag) {
        reloadGrid();
        refreshFlag = false;
    }
}

