<%@tag display-name="grid" pageEncoding="utf-8" description="数据表格" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ attribute name="id" required="true" type="java.lang.String" description="表格id" %>
<%@ attribute name="url" required="true" type="java.lang.String" rtexprvalue="true" description="请求url" %>
<%@ attribute name="sortName" type="java.lang.String" description="排序字段" %>
<%@ attribute name="sortOrder" type="java.lang.String" description="排序方式" %>
<%@ attribute name="width" type="java.lang.String" %>
<%@ attribute name="height" type="java.lang.String" %>
<%@ attribute name="heightDiff" type="java.lang.String" %>
<%@ attribute name="checkbox" type="java.lang.Boolean" %>
<%@ attribute name="fixedCellHeight" type="java.lang.Boolean" %>
<%@ attribute name="selectRowButtonOnly" type="java.lang.Boolean" %>
<%@ attribute name="params" type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="dataAction" type="java.lang.String" %>
<%@ attribute name="enabledEdit" type="java.lang.Boolean" %>
<%
    String serverHost = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    String basePath = serverHost + request.getContextPath();
%>
<%@ attribute name="style" type="java.lang.String" description="表格样式" %>
<script type="application/javascript">
    var ${id}Manager;
    var ${id}GridColumns = [];
    var ${id}GridToolbarOpts = {};
</script>
<jsp:doBody/>
<div id="${id}" style="${style}">
</div>
<script type="application/javascript">
    ${id}Manager = UICtrl.grid('#${id}', {
        url: /^https?:\/\/$/.test('${url}') ? '${url}' : ('<%=basePath%>' + '${url}'),
        dataAction: '${dataAction}' ? '${dataAction}' : 'server',
        columns: ${id}GridColumns,
        <c:if test="${params!=null}">
        parms: ${params},
        </c:if>
        sortName: '${sortName}',
        SortOrder: '${sortOrder}',
        toolbar: UICtrl.getDefaultToolbarOptions(${id}GridToolbarOpts),
        width: '${width}',
        height: '${height}',
        heightDiff: '${heightDiff}',
        <c:if test="${checkbox!=null}">
        checkbox: ${checkbox},
        </c:if>
        <c:if test="${fixedCellHeight!=null}">
        fixedCellHeight: ${fixedCellHeight},
        </c:if>
        <c:if test="${selectRowButtonOnly!=null}">
        selectRowButtonOnly: ${selectRowButtonOnly},
        </c:if>
        <c:if test="${enabledEdit!=null}">
        enabledEdit:${enabledEdit}
        </c:if>
    });
</script>