<%@tag pageEncoding="utf-8" body-content="empty" description="数据表格列列" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ tag import="javax.servlet.jsp.tagext.JspTag" %>
<%@ tag import="java.beans.PropertyDescriptor" %>
<%@ tag import="java.beans.Introspector" %>
<%@ tag import="java.lang.reflect.Method" %>
<%@ tag import="com.huigou.exception.ApplicationException" %>
<%@ attribute name="name" required="true" type="java.lang.String" description="字段名称" %>
<%@ attribute name="display" required="false" type="java.lang.String" description="显示名称" %>
<%@ attribute name="width" type="java.lang.String" description="字段宽度" %>
<%@ attribute name="minWidth" type="java.lang.String" description="字段最小宽度" %>
<%@ attribute name="type" type="java.lang.String" description="字段数据类型" %>
<%@ attribute name="align" type="java.lang.String" description="字段对齐方式" %>
<%@ attribute name="renderFn" type="java.lang.String" %>
<%@ attribute name="editorFn" %>
<%
    String gridId;
    JspTag parentTag = getParent();
    try {
        PropertyDescriptor[] pds = Introspector.getBeanInfo(parentTag.getClass()).getPropertyDescriptors();
        Method idReadMethod = null;
        for (PropertyDescriptor pd : pds) {
            if (pd.getName().equals("id")) {
                idReadMethod = pd.getReadMethod();
                break;
            }
        }
        gridId = (String) idReadMethod.invoke(parentTag);
    } catch (Exception e) {
        throw new ApplicationException("渲染标签 grid-column 出错", e);
    }
%>
<script type="application/javascript">
    <%=gridId%>GridColumns.push({
        name: '${name}',
        display: '${display}',
        width: '${width}',
        minWidth: '${minWidth}',
        type: '${type}',
        align: '${align}',
        <c:if test="${renderFn!=null}">
        render: ${renderFn},
        </c:if>
        <c:if test="${editorFn!=null}">
        editor: ${editorFn}.call()
        </c:if>
    })
</script>