package com.huigou.bpm.webservice.utils;

import com.huigou.bpm.webservice.call.sapclient.DestinationProvider;
import com.huigou.bpm.webservice.exception.SAPException;
import com.huigou.data.query.XMLParseUtil;
import com.huigou.exception.ApplicationException;
import com.sap.conn.jco.*;

import javax.xml.XMLConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SapJcoClient {

    private JCoParameterList inParm;
    private JCoParameterList outParm;
    private JCoParameterList tabParam;
    private JCoFunction function;

    private static JCoDestination getDestination() {
        try {
           return DestinationProvider.getDestination("SAP_CLIENT");
        } catch (JCoException e) {
            throw new SAPException("读取SAP连接参数，配置错误");
        }
    }

    public Map<String,Object> execCall(String functionName,Map<String,Object> inputData){
        JCoDestination destination;
        try {
            destination = getDestination();
// 取得要执行的方法
            function = destination.getRepository().getFunction(functionName);
        } catch (JCoException e) {
            throw new SAPException("SAP获取方法"+ functionName +"失败："+ e.getMessage());
        }
        if (function == null) {
            throw new SAPException(functionName +"方法不存在");
        }
        inParm = function.getImportParameterList();
        outParm = function.getExportParameterList();
        tabParam = function.getTableParameterList();
        if(inParm!=null){
            setParameterValue(inParm,inputData);
        }
        if(tabParam!=null){
            setParameterValue(tabParam,inputData);
        }

        try {
            function.execute(destination);
            Map<String,Object> result = new HashMap<String,Object>();
            result.putAll(SapJcoUtils.list2Map(inParm));
            result.putAll(SapJcoUtils.list2Map(outParm));
            result.putAll(SapJcoUtils.list2Map(tabParam));
            return result;
        } catch (JCoException e) {
            throw new SAPException("执行【"+functionName+"】方法失败");
        }
    }

    private void setParameterValue(JCoParameterList param,Map<String,Object> inputData){
        JCoFieldIterator iterator = param.getFieldIterator();
        while(iterator.hasNextField()){
            JCoField field = iterator.nextField();
            if(field.getValue() instanceof JCoStructure){
                JCoStructure structure = (JCoStructure) field.getValue();
                Object data = inputData.get(field.getName());
                if(data instanceof Map){
                    SapJcoUtils.fromMap(structure,(Map)data);
                }else{
                    throw new SAPException("参数【"+field.getName()+"】输入错误！");
                }
            }
            if(field.getValue() instanceof JCoTable){
                JCoTable table = (JCoTable) field.getValue();
                Object data = inputData.get(field.getName());
                if(data instanceof List){
                    SapJcoUtils.fromMap(table,(List)data);
                }else if(data instanceof Map){
                    SapJcoUtils.fromMap(table,(Map)data);
                }
            }
        }
    }
}
