package com.huigou.bpm.webservice.repository;

import com.huigou.bpm.webservice.domain.model.WebServiceConfigType;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface WebServiceConfigTypeRepository extends JpaRepository<WebServiceConfigType,String> {
    List<WebServiceConfigType> findWebServiceConfigTypeByStatus(Integer status);
    WebServiceConfigType findByCode(String code);

    /**
     * 检查Code是否重复
     * @param code
     * @param id
     * @return
     */
    Integer countByCodeAndIdIsNot(String code,String id);
}
