package com.huigou.bpm.webservice.domain.model;

import com.huigou.data.domain.model.BaseInfoAbstractEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 第三方系统WEB SERVICE 接口类型定义表
 */
@Setter
@Getter
@Entity
@Table(name = "TBPM_WEB_SERVICE_CONFIG_TYPE")
public class WebServiceConfigType extends BaseInfoAbstractEntity {

    private static final long serialVersionUID = -6361029926532804103L;

    /**
     * 第三方系统访问 Service 对象名称
     */
    @Column(name = "SYSTEM_SERVICE_CODE")
    private String systemServiceCode;
    /**
     * 接口方法名称
     */
    @Column(name = "SERVICE_METHOD")
    private String serviceMethod;
    /**
     * 接口参数名称
     */
    @Column(name = "SERVICE_PARAMTERS")
    private String serviceParamters;
    /**
     * 接口参数类型
     */
    @Column(name = "SERVICE_PARAM_TYPES")
    private String serviceParamTypes;
    /**
     * WEB SERVICE 接口类型定义备注
     */
    @Column(name = "REMARK")
    private String remark;
    /**
     * 是否启用规则验证
     */
    @Column(name="IS_ENABLE_RULE")
    private Integer isEnableRule;
    /**
     * 规则编号
     */
    @Column(name="RULE_CODE")
    private String ruleCode;
    /**
     * 规则名称
     */
    @Column(name="RULE_NAME")
    private String ruleName;
}
