package com.huigou.bpm.webservice.domain.model;

import com.huigou.data.domain.model.BaseInfoAbstractEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 第三方系统WEB SERVICE 接口配置表
 */
@Setter
@Getter
@Entity
@Table(name = "TBPM_OTHER_SYSTEM_CONFIG")
public class OtherSystemConfig extends BaseInfoAbstractEntity {

    private static final long serialVersionUID = -6361029926532804803L;

    /**
     * 第三方系统ID
     */
    @Column(name = "SYSTEM_ID")
    private String systemId;
    /**
     * 第三方系统访问 Service 类别(接口类型配置表CODE)
     */
    @Column(name = "SYSTEM_SERVICE_CATEGORY")
    private String systemServiceCategory;
    /**
     * 第三方系统访问 Service 类别名称(接口类型配置表NAME)
     */
    @Column(name = "SYSTEM_SERVICE_NAME")
    private String systemServiceName;
    /**
     * 是否启用规则验证
     */
    @Column(name="IS_ENABLE_RULE")
    private Integer isEnableRule;
    /**
     * 规则编号
     */
    @Column(name="RULE_CODE")
    private String ruleCode;
    /**
     * 规则名称
     */
    @Column(name="RULE_NAME")
    private String ruleName;
    /**
     * 第三方系统接口配置备注
     */
    @Column(name = "REMARK")
    private String remark;
}
