package com.huigou.bpm.webservice.controller;

import com.huigou.bpm.webservice.application.OtherSystemConfigApplication;
import com.huigou.bpm.webservice.application.WebServiceConfigTypeApplication;
import com.huigou.bpm.webservice.domain.model.OtherSystemConfig;
import com.huigou.bpm.webservice.domain.model.WebServiceConfigType;
import com.huigou.bpm.webservice.domain.query.OtherSystemConfigQueryRequest;
import com.huigou.bpm.webservice.domain.query.WebServiceConfigTypeQueryRequest;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.log.annotation.LogInfo;
import com.huigou.uasp.log.domain.model.LogType;
import com.huigou.uasp.log.domain.model.OperationType;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

@Controller
@ControllerMapping("webservice")
public class WebServiceController extends CommonController {

    @Override
    protected String getPagePath() {
        return "/system/webservice/";
    }

    @Autowired
    private OtherSystemConfigApplication otherSystemConfigApplication;
    @Autowired
    private WebServiceConfigTypeApplication webServiceConfigTypeApplication;

    /**
     * 跳转到第三方系统WEBSERVICE配置列表页面
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.LIST, description = "跳转到第三方系统WEBSERVICE配置列表页面")
    public String forwardWebServiceConfig() {
        return forward("webServiceConfig");
    }

    /**
     * 添加第三方系统WEBSERVICE配置详情页面
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "添加第三方系统WEBSERVICE配置详情页面")
    public String forwardInsertWebServiceConfig() {
        return forward("webServiceConfigDetail");
    }

    /**
     * 修改第三方系统WEBSERVICE配置详情页面
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.UPDATE, description = "修改第三方系统WEBSERVICE配置详情页面")
    public String forwardUpdateWebServiceConfig() {
        SDO sdo = this.getSDO();
        return forward("webServiceConfigDetail",sdo);
    }

    /**
     * 跳转到WEBSERVICE类型配置列表页面
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.LIST, description = "跳转到WEBSERVICE类型配置列表页面")
    public String forwardWebServiceConfigType() {
        return forward("webServiceConfigType");
    }

    /**
     * 添加到WEBSERVICE类型配置列表页面
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "添加到WEBSERVICE类型配置列表页面")
    public String forwardInsertWebServiceConfigTypeDetail() {
        return forward("webServiceConfigTypeDetail");
    }

    /**
     * 修改到WEBSERVICE类型配置详情页面
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.UPDATE, description = "修改到WEBSERVICE类型配置详情页面")
    public String forwardUpdateWebServiceConfigTypeDetail() {
        SDO sdo = this.getSDO();
        return forward("webServiceConfigTypeDetail",sdo);
    }

    /**
     * 分页查询WEBSERVICE配置列表
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.QUERY, description = "分页查询WEBSERVICE配置列表")
    public String findOtherSystemConfig(){
        SDO sdo = this.getSDO();
        OtherSystemConfigQueryRequest queryRequest = sdo.toQueryRequest(OtherSystemConfigQueryRequest.class);
        return toResult(otherSystemConfigApplication.slicedQueryOtherSystemConfig(queryRequest));
    }

    /**
     * 分页查询WEBSERVICE类型配置列表
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.QUERY, description = "分页查询WEBSERVICE类型配置列表")
    public String findWebServiceConfigType(){
        SDO sdo = this.getSDO();
        WebServiceConfigTypeQueryRequest queryRequest = sdo.toQueryRequest(WebServiceConfigTypeQueryRequest.class);
        return toResult(webServiceConfigTypeApplication.slicedQueryWebServiceConfigType(queryRequest));
    }

    /**
     * 保存第三方Web Service接口配置
     * @return
     */
    @LogInfo(logType = LogType.SYS,operaionType = OperationType.ADD,description = "保存第三方Web Service接口配置")
    public String saveOtherSystemConfig(){
        SDO sdo = this.getSDO();
        OtherSystemConfig config = sdo.toObject(OtherSystemConfig.class);
        otherSystemConfigApplication.saveOtherSystemConfig(config);
        return success();
    }

    /**
     * 保存第三方Web Service接口类型配置
     * @return
     */
    @LogInfo(logType = LogType.SYS,operaionType = OperationType.ADD,description = "保存Web Service接口类型配置")
    public String saveWebServiceType(){
        SDO sdo = this.getSDO();
        WebServiceConfigType configType = sdo.toObject(WebServiceConfigType.class);
        webServiceConfigTypeApplication.saveWebServiceConfigType(configType);
        return success();
    }

    /**
     * 修改Web Service接口类型配置状态
     * @return
     */
    @LogInfo(logType = LogType.SYS,operaionType = OperationType.ADD,description = "修改Web Service接口类型配置状态")
    public String updateWebServiceTypeStatus(){
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        Integer status = sdo.getInteger(CommonDomainConstants.STATUS_FIELD_NAME);
        webServiceConfigTypeApplication.updateWebServiceTypeStatus(ids,status);
        return success();
    }
    /**
     * 修改第三方Web Service接口配置状态
     * @return
     */
    @LogInfo(logType = LogType.SYS,operaionType = OperationType.ADD,description = "保存第三方Web Service接口配置状态")
    public String updateOtherSystemConfigStatus(){
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        Integer status = sdo.getInteger(CommonDomainConstants.STATUS_FIELD_NAME);
        otherSystemConfigApplication.updateOtherSystemConfigStatus(ids,status);
        return success();
    }

    /**
     * 删除Web Service接口类型配置
     * @return
     */
    @LogInfo(logType = LogType.SYS,operaionType = OperationType.ADD,description = "删除Web Service接口类型配置")
    public String deleteWebServiceType(){
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        webServiceConfigTypeApplication.deleteWebServiceType(ids);
        return success();
    }
    /**
     * 删除第三方Web Service接口配置
     * @return
     */
    @LogInfo(logType = LogType.SYS,operaionType = OperationType.ADD,description = "删除第三方Web Service接口配置")
    public String deleteOtherSystemConfig(){
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        otherSystemConfigApplication.deleteOtherSystemConfig(ids);
        return success();
    }
}
